
***

Read in a different language:

[ar عربى](README_AR.md) [zh-t 中國傳統的）](README_ZH-T.md)[**en-us**](README.md) [fr français](README_FR.md) [de Deutsch](README_DE.md) [ja 日本語](README_JA.md) [ko-south 韓國語](README_KO_SOUTH.md) [pl polski](README_PL.md) [ru русский](README_RU.md) [es en español](README_ES.md)

Translations in languages other than English are machine translated and are not yet accurate. No errors have been fixed yet as of February 5th 2021. Please report translation errors [here](https://github.com/seanpm2001/Why-you-should-stop-using-Chrome/issues/) make sure to backup your correction with sources and guide me, as I don't know languages other than English well (I plan on getting a translator eventually) please cite [wiktionary](https://en.wiktionary.org) and other sources in your report. Failing to do so will result in a rejection of the correction being published.

***

# What the FLoC

## Problems with Googles big FLoCing ad problem, and another major reason why you should stop using Google Chrome

![Google_Chrome_icon_(September_2014).svg](Google_Chrome_icon_(September_2014).svg)

This is an article on why you should stop using Google Chrome. I don't feel like anyone should be using Chrome in 2021, or want to use it, as every other modern web browser has succeeded Chrome on its many issues. [Chrome has become the new Internet Explorer 6](https://www.theverge.com/2018/1/4/16805216/google-chrome-only-sites-internet-explorer-6-web-standards). It is time for the next browser to take over. This article will help you make your choice (if you haven't already)

***

# Index

[01.0 - Memory usage](#Memory-usage)

[02.0 - Privacy](#Privacy)

[03.0 - ChromeBooks](#Chromebooks)

> [03.0.1 - For everyone](#For-everyone)

> [03.0.2 - For developers](#For-developers)

> [03.0.3 - BSD](#BSD)

[04.0 - Ad-blocking](#Ad-blocking)

[05.0 - AMP](#AMP)

[06.0 - Other things to check out](#Other-things-to-check-out)

[07.0 - Article info](#Article-info)

> [07.0.1 - Software status](#Software-status)

[08.0 - File history](#File-history)

[09.0 - Footer](#Footer)

***

## Memory usage

The Internet frequently makes the joke of Chrome using up tons of memory, sometimes referring to it as a black hole. Most jokes are exaggerated, this one is no exception, although memory usage on Chrome is **very bad**.

The Chrome browser uses an inefficient method where a separate instance of the browser is put into place for every tab. This adds ~190-250 megabytes of RAM to every tab. Along with this, the browser is very inefficient in page loading, which adds even more unnecessary RAM usage.

Switching to any other browser, even other chromium-based browsers will result in better memory usage. Notable other Chromium browsers include Microsoft Edge (2019 onward) Brave, and Vivaldi. I would prefer Firefox or a non-Chromium browser for privacy and control, mostly something that is completely open source.

With Firefox, I can have over 100 tabs open at once while using less than 4 gigabytes of RAM. In Chrome, this would take at least 16 gigabytes of RAM.

Chrome is also reported to be very bad with CPU usage compared to other browsers. Firefox uses very little CPU on Windows 10 and Ubuntu 20.04, but Chrome uses 4-6x more CPU on both platforms. Higher CPU usage will drain your battery life, and can easily cut your battery life in half, and is bad for the environment when done too much. On most devices, Chrome uses a minimum 60-75% of the CPU at all times, while Firefox uses a minimum of 1-13% of CPU at all times (based on common computers and intermediate computers under $2000.00)

Google no longer cares about the performance of Chrome, as of 2017, when they discontinued their last benchmarking software to test Chrome (Google Octane was discontinued in 2017) so the performance will just keep getting worse and worse with each update until users get upset (if enough do) then small changes will be made, and it will build back up to this again and keep repeating this pattern.

***

## Privacy

[G](https://en.wikipedia.org/wiki/Criticism_of_Google)[o](https://en.wikipedia.org/wiki/PRISM_(surveillance_program))[o](https://www.reddit.com/r/degoogle/)[g](https://www.wired.com/2012/06/opinion-google-is-evil/)[l](https://securitygladiators.com/chrome-privacy-bad/)[e](https://www.zdnet.com/article/goodbye-google-why-and-how-to-take-back-your-privacy/) [h](https://www.theguardian.com/commentisfree/2018/mar/28/all-the-data-facebook-google-has-on-you-privacy)[a](https://www.vox.com/recode/2020/2/21/21146998/google-new-mexico-children-privacy-school-chromebook-lawsuit)[s](https://www.eff.org/deeplinks/2019/08/dont-play-googles-privacy-sandbox-1) [a](https://money.cnn.com/2017/10/11/technology/google-home-mini-security-flaw/index.html) [v](https://www.huffpost.com/entry/why-googles-spying-on-use_b_3530296)[e](https://medium.com/digiprivacy/i-stopped-using-google-as-my-search-engine-heres-why-7a3a1b4fef81)[r](https://www.theguardian.com/technology/2019/nov/05/fitbit-google-acquisition-health-data)[y](https://www.computerworld.com/article/3128791/how-google-homes-always-on-will-affect-privacy.html) [v](https://protonmail.com/blog/google-privacy-problem/)[e](https://www.forbes.com/sites/gordonkelly/2020/02/23/google-chrome-80-upgrade-deep-linking-update-chrome-browser/)[r](https://www.wired.co.uk/article/duckduckgo-google-alternative-search-privacy)[y](https://en.wikipedia.org/wiki/Nothing_to_hide_argument#Criticism) [b](https://spreadprivacy.com/three-reasons-why-the-nothing-to-hide-argument-is-flawed/)[a](https://eduzaurus.com/free-essay-samples/nothing-to-hide-argument-has-nothing-to-say/)[d](https://www.cnet.com/how-to/google-collects-a-frightening-amount-of-data-about-you-you-can-find-and-delete-it-now/) [r](https://www.nbcnews.com/tech/tech-news/google-sells-future-powered-your-personal-data-n870501)[e](https://www.eff.org/deeplinks/2020/03/google-says-it-doesnt-sell-your-data-heres-how-company-shares-monetizes-and)[c](https://www.wired.com/story/google-tracks-you-privacy/)[o](https://www.theguardian.com/commentisfree/2018/mar/28/all-the-data-facebook-google-has-on-you-privacy)[r](https://www.dailymail.co.uk/sciencetech/article-5743829/Googles-vision-TOTAL-data-collection-revealed.html)[d](https://www.reuters.com/article/us-alphabet-google-privacy-lawsuit-idUSKBN23933H) [w](https://www.wired.com/story/health-fitness-data-privacy/)[h](https://www.pcmag.com/news/google-sued-over-kids-data-collection-on-education-chromebooks)[e](https://mashable.com/article/google-android-data-collection-study/)[n](https://www.engadget.com/australian-government-google-data-collection-lawsuit-182043643.html) [i](https://www.maketecheasier.com/studyandroid-data-google-ios-apple/)[t](https://www.washingtonpost.com/technology/2019/07/23/never-googlers-web-users-take-ultimate-step-guard-their-data/) [c](https://www.cnn.com/2019/11/12/business/google-project-nightingale-ascension/index.html)[o](https://en.wikipedia.org/wiki/2018_Google_data_breach)[m](https://moz.com/blog/where-does-google-draw-the-data-collection-line)[e](https://mashable.com/article/google-android-data-collection-study/)[s](https://eandt.theiet.org/content/articles/2020/06/google-sued-over-data-collection-from-users-in-incognito-mode/) [t](https://www.nytimes.com/2019/01/21/technology/google-europe-gdpr-fine.html)[o](https://www.bloomberg.com/news/articles/2017-11-30/google-sued-over-data-claims-on-behalf-of-5-million-iphone-users) [u](https://time.com/23782/google-flu-trends-big-data-problems/)[s](https://www.reuters.com/article/dataprivacy-googleyoutube-kidsdata-idUSL1N2J306W)[e](https://www.adweek.com/performance-marketing/google-is-collecting-your-data-even-when-your-phone-isnt-in-use/)[r](https://www.computerworld.com/article/2914838/project-fi-will-help-google-amass-even-more-data-about-you.html) [p](https://topclassactions.com/lawsuit-settlements/privacy/google-says-class-action-lawsuit-plaintiffs-consented-to-data-collection/)[r](https://arstechnica.com/information-technology/2014/01/what-google-can-really-do-with-nest-or-really-nests-data/)[i](https://www.cbsnews.com/news/google-education-spies-on-collects-data-on-millions-of-kids-alleges-lawsuit-new-mexico-attorney-general/)[v](https://www.nationalreview.com/2018/04/the-student-data-mining-scandal-under-our-noses/)[a](https://www.wired.com/insights/2012/10/google-opt-out/)[c](https://www.nytimes.com/2019/09/04/technology/google-youtube-fine-ftc.html)[y](https://medium.com/@hansdezwart/during-world-war-ii-we-did-have-something-to-hide-40689565c550)[.](https://medium.com/digitalprivacywise/why-you-should-stop-using-google-chrome-6c934c9a827c) (I could go on and on with evidence of this, but it took a long time to find and go through all these articles)

No matter what you do, when you are using Chrome, all of your sensitive personal data is being sent to Google and others. Google has also been spotted going through open programs. For example, from personal experience (on Firefox) with a YouTube tab open that I didn't visit, I watched several videos offline (VLC Media Player) Later when I went to check the recommendations, it was nearly everything that I had watched. There is no doubt they are spying on other programs too.

In Chrome (and many other browsers) an incognito mode is present. In Chrome, this mode is pointless, as Google will still mine your data. Even if you turn data mining/tracking off, and enable the "do not track" signal, surprise suprise, Google is still mining your data.

Using DuckDuckGo to protect your privacy on Chrome only helps for what you search, but Google will still mine your data, so it isn't as effective.

If you think you have nothing to hide, **you are absolutely wrong**. This argument has been debunked many times over:

[Via Wikipedia](https://en.wikipedia.org/wiki/Nothing_to_hide_argument#Criticism)

1. Edward Snowden remarked "Arguing that you don't care about the right to privacy because you have nothing to hide is no different than saying you don't care about free speech because you have nothing to say. "When you say, ‘I have nothing to hide,’ you’re saying, ‘I don’t care about this right.’ You’re saying, ‘I don’t have this right, because I’ve got to the point where I have to justify it.’ The way rights work is, the government has to justify its intrusion into your rights."

2. Daniel J. Solove stated in an article for The Chronicle of Higher Education that he opposes the argument; he stated that a government can leak information about a person and cause damage to that person, or use information about a person to deny access to services even if a person did not actually engage in wrongdoing, and that a government can cause damage to one's personal life through making errors. Solove wrote "When engaged directly, the nothing-to-hide argument can ensnare, for it forces the debate to focus on its narrow understanding of privacy. But when confronted with the plurality of privacy problems implicated by government data collection and use beyond surveillance and disclosure, the nothing-to-hide argument, in the end, has nothing to say."

3. Adam D. Moore, author of Privacy Rights: Moral and Legal Foundations, argued, "it is the view that rights are resistant to cost/benefit or consequentialist sort of arguments. Here we are rejecting the view that privacy interests are the sorts of things that can be traded for security." He also stated that surveillance can disproportionately affect certain groups in society based on appearance, ethnicity, sexuality, and religion.

4. Bruce Schneier, a computer security expert and cryptographer, expressed opposition, citing Cardinal Richelieu's statement "If one would give me six lines written by the hand of the most honest man, I would find something in them to have him hanged", referring to how a state government can find aspects in a person's life in order to prosecute or blackmail that individual. Schneier also argued "Too many wrongly characterize the debate as 'security versus privacy.' The real choice is liberty versus control."

5. Harvey A. Silverglate estimated that the common person, on average, unknowingly commits three felonies a day in the US.

6. Emilio Mordini, philosopher and psychoanalyst, argued that the "nothing to hide" argument is inherently paradoxical. People do not need to have "something to hide" in order to hide "something". What is hidden is not necessarily relevant, claims Mordini. Instead, he argues an intimate area which can be both hidden and access-restricted is necessary since, psychologically speaking, we become individuals through the discovery that we could hide something to others.

7. Julian Assange stated "There is no killer answer yet. Jacob Appelbaum (@ioerror) has a clever response, asking people who say this to then hand him their phone unlocked and pull down their pants. My version of that is to say, 'well, if you're so boring then we shouldn't be talking to you, and neither should anyone else', but philosophically, the real answer is this: Mass surveillance is a mass structural change. When society goes bad, it's going to take you with it, even if you are the blandest person on earth."

8. Ignacio Cofone, law professor, argues that the argument is mistaken in its own terms because, whenever people disclose relevant information to others, they also disclose irrelevant information. This irrelevant information has privacy costs and can lead to other harms, such as discrimination.

***

## Chromebooks

If you own your own Chromebook, you should delete ChromeOS and install another Linux distribution. Unlike most Android devices (*cough* Samsung *cough*) Chromebooks don't have to be rooted to install another system, and aren't locked down (*cough* Samsung *cough* *cough*). You should delete ChromeOS and flash another Linux distribution on it. It will make your Chromebook over 10000x more functional, and it will allow you to do things other than web browsing.

**WARNING:** it is **not legal** to delete the software off of public computers from schools, banks, hospitals, etc. Even if the software is really bad, **you can face severe punishments for modifying the software on devices that you don't own.** This is not limited to: suspension (rare, you would normally get expelled, not suspended) expulsion, jail time, prison time, felonies, and misdemeanors.

Here are some recommended Linux distributions for your Chromebook

### For everyone

Linux distributions that are highly functional and compatible with all computer users.

* Fedora Linux - A Red-hat based Linux distribution by Red Hat and Oracle, highly stable but less popular than Ubuntu. Still very easy to use and very stable. Not as limited as Ubuntu. Uses GNOME 3 desktop environment by default, but can be switched to KDE, and others. New releases every ~6 months. No long term support.

* Ubuntu - A Debian based Linux distribution by Canonical, currently the most popular desktop Linux distribution (over 45% marketshare) and the easiest for new users. Very stable, but somewhat limited. Comes default with the GNOME desktop environment, criticized for some proprietary parts, an incident in 2012 regarding Amazon being bundled, and snap packages. New releases every 6 months, new long term support releases every 2 years.

* Kubuntu - Ubuntu, but with a MUCH lighter desktop environment (uses KDE instead of GNOME)

* Lubuntu - Ubuntu, but with a lighter desktop environment (uses LXQt instead of GNOME)

* Pop!OS - A Ubuntu distribution that is highly favorable. Made by System76, and also uses the GNOME desktop environment)

* Other (list incomplete)

### For developers

Linux distributions that are extremely high functional, but require intermediate/advanced computer skills.

* Gentoo Linux - Requires a lot of compiling, very stable, but not the most popular (note: the low popularity doesn't make it bad)

* Manjaro Linux - Note: NOT ARCH based

* Arch Linux - Highly stable Linux distribution, just ignore the superiority complex of some users (mostly the ones that say "I use Arch btw")

* NixOS - For those who want to use Nix and NixOS packages. There are over 60000 packages for NixOS

* Other (list incomplete)

### BSD

BSD is a different open source system that isn't based on Linux. Although not as popular, it is still good.

If you are looking for BSD on a Chromebook, you might want to do more research. It might be harder to get BSD to work on a Chromebook.

Research these BSD distributions:

* FreeBSD

* OpenBSD

* NetBSD

***

## Ad Blocking

In 2019, Google Chrome was updated. This update (v?) removed the ability to easily install adblocking extensions. You may think that ads are necessary for a site, but an ad blocker can act as an anti-virus in some cases. Many common popular sites (such as w3schools, pornhub, etc.) have malicious ads that can install malware on your computer just by visiting the site. Having an adblocker can prevent these malicious ads from loading. 

With the block of ad blockers, you now can't get away from ads on Chrome, even the ones that can give your computer ransomware. 

***

## AMP

Google AMP (Originally Accelerated Mobile Pages) is a feature by Google that is killing the Internet. Any time you search with the Google search engine, you are going to an AMP site, which limits the revenue, viewcount, and other analytics for the sites you visit. Stop using AMP to support sites.

Google AMP is a modified version of the websites you are visiting that has Googles tracking embedded, and ads forced in. It is very unhealthy for the Internet.

***

## Other things to check out

[The Google Graveyard (killedbygoogle.com) - a sorted list of the 224+ products Google has killed](https://killedbygoogle.com/)

> [GitHub link](https://github.com/codyogden/killedbygoogle)

[Alphabet worker union - The new workers union at Google with over 800 members](https://alphabetworkersunion.org/people/our-union/)

[Don't want to part with the dinosaur easter egg? This website has you covered](https://chromedino.com/)

There are other alternates, just search for them.

***

## Article info

File type: `Markdown (*.md)`

File version: `3 (Friday, February 5th 2021 at 1:50 pm)`

Line count (including blank lines and compiler line): `289`

### Software status

All of my works are free from restrictions. DRM (**D**igital **R**estrictions **M**anagement) is not present in any of my works. This project does not contain any DRM

![DRM-free_label.en.svg](DRM-free_label.en.svg)

This sticker is supported by the Free Software Foundation. I never intend to include DRM in my works.

## File history

Version 1 (Wednesday, February 3rd 2021 at 4:40 pm)

> Changes:

> * Started the file/article

> * Added the title section

> * Referenced the Google Chrome icon

> * Added a section about memory usage

> * Added a section about privacy

> * Added a section about Chromebooks and ChromeOS

> * No other changes in version 1

Version 2 (Wednesday, February 3rd 2021 at 5:13 pm)

> Changes:

> * Added the ad blocking section

> * Added the AMP section

> * Added the article info section

> * Referenced the DRM Free icon

> * Added the file history section

> * Added the other things to check out section

> * Added the index

> * Added the footer

> * Updated the BSD section

> * No other changes in version 2

Version 3 (Friday, February 5th 2021 at 1:50 pm)

> Changes:

> * Added a link to the first 9 non-English translations of this article

> * Added a link to the Internet Explorer 6 claim

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 3

Version 4 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 4

Version 5 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 5

Version 6 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 6

***

## Footer

You have reached the end of this file!

### EOF

***

