
***

![DEGOOGLE1.jpeg](DEGOOGLE1.jpeg)

# Degoogling - Degoogle your life

This is the main degoogling article for general degoogling info and a link to the other articles.

[See the list as a GitHub organization](https://github.com/Degoogle-your-life)

***

_Read this article in a different language:_

**Current language is:** `English (US)` _(translations may need to be corrected to fix English replacing the correct language)_

_🌐 List of languages_

**Sorted by:** `A-Z`

[Sorting options unavailable](https://github.com/Degoogle-your-Life)

( [af Afrikaans](/.github/README_AF.md) Afrikaans | [sq Shqiptare](/.github/README_SQ.md) Albanian | [am አማርኛ](/.github/README_AM.md) Amharic | [ar عربى](/.github/README_AR.md) Arabic | [hy հայերեն](/.github/README_HY.md) Armenian | [az Azərbaycan dili](/.github/README_AZ.md) Azerbaijani | [eu Euskara](/.github/README_EU.md) Basque | [be Беларуская](/.github/README_BE.md) Belarusian | [bn বাংলা](/.github/README_BN.md) Bengali | [bs Bosanski](/.github/README_BS.md) Bosnian | [bg български](/.github/README_BG.md) Bulgarian | [ca Català](/.github/README_CA.md) Catalan | [ceb Sugbuanon](/.github/README_CEB.md) Cebuano | [ny Chichewa](/.github/README_NY.md) Chichewa | [zh-CN 简体中文](/.github/README_ZH-CN.md) Chinese (Simplified) | [zh-t 中國傳統的）](/.github/README_ZH-T.md) Chinese (Traditional) | [co Corsu](/.github/README_CO.md) Corsican | [hr Hrvatski](/.github/README_HR.md) Croatian | [cs čeština](/.github/README_CS.md) Czech | [da dansk](README_DA.md) Danish | [nl Nederlands](/.github/README_NL.md) Dutch | [**en-us English**](/.github/README.md) English |  [EO Esperanto](/.github/README_EO.md) Esperanto | [et Eestlane](/.github/README_ET.md) Estonian | [tl Pilipino](/.github/README_TL.md) Filipino | [fi Suomalainen](/.github/README_FI.md) Finnish |  [fr français](/.github/README_FR.md) French | [fy Frysk](/.github/README_FY.md) Frisian | [gl Galego](/.github/README_GL.md) Galician | [ka ქართველი](/.github/README_KA) Georgian | [de Deutsch](/.github/README_DE.md) German | [el Ελληνικά](/.github/README_EL.md) Greek | [gu ગુજરાતી](/.github/README_GU.md) Gujarati | [ht Kreyòl ayisyen](/.github/README_HT.md) Haitian Creole | [ha Hausa](/.github/README_HA.md) Hausa | [haw Ōlelo Hawaiʻi](/.github/README_HAW.md) Hawaiian | [he עִברִית](/.github/README_HE.md) Hebrew | [hi हिन्दी](/.github/README_HI.md) Hindi | [hmn Hmong](/.github/README_HMN.md) Hmong | [hu Magyar](/.github/README_HU.md) Hungarian | [is Íslenska](/.github/README_IS.md) Icelandic | [ig Igbo](/.github/README_IG.md) Igbo | [id bahasa Indonesia](/.github/README_ID.md) Icelandic | [ga Gaeilge](/.github/README_GA.md) Irish | [it Italiana/Italiano](/.github/README_IT.md) | [ja 日本語](/.github/README_JA.md) Japanese | [jw Wong jawa](/.github/README_JW.md) Javanese | [kn ಕನ್ನಡ](/.github/README_KN.md) Kannada | [kk Қазақ](/.github/README_KK.md) Kazakh | [km ខ្មែរ](/.github/README_KM.md) Khmer | [rw Kinyarwanda](/.github/README_RW.md) Kinyarwanda | [ko-south 韓國語](/.github/README_KO_SOUTH.md) Korean (South) | [ko-north 문화어](README_KO_NORTH.md) Korean (North) (NOT YET TRANSLATED) | [ku Kurdî](/.github/README_KU.md) Kurdish (Kurmanji) | [ky Кыргызча](/.github/README_KY.md) Kyrgyz | [lo ລາວ](/.github/README_LO.md) Lao | [la Latine](/.github/README_LA.md) Latin | [lt Lietuvis](/.github/README_LT.md) Lithuanian | [lb Lëtzebuergesch](/.github/README_LB.md) Luxembourgish | [mk Македонски](/.github/README_MK.md) Macedonian | [mg Malagasy](/.github/README_MG.md) Malagasy | [ms Bahasa Melayu](/.github/README_MS.md) Malay | [ml മലയാളം](/.github/README_ML.md) Malayalam | [mt Malti](/.github/README_MT.md) Maltese | [mi Maori](/.github/README_MI.md) Maori | [mr मराठी](/.github/README_MR.md) Marathi | [mn Монгол](/.github/README_MN.md) Mongolian | [my မြန်မာ](/.github/README_MY.md) Myanmar (Burmese) | [ne नेपाली](/.github/README_NE.md) Nepali | [no norsk](/.github/README_NO.md) Norwegian | [or ଓଡିଆ (ଓଡିଆ)](/.github/README_OR.md) Odia (Oriya) | [ps پښتو](/.github/README_PS.md) Pashto | [fa فارسی](/.github/README_FA.md) |Persian  [pl polski](/.github/README_PL.md) Polish | [pt português](/.github/README_PT.md) Portuguese | [pa ਪੰਜਾਬੀ](/.github/README_PA.md) Punjabi | No languages available that start with the letter Q | [ro Română](/.github/README_RO.md) Romanian | [ru русский](/.github/README_RU.md) Russian | [sm Faasamoa](/.github/README_SM.md) Samoan | [gd Gàidhlig na h-Alba](/.github/README_GD.md) Scots Gaelic | [sr Српски](/.github/README_SR.md) Serbian | [st Sesotho](/.github/README_ST.md) Sesotho | [sn Shona](/.github/README_SN.md) Shona | [sd سنڌي](/.github/README_SD.md) Sindhi | [si සිංහල](/.github/README_SI.md) Sinhala | [sk Slovák](/.github/README_SK.md) Slovak | [sl Slovenščina](/.github/README_SL.md) Slovenian | [so Soomaali](/.github/README_SO.md) Somali | [[es en español](/.github/README_ES.md) Spanish | [su Sundanis](/.github/README_SU.md) Sundanese | [sw Kiswahili](/.github/README_SW.md) Swahili | [sv Svenska](/.github/README_SV.md) Swedish | [tg Тоҷикӣ](/.github/README_TG.md) Tajik | [ta தமிழ்](/.github/README_TA.md) Tamil | [tt Татар](/.github/README_TT.md) Tatar | [te తెలుగు](/.github/README_TE.md) Telugu | [th ไทย](/.github/README_TH.md) Thai | [tr Türk](/.github/README_TR.md) Turkish | [tk Türkmenler](/.github/README_TK.md) Turkmen | [uk Український](/.github/README_UK.md) Ukrainian | [ur اردو](/.github/README_UR.md) Urdu | [ug ئۇيغۇر](/.github/README_UG.md) Uyghur | [uz O'zbek](/.github/README_UZ.md) Uzbek | [vi Tiếng Việt](/.github/README_VI.md) Vietnamese | [cy Cymraeg](/.github/README_CY.md) Welsh | [xh isiXhosa](/.github/README_XH.md) Xhosa | [yi יידיש](/.github/README_YI.md) Yiddish | [yo Yoruba](/.github/README_YO.md) Yoruba | [zu Zulu](/.github/README_ZU.md) Zulu ) Available in 110 languages (108 when not counting English and North Korean, as North Korean has not been translated yet [Read about it here](/OldVersions/Korean(North)/README.md))

Translations in languages other than English are machine translated and are not yet accurate. No errors have been fixed yet as of February 5th 2021. Please report translation errors [here](https://github.com/seanpm2001/Degoogle-your-life/issues/) make sure to backup your correction with sources and guide me, as I don't know languages other than English well (I plan on getting a translator eventually) please cite [wiktionary](https://en.wiktionary.org) and other sources in your report. Failing to do so will result in a rejection of the correction being published.

Note: due to limitations with GitHub's interpretation of markdown (and pretty much every other web-based interpretation of markdown) clicking these links will redirect you to a separate file on a separate page that isn't my GitHub profile page. You will be redirected to the [seanpm2001/seanpm2001 repository](https://github.com/seanpm2001/seanpm2001), where the README is hosted.

Translations are done with Google Translate due to limited or no support for the languages I need in other translation services like DeepL and Bing Translate (pretty ironic for an anti-Google campaign) I am working on finding an alternative. For some reason, the formatting (links, dividers, bolding, italics, etc.) is messed up in various translations. It is tedious to fix, and I do not know how to fix these issues in languages with non-latin characters, and right to left languages (like Arabic) extra help is needed in fixing these issues

Due to maintenance issues, many translations are out of date and are using an outdated version of this `README` article file. A translator is needed. Also, as of April 9th 2021, it is going to take me a while to get all the new links working.

***

## Index

[00.0 - Title](#Degoogling---Degoogle-your-life)

> [00.1 - Index](#Index)

[01.0 - Basic description](#Basic-description)

> [01.1 - Repository header](#Degoogle-your-life)

> [01.2 - Wuest3NFuchs description overview](#Overview-by-Wuest3nFuchs)

> > [01.2.1 - What does it mean?](#What-does-it-mean--by-Wuest3nFuchs)

> > [01.2.2 - Why Degoogle?](#Why-Degoogle--by-Wuest3nFuchs)

[02.0 - Articles](#Articles)

[03.0 - Privacy](#Privacy)

[04.0 - Other anti-Google campaigns](#Other-anti-Google-campaigns)

> [04.0.1 - Defunct](#Defunct)

> [04.0.2 - Ongoing](#Ongoing)

[05.0 - Countering other arguments](#Countering-other-arguments)

> [05.0.1 - Convenience](#Convenience)

> [05.0.2 - Why does it matter? It's too late anyways](#Why-does-it-matter,-its-too-late-anyways)

> [05.0.3 - Other](#Other)

[06.0 - Sources](#Sources)

[07.0 - Download links](#Download-links)

[08.0 - My degoogling experience](#My-degoogling-experience)

> [08.1 - What I switched from](#What-I-switched-from)

> [08.2 - Products I still can't get away from](#Products-I-still-cannot-get-away-from)

[09.0 - Other things to check out](#Other-things-to-check-out)

[10.0 - File info](#File-info)

> [10.1 - Software status](#Software-status)

> [10.2 - Sponsor info](#Sponsor-info)

[11.0 - File history](#File-history)

[12.0 - Footer](#Footer)

***

## Basic description

[From Wikipedia: Degoogle](https://en.wikipedia.org/wiki/DeGoogle)

The DeGoogle movement (also called the de-Google movement) is a grassroots campaign that has spawned as privacy activists urge users to stop using Google products entirely due to growing privacy concerns regarding the company. The term refers to the act of removing Google from one's life. As the growing market share of the internet giant creates monopolistic power for the company in digital spaces, increasing numbers of journalists have noted the difficulty to find alternatives to the company's products.

**History**

In 2013, John Koetsier of Venturebeat said Amazon's Kindle Fire Android-based tablet was "a de-Google-ized version of Android." In 2014 John Simpson of US News wrote about the “right to be forgotten” by Google and other search engines. In 2015, Derek Scally of Irish Times wrote an article on how to "De-Google your life." In 2016 Kris Carlon of Android Authority suggested that users of CyanogenMod 14 could “de-Google” their phones, because CyanogenMod works fine without Google apps too. In 2018 Nick Lucchesi of Inverse wrote about how ProtonMail was promoting how to "be able to completely de-Google-fy your life.” Lifehacker's Brendan Hesse wrote a detailed tutorial on "quitting Google." Gizmodo journalist Kashmir Hill claims that she missed meetings and had difficulties organizing meet ups without the use of Google Calendar. In 2019, Huawei gave a refund to phone owners in the Philippines who were inhibited from using services provided by Google because so few alternatives exist that the absence of the company's products made normal internet use unfeasible.

***

# Degoogle-your-life
A repository for general degoogling info and links to my other degoogling repositories.

***

## Overview by Wuest3nFuchs

A better description, provided by [Wuest3nFuchs](https://github.com/Wuest3nFuchs) - source: [Wuest3nFuchs/Degoogle](https://github.com/Wuest3nFuchs/Degoogle)

### What does it mean? by Wuest3nFuchs

Degoogling means to stop using anything that belongs to Google, anything that was made by Google. I'm talking about their search engine, their mail service (Gmail), Youtube, etc.

### Why Degoogle? by Wuest3nFuchs

Google is one of the most powerful companies in the world right now. They have stored a huge amount of information on all of us. Some would argue that our information is safe with them because they know how to protect it. But this isn't true. Google has been penetrated before and it will be penetrated in the future. Maybe not by some script kiddie but it will be done by a nation state. Google stores personal information on all of us because this is how they make money.

They scan our emails, store what we search when we're using their search engine, what videos we watch on Youtube. This is how they target us and build a profile on us to show us some ad based on what we talked about with our best friend so they can show us an ad for something we need, but this is too creepy. Thanks to Mr. Snowden we now know that Google has shared our personal information with NSA under a program called **"PRISM"**.


In the future someone will be capable of accessing all that information and I assure you something really bad is going to happen. To prevent that from happening, you should start Degoogling right now. Also you shouldn't use products by a company that shares your data with **NSA**. You should put a stop to all of this by degoogling.

**If other people can do it, you can do it too.**

[Read more here](https://github.com/Wuest3nFuchs/Degoogle)

<!-- A link to the fork is currently not listed, as I do not own this repository entirely, and want to promote other sources. It would be selfish to link to my own https://github.com/Degoogle-your-life/Degoogle !-->

***

## Articles

### Article status

_All articles are currently a work in progress and need massive improvements. Suggestions and fixes are allowed._

_As of April 18th 2021 at 4:09 pm, most articles haven't been started yet. I am working on finding time and effort to start them._

[Why you should stop using Google Chrome](https://github.com/seanpm2001/Why-you-should-stop-using-Chrome) <!-- 1 !-->

[Stop using ChromeBooks](https://github.com/seanpm2001/Stop-using-Chromebooks) <!-- 2 !-->

[Stop using WideVine DRM/It's time to cut WideVine DRM](https://github.com/seanpm2001/Its-time-to-cut-WideVine-DRM) <!-- 3 !-->

[Why you should stop using ReCaptcha](https://github.com/seanpm2001/Why-you-should-stop-using-ReCaptcha) <!-- 4 !-->

[Alternating from YouTube](https://github.com/seanpm2001/Alternating-from-YouTube) <!-- 5 !-->

[Stop Googling, why you should stop using Google Search](https://github.com/seanpm2001/Stop-Googling--Why-you-should-stop-using-Google-Search) <!-- 6 !-->

[Why you should stop using Gmail](https://github.com/seanpm2001/Why-you-should-stop-using-GMail) <!-- 7 !-->

[Why you should stop using Android](https://github.com/seanpm2001/Why-you-should-stop-using-Android) <!-- 8 !-->

[Why you should avoid Google Amp](https://github.com/seanpm2001/Why-you-should-avoid-Google-AMP) <!-- 9 !-->

[Why you should stop using Google Drive](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Drive) <!-- 10 !-->

[Why you should stop using Google Maps and Google Earth](https://github.com/seanpm2001/Why-you-should-stop-using-Google-maps-and-Google-Earth) <!-- 11 !-->

[Hey Google, stop](https://github.com/seanpm2001/Hey-Google-Stop) <!-- 12 !-->

[Stop reading from Google/Play books](https://github.com/seanpm2001/Stop-reading-from-Google-Books) <!-- 13 !-->

[Stop using Google Classroom](https://github.com/seanpm2001/Stop-using-Google-Classroom) <!-- 14 !-->

[Why you should stop using Google Translate](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Translate) <!-- 15 !-->

[Why you should stop using your Google Account(s)](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Accounts) <!-- 16 !-->

**New articles to be written soon:**

[Why you should stop using Gerrit](https://github.com/seanpm2001/Why-you-should-stop-using-Gerrit) <!-- 17 !-->

[Why you should stop using Google Analytics (the repository is broken on my end as of Wednesday, February 24th 2021 at 4:13 pm)](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Analytics) <!-- 18 !-->

<!-- Work divider !-->

[Why you should stop using Google AdSense](https://github.com/seanpm2001/Why-you-should-stop-using-Google-AdSense) <!-- 19 !-->

[Why you should stop using Google One](https://github.com/seanpm2001/Why-you-should-stop-using-Google-One) <!-- 20 !-->

[Why you should stop using Google+ (defunct)](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Plus) <!-- 21 !-->

[Why you should stop using the Google Play Store](https://github.com/seanpm2001/Why-you-should-stop-using-the-Google-Play-Store) <!-- 22 !-->

[Why you should stop using Google Docs](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Docs) <!-- 23 !-->

[Why you should stop using Google Slides](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Slides) <!-- 24 !-->

[Why you should stop using Google Sheets](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Sheets) <!-- 25 !-->

[Why you should stop using Google Forms](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Forms) <!-- 26 !-->

[Why you should stop using Google Cardboard](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Cardboard) <!-- 27 !-->

[Why you should stop using Google Messages](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Messages) <!-- 28 !-->

[Why you should stop using Google Material Design](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Material-Design) <!-- 29 !-->

[Why you should stop using Google Glass/Glasses](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Glass) <!-- 30 !-->

[Why you should stop using Google Fuchsia](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Fuchsia) <!-- 31 !-->

[Why you should stop using GBoard](https://github.com/seanpm2001/Why-you-should-stop-using-GBoard) <!-- 32 !-->

[Why you should stop using Google Home](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Home) <!-- 33 !-->

[Why you should stop using Google Nest](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Nest) <!-- 34 !-->

[Why you should stop using Google Hangouts (defunct)](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Hangouts) <!-- 35 !-->

[Why you should stop using Google Duo](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Duo) <!-- 36 !-->

[Why you should stop using Google Tensorflow](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Tensorflow) <!-- 37 !-->

[Why you should stop using Google Blockly](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Blockly) <!-- 38 !-->

[Why you should stop using Google Flutter](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Flutter) <!-- 39 !-->

[Why you should stop using Googles Go programming language](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Go) <!-- 40 !-->

[Why you should stop using Googles Dart programming language](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Dart) <!-- 41 !-->

[Why you should stop using Googles WebP image format](https://github.com/seanpm2001/Why-you-should-stop-using-Google-WebP) <!-- 42 !-->

[Why you should stop using Googles WebM video format](https://github.com/seanpm2001/Why-you-should-stop-using-Google-WebM) <!-- 43 !--> 

[Why you should stop using Google Video](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Video) <!-- 44 !-->

[Why you should stop using Google Sites (classic)](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Sites_Classic) <!-- 45 !-->

[Why you should stop using Google Sites ("New")](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Sites_New) <!-- 46 !-->

[Why you should stop using Google Pay](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Pay) <!-- 47 !-->

[Why you should stop using Android Pay](https://github.com/seanpm2001/Why-you-should-stop-using-Android-Pay) <!-- 48 !-->

[Why you should stop using Google VPN (oxymoron)](https://github.com/seanpm2001/Why-you-should-stop-using-Google-VPN) <!-- 49 !-->

[Why you should stop using Google Photos](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Photos) <!-- 50 !-->

[Why you should stop using Google Calendar](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Calendar) <!-- 51 !-->

[Why you should stop using VirusTotal (since it has been owned by Google since September 2012](https://github.com/seanpm2001/Why-you-should-stop-using-VirusTotal)  <!-- 52 !-->

[Why you should stop using Google Fi](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Fi) <!-- 53 !-->

[Why you should stop using Google Stadia](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Stadia) <!-- 54 !-->

[Why you should stop using Google Keep](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Keep) <!-- 55 !-->

[Why you should stop using Google Base](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Base) <!-- 56 !-->

[Why you should stop participating in the Google Summer of Code](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Summer-of-code) <!-- 57 !-->

[Why you should stop using Google Camera](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Camera) <!-- 58 !-->

[Why you should stop using Google Calculator (may seem extreme, but you should degoogle from everything, extremely easy to alternate from)](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Calculator) <!-- 59 !-->

[Why you should stop using Google Survey + rewards](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Survey-rewards) <!-- 60 !-->

[Why you should stop using Google Drawings](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Drawings) <!-- 61 !-->

[Why you should stop using Tenor (GIF site, owned by Google since 2019)](https://github.com/seanpm2001/Why-you-should-stop-using-Google-Tenor) <!-- 62 !-->

[What the FLoC - Why you should avoid Googles big FLoCing problem (stop using Google Chrome)](https://github.com/seanpm2001/What-the-FLoC) <!-- 63 !-->

**Total articles:** `63`

**Article [roadmap AB](DegoogleCampaign_2021Roadmap_Part1.md) (up to March 12th 2021) 2 days off** 

**Article [roadmap BB](DegoogleCampaign_2021Roadmao_Part2.md) (up to ? 2021) 2 days off**

Article status

All articles are currently a work in progress and need massive improvements. Suggestions and fixes are allowed.

**Forks**

Expanding my Degoogle network, and adding some ease of access, and community shoutouts.

1. [Fossapps](https://github.com/Degoogle-your-life/Fossapps) | Forked from: [https://github.com/wacko1805/Fossapps](https://github.com/wacko1805/Fossapps) (English)

2. [Privacy-links](https://github.com/Degoogle-your-life/Privacy-links) | Forked from: [https://github.com/Arturro43/privacy-links](https://github.com/Arturro43/privacy-links) (Polish)

3. [Delightful-Privacy](https://github.com/Degoogle-your-life/Delightful-Privacy) | Forked from: [https://github.com/LinuxCafeFederation/Delightful-Privacy](https://github.com/LinuxCafeFederation/Delightful-Privacy) (English)

4. [Blocklists](https://github.com/Degoogle-your-life/blocklists) | Forked from: [https://github.com/jmdugan/blocklists](https://github.com/jmdugan/blocklists) (English)

5. [Degoogle, by Wuest3nFuchs](https://github.com/Degoogle-your-life/Degoogle) | Forked from: [https://github.com/Wuest3nFuchs/Degoogle](https://github.com/Wuest3nFuchs/Degoogle) (English)

**Related**

[Degoogled Android phone Virtual Machine research](https://github.com/seanpm2001/Degoogled_Android_Phone_VM_Research)

**See also:**

[Criticism of Google at Wikipedia](https://en.wikipedia.org/wiki/Criticism_of_Google)

[The Google Graveyard (killedbygoogle.com) - a sorted list of the 224+ products Google has killed](https://killedbygoogle.com/)

> [GitHub link](https://github.com/codyogden/killedbygoogle)

[Alphabet worker union - The new workers union at Google with over 800 members](https://alphabetworkersunion.org/people/our-union/)

[Don't want to part with the dinosaur easter egg? This website has you covered](https://chromedino.com/)

***

## Privacy

[G](https://en.wikipedia.org/wiki/Criticism_of_Google)[o](https://en.wikipedia.org/wiki/PRISM_(surveillance_program))[o](https://www.reddit.com/r/degoogle/)[g](https://www.wired.com/2012/06/opinion-google-is-evil/)[l](https://securitygladiators.com/chrome-privacy-bad/)[e](https://www.zdnet.com/article/goodbye-google-why-and-how-to-take-back-your-privacy/) [h](https://www.theguardian.com/commentisfree/2018/mar/28/all-the-data-facebook-google-has-on-you-privacy)[a](https://www.vox.com/recode/2020/2/21/21146998/google-new-mexico-children-privacy-school-chromebook-lawsuit)[s](https://www.eff.org/deeplinks/2019/08/dont-play-googles-privacy-sandbox-1) [a](https://money.cnn.com/2017/10/11/technology/google-home-mini-security-flaw/index.html) [v](https://www.huffpost.com/entry/why-googles-spying-on-use_b_3530296)[e](https://medium.com/digiprivacy/i-stopped-using-google-as-my-search-engine-heres-why-7a3a1b4fef81)[r](https://www.theguardian.com/technology/2019/nov/05/fitbit-google-acquisition-health-data)[y](https://www.computerworld.com/article/3128791/how-google-homes-always-on-will-affect-privacy.html) [v](https://protonmail.com/blog/google-privacy-problem/)[e](https://www.forbes.com/sites/gordonkelly/2020/02/23/google-chrome-80-upgrade-deep-linking-update-chrome-browser/)[r](https://www.wired.co.uk/article/duckduckgo-google-alternative-search-privacy)[y](https://en.wikipedia.org/wiki/Nothing_to_hide_argument#Criticism) [b](https://spreadprivacy.com/three-reasons-why-the-nothing-to-hide-argument-is-flawed/)[a](https://eduzaurus.com/free-essay-samples/nothing-to-hide-argument-has-nothing-to-say/)[d](https://www.cnet.com/how-to/google-collects-a-frightening-amount-of-data-about-you-you-can-find-and-delete-it-now/) [r](https://www.nbcnews.com/tech/tech-news/google-sells-future-powered-your-personal-data-n870501)[e](https://www.eff.org/deeplinks/2020/03/google-says-it-doesnt-sell-your-data-heres-how-company-shares-monetizes-and)[c](https://www.wired.com/story/google-tracks-you-privacy/)[o](https://www.theguardian.com/commentisfree/2018/mar/28/all-the-data-facebook-google-has-on-you-privacy)[r](https://www.dailymail.co.uk/sciencetech/article-5743829/Googles-vision-TOTAL-data-collection-revealed.html)[d](https://www.reuters.com/article/us-alphabet-google-privacy-lawsuit-idUSKBN23933H) [w](https://www.wired.com/story/health-fitness-data-privacy/)[h](https://www.pcmag.com/news/google-sued-over-kids-data-collection-on-education-chromebooks)[e](https://mashable.com/article/google-android-data-collection-study/)[n](https://www.engadget.com/australian-government-google-data-collection-lawsuit-182043643.html) [i](https://www.maketecheasier.com/studyandroid-data-google-ios-apple/)[t](https://www.washingtonpost.com/technology/2019/07/23/never-googlers-web-users-take-ultimate-step-guard-their-data/) [c](https://www.cnn.com/2019/11/12/business/google-project-nightingale-ascension/index.html)[o](https://en.wikipedia.org/wiki/2018_Google_data_breach)[m](https://moz.com/blog/where-does-google-draw-the-data-collection-line)[e](https://mashable.com/article/google-android-data-collection-study/)[s](https://eandt.theiet.org/content/articles/2020/06/google-sued-over-data-collection-from-users-in-incognito-mode/) [t](https://www.nytimes.com/2019/01/21/technology/google-europe-gdpr-fine.html)[o](https://www.bloomberg.com/news/articles/2017-11-30/google-sued-over-data-claims-on-behalf-of-5-million-iphone-users) [u](https://time.com/23782/google-flu-trends-big-data-problems/)[s](https://www.reuters.com/article/dataprivacy-googleyoutube-kidsdata-idUSL1N2J306W)[e](https://www.adweek.com/performance-marketing/google-is-collecting-your-data-even-when-your-phone-isnt-in-use/)[r](https://www.computerworld.com/article/2914838/project-fi-will-help-google-amass-even-more-data-about-you.html) [p](https://topclassactions.com/lawsuit-settlements/privacy/google-says-class-action-lawsuit-plaintiffs-consented-to-data-collection/)[r](https://arstechnica.com/information-technology/2014/01/what-google-can-really-do-with-nest-or-really-nests-data/)[i](https://www.cbsnews.com/news/google-education-spies-on-collects-data-on-millions-of-kids-alleges-lawsuit-new-mexico-attorney-general/)[v](https://www.nationalreview.com/2018/04/the-student-data-mining-scandal-under-our-noses/)[a](https://www.wired.com/insights/2012/10/google-opt-out/)[c](https://www.nytimes.com/2019/09/04/technology/google-youtube-fine-ftc.html)[y](https://medium.com/@hansdezwart/during-world-war-ii-we-did-have-something-to-hide-40689565c550)[.](https://medium.com/digitalprivacywise/why-you-should-stop-using-google-chrome-6c934c9a827c) (I could go on and on with evidence of this, but it took a long time to find and go through all these articles)

Privacy on Google products is always bad, due to all Google products containing spyware.

No matter what you do, when you are using Google, all of your sensitive personal data is being sent to Google and others. Google has also been spotted going through open programs. For example, from personal experience (on Firefox) with a YouTube tab open that I didn't visit, I watched several videos offline (VLC Media Player) Later when I went to check the recommendations, it was nearly everything that I had watched. There is no doubt they are spying on other programs too.

In Chrome (and many other browsers) an incognito mode is present. In Chrome, this mode is pointless, as Google will still mine your data. Even if you turn data mining/tracking off, and enable the "do not track" signal, surprise suprise, Google is still mining your data.

If you think you have nothing to hide, **you are absolutely wrong**. This argument has been debunked many times over:

[Via Wikipedia](https://en.wikipedia.org/wiki/Nothing_to_hide_argument#Criticism)

1. Edward Snowden remarked "Arguing that you don't care about the right to privacy because you have nothing to hide is no different than saying you don't care about free speech because you have nothing to say. "When you say, ‘I have nothing to hide,’ you’re saying, ‘I don’t care about this right.’ You’re saying, ‘I don’t have this right, because I’ve got to the point where I have to justify it.’ The way rights work is, the government has to justify its intrusion into your rights."

2. Daniel J. Solove stated in an article for The Chronicle of Higher Education that he opposes the argument; he stated that a government can leak information about a person and cause damage to that person, or use information about a person to deny access to services even if a person did not actually engage in wrongdoing, and that a government can cause damage to one's personal life through making errors. Solove wrote "When engaged directly, the nothing-to-hide argument can ensnare, for it forces the debate to focus on its narrow understanding of privacy. But when confronted with the plurality of privacy problems implicated by government data collection and use beyond surveillance and disclosure, the nothing-to-hide argument, in the end, has nothing to say."

3. Adam D. Moore, author of Privacy Rights: Moral and Legal Foundations, argued, "it is the view that rights are resistant to cost/benefit or consequentialist sort of arguments. Here we are rejecting the view that privacy interests are the sorts of things that can be traded for security." He also stated that surveillance can disproportionately affect certain groups in society based on appearance, ethnicity, sexuality, and religion.

4. Bruce Schneier, a computer security expert and cryptographer, expressed opposition, citing Cardinal Richelieu's statement "If one would give me six lines written by the hand of the most honest man, I would find something in them to have him hanged", referring to how a state government can find aspects in a person's life in order to prosecute or blackmail that individual. Schneier also argued "Too many wrongly characterize the debate as 'security versus privacy.' The real choice is liberty versus control."

5. Harvey A. Silverglate estimated that the common person, on average, unknowingly commits three felonies a day in the US.

6. Emilio Mordini, philosopher and psychoanalyst, argued that the "nothing to hide" argument is inherently paradoxical. People do not need to have "something to hide" in order to hide "something". What is hidden is not necessarily relevant, claims Mordini. Instead, he argues an intimate area which can be both hidden and access-restricted is necessary since, psychologically speaking, we become individuals through the discovery that we could hide something to others.

7. Julian Assange stated "There is no killer answer yet. Jacob Appelbaum (@ioerror) has a clever response, asking people who say this to then hand him their phone unlocked and pull down their pants. My version of that is to say, 'well, if you're so boring then we shouldn't be talking to you, and neither should anyone else', but philosophically, the real answer is this: Mass surveillance is a mass structural change. When society goes bad, it's going to take you with it, even if you are the blandest person on earth."

8. Ignacio Cofone, law professor, argues that the argument is mistaken in its own terms because, whenever people disclose relevant information to others, they also disclose irrelevant information. This irrelevant information has privacy costs and can lead to other harms, such as discrimination.

***

## Other anti-Google campaigns

This is a list of other notable anti-Google campaigns. This list is incomplete. You can help by expanding it.

### Defunct

[Scroogled - By Microsoft (November 2012 to 2014)](https://en.wikipedia.org/wiki/Scroogled)

_No other entries at the moment._

### Ongoing

_This list is currently empty._

***

## Countering other arguments

There are some arguments people make to justify Google. One of the first major one is already debunked [here](#Privacy) but here are some other ones:

### Convenience

Yes, Google products seem convenient. However, you are trading everything good for convenience, including security, privacy, and reliability. Google has been getting lazier over the years, and their servers have gone down more and more. Right now, the Google servers go down for nearly an hour 1-2 times per month (most notably YouTube)

Unfortunately, due to societies reliance on Google, Google has come to dominate the Internet, and is seeking to control more and more. In 2012, when Google went down for 5 minutes, it was reported that **global** Internet traffic **dropped by 40%** Google frequently goes down for 1-2 hours, and with the [firing of their ethics team](https://techcrunch.com/2021/02/19/google-fires-top-ai-ethics-researcher-margaret-mitchell/) among other things, they are going to become less and less convenient.

Convenience isn't always a good thing. You should be aware of what is going on and be prepared for when they go down, as there isn't a way to have a server not go down every once in a while.

Google also isn't as convenient as you think. There are other much more convenient sites. Google is far from convenient, when you account their random account suspensions and terminations with no response (unless you draw enough attention to the Google twitter account or sue them for $100,000,000 or more) then they have taken advantage of you, screwed you over, and forced you to scream into a pillow, where no-one could hear your screams for help.

### Why does it matter, its too late anyways

This is a less common argument, but it needs explanation. With the current state, most world governments, along with several powerful corporations seem to know your every move, so why even bother to get away from it? The answer is simple: **you deserve better**. If you manage to get away from them at this point, it is harder for them to track your moves further, and you can build a new more private life.

[1 source](https://www.reddit.com/r/degoogle/comments/huk4rp/why_you_should_degoogle_intro_degoogling/) By the way, I have been giving my free Reddit award to this post every time I get it for over a week now (along with all 500 of my free coins) to boost this topic up further. So far, I have given this post over 14 free awards. It isn't much, but small things can make a big impact, depending on how it is perceived, and by whom.

### Other

I don't have any other arguments at the moment.

_This list is incomplete_

***

## Sources

Copy:

[G](https://en.wikipedia.org/wiki/Criticism_of_Google)[o](https://en.wikipedia.org/wiki/PRISM_(surveillance_program))[o](https://www.reddit.com/r/degoogle/)[g](https://www.wired.com/2012/06/opinion-google-is-evil/)[l](https://securitygladiators.com/chrome-privacy-bad/)[e](https://www.zdnet.com/article/goodbye-google-why-and-how-to-take-back-your-privacy/) [h](https://www.theguardian.com/commentisfree/2018/mar/28/all-the-data-facebook-google-has-on-you-privacy)[a](https://www.vox.com/recode/2020/2/21/21146998/google-new-mexico-children-privacy-school-chromebook-lawsuit)[s](https://www.eff.org/deeplinks/2019/08/dont-play-googles-privacy-sandbox-1) [a](https://money.cnn.com/2017/10/11/technology/google-home-mini-security-flaw/index.html) [v](https://www.huffpost.com/entry/why-googles-spying-on-use_b_3530296)[e](https://medium.com/digiprivacy/i-stopped-using-google-as-my-search-engine-heres-why-7a3a1b4fef81)[r](https://www.theguardian.com/technology/2019/nov/05/fitbit-google-acquisition-health-data)[y](https://www.computerworld.com/article/3128791/how-google-homes-always-on-will-affect-privacy.html) [v](https://protonmail.com/blog/google-privacy-problem/)[e](https://www.forbes.com/sites/gordonkelly/2020/02/23/google-chrome-80-upgrade-deep-linking-update-chrome-browser/)[r](https://www.wired.co.uk/article/duckduckgo-google-alternative-search-privacy)[y](https://en.wikipedia.org/wiki/Nothing_to_hide_argument#Criticism) [b](https://spreadprivacy.com/three-reasons-why-the-nothing-to-hide-argument-is-flawed/)[a](https://eduzaurus.com/free-essay-samples/nothing-to-hide-argument-has-nothing-to-say/)[d](https://www.cnet.com/how-to/google-collects-a-frightening-amount-of-data-about-you-you-can-find-and-delete-it-now/) [r](https://www.nbcnews.com/tech/tech-news/google-sells-future-powered-your-personal-data-n870501)[e](https://www.eff.org/deeplinks/2020/03/google-says-it-doesnt-sell-your-data-heres-how-company-shares-monetizes-and)[c](https://www.wired.com/story/google-tracks-you-privacy/)[o](https://www.theguardian.com/commentisfree/2018/mar/28/all-the-data-facebook-google-has-on-you-privacy)[r](https://www.dailymail.co.uk/sciencetech/article-5743829/Googles-vision-TOTAL-data-collection-revealed.html)[d](https://www.reuters.com/article/us-alphabet-google-privacy-lawsuit-idUSKBN23933H) [w](https://www.wired.com/story/health-fitness-data-privacy/)[h](https://www.pcmag.com/news/google-sued-over-kids-data-collection-on-education-chromebooks)[e](https://mashable.com/article/google-android-data-collection-study/)[n](https://www.engadget.com/australian-government-google-data-collection-lawsuit-182043643.html) [i](https://www.maketecheasier.com/studyandroid-data-google-ios-apple/)[t](https://www.washingtonpost.com/technology/2019/07/23/never-googlers-web-users-take-ultimate-step-guard-their-data/) [c](https://www.cnn.com/2019/11/12/business/google-project-nightingale-ascension/index.html)[o](https://en.wikipedia.org/wiki/2018_Google_data_breach)[m](https://moz.com/blog/where-does-google-draw-the-data-collection-line)[e](https://mashable.com/article/google-android-data-collection-study/)[s](https://eandt.theiet.org/content/articles/2020/06/google-sued-over-data-collection-from-users-in-incognito-mode/) [t](https://www.nytimes.com/2019/01/21/technology/google-europe-gdpr-fine.html)[o](https://www.bloomberg.com/news/articles/2017-11-30/google-sued-over-data-claims-on-behalf-of-5-million-iphone-users) [u](https://time.com/23782/google-flu-trends-big-data-problems/)[s](https://www.reuters.com/article/dataprivacy-googleyoutube-kidsdata-idUSL1N2J306W)[e](https://www.adweek.com/performance-marketing/google-is-collecting-your-data-even-when-your-phone-isnt-in-use/)[r](https://www.computerworld.com/article/2914838/project-fi-will-help-google-amass-even-more-data-about-you.html) [p](https://topclassactions.com/lawsuit-settlements/privacy/google-says-class-action-lawsuit-plaintiffs-consented-to-data-collection/)[r](https://arstechnica.com/information-technology/2014/01/what-google-can-really-do-with-nest-or-really-nests-data/)[i](https://www.cbsnews.com/news/google-education-spies-on-collects-data-on-millions-of-kids-alleges-lawsuit-new-mexico-attorney-general/)[v](https://www.nationalreview.com/2018/04/the-student-data-mining-scandal-under-our-noses/)[a](https://www.wired.com/insights/2012/10/google-opt-out/)[c](https://www.nytimes.com/2019/09/04/technology/google-youtube-fine-ftc.html)[y](https://medium.com/@hansdezwart/during-world-war-ii-we-did-have-something-to-hide-40689565c550)[.](https://medium.com/digitalprivacywise/why-you-should-stop-using-google-chrome-6c934c9a827c)

Other sources:

[Five eyes Alliance](https://en.wikipedia.org/wiki/Five_Eyes)[Nineteen eighty four](https://en.wikipedia.org/wiki/Nineteen_Eighty-Four)

***

## Download links

[Get Firefox](https://www.mozilla.org/en-US/firefox/new/)[Get Tor browser](https://www.torproject.org/download/)[Other/unavailable](https://www.example.com)

***

## My degoogling experience

I finally started to see the problems with big tech in 2018, and I began degoogling. In the first few months, I made significant progress. It slowed down immensely since then.


### What I switched from

Google Chrome -> Firefox/Tor

Google Search -> DuckDuckGo (default)/Ecosia (when I feel like it)/Bing (rarely)

GMail - ProtonMail (not yet fully switched)

Google Sites -> Self hosting (not yet fully switched)

Google+ -> Hardly ever used, deleted itself due to its own shutdown

Google Docs -> Never used, I just use Microsoft Word 2013 (before 2019) and LibreOffice (2019-onward) instead.

Google Sheets -> Never used, I just use Microsoft Excel 2013 (before 2019) and LibreOffice (2019-onward) instead.

Google Slides -> Never used, I just use Microsoft PowerPoint 2013 (before 2019) and LibreOffice (2019-onward) instead.

Google Drawings -> Never used, I just use LibreOffice (2019-onward) instead.

Gerrit -> Never ussed, I just use GitHub (current default), GitLab, BitBucket, and SourceForge instead.

Google Photos -> Never used

Google Drive -> OneDrive (2019-2020) Degoo (2020-2020) pCloud (2020-present)

Google Maps -> OpenStreetMaps/Apple Maps

Go - Making a special exception, but not using as a functional programming language

Dart - Making a special exception, but not using as a functional programming language

Flutter - Making a special exception, but not using as a functional programming language

Google Earth -> OpenStreetMaps/Apple Maps

Google Streetview -> Never used, I find it extra creepy

Google Fi -> Never used

Google Calendar -> Never used

Google calculator -> Literally any other calculator app, even a Linux terminal running in Python mode if I feel like it

Google Nest -> Never used

Google AMP -> Never used

Google VPN -> Never used, also an oxymoron

Google Pay -> Never used

Google Summer of Code -> Never participated

Tenor -> Other GIF sites, although GIFs aren't too important to me. I normally get GIF files from DuckDuckGo images, Imgur, Reddit, or other sites.

Blockly -> No longer used, not sure if Scratch directly ran blockly. I became a functional programmer in 2017 onward, and grew out of Scratch.

GBoard -> Used once, but abandoned

Google Glass -> Never used, considered as a young child but decided not to get one/use one if I had the option

_List may be incomplete._

### Products I still cannot get away from

As of February 25th 2021, these are the Google products that are keeping me from fully degoogling:

1. YouTube

2. Android

3. Google Play Store

4. GMail (only for school and some sites)

5. Google Classroom (only for school)

6. Google Translate

7. Google Account

8. Google Sites (as Google is violating the laws of the GDPR (and can face another €5,000,000.00 fine until they get it fixed) and forbidding downloads of this product)

I have degoogled from everything else.

***

## Go is evil

Google steamrolled over the 2003 Agent Based programming language `Go!` with their programming language `Go` (from 2009, 6 years later) and claimed that their language wouldn't affect the other language at all. Google was criticized heavily for this, as their `Don't be evil` motto was still active at the time, and this is one of the many incidents that got the don't be evil Motto retired.

In the end, development of `Go!` ceased, while `Go` became more and more common. Google claimed they wouldn't stramroll over `Go!` but in the end, they did, and they got away with it (as of April 9th 2021)

[Read more about Go and how to alternate here](https://github.com/Degoogle-your-life/Why-you-should-stop-using-Google-Go)

***

## Usage of DRM

Google uses DRM (Digital Restrictions Management) through their WideVine DRM "service" and other forms. The goal of DRM is to destroy the open Internet and give companies monopolistic power over users. You should get rid of WideVine completely, no matter the cost.

[Read more about WideVine and its problems here](https://github.com/Degoogle-your-life/Its-time-to-cut-WideVine-DRM)

***

## Common misconceptions

This is a list of some common misconceptions with Google products.

### Google is not the Internet

Google/Google search is not the Internet, Google search is just a search engine, kind of like how not every game for a Nintendo platform is made by Nintendo, but is licensed by Nintendo, but to a much greater extent. If all of Googles servers were to be simultaneously destroyed right now, only Google Sites like YouTube, Gmail, Google Docs, Google search, etc. would be gone, but the majority of the Internet would still be there (Wikipedia, Stackoverflow, GitHub, all of Microsofts websites, NYTimes, Samsung, TikTok, etc.) they may lose their Google sign-in and analytical functionality, but they would still be functional (unless they were poorly programmed and relied directly on Google)

***

## Internet Explorer 6 and Chrome

Google Chrome is becoming the new Internet Explorer 6. When Google Chrome originally came out, Firefox was the dominant browser, and had mostly killed off Internet Explorers marketshare (which surpassed 96% before millions of people switched to Firefox and other browsers) when Google Chrome came out, people switched due to its speed and it being by Google (which wasn't considered as evil at the time, as most privacy issues hadn't come to light yet) Google Chrome originally respected web standards (which is what Firefox did that killed off Internet Explorers 96% browser marketshare) however, as Google Chromes marketshare rose, Google began removing more and more features, adding more spyware, and stopped accepting web standards, Google Chrome has become the new Internet Explorer 6.

The major problem right now is websites that are Chrome only, and won't work on other browsers, as their developers decided they didn't want the other 30-40% of Internet users who don't use Chrome to use their site.

Even Google themselves is making their sites Chrome only. For example, Google search will prompt you to download Chrome 3 times every 10 seconds if it detects you are not using Google Chrome (even other Chromium-based browsers such as Brave are affected) and sites like Google Earth don't allow Firefox users to use their site (as of 2020) plus Google Translate does not support voice input on Firefox, and other non-Google Chrome browsers.

### The problem with Brave

Other browsers that are based on Chromium, such as Brave and Microsoft Edge aren't completely free of Google spyware. Brave is commonly recommended by the wrong side of the privacy community, but Brave is still a problem, as it uses Chromium. The Internet shouldn't consist of Chromium only browsers, there should be a variety of choice. Brave is the wrong way to go.

[Read more about degoogling from Google Chrome/Chromium here](https://github.com/Degoogle-your-life/Why-you-should-stop-using-Chrome)

[Read more about degoogling from ChromeOS/ChromiumOS (Chromebooks/Chromeboxes/Chromeblets/ChromeBits/ChromeETC) here](https://github.com/Degoogle-your-life/Stop-using-Chromebooks)

***

## Faux privacy renewal

Google has been trying to tell the world they care about privacy, after it was already too late. They continue to claim they respect user privacy, but they still aren't fixing all their privacy problems. 

### Open source cannot be partial

Open source can't be partial. Google is proof of this. Every bit and byte of the source code must be visible to the public, with not even an 8th of a byte hidden.

Projects like Android and ChromeOS are partially open source, but contain a majority of proprietary, spyware elements.

### Oxymoron

Google VPN is an oxymoron. Google does not care about privacy, and a Virtual Private Network (VPN) from a company like them would be one of the worst possible choices for a VPN service.

***

## Bad performance

Google does not care about the performance of their products as of at least 2017, as their last benchmarking software (Google Octane) was discontinued in 2017.

***

## Bad project management

Google has a very bad internal project management system. Some common examples of programs that have gotten more and more downgraded include Google Duo and YouTube music (formerly Google Play Music)

In Googles internal development system, 1 app leads to another app with half the functionality, then the original app gets deleted. A couple years later, a new app with 75% less functionality is made, and then the app with 50% functionality is removed, followed by a new app with 87.5% of the functionality being created, then the app with 75% functionality is discontinued, and so on.

***

## Horrible or no moderation of services

YouTube is the most common example in the world of bad moderation creating the worst platform in existence. Google also doesn't seem to get that YouTube isn't YouTube kids.

For YouTube, hateful pro-Nazi and White Supremacist content is served to users for the purpose of more engagement time and more money. Google also has done some very stupid things in their moderation, such as approving a Christian Anal Sex video as content `made for kids` while at the same time age restricting the video. It is also not too uncommon to see pornographic or gore ads being right under the Baby Shark video, along with various other `made for kids` content.

YouTube users complain extremely frequently about the poor moderation on YouTube for bad content (like the examples listed above) while users can get their videos deleted at random for no reason with no ability to repeal, along with users being punished for any form of swearing, even very minor cases like saying `crap` users commonly compare YouTube to the [Soviet Union](https://en.wikipedia.org/wiki/Soviet_Union) in the Stalin era, due to these unequal punishments.

In 2021, Google announced that they will put ads on all videos, despite the video being demonitized (so that Google makes money, but the creator doesn't) this doesn't relate to moderation too much, but it is important to note.

YouTube is moderated (albeit very poorly) but the Google ad service that makes them most of their money seems to have little to no moderation.

[Read more about YouTube moderation issues and how to alternate from YouTube](https://github.com/seanpm2001/Alternating-from-YouTube)

Advertisements for Google Play are generated from bot farms, you can tell by the same ad scenarios being used by hundreds of companies with little changes, and no relation to the product (common examples: Playrix (Homescapes, Gardenscapes) Fishdom, Mafia City, and thousands more) along with a booming malicious trend of ads claiming that users can earn money by playing games, listening to music, etc. PayPal hasn't commented on this, but it is obvious that this is a scam, as if you could make over $10,000 in less than 20 seconds by playing a game guaranteed, nobody would be doing work and would be doing this instead, which is impossible, and a business could not work like this. This obvious scam has been growing strong since 2019, and now the bot farms that produce these ads are fighting with each other in their own ads.

Several advertisements are also very lewd, and attempt to get users (majority of them being users under the age of 13, or bots) to click through sexual manipulation.

Many apps use bots and astroturf their products, so whenever a bad review is made, sock puppet bot accounts will start posting 5 star reviews and attempt to negate your criticism. [Google is doing this themselves as well](#Astroturfing)

[Read more about issues with Google AdSense](https://github.com/Degoogle-your-life/Why-you-should-stop-using-Google-AdSense)

***

## Astroturfing

General definition [(from Wikipedia)](https://en.wikipedia.org/wiki/Astroturfing)

```
Astroturfing is the practice of masking the sponsors of a message or organization (e.g., political, advertising, religious or public relations) to make it appear as though it originates from and is supported by grassroots participants. It is a practice intended to give the statements or organizations credibility by withholding information about the source's financial connection. The term astroturfing is derived from AstroTurf, a brand of synthetic carpeting designed to resemble natural grass, as a play on the word "grassroots". The implication behind the use of the term is that instead of a "true" or "natural" grassroots effort behind the activity in question, there is a "fake" or "artificial" appearance of support.
```

Google has a history of astroturfing to make it seem like they aren't doing anything evil (in the process, astroturfing is evil) for example, posting critism of Google on a platform like Twitter (which they have an account on) will result in several accounts that have existed for a while but never posted before coming out and claiming that what you said is false, and then claiming that Google is the best company, but done in a way that it may not be obvious that these are bots to most people.

***

## Illegal and unethical business practices

Google uses illegal and unethical business practices to further their monopoly, such as using tax havens, outsourcing jobs, and continuing to do illegal invasive activities as a cost of doing business.

### In Europe

Europe has frequently sued Google, the biggest lawsuit being against illegal behavior in Android, which resulted in Google receiving a €5,000,000,000 (equivalent to $5,947,083,703.68 in April 9th 2021 money)

### In North America

The United States has not given nearly enough of a fine to Google yet, compared to Europes €5,000,000,000 fine.

### Controversies

Google doesn't care about a problem until it creates a controversy, then they will make a poor attempt to fix it, just enough for the controversy to temporarily go away, and the problem then gets exponentially worse until it creates another controversy, and the cycle continues. They simply don't care enough to do anything serious about it.

***

## Google is automated

As a company, Google is mostly automated, with less moderation than automation.

A company should not be fully automated. Google is an example of this. Moderation is horrible when done only by AI, YouTube is a good example, even with the extra few (hundreds, or maybe a thousand) people moderating the site, where it is apparently so bad that most of them have to get therapy while working.

***

## Android

Android is owned by Google. Part of the Open Handset Alliance (which hasn't been open since Android) Android has become another monopoly point for Google, and a very hard one to escape.

Android has been reported to phone home to Google at least 10 times per day, and despite being partially open source, it still acts heavily as spyware. 

Several projects have been created to alternate from Android, but require rooting your device. This simply isn't possible anymore for specific Samsung phones in the US, due to the Knox DRM. Common alternates to Android include iOS, iPadOS, LineageOS, Android x86, Ubuntu Touch, and PiPhone (Pi Phone is a brand of phones that run various Linux systems on a mobile device, such as Fedora, Ubuntu, Arch, etc.)

[See my research on getting a degoogled Android virtual machine functional](https://github.com/Degoogle-your-life/Degoogled_Android_Phone_VM_Research)

[See how to degoogle from Android](https://github.com/Degoogle-your-life/Why-you-should-stop-using-Android)

***

## Small actions to help

Spreading awareness in every way you can is important. For me, I not only frequently talk about degoogling, and write articles, but I also have a small little habit, where I give my daily free Reddit award to the pinned post on r/degoogle to raise awareness. So far, I have given nearly 30 awards to the pinned post (I also spent 500 of my free coins on 10 awards for that post)

***

## Untrustable

Google cannot be trusted, and can never be trusted ever again. They have completely gone from "don't be evil" (they were always evil) to just being completely evil and not trying to hide it.

***

## Other things to check out

[The Google Graveyard (killedbygoogle.com) - a sorted list of the 224+ products Google has killed](https://killedbygoogle.com/)

> [GitHub link](https://github.com/codyogden/killedbygoogle)

[Alphabet worker union - The new workers union at Google with over 800 members](https://alphabetworkersunion.org/people/our-union/)

[Don't want to part with the dinosaur easter egg? This website has you covered](https://chromedino.com/)

There are other alternates, just search for them.

***

Some fact checking is needed for this article

***

## File info

File type: `Markdown (*.md)`

Line count (including blank lines and compiler line): `968`

File version: `6 (Sunday, April 18th 2021 at 4:18 pm)`

***

### Software status

All of my works are free some restrictions. DRM (**D**igital **R**estrictions **M**anagement) is not present in any of my works.

![DRM-free_label.en.svg](DRM-free_label.en.svg)

This sticker is supported by the Free Software Foundation. I never intend to include DRM in my works.

I am using the abbreviation "Digital Restrictions Management" instead of the more known "Digital Rights Management" as the common way of addressing it is false, there are no rights with DRM. The spelling "Digital Restrictions Management" is more accurate, and is supported by [Richard M. Stallman (RMS)](https://en.wikipedia.org/wiki/Richard_Stallman) and the [Free Software Foundation (FSF)](https://en.wikipedia.org/wiki/Free_Software_Foundation)

This section is used to raise awareness for the problems with DRM, and also to protest it. DRM is defective by design and is a major threat to all computer users and software freedom.

Image credit: [defectivebydesign.org/drm-free/...](https://www.defectivebydesign.org/drm-free/how-to-use-label)

***

## Sponsor info

![SponsorButton.png](SponsorButton.png) <-- Don't click this button, it doesn't work, it is just an image. The real button is at the top of the page in the right (<- L **R** ->) corner

You can sponsor this project if you like, but please specify what you want to donate to. [See the funds you can donate to here](https://github.com/seanpm2001/Sponsor-info/tree/main/For-sponsors)

You can view other sponsor info [here](https://github.com/seanpm2001/Sponsor-info/)

Try it out! The sponsor button is right up next to the watch/unwatch button.

***

## File history



 * Started the file

> * Added the title section

> * Added the index

> * Added the about section

> * Added the Wiki section

> * Added the version history section

> * Added the issues section.

> * Added the past issues section

> * Added the past pull requests section

> * Added the active pull requests section

> * Added the contributors section

> * Added the contributing section

> * Added the about README section

> * Added the README version history section

> * Added the resources section

> * Added a software status section, with a DRM free sticker and message

> * Added the sponsor info section

> * No other changes in version 0.1

Version 1 (Friday, February 19th 2021 at 5:20 pm)

> Changes:

> * Started the file

> * Added the basic description section

> * Added the repository description section

> * Added the articles list, with 14 entries

> > * Added a `related articles` section

> > * Added a `see also` section

> * Added the file info section

> * Added the file history section

> * Added the footer

> * No other changes in version 1

Version 2 (Friday, February 19th 2021 at 5:26 pm)

> Changes:

> * Added the translation status section

> * Added the Other things to check out section

> * Added the privacy section

> * Added an index

> * Added the software status subsection

> * Added the other anti-Google campaigns section

> > * Added the defunct subsection

> > * Added the ongoing subsection

> * Added the sources section

> * Added the download links section

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 2

Version 3 (Wednesday, February 24th 2021 at 7:56 pm)

> Changes:

> * Updated the index

> * Referenced the degoogle icon and the new GitHub organization

> * Added links to newer articles

> * Added the countering other arguments section

> > * Added the convenience subsection

> > * Added the Why even bother subsection

> > * Added the other subsection

> * Updated some data

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 3

Version 4 (Thurday, February 25th 2021 at 9:31 pm)

> Changes:

> * Added links to 10 new articles

> * Added a section about my experience degoogling

> * Updated the index

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 4

Version 5 (Friday, April 9th 2021 at 6:02 pm)

_There has been a lack of updates to the anti-Google movement from me lately, I am working on getting back to it after a 1+ month hiatus._

> Changes:

> * Updated the title section

> * Updated the index

> * Updated the language list: fixed links, and added more supported languages

> * Updated the article status section, adding 4 fork links

> * Updated the software status section

> * Added the Go is evil section

> * Added the Usage of DRM section

> * Added the Common misconceptions section

> > * Added the Google is not the Internet subsection

> * Added the Internet Explorer 6 and Chrome section

> > * Added the The problem with Brave subsection

> * Added the Faux privacy removal

> * Added the Open source cannot be partial subsection

> * Added the Oxymoron subsection

> * Added the Bad performance section

> * Added the Bad project management section

> * Added the Horrible or no moderation of services section

> * Added the Astroturfing section

> * Added the Illegal and unethical business practices section

> * Added the In Europe subsection

> > * Added the In North America subsection

> > * Added the Controversies subsection
	
> * Added the Google is automated section

> * Added the Android section

> * Added the Small actions to help section

> * Added the Untrustable section

> * Added the sponsor info section

> * Updated the footer

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 5

Version 6 (Sunday, April 18th 2021 at 4:18 pm)

> Changes:

> * Updated the index

> * Added a new overview description

> * Updated article status info

> * Added a link to the new Google FLoC article

> * Added a link to Wuest 3n Fuchs Degoogle article and general info on it

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 6

Version 7 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 7

Version 8 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 8

Version 9 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 9

Version 10 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 10

Version 11 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 11

Version 12 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 12

***

## Footer

You have reached the end of this file

( [Back to top](#Top) | [Return to GitHub](https://github.com) ) 

### EOF

***

