
***

# Contributing

> **Make sure to always follow the latest version of the CONTRIBUTING.md file**

Contributions to the SNU Keyboard project are allowed, as long as you follow these contributing guidelines:

> * Keep it professional

> Please refrain from using swearing, using slurs, or other bad words when committing

> * Do not modify snapshot files

> Snapshot files serve as an archive of old versions of pages. Do not edit or delete these files

> * Create snapshot files after each verified commit

> You have to create archives of your work after each commit to a file. For snapshots, just copy and paste the file you edited with the contents you edited, and save it in the `OldVersions/` directory with the original name, followed by `_snapshot` then a number that is 1 above the previous snapshot

> * Do not modify certain files

> Only approved high-level contributers can modify certain files, such as Wiki pages, contributing.md, README.md, and the license.

> * Do not add in tracking scripts

> Trackers are not allowed in any of my projects. Please keep backdoors, trackers, rootkits, keyloggers, and other privacy invasive features out of every file,

> * Keep it efficient

> These pages should be able to quickly load with less than 10 megabits of bandwidth speed. Please do not bog down page performance.

> * Don't add images without permission

> Images are sensitive for this project and will need to be approved before they can be committed.

> Please make sure to follow these rules to develop here.

> * Don't modify the Wiki without permission

> The Wiki is important for certain information and shouldn't be vandalized. Ask before modifying it. You must get approval from SeanPM2001 or another contributer of high level to the SNU project.

> * Don't blank out files

> Blanking out files is considered vandalism. Do not delete all the contents of a file.

> * Don't add copyrighted material without permission

> Copyrighted material needs permission to be added. You can't upload copyrighted material without permission. Some copyright holders to be aware of include Nintendo, Fox, Viacom, UMG, and many others. The ones listed are very strict on copyright and will try to hurt you over the littlest of things.

> * No vandalism

> Do not vandalize anything. This is pretty straightforward. If you are unsure what counts as vandalism, read other entries in this file.

> * Keep your commits professional

> Please document your commits well, but refrain from using swear words, slurs, or other bad words, unless you are referencing a file.

> * Do not delete lone `IGNORE.md` files

> `IGNORE.md` files should not be deleted if they are the only file in the folder/directory. If there is only an `IGNORE.md` file in a directory, it means the local repository had a blank directory, and I had to create an `IGNORE.md` file on GitHub, since you can't create empty folders/directories on GitHub.

> * Do not start writing in other languages without permission

> Do not start writing in a new language without permission. You can modify the current files with the current languages, but new languages would need approval first.

> * Fix as many bugs as possible

> In recent files, try to find and fix as many bugs as possible. If you are not capable of this, you can do other things, or you can make spelling corrections only if you are really good at the language you are writing in.

***

## File info

Contributing file version: `1 (Thursday, September 17th 2020 at 1:52 pm)`

Line count: `85`

File type: `Markdown (*.md)`

### End of file

***
