//
// Copyright (C) 2015 crosire & kagikn & contributors
// License: https://github.com/scripthookvdotnet/scripthookvdotnet#license
//

namespace GTA
{
    public enum WindowTitle
    {
        /// <summary>
        /// "Enter your Eyefind message (MAX 500 characters)"
        /// </summary>
        EnterEyefindMessage,
        /// <summary>
        /// "Message too long. Try again (MAX 500 characters)"
        /// </summary>
        MessageTooLong,
        /// <summary>
        /// "Forbidden message. Try again (MAX 500 characters)"
        /// </summary>
        ForbiddenMessage,
        /// <summary>
        /// "Enter your Eyefind subject (MAX 60 characters)"
        /// </summary>
        EnterEyefindSubject,
        /// <summary>
        /// "Subject too long. Try again (MAX 60 characters)"
        /// </summary>
        SubjectTooLong,
        /// <summary>
        /// "Enter Synopsis (MAX 125 characters)"
        /// </summary>
        EnterSynopsis,
        /// <summary>
        /// "Enter Custom Team Name (MAX 15 characters)"
        /// </summary>
        EnterCustomTeamName,
        /// <summary>
        /// "Forbidden Text. Try again (MAX 15 characters)"
        /// </summary>
        ForbiddenText15,
        /// <summary>
        /// "Custom Team Name"
        /// </summary>
        CustomTeamName,
        /// <summary>
        /// "Enter Message (MAX 60 characters)"
        /// </summary>
        EnterMessage60,
        /// <summary>
        /// "Forbidden Text. Try again (MAX 60 characters)"
        /// </summary>
        ForbiddenText60,
        /// <summary>
        /// "Invalid Message. Try again (MAX 20 characters)"
        /// </summary>
        InvalidMessage,
        /// <summary>
        /// "Enter Message (MAX 20 characters)"
        /// </summary>
        EnterMessage20,
        /// <summary>
        /// "Enter Outfit Name (MAX 15 characters)"
        /// </summary>
        EnterOutfitName,
        /// <summary>
        /// "Invalid Outfit Name. Try again (MAX 15 characters)"
        /// </summary>
        InvalidOutfitName,
        /// <summary>
        /// "Outfit Name"
        /// </summary>
        OutfitName,
        /// <summary>
        /// "Enter your Challenge name (MAX 30 characters)"
        /// </summary>
        EnterChallengeName,
    }
}
