//
// Copyright (C) 2015 crosire & kagikn & contributors
// License: https://github.com/scripthookvdotnet/scripthookvdotnet#license
//

namespace GTA
{
    /// <summary>
    /// An enumeration of all possible scripted task name hashes.
    /// Used for <see cref="Ped.GetScriptTaskStatus(ScriptTaskNameHash)"/>.
    /// </summary>
    public enum ScriptTaskNameHash : uint
    {
        /// <summary>
        /// This is the special hash that makes <see cref="Ped.GetScriptTaskStatus(ScriptTaskNameHash)"/> returns the current task status
        /// regardless of the current script task hash.
        /// </summary>
        Any = 0x55966344,
        /// <summary>
        /// This value is used when no scripted task is performed.
        /// </summary>
        Invalid = 0x811E343C,
        Pause = 0x03C990EC,
        StandStill = 0xC572E06A,
        Jump = 0x24415046,
        Cower = 0x1C43F4CF,
        HandsUp = 0xA573B67C,
        Duck = 0x1D415F6C,
        EnterVehicle = 0x950B6492,
        LeaveVehicle = 0x1AE73569,
        VehicleDriveToCoord = 0x93A5526E,
        VehicleDriveToCoordLongrange = 0x21D33957,
        VehicleDriveWander = 0xF09B15B3,
        GoStraightToCoord = 0x7D8F4411,
        GoStraightToCoordRelativeToEntity = 0x78EC0FF6,
        AchieveHeading = 0x7276D3DF,
        FollowPointRoute = 0xB232526F,
        GoToEntity = 0x4924437D,
        SmartFleePoint = 0xF10822AA,
        SmartFleePed = 0x6BA30179,
        WanderStandard = 0xBBA3B7CA,
        FollowNavMeshToCoord = 0x2A89B8A7,
        GoToCoordAnyMeans = 0x93399E79,
        PerformSequence = 0x0E763797,
        LeaveAnyVehicle = 0xCE98FBB3,
        AimGunScripted = 0x0C69931F,
        AimGunAtEntity = 0x6134071B,
        GoToCoordWhileShooting = 0x9387DEAB,
        TurnPedToFaceEntity = 0xCBCE4595,
        AimGunAtCoord = 0x49BEF36E,
        ShootAtCoord = 0xD90EF188,
        ShuffleToNextVehicleSeat = 0x153011FC,
        EveryoneLeaveVehicle = 0xA569F146,
        GoToEntityOffset = 0x87E3E0A8,
        TurnPedToFaceCoord = 0x574BB8F5,
        DrivePointRoute = 0xBAE13130,
        VehicleTempAction = 0x81B4D53A,
        BringVehicleToHalt = 0x30A0DC39,
        VehicleMission = 0xB41F1A34,
        DriveBy = 0x7D711E7D,
        UseMobilePhone = 0x37D339A1,
        WarpPedIntoVehicle = 0xBC555B9D,
        ShootAtEntity = 0x0A01F8B8,
        Climb = 0xB802FDCA,
        PerformSequenceFromProgress = 0x5485FD94,
        GoToEntityAiming = 0x967EA21C,
        SetPedDecisionMaker = 0x4E5B453C,
        SetPedDefensiveArea = 0x00A101C8,
        PedSlideToCoord = 0x3E5094A7,
        DrivePointRouteAdvanced = 0xEA6A323F,
        PedSlideToCoordAndPlayAnim = 0x8A0970F4,
        PlayAnim = 0x87B9A382,
        ArrestPed = 0x52FF82C0,
        Combat = 0x2E85A751,
        CombatTimed = 0xF2E41A8A,
        SeekCoverFromPos = 0xA77A06C5,
        SeekCoverFromPed = 0x71E30BDC,
        SeekCoverToCoverPoint = 0x99AFA8A3,
        ToggleDuck = 0x0F3B8554,
        GuardDefensiveArea = 0xDF5F4BA7,
        PickupAndCarryObject = 0x89025025,
        SeekCoverToCoords = 0x6C01775C,
        GuardAngledDefensiveArea = 0x84AEE7A0,
        StandGuard = 0xD88F2CDE,
        ClimbLadder = 0x66403353,
        GuardSphereDefensiveArea = 0x21E8D4E4,
        StartScenarioInPlace = 0x3B3A458F,
        StartScenarioAtPosition = 0xBE86C566,
        StartVehicleScenario = 0x86016E38,
        PutPedDirectlyIntoCover = 0x8B2F140E,
        PutPedDirectlyIntoCoverFromTarget = 0x9DD414F5,
        PutPedDirectlyIntoMelee = 0xFBBF6F4D,
        GuardCurrentPosition = 0x8CE49D34,
        UseNearestScenarioToPos = 0x623A5EFE,
        UseNearestScenarioChainToPos = 0x9BD19AE7,
        PerformSequenceLocally = 0xE7FBAB4F,
        CombatHatedTargetsInArea = 0x42CC4F21,
        CombatHatedTargetsAroundPed = 0xAA05B492,
        SwapWeapon = 0x2AB81462,
        ReloadWeapon = 0xC322ED6F,
        CombatHatedTargetsAroundPedTimed = 0x2719C0D1,
        GetOffBoat = 0x9A27A999,
        FollowNavmeshToCoordAdvanced = 0x9C4FBCAC,
        Patrol = 0xB550726C,
        StayInCover = 0xE1C16E99,
        HangGlider = 0x00E1228C,
        FollowToOffsetOfEntity = 0x3EF867F4,
        FollowToOffsetOfPickup = 0x70AEF4E9,
        GoToCoordWhileAimingAtCoord = 0x19CE5AFC,
        GoToCoordWhileAimingAtEntity = 0x972C6757,
        GoToEntityWhileAimingAtCoord = 0xBAEB517C,
        GoToEntityWhileAimingAtEntity = 0xB80BFB24,
        UseWalkieTalkie = 0x29BABC64,
        ChatToPed = 0x0FC239CD,
        FireFlare = 0xDEB1C08F,
        BindPose = 0x4929CE40,
        NMElectrocute = 0x8944A9A0,
        NMHighFall = 0x015D63E3,
        NMDangle = 0x0B49EAEC,
        NMSlungOverShoulder = 0xF0F9FFC0,
        NMStumble = 0xBACF9837,
        SkyDive = 0x4B65F15C,
        Parachute = 0x76CA4A8E,
        ParachuteToTarget = 0x4921B47A,
        FollowWaypointRoute = 0x9B4FC7D8,
        NMAttachToVehicle = 0x4847A94F,
        SetBlockingOfNonTemporaryEvents = 0x6F9C865C,
        MoveNetwork = 0x0494661C,
        SynchronizedScene = 0x6A67A5CC,
        VehicleShootAtCoord = 0xAF18B824,
        VehicleShootAtEntity = 0x20123810,
        VehiclePark = 0xEFC8537E,
        MountAnimal = 0x6F5F73AE,
        DismountAnimal = 0x1DE2A7BD,
        ThrowProjectile = 0xAD37BF03,
        VehicleAimAtCoord = 0x00C59C52,
        VehicleAimAtEntity = 0x6F30F4C1,
        VehicleAimUsingCamera = 0x3BDBC83C,
        AdvanceToTargetInLine = 0xCC312EC4,
        RappelFromHeli = 0xEF8D6B40,
        GeneralSweep = 0x491A782D,
        DragPedToCoord = 0x87A3DFEA,
        VehicleFollowWaypointRecording = 0xF1F17AE7,
        RappelDownFall = 0x8E29DEF2,
        GoToCoordAndAimAtHatedEntitiesNearCoord = 0x290A02BC,
        WanderInArea = 0x370BCF53,
        VehicleGoToNavmesh = 0xFBB43C4A,
        ForceMotionState = 0x9E78AC1F,
        InCustody = 0x6D4411C9,
        LookAtEntity = 0x08F5AF9D,
        LookAtCoord = 0xCB842EEC,
        VehicleChase = 0x2288A57C,
        StealthKill = 0x5014CC1A,
        HeliChase = 0x27369192,
        PlaneChase = 0x02DBA9BF,
        PlaneLand = 0x043E4A56,
        ShockingEventBackAway = 0x7F9814E9,
        ShockingEventHurryAway = 0xEC685098,
        ShockingEventReact = 0x498BABE3,
        Writhe = 0x8EC23E41,
        ExitCover = 0x4E961D82,
        PlantBomb = 0x8127FD1A,
        InvestigateCoords = 0x9C250C19,
        WanderSpecific = 0xD46F7254,
        SharkCircleCoord = 0x48EED267,
        SharkCirclePed = 0xFD0B5826,
        ReactAndFleeCoord = 0x29269FF1,
        ReactAndFleePed = 0x7DEDF098,
        GoToCoordAnyMeansExtraParams = 0x45B5A146,
        UseNearestTrainScenarioToPos = 0xA5806868,
        Jetpack = 0x828EBA07,
        GoToCoordAnyMeansExtraParamsWithCruiseSpeed = 0x4DE5C290,
        AgitatedAction = 0x548CB4B4,
        WarpPedDirectlyIntoCover = 0x0E802924
    }
}
