//
// Copyright (C) 2015 crosire & kagikn & contributors
// License: https://github.com/scripthookvdotnet/scripthookvdotnet#license
//

namespace GTA
{
    public enum BlipColor
    {
        /// <summary>
        /// The default RGB value of this color is the same as HUD_COLOUR_PURE_WHITE, whose default RGB value is #FFFFFF.
        /// </summary>
        White,
        Red,
        Green,
        Blue,
        Yellow = 66,
        /// <summary>
        /// The default RGB value of this color is the same as HUD_COLOUR_WHITE, whose default RGB value is #F0F0F0.
        /// </summary>
        WhiteNotPure = 4,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.Yellow"></see>, the only difference is color index.
        /// </summary>
        Yellow2,
        NetPlayer1,
        NetPlayer2,
        NetPlayer3,
        NetPlayer4,
        NetPlayer5,
        NetPlayer6,
        NetPlayer7,
        NetPlayer8,
        NetPlayer9,
        NetPlayer10,
        NetPlayer11,
        NetPlayer12,
        NetPlayer13,
        NetPlayer14,
        NetPlayer15,
        NetPlayer16,
        NetPlayer17,
        NetPlayer18,
        NetPlayer19,
        NetPlayer20,
        NetPlayer21,
        NetPlayer22,
        NetPlayer23,
        NetPlayer24,
        NetPlayer25,
        NetPlayer26,
        NetPlayer27,
        NetPlayer28,
        NetPlayer29,
        NetPlayer30,
        NetPlayer31,
        NetPlayer32,
        Freemode,
        InactiveMission,
        GreyDark,
        RedLight,
        /// <summary>
        /// This color is usually #65B4D4 sky blue, which is similar to <see cref="System.Drawing.Color.SkyBlue"></see>.
        /// </summary>
        Michael,
        /// <summary>
        /// This color is usually #ABEDAB light green, which is very similar to <see cref="System.Drawing.Color.LightGreen"></see>.
        /// </summary>
        Franklin,
        /// <summary>
        /// This color is usually #ABEDAB orange, which is very similar to <see cref="System.Drawing.Color.SandyBrown"></see>.
        /// </summary>
        Trevor,
        GolfPlayer1,
        GolfPlayer2,
        GolfPlayer3,
        GolfPlayer4,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.Red"></see>, the only difference is color index.
        /// </summary>
        Red2,
        Purple,
        Orange,
        GreenDark,
        BlueLight,
        BlueDark,
        Grey,
        YellowDark,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.Blue"></see>, the only difference is color index.
        /// </summary>
        Blue2,
        PurpleDark,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.Red"></see>, the only difference is color index.
        /// </summary>
        Red3,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.Yellow"></see>, the only difference is color index.
        /// </summary>
        Yellow3,
        Pink,
        GreyLight,
        Gang,
        Gang2,
        Gang3,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.Blue"></see>, the only difference is color index.
        /// </summary>
        Blue3 = 67,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.Blue"></see>, the only difference is color index.
        /// </summary>
        Blue4,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.Green"></see>, the only difference is color index.
        /// </summary>
        Green2,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.Yellow"></see>, the only difference is color index.
        /// </summary>
        Yellow4,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.Yellow"></see>, the only difference is color index.
        /// </summary>
        Yellow5,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.White"></see>, the only difference is color index.
        /// </summary>
        White2,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.Yellow"></see>, the only difference is color index.
        /// </summary>
        Yellow6,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.Blue"></see>, the only difference is color index.
        /// </summary>
        Blue5,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.Red"></see>, the only difference is color index.
        /// </summary>
        Red4,
        RedDark,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.Blue"></see>, the only difference is color index.
        /// </summary>
        Blue6,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.BlueDark"></see>, the only difference is color index.
        /// </summary>
        BlueDark2,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.RedDark"></see>, the only difference is color index.
        /// </summary>
        RedDark2,
        MenuYellow,
        SimpleBlipDefault,
        Waypoint,
        /// <summary>
        /// This color is always the same as <see cref="BlipColor.Blue"></see>, the only difference is color index.
        /// </summary>
        Blue7,
    }
}
