//
// Copyright (C) 2015 crosire & kagikn & contributors
// License: https://github.com/scripthookvdotnet/scripthookvdotnet#license
//

namespace GTA.Native
{
    public enum PedHash : uint
    {
        // Player Characters

        Michael = 225514697u,
        Franklin = 2602752943u,
        /// <summary>
        /// The Franklin Clinton model added in the Contract update, and this model is not used for story mode. The model name is <c>P_Franklin_02</c>.
        /// The leader player will control a <see cref="Ped" /> with this model in Short Trip missions.
        /// </summary>
        Franklin02 = 2937109846u,
        Trevor = 2608926626u,

        // Mission Characters

        Abigail = 1074457665u,
        AcidLabCook = 4185372713u,
        Agatha = 1855569864u,
        Agent = 610988552u,
        Agent02 = 1183124263u,
        Agent14 = 4227433577u,
        AhronWard = 927014855u,
        AmandaTownley = 1830688247u,
        Andreas = 1206185632u,
        /// <summary>
        /// The first in-game model of Andre Romell Young, known professionally as Dr. Dre.
        /// </summary>
        ARY = 3473698871u,
        /// <summary>
        /// The second in-game model of Andre Romell Young, known professionally as Dr. Dre.
        /// </summary>
        ARY02 = 2275358319u,
        Ashley = 2129936603u,
        AviSchwartzman = 939183526u,
        AviSchwartzman02 = 3735478533u,
        AviSchwartzman03 = 2100370963u,
        Avery = 3088269167u,
        Avon = 4242698434u,
        BallasLeader = 3678516463u,
        Ballasog = 2802535058u,
        Bankman = 2426248831u,
        Barry = 797459875u,
        Benny = 3300333010u,
        Benny02 = 1943113851u,
        Bestmen = 1464257942u,
        Beverly = 3181518428u,
        Billionaire = 28135809u,
        Brad = 3183167778u,
        Bride = 1633872967u,
        Brucie2 = 3893268832u,
        CallGirl01 = 2872523215u,
        CallGirl02 = 2450524033,
        Car3Guy1 = 2230970679u,
        Car3Guy2 = 1975732938u,
        Casey = 3774489940u,
        Celeb01 = 3676106820u,
        CharlieReed = 1818503341u,
        Chef = 1240128502u,
        Chef2 = 2240322243u,
        Chef3 = 4138965971u,
        Clay = 1825562762u,
        Claypain = 2634057640u,
        Cletus = 3865252245u,
        CrisFormage = 678319271u,
        Dale = 1182012905u,
        DaveNorton = 365775923u,
        Dax = 4050142444u,
        Denise = 2181772221u,
        Devin = 1952555184u,
        Dix = 4207997581u,
        DJBlaMadon = 4219210853u,
        DJBlamRupert = 914073350u,
        DJBlamRyanH = 400495475u,
        DJBlamRyanS = 3057799231u,
        DJDixManager = 4221366718u,
        DJGeneric01 = 2580849741u,
        DJSolFotios = 1241432569u,
        DJSolJakob = 2486302027u,
        DJSolManager = 2123514453u,
        DJSolMike = 795497466u,
        DJSolRobT = 1194880004u,
        DJTalAurelia = 2972453492u,
        DJTalIgnazio = 2787461577u,
        DoaMan = 1646160893u,
        Dom = 2620240008u,
        Dreyfuss = 3666413874u,
        DrFriedlander = 3422293493u,
        DrFriedlander2 = 2692738449u,
        DrugDealer = 520923037u,
        EdToh = 712602007u,
        EnglishDave = 205318924u,
        EnglishDave02 = 905946442u,
        EntourageA = 435539666u,
        EntourageB = 3362171829u,
        Fabien = 3499148112u,
        FbiSuit01 = 988062523u,
        Floyd = 2981205682u,
        Fooliganz01 = 3809717386u,
        Fooliganz02 = 944592636u,
        Furry = 1344679353u,
        G = 2216405299u,
        GeorginaCheng = 4014713647u,
        GolferA = 1067129421u,
        GolferB = 1858893999u,
        Groom = 4274948997u,
        GunVanSeller = 1520835918u,
        Gustavo = 3045437975u,
        Hao = 1704428387u,
        Hao02 = 4035146080u,
        HelmsmanPavel = 3619807921u,
        HippyLeader = 2017183759u,
        Huang = 3218252083u,
        Hunter = 3457361118u,
        Imani = 772427594u,
        IslandDJ00 = 3802345064u,
        IslandDJ01 = 1866942414u,
        IslandDJ02 = 1562223483u,
        IslandDJ03 = 322310057u,
        IslandDJ04 = 2154719772u,
        IslandDJ04D01 = 2979249514u,
        IslandDJ04D02 = 4260779566u,
        IslandDJ04E01 = 590182749u,
        Jackie = 2040422902u,
        JamalAmir = 1011548258u,
        Janet = 225287241u,
        Jaywalker = 1283622549u,
        JayNorris = 2050158196u,
        Jewelass = 257763003u,
        JimmyBoston = 3986688045u,
        JimmyBoston02 = 1135976220u,
        JimmyDisanto = 1459905209u,
        JimmyDiSanto2 = 2217591510u,
        /// <summary>
        /// The first in-game model of Jimmy Iovine.
        /// </summary>
        JIO = 1937203007u,
        /// <summary>
        /// The second in-game model of Jimmy Iovine.
        /// </summary>
        JIO02 = 3494374974u,
        JoeMinuteman = 3189787803u,
        JohnnyGuns = 658984954u,
        JohnnyKlebitz = 2278195374u,
        Josef = 3776618420u,
        Josh = 2040438510u,
        JuanStrickler = 507392637u,
        KarenDaniels = 3948009817u,
        Kaylee = 2810251555u,
        KerryMcintosh = 1530648845u,
        KerryMcIntosh02 = 3628252818u,
        Labrat = 2682084818u,
        LaceyJones02 = 3426139884u,
        LamarDavis = 1706635382u,
        LamarDavis02 = 421830750u,
        Lazlow = 3756278757u,
        Lazlow2 = 2231650028u,
        LesterCrest = 1302784073u,
        LesterCrest2 = 1849883942u,
        LesterCrest3 = 2013139108u,
        Lifeinvad01 = 1401530684u,
        Lifeinvad02 = 666718676u,
        LilDee = 3356359010u,
        Luchadora = 4163779209u,
        Magenta = 4242313482u,
        Malc = 4055673113u,
        Manuel = 4248931856u,
        Marnie = 411185872u,
        MaryAnn = 2741999622u,
        MasonDuggan = 1224757029u,
        Maude = 1005070462u,
        Mechanic01 = 482489509u,
        Mechanic02 = 1590147279u,
        Michelle = 3214308084u,
        MiguelMadrazo = 2781707480u,
        Milton = 3408943538u,
        Mimi = 2018483349u,
        /// <summary>
        /// The first in-game model of Mark Jordan, known professionally as DJ Pooh.
        /// </summary>
        MJO = 761115490u,
        /// <summary>
        /// The second in-game model of Mark Jordan, known professionally as DJ Pooh.
        /// </summary>
        MJO02 = 952584644u,
        Molly = 2936266209u,
        Moodyman02 = 2547074227u,
        MrK = 3990661997u,
        MrsPhillips = 946007720u,
        MrsR = 2642001958u,
        MrsThornhill = 503621995u,
        Musician00 = 595139263u,
        Natalia = 3726105915u,
        NervousRon = 3170921201u,
        NervousRon2 = 74809322u,
        Nigel = 3367442045u,
        OldMan1a = 1906124788u,
        OldMan2 = 4011150407u,
        OldRichGuy = 1006915658u,
        Omega = 1625728984u,
        ONeil = 768005095u,
        Orleans = 1641334641u,
        Ortega = 648372919u,
        Paper = 2577072326u,
        PartyPromo = 2243470389u,
        Patricia = 3312325004u,
        Patricia02 = 3272690865u,
        PernellMoss = 2239793254u,
        Popov = 645279998u,
        Paige = 357551935u,
        Pilot = 2253313678u,
        Pilot02 = 183230355u,
        Priest = 1681385341u,
        PrologueDriver = 2237544099u,
        PrologueSec01 = 1888624839u,
        PrologueSec02 = 666086773u,
        RampGang = 3845001836u,
        RampHic = 1165307954u,
        RampHipster = 3740245870u,
        RampMex = 3870061732u,
        Rashkovsky = 940330470u,
        ReqOfficer = 3944177684u,
        RoccoPelosi = 3585757951u,
        RoosterMcCraw = 2086307585u,
        RussianDrunk = 1024089777u,
        SachaYetarianMechanic = 1476581877u,
        ScreenWriter = 4293277303u,
        SecurityA = 793664635u,
        Sessanta = 924556713u,
        SiemonYetarian = 1283141381u,
        Sol = 3786117468u,
        Solomon = 2260598310u,
        SoundEng00 = 3661356520u,
        SSS = 991486725u,
        SteveHains = 941695432u,
        Stretch = 915948376u,
        SubCrewHead = 3801918077u,
        TalCC = 3828621987u,
        Talina = 3885222120u,
        TalMM = 1182156569u,
        Tanisha = 226559113u,
        TaoCheng = 3697041061u,
        TaoCheng2 = 1506159504u,
        TaosTranslator = 2089096292u,
        TaosTranslator2 = 3828553631u,
        TennisCoach = 2721800023u,
        Terry = 1728056212u,
        Thornton = 2482949079u,
        TomCasino = 55858852u,
        TomEpsilon = 3447159466u,
        Tonya = 3402126148u,
        TonyPrince = 761829301u,
        TracyDisanto = 3728026165u,
        TrafficWarden = 1461287021u,
        TylerDixon = 1382414087u,
        TylerDixon02 = 1511543927u,
        VagosLeader = 2205902046u,
        VagosSpeak = 4194109068u,
        Vernon = 3451031970u,
        Vincent = 736659122u,
        Vincent2 = 197443027u,
        Vincent3 = 363712933u,
        Vincent4 = 1764259993u,
        Wade = 2459507570u,
        WeiCheng = 2867128955u,
        Wendy = 1850188817u,
        YusufAmir = 1608114028u,
        Zimbor = 188012277u,


        AbigailCutscene = 2306246977u,
        AgathaCutscene = 756308504u,
        AgentCutscene = 3614493108u,
        Agent14Cutscene = 1841036427u,
        AlanJeromeCutscene = 1925887591u,
        AmandaTownleyCutscene = 2515474659u,
        AndreasCutscene = 3881194279u,
        AnitaCutscene = 117698822u,
        AntonCutscene = 2781317046u,
        /// <summary>
        /// The first cutscene model of Andre Romell Young, known professionally as Dr. Dre.
        /// </summary>
        ARYCutscene = 3059505486u,
        /// <summary>
        /// The second cutscene model of Andre Romell Young, known professionally as Dr. Dre.
        /// </summary>
        ARY02Cutscene = 3927407837u,
        AshleyCutscene = 650367097u,
        AveryCutscene = 1427949869u,
        AvonCutscene = 406009421u,
        AviSchwartzmanCutscene = 2560490906u,
        AviSchwartzman02Cutscene = 2315189472u,
        AviSchwartzman03Cutscene = 399022197u,
        BallasLeaderCutscene = 3098086931u,
        BallasogCutscene = 2884567044u,
        BankmanCutscene = 2539657518u,
        BarryCutscene = 1767447799u,
        BeverlyCutscene = 3027157846u,
        BillionaireCutscene = 3397673303u,
        BogdanCutscene = 1594283837u,
        BradCutscene = 4024807398u,
        BradCadaverCutscene = 1915268960u,
        BrideCutscene = 2193587873u,
        Brucie2Cutscene = 3361779221u,
        BryonyCutscene = 2006035933u,
        BurgerDrugCutscene = 2363277399u,
        CallGirl01Cutscene = 1613083234u,
        CallGirl02Cutscene = 779177722u,
        Car3Guy1Cutscene = 71501447u,
        Car3Guy2Cutscene = 327394568u,
        CarBuyerCutscene = 2362341647u,
        CaseyCutscene = 3935738944u,
        Celeb01Cutscene = 592225333u,
        CharlieReedCutscene = 10366540u,
        ChefCutscene = 2739391114u,
        Chef2Cutscene = 2925257274u,
        Chef3Cutscene = 2229008065u,
        ChinGoonCutscene = 2831296918u,
        ClayCutscene = 3687553076u,
        CletusCutscene = 3404326357u,
        CopCutscene = 2595446627u,
        CrisFormageCutscene = 3253960934u,
        CustomerCutscene = 2756669323u,
        DaleCutscene = 216536661u,
        DaveNortonCutscene = 2240226444u,
        DaxCutscene = 1117614067u,
        DebraCutscene = 3973074921u,
        DeniseCutscene = 1870669624u,
        DeniseFriendCutscene = 3045926185u,
        DevinCutscene = 788622594u,
        DixCutscene = 3957337349u,
        DJBlaMadonCutscene = 1835399538u,
        DomCutscene = 1198698306u,
        DreyfussCutscene = 1012965715u,
        DrFriedlanderCutscene = 2745392175u,
        DrFriedlander2Cutscene = 3177620756u,
        DrugDealerCutscene = 949115134u,
        EnglishDaveCutscene = 3533210174u,
        EnglishDave02Cutscene = 3713623407u,
        FabienCutscene = 1191403201u,
        FbiSuit01Cutscene = 1482427218u,
        FloydCutscene = 103106535u,
        FosRepCutscene = 466359675u,
        GCutscene = 2727244247u,
        GeorginaChengCutscene = 345107131u,
        GolferACutscene = 2120159624u,
        GolferBCutscene = 3706572452u,
        GroomCutscene = 2058033618u,
        GroveStrDlrCutscene = 3898166818u,
        GuadalopeCutscene = 261428209u,
        GurkCutscene = 3272931111u,
        GustavoCutscene = 2331262242u,
        HaoCutscene = 3969814300u,
        Hao02Cutscene = 3211915155u,
        HelmsmanPavelCutscene = 2675868152u,
        HuangCutscene = 1064198787u,
        HughCutscene = 1863555924u,
        HunterCutscene = 1531218220u,
        ImaniCutscene = 1987160310u,
        ImranCutscene = 3812756443u,
        IslandDJ00Cutscene = 2053038501u,
        IslandDJ01Cutscene = 887084708u,
        IslandDJ02Cutscene = 1712601360u,
        IslandDJ03Cutscene = 2440761309u,
        IslandDJ04Cutscene = 2998686303u,
        JackHowitzerCutscene = 1153203121u,
        JamalAmirCutscene = 3014899707u,
        JanetCutscene = 808778210u,
        JanitorCutscene = 3254803008u,
        JewelassCutscene = 1145088004u,
        JimmyBostonCutscene = 60192701u,
        JimmyDisantoCutscene = 3100414644u,
        JimmyDiSanto2Cutscene = 1836024091u,
        /// <summary>
        /// The first cutscene model of Jimmy Iovine.
        /// </summary>
        JIOCutscene = 2727058989u,
        /// <summary>
        /// The second cutscene model of Jimmy Iovine.
        /// </summary>
        JIO02Cutscene = 3702591664u,
        JoeMinutemanCutscene = 4036845097u,
        JohnnyGunsCutscene = 2108278433u,
        JohnnyKlebitzCutscene = 4203395201u,
        JosefCutscene = 1167549130u,
        JoshCutscene = 1158606749u,
        JuanStricklerCutscene = 3612049721u,
        KarenDanielsCutscene = 1269774364u,
        LabratCutscene = 1491358515u,
        LamarDavisCutscene = 1162230285u,
        LamarDavis02Cutscene = 22425093u,
        LazlowCutscene = 949295643u,
        Lazlow2Cutscene = 1598839101u,
        LesterCrestCutscene = 3046438339u,
        LesterCrest2Cutscene = 191074589u,
        LesterCrest3Cutscene = 496317824u,
        Lifeinvad01Cutscene = 1918178165u,
        LuchadoraCutscene = 1373135346u,
        MagentaCutscene = 1477887514u,
        ManuelCutscene = 4222842058u,
        MarnieCutscene = 1464721716u,
        MartinMadrazoCutscene = 1129928304u,
        MaryannCutscene = 161007533u,
        MaudeCutscene = 3166991819u,
        MerryWeatherCutscene = 1631478380u,
        MichelleCutscene = 1890499016u,
        MiguelMadrazoCutscene = 3685838978u,
        MiltonCutscene = 3077190415u,
        MimiCutscene = 2260860904u,
        /// <summary>
        /// The first cutscene model of Mark Jordan, known professionally as DJ Pooh.
        /// </summary>
        MJOCutscene = 2700978005u,
        /// <summary>
        /// The second cutscene model of Mark Jordan, known professionally as DJ Pooh.
        /// </summary>
        MJO02Cutscene = 2566126104u,
        MollyCutscene = 1167167044u,
        Moodyman02Cutscene = 2373903780u,
        MoviePremFemaleCutscene = 1270514905u,
        MoviePremMaleCutscene = 2372398717u,
        MrKCutscene = 3284966005u,
        MrsPhillipsCutscene = 3422397391u,
        MrsThornhillCutscene = 1334976110u,
        Musician00Cutscene = 3351027244u,
        NataliaCutscene = 1325314544u,
        NervousRonCutscene = 2023152276u,
        NervousRon2Cutscene = 731167118u,
        NigelCutscene = 3779566603u,
        OldMan1aCutscene = 518814684u,
        OldMan2Cutscene = 2566514544u,
        OmegaCutscene = 2339419141u,
        OrleansCutscene = 2905870170u,
        OrtegaCutscene = 3235579087u,
        OscarCutscene = 4095687067u,
        PaigeCutscene = 1528799427u,
        PaperCutscene = 1798879480u,
        PopovCutscene = 1635617250u,
        PartyPromoCutscene = 2564310175u,
        PatriciaCutscene = 3750433537u,
        Patricia02Cutscene = 788179139u,
        PornDudesCutscene = 793443893u,
        PriestCutscene = 1299047806u,
        PrologueDriverCutscene = 4027271643u,
        PrologueSec01Cutscene = 2141384740u,
        PrologueSec02Cutscene = 512955554u,
        RampGangCutscene = 3263172030u,
        RampHicCutscene = 2240582840u,
        RampHipsterCutscene = 569740212u,
        RampMarineCutscene = 1634506681u,
        RampMexCutscene = 4132362192u,
        RashkovskyCutscene = 411081129u,
        ReporterCutscene = 776079908u,
        ReqOfficerCutscene = 2297916218u,
        RoccoPelosiCutscene = 2858686092u,
        RussianDrunkCutscene = 1179785778u,
        ScreenWriterCutscene = 2346790124u,
        SecurityACutscene = 734593052u,
        SessantaCutscene = 3552233440u,
        SiemonYetarianCutscene = 3230888450u,
        SolCutscene = 1324952405u,
        SolomonCutscene = 4140949582u,
        SoundEng00Cutscene = 543190380u,
        SSSCutscene = 3772505184u,
        SteveHainsCutscene = 2766184958u,
        StretchCutscene = 2302502917u,
        Stripper01Cutscene = 2934601397u,
        Stripper02Cutscene = 2168724337u,
        TalCCCutscene = 3392144504u,
        TalMMCutscene = 3785408493u,
        TanishaCutscene = 1123963760u,
        TaoChengCutscene = 2288257085u,
        TaoCheng2Cutscene = 650034742u,
        TaosTranslatorCutscene = 1397974313u,
        TaosTranslator2Cutscene = 3017289007u,
        TennisCoachCutscene = 1545995274u,
        TerryCutscene = 978452933u,
        ThorntonCutscene = 4086880849u,
        TomCutscene = 1776856003u,
        TomCasinoCutscene = 3488666811u,
        TomEpsilonCutscene = 2349847778u,
        TonyaCutscene = 1665391897u,
        TonyPrinceCutscene = 1566545691u,
        TracyDisantoCutscene = 101298480u,
        TrafficWardenCutscene = 3727243251u,
        UndercoverCopCutscene = 4017642090u,
        VagosLeaderCutscene = 2201152485u,
        VagosSpeakCutscene = 1224690857u,
        VernonCutscene = 3178697670u,
        VincentCutscene = 520636071u,
        Vincent2Cutscene = 2782957088u,
        Vincent4Cutscene = 2149958315u,
        WadeCutscene = 3529955798u,
        WeiChengCutscene = 819699067u,
        WendyCutscene = 1437043119u,
        YusufAmirCutscene = 2709440876,
        ZimborCutscene = 3937184496u,

        // Animals

        Boar = 3462393972u,
        Boar2 = 2334752500u,
        Cat = 1462895032u,
        ChickenHawk = 2864127842u,
        Chimp = 2825402133u,
        Chimp2 = 2114741418u,
        Chop = 351016938u,
        Chop2 = 1039404993u,
        Cormorant = 1457690978u,
        Cow = 4244282910u,
        Coyote = 1682622302u,
        Coyote2 = 734582471u,
        Crow = 402729631u,
        Deer = 3630914197u,
        Deer2 = 2857068496u,
        Dolphin = 2344268885u,
        Fish = 802685111u,
        Hen = 1794449327u,
        HammerShark = 1015224100u,
        Humpback = 1193010354u,
        Husky = 1318032802u,
        KillerWhale = 2374682809u,
        MountainLion = 307287994u,
        MountainLion2 = 2368442193u,
        Panther = 3877461608u,
        Pig = 2971380566u,
        Pigeon = 111281960u,
        Poodle = 1125994524u,
        Pug = 1832265812u,
        Pug2 = 1072872081u,
        Rabbit = 3753204865u,
        Rabbit2 = 1553815115u,
        Rat = 3283429734u,
        Retriever = 882848737u,
        Rhesus = 3268439891u,
        Rottweiler = 2506301981u,
        Seagull = 3549666813u,
        Shepherd = 1126154828u,
        Stingray = 2705875277u,
        TigerShark = 113504370u,
        Westy = 2910340283u,

        // Unique Pedestrians

        Abner = 4037813798u,
        AlDiNapoli = 4042020578u,
        Antonb = 3479321132u,
        Armoured01 = 3455013896u,
        AvonGoon = 2618542997u,
        Babyd = 3658575486u,
        Bankman01 = 3272005365u,
        Baygor = 1380197501u,
        BethFemaleYoung01 = 2503965067u,
        BogdanGoon = 1297520375u,
        BikeHire01 = 1984382277u,
        BikerChic = 4198014287u,
        BlaneMaleMiddleAge = 2543361176u,
        BoatStaff01M = 3361671816u,
        BoatStaff01F = 848542158u,
        BurgerDrug = 2340239206u,
        CalebMaleYoung = 4150317356u,
        CarDesignFemale01 = 606876839u,
        CarolFemaleOld = 1415150394u,
        CasinoCashFemaleMiddleAge01 = 3138220789u,
        CasinoShopFemaleMiddleAge01 = 338154536u,
        Chip = 610290475u,
        Claude01 = 3237179831u,
        ClubHouseBar01 = 3287737221u,
        CocaineFemale01 = 1264941816u,
        CocaineMale01 = 1456705429u,
        ComJane = 3064628686u,
        Corpse01 = 773063444u,
        Corpse01UFY = 2624589981u,
        Corpse01UMY = 2495782975u,
        Corpse02 = 228356856u,
        CounterfeitFemale01 = 3079205365u,
        CounterfeitMale01 = 2555758964u,
        CroupThiefMaleYoung01 = 2145640135u,
        CurtisMaleMiddleAge = 4161104501u,
        Cyclist01 = 755956971u,
        DanceBurlFemaleYoung = 222643882u,
        DanceBurlMaleYoung = 1443057394u,
        DanceLthrFemaleYoung = 130590395u,
        DanceLthrMaleYoung = 4202382694u,
        DanceRaveFemaleYoung = 2145639711u,
        DanceRaveMaleYoung = 2900533745u,
        DeadHooker = 1943971979u,
        DeanMaleOld = 4188740747u,
        DebbieFemaleMiddleAge01 = 223828550u,
        Drowned = 3623056905u,
        EileenFemaleOld = 2630685688u,
        ExArmy01 = 1161072059u,
        ExecutivePAMale01 = 1048844220u,
        ExecutivePAFemale01 = 1126998116u,
        ExecutivePAFemale02 = 1500695792u,
        Famdd01 = 866411749u,
        FemaleAgent = 1348537411u,
        FibArchitect = 874722259u,
        FibMugger01 = 2243544680u,
        FibSec01 = 1558115333u,
        FilmDirector = 728636342u,
        FilmNoir = 732742363u,
        Finguru01 = 1189322339u,
        ForgeryFemale01 = 2014985464u,
        ForgeryMale01 = 1631482011u,
        FreemodeFemale01 = 2627665880u,
        FreemodeMale01 = 1885233650u,
        GabrielMaleYoung = 1278330017u,
        Glenstank01 = 1169888870u,
        Griff01 = 3293887675u,
        Guido01 = 3333724719u,
        GunVend01 = 3005388626u,
        Hacker = 2579169528u,
        HeadTargets = 1173958009u,
        HeliStaff01 = 431423238u,
        Hippie01 = 4030826507u,
        Hotposh01 = 2526768638u,
        Imporage = 880829941u,
        ImportExportFemale01 = 2225189146u,
        ImportExportMale01 = 3164785898u,
        Jesus01 = 3459037009u,
        Jewelass01 = 4040474158u,
        JewelSec01 = 2899099062u,
        JewelThief = 3872144604u,
        Juggernaut01M = 2431602996u,
        Juggernaut02UMY = 2738943447u,
        Juggernaut03UMM = 2680892058u,
        Justin = 2109968527u,
        LaurenFemaleYoung = 967594628u,
        Mani = 3367706194u,
        Markfost = 479578891u,
        Marston01 = 943915367u,
        MethFemale01 = 3534913217u,
        MethMale01 = 3988008767u,
        MilitaryBum = 1191548746u,
        Miranda = 1095737979u,
        Miranda02 = 3954904244u,
        Mistress = 1573528872u,
        Misty01 = 3509125021u,
        MovieStar = 894928436u,
        MPros01 = 1822283721u,
        Niko01 = 4007317449u,
        Paparazzi = 1346941736u,
        Party01 = 921110016u,
        PartyTarget = 2180468199u,
        PestContDriver = 994527967u,
        PestContGunman = 193469166u,
        Pogo01 = 3696858125u,
        Poppymich = 602513566u,
        PoppyMich02 = 1823868411u,
        Princess = 3538133636u,
        Prisoner01 = 2073775040u,
        PrologueHostage01 = 3306347811u,
        PrologueMournFemale01 = 2718472679u,
        PrologueMournMale01 = 3465937675u,
        RivalPaparazzi = 1624626906u,
        SecuroGuardMale01 = 3660355662u,
        ShopKeep01 = 416176080u,
        SlodHuman = 1057201338u,
        SlodLargeQuadped = 2238511874u,
        SlodSmallQuadped = 762327283u,
        SmugMech01 = 3446096293u,
        SpyActor = 2886641112u,
        SpyActress = 1535236204u,
        StreetArt01 = 1813637474u,
        StripperLite = 695248020u,
        Taphillbilly = 2585681490u,
        TaylorFemaleYoung = 450271392u,
        Tramp01 = 1787764635u,
        UshiMaleYoung = 4218162071u,
        VagosFun01 = 3299219389u,
        VinceMaleMiddleAge = 2526968950u,
        WareMechMale01 = 4154933561u,
        WillyFist = 2423691919u,
        WarehouseBoss = 1108376739u,
        WeaponExpertMale01 = 921328393u,
        WeaponWorkerMale01 = 1099321454u,
        WeedFemale01 = 2992993187u,
        WeedMale01 = 2441008217u,
        YuleMonster = 3543068589u,
        Zombie01 = 2890614022u,
        YetiUMM = 2363925622u,

        // Random Pedestrians

        Acult01AMM = 1413662315u,
        Acult01AMO = 1430544400u,
        Acult01AMY = 3043264555u,
        Acult02AMO = 1268862154u,
        Acult02AMY = 2162532142u,
        AfriAmer01AMM = 3513928062u,
        Airhostess01SFY = 1567728751u,
        AirworkerSMY = 1644266841u,
        Ammucity01SMY = 2651349821u,
        AmmuCountrySMM = 233415434u,
        ArmBoss01GMM = 4058522530u,
        ArmGoon01GMM = 4255728232u,
        ArmGoon02GMY = 3310258058u,
        ArmLieut01GMM = 3882958867u,
        Armoured01SMM = 2512875213u,
        Armoured02SMM = 1669696074u,
        Armymech01SMY = 1657546978u,
        Autopsy01SMY = 2988916046u,
        Autoshop01SFM = 12394276u,
        Autoshop01SMM = 68070371u,
        Autoshop02SMM = 4033578141u,
        Autoshop03SMM = 109850898u,
        Azteca01GMY = 1752208920u,
        BallaEast01GMY = 4096714883u,
        BallaOrig01GMY = 588969535u,
        Ballas01GFY = 361513884u,
        BallaSout01GMY = 599294057u,
        BankRobber01AMM = 3645767658u,
        Barman01SMY = 3852538118u,
        Bartender01SFY = 2014052797u,
        Baywatch01SFY = 1250841910u,
        Baywatch01SMY = 189425762u,
        Beach01AFM = 808859815u,
        Beach01AFY = 3349113128u,
        Beach01AMM = 1077785853u,
        Beach01AMO = 2217202584u,
        Beach01AMY = 3523131524u,
        Beach02AFY = 3105934379u,
        Beach02AMM = 2021631368u,
        Beach02AMO = 3243462130u,
        Beach02AMY = 600300561u,
        Beach03AMY = 3886638041u,
        Beach04AMY = 3105523388u,
        BeachBarStaff01SFY = 3269663242u,
        Beachvesp01AMY = 2114544056u,
        Beachvesp02AMY = 3394697810u,
        BennyMech01F = 2139205821u,
        Bevhills01AFM = 3188223741u,
        Bevhills01AFY = 1146800212u,
        Bevhills01AMM = 1423699487u,
        Bevhills01AMY = 1982350912u,
        Bevhills02AFM = 2688103263u,
        Bevhills02AFY = 1546450936u,
        Bevhills02AMM = 1068876755u,
        Bevhills02AMY = 1720428295u,
        Bevhills03AFY = 549978415u,
        Bevhills04AFY = 920595805u,
        Bevhills05AFY = 2464671085u,
        Blackops01SMY = 3019107892u,
        Blackops02SMY = 2047212121u,
        Blackops03SMY = 1349953339u,
        Bodybuild01AFM = 1004114196u,
        Bouncer01SMM = 2681481517u,
        Bouncer02SMM = 1376128402u,
        Breakdance01AMY = 933205398u,
        Busboy01SMY = 3640249671u,
        Busicas01AMY = 2597531625u,
        Business01AFY = 664399832u,
        Business01AMM = 2120901815u,
        Business01AMY = 3382649284u,
        Business02AFM = 532905404u,
        Business02AFY = 826475330u,
        Business02AMY = 3014915558u,
        Business03AFY = 2928082356u,
        Business03AMY = 2705543429u,
        Business04AFY = 3083210802u,
        Busker01SMO = 2912874939u,
        CarClub01AFY = 4245210443u,
        CarClub01AMY = 1751120084u,
        CartelGoons01GMM = 2572894111u,
        CartelGuards01GMM = 2127932792u,
        CartelGuards02GMM = 1821116645u,
        Casino01SFY = 3163733717u,
        Casino01SMY = 337826907u,
        CasRN01GMM = 1020431539u,
        CCrew01SMM = 3387290987u,
        CCrew02SMM = 3080868068u,
        CCrew03SMM = 3867258530u,
        Chef01SMY = 261586155u,
        ChemSec01SMM = 788443093u,
        ChemWork01GMM = 4128603535u,
        ChiBoss01GMM = 3118269184u,
        ChiCold01GMM = 275618457u,
        ChiGoon01GMM = 2119136831u,
        ChiGoon02GMM = 4285659174u,
        CiaSec01SMM = 1650288984u,
        Clown01SMY = 71929310u,
        ClubBar01SFY = 3240507723u,
        ClubBar01SMY = 1299424319u,
        ClubBar02SFY = 1438999163u,
        ClubCust01AFY = 1744231373u,
        ClubCust02AFY = 357447289u,
        ClubCust03AFY = 10751269u,
        ClubCust04AFY = 786557344u,
        ClubCust01AMY = 2813792322u,
        ClubCust02AMY = 3324988722u,
        ClubCust03AMY = 3572886207u,
        ClubCust04AMY = 3793814805u,
        Cntrybar01SMM = 436345731u,
        Construct01SMY = 3621428889u,
        Construct02SMY = 3321821918u,
        Cop01SFY = 368603149u,
        Cop01SMM = 1762753038u,
        Cop01SMY = 1581098148u,
        Cyclist01AMY = 4257633223u,
        Dealer01SMY = 3835149295u,
        Devinsec01SMY = 2606068340u,
        Dhill01AMY = 4282288299u,
        Dockwork01SMM = 349680864u,
        Dockwork01SMY = 2255894993u,
        Doctor01SMM = 3564307372u,
        Doorman01SMY = 579932932u,
        Downtown01AFM = 1699403886u,
        Downtown01AMY = 766375082u,
        DrugProcess01SMM = 1547070595u,
        DwService01SMY = 1976765073u,
        DwService02SMY = 4119890438u,
        Eastsa01AFM = 2638072698u,
        Eastsa01AFY = 4121954205u,
        Eastsa01AMM = 4188468543u,
        Eastsa01AMY = 2756120947u,
        Eastsa02AFM = 1674107025u,
        Eastsa02AFY = 70821038u,
        Eastsa02AMM = 131961260u,
        Eastsa02AMY = 377976310u,
        Eastsa03AFY = 1371553700u,
        Epsilon01AFY = 1755064960u,
        Epsilon01AMY = 2010389054u,
        Epsilon02AMY = 2860711835u,
        Factory01SFY = 1777626099u,
        Factory01SMY = 1097048408u,
        Famca01GMY = 3896218551u,
        Famdnf01GMY = 3681718840u,
        Famfor01GMY = 2217749257u,
        Families01GFY = 1309468115u,
        Farmer01AMM = 2488675799u,
        FatBla01AFM = 4206136267u,
        FatCult01AFM = 3050275044u,
        Fatlatin01AMM = 1641152947u,
        FatWhite01AFM = 951767867u,
        FemBarberSFM = 373000027u,
        FibOffice01SMM = 3988550982u,
        FibOffice02SMM = 653289389u,
        FibSec01SMM = 2072724299u,
        FieldWorker01SMM = 2423573072u,
        Fireman01SMY = 3065114024u,
        Fitness01AFY = 1165780219u,
        Fitness02AFY = 331645324u,
        Fooliganz01GFM = 2705574861u,
        Fooliganz01GMM = 620276966u,
        FriedlanderGoons01GMM = 80921836u,
        Gaffer01SMM = 2841034142u,
        GarbageSMY = 4000686095u,
        Gardener01SMM = 1240094341u,
        Gay01AMY = 3519864886u,
        Gay02AMY = 2775713665u,
        GenBiker01AFM = 1956335717u,
        GenBiker01AMM = 3739319678u,
        GenCasPat01AFY = 2434503858u,
        GenCasPat01AMY = 2600762591u,
        Genfat01AMM = 115168927u,
        Genfat02AMM = 330231874u,
        Genhot01AFY = 793439294u,
        GenStreet01AFM = 1261149561u,
        Genstreet01AFO = 1640504453u,
        Genstreet01AMO = 2908022696u,
        Genstreet01AMY = 2557996913u,
        Genstreet02AMY = 891398354u,
        GenThug01GMM = 3540189323u,
        GentransportSMM = 411102470u,
        Golfer01AFY = 2111372120u,
        Golfer01AMM = 2850754114u,
        Golfer01AMY = 3609190705u,
        Goons01GMM = 1642910562u,
        Grip01SMY = 815693290u,
        Hairdress01SMM = 1099825042u,
        Hasjew01AMM = 1809430156u,
        Hasjew01AMY = 3782053633u,
        HazmatWorker01SMM = 3688051673u,
        Highsec01SMM = 4049719826u,
        Highsec02SMM = 691061163u,
        HighSec03SMM = 518696223u,
        HighSec04SMM = 1442749254u,
        HighSec05SMM = 985359552u,
        Hiker01AFY = 813893651u,
        Hiker01AMY = 1358380044u,
        Hillbilly01AMM = 1822107721u,
        Hillbilly02AMM = 2064532783u,
        Hippie01AFY = 343259175u,
        Hippy01AMY = 2097407511u,
        Hipster01AFY = 2185745201u,
        Hipster01AMY = 587703123u,
        Hipster02AFY = 2549481101u,
        Hipster02AMY = 349505262u,
        Hipster03AFY = 2780469782u,
        Hipster03AMY = 1312913862u,
        Hipster04AFY = 429425116u,
        Hooker01SFY = 42647445u,
        Hooker02SFY = 348382215u,
        Hooker03SFY = 51789996u,
        Hwaycop01SMY = 1939545845u,
        Indian01AFO = 3134700416u,
        Indian01AFY = 153984193u,
        Indian01AMM = 3721046572u,
        Indian01AMY = 706935758u,
        JanitorSMM = 2842417644u,
        Jetski01AMY = 767028979u,
        Juggalo01AFY = 3675473203u,
        Juggalo01AMY = 2445950508u,
        KorBoss01GMM = 891945583u,
        Korean01GMY = 611648169u,
        Korean02GMY = 2414729609u,
        KorLieut01GMY = 2093736314u,
        Ktown01AFM = 1388848350u,
        Ktown01AFO = 1204772502u,
        Ktown01AMM = 3512565361u,
        Ktown01AMO = 355916122u,
        Ktown01AMY = 452351020u,
        Ktown02AFM = 1090617681u,
        Ktown02AMY = 696250687u,
        Lathandy01SMM = 2659242702u,
        Latino01AMY = 321657486u,
        Lifeinvad01SMM = 3724572669u,
        LinecookSMM = 3684436375u,
        Lost01GFY = 4250220510u,
        Lost01GMY = 1330042375u,
        Lost02GMY = 1032073858u,
        Lost03GMY = 850468060u,
        Lsmetro01SMM = 1985653476u,
        Maid01SFM = 3767780806u,
        Malibu01AMM = 803106487u,
        MaraGrandeGMM = 2487843240u,
        Mariachi01SMM = 2124742566u,
        Marine01SMM = 4074414829u,
        Marine01SMY = 1702441027u,
        Marine02SMM = 4028996995u,
        Marine02SMY = 1490458366u,
        Marine03SMY = 1925237458u,
        Methhead01AMY = 1768677545u,
        MexBoss01GMM = 1466037421u,
        MexBoss02GMM = 1226102803u,
        MexCntry01AMM = 3716251309u,
        MexGang01GMY = 3185399110u,
        MexGoon01GMY = 653210662u,
        MexGoon02GMY = 832784782u,
        MexGoon03GMY = 2521633500u,
        MexLabor01AMM = 2992445106u,
        MexThug01AMY = 810804565u,
        Migrant01SFY = 3579522037u,
        Migrant01SMM = 3977045190u,
        MimeSMY = 1021093698u,
        MLCrisis01AMM = 1561088805u,
        Motox01AMY = 1694362237u,
        Motox02AMY = 2007797722u,
        MovAlien01 = 1684083350u,
        MovPrem01SFY = 587253782u,
        Movprem01SMM = 3630066984u,
        Movspace01SMM = 3887273010u,
        Musclbeac01AMY = 1264920838u,
        Musclbeac02AMY = 3374523516u,
        OgBoss01AMM = 1746653202u,
        Paparazzi01AMM = 3972697109u,
        Paramedic01SMM = 3008586398u,
        PestCont01SMY = 1209091352u,
        Pilot01SMM = 3881519900u,
        Pilot01SMY = 2872052743u,
        Pilot02SMM = 4131252449u,
        PoloGoon01GMY = 1329576454u,
        PoloGoon02GMY = 2733138262u,
        Polynesian01AMM = 2849617566u,
        Polynesian01AMY = 2206530719u,
        Postal01SMM = 1650036788u,
        Postal02SMM = 1936142927u,
        Prisguard01SMM = 1456041926u,
        PrisMuscl01SMY = 1596003233u,
        Prisoner01SMY = 2981862233u,
        Prisoners01GMM = 565446671u,
        PrologueHostage01AFM = 379310561u,
        PrologueHostage01AMM = 2534589327u,
        RaceOrg01SMM = 2597948825u,
        Ranger01SFY = 2680682039u,
        Ranger01SMY = 4017173934u,
        RetailStaff01SFM = 3248235618u,
        Roadcyc01AMY = 4116817094u,
        Robber01SMY = 3227390873u,
        RsRanger01AMO = 1011059922u,
        Runner01AFY = 3343476521u,
        Runner01AMY = 623927022u,
        Runner02AMY = 2218630415u,
        Rurmeth01AFY = 1064866854u,
        Rurmeth01AMM = 1001210244u,
        Salton01AFM = 3725461865u,
        Salton01AFO = 3439295882u,
        Salton01AMM = 1328415626u,
        Salton01AMO = 539004493u,
        Salton01AMY = 3613420592u,
        Salton02AMM = 1626646295u,
        Salton03AMM = 2995538501u,
        Salton04AMM = 2521108919u,
        SalvaBoss01GMY = 2422005962u,
        SalvaGoon01GMY = 663522487u,
        SalvaGoon02GMY = 846439045u,
        SalvaGoon03GMY = 62440720u,
        SbikeAMO = 1794381917u,
        Scdressy01AFY = 3680420864u,
        Scientist01SMM = 1092080539u,
        Scrubs01SFY = 2874755766u,
        Security01SMM = 3613962792u,
        Sheriff01SFY = 1096929346u,
        Sheriff01SMY = 2974087609u,
        ShopHighSFM = 2923947184u,
        ShopLowSFY = 2842568196u,
        ShopMaskSMY = 1846684678u,
        ShopMidSFY = 1055701597u,
        Skater01AFY = 1767892582u,
        Skater01AMM = 3654768780u,
        Skater01AMY = 3250873975u,
        Skater02AMY = 2952446692u,
        Skidrow01AFM = 2962707003u,
        Skidrow01AMM = 32417469u,
        Slasher01GMM = 662575004u,
        SmartCasPat01AFY = 279228114u,
        SmartCasPat01AMY = 553826858u,
        Snowcop01SMM = 451459928u,
        Socenlat01AMM = 193817059u,
        Soucent01AFM = 1951946145u,
        Soucent01AFO = 1039800368u,
        Soucent01AFY = 744758650u,
        Soucent01AMM = 1750583735u,
        Soucent01AMO = 718836251u,
        Soucent01AMY = 3877027275u,
        Soucent02AFM = 4079145784u,
        Soucent02AFO = 2775443222u,
        Soucent02AFY = 1519319503u,
        Soucent02AMM = 2674735073u,
        Soucent02AMO = 1082572151u,
        Soucent02AMY = 2896414922u,
        Soucent03AFY = 2276611093u,
        Soucent03AMM = 2346291386u,
        Soucent03AMO = 238213328u,
        Soucent03AMY = 3287349092u,
        Soucent04AMM = 3271294718u,
        Soucent04AMY = 2318861297u,
        Soucentmc01AFM = 3454621138u,
        Staggrm01AMO = 2442448387u,
        Stbla01AMY = 3482496489u,
        Stbla02AMY = 2563194959u,
        Stlat01AMY = 2255803900u,
        Stlat02AMM = 3265820418u,
        Stripper01SFY = 1381498905u,
        Stripper02SFY = 1846523796u,
        StripperLiteSFY = 1544875514u,
        Strperf01SMM = 2035992488u,
        Strpreach01SMM = 469792763u,
        StrPunk01GMY = 4246489531u,
        StrPunk02GMY = 228715206u,
        Strvend01SMM = 3465614249u,
        Strvend01SMY = 2457805603u,
        Stwhi01AMY = 605602864u,
        Stwhi02AMY = 919005580u,
        StudioAssist01SFM = 3243617472u,
        StudioAssist02SMM = 2679204136u,
        StudioParty01AFY = 1152702280u,
        StudioParty02AFY = 1984313950u,
        StudioParty01AMM = 2342084645u,
        StudioParty01AMY = 2989564573u,
        StudioProd01SMM = 3819113407u,
        StudioSouEng02SMM = 3725116432u,
        SubCrew01SMM = 3738560875u,
        Sunbathe01AMY = 3072929548u,
        Surfer01AMY = 3938633710u,
        Swat01SMY = 2374966032u,
        Sweatshop01SFM = 824925120u,
        Sweatshop01SFY = 2231547570u,
        Tattoo01AMO = 2494442380u,
        Tattoo01SMM = 3289859051u,
        TattooCust01AMY = 2619283993u,
        Tennis01AFY = 1426880966u,
        Tennis01AMM = 1416254276u,
        Topless01AFY = 2633130371u,
        Tourist01AFM = 1347814329u,
        Tourist01AFY = 1446741360u,
        Tourist01AMM = 3365863812u,
        Tourist02AFY = 2435054400u,
        Tramp01AFM = 1224306523u,
        Tramp01AMM = 516505552u,
        Tramp01AMO = 390939205u,
        TrampBeac01AFM = 2359345766u,
        TrampBeac01AMM = 1404403376u,
        Tranvest01AMM = 3773208948u,
        Tranvest02AMM = 4144940484u,
        Trucker01SMM = 1498487404u,
        Ups01SMM = 2680389410u,
        Ups02SMM = 3502104854u,
        Uscg01SMY = 3389018345u,
        Vagos01GFY = 1520708641u,
        Valet01SMY = 999748158u,
        Vindouche01AMY = 3247667175u,
        Vinewood01AFY = 435429221u,
        Vinewood01AMY = 1264851357u,
        Vinewood02AFY = 3669401835u,
        Vinewood02AMY = 1561705728u,
        Vinewood03AFY = 933092024u,
        Vinewood03AMY = 534725268u,
        Vinewood04AFY = 4209271110u,
        Vinewood04AMY = 835315305u,
        Waiter01SMY = 2907468364u,
        Warehouse01SFM = 3845594002u,
        Warehouse01SMM = 660117393u,
        WareTech01SMY = 1221043248u,
        WestSec01SMY = 2719478597u,
        WestSec02SMY = 3200789669u,
        WinClean01SMY = 1426951581u,
        Xmech01SMY = 1142162924u,
        Xmech02SMY = 3189832196u,
        Xmech02SMYMP = 1762949645u,
        Yoga01AFY = 3290105390u,
        Yoga01AMY = 2869588309u,
    }
}
