/**
 * Custom colors for use throughout the application.
 *
 * Copyright (C) 2024 Scribe
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package be.scri.ui.theme

import androidx.compose.ui.graphics.Color

val theme_light_card_view_color = Color(color = 0xFFFFFFFF)
val theme_light_button_color = Color(color = 0xFFFDAD0D)
val theme_light_button_text_color = Color(color = 0xFF000000)
val theme_light_background = Color(color = 0xFF5EB5E8)
val theme_light_text_color = Color(color = 0xFF000000)
val theme_light_selected_button_color = Color(color = 0xFF235270)
val theme_light_switch_container_color = Color(color = 0xFFAAAAAA)
val theme_light_switch_selector_color = Color(color = 0xFFFEDE9E)
val theme_light_unchecked_switch_selector_color = Color(color = 0xFFEEEEEE)
val theme_light_corner_button_color = Color(color = 0xFFFDAD0D)

val theme_dark_card_view_color = Color(color = 0xFF000000)
val theme_dark_button_color = Color(color = 0xFFD17B0F)
val theme_dark_button_text_color = Color(color = 0xFFD17B0F)
val theme_dark_background = Color(color = 0xFF235270)
val theme_dark_text_color = Color(color = 0xFFFFFFFF)
val theme_dark_button_outline_color = Color(color = 0xFFD17B0F)
val theme_dark_selected_button_color = Color(color = 0xFF5EB5E8)
val theme_dark_switch_container_color = Color(color = 0xFFAAAAAA)
val theme_dark_switch_selector_color = Color(color = 0xFF2A1903)
val theme_dark_unchecked_switch_selector_color = Color(color = 0xFF2D2D2D)
val theme_dark_corner_button_color = Color(color = 0xFF2A1903)

@Suppress("MagicNumber")
val BlueSky = Color(0xFF4478a9)

@Suppress("MagicNumber")
val NightSky = Color(0xFF333333)

@Suppress("MagicNumber")
val BorderColor = Color(0x40000000)
