package namesgenerator

import (
	"fmt"
	"math/rand"
	"strings"
	"time"
)

var (
	left = [...]string{
		"admiring",
		"adoring",
		"affectionate",
		"agitated",
		"amazing",
		"angry",
		"awesome",
		"beautiful",
		"blissful",
		"bold",
		"boring",
		"brave",
		"busy",
		"charming",
		"clever",
		"cool",
		"compassionate",
		"competent",
		"condescending",
		"confident",
		"cranky",
		"crazy",
		"dazzling",
		"determined",
		"distracted",
		"dreamy",
		"eager",
		"ecstatic",
		"elastic",
		"elated",
		"elegant",
		"eloquent",
		"epic",
		"exciting",
		"fervent",
		"festive",
		"flamboyant",
		"focused",
		"friendly",
		"frosty",
		"funny",
		"gallant",
		"gifted",
		"goofy",
		"gracious",
		"great",
		"happy",
		"hardcore",
		"heuristic",
		"hopeful",
		"hungry",
		"infallible",
		"inspiring",
		"interesting",
		"intelligent",
		"jolly",
		"jovial",
		"keen",
		"kind",
		"laughing",
		"loving",
		"lucid",
		"magical",
		"mystifying",
		"modest",
		"musing",
		"naughty",
		"nervous",
		"nice",
		"nifty",
		"nostalgic",
		"objective",
		"optimistic",
		"peaceful",
		"pedantic",
		"pensive",
		"practical",
		"priceless",
		"quirky",
		"quizzical",
		"recursing",
		"relaxed",
		"reverent",
		"romantic",
		"sad",
		"serene",
		"sharp",
		"silly",
		"sleepy",
		"stoic",
		"strange",
		"stupefied",
		"suspicious",
		"sweet",
		"tender",
		"thirsty",
		"trusting",
		"unruffled",
		"upbeat",
		"vibrant",
		"vigilant",
		"vigorous",
		"wizardly",
		"wonderful",
		"xenodochial",
		"youthful",
		"zealous",
		"zen",
	}

	// Docker, starting from 0.7.x, generates names from notable scientists and hackers.
	// Please, for any amazing man that you add to the list, consider adding an equally amazing woman to it, and vice versa.
	right = [...]string{
		"Aardvark",
		"Albatross",
		"Alligator",
		"Alpaca",
		"Ant",
		"Anteater",
		"Antelope",
		"Ape",
		"Armadillo",
		"Donkey",
		"Baboon",
		"Badger",
		"Barracuda",
		"Bat",
		"Bear",
		"Beaver",
		"Bee",
		"Bison",
		"Boar",
		"Buffalo",
		"Butterfly",
		"Camel",
		"Capybara",
		"Caribou",
		"Cassowary",
		"Cat",
		"Caterpillar",
		"Cattle",
		"Chamois",
		"Cheetah",
		"Chicken",
		"Chimpanzee",
		"Chinchilla",
		"Chough",
		"Clam",
		"Cobra",
		"Cockroach",
		"Cod",
		"Cormorant",
		"Coyote",
		"Crab",
		"Crane",
		"Crocodile",
		"Crow",
		"Curlew",
		"Deer",
		"Dinosaur",
		"Dog",
		"Dogfish",
		"Dolphin",
		"Dotterel",
		"Dove",
		"Dragonfly",
		"Duck",
		"Dugong",
		"Dunlin",
		"Eagle",
		"Echidna",
		"Eel",
		"Eland",
		"Elephant",
		"Elk",
		"Emu",
		"Falcon",
		"Ferret",
		"Finch",
		"Fish",
		"Flamingo",
		"Fly",
		"Fox",
		"Frog",
		"Gaur",
		"Gazelle",
		"Gerbil",
		"Giraffe",
		"Gnat",
		"Gnu",
		"Goat",
		"Goldfinch",
		"Goldfish",
		"Goose",
		"Gorilla",
		"Goshawk",
		"Grasshopper",
		"Grouse",
		"Guanaco",
		"Gull",
		"Hamster",
		"Hare",
		"Hawk",
		"Hedgehog",
		"Heron",
		"Herring",
		"Hippopotamus",
		"Hornet",
		"Horse",
		"Human",
		"Hummingbird",
		"Hyena",
		"Ibex",
		"Ibis",
		"Jackal",
		"Jaguar",
		"Jay",
		"Jellyfish",
		"Kangaroo",
		"Kingfisher",
		"Koala",
		"Kookabura",
		"Kouprey",
		"Kudu",
		"Lapwing",
		"Lark",
		"Lemur",
		"Leopard",
		"Lion",
		"Llama",
		"Lobster",
		"Locust",
		"Loris",
		"Louse",
		"Lyrebird",
		"Magpie",
		"Mallard",
		"Manatee",
		"Mandrill",
		"Mantis",
		"Marten",
		"Meerkat",
		"Mink",
		"Mole",
		"Mongoose",
		"Monkey",
		"Moose",
		"Mosquito",
		"Mouse",
		"Mule",
		"Narwhal",
		"Newt",
		"Nightingale",
		"Octopus",
		"Okapi",
		"Opossum",
		"Oryx",
		"Ostrich",
		"Otter",
		"Owl",
		"Oyster",
		"Panther",
		"Parrot",
		"Partridge",
		"Peafowl",
		"Pelican",
		"Penguin",
		"Pheasant",
		"Pig",
		"Pigeon",
		"Pony",
		"Porcupine",
		"Porpoise",
		"Quail",
		"Quelea",
		"Quetzal",
		"Rabbit",
		"Raccoon",
		"Rail",
		"Ram",
		"Rat",
		"Raven",
		"Red deer",
		"Reindeer",
		"Rhinoceros",
		"Rook",
		"Salamander",
		"Salmon",
		"Sand Dollar",
		"Sandpiper",
		"Sardine",
		"Scorpion",
		"Seahorse",
		"Seal",
		"Shark",
		"Sheep",
		"Shrew",
		"Skunk",
		"Snail",
		"Snake",
		"Sparrow",
		"Spider",
		"Spoonbill",
		"Squid",
		"Squirrel",
		"Starling",
		"Stingray",
		"Stinkbug",
		"Stork",
		"Swallow",
		"Swan",
		"Tapir",
		"Tarsier",
		"Termite",
		"Tiger",
		"Toad",
		"Trout",
		"Turkey",
		"Turtle",
		"Viper",
		"Vulture",
		"Wallaby",
		"Walrus",
		"Wasp",
		"Weasel",
		"Whale",
		"Wildcat",
		"Wolf",
		"Wolverine",
		"Wombat",
		"Woodcock",
		"Woodpecker",
		"Worm",
		"Wren",
		"Yak",
	}
)

func init() {
	rand.Seed(time.Now().UTC().UnixNano())
}

// GetRandomName generates a random name from the list of adjectives
// and animals in this package
func GetRandomName() string {
begin:
	l := left[rand.Intn(len(left))]
	r := strings.ToLower(right[rand.Intn(len(right))])
	if l[0] != r[0] || strings.Contains(r," "){
		goto begin
	}

	return fmt.Sprintf("%s%s", l, r)
}
