---

title: Shopping List
description: All parts you need to build your own 68% Mechanical Keyboard! Find all information about the Circuit Board, Aluminium Case, and QMK Firmware. A complete shopping list helps you with ordering all parts, and a detailed guide with photos supports you in building your own keyboard!
image: /images/og/splash.jpg

next:
  link: /guide/case
  name: Aluminium Case

---

The [Printed Circuit Board][board] and [Aluminium Case][case] are the only custom parts you need to order, all other items are off-the-shelf, and you can find them on [eBay][ebay], [Amazon][amazon], and [Alibaba][alibaba]. Without a set of keycaps, you will spend around **80 USD** for all parts. With the optional parts, you will quickly hit *120 USD* and still have no keycaps&nbsp;…

### Custom Parts

<!-- <small>You can find discount codes for ordering the [Circuit Board](/guide/board) and the [Aluminium Case](/guide/case) for selected online shops on the respective pages!</small> -->

- [Aluminium Case: Bottom & Cover][case]
  <span>around 45 USD, depends on your vendor</span>
- [Printed Circuit Board][board]
  <span>starting at *3.81 USD* with [EasyEDA][eda]</span>

### Regular Parts

<!-- <small>Most items are available with free shipping. On the page explaining the [Circuit Board](/guide/board), you can find a discount code for ordering the Arduino controller!</small> -->

{{% parts "board" %}}
{{% parts "case" %}}

### Optional Parts

Your keyboard will work fine without the following parts. But, if you want to go an extra mile with this project, you should definitely order the [Shrink Kit](#shrink-kit) and these items.

- Anodized Aluminium
  <span>additional 45 USD, depends on your vendor</span>
- Cherry Dampeners
  <span>0.99 USD on [eBay](https://www.ebay.com/sch/i.html?_nkw=cherry+dampeners)</span>
- Silicone Dampeners Oil
  <span>2.47 USD on [eBay](https://www.ebay.com/sch/i.html?_nkw=silicone+dampeners+oil)</span>
- Rubber Bumper Feet
  <span>1.23 USD on [eBay](https://www.ebay.com/sch/i.html?_nkw=rubber+bumper-feet+self+adhesiv)</span>

### Shrink Kit

With a few modifications on the [Circuit Board][board] wiring, you can shrink the [Aluminium Case][case] down to **10mm** of height. You just need the following additional parts and, depending on your soldering skills, some patience.

{{% parts "shrink" %}}

<small>*The current version of this guide does not include any information how to assemble these parts. Hopefully this will be added in a future update.*</small>

### Recycling

If you don't want to spend the money and time to build an own keyboard, but still want a customizable one with 68 keys, you can order a [Magicforce68 keyboard](https://www.aliexpress.com/item/keyboard/32471875698.html) and replace the circuit board with [a custom one](/guide/board). The folks at [keeb.io](https://keeb.io/pages/magicforce-68-mf68-pcb-replacement-build-guide) have an excellent tutorial for this!

<!--

### Discounts

As mentioned above, discount codes for some items on the list are available. If you own a shop and would love to provide a special discount for some of the items above, please [get in contact](/legal) with me! I would love to feature your shop on these pages … 

-->

[case]: /guide/case
[board]: /guide/board
[ebay]: https://ebay.com
[amazon]: https://amazon.com
[alibaba]: https://alibaba.com
[lto]: http://www.laserteileonline.de/
[eda]: https://easyeda.com/order
