---

title: Custom 68% Mechanical Keyboard DIY Guide
description: Build your own 68% Mechanical Keyboard! Find all information about the Circuit Board, Aluminium Case, and QMK Firmware. A complete shopping list helps you with ordering all parts, and a detailed DIY guide with photos supports you in building your own keyboard!
image: /images/og/splash.jpg

aliases:
  - /guide

---

Welcome, Bonjour, and Moin! With the contents and DIY guide on [68Keys.io][1], you can build your own custom 68% Mechanical Keyboard! Sounds great, right? You will find all information about the needed [Circuit Board][2], [Aluminium Case][3], and modified [QMK firmware][4] on this site. With the detailed shopping list, you can start ordering parts and dive into building your DIY mechanical keyboard right away. Have fun!

![Custom 68% Mechanical Keyboard from 68Keys.io](/images/intro.jpg)

Being an enthusiast for mechanical keyboards, I switched to 60% keyboards from [KBParadise][5] a couple of months ago. I never regretted this decision, but all the time I had an eye on a beauty called [Varmilo VA68M][6]. When I read about the terrible macOS support, I was truly disappointed and started to read about building a custom DIY mechanical keyboard with 68 keys.

### How to use the DIY guide?

The content on this site is split up into three parts. Together with the [shopping list][7], you have all you need to start building your custom mechanical keyboard:

- [Aluminium Case][3]\
  <span>Simple, inexpensive, but beautiful case made of Aluminium</span>
- [Printed Circuit Boards][2]\
  <span>Custom circuit boards using an Arduino with ATmega32U4</span>
- [QMK Firmware][4]\
  <span>Programmable firmware based on the popular QMK core</span>

If you are ready to tackle this adventure, head over to the [shopping list][7]! When you received everything, start with assembling the [Aluminium Case][3] first, followed by soldering everything to the [Circuit Board][2], and finally load the [QMK Firmware][4] to your board&nbsp;…

### Requirements

I expect you already have a couple of things, most notable a screwdriver and a soldering iron. The needed screwdriver depends on the type of screws you chose for the case, and I cannot recommend any specific soldering Iron. I ordered an inexpensive one on Amazon a couple of years ago.

### License

This DIY guide is published using the [BY-NC-SA Creative Commons][8] license, and you can use all information and resources free of charge. However, I would love to hear your [feedback on twitter][9]!

Sources are available on [GitHub][10], please submit a [Pull Request][11] or file an [Issue][12] if you notice something strange on these pages.

### Thank You!

All this content would not exist without the great resources about mechanical keyboards already available online. Most important the [Keyboard Layout Editor][13], [Keyboard Case Builder][14], [Gerber files for the PCB][15], [QMK firmware][16], and many more.

Huge applause goes to [Hauke][17] for hooking me up with mechanical keyboards, my colleagues at the office that suffer from the clicky noise, and [Julia][18] for all the excellent photos. You guys are the best! 😘

[1]: /
[2]: /guide/board/
[3]: /guide/case/
[4]: /guide/firmware/
[5]: http://www.kbp.com.tw/
[6]: http://en.varmilo.com/
[7]: /parts
[8]: https://github.com/sbstjn/68Keys.io/blob/master/LICENSE.md
[9]: https://twitter.com/68keys
[10]: https://github.com/sbstjn/68keys.io
[11]: https://github.com/sbstjn/68keys.io/pulls
[12]: https://github.com/sbstjn/68keys.io/issues
[13]: http://www.keyboard-layout-editor.com/
[14]: http://builder.swillkb.com/
[15]: https://68keys.io/files/pcb.zip
[16]: https://github.com/sbstjn/qmk_firmware/tree/master/keyboards/68keys
[17]: https://twitter.com/einjungeauskiel
[18]: http://julia-kestner.de
