import { NextResponse } from "next/server";

export async function GET() {
  return NextResponse.json({
    data: {
      "CNN News": {
        all: "/api/cnn-news/",
        type: "/api/cnn-news/:type",
        listType: [
          "nasional",
          "internasional",
          "ekonomi",
          "olahraga",
          "teknologi",
          "hiburan",
          "gaya-hidup",
        ],
      },
      "CNBC News": {
        all: "/api/cnbc-news/",
        type: "/api/cnbc-news/:type",
        listType: [
          "market",
          "news",
          "entrepreneur",
          "syariah",
          "tech",
          "lifestyle",
        ],
      },
      "Republika News": {
        all: "/api/republika-news/",
        type: "/api/republika-news/:type",
        listType: [
          "news",
          "nusantara",
          "khazanah",
          "islam-digest",
          "internasional",
          "ekonomi",
          "sepakbola",
          "leisure",
        ],
      },
      "Tempo News": {
        all: "/api/tempo-news/",
        type: "/api/tempo-news/:type",
        listType: [
          "nasional",
          "bisnis",
          "metro",
          "dunia",
          "bola",
          "sport",
          "cantik",
          "tekno",
          "otomotif",
          "nusantara",
        ],
      },
      "Antara News": {
        type: "/api/antara-news/:type",
        listType: [
          "terkini",
          "top-news",
          "politik",
          "hukum",
          "ekonomi",
          "metro",
          "sepakbola",
          "olahraga",
          "humaniora",
          "lifestyle",
          "hiburan",
          "dunia",
          "infografik",
          "tekno",
          "otomotif",
          "warta-bumi",
          "rilis-pers",
        ],
      },
      "Okezone News": {
        all: "/api/okezone-news",
        listType: [
          "breaking",
          "sport",
          "economy",
          "lifestyle",
          "celebrity",
          "bola",
          "techno",
        ],
      },
      "BBC News": {
        all: "/api/bbc-news",
        listType: [
          "dunia",
          "berita_indonesia",
          "olahraga",
          "majalah",
          "multimedia",
        ],
      },
      "Kumparan News": {
        all: "/api/kumparan-news",
      },
      "Tribun News": {
        all: "/api/tribun-news",
        withZoneAndType: "/api/tribun-news/:zone/:type",
        zone: [
          "jakarta",
          "jabar",
          "mataram",
          "mataraman",
          "medan",
          "padang",
          "flores",
          "sulbar",
          "ambon",
          "wartakota",
          "bogor",
          "pantura",
          "madura",
          "palembang",
          "pekanbaru",
          "banjarmasin",
          "pontianak",
          "papua",
          "bekasi",
          "cirebon",
          "jogja",
          "bali",
          "bangka",
          "jambi",
          "kaltim",
          "palu",
          "papuabarat",
          "banten",
          "jateng",
          "jatim",
          "aceh",
          "batam",
          "sumsel",
          "kalteng",
          "makassar",
          "tangerang",
          "solo",
          "surabaya",
          "prohaba",
          "belitung",
          "lampung",
          "kaltara",
          "lombok",
          "depok",
          "banyumas",
          "suryamalang",
          "sultra",
          "babel",
          "kupang",
          "manado",
          "ternate",
        ],
        listType: [
          "bisnis",
          "superskor",
          "sport",
          "seleb",
          "lifestyle",
          "travel",
          "parapuan",
          "otomotif",
          "techno",
          "ramadan",
        ],
      },
      "Zetizen Jawapos News": {
        all: "/api/zetizen-jawapos-news",
        listType: [
          "book",
          "movie",
          "music",
          "tv-series",
          "beauty",
          "trend",
          "food-and-traveling",
          "games",
          "otomodif",
          "sport-and-health",
          "after-school",
          "career-coach",
          "dear-you",
          "get-a-life",
          "scholarship-info",
          "science",
          "techno",
          "zetizen-national-challenge",
        ],
      },
      Vice: {
        all: "/api/vice-news",
      },
      "Suara News": {
        all: "/api/suara-news",
        listType: [
          "news",
          "bisnis",
          "lifestyle",
          "entertainment",
          "otomotif",
          "tekno",
          "health",
          "mostpopular",
          "wawancara",
          "pressrelease",
        ],
      },
      "VOA Indonesia": {
        all: "/api/voa-news",
      },
    },
  });
}
