<div align="center">

<h1>Berita Indo API</h1>

<p>An API designed to showcase news from Indonesia.</p>

![berita-indo-api](https://socialify.git.ci/satyawikananda/berita-indo-api/image?description=1&forks=1&issues=1&logo=https%3A%2F%2Fi.pinimg.com%2Foriginals%2F26%2F91%2Ff2%2F2691f2fa1a0f078f5f274edf7fea6763.png&owner=1&pulls=1&stargazers=1&theme=Light)

</div>

> Dokumentasi untuk bahasa indonesia. [Klik disini](./README-ID.md)

## Description

The Berita Indo API, also known as the Indonesian News API, is designed to present various news from Indonesia, sourced from providers such as CNN News, CNBC News, and others. The data is extracted from RSS feeds and converted into JSON format, accessible through a Rest API. 

## List Endpoints Berita Indo API
You can see the list endpoint and its associated type either directly on the website or through this [code file](https://github.com/satyawikananda/berita-indo-api/blob/5af2ef203c11e9abeda675572e4affa3489439d4/src/app/api/route.ts#L4C29-L4C29).

> Every API endpoint includes a query parameter called 'search', which proves to be useful when you intend to search the API data based on the title.

## Installation

To incorporate this project into your own machine, you can easily install it by following the steps outlined below.

1. Clone this repository

```
git clone https://github.com/satyawikananda/berita-indo-api.git
```

2. Install dependencies

```
yarn install
```

> To run this program, simply use the command `yarn dev` in your terminal.

## Tech Stack

Regarding the tech stack, Berita Indo API utilizes:

1. [Next.js](https://nextjs.org/) - The React Framework
2. [Daisy UI](https://daisyui.com) - Tailwind CSS component library
3. [React Json Viewer](https://github.com/mac-s-g/react-json-view) - JSON viewer for react
4. [React Tweet](https://github.com/vercel/react-tweet) - Tweet embed for react app
5. [RSS Parser](https://github.com/rbren/rss-parser) - A lightweight RSS parser, for Node and the browser
6. [Fuse.js](https://www.fusejs.io/) - Powerful, lightweight fuzzy-search library, with zero dependencies.
7. [Vaul](https://vaul.emilkowal.ski/) - Drawer component for React.
8. [Snackbar](https://github.com/egoist/snackbar) - A tiny browser library for showing a brief message at the bottom of the screen

# Showcase

If you integrate this API into your project application, you have the option to register your project in the showcase provided below:

- [Berita.id](https://github.com/NicolaDonoastro/berita.id) Minimalist news platform by [NicolaDonoastro](https://github.com/NicolaDonoastro)
- [Mobile News Platform](https://github.com/indrapalijama/mobile-news-platform) Mobile News Apps using Ionic by [Indrapalijama](https://github.com/indrapalijama)
- [React CNN News](https://github.com/galanggg/react-cnn-news) Simple news app by [Galanggg](https://github.com/galanggg)
- [COnews](https://github.com/maulana2468/COnews) CNN & CNBC Mobile news app by [Maulana2468](https://github.com/maulana2468)
- [Newsid](https://github.com/ediruhiat/newsid) CLI Breaking news app app by [ediruhiat](https://github.com/ediruhiat)

# Support Me

You can support me on [Karya Karsa](https://karyakarsa.com/satyawikananda) and [Trakteer](https://trakteer.id/satya-wikananda/)

# Contribution

Interested in enhancing this project? You can actively contribute to it. I am fully receptive to any contributions that can help improve the project.

# Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="https://satyawikananda.vercel.app"><img src="https://avatars.githubusercontent.com/u/33148052?v=4?s=100" width="100px;" alt=""/><br /><sub><b>I Gusti Ngurah Satya Wikananda</b></sub></a><br /><a href="https://github.com/satyawikananda/berita-indo-api/commits?author=satyawikananda" title="Code">💻</a> <a href="#maintenance-satyawikananda" title="Maintenance">🚧</a> <a href="https://github.com/satyawikananda/berita-indo-api/issues?q=author%3Asatyawikananda" title="Bug reports">🐛</a> <a href="#ideas-satyawikananda" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/satyawikananda/berita-indo-api/commits?author=satyawikananda" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/galanggg"><img src="https://avatars.githubusercontent.com/u/21099312?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Galanggg</b></sub></a><br /><a href="https://github.com/satyawikananda/berita-indo-api/commits?author=galanggg" title="Code">💻</a> <a href="#ideas-galanggg" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://github.com/axmad386"><img src="https://avatars.githubusercontent.com/u/8775678?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Akhmad Salafudin</b></sub></a><br /><a href="https://github.com/satyawikananda/berita-indo-api/commits?author=axmad386" title="Code">💻</a> <a href="https://github.com/satyawikananda/berita-indo-api/issues?q=author%3Aaxmad386" title="Bug reports">🐛</a> <a href="#ideas-axmad386" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://kirintux.ninja/"><img src="https://avatars.githubusercontent.com/u/64598048?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Enggar Tivandi</b></sub></a><br /><a href="https://github.com/satyawikananda/berita-indo-api/commits?author=nekoding" title="Code">💻</a></td>
    <td align="center"><a href="https://www.linkedin.com/in/danar-noverawan-58a850184"><img src="https://avatars.githubusercontent.com/u/39963063?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Danar Noverawan</b></sub></a><br /><a href="https://github.com/satyawikananda/berita-indo-api/commits?author=danarn17" title="Code">💻</a> <a href="https://github.com/satyawikananda/berita-indo-api/commits?author=danarn17" title="Documentation">📖</a></td>
    <td align="center"><a href="http://indrapalijama.github.io"><img src="https://avatars.githubusercontent.com/u/33986004?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Indra Palijama</b></sub></a><br /><a href="https://github.com/satyawikananda/berita-indo-api/commits?author=indrapalijama" title="Code">💻</a> <a href="https://github.com/satyawikananda/berita-indo-api/commits?author=indrapalijama" title="Documentation">📖</a></td>
  </tr>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!

---

![forthebadge](https://forthebadge.com/images/badges/built-with-love.svg)
![forthebadge](https://forthebadge.com/images/badges/made-with-typescript.svg)
![vercelbadge](https://www.datocms-assets.com/31049/1618983297-powered-by-vercel.svg)

Powered by Next.js and Vercel. Code licensed under [MIT License](https://raw.githubusercontent.com/satyawikananda/berita-indo-api/main/LICENSE?token=AH44ZFF4GHAMNS4WIL4FCC3ADZ4F6).
