/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import oracle.jdbc.driver.T4CSocketOutputStreamWrapper;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;

class T4CSocketInputStreamWrapper
extends InputStream {
    static final int MAX_BUFFER_SIZE = 2048;
    NetInputStream is = null;
    T4CSocketOutputStreamWrapper os = null;
    boolean eof = false;
    byte[] buffer = new byte[2048];
    int bIndex = 0;
    int bytesAvailable;

    T4CSocketInputStreamWrapper(NetInputStream netInputStream, T4CSocketOutputStreamWrapper t4CSocketOutputStreamWrapper) throws IOException {
        this.is = netInputStream;
        this.os = t4CSocketOutputStreamWrapper;
    }

    public final int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.bytesAvailable < 1) {
            this.readNextPacket();
            if (this.eof) {
                return -1;
            }
        }
        --this.bytesAvailable;
        return this.buffer[this.bIndex++] & 0xFF;
    }

    public final int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.eof) {
            return 0;
        }
        if (this.bytesAvailable < n3) {
            int n4 = this.bytesAvailable;
            System.arraycopy(this.buffer, this.bIndex, byArray, n2, n4);
            this.bIndex += n4;
            this.bytesAvailable -= n4;
            this.is.read(byArray, n2 += n4, n3 - n4);
        } else {
            System.arraycopy(this.buffer, this.bIndex, byArray, n2, n3);
            this.bIndex += n3;
            this.bytesAvailable -= n3;
        }
        return n3;
    }

    void readNextPacket() throws IOException {
        this.os.flush();
        int n2 = this.is.read();
        if (n2 == -1) {
            this.eof = true;
            return;
        }
        this.buffer[0] = (byte)n2;
        this.bytesAvailable = this.is.available() + 1;
        int n3 = this.bytesAvailable = this.bytesAvailable > 2048 ? 2048 : this.bytesAvailable;
        if (this.bytesAvailable > 1) {
            this.is.read(this.buffer, 1, this.bytesAvailable - 1);
        }
        this.bIndex = 0;
    }

    int readB1() throws IOException {
        return this.read();
    }

    long readLongLSB(int n2) throws IOException {
        long l2 = 0L;
        boolean bl = false;
        if ((n2 & 0x80) > 0) {
            n2 &= 0x7F;
            bl = true;
        }
        int n3 = n2;
        int n4 = 0;
        while (n3 > 0) {
            if (this.bytesAvailable < 1) {
                this.readNextPacket();
            }
            l2 |= ((long)this.buffer[this.bIndex++] & 0xFFL) << 8 * n4;
            --this.bytesAvailable;
            --n3;
            ++n4;
        }
        return (long)(bl ? -1 : 1) * l2;
    }

    long readLongMSB(int n2) throws IOException {
        long l2 = 0L;
        boolean bl = false;
        if ((n2 & 0x80) > 0) {
            n2 &= 0x7F;
            bl = true;
        }
        for (int i2 = n2; i2 > 0; --i2) {
            if (this.bytesAvailable < 1) {
                this.readNextPacket();
            }
            l2 |= ((long)this.buffer[this.bIndex++] & 0xFFL) << 8 * (i2 - 1);
            --this.bytesAvailable;
        }
        return (long)(bl ? -1 : 1) * l2;
    }

    public boolean readZeroCopyIO(byte[] byArray, int n2, int[] nArray) throws IOException, NetException, BreakNetException {
        this.os.flush();
        return this.is.readZeroCopyIO(byArray, n2, nArray);
    }
}

