import styles from "./raycast.module.css";
import { motion } from "framer-motion";
import cn from "clsx";
import { NextSeo } from "next-seo";

function Raycast() {
  return (
    <main className={cn(styles.main, styles.crt)}>
      <div className={styles.center}>
        <motion.div
          style={{ position: "relative" }}
          initial={{ opacity: 0, scale: 0.9, y: 30 }}
          animate={{ opacity: 1, scale: 1, y: 0 }}
          transition={{ type: "spring", duration: 2, bounce: 0.35 }}
        >
          <button
            className={styles.key}
            onClick={() =>
              (window.location.href =
                "raycast://extensions/raycast/raycast/confetti")
            }
          >
            <div className={styles.keyInner}>
              <svg
                width="85"
                height="85"
                viewBox="0 0 300 300"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
                className={styles.logo}
              >
                <path
                  d="M75 193.5V225L0 150L15.75 134.25L75 193.5ZM106.5 225H75L150 300L165.75 284.25L106.5 225ZM284.25 165.75L300 150L150 0L134.25 15.75L193.5 75H157.5L116.25 33.75L100.5 49.5L126 75H108V191.25H225V173.25L250.5 198.75L266.25 183L225 142.5V106.5L284.25 165.75ZM82.5 67.5L67.5 83.25L84 99.75L99.75 84L82.5 67.5ZM216 200.25L200.25 216L216.75 232.5L232.5 217.5L216 200.25ZM49.5 100.5L33.75 116.25L75 157.5V126L49.5 100.5ZM173.25 225H142.5L183.75 266.25L199.5 250.5L173.25 225Z"
                  fill="#FF6161"
                />
              </svg>

              <div className={styles.logoBlur} />

              <svg
                xmlns="http://www.w3.org/2000/svg"
                version="1.1"
                viewBox="0 0 800 800"
                className={styles.bg}
              >
                <defs>
                  <filter
                    id="uuunion-blur"
                    x="-100%"
                    y="-100%"
                    width="400%"
                    height="400%"
                    color-interpolation-filters="sRGB"
                  >
                    <feGaussianBlur
                      in="SourceGraphic"
                      stdDeviation="22 22"
                      result="blur"
                    ></feGaussianBlur>
                    <feDropShadow
                      stdDeviation="80"
                      in="blur"
                      dx="65"
                      dy="65"
                      flood-color="#D94D65"
                      flood-opacity="0"
                      x="0%"
                      y="0%"
                      width="100%"
                      height="100%"
                    ></feDropShadow>
                  </filter>
                  <filter
                    id="uuunion-blur2"
                    x="-100%"
                    y="-100%"
                    width="400%"
                    height="400%"
                    color-interpolation-filters="sRGB"
                  >
                    <feGaussianBlur
                      in="SourceGraphic"
                      stdDeviation="22 22"
                      result="blur"
                    ></feGaussianBlur>
                    <feDropShadow
                      stdDeviation="80"
                      in="blur"
                      dx="-65"
                      dy="-65"
                      flood-color="#D94D65"
                      flood-opacity="0"
                      x="0%"
                      y="0%"
                      width="100%"
                      height="100%"
                    ></feDropShadow>
                  </filter>
                  <linearGradient
                    gradientTransform="rotate(67, 0.5, 0.5)"
                    x1="50%"
                    y1="0%"
                    x2="50%"
                    y2="100%"
                    id="uuunion-grad"
                  >
                    <stop stop-color="#3D1522" offset="10%"></stop>
                    <stop stop-color="#D94D65" offset="90%"></stop>
                  </linearGradient>
                  <linearGradient
                    gradientTransform="rotate(163, 0.5, 0.5)"
                    x1="50%"
                    y1="0%"
                    x2="50%"
                    y2="100%"
                    id="uuunion-grad2"
                  >
                    <stop stop-color="#3D1522" offset="25%"></stop>
                    <stop stop-color="#D94D65" offset="100%"></stop>
                  </linearGradient>
                  <linearGradient
                    gradientTransform="rotate(360, 0.5, 0.5)"
                    x1="50%"
                    y1="0%"
                    x2="50%"
                    y2="100%"
                    id="uuunion-grad3"
                  >
                    <stop stop-color="#3D1522" offset="0%"></stop>
                    <stop stop-color="#D94D65" offset="75%"></stop>
                  </linearGradient>
                </defs>
                <path
                  d="M-78.63 -79.98Q-64.07 -77.51 -49.51 -75.26 -34.95 -73.42 -20.38 -72.14 -5.82 -71.54 8.73 -71.66 23.29 -72.5 37.86 -73.98 52.42 -75.98 66.98 -78.32 81.54 -80.81 96.11 -83.23 110.67 -85.37 125.23 -87.05 139.8 -88.12 154.36 -88.49 168.92 -88.14 183.48 -87.09 198.05 -85.42 212.61 -83.29 227.17 -80.88 241.73 -78.39 256.3 -76.04 270.86 -74.03 285.42 -72.53 299.98 -71.67 314.55 -71.53 329.11 -72.11 343.67 -73.37 358.23 -75.2 372.8 -77.44 387.36 -79.9 401.92 -82.37 416.49 -84.63 431.05 -86.5 445.61 -87.81 460.17 -88.44 474.74 -88.35 489.3 -87.55 503.86 -86.09 518.42 -84.11 532.99 -81.78 547.55 -79.29 562.11 -76.87 576.67 -74.71 591.24 -73.01 605.8 -71.9 620.36 -71.5 634.92 -71.82 649.49 -72.84 664.05 -74.48 678.61 -76.59 693.17 -79 707.74 -81.49 722.3 -83.85 736.86 -85.88 751.43 -87.41 765.99 -88.29 780.55 -88.47 795.11 -87.92 809.68 -86.69 824.24 -84.88 838.8 -82.65 853.36 -80.2 855.79 -65.2 859.71 -50.21 864.9 -35.22 871.03 -20.22 877.71 -5.23 884.54 9.75 891.08 24.75 896.94 39.74 901.74 54.73 905.19 69.73 907.07 84.72 907.27 99.71 905.77 114.71 902.67 129.7 898.16 144.69 892.52 159.68 886.11 174.68 879.31 189.67 872.55 204.66 866.26 219.66 860.82 234.65 856.57 249.64 853.78 264.64 852.62 279.63 853.16 294.62 855.37 309.62 859.11 324.61 864.15 339.6 870.18 354.6 876.81 369.59 883.64 384.58 890.25 399.58 896.21 414.57 901.17 429.56 904.82 444.56 906.92 459.55 907.34 474.54 906.07 489.54 903.17 504.53 898.83 519.52 893.33 534.52 886.99 549.51 880.22 564.5 873.43 579.5 867.05 594.49 861.48 609.48 857.06 624.48 854.06 639.47 852.68 654.46 853 669.46 854.99 684.45 858.54 699.44 863.42 714.44 869.33 729.43 875.91 744.42 882.74 759.42 889.4 774.41 895.47 789.4 900.59 804.4 904.42 819.39 906.73 834.38 907.38 849.38 906.33 864.37 903.64 879.36 888.25 871.71 872.87 864.77 857.48 859.13 842.09 855.29 826.7 853.57 811.31 854.12 795.92 856.89 780.54 861.65 765.15 867.98 749.76 875.34 734.37 883.1 718.98 890.6 703.59 897.18 688.21 902.29 672.82 905.49 657.43 906.49 642.04 905.22 626.65 901.78 611.26 896.47 595.88 889.75 580.49 882.19 565.1 874.44 549.71 867.17 534.32 860.99 518.93 856.46 503.55 853.94 488.16 853.66 472.77 855.64 457.38 859.71 441.99 865.53 426.6 872.59 411.21 880.28 395.83 887.95 380.44 894.94 365.05 900.64 349.66 904.57 334.27 906.39 318.88 905.94 303.5 903.27 288.11 898.59 272.72 892.32 257.33 884.99 241.94 877.23 226.55 869.71 211.17 863.07 195.78 857.89 180.39 854.6 165 853.5 149.61 854.67 134.22 858.01 118.84 863.25 103.45 869.92 88.06 877.46 72.67 885.21 57.28 892.52 41.89 898.75 26.51 903.37 11.12 905.99 -4.26 906.37 -19.65 904.48 -35.04 900.5 -50.43 894.75 -65.81 887.73 -81.2 880.05 -81.34 865.05 -81.39 850.05 -81.36 835.05 -81.24 820.05 -81.05 805.05 -80.79 790.05 -80.48 775.05 -80.14 760.05 -79.79 745.05 -79.45 730.05 -79.15 715.05 -78.9 700.05 -78.72 685.04 -78.62 670.04 -78.6 655.04 -78.67 640.04 -78.82 625.04 -79.05 610.04 -79.33 595.04 -79.66 580.04 -80.01 565.04 -80.35 550.04 -80.68 535.04 -80.96 520.04 -81.18 505.04 -81.33 490.04 -81.39 475.04 -81.37 460.04 -81.26 445.03 -81.08 430.03 -80.82 415.03 -80.52 400.03 -80.18 385.03 -79.83 370.03 -79.49 355.03 -79.19 340.03 -78.93 325.03 -78.74 310.03 -78.62 295.03 -78.6 280.03 -78.66 265.03 -78.8 250.03 -79.02 235.03 -79.29 220.03 -79.61 205.03 -79.96 190.02 -80.31 175.02 -80.64 160.02 -80.92 145.02 -81.15 130.02 -81.31 115.02 -81.39 100.02 -81.38 85.02 -81.28 70.02 -81.11 55.02 -80.86 40.02 -80.56 25.02 -80.23 10.02 -79.88 -4.97 -79.54 -19.97 -79.22 -34.97 -78.96 -49.98 -78.76 -64.98 -78.63 -79.98"
                  fill="url(#uuunion-grad)"
                ></path>
                <path
                  d="M-78.63 -79.98Q-78.76 -64.98 -78.96 -49.98 -79.22 -34.97 -79.54 -19.97 -79.88 -4.97 -80.23 10.02 -80.56 25.02 -80.86 40.02 -81.11 55.02 -81.28 70.02 -81.38 85.02 -81.39 100.02 -81.31 115.02 -81.15 130.02 -80.92 145.02 -80.64 160.02 -80.31 175.02 -79.96 190.02 -79.61 205.03 -79.29 220.03 -79.02 235.03 -78.8 250.03 -78.66 265.03 -78.6 280.03 -78.62 295.03 -78.74 310.03 -78.93 325.03 -79.19 340.03 -79.49 355.03 -79.83 370.03 -80.18 385.03 -80.52 400.03 -70.41 403.44 -60.29 406.72 -50.18 409.74 -40.07 412.38 -29.96 414.55 -19.85 416.17 -0.89 417.4 2.38 417.48 14.85 410.43 27.24 402.41 39.55 393.53 51.78 383.95 63.93 373.89 76.01 363.58 88.02 353.27 99.97 343.18 111.88 333.55 123.74 324.57 135.57 316.4 147.38 309.13 159.19 302.81 171.01 297.44 182.85 292.95 194.73 289.21 206.66 286.08 218.65 283.35 230.73 280.82 242.89 278.25 255.16 275.43 267.53 272.17 280.03 268.29 292.66 263.65 305.42 258.19 318.31 251.86 331.35 244.68 344.52 236.72 357.83 228.09 371.27 218.96 384.83 209.49 398.5 199.88 412.28 190.33 426.15 181.04 440.1 172.19 454.1 163.92 468.15 156.33 482.21 149.51 496.28 143.46 510.33 138.16 524.33 133.55 538.28 129.51 552.13 125.9 565.88 122.55 579.51 119.3 592.98 115.96 606.29 112.35 619.42 108.34 632.35 103.78 645.07 98.61 657.56 92.75 669.83 86.2 681.86 79 693.66 71.22 705.21 62.95 716.53 54.32 727.62 45.49 738.49 36.62 749.16 27.85 759.63 19.34 769.93 11.21 780.07 3.57 790.09 -3.51 800 -9.99 792.81 -27.16 786.22 -44.34 780.81 -61.51 777.01 -78.68 775.15 -95.85 775.4 -113.02 777.72 -130.2 781.92 -147.37 767.33 -147.01 752.75 -146.06 738.17 -144.59 723.59 -142.73 709 -140.64 694.42 -138.5 679.84 -136.48 665.25 -134.76 650.67 -133.49 636.09 -132.76 621.51 -132.65 606.92 -133.17 592.34 -134.26 577.76 -135.84 563.17 -137.77 548.59 -139.89 534.01 -142.02 519.43 -143.98 504.84 -145.6 490.26 -146.74 475.68 -147.31 461.09 -147.27 446.51 -146.6 431.93 -145.38 417.35 -143.69 402.76 -141.7 388.18 -139.56 373.6 -137.46 359.01 -135.57 344.43 -134.06 329.85 -133.05 315.27 -132.63 300.68 -132.84 286.1 -133.65 271.52 -135 256.93 -136.78 242.35 -138.82 227.77 -140.97 213.18 -143.04 198.6 -144.84 184.02 -146.24 169.44 -147.1 154.85 -147.37 140.27 -147.01 125.69 -146.05 111.1 -144.58 96.52 -142.72 81.94 -140.63 67.36 -138.48 52.77 -136.47 38.19 -134.75 23.61 -133.48 9.02 -132.76 -5.55 -132.65 -20.13 -133.17 -34.71 -134.27 -49.3 -135.85 -63.88 -137.78 -78.46 -139.9 -93.05 -142.03 -107.63 -143.99 -122.21 -145.6 -131.55 -133.42 -114.57 -115.25 -105.53 -106.66 -96.54 -97.89 -87.58 -88.99 -78.63 -79.98"
                  fill="url(#uuunion-grad2)"
                  filter="url(#uuunion-blur)"
                ></path>
                <path
                  d="M809.35 382.5Q819.46 382.76 829.57 383.68 839.69 385.23 849.8 387.34 859.91 389.94 870.02 392.92 880.13 396.18 890.25 399.58 896.21 414.57 901.17 429.56 904.82 444.56 906.92 459.55 907.34 474.54 906.07 489.54 903.17 504.53 898.83 519.52 893.33 534.52 886.99 549.51 880.22 564.5 873.43 579.5 867.05 594.49 861.48 609.48 857.06 624.48 854.06 639.47 852.68 654.46 853 669.46 854.99 684.45 858.54 699.44 863.42 714.44 869.33 729.43 875.91 744.42 882.74 759.42 889.4 774.41 895.47 789.4 900.59 804.4 904.42 819.39 906.73 834.38 907.38 849.38 906.33 864.37 903.64 879.36 889.52 872.32 875.4 865.84 861.28 860.38 847.15 856.34 833.03 854.01 818.91 853.56 804.79 855.03 790.67 858.31 776.54 863.16 762.42 869.22 748.3 876.07 734.18 883.2 720.06 890.1 705.93 896.26 691.81 901.25 677.69 904.7 663.57 906.36 649.45 906.11 635.32 903.97 621.2 900.1 607.08 894.76 592.96 888.36 578.84 881.35 564.71 874.25 550.59 867.56 536.47 861.77 522.35 857.3 508.23 854.47 494.1 853.5 479.98 854.44 465.86 857.23 451.74 861.67 437.62 867.44 423.49 874.11 409.37 881.22 395.25 888.23 381.13 894.65 367.01 900.01 352.88 903.91 338.76 906.09 324.64 906.38 310.52 904.75 296.4 901.34 282.27 896.37 268.15 890.23 254.03 883.34 239.91 876.21 225.78 869.35 211.66 863.26 197.54 858.39 183.42 855.08 169.3 853.58 155.17 853.98 141.05 856.27 126.93 860.28 112.81 865.72 98.69 872.19 84.56 879.22 70.44 886.32 56.32 892.95 42.2 898.64 28.08 902.99 6.93 900.99 -0.04 886.11 -0.03 875.93 -0.03 865.74 -0.07 855.55 -0.13 845.37 -0.01 830.09 0.69 825 13.34 817.88 25.92 809.34 38.43 799.53 50.85 788.65 63.2 777.01 75.45 764.93 87.63 752.75 99.73 740.85 111.75 729.54 123.71 719.13 135.6 709.85 147.44 701.87 159.24 695.29 171.01 690.11 182.76 686.25 194.51 683.55 206.27 681.8 218.06 680.72 229.89 679.98 241.77 679.26 253.72 678.24 265.75 676.59 277.89 674.06 290.13 670.42 302.49 665.55 314.97 659.36 327.6 651.87 340.37 643.17 353.28 633.41 366.35 622.81 379.56 611.65 392.92 600.23 406.43 588.84 420.06 577.8 433.83 567.4 447.71 557.86 461.69 549.38 475.75 542.07 489.89 536 504.08 531.13 518.3 527.36 532.53 524.54 546.75 522.45 560.93 520.83 575.05 519.41 589.1 517.89 603.04 516 616.85 513.47 630.52 510.1 644.02 505.71 657.34 500.23 670.45 493.6 683.35 485.87 696.02 477.14 708.45 467.57 720.63 457.37 732.56 446.78 744.24 436.07 755.67 425.49 766.86 415.32 777.8 405.77 788.52 397.03 804.19 385.88 809.35 382.5"
                  fill="url(#uuunion-grad3)"
                  filter="url(#uuunion-blur2)"
                ></path>
              </svg>
            </div>
            <motion.div
              initial={{ opacity: 0 }}
              animate={{ opacity: 1 }}
              transition={{ delay: 0.15, duration: 1 }}
              style={{
                position: "absolute",
                zIndex: 2,
                top: 0,
                left: 0,
                right: 0,
                display: "flex",
                justifyContent: "center",
                alignItems: "center",
              }}
            >
              <div className={styles.glow1}></div>
              <div className={styles.glow2}></div>
              <div className={styles.glow3}></div>
              <div className={styles.glow4}></div>
            </motion.div>
          </button>
        </motion.div>
      </div>
    </main>
  );
}

export default function RaycastPage() {
  const title = "Raycast";
  const seoTitle = `${title} | Samuel Kraft`;
  const desc = `I'm joining Raycast as a design engineer`;
  const url = `https://samuelkraft.com/playground/raycast`;
  return (
    <>
      <NextSeo
        title={seoTitle}
        description={desc}
        canonical={url}
        openGraph={{
          title: seoTitle,
          url,
          description: desc,
          images: [
            {
              url: `https://og-image.samuelkraft.vercel.app/${encodeURIComponent(
                title
              )}?desc=${encodeURIComponent(desc)}&theme=dark.png`,
              alt: title,
            },
          ],
        }}
      />
      <div className="flex flex-col gap-8">
        <div className="flex flex-col gap-1">
          <h1 className="text-primary">{title}</h1>
          <p className="text-secondary">{desc}</p>
        </div>
        <div className="flex flex-col gap-4">
          <section className="overflow-hidden rounded-lg">
            <Raycast />
          </section>
        </div>
      </div>
    </>
  );
}
