#pragma once

namespace VSSynth
{
    /**
     * @brief Notes and their respective frequencies
     * 
     * Table pulled from https://pages.mtu.edu/~suits/notefreqs.html
     * Sharp notes and flat notes contain a lowercase s or b respectively.
     */
    namespace Notes
    {
        const double C0 = 16.35;
        const double Cs0 = 17.32;
        const double Db0 = 17.32;
        const double D0 = 18.35;
        const double Ds0 = 19.45;
        const double Eb0 = 19.45;
        const double E0 = 20.60;
        const double F0 = 21.83;
        const double Fs0 = 23.12;
        const double Gb0 = 23.12;
        const double G0 = 24.50;
        const double Gs0 = 25.96;
        const double Ab0 = 25.96;
        const double A0 = 27.50;
        const double As0 = 29.14;
        const double Bb0 = 29.14;
        const double B0 = 30.87;
        const double C1 = 32.70;
        const double Cs1 = 34.65;
        const double Db1 = 34.65;
        const double D1 = 36.71;
        const double Ds1 = 38.89;
        const double Eb1 = 38.89;
        const double E1 = 41.20;
        const double F1 = 43.65;
        const double Fs1 = 46.25;
        const double Gb1 = 46.25;
        const double G1 = 49.00;
        const double Gs1 = 51.91;
        const double Ab1 = 51.91;
        const double A1 = 55.00;
        const double As1 = 58.27;
        const double Bb1 = 58.27;
        const double B1 = 61.74;
        const double C2 = 65.41;
        const double Cs2 = 69.30;
        const double Db2 = 69.30;
        const double D2 = 73.42;
        const double Ds2 = 77.78;
        const double Eb2 = 77.78;
        const double E2 = 82.41;
        const double F2 = 87.31;
        const double Fs2 = 92.50;
        const double Gb2 = 92.50;
        const double G2 = 98.00;
        const double Gs2 = 103.83;
        const double Ab2 = 103.83;
        const double A2 = 110.00;
        const double As2 = 116.54;
        const double Bb2 = 116.54;
        const double B2 = 123.47;
        const double C3 = 130.81;
        const double Cs3 = 138.59;
        const double Db3 = 138.59;
        const double D3 = 146.83;
        const double Ds3 = 155.56;
        const double Eb3 = 155.56;
        const double E3 = 164.81;
        const double F3 = 174.61;
        const double Fs3 = 185.00;
        const double Gb3 = 185.00;
        const double G3 = 196.00;
        const double Gs3 = 207.65;
        const double Ab3 = 207.65;
        const double A3 = 220.00;
        const double As3 = 233.08;
        const double Bb3 = 233.08;
        const double B3 = 246.94;
        const double C4 = 261.63;
        const double Cs4 = 277.18;
        const double Db4 = 277.18;
        const double D4 = 293.66;
        const double Ds4 = 311.13;
        const double Eb4 = 311.13;
        const double E4 = 329.63;
        const double F4 = 349.23;
        const double Fs4 = 369.99;
        const double Gb4 = 369.99;
        const double G4 = 392.00;
        const double Gs4 = 415.30;
        const double Ab4 = 415.30;
        const double A4 = 440.00;
        const double As4 = 466.16;
        const double Bb4 = 466.16;
        const double B4 = 493.88;
        const double C5 = 523.25;
        const double Cs5 = 554.37;
        const double Db5 = 554.37;
        const double D5 = 587.33;
        const double Ds5 = 622.25;
        const double Eb5 = 622.25;
        const double E5 = 659.25;
        const double F5 = 698.46;
        const double Fs5 = 739.99;
        const double Gb5 = 739.99;
        const double G5 = 783.99;
        const double Gs5 = 830.61;
        const double Ab5 = 830.61;
        const double A5 = 880.00;
        const double As5 = 932.33;
        const double Bb5 = 932.33;
        const double B5 = 987.77;
        const double C6 = 1046.50;
        const double Cs6 = 1108.73;
        const double Db6 = 1108.73;
        const double D6 = 1174.66;
        const double Ds6 = 1244.51;
        const double Eb6 = 1244.51;
        const double E6 = 1318.51;
        const double F6 = 1396.91;
        const double Fs6 = 1479.98;
        const double Gb6 = 1479.98;
        const double G6 = 1567.98;
        const double Gs6 = 1661.22;
        const double Ab6 = 1661.22;
        const double A6 = 1760.00;
        const double As6 = 1864.66;
        const double Bb6 = 1864.66;
        const double B6 = 1975.53;
        const double C7 = 2093.00;
        const double Cs7 = 2217.46;
        const double Db7 = 2217.46;
        const double D7 = 2349.32;
        const double Ds7 = 2489.02;
        const double Eb7 = 2489.02;
        const double E7 = 2637.02;
        const double F7 = 2793.83;
        const double Fs7 = 2959.96;
        const double Gb7 = 2959.96;
        const double G7 = 3135.96;
        const double Gs7 = 3322.44;
        const double Ab7 = 3322.44;
        const double A7 = 3520.00;
        const double As7 = 3729.31;
        const double Bb7 = 3729.31;
        const double B7 = 3951.07;
        const double C8 = 4186.01;
        const double Cs8 = 4434.92;
        const double Db8 = 4434.92;
        const double D8 = 4698.63;
        const double Ds8 = 4978.03;
        const double Eb8 = 4978.03;
        const double E8 = 5274.04;
        const double F8 = 5587.65;
        const double Fs8 = 5919.91;
        const double Gb8 = 5919.91;
        const double G8 = 6271.93;
        const double Gs8 = 6644.88;
        const double Ab8 = 6644.88;
        const double A8 = 7040.00;
        const double As8 = 7458.62;
        const double Bb8 = 7458.62;
        const double B8 = 7902.13;
    } // namespace Notes
} // namespace VSSynth