# Salvo with OpenTelemetry OTLP Example

## open-telemetry-otlp
[otlp](https://opentelemetry.io/) High-quality, ubiquitous, and portable telemetry to enable effective observability

This example demonstrates how to integrate the Salvo web framework with OpenTelemetry OTLP for tracing and logging, using Jaeger as the backend for visualization.

## Prerequisites

- Rust and Cargo installed on your system.
- Docker installed for running Jaeger.

## Running Jaeger with Docker

Before running the application, you need to start Jaeger using Docker. This will set up Jaeger's UI and OTLP collector to receive telemetry data.

```bash
docker run -d -p 16686:16686 -p 4317:4317 -e COLLECTOR_OTLP_ENABLED=true jaegertracing/all-in-one:latest
```


## Running the Application
Build and run the application:
Access the example endpoint:
```bash 
curl http://localhost:5800/
You should see "Hello World" as the response. Traces for requests made to this endpoint will be sent to Jaeger.
```
## Viewing Traces
Open Jaeger UI in a web browser:
http://localhost:16686
Navigate to the Jaeger UI to view the traces and detailed telemetry data generated by interacting with the Salvo application.

