// Code generated by Prisma Client Rust. DO NOT EDIT

#![allow(warnings, unused)]
pub static DATAMODEL_STR: &'static str = include_str!("prisma/schema.prisma");
static DATABASE_STR: &'static str = "sqlite";
use ::prisma_client_rust::migrations::include_dir;
pub static MIGRATIONS_DIR: &::prisma_client_rust::migrations::include_dir::Dir =
    &::prisma_client_rust::migrations::include_dir::include_dir!("../salvo/examples/db_prisma_orm/prisma/migrations");
pub async fn new_client() -> Result<PrismaClient, ::prisma_client_rust::NewClientError> {
    PrismaClient::_builder().build().await
}
pub async fn new_client_with_url(url: &str) -> Result<PrismaClient, ::prisma_client_rust::NewClientError> {
    PrismaClient::_builder().with_url(url.to_string()).build().await
}
pub mod user {
    use super::_prisma::*;
    use super::*;
    pub mod id {
        use super::super::*;
        use super::_prisma::*;
        use super::{OrderByParam, SetParam, UniqueWhereParam, WhereParam, WithParam};
        pub fn set<T: From<Set>>(value: i32) -> T {
            Set(value).into()
        }
        pub fn equals<T: From<UniqueWhereParam>>(value: i32) -> T {
            UniqueWhereParam::IdEquals(value).into()
        }
        pub fn order(direction: ::prisma_client_rust::Direction) -> OrderByParam {
            OrderByParam::Id(direction)
        }
        pub fn in_vec(value: Vec<i32>) -> WhereParam {
            WhereParam::Id(_prisma::read_filters::IntFilter::InVec(value))
        }
        pub fn not_in_vec(value: Vec<i32>) -> WhereParam {
            WhereParam::Id(_prisma::read_filters::IntFilter::NotInVec(value))
        }
        pub fn lt(value: i32) -> WhereParam {
            WhereParam::Id(_prisma::read_filters::IntFilter::Lt(value))
        }
        pub fn lte(value: i32) -> WhereParam {
            WhereParam::Id(_prisma::read_filters::IntFilter::Lte(value))
        }
        pub fn gt(value: i32) -> WhereParam {
            WhereParam::Id(_prisma::read_filters::IntFilter::Gt(value))
        }
        pub fn gte(value: i32) -> WhereParam {
            WhereParam::Id(_prisma::read_filters::IntFilter::Gte(value))
        }
        pub fn not(value: i32) -> WhereParam {
            WhereParam::Id(_prisma::read_filters::IntFilter::Not(value))
        }
        pub fn increment(value: i32) -> SetParam {
            SetParam::IncrementId(value)
        }
        pub fn decrement(value: i32) -> SetParam {
            SetParam::DecrementId(value)
        }
        pub fn multiply(value: i32) -> SetParam {
            SetParam::MultiplyId(value)
        }
        pub fn divide(value: i32) -> SetParam {
            SetParam::DivideId(value)
        }
        pub struct Set(pub i32);
        impl From<Set> for SetParam {
            fn from(value: Set) -> Self {
                Self::SetId(value.0)
            }
        }
        pub struct Include;
        impl Into<super::IncludeParam> for Include {
            fn into(self) -> super::IncludeParam {
                super::IncludeParam::Id(self)
            }
        }
        impl Include {
            pub fn to_selection(self) -> ::prisma_client_rust::Selection {
                ::prisma_client_rust::Selection::builder("id").build()
            }
        }
        pub struct Select;
        impl Into<super::SelectParam> for Select {
            fn into(self) -> super::SelectParam {
                super::SelectParam::Id(self)
            }
        }
        impl Select {
            pub fn to_selection(self) -> ::prisma_client_rust::Selection {
                ::prisma_client_rust::Selection::builder("id").build()
            }
        }
    }
    pub mod username {
        use super::super::*;
        use super::_prisma::*;
        use super::{OrderByParam, SetParam, UniqueWhereParam, WhereParam, WithParam};
        pub fn set<T: From<Set>>(value: String) -> T {
            Set(value).into()
        }
        pub fn equals<T: From<UniqueWhereParam>>(value: String) -> T {
            UniqueWhereParam::UsernameEquals(value).into()
        }
        pub fn order(direction: ::prisma_client_rust::Direction) -> OrderByParam {
            OrderByParam::Username(direction)
        }
        pub fn in_vec(value: Vec<String>) -> WhereParam {
            WhereParam::Username(_prisma::read_filters::StringFilter::InVec(value))
        }
        pub fn not_in_vec(value: Vec<String>) -> WhereParam {
            WhereParam::Username(_prisma::read_filters::StringFilter::NotInVec(value))
        }
        pub fn lt(value: String) -> WhereParam {
            WhereParam::Username(_prisma::read_filters::StringFilter::Lt(value))
        }
        pub fn lte(value: String) -> WhereParam {
            WhereParam::Username(_prisma::read_filters::StringFilter::Lte(value))
        }
        pub fn gt(value: String) -> WhereParam {
            WhereParam::Username(_prisma::read_filters::StringFilter::Gt(value))
        }
        pub fn gte(value: String) -> WhereParam {
            WhereParam::Username(_prisma::read_filters::StringFilter::Gte(value))
        }
        pub fn contains(value: String) -> WhereParam {
            WhereParam::Username(_prisma::read_filters::StringFilter::Contains(value))
        }
        pub fn starts_with(value: String) -> WhereParam {
            WhereParam::Username(_prisma::read_filters::StringFilter::StartsWith(value))
        }
        pub fn ends_with(value: String) -> WhereParam {
            WhereParam::Username(_prisma::read_filters::StringFilter::EndsWith(value))
        }
        pub fn not(value: String) -> WhereParam {
            WhereParam::Username(_prisma::read_filters::StringFilter::Not(value))
        }
        pub struct Set(pub String);
        impl From<Set> for SetParam {
            fn from(value: Set) -> Self {
                Self::SetUsername(value.0)
            }
        }
        pub struct Include;
        impl Into<super::IncludeParam> for Include {
            fn into(self) -> super::IncludeParam {
                super::IncludeParam::Username(self)
            }
        }
        impl Include {
            pub fn to_selection(self) -> ::prisma_client_rust::Selection {
                ::prisma_client_rust::Selection::builder("username").build()
            }
        }
        pub struct Select;
        impl Into<super::SelectParam> for Select {
            fn into(self) -> super::SelectParam {
                super::SelectParam::Username(self)
            }
        }
        impl Select {
            pub fn to_selection(self) -> ::prisma_client_rust::Selection {
                ::prisma_client_rust::Selection::builder("username").build()
            }
        }
    }
    pub mod email {
        use super::super::*;
        use super::_prisma::*;
        use super::{OrderByParam, SetParam, UniqueWhereParam, WhereParam, WithParam};
        pub fn set<T: From<Set>>(value: String) -> T {
            Set(value).into()
        }
        pub fn equals(value: String) -> WhereParam {
            WhereParam::EmailEquals(value).into()
        }
        pub fn order(direction: ::prisma_client_rust::Direction) -> OrderByParam {
            OrderByParam::Email(direction)
        }
        pub fn in_vec(value: Vec<String>) -> WhereParam {
            WhereParam::Email(_prisma::read_filters::StringFilter::InVec(value))
        }
        pub fn not_in_vec(value: Vec<String>) -> WhereParam {
            WhereParam::Email(_prisma::read_filters::StringFilter::NotInVec(value))
        }
        pub fn lt(value: String) -> WhereParam {
            WhereParam::Email(_prisma::read_filters::StringFilter::Lt(value))
        }
        pub fn lte(value: String) -> WhereParam {
            WhereParam::Email(_prisma::read_filters::StringFilter::Lte(value))
        }
        pub fn gt(value: String) -> WhereParam {
            WhereParam::Email(_prisma::read_filters::StringFilter::Gt(value))
        }
        pub fn gte(value: String) -> WhereParam {
            WhereParam::Email(_prisma::read_filters::StringFilter::Gte(value))
        }
        pub fn contains(value: String) -> WhereParam {
            WhereParam::Email(_prisma::read_filters::StringFilter::Contains(value))
        }
        pub fn starts_with(value: String) -> WhereParam {
            WhereParam::Email(_prisma::read_filters::StringFilter::StartsWith(value))
        }
        pub fn ends_with(value: String) -> WhereParam {
            WhereParam::Email(_prisma::read_filters::StringFilter::EndsWith(value))
        }
        pub fn not(value: String) -> WhereParam {
            WhereParam::Email(_prisma::read_filters::StringFilter::Not(value))
        }
        pub struct Set(pub String);
        impl From<Set> for SetParam {
            fn from(value: Set) -> Self {
                Self::SetEmail(value.0)
            }
        }
        pub struct Include;
        impl Into<super::IncludeParam> for Include {
            fn into(self) -> super::IncludeParam {
                super::IncludeParam::Email(self)
            }
        }
        impl Include {
            pub fn to_selection(self) -> ::prisma_client_rust::Selection {
                ::prisma_client_rust::Selection::builder("email").build()
            }
        }
        pub struct Select;
        impl Into<super::SelectParam> for Select {
            fn into(self) -> super::SelectParam {
                super::SelectParam::Email(self)
            }
        }
        impl Select {
            pub fn to_selection(self) -> ::prisma_client_rust::Selection {
                ::prisma_client_rust::Selection::builder("email").build()
            }
        }
    }
    pub fn create(username: String, email: String, _params: Vec<SetParam>) -> (String, String, Vec<SetParam>) {
        (username, email, _params)
    }
    pub fn create_unchecked(
        username: String,
        email: String,
        _params: Vec<SetParam>,
    ) -> (String, String, Vec<SetParam>) {
        (username, email, _params)
    }
    #[macro_export]
    macro_rules ! _select_user { ($ (($ ($ func_arg : ident : $ func_arg_ty : ty) , +) =>) ? $ module_name : ident { $ ($ field : ident $ (($ ($ filters : tt) +) $ (. $ arg : ident ($ ($ arg_params : tt) *)) *) ? $ (: $ selection_mode : ident { $ ($ selections : tt) + }) ?) + }) => { # [allow (warnings)] pub mod $ module_name { $ crate :: prisma :: user :: select ! (@ definitions ; $ ($ field $ (($ ($ filters) +) $ (. $ arg ($ ($ arg_params) *)) *) ? $ (: $ selection_mode { $ ($ selections) + }) ?) +) ; pub struct Select (Vec < :: prisma_client_rust :: Selection >) ; impl :: prisma_client_rust :: select :: SelectType for Select { type Data = Data ; type ModelData = $ crate :: prisma :: user :: Data ; fn to_selections (self) -> Vec < :: prisma_client_rust :: Selection > { self . 0 } } use super :: * ; pub fn select ($ ($ ($ func_arg : $ func_arg_ty) , +) ?) -> Select { Select ($ crate :: prisma :: user :: select ! (@ selections_to_select_params ; : select { $ ($ field $ (($ ($ filters) +) $ (. $ arg ($ ($ arg_params) *)) *) ? $ (: $ selection_mode { $ ($ selections) + }) ?) + }) . into_iter () . map (| p | p . to_selection ()) . collect ()) } } } ; ({ $ ($ field : ident $ (($ ($ filters : tt) +) $ (. $ arg : ident ($ ($ arg_params : tt) *)) *) ? $ (: $ selection_mode : ident { $ ($ selections : tt) + }) ?) + }) => { { $ crate :: prisma :: user :: select ! (@ definitions ; $ ($ field $ (($ ($ filters) +) $ (. $ arg ($ ($ arg_params) *)) *) ? $ (: $ selection_mode { $ ($ selections) + }) ?) +) ; pub struct Select (Vec < :: prisma_client_rust :: Selection >) ; impl :: prisma_client_rust :: select :: SelectType for Select { type Data = Data ; type ModelData = $ crate :: prisma :: user :: Data ; fn to_selections (self) -> Vec < :: prisma_client_rust :: Selection > { self . 0 } } Select ($ crate :: prisma :: user :: select ! (@ selections_to_select_params ; : select { $ ($ field $ (($ ($ filters) +) $ (. $ arg ($ ($ arg_params) *)) *) ? $ (: $ selection_mode { $ ($ selections) + }) ?) + }) . into_iter () . map (| p | p . to_selection ()) . collect ()) } } ; (@ definitions ; $ ($ field : ident $ (($ ($ filters : tt) +) $ (. $ arg : ident ($ ($ arg_params : tt) *)) *) ? $ (: $ selection_mode : ident { $ ($ selections : tt) + }) ?) +) => { # [allow (warnings)] enum Fields { id , username , email } # [allow (warnings)] impl Fields { fn selections () { $ (let _ = Fields :: $ field ;) + } } # [allow (warnings)] # [derive (std :: fmt :: Debug , Clone)] pub struct Data { $ (pub $ field : $ crate :: prisma :: user :: select ! (@ field_type ; $ field $ (: $ selection_mode { $ ($ selections) + }) ?) ,) + } impl :: serde :: Serialize for Data { fn serialize < S > (& self , serializer : S) -> Result < S :: Ok , S :: Error > where S : :: serde :: Serializer , { use :: serde :: ser :: SerializeStruct ; let mut state = serializer . serialize_struct ("Data" , [$ (stringify ! ($ field) ,) +] . len ()) ? ; $ (state . serialize_field ($ crate :: prisma :: user :: select ! (@ field_serde_name ; $ field) , & self . $ field) ? ;) * state . end () } } impl < 'de > :: serde :: Deserialize < 'de > for Data { fn deserialize < D > (deserializer : D) -> Result < Self , D :: Error > where D : :: serde :: Deserializer < 'de > , { # [allow (warnings)] enum Field { $ ($ field) , + , } impl < 'de > :: serde :: Deserialize < 'de > for Field { fn deserialize < D > (deserializer : D) -> Result < Field , D :: Error > where D : :: serde :: Deserializer < 'de > , { struct FieldVisitor ; impl < 'de > :: serde :: de :: Visitor < 'de > for FieldVisitor { type Value = Field ; fn expecting (& self , formatter : & mut :: std :: fmt :: Formatter) -> :: std :: fmt :: Result { formatter . write_str (concat ! ($ ($ crate :: prisma :: user :: select ! (@ field_serde_name ; $ field) , ", ") , +)) } fn visit_str < E > (self , value : & str) -> Result < Field , E > where E : :: serde :: de :: Error , { match value { $ ($ crate :: prisma :: user :: select ! (@ field_serde_name ; $ field) => Ok (Field :: $ field)) , * , _ => Err (:: serde :: de :: Error :: unknown_field (value , FIELDS)) , } } } deserializer . deserialize_identifier (FieldVisitor) } } struct DataVisitor ; impl < 'de > :: serde :: de :: Visitor < 'de > for DataVisitor { type Value = Data ; fn expecting (& self , formatter : & mut std :: fmt :: Formatter) -> std :: fmt :: Result { formatter . write_str ("struct Data") } fn visit_map < V > (self , mut map : V) -> Result < Data , V :: Error > where V : :: serde :: de :: MapAccess < 'de > , { $ (let mut $ field = None ;) * while let Some (key) = map . next_key () ? { match key { $ (Field :: $ field => { if $ field . is_some () { return Err (:: serde :: de :: Error :: duplicate_field ($ crate :: prisma :: user :: select ! (@ field_serde_name ; $ field))) ; } $ field = Some (map . next_value () ?) ; }) * } } $ (let $ field = $ field . ok_or_else (|| serde :: de :: Error :: missing_field ($ crate :: prisma :: user :: select ! (@ field_serde_name ; $ field))) ? ;) * Ok (Data { $ ($ field) , * }) } } const FIELDS : & 'static [& 'static str] = & ["id" , "username" , "email"] ; deserializer . deserialize_struct ("Data" , FIELDS , DataVisitor) } } $ ($ (pub mod $ field { $ crate :: prisma :: user :: select ! (@ field_module ; $ field : $ selection_mode { $ ($ selections) + }) ; }) ?) + } ; (@ field_type ; id) => { i32 } ; (@ field_type ; username) => { String } ; (@ field_type ; email) => { String } ; (@ field_type ; $ field : ident $ ($ tokens : tt) *) => { compile_error ! (stringify ! (Cannot select field nonexistent field $ field on model "User" , available fields are "id, username, email")) } ; (@ field_module ; $ ($ tokens : tt) *) => { } ; (@ selection_field_to_selection_param ; id) => { Into :: < $ crate :: prisma :: user :: SelectParam > :: into ($ crate :: prisma :: user :: id :: Select) } ; (@ selection_field_to_selection_param ; username) => { Into :: < $ crate :: prisma :: user :: SelectParam > :: into ($ crate :: prisma :: user :: username :: Select) } ; (@ selection_field_to_selection_param ; email) => { Into :: < $ crate :: prisma :: user :: SelectParam > :: into ($ crate :: prisma :: user :: email :: Select) } ; (@ selection_field_to_selection_param ; $ ($ tokens : tt) *) => { compile_error ! (stringify ! ($ ($ tokens) *)) } ; (@ selections_to_select_params ; : $ macro_name : ident { $ ($ field : ident $ (($ ($ filters : tt) +) $ (. $ arg : ident ($ ($ arg_params : tt) *)) *) ? $ (: $ selection_mode : ident { $ ($ selections : tt) + }) ?) + }) => { [$ ($ crate :: prisma :: user :: $ macro_name ! (@ selection_field_to_selection_param ; $ field $ (($ ($ filters) +) $ (. $ arg ($ ($ arg_params) *)) *) ? $ (: $ selection_mode { $ ($ selections) + }) ?) ,) +] } ; (@ filters_to_args ;) => { vec ! [] } ; (@ filters_to_args ; $ ($ t : tt) *) => { $ ($ t) * } ; (@ field_serde_name ; id) => { "id" } ; (@ field_serde_name ; username) => { "username" } ; (@ field_serde_name ; email) => { "email" } ; }
    pub use _select_user as select;
    pub enum SelectParam {
        Id(id::Select),
        Username(username::Select),
        Email(email::Select),
    }
    impl SelectParam {
        pub fn to_selection(self) -> ::prisma_client_rust::Selection {
            match self {
                Self::Id(data) => data.to_selection(),
                Self::Username(data) => data.to_selection(),
                Self::Email(data) => data.to_selection(),
            }
        }
    }
    #[macro_export]
    macro_rules ! _include_user { ($ (($ ($ func_arg : ident : $ func_arg_ty : ty) , +) =>) ? $ module_name : ident { $ ($ field : ident $ (($ ($ filters : tt) +) $ (. $ arg : ident ($ ($ arg_params : tt) *)) *) ? $ (: $ selection_mode : ident { $ ($ selections : tt) + }) ?) + }) => { # [allow (warnings)] pub mod $ module_name { $ crate :: prisma :: user :: include ! (@ definitions ; $ ($ field $ (($ ($ filters) +) $ (. $ arg ($ ($ arg_params) *)) *) ? $ (: $ selection_mode { $ ($ selections) + }) ?) +) ; pub struct Include (Vec < :: prisma_client_rust :: Selection >) ; impl :: prisma_client_rust :: include :: IncludeType for Include { type Data = Data ; type ModelData = $ crate :: prisma :: user :: Data ; fn to_selections (self) -> Vec < :: prisma_client_rust :: Selection > { self . 0 } } use super :: * ; pub fn include ($ ($ ($ func_arg : $ func_arg_ty) , +) ?) -> Include { let mut selections = < $ crate :: prisma :: user :: Actions as :: prisma_client_rust :: ModelActions > :: scalar_selections () ; selections . extend ($ crate :: prisma :: user :: include ! (@ selections_to_include_params ; : include { $ ($ field $ (($ ($ filters) +) $ (. $ arg ($ ($ arg_params) *)) *) ? $ (: $ selection_mode { $ ($ selections) + }) ?) + }) . into_iter () . map (| p | p . to_selection ())) ; Include (selections) } } } ; ({ $ ($ field : ident $ (($ ($ filters : tt) +) $ (. $ arg : ident ($ ($ arg_params : tt) *)) *) ? $ (: $ selection_mode : ident { $ ($ selections : tt) + }) ?) + }) => { { $ crate :: prisma :: user :: include ! (@ definitions ; $ ($ field $ (($ ($ filters) +) $ (. $ arg ($ ($ arg_params) *)) *) ? $ (: $ selection_mode { $ ($ selections) + }) ?) +) ; pub struct Include (Vec < :: prisma_client_rust :: Selection >) ; impl :: prisma_client_rust :: include :: IncludeType for Include { type Data = Data ; type ModelData = $ crate :: prisma :: user :: Data ; fn to_selections (self) -> Vec < :: prisma_client_rust :: Selection > { self . 0 } } Include ({ let mut selections = < $ crate :: prisma :: user :: Actions as :: prisma_client_rust :: ModelActions > :: scalar_selections () ; selections . extend ($ crate :: prisma :: user :: include ! (@ selections_to_include_params ; : include { $ ($ field $ (($ ($ filters) +) $ (. $ arg ($ ($ arg_params) *)) *) ? $ (: $ selection_mode { $ ($ selections) + }) ?) + }) . into_iter () . map (| p | p . to_selection ())) ; selections }) } } ; (@ definitions ; $ ($ field : ident $ (($ ($ filters : tt) +) $ (. $ arg : ident ($ ($ arg_params : tt) *)) *) ? $ (: $ selection_mode : ident { $ ($ selections : tt) + }) ?) +) => { # [allow (warnings)] enum Fields { } # [allow (warnings)] impl Fields { fn selections () { $ (let _ = Fields :: $ field ;) + } } # [allow (warnings)] # [derive (std :: fmt :: Debug , Clone)] pub struct Data { pub id : i32 , pub username : String , pub email : String , $ (pub $ field : $ crate :: prisma :: user :: include ! (@ field_type ; $ field $ (: $ selection_mode { $ ($ selections) + }) ?) ,) + } impl :: serde :: Serialize for Data { fn serialize < S > (& self , serializer : S) -> Result < S :: Ok , S :: Error > where S : :: serde :: Serializer , { use :: serde :: ser :: SerializeStruct ; let mut state = serializer . serialize_struct ("Data" , [$ (stringify ! ($ field) ,) + stringify ! (id) , stringify ! (username) , stringify ! (email)] . len ()) ? ; $ (state . serialize_field ($ crate :: prisma :: user :: include ! (@ field_serde_name ; $ field) , & self . $ field) ? ;) * state . serialize_field ($ crate :: prisma :: user :: include ! (@ field_serde_name ; id) , & self . id) ? ; state . serialize_field ($ crate :: prisma :: user :: include ! (@ field_serde_name ; username) , & self . username) ? ; state . serialize_field ($ crate :: prisma :: user :: include ! (@ field_serde_name ; email) , & self . email) ? ; state . end () } } impl < 'de > :: serde :: Deserialize < 'de > for Data { fn deserialize < D > (deserializer : D) -> Result < Self , D :: Error > where D : :: serde :: Deserializer < 'de > , { # [allow (warnings)] enum Field { $ ($ field) , + , id , username , email } impl < 'de > :: serde :: Deserialize < 'de > for Field { fn deserialize < D > (deserializer : D) -> Result < Field , D :: Error > where D : :: serde :: Deserializer < 'de > , { struct FieldVisitor ; impl < 'de > :: serde :: de :: Visitor < 'de > for FieldVisitor { type Value = Field ; fn expecting (& self , formatter : & mut :: std :: fmt :: Formatter) -> :: std :: fmt :: Result { formatter . write_str (concat ! ($ ($ crate :: prisma :: user :: include ! (@ field_serde_name ; $ field) , ", ") , + , $ crate :: prisma :: user :: include ! (@ field_serde_name ; id) , ", " , $ crate :: prisma :: user :: include ! (@ field_serde_name ; username) , ", " , $ crate :: prisma :: user :: include ! (@ field_serde_name ; email) , ", ")) } fn visit_str < E > (self , value : & str) -> Result < Field , E > where E : :: serde :: de :: Error , { match value { $ ($ crate :: prisma :: user :: include ! (@ field_serde_name ; $ field) => Ok (Field :: $ field)) , * , $ crate :: prisma :: user :: include ! (@ field_serde_name ; id) => Ok (Field :: id) , $ crate :: prisma :: user :: include ! (@ field_serde_name ; username) => Ok (Field :: username) , $ crate :: prisma :: user :: include ! (@ field_serde_name ; email) => Ok (Field :: email) , _ => Err (:: serde :: de :: Error :: unknown_field (value , FIELDS)) , } } } deserializer . deserialize_identifier (FieldVisitor) } } struct DataVisitor ; impl < 'de > :: serde :: de :: Visitor < 'de > for DataVisitor { type Value = Data ; fn expecting (& self , formatter : & mut std :: fmt :: Formatter) -> std :: fmt :: Result { formatter . write_str ("struct Data") } fn visit_map < V > (self , mut map : V) -> Result < Data , V :: Error > where V : :: serde :: de :: MapAccess < 'de > , { $ (let mut $ field = None ;) * let mut id = None ; let mut username = None ; let mut email = None ; while let Some (key) = map . next_key () ? { match key { Field :: id => { if id . is_some () { return Err (:: serde :: de :: Error :: duplicate_field ($ crate :: prisma :: user :: include ! (@ field_serde_name ; id))) ; } id = Some (map . next_value () ?) ; } Field :: username => { if username . is_some () { return Err (:: serde :: de :: Error :: duplicate_field ($ crate :: prisma :: user :: include ! (@ field_serde_name ; username))) ; } username = Some (map . next_value () ?) ; } Field :: email => { if email . is_some () { return Err (:: serde :: de :: Error :: duplicate_field ($ crate :: prisma :: user :: include ! (@ field_serde_name ; email))) ; } email = Some (map . next_value () ?) ; } $ (Field :: $ field => { if $ field . is_some () { return Err (:: serde :: de :: Error :: duplicate_field ($ crate :: prisma :: user :: include ! (@ field_serde_name ; $ field))) ; } $ field = Some (map . next_value () ?) ; }) * } } $ (let $ field = $ field . ok_or_else (|| serde :: de :: Error :: missing_field ($ crate :: prisma :: user :: include ! (@ field_serde_name ; $ field))) ? ;) * let id = id . ok_or_else (|| serde :: de :: Error :: missing_field ($ crate :: prisma :: user :: include ! (@ field_serde_name ; id))) ? ; let username = username . ok_or_else (|| serde :: de :: Error :: missing_field ($ crate :: prisma :: user :: include ! (@ field_serde_name ; username))) ? ; let email = email . ok_or_else (|| serde :: de :: Error :: missing_field ($ crate :: prisma :: user :: include ! (@ field_serde_name ; email))) ? ; Ok (Data { id , username , email , $ ($ field) , * }) } } const FIELDS : & 'static [& 'static str] = & ["id" , "username" , "email"] ; deserializer . deserialize_struct ("Data" , FIELDS , DataVisitor) } } $ ($ (pub mod $ field { $ crate :: prisma :: user :: $ selection_mode ! (@ field_module ; $ field : $ selection_mode { $ ($ selections) + }) ; }) ?) + } ; (@ field_type ; $ field : ident $ ($ tokens : tt) *) => { compile_error ! (stringify ! (Cannot include nonexistent relation $ field on model "User" , available relations are "")) } ; (@ field_module ; $ ($ tokens : tt) *) => { } ; (@ selection_field_to_selection_param ; $ ($ tokens : tt) *) => { compile_error ! (stringify ! ($ ($ tokens) *)) } ; (@ selections_to_include_params ; : $ macro_name : ident { $ ($ field : ident $ (($ ($ filters : tt) +) $ (. $ arg : ident ($ ($ arg_params : tt) *)) *) ? $ (: $ selection_mode : ident { $ ($ selections : tt) + }) ?) + }) => { [$ ($ crate :: prisma :: user :: $ macro_name ! (@ selection_field_to_selection_param ; $ field $ (($ ($ filters) +) $ (. $ arg ($ ($ arg_params) *)) *) ? $ (: $ selection_mode { $ ($ selections) + }) ?) ,) +] } ; (@ filters_to_args ;) => { vec ! [] } ; (@ filters_to_args ; $ ($ t : tt) *) => { $ ($ t) * } ; (@ field_serde_name ; id) => { "id" } ; (@ field_serde_name ; username) => { "username" } ; (@ field_serde_name ; email) => { "email" } ; }
    pub use _include_user as include;
    pub enum IncludeParam {
        Id(id::Include),
        Username(username::Include),
        Email(email::Include),
    }
    impl IncludeParam {
        pub fn to_selection(self) -> ::prisma_client_rust::Selection {
            match self {
                Self::Id(data) => data.to_selection(),
                Self::Username(data) => data.to_selection(),
                Self::Email(data) => data.to_selection(),
            }
        }
    }
    #[derive(Debug, Clone, :: serde :: Serialize, :: serde :: Deserialize)]
    pub struct Data {
        #[serde(rename = "id")]
        pub id: i32,
        #[serde(rename = "username")]
        pub username: String,
        #[serde(rename = "email")]
        pub email: String,
    }
    impl Data {}
    #[derive(Clone)]
    pub enum WithParam {}
    impl Into<::prisma_client_rust::Selection> for WithParam {
        fn into(self) -> ::prisma_client_rust::Selection {
            match self {}
        }
    }
    #[derive(Clone)]
    pub enum SetParam {
        SetId(i32),
        IncrementId(i32),
        DecrementId(i32),
        MultiplyId(i32),
        DivideId(i32),
        SetUsername(String),
        SetEmail(String),
    }
    impl Into<(String, ::prisma_client_rust::PrismaValue)> for SetParam {
        fn into(self) -> (String, ::prisma_client_rust::PrismaValue) {
            match self {
                SetParam::SetId(value) => ("id".to_string(), ::prisma_client_rust::PrismaValue::Int(value as i64)),
                SetParam::IncrementId(value) => (
                    "id".to_string(),
                    ::prisma_client_rust::PrismaValue::Object(vec![(
                        "increment".to_string(),
                        ::prisma_client_rust::PrismaValue::Int(value as i64),
                    )]),
                ),
                SetParam::DecrementId(value) => (
                    "id".to_string(),
                    ::prisma_client_rust::PrismaValue::Object(vec![(
                        "decrement".to_string(),
                        ::prisma_client_rust::PrismaValue::Int(value as i64),
                    )]),
                ),
                SetParam::MultiplyId(value) => (
                    "id".to_string(),
                    ::prisma_client_rust::PrismaValue::Object(vec![(
                        "multiply".to_string(),
                        ::prisma_client_rust::PrismaValue::Int(value as i64),
                    )]),
                ),
                SetParam::DivideId(value) => (
                    "id".to_string(),
                    ::prisma_client_rust::PrismaValue::Object(vec![(
                        "divide".to_string(),
                        ::prisma_client_rust::PrismaValue::Int(value as i64),
                    )]),
                ),
                SetParam::SetUsername(value) => {
                    ("username".to_string(), ::prisma_client_rust::PrismaValue::String(value))
                }
                SetParam::SetEmail(value) => ("email".to_string(), ::prisma_client_rust::PrismaValue::String(value)),
            }
        }
    }
    #[derive(Clone)]
    pub enum OrderByParam {
        Id(::prisma_client_rust::Direction),
        Username(::prisma_client_rust::Direction),
        Email(::prisma_client_rust::Direction),
    }
    impl Into<(String, ::prisma_client_rust::PrismaValue)> for OrderByParam {
        fn into(self) -> (String, ::prisma_client_rust::PrismaValue) {
            match self {
                Self::Id(direction) => (
                    "id".to_string(),
                    ::prisma_client_rust::PrismaValue::String(direction.to_string()),
                ),
                Self::Username(direction) => (
                    "username".to_string(),
                    ::prisma_client_rust::PrismaValue::String(direction.to_string()),
                ),
                Self::Email(direction) => (
                    "email".to_string(),
                    ::prisma_client_rust::PrismaValue::String(direction.to_string()),
                ),
            }
        }
    }
    #[derive(Clone)]
    pub enum WhereParam {
        Not(Vec<WhereParam>),
        Or(Vec<WhereParam>),
        And(Vec<WhereParam>),
        IdEquals(i32),
        Id(_prisma::read_filters::IntFilter),
        UsernameEquals(String),
        Username(_prisma::read_filters::StringFilter),
        EmailEquals(String),
        Email(_prisma::read_filters::StringFilter),
    }
    impl ::prisma_client_rust::WhereInput for WhereParam {
        fn serialize(self) -> ::prisma_client_rust::SerializedWhereInput {
            let (name, value) = match self {
                Self::Not(value) => (
                    "NOT",
                    ::prisma_client_rust::SerializedWhereValue::Object(::prisma_client_rust::merge_fields(
                        value
                            .into_iter()
                            .map(::prisma_client_rust::WhereInput::serialize)
                            .map(Into::into)
                            .collect(),
                    )),
                ),
                Self::Or(value) => (
                    "OR",
                    ::prisma_client_rust::SerializedWhereValue::List(
                        value
                            .into_iter()
                            .map(::prisma_client_rust::WhereInput::serialize)
                            .map(Into::into)
                            .map(|v| vec![v])
                            .map(::prisma_client_rust::PrismaValue::Object)
                            .collect(),
                    ),
                ),
                Self::And(value) => (
                    "AND",
                    ::prisma_client_rust::SerializedWhereValue::Object(::prisma_client_rust::merge_fields(
                        value
                            .into_iter()
                            .map(::prisma_client_rust::WhereInput::serialize)
                            .map(Into::into)
                            .collect(),
                    )),
                ),
                Self::IdEquals(value) => (
                    "id",
                    ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "equals".to_string(),
                        ::prisma_client_rust::PrismaValue::Int(value as i64),
                    )]),
                ),
                Self::Id(value) => ("id", value.into()),
                Self::UsernameEquals(value) => (
                    "username",
                    ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "equals".to_string(),
                        ::prisma_client_rust::PrismaValue::String(value),
                    )]),
                ),
                Self::Username(value) => ("username", value.into()),
                Self::EmailEquals(value) => (
                    "email",
                    ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "equals".to_string(),
                        ::prisma_client_rust::PrismaValue::String(value),
                    )]),
                ),
                Self::Email(value) => ("email", value.into()),
            };
            ::prisma_client_rust::SerializedWhereInput::new(name, value.into())
        }
    }
    #[derive(Clone)]
    pub enum UniqueWhereParam {
        UsernameEquals(String),
        IdEquals(i32),
    }
    impl From<UniqueWhereParam> for WhereParam {
        fn from(value: UniqueWhereParam) -> Self {
            match value {
                UniqueWhereParam::UsernameEquals(value) => Self::UsernameEquals(value),
                UniqueWhereParam::IdEquals(value) => Self::IdEquals(value),
            }
        }
    }
    impl From<::prisma_client_rust::Operator<Self>> for WhereParam {
        fn from(op: ::prisma_client_rust::Operator<Self>) -> Self {
            match op {
                ::prisma_client_rust::Operator::Not(value) => Self::Not(value),
                ::prisma_client_rust::Operator::And(value) => Self::And(value),
                ::prisma_client_rust::Operator::Or(value) => Self::Or(value),
            }
        }
    }
    pub type UniqueArgs = ::prisma_client_rust::UniqueArgs<Actions<'static>>;
    pub type ManyArgs = ::prisma_client_rust::ManyArgs<Actions<'static>>;
    pub type Count<'a> = ::prisma_client_rust::Count<'a, Actions<'static>>;
    pub type Create<'a> = ::prisma_client_rust::Create<'a, Actions<'static>>;
    pub type CreateMany<'a> = ::prisma_client_rust::CreateMany<'a, Actions<'static>>;
    pub type FindUnique<'a> = ::prisma_client_rust::FindUnique<'a, Actions<'static>>;
    pub type FindMany<'a> = ::prisma_client_rust::FindMany<'a, Actions<'static>>;
    pub type FindFirst<'a> = ::prisma_client_rust::FindFirst<'a, Actions<'static>>;
    pub type Update<'a> = ::prisma_client_rust::Update<'a, Actions<'static>>;
    pub type UpdateMany<'a> = ::prisma_client_rust::UpdateMany<'a, Actions<'static>>;
    pub type Upsert<'a> = ::prisma_client_rust::Upsert<'a, Actions<'static>>;
    pub type Delete<'a> = ::prisma_client_rust::Delete<'a, Actions<'static>>;
    pub type DeleteMany<'a> = ::prisma_client_rust::DeleteMany<'a, Actions<'static>>;
    #[derive(Clone)]
    pub struct Actions<'a> {
        pub client: &'a ::prisma_client_rust::PrismaClientInternals,
    }
    impl ::prisma_client_rust::ModelActions for Actions<'_> {
        type Data = Data;
        type Where = WhereParam;
        type Set = SetParam;
        type With = WithParam;
        type OrderBy = OrderByParam;
        type Cursor = UniqueWhereParam;
        const MODEL: &'static str = "User";
        fn scalar_selections() -> Vec<::prisma_client_rust::Selection> {
            ["id", "username", "email"]
                .into_iter()
                .map(|o| {
                    let builder = ::prisma_client_rust::Selection::builder(o);
                    builder.build()
                })
                .collect()
        }
    }
    impl<'a> Actions<'a> {
        pub fn find_unique(self, _where: UniqueWhereParam) -> FindUnique<'a> {
            FindUnique::new(self.client, _where.into())
        }
        pub fn find_first(self, _where: Vec<WhereParam>) -> FindFirst<'a> {
            FindFirst::new(self.client, _where)
        }
        pub fn find_many(self, _where: Vec<WhereParam>) -> FindMany<'a> {
            FindMany::new(self.client, _where)
        }
        pub fn create(self, username: String, email: String, mut _params: Vec<SetParam>) -> Create<'a> {
            _params.push(username::set(username));
            _params.push(email::set(email));
            Create::new(self.client, _params)
        }
        pub fn update(self, _where: UniqueWhereParam, _params: Vec<SetParam>) -> Update<'a> {
            Update::new(self.client, _where.into(), _params, vec![])
        }
        pub fn update_many(self, _where: Vec<WhereParam>, _params: Vec<SetParam>) -> UpdateMany<'a> {
            UpdateMany::new(self.client, _where, _params)
        }
        pub fn upsert(
            self,
            _where: UniqueWhereParam,
            (username, email, mut _params): (String, String, Vec<SetParam>),
            _update: Vec<SetParam>,
        ) -> Upsert<'a> {
            _params.push(username::set(username));
            _params.push(email::set(email));
            Upsert::new(self.client, _where.into(), _params, _update)
        }
        pub fn delete(self, _where: UniqueWhereParam) -> Delete<'a> {
            Delete::new(self.client, _where.into(), vec![])
        }
        pub fn delete_many(self, _where: Vec<WhereParam>) -> DeleteMany<'a> {
            DeleteMany::new(self.client, _where)
        }
        pub fn count(self, _where: Vec<WhereParam>) -> Count<'a> {
            Count::new(self.client, _where)
        }
    }
}
pub mod _prisma {
    pub struct PrismaClientBuilder {
        url: Option<String>,
        action_notifier: ::prisma_client_rust::ActionNotifier,
    }
    impl PrismaClientBuilder {
        pub fn new() -> Self {
            Self {
                url: None,
                action_notifier: ::prisma_client_rust::ActionNotifier::new(),
            }
        }
        pub fn with_url(mut self, url: String) -> Self {
            self.url = Some(url);
            self
        }
        pub async fn build(self) -> Result<PrismaClient, ::prisma_client_rust::NewClientError> {
            let config = ::prisma_client_rust::datamodel::parse_configuration(super::DATAMODEL_STR)?.subject;
            let source = config
                .datasources
                .first()
                .expect("Please supply a datasource in your schema.prisma file");
            let url = match self.url {
                Some(url) => url,
                None => {
                    let url = if let Some(url) = source.load_shadow_database_url()? {
                        url
                    } else {
                        source.load_url(|key| std::env::var(key).ok())?
                    };
                    match url.starts_with("file:") {
                        true => {
                            let path = url.split(":").nth(1).unwrap();
                            if std::path::Path::new("./prisma/schema.prisma").exists() {
                                format!("file:./prisma/{}", path)
                            } else {
                                url
                            }
                        }
                        _ => url,
                    }
                }
            };
            let (db_name, executor) = ::prisma_client_rust::query_core::executor::load(&source, &[], &url).await?;
            let internal_model =
                ::prisma_client_rust::prisma_models::InternalDataModelBuilder::new(super::DATAMODEL_STR).build(db_name);
            let query_schema = std::sync::Arc::new(prisma_client_rust::query_core::schema_builder::build(
                internal_model,
                true,
                source.capabilities(),
                vec![],
                source.referential_integrity(),
            ));
            executor.primary_connector().get_connection().await?;
            Ok(PrismaClient(::prisma_client_rust::PrismaClientInternals {
                executor,
                query_schema,
                url,
                action_notifier: self.action_notifier,
            }))
        }
    }
    pub struct PrismaClient(::prisma_client_rust::PrismaClientInternals);
    impl ::std::fmt::Debug for PrismaClient {
        fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
            f.debug_struct("PrismaClient").finish()
        }
    }
    impl PrismaClient {
        pub fn _builder() -> PrismaClientBuilder {
            PrismaClientBuilder::new()
        }
        pub fn _query_raw<T: serde::de::DeserializeOwned>(
            &self,
            query: ::prisma_client_rust::Raw,
        ) -> ::prisma_client_rust::QueryRaw<T> {
            ::prisma_client_rust::QueryRaw::new(&self.0, query, super::DATABASE_STR)
        }
        pub fn _execute_raw(&self, query: ::prisma_client_rust::Raw) -> ::prisma_client_rust::ExecuteRaw {
            ::prisma_client_rust::ExecuteRaw::new(&self.0, query, super::DATABASE_STR)
        }
        pub async fn _batch<T: ::prisma_client_rust::BatchContainer<Marker>, Marker>(
            &self,
            queries: T,
        ) -> ::prisma_client_rust::Result<T::ReturnType> {
            ::prisma_client_rust::batch(queries, &self.0).await
        }
        pub async fn _migrate_deploy(&self) -> Result<(), ::prisma_client_rust::migrations::MigrateDeployError> {
            let res = ::prisma_client_rust::migrations::migrate_deploy(
                super::DATAMODEL_STR,
                super::MIGRATIONS_DIR,
                &self.0.url,
            )
            .await;
            ::prisma_client_rust::tokio::time::sleep(core::time::Duration::from_millis(1)).await;
            res
        }
        pub async fn _migrate_resolve(
            &self,
            migration: &str,
        ) -> Result<(), ::prisma_client_rust::migrations::MigrateResolveError> {
            ::prisma_client_rust::migrations::migrate_resolve(
                migration,
                super::DATAMODEL_STR,
                super::MIGRATIONS_DIR,
                &self.0.url,
            )
            .await
        }
        pub fn _db_push(&self) -> ::prisma_client_rust::migrations::DbPush {
            ::prisma_client_rust::migrations::db_push(super::DATAMODEL_STR, &self.0.url)
        }
        pub fn user(&self) -> super::user::Actions {
            super::user::Actions { client: &self.0 }
        }
    }
    #[derive(Debug, Clone, Copy, :: serde :: Serialize, :: serde :: Deserialize)]
    pub enum SortOrder {
        #[serde(rename = "asc")]
        Asc,
        #[serde(rename = "desc")]
        Desc,
    }
    impl ToString for SortOrder {
        fn to_string(&self) -> String {
            match self {
                Self::Asc => "asc".to_string(),
                Self::Desc => "desc".to_string(),
            }
        }
    }
    #[derive(Debug, Clone, Copy, :: serde :: Serialize, :: serde :: Deserialize)]
    pub enum TransactionIsolationLevel {
        #[serde(rename = "Serializable")]
        Serializable,
    }
    impl ToString for TransactionIsolationLevel {
        fn to_string(&self) -> String {
            match self {
                Self::Serializable => "Serializable".to_string(),
            }
        }
    }
    #[derive(Debug, Clone, Copy, :: serde :: Serialize, :: serde :: Deserialize)]
    pub enum UserScalarFieldEnum {
        #[serde(rename = "id")]
        Id,
        #[serde(rename = "username")]
        Username,
        #[serde(rename = "email")]
        Email,
    }
    impl ToString for UserScalarFieldEnum {
        fn to_string(&self) -> String {
            match self {
                Self::Id => "id".to_string(),
                Self::Username => "username".to_string(),
                Self::Email => "email".to_string(),
            }
        }
    }
    pub mod read_filters {
        use super::*;
        #[derive(Clone)]
        pub enum IntFilter {
            InVec(Vec<i32>),
            NotInVec(Vec<i32>),
            Lt(i32),
            Lte(i32),
            Gt(i32),
            Gte(i32),
            Not(i32),
        }
        impl Into<::prisma_client_rust::SerializedWhereValue> for IntFilter {
            fn into(self) -> ::prisma_client_rust::SerializedWhereValue {
                match self {
                    Self::InVec(value) => ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "in".to_string(),
                        ::prisma_client_rust::PrismaValue::List(
                            value
                                .into_iter()
                                .map(|v| ::prisma_client_rust::PrismaValue::Int(v as i64))
                                .collect(),
                        ),
                    )]),
                    Self::NotInVec(value) => ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "notIn".to_string(),
                        ::prisma_client_rust::PrismaValue::List(
                            value
                                .into_iter()
                                .map(|v| ::prisma_client_rust::PrismaValue::Int(v as i64))
                                .collect(),
                        ),
                    )]),
                    Self::Lt(value) => ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "lt".to_string(),
                        ::prisma_client_rust::PrismaValue::Int(value as i64),
                    )]),
                    Self::Lte(value) => ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "lte".to_string(),
                        ::prisma_client_rust::PrismaValue::Int(value as i64),
                    )]),
                    Self::Gt(value) => ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "gt".to_string(),
                        ::prisma_client_rust::PrismaValue::Int(value as i64),
                    )]),
                    Self::Gte(value) => ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "gte".to_string(),
                        ::prisma_client_rust::PrismaValue::Int(value as i64),
                    )]),
                    Self::Not(value) => ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "not".to_string(),
                        ::prisma_client_rust::PrismaValue::Int(value as i64),
                    )]),
                }
            }
        }
        #[derive(Clone)]
        pub enum StringFilter {
            InVec(Vec<String>),
            NotInVec(Vec<String>),
            Lt(String),
            Lte(String),
            Gt(String),
            Gte(String),
            Contains(String),
            StartsWith(String),
            EndsWith(String),
            Not(String),
        }
        impl Into<::prisma_client_rust::SerializedWhereValue> for StringFilter {
            fn into(self) -> ::prisma_client_rust::SerializedWhereValue {
                match self {
                    Self::InVec(value) => ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "in".to_string(),
                        ::prisma_client_rust::PrismaValue::List(
                            value
                                .into_iter()
                                .map(|v| ::prisma_client_rust::PrismaValue::String(v))
                                .collect(),
                        ),
                    )]),
                    Self::NotInVec(value) => ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "notIn".to_string(),
                        ::prisma_client_rust::PrismaValue::List(
                            value
                                .into_iter()
                                .map(|v| ::prisma_client_rust::PrismaValue::String(v))
                                .collect(),
                        ),
                    )]),
                    Self::Lt(value) => ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "lt".to_string(),
                        ::prisma_client_rust::PrismaValue::String(value),
                    )]),
                    Self::Lte(value) => ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "lte".to_string(),
                        ::prisma_client_rust::PrismaValue::String(value),
                    )]),
                    Self::Gt(value) => ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "gt".to_string(),
                        ::prisma_client_rust::PrismaValue::String(value),
                    )]),
                    Self::Gte(value) => ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "gte".to_string(),
                        ::prisma_client_rust::PrismaValue::String(value),
                    )]),
                    Self::Contains(value) => ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "contains".to_string(),
                        ::prisma_client_rust::PrismaValue::String(value),
                    )]),
                    Self::StartsWith(value) => ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "startsWith".to_string(),
                        ::prisma_client_rust::PrismaValue::String(value),
                    )]),
                    Self::EndsWith(value) => ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "endsWith".to_string(),
                        ::prisma_client_rust::PrismaValue::String(value),
                    )]),
                    Self::Not(value) => ::prisma_client_rust::SerializedWhereValue::Object(vec![(
                        "not".to_string(),
                        ::prisma_client_rust::PrismaValue::String(value),
                    )]),
                }
            }
        }
    }
}
pub use _prisma::PrismaClient;
