# Community Projects

If your project isn't listed here and you would like it to be, please feel free to create a PR.

## Community maintained modules

- [Socketioxide](https://github.com/Totodore/socketioxide): A socket.io server implementation in Rust that integrates with the Tower ecosystem and the Tokio stack.
- [Websocket](https://gitee.com/hubert22/salvo-websocket): This crate is websocket tool for salvo.
- [SalvoRsTool](https://github.com/mdddj/SalvoRsTool): salvo Idea RustRover插件 快速生成dto router service模板代码
- [protect-endpoints](https://github.com/DDtKey/protect-endpoints): Collection of crates to protect your endpoints
- [salvo-captcha](https://git.4rs.nl/awiteb/salvo-captcha): A captcha middleware for Salvo framework.
- [salvo-casbin](https://github.com/casbin-rs/salvo-casbin): Casbin access control hoop for salvo framework.

## Project showcase

- [AI00 RWKV Server](https://github.com/Ai00-X/ai00_server): AI00 RWKV Server is an inference API server based on the RWKV model..
- [Salvo Admin](https://github.com/lyqgit/salvo-admin): 基于salvo和Ruoyi-Vue3的rust快速开发框架.
- [Salvo Admin](https://github.com/feihua/salvo-admin): 基于salvo和rbatis的rbac权限管理系统.
- [Geospatial Web](https://gitlab.com/geospatialweb/rust-mvt-postgis): Rust REST API - Martin MVT Tile Server - PostGIS.
- [ALLEY](https://github.com/alley-rs/alley-transfer): Software for fast file transfer between terminals in the same network segment.
- [musicbot](https://github.com/AdrienPensart/musicbot): Music swiss army knife.
- [Replex](https://github.com/lostb1t/replex): Remix your Plex recommendations.
- [Pure Rust Instant Message(PRIM)](https://github.com/SuanCaiYv/prim): 使用纯Rust实现的即时通讯系统.
- [rblog](https://github.com/prabirshrestha/rblog): Blog engine written in rust.
- [myblog](https://github.com/driftluo/myblog): This is my personal blog.
- [opensound](https://github.com/opensound-org/opensound): Pro-Audio system engine, using `salvo` as the default HTTP server backend（专业音频系统引擎，使用`salvo`作为默认HTTP服务器后端）.
- [static-api](https://github.com/josejachuf/static-api-rs): This is a simple application emulating a basic REST API.
- [palpo](https://github.com/palpo-matrix-server/palpo): A Rust Matrix Server Implementation.
- [yiirs](https://github.com/shenghui0779/yiirs): Rust API 快速开发脚手架 (Salvo & Axum).
- [luxy](https://github.com/alley-rs/fluxy): Software for fast file transfer between terminals in the same network segment.
- [ffxiv-best-craft](https://github.com/Tnze/ffxiv-best-craft): A crafting simulator and solver for FF14 with friendly GUI.

## Tutorials
- [Rust Salvo零基础教程](https://www.bilibili.com/video/BV1FS421N71D/): Rust Salvo零基础入门教程.
- [使用Tera和Salvo构建单词本](https://www.bilibili.com/video/BV1Kg411b75s): 使用Tera和Salvo构建一个简单的单词本Web应用.
- [is salvo really the simplest rust web framework?](https://www.youtube.com/watch?v=tf9x97eTcpk)
- [Salvo.rs - Un Framework sencillo de Backend creado en Rust](https://www.youtube.com/watch?v=HlVf4mE8V9s)
- [rust + dioxus maybe | rust, salvo, dioxus live view, sqlx](https://www.youtube.com/watch?v=_j9tNhWbp8g)
- [rust + dockerfile + fly | rust, salvo, dioxus live view, sqlx, docker, fly.io](https://www.youtube.com/watch?v=IuyQxpbxjb8)
