/*
 Navicat Premium Data Transfer

 Source Server         : 127.0.0.1
 Source Server Type    : MySQL
 Source Server Version : 80025
 Source Host           : 127.0.0.1:3306
 Source Schema         : blog

 Target Server Type    : MySQL
 Target Server Version : 80025
 File Encoding         : 65001

 Date: 05/08/2022 09:54:31
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for gen_table
-- ----------------------------
DROP TABLE IF EXISTS `gen_table`;
CREATE TABLE `gen_table`  (
  `table_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '表名称',
  `table_comment` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '表描述',
  `sub_table_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '关联子表的表名',
  `sub_table_fk_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '子表关联的外键名',
  `class_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '实体类名称',
  `tpl_category` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT 'crud' COMMENT '使用的模板（crud单表操作 tree树表操作）',
  `package_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '生成包路径',
  `module_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '生成模块名',
  `business_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '生成业务名',
  `function_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '生成功能名',
  `function_author` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '生成功能作者',
  `gen_type` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '0' COMMENT '生成代码方式（0zip压缩包 1自定义路径）',
  `gen_path` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '/' COMMENT '生成路径（不填默认项目路径）',
  `options` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '其它生成选项',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`table_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '代码生成业务表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of gen_table
-- ----------------------------
INSERT INTO `gen_table` VALUES (1, 't_blog', '博客', NULL, NULL, 'TBlog', 'crud', 'com.salishBlog.business', 'tBlog', 'blog', '博客', 'salish', '0', '/', '{}', 'admin', '2022-07-21 15:03:18', '', '2022-07-21 15:25:52', NULL);
INSERT INTO `gen_table` VALUES (2, 't_tag', '标签', NULL, NULL, 'TTag', 'crud', 'com.salishBlog.business', 'tTag', 'tag', '标签', 'salishChen', '0', '/', '{}', 'admin', '2022-07-21 15:03:18', '', '2022-07-21 15:26:01', NULL);

-- ----------------------------
-- Table structure for gen_table_column
-- ----------------------------
DROP TABLE IF EXISTS `gen_table_column`;
CREATE TABLE `gen_table_column`  (
  `column_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '归属表编号',
  `column_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '列名称',
  `column_comment` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '列描述',
  `column_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '列类型',
  `java_type` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT 'JAVA类型',
  `java_field` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT 'JAVA字段名',
  `is_pk` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '是否主键（1是）',
  `is_increment` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '是否自增（1是）',
  `is_required` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '是否必填（1是）',
  `is_insert` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '是否为插入字段（1是）',
  `is_edit` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '是否编辑字段（1是）',
  `is_list` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '是否列表字段（1是）',
  `is_query` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '是否查询字段（1是）',
  `query_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT 'EQ' COMMENT '查询方式（等于、不等于、大于、小于、范围）',
  `html_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '显示类型（文本框、文本域、下拉框、复选框、单选框、日期控件）',
  `dict_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '字典类型',
  `sort` int(0) NULL DEFAULT NULL COMMENT '排序',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`column_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 17 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '代码生成业务表字段' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of gen_table_column
-- ----------------------------
INSERT INTO `gen_table_column` VALUES (1, '1', 'id', '博客id', 'int', 'Long', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', NULL, 1, 'admin', '2022-07-21 15:03:18', NULL, '2022-07-21 15:25:52');
INSERT INTO `gen_table_column` VALUES (2, '1', 'tltle', '标题', 'text', 'String', 'tltle', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 2, 'admin', '2022-07-21 15:03:18', NULL, '2022-07-21 15:25:52');
INSERT INTO `gen_table_column` VALUES (3, '1', 'cover', '封面', 'varchar(255)', 'String', 'cover', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2022-07-21 15:03:18', NULL, '2022-07-21 15:25:52');
INSERT INTO `gen_table_column` VALUES (4, '1', 'summary', '简介', 'varchar(255)', 'String', 'summary', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2022-07-21 15:03:18', NULL, '2022-07-21 15:25:52');
INSERT INTO `gen_table_column` VALUES (5, '1', 'content', '内容', 'text', 'String', 'content', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'editor', '', 5, 'admin', '2022-07-21 15:03:18', NULL, '2022-07-21 15:25:52');
INSERT INTO `gen_table_column` VALUES (6, '1', 'tag_id', '标签id', 'int', 'Long', 'tagId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2022-07-21 15:03:18', NULL, '2022-07-21 15:25:52');
INSERT INTO `gen_table_column` VALUES (7, '1', 'blog_type', '类型', 'varchar(50)', 'String', 'blogType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 7, 'admin', '2022-07-21 15:03:18', NULL, '2022-07-21 15:25:52');
INSERT INTO `gen_table_column` VALUES (8, '1', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', NULL, 9, 'admin', '2022-07-21 15:03:18', NULL, '2022-07-21 15:25:52');
INSERT INTO `gen_table_column` VALUES (9, '1', 'create_by', '创建人', 'varchar(50)', 'String', 'createBy', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', NULL, 10, 'admin', '2022-07-21 15:03:18', NULL, '2022-07-21 15:25:52');
INSERT INTO `gen_table_column` VALUES (10, '1', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', NULL, 11, 'admin', '2022-07-21 15:03:18', NULL, '2022-07-21 15:25:52');
INSERT INTO `gen_table_column` VALUES (11, '1', 'update_by', '更新人', 'varchar(50)', 'String', 'updateBy', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'input', NULL, 12, 'admin', '2022-07-21 15:03:18', NULL, '2022-07-21 15:25:52');
INSERT INTO `gen_table_column` VALUES (12, '1', 'is_delete', '是否删除', 'tinyint', 'Long', 'isDelete', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2022-07-21 15:03:18', NULL, '2022-07-21 15:25:52');
INSERT INTO `gen_table_column` VALUES (13, '2', 'id', '标签id', 'int', 'Long', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2022-07-21 15:03:18', '', '2022-07-21 15:26:01');
INSERT INTO `gen_table_column` VALUES (14, '2', 'tag', '标签', 'varchar(255)', 'String', 'tag', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2022-07-21 15:03:18', '', '2022-07-21 15:26:01');
INSERT INTO `gen_table_column` VALUES (15, '2', 'tag_color', '标签色彩', 'varchar(255)', 'String', 'tagColor', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2022-07-21 15:03:18', '', '2022-07-21 15:26:01');
INSERT INTO `gen_table_column` VALUES (16, '2', 'times', '访问次数', 'datetime', 'Date', 'times', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 4, 'admin', '2022-07-21 15:03:18', '', '2022-07-21 15:26:01');
INSERT INTO `gen_table_column` VALUES (17, '1', 'content_type', '内容类型', 'varchar(10)', 'String', 'contentType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 8, '', '2022-07-21 15:20:27', '', '2022-07-21 15:25:52');

-- ----------------------------
-- Table structure for sys_config
-- ----------------------------
DROP TABLE IF EXISTS `sys_config`;
CREATE TABLE `sys_config`  (
  `config_id` int(0) NOT NULL AUTO_INCREMENT COMMENT '参数主键',
  `config_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '参数名称',
  `config_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '参数键名',
  `config_value` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '参数键值',
  `config_type` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT 'N' COMMENT '系统内置（Y是 N否）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`config_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '参数配置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_config
-- ----------------------------
INSERT INTO `sys_config` VALUES (1, '主框架页-默认皮肤样式名称', 'sys.index.skinName', 'skin-blue', 'Y', 'admin', '2022-07-20 16:56:55', '', NULL, '蓝色 skin-blue、绿色 skin-green、紫色 skin-purple、红色 skin-red、黄色 skin-yellow');
INSERT INTO `sys_config` VALUES (2, '用户管理-账号初始密码', 'sys.user.initPassword', '123456', 'Y', 'admin', '2022-07-20 16:56:55', '', NULL, '初始化密码 123456');
INSERT INTO `sys_config` VALUES (3, '主框架页-侧边栏主题', 'sys.index.sideTheme', 'theme-dark', 'Y', 'admin', '2022-07-20 16:56:55', '', NULL, '深色主题theme-dark，浅色主题theme-light');
INSERT INTO `sys_config` VALUES (4, '账号自助-验证码开关', 'sys.account.captchaEnabled', 'true', 'Y', 'admin', '2022-07-20 16:56:55', '', NULL, '是否开启验证码功能（true开启，false关闭）');
INSERT INTO `sys_config` VALUES (5, '账号自助-是否开启用户注册功能', 'sys.account.registerUser', 'false', 'Y', 'admin', '2022-07-20 16:56:55', '', NULL, '是否开启注册用户功能（true开启，false关闭）');

-- ----------------------------
-- Table structure for sys_dept
-- ----------------------------
DROP TABLE IF EXISTS `sys_dept`;
CREATE TABLE `sys_dept`  (
  `dept_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '部门id',
  `parent_id` bigint(0) NULL DEFAULT 0 COMMENT '父部门id',
  `ancestors` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '祖级列表',
  `dept_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '部门名称',
  `order_num` int(0) NULL DEFAULT 0 COMMENT '显示顺序',
  `leader` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '负责人',
  `phone` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '联系电话',
  `email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '邮箱',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '0' COMMENT '部门状态（0正常 1停用）',
  `del_flag` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`dept_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 109 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '部门表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_dept
-- ----------------------------
INSERT INTO `sys_dept` VALUES (100, 0, '0', '若依科技', 0, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-07-20 16:56:48', '', NULL);
INSERT INTO `sys_dept` VALUES (101, 100, '0,100', '深圳总公司', 1, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-07-20 16:56:48', '', NULL);
INSERT INTO `sys_dept` VALUES (102, 100, '0,100', '长沙分公司', 2, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-07-20 16:56:48', '', NULL);
INSERT INTO `sys_dept` VALUES (103, 101, '0,100,101', '研发部门', 1, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-07-20 16:56:48', '', NULL);
INSERT INTO `sys_dept` VALUES (104, 101, '0,100,101', '市场部门', 2, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-07-20 16:56:48', '', NULL);
INSERT INTO `sys_dept` VALUES (105, 101, '0,100,101', '测试部门', 3, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-07-20 16:56:48', '', NULL);
INSERT INTO `sys_dept` VALUES (106, 101, '0,100,101', '财务部门', 4, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-07-20 16:56:48', '', NULL);
INSERT INTO `sys_dept` VALUES (107, 101, '0,100,101', '运维部门', 5, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-07-20 16:56:48', '', NULL);
INSERT INTO `sys_dept` VALUES (108, 102, '0,100,102', '市场部门', 1, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-07-20 16:56:48', '', NULL);
INSERT INTO `sys_dept` VALUES (109, 102, '0,100,102', '财务部门', 2, '若依', '15888888888', 'ry@qq.com', '0', '0', 'admin', '2022-07-20 16:56:48', '', NULL);

-- ----------------------------
-- Table structure for sys_dict_data
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict_data`;
CREATE TABLE `sys_dict_data`  (
  `dict_code` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '字典编码',
  `dict_sort` int(0) NULL DEFAULT 0 COMMENT '字典排序',
  `dict_label` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '字典标签',
  `dict_value` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '字典键值',
  `dict_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '字典类型',
  `css_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '样式属性（其他样式扩展）',
  `list_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '表格回显样式',
  `is_default` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT 'N' COMMENT '是否默认（Y是 N否）',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`dict_code`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 105 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '字典数据表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_dict_data
-- ----------------------------
INSERT INTO `sys_dict_data` VALUES (1, 1, '男', '0', 'sys_user_sex', '', '', 'Y', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '性别男');
INSERT INTO `sys_dict_data` VALUES (2, 2, '女', '1', 'sys_user_sex', '', '', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '性别女');
INSERT INTO `sys_dict_data` VALUES (3, 3, '未知', '2', 'sys_user_sex', '', '', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '性别未知');
INSERT INTO `sys_dict_data` VALUES (4, 1, '显示', '0', 'sys_show_hide', '', 'primary', 'Y', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '显示菜单');
INSERT INTO `sys_dict_data` VALUES (5, 2, '隐藏', '1', 'sys_show_hide', '', 'danger', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '隐藏菜单');
INSERT INTO `sys_dict_data` VALUES (6, 1, '正常', '0', 'sys_normal_disable', '', 'primary', 'Y', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '正常状态');
INSERT INTO `sys_dict_data` VALUES (7, 2, '停用', '1', 'sys_normal_disable', '', 'danger', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '停用状态');
INSERT INTO `sys_dict_data` VALUES (8, 1, '正常', '0', 'sys_job_status', '', 'primary', 'Y', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '正常状态');
INSERT INTO `sys_dict_data` VALUES (9, 2, '暂停', '1', 'sys_job_status', '', 'danger', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '停用状态');
INSERT INTO `sys_dict_data` VALUES (10, 1, '默认', 'DEFAULT', 'sys_job_group', '', '', 'Y', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '默认分组');
INSERT INTO `sys_dict_data` VALUES (11, 2, '系统', 'SYSTEM', 'sys_job_group', '', '', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '系统分组');
INSERT INTO `sys_dict_data` VALUES (12, 1, '是', 'Y', 'sys_yes_no', '', 'primary', 'Y', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '系统默认是');
INSERT INTO `sys_dict_data` VALUES (13, 2, '否', 'N', 'sys_yes_no', '', 'danger', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '系统默认否');
INSERT INTO `sys_dict_data` VALUES (14, 1, '通知', '1', 'sys_notice_type', '', 'warning', 'Y', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '通知');
INSERT INTO `sys_dict_data` VALUES (15, 2, '公告', '2', 'sys_notice_type', '', 'success', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '公告');
INSERT INTO `sys_dict_data` VALUES (16, 1, '正常', '0', 'sys_notice_status', '', 'primary', 'Y', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '正常状态');
INSERT INTO `sys_dict_data` VALUES (17, 2, '关闭', '1', 'sys_notice_status', '', 'danger', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '关闭状态');
INSERT INTO `sys_dict_data` VALUES (18, 1, '新增', '1', 'sys_oper_type', '', 'info', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '新增操作');
INSERT INTO `sys_dict_data` VALUES (19, 2, '修改', '2', 'sys_oper_type', '', 'info', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '修改操作');
INSERT INTO `sys_dict_data` VALUES (20, 3, '删除', '3', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '删除操作');
INSERT INTO `sys_dict_data` VALUES (21, 4, '授权', '4', 'sys_oper_type', '', 'primary', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '授权操作');
INSERT INTO `sys_dict_data` VALUES (22, 5, '导出', '5', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '导出操作');
INSERT INTO `sys_dict_data` VALUES (23, 6, '导入', '6', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '导入操作');
INSERT INTO `sys_dict_data` VALUES (24, 7, '强退', '7', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '强退操作');
INSERT INTO `sys_dict_data` VALUES (25, 8, '生成代码', '8', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '生成操作');
INSERT INTO `sys_dict_data` VALUES (26, 9, '清空数据', '9', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '清空操作');
INSERT INTO `sys_dict_data` VALUES (27, 1, '成功', '0', 'sys_common_status', '', 'primary', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '正常状态');
INSERT INTO `sys_dict_data` VALUES (28, 2, '失败', '1', 'sys_common_status', '', 'danger', 'N', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '停用状态');
INSERT INTO `sys_dict_data` VALUES (100, 1, '前端', '1', 'blog_type', NULL, 'default', 'N', '0', 'admin', '2022-07-21 17:26:54', 'admin', '2022-07-21 17:27:57', NULL);
INSERT INTO `sys_dict_data` VALUES (101, 2, '后端', '2', 'blog_type', NULL, 'default', 'N', '0', 'admin', '2022-07-21 17:26:59', 'admin', '2022-07-21 17:27:53', NULL);
INSERT INTO `sys_dict_data` VALUES (102, 3, '数据库', '3', 'blog_type', NULL, 'default', 'N', '0', 'admin', '2022-07-21 17:27:13', 'admin', '2022-07-21 17:27:50', NULL);
INSERT INTO `sys_dict_data` VALUES (103, 4, '实用教程', '4', 'blog_type', NULL, 'default', 'N', '0', 'admin', '2022-07-21 17:27:47', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (104, 1, 'markdown', '1', 'content_type', NULL, 'default', 'N', '0', 'admin', '2022-07-25 14:05:42', '', NULL, NULL);
INSERT INTO `sys_dict_data` VALUES (105, 2, '富文本', '2', 'content_type', NULL, 'default', 'N', '0', 'admin', '2022-07-25 14:05:49', '', NULL, NULL);

-- ----------------------------
-- Table structure for sys_dict_type
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict_type`;
CREATE TABLE `sys_dict_type`  (
  `dict_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '字典主键',
  `dict_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '字典名称',
  `dict_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '字典类型',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`dict_id`) USING BTREE,
  UNIQUE INDEX `dict_type`(`dict_type`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 101 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '字典类型表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_dict_type
-- ----------------------------
INSERT INTO `sys_dict_type` VALUES (1, '用户性别', 'sys_user_sex', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '用户性别列表');
INSERT INTO `sys_dict_type` VALUES (2, '菜单状态', 'sys_show_hide', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '菜单状态列表');
INSERT INTO `sys_dict_type` VALUES (3, '系统开关', 'sys_normal_disable', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '系统开关列表');
INSERT INTO `sys_dict_type` VALUES (4, '任务状态', 'sys_job_status', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '任务状态列表');
INSERT INTO `sys_dict_type` VALUES (5, '任务分组', 'sys_job_group', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '任务分组列表');
INSERT INTO `sys_dict_type` VALUES (6, '系统是否', 'sys_yes_no', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '系统是否列表');
INSERT INTO `sys_dict_type` VALUES (7, '通知类型', 'sys_notice_type', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '通知类型列表');
INSERT INTO `sys_dict_type` VALUES (8, '通知状态', 'sys_notice_status', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '通知状态列表');
INSERT INTO `sys_dict_type` VALUES (9, '操作类型', 'sys_oper_type', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '操作类型列表');
INSERT INTO `sys_dict_type` VALUES (10, '系统状态', 'sys_common_status', '0', 'admin', '2022-07-20 16:56:54', '', NULL, '登录状态列表');
INSERT INTO `sys_dict_type` VALUES (100, '博客类型', 'blog_type', '0', 'admin', '2022-07-21 17:26:31', '', NULL, NULL);
INSERT INTO `sys_dict_type` VALUES (101, '博文类型', 'content_type', '0', 'admin', '2022-07-25 14:05:31', '', NULL, NULL);

-- ----------------------------
-- Table structure for sys_job
-- ----------------------------
DROP TABLE IF EXISTS `sys_job`;
CREATE TABLE `sys_job`  (
  `job_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '任务ID',
  `job_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '' COMMENT '任务名称',
  `job_group` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT 'DEFAULT' COMMENT '任务组名',
  `invoke_target` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '调用目标字符串',
  `cron_expression` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT 'cron执行表达式',
  `misfire_policy` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '3' COMMENT '计划执行错误策略（1立即执行 2执行一次 3放弃执行）',
  `concurrent` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '1' COMMENT '是否并发执行（0允许 1禁止）',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '0' COMMENT '状态（0正常 1暂停）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '备注信息',
  PRIMARY KEY (`job_id`, `job_name`, `job_group`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '定时任务调度表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_job
-- ----------------------------
INSERT INTO `sys_job` VALUES (1, '系统默认（无参）', 'DEFAULT', 'ryTask.ryNoParams', '0/10 * * * * ?', '3', '1', '1', 'admin', '2022-07-20 16:56:55', '', NULL, '');
INSERT INTO `sys_job` VALUES (2, '系统默认（有参）', 'DEFAULT', 'ryTask.ryParams(\'ry\')', '0/15 * * * * ?', '3', '1', '1', 'admin', '2022-07-20 16:56:55', '', NULL, '');
INSERT INTO `sys_job` VALUES (3, '系统默认（多参）', 'DEFAULT', 'ryTask.ryMultipleParams(\'ry\', true, 2000L, 316.50D, 100)', '0/20 * * * * ?', '3', '1', '1', 'admin', '2022-07-20 16:56:55', '', NULL, '');

-- ----------------------------
-- Table structure for sys_job_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_job_log`;
CREATE TABLE `sys_job_log`  (
  `job_log_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '任务日志ID',
  `job_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '任务名称',
  `job_group` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '任务组名',
  `invoke_target` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '调用目标字符串',
  `job_message` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '日志信息',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '0' COMMENT '执行状态（0正常 1失败）',
  `exception_info` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '异常信息',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`job_log_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '定时任务调度日志表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_job_log
-- ----------------------------

-- ----------------------------
-- Table structure for sys_logininfor
-- ----------------------------
DROP TABLE IF EXISTS `sys_logininfor`;
CREATE TABLE `sys_logininfor`  (
  `info_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '访问ID',
  `user_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '用户账号',
  `ipaddr` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '登录IP地址',
  `login_location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '登录地点',
  `browser` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '浏览器类型',
  `os` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '操作系统',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '0' COMMENT '登录状态（0成功 1失败）',
  `msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '提示消息',
  `login_time` datetime(0) NULL DEFAULT NULL COMMENT '访问时间',
  PRIMARY KEY (`info_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 135 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '系统访问记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_logininfor
-- ----------------------------
INSERT INTO `sys_logininfor` VALUES (100, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-07-20 16:57:19');
INSERT INTO `sys_logininfor` VALUES (101, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '1', '验证码错误', '2022-07-21 13:53:36');
INSERT INTO `sys_logininfor` VALUES (102, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '1', '验证码错误', '2022-07-21 13:53:40');
INSERT INTO `sys_logininfor` VALUES (103, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '1', '验证码错误', '2022-07-21 13:53:43');
INSERT INTO `sys_logininfor` VALUES (104, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-07-21 13:53:48');
INSERT INTO `sys_logininfor` VALUES (105, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-07-21 15:03:00');
INSERT INTO `sys_logininfor` VALUES (106, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '1', '用户不存在/密码错误', '2022-07-21 15:25:14');
INSERT INTO `sys_logininfor` VALUES (107, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-07-21 15:25:22');
INSERT INTO `sys_logininfor` VALUES (108, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '1', '验证码错误', '2022-07-21 16:49:17');
INSERT INTO `sys_logininfor` VALUES (109, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-07-21 16:49:22');
INSERT INTO `sys_logininfor` VALUES (110, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-07-21 17:02:41');
INSERT INTO `sys_logininfor` VALUES (111, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-07-21 17:05:24');
INSERT INTO `sys_logininfor` VALUES (112, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-07-21 17:13:38');
INSERT INTO `sys_logininfor` VALUES (113, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '1', '验证码错误', '2022-07-25 13:46:28');
INSERT INTO `sys_logininfor` VALUES (114, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '1', '验证码错误', '2022-07-25 13:46:34');
INSERT INTO `sys_logininfor` VALUES (115, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-07-25 13:46:37');
INSERT INTO `sys_logininfor` VALUES (116, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-07-26 14:48:11');
INSERT INTO `sys_logininfor` VALUES (117, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-07-26 16:19:43');
INSERT INTO `sys_logininfor` VALUES (118, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-07-27 14:03:52');
INSERT INTO `sys_logininfor` VALUES (119, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-07-27 15:08:10');
INSERT INTO `sys_logininfor` VALUES (120, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '1', '验证码错误', '2022-07-28 09:43:53');
INSERT INTO `sys_logininfor` VALUES (121, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '1', '验证码错误', '2022-07-28 09:43:55');
INSERT INTO `sys_logininfor` VALUES (122, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-07-28 09:43:58');
INSERT INTO `sys_logininfor` VALUES (123, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '退出成功', '2022-07-28 09:44:45');
INSERT INTO `sys_logininfor` VALUES (124, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-07-28 13:51:59');
INSERT INTO `sys_logininfor` VALUES (125, 'root', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '1', '登录用户：root 不存在', '2022-07-29 16:31:30');
INSERT INTO `sys_logininfor` VALUES (126, 'root', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '1', '登录用户：root 不存在', '2022-07-29 16:31:37');
INSERT INTO `sys_logininfor` VALUES (127, 'root', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '1', '验证码错误', '2022-07-29 16:31:39');
INSERT INTO `sys_logininfor` VALUES (128, 'root', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '1', '验证码错误', '2022-07-29 16:31:44');
INSERT INTO `sys_logininfor` VALUES (129, 'root', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '1', '登录用户：root 不存在', '2022-07-29 16:31:47');
INSERT INTO `sys_logininfor` VALUES (130, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-07-29 16:31:58');
INSERT INTO `sys_logininfor` VALUES (131, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-08-01 09:10:18');
INSERT INTO `sys_logininfor` VALUES (132, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-08-02 09:54:13');
INSERT INTO `sys_logininfor` VALUES (133, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '1', '验证码错误', '2022-08-02 10:50:12');
INSERT INTO `sys_logininfor` VALUES (134, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-08-02 10:50:16');
INSERT INTO `sys_logininfor` VALUES (135, 'admin', '127.0.0.1', '内网IP', 'Chrome 9', 'Windows 7', '0', '登录成功', '2022-08-03 17:45:30');

-- ----------------------------
-- Table structure for sys_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_menu`;
CREATE TABLE `sys_menu`  (
  `menu_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '菜单ID',
  `menu_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '菜单名称',
  `parent_id` bigint(0) NULL DEFAULT 0 COMMENT '父菜单ID',
  `order_num` int(0) NULL DEFAULT 0 COMMENT '显示顺序',
  `path` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '路由地址',
  `component` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '组件路径',
  `query` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '路由参数',
  `is_frame` int(0) NULL DEFAULT 1 COMMENT '是否为外链（0是 1否）',
  `is_cache` int(0) NULL DEFAULT 0 COMMENT '是否缓存（0缓存 1不缓存）',
  `menu_type` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '菜单类型（M目录 C菜单 F按钮）',
  `visible` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '0' COMMENT '菜单状态（0显示 1隐藏）',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '0' COMMENT '菜单状态（0正常 1停用）',
  `perms` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '权限标识',
  `icon` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '#' COMMENT '菜单图标',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`menu_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2011 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '菜单权限表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_menu
-- ----------------------------
INSERT INTO `sys_menu` VALUES (1, '系统管理', 0, 111, 'system', NULL, '', 1, 0, 'M', '0', '0', '', 'system', 'admin', '2022-07-20 16:56:51', 'admin', '2022-07-21 15:26:29', '系统管理目录');
INSERT INTO `sys_menu` VALUES (2, '系统监控', 0, 112, 'monitor', NULL, '', 1, 0, 'M', '0', '0', '', 'monitor', 'admin', '2022-07-20 16:56:51', 'admin', '2022-07-21 15:26:34', '系统监控目录');
INSERT INTO `sys_menu` VALUES (3, '系统工具', 0, 100, 'tool', NULL, '', 1, 0, 'M', '0', '0', '', 'tool', 'admin', '2022-07-20 16:56:51', 'admin', '2022-07-21 15:26:24', '系统工具目录');
INSERT INTO `sys_menu` VALUES (4, '若依官网', 0, 9999, 'http://ruoyi.vip', NULL, '', 0, 0, 'M', '1', '1', '', 'guide', 'admin', '2022-07-20 16:56:51', 'admin', '2022-07-21 15:26:50', '若依官网地址');
INSERT INTO `sys_menu` VALUES (100, '用户管理', 1, 1, 'user', 'system/user/index', '', 1, 0, 'C', '0', '0', 'system:user:list', 'user', 'admin', '2022-07-20 16:56:51', '', NULL, '用户管理菜单');
INSERT INTO `sys_menu` VALUES (101, '角色管理', 1, 2, 'role', 'system/role/index', '', 1, 0, 'C', '0', '0', 'system:role:list', 'peoples', 'admin', '2022-07-20 16:56:51', '', NULL, '角色管理菜单');
INSERT INTO `sys_menu` VALUES (102, '菜单管理', 1, 3, 'menu', 'system/menu/index', '', 1, 0, 'C', '0', '0', 'system:menu:list', 'tree-table', 'admin', '2022-07-20 16:56:51', '', NULL, '菜单管理菜单');
INSERT INTO `sys_menu` VALUES (103, '部门管理', 1, 4, 'dept', 'system/dept/index', '', 1, 0, 'C', '0', '0', 'system:dept:list', 'tree', 'admin', '2022-07-20 16:56:51', '', NULL, '部门管理菜单');
INSERT INTO `sys_menu` VALUES (104, '岗位管理', 1, 5, 'post', 'system/post/index', '', 1, 0, 'C', '0', '0', 'system:post:list', 'post', 'admin', '2022-07-20 16:56:51', '', NULL, '岗位管理菜单');
INSERT INTO `sys_menu` VALUES (105, '字典管理', 1, 6, 'dict', 'system/dict/index', '', 1, 0, 'C', '0', '0', 'system:dict:list', 'dict', 'admin', '2022-07-20 16:56:51', '', NULL, '字典管理菜单');
INSERT INTO `sys_menu` VALUES (106, '参数设置', 1, 7, 'config', 'system/config/index', '', 1, 0, 'C', '0', '0', 'system:config:list', 'edit', 'admin', '2022-07-20 16:56:51', '', NULL, '参数设置菜单');
INSERT INTO `sys_menu` VALUES (107, '通知公告', 1, 8, 'notice', 'system/notice/index', '', 1, 0, 'C', '0', '0', 'system:notice:list', 'message', 'admin', '2022-07-20 16:56:51', '', NULL, '通知公告菜单');
INSERT INTO `sys_menu` VALUES (108, '日志管理', 1, 9, 'log', '', '', 1, 0, 'M', '0', '0', '', 'log', 'admin', '2022-07-20 16:56:51', '', NULL, '日志管理菜单');
INSERT INTO `sys_menu` VALUES (109, '在线用户', 2, 1, 'online', 'monitor/online/index', '', 1, 0, 'C', '0', '0', 'monitor:online:list', 'online', 'admin', '2022-07-20 16:56:51', '', NULL, '在线用户菜单');
INSERT INTO `sys_menu` VALUES (110, '定时任务', 2, 2, 'job', 'monitor/job/index', '', 1, 0, 'C', '0', '0', 'monitor:job:list', 'job', 'admin', '2022-07-20 16:56:51', '', NULL, '定时任务菜单');
INSERT INTO `sys_menu` VALUES (111, '数据监控', 2, 3, 'druid', 'monitor/druid/index', '', 1, 0, 'C', '0', '0', 'monitor:druid:list', 'druid', 'admin', '2022-07-20 16:56:51', '', NULL, '数据监控菜单');
INSERT INTO `sys_menu` VALUES (112, '服务监控', 2, 4, 'server', 'monitor/server/index', '', 1, 0, 'C', '0', '0', 'monitor:server:list', 'server', 'admin', '2022-07-20 16:56:51', '', NULL, '服务监控菜单');
INSERT INTO `sys_menu` VALUES (113, '缓存监控', 2, 5, 'cache', 'monitor/cache/index', '', 1, 0, 'C', '0', '0', 'monitor:cache:list', 'redis', 'admin', '2022-07-20 16:56:51', '', NULL, '缓存监控菜单');
INSERT INTO `sys_menu` VALUES (114, '缓存列表', 2, 6, 'cacheList', 'monitor/cache/list', '', 1, 0, 'C', '0', '0', 'monitor:cache:list', 'redis-list', 'admin', '2022-07-20 16:56:51', '', NULL, '缓存列表菜单');
INSERT INTO `sys_menu` VALUES (115, '表单构建', 3, 1, 'build', 'tool/build/index', '', 1, 0, 'C', '0', '0', 'tool:build:list', 'build', 'admin', '2022-07-20 16:56:51', '', NULL, '表单构建菜单');
INSERT INTO `sys_menu` VALUES (116, '代码生成', 3, 2, 'gen', 'tool/gen/index', '', 1, 0, 'C', '0', '0', 'tool:gen:list', 'code', 'admin', '2022-07-20 16:56:51', '', NULL, '代码生成菜单');
INSERT INTO `sys_menu` VALUES (117, '系统接口', 3, 3, 'swagger', 'tool/swagger/index', '', 1, 0, 'C', '0', '0', 'tool:swagger:list', 'swagger', 'admin', '2022-07-20 16:56:51', '', NULL, '系统接口菜单');
INSERT INTO `sys_menu` VALUES (500, '操作日志', 108, 1, 'operlog', 'monitor/operlog/index', '', 1, 0, 'C', '0', '0', 'monitor:operlog:list', 'form', 'admin', '2022-07-20 16:56:51', '', NULL, '操作日志菜单');
INSERT INTO `sys_menu` VALUES (501, '登录日志', 108, 2, 'logininfor', 'monitor/logininfor/index', '', 1, 0, 'C', '0', '0', 'monitor:logininfor:list', 'logininfor', 'admin', '2022-07-20 16:56:51', '', NULL, '登录日志菜单');
INSERT INTO `sys_menu` VALUES (1000, '用户查询', 100, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:user:query', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1001, '用户新增', 100, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:user:add', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1002, '用户修改', 100, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:user:edit', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1003, '用户删除', 100, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:user:remove', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1004, '用户导出', 100, 5, '', '', '', 1, 0, 'F', '0', '0', 'system:user:export', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1005, '用户导入', 100, 6, '', '', '', 1, 0, 'F', '0', '0', 'system:user:import', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1006, '重置密码', 100, 7, '', '', '', 1, 0, 'F', '0', '0', 'system:user:resetPwd', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1007, '角色查询', 101, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:role:query', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1008, '角色新增', 101, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:role:add', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1009, '角色修改', 101, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:role:edit', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1010, '角色删除', 101, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:role:remove', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1011, '角色导出', 101, 5, '', '', '', 1, 0, 'F', '0', '0', 'system:role:export', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1012, '菜单查询', 102, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:query', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1013, '菜单新增', 102, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:add', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1014, '菜单修改', 102, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:edit', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1015, '菜单删除', 102, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:menu:remove', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1016, '部门查询', 103, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:query', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1017, '部门新增', 103, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:add', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1018, '部门修改', 103, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:edit', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1019, '部门删除', 103, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:dept:remove', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1020, '岗位查询', 104, 1, '', '', '', 1, 0, 'F', '0', '0', 'system:post:query', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1021, '岗位新增', 104, 2, '', '', '', 1, 0, 'F', '0', '0', 'system:post:add', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1022, '岗位修改', 104, 3, '', '', '', 1, 0, 'F', '0', '0', 'system:post:edit', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1023, '岗位删除', 104, 4, '', '', '', 1, 0, 'F', '0', '0', 'system:post:remove', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1024, '岗位导出', 104, 5, '', '', '', 1, 0, 'F', '0', '0', 'system:post:export', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1025, '字典查询', 105, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:query', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1026, '字典新增', 105, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:add', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1027, '字典修改', 105, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:edit', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1028, '字典删除', 105, 4, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:remove', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1029, '字典导出', 105, 5, '#', '', '', 1, 0, 'F', '0', '0', 'system:dict:export', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1030, '参数查询', 106, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:query', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1031, '参数新增', 106, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:add', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1032, '参数修改', 106, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:edit', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1033, '参数删除', 106, 4, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:remove', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1034, '参数导出', 106, 5, '#', '', '', 1, 0, 'F', '0', '0', 'system:config:export', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1035, '公告查询', 107, 1, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:query', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1036, '公告新增', 107, 2, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:add', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1037, '公告修改', 107, 3, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:edit', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1038, '公告删除', 107, 4, '#', '', '', 1, 0, 'F', '0', '0', 'system:notice:remove', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1039, '操作查询', 500, 1, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:operlog:query', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1040, '操作删除', 500, 2, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:operlog:remove', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1041, '日志导出', 500, 4, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:operlog:export', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1042, '登录查询', 501, 1, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:logininfor:query', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1043, '登录删除', 501, 2, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:logininfor:remove', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1044, '日志导出', 501, 3, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:logininfor:export', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1045, '在线查询', 109, 1, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:online:query', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1046, '批量强退', 109, 2, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:online:batchLogout', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1047, '单条强退', 109, 3, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:online:forceLogout', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1048, '任务查询', 110, 1, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:query', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1049, '任务新增', 110, 2, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:add', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1050, '任务修改', 110, 3, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:edit', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1051, '任务删除', 110, 4, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:remove', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1052, '状态修改', 110, 5, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:changeStatus', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1053, '任务导出', 110, 7, '#', '', '', 1, 0, 'F', '0', '0', 'monitor:job:export', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1054, '生成查询', 115, 1, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:query', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1055, '生成修改', 115, 2, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:edit', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1056, '生成删除', 115, 3, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:remove', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1057, '导入代码', 115, 2, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:import', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1058, '预览代码', 115, 4, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:preview', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (1059, '生成代码', 115, 5, '#', '', '', 1, 0, 'F', '0', '0', 'tool:gen:code', '#', 'admin', '2022-07-20 16:56:51', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2000, '博客', 0, 1, 'blog', 'business/blog/index', NULL, 1, 0, 'C', '0', '0', 'business:blog:list', 'documentation', 'admin', '2022-07-21 15:21:38', 'admin', '2022-07-21 17:03:09', '博客菜单');
INSERT INTO `sys_menu` VALUES (2001, '博客查询', 2000, 1, '#', '', NULL, 1, 0, 'F', '0', '0', 'business:blog:query', '#', 'admin', '2022-07-21 15:21:38', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2002, '博客新增', 2000, 2, '#', '', NULL, 1, 0, 'F', '0', '0', 'business:blog:add', '#', 'admin', '2022-07-21 15:21:39', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2003, '博客修改', 2000, 3, '#', '', NULL, 1, 0, 'F', '0', '0', 'business:blog:edit', '#', 'admin', '2022-07-21 15:21:39', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2004, '博客删除', 2000, 4, '#', '', NULL, 1, 0, 'F', '0', '0', 'business:blog:remove', '#', 'admin', '2022-07-21 15:21:39', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2005, '博客导出', 2000, 5, '#', '', NULL, 1, 0, 'F', '0', '0', 'business:blog:export', '#', 'admin', '2022-07-21 15:21:39', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2006, '标签', 0, 2, 'tag', 'business/tag/index', NULL, 1, 0, 'C', '0', '0', 'buisiness:tag:list', 'rate', 'admin', '2022-07-21 15:21:47', 'admin', '2022-07-21 17:21:11', '标签菜单');
INSERT INTO `sys_menu` VALUES (2007, '标签查询', 2006, 1, '#', '', NULL, 1, 0, 'F', '0', '0', 'buisiness:tag:query', '#', 'admin', '2022-07-21 15:21:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2008, '标签新增', 2006, 2, '#', '', NULL, 1, 0, 'F', '0', '0', 'buisiness:tag:add', '#', 'admin', '2022-07-21 15:21:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2009, '标签修改', 2006, 3, '#', '', NULL, 1, 0, 'F', '0', '0', 'buisiness:tag:edit', '#', 'admin', '2022-07-21 15:21:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2010, '标签删除', 2006, 4, '#', '', NULL, 1, 0, 'F', '0', '0', 'buisiness:tag:remove', '#', 'admin', '2022-07-21 15:21:47', '', NULL, '');
INSERT INTO `sys_menu` VALUES (2011, '标签导出', 2006, 5, '#', '', NULL, 1, 0, 'F', '0', '0', 'buisiness:tag:export', '#', 'admin', '2022-07-21 15:21:47', '', NULL, '');

-- ----------------------------
-- Table structure for sys_notice
-- ----------------------------
DROP TABLE IF EXISTS `sys_notice`;
CREATE TABLE `sys_notice`  (
  `notice_id` int(0) NOT NULL AUTO_INCREMENT COMMENT '公告ID',
  `notice_title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '公告标题',
  `notice_type` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '公告类型（1通知 2公告）',
  `notice_content` longblob NULL COMMENT '公告内容',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '0' COMMENT '公告状态（0正常 1关闭）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`notice_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '通知公告表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_notice
-- ----------------------------
INSERT INTO `sys_notice` VALUES (1, '温馨提醒：2018-07-01 若依新版本发布啦', '2', 0xE696B0E78988E69CACE58685E5AEB9, '0', 'admin', '2022-07-20 16:56:56', '', NULL, '管理员');
INSERT INTO `sys_notice` VALUES (2, '维护通知：2018-07-01 若依系统凌晨维护', '1', 0xE7BBB4E68AA4E58685E5AEB9, '0', 'admin', '2022-07-20 16:56:56', '', NULL, '管理员');

-- ----------------------------
-- Table structure for sys_oper_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_oper_log`;
CREATE TABLE `sys_oper_log`  (
  `oper_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '日志主键',
  `title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '模块标题',
  `business_type` int(0) NULL DEFAULT 0 COMMENT '业务类型（0其它 1新增 2修改 3删除）',
  `method` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '方法名称',
  `request_method` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '请求方式',
  `operator_type` int(0) NULL DEFAULT 0 COMMENT '操作类别（0其它 1后台用户 2手机端用户）',
  `oper_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '操作人员',
  `dept_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '部门名称',
  `oper_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '请求URL',
  `oper_ip` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '主机地址',
  `oper_location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '操作地点',
  `oper_param` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '请求参数',
  `json_result` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '返回参数',
  `status` int(0) NULL DEFAULT 0 COMMENT '操作状态（0正常 1异常）',
  `error_msg` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '错误消息',
  `oper_time` datetime(0) NULL DEFAULT NULL COMMENT '操作时间',
  PRIMARY KEY (`oper_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 180 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '操作日志记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_oper_log
-- ----------------------------
INSERT INTO `sys_oper_log` VALUES (100, '菜单管理', 3, 'com.salishBlog.web.controller.system.SysMenuController.remove()', 'DELETE', 1, 'admin', NULL, '/system/menu/4', '127.0.0.1', '内网IP', '{menuId=4}', '{\"msg\":\"菜单已分配,不允许删除\",\"code\":500}', 0, NULL, '2022-07-21 13:54:21');
INSERT INTO `sys_oper_log` VALUES (101, '菜单管理', 3, 'com.salishBlog.web.controller.system.SysMenuController.remove()', 'DELETE', 1, 'admin', NULL, '/system/menu/4', '127.0.0.1', '内网IP', '{menuId=4}', '{\"msg\":\"菜单已分配,不允许删除\",\"code\":500}', 0, NULL, '2022-07-21 13:54:28');
INSERT INTO `sys_oper_log` VALUES (102, '菜单管理', 2, 'com.salishBlog.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"createTime\":\"2022-07-20 16:56:51\",\"icon\":\"guide\",\"isCache\":\"0\",\"isFrame\":\"0\",\"menuId\":4,\"menuName\":\"若依官网\",\"menuType\":\"M\",\"orderNum\":4,\"params\":{},\"parentId\":0,\"path\":\"http://ruoyi.vip\",\"perms\":\"\",\"query\":\"\",\"status\":\"1\",\"updateBy\":\"admin\",\"visible\":\"1\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 13:54:37');
INSERT INTO `sys_oper_log` VALUES (103, '菜单管理', 3, 'com.salishBlog.web.controller.system.SysMenuController.remove()', 'DELETE', 1, 'admin', NULL, '/system/menu/4', '127.0.0.1', '内网IP', '{menuId=4}', '{\"msg\":\"菜单已分配,不允许删除\",\"code\":500}', 0, NULL, '2022-07-21 13:54:39');
INSERT INTO `sys_oper_log` VALUES (104, '菜单管理', 3, 'com.salishBlog.web.controller.system.SysMenuController.remove()', 'DELETE', 1, 'admin', NULL, '/system/menu/4', '127.0.0.1', '内网IP', '{menuId=4}', '{\"msg\":\"菜单已分配,不允许删除\",\"code\":500}', 0, NULL, '2022-07-21 13:54:50');
INSERT INTO `sys_oper_log` VALUES (105, '代码生成', 6, 'com.salishBlog.generator.controller.GenController.importTableSave()', 'POST', 1, 'admin', NULL, '/tool/gen/importTable', '127.0.0.1', '内网IP', 't_blog,t_tag', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 15:03:18');
INSERT INTO `sys_oper_log` VALUES (106, '代码生成', 2, 'com.salishBlog.generator.controller.GenController.editSave()', 'PUT', 1, 'admin', NULL, '/tool/gen', '127.0.0.1', '内网IP', '{\"businessName\":\"blog\",\"className\":\"TBlog\",\"columns\":[{\"capJavaField\":\"Id\",\"columnComment\":\"博客id\",\"columnId\":1,\"columnName\":\"id\",\"columnType\":\"int\",\"createBy\":\"admin\",\"createTime\":\"2022-07-21 15:03:18\",\"dictType\":\"\",\"edit\":false,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isPk\":\"1\",\"javaField\":\"id\",\"javaType\":\"Long\",\"list\":false,\"params\":{},\"pk\":true,\"query\":false,\"queryType\":\"EQ\",\"required\":false,\"sort\":1,\"superColumn\":false,\"tableId\":1,\"updateBy\":\"\",\"usableColumn\":false},{\"capJavaField\":\"Tltle\",\"columnComment\":\"标题\",\"columnId\":2,\"columnName\":\"tltle\",\"columnType\":\"text\",\"createBy\":\"admin\",\"createTime\":\"2022-07-21 15:03:18\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"textarea\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"javaField\":\"tltle\",\"javaType\":\"String\",\"list\":true,\"params\":{},\"pk\":false,\"query\":true,\"queryType\":\"EQ\",\"required\":false,\"sort\":2,\"superColumn\":false,\"tableId\":1,\"updateBy\":\"\",\"usableColumn\":false},{\"capJavaField\":\"Cover\",\"columnComment\":\"封面\",\"columnId\":3,\"columnName\":\"cover\",\"columnType\":\"varchar(255)\",\"createBy\":\"admin\",\"createTime\":\"2022-07-21 15:03:18\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"javaField\":\"cover\",\"javaType\":\"String\",\"list\":true,\"params\":{},\"pk\":false,\"query\":true,\"queryType\":\"EQ\",\"required\":false,\"sort\":3,\"superColumn\":false,\"tableId\":1,\"updateBy\":\"\",\"usableColumn\":false},{\"capJavaField\":\"Summary\",\"columnComment\":\"简介\",\"columnId\":4,\"columnName\":\"summary\",\"columnType\":\"varchar(255)\",\"createBy\":\"admin\",\"createTime\":\"2022-07-21 15:03:18\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"javaField\":\"summary\",\"javaType\":\"String\",\"list\":true,\"params\":{},\"pk\":false,\"query\":true,\"queryType\":\"EQ\",\"required\":', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 15:05:34');
INSERT INTO `sys_oper_log` VALUES (107, '代码生成', 2, 'com.salishBlog.generator.controller.GenController.editSave()', 'PUT', 1, 'admin', NULL, '/tool/gen', '127.0.0.1', '内网IP', '{\"businessName\":\"tag\",\"className\":\"TTag\",\"columns\":[{\"capJavaField\":\"Id\",\"columnComment\":\"标签id\",\"columnId\":13,\"columnName\":\"id\",\"columnType\":\"int\",\"createBy\":\"admin\",\"createTime\":\"2022-07-21 15:03:18\",\"dictType\":\"\",\"edit\":false,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isPk\":\"1\",\"javaField\":\"id\",\"javaType\":\"Long\",\"list\":false,\"params\":{},\"pk\":true,\"query\":false,\"queryType\":\"EQ\",\"required\":false,\"sort\":1,\"superColumn\":false,\"tableId\":2,\"updateBy\":\"\",\"usableColumn\":false},{\"capJavaField\":\"Tag\",\"columnComment\":\"标签\",\"columnId\":14,\"columnName\":\"tag\",\"columnType\":\"varchar(255)\",\"createBy\":\"admin\",\"createTime\":\"2022-07-21 15:03:18\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"javaField\":\"tag\",\"javaType\":\"String\",\"list\":true,\"params\":{},\"pk\":false,\"query\":true,\"queryType\":\"EQ\",\"required\":false,\"sort\":2,\"superColumn\":false,\"tableId\":2,\"updateBy\":\"\",\"usableColumn\":false},{\"capJavaField\":\"TagColor\",\"columnComment\":\"标签色彩\",\"columnId\":15,\"columnName\":\"tag_color\",\"columnType\":\"varchar(255)\",\"createBy\":\"admin\",\"createTime\":\"2022-07-21 15:03:18\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"javaField\":\"tagColor\",\"javaType\":\"String\",\"list\":true,\"params\":{},\"pk\":false,\"query\":true,\"queryType\":\"EQ\",\"required\":false,\"sort\":3,\"superColumn\":false,\"tableId\":2,\"updateBy\":\"\",\"usableColumn\":false},{\"capJavaField\":\"Times\",\"columnComment\":\"访问次数\",\"columnId\":16,\"columnName\":\"times\",\"columnType\":\"datetime\",\"createBy\":\"admin\",\"createTime\":\"2022-07-21 15:03:18\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"datetime\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"javaField\":\"times\",\"javaType\":\"Date\",\"list\":true,\"params\":{},\"pk\":false,\"query\":true,\"queryType\":\"EQ\",\"requ', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 15:06:06');
INSERT INTO `sys_oper_log` VALUES (108, '代码生成', 2, 'com.salishBlog.generator.controller.GenController.synchDb()', 'GET', 1, 'admin', NULL, '/tool/gen/synchDb/t_blog', '127.0.0.1', '内网IP', '{tableName=t_blog}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 15:20:27');
INSERT INTO `sys_oper_log` VALUES (109, '代码生成', 8, 'com.salishBlog.generator.controller.GenController.batchGenCode()', 'GET', 1, 'admin', NULL, '/tool/gen/batchGenCode', '127.0.0.1', '内网IP', '{}', NULL, 0, NULL, '2022-07-21 15:20:43');
INSERT INTO `sys_oper_log` VALUES (110, '代码生成', 2, 'com.salishBlog.generator.controller.GenController.editSave()', 'PUT', 1, 'admin', NULL, '/tool/gen', '127.0.0.1', '内网IP', '{\"businessName\":\"blog\",\"className\":\"TBlog\",\"columns\":[{\"capJavaField\":\"Id\",\"columnComment\":\"博客id\",\"columnId\":1,\"columnName\":\"id\",\"columnType\":\"int\",\"createBy\":\"admin\",\"createTime\":\"2022-07-21 15:03:18\",\"edit\":false,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isPk\":\"1\",\"javaField\":\"id\",\"javaType\":\"Long\",\"list\":false,\"params\":{},\"pk\":true,\"query\":false,\"queryType\":\"EQ\",\"required\":false,\"sort\":1,\"superColumn\":false,\"tableId\":1,\"updateTime\":\"2022-07-21 15:20:26\",\"usableColumn\":false},{\"capJavaField\":\"Tltle\",\"columnComment\":\"标题\",\"columnId\":2,\"columnName\":\"tltle\",\"columnType\":\"text\",\"createBy\":\"admin\",\"createTime\":\"2022-07-21 15:03:18\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"textarea\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"javaField\":\"tltle\",\"javaType\":\"String\",\"list\":true,\"params\":{},\"pk\":false,\"query\":true,\"queryType\":\"EQ\",\"required\":false,\"sort\":2,\"superColumn\":false,\"tableId\":1,\"updateTime\":\"2022-07-21 15:20:26\",\"usableColumn\":false},{\"capJavaField\":\"Cover\",\"columnComment\":\"封面\",\"columnId\":3,\"columnName\":\"cover\",\"columnType\":\"varchar(255)\",\"createBy\":\"admin\",\"createTime\":\"2022-07-21 15:03:18\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"javaField\":\"cover\",\"javaType\":\"String\",\"list\":true,\"params\":{},\"pk\":false,\"query\":true,\"queryType\":\"EQ\",\"required\":false,\"sort\":3,\"superColumn\":false,\"tableId\":1,\"updateTime\":\"2022-07-21 15:20:26\",\"usableColumn\":false},{\"capJavaField\":\"Summary\",\"columnComment\":\"简介\",\"columnId\":4,\"columnName\":\"summary\",\"columnType\":\"varchar(255)\",\"createBy\":\"admin\",\"createTime\":\"2022-07-21 15:03:18\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"javaField\":\"summary\",\"javaType\":\"String\",\"list\":true,\"params\":{},\"pk', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 15:25:52');
INSERT INTO `sys_oper_log` VALUES (111, '代码生成', 2, 'com.salishBlog.generator.controller.GenController.editSave()', 'PUT', 1, 'admin', NULL, '/tool/gen', '127.0.0.1', '内网IP', '{\"businessName\":\"tag\",\"className\":\"TTag\",\"columns\":[{\"capJavaField\":\"Id\",\"columnComment\":\"标签id\",\"columnId\":13,\"columnName\":\"id\",\"columnType\":\"int\",\"createBy\":\"admin\",\"createTime\":\"2022-07-21 15:03:18\",\"dictType\":\"\",\"edit\":false,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isPk\":\"1\",\"javaField\":\"id\",\"javaType\":\"Long\",\"list\":false,\"params\":{},\"pk\":true,\"query\":false,\"queryType\":\"EQ\",\"required\":false,\"sort\":1,\"superColumn\":false,\"tableId\":2,\"updateBy\":\"\",\"updateTime\":\"2022-07-21 15:06:06\",\"usableColumn\":false},{\"capJavaField\":\"Tag\",\"columnComment\":\"标签\",\"columnId\":14,\"columnName\":\"tag\",\"columnType\":\"varchar(255)\",\"createBy\":\"admin\",\"createTime\":\"2022-07-21 15:03:18\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"javaField\":\"tag\",\"javaType\":\"String\",\"list\":true,\"params\":{},\"pk\":false,\"query\":true,\"queryType\":\"EQ\",\"required\":false,\"sort\":2,\"superColumn\":false,\"tableId\":2,\"updateBy\":\"\",\"updateTime\":\"2022-07-21 15:06:06\",\"usableColumn\":false},{\"capJavaField\":\"TagColor\",\"columnComment\":\"标签色彩\",\"columnId\":15,\"columnName\":\"tag_color\",\"columnType\":\"varchar(255)\",\"createBy\":\"admin\",\"createTime\":\"2022-07-21 15:03:18\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"input\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"javaField\":\"tagColor\",\"javaType\":\"String\",\"list\":true,\"params\":{},\"pk\":false,\"query\":true,\"queryType\":\"EQ\",\"required\":false,\"sort\":3,\"superColumn\":false,\"tableId\":2,\"updateBy\":\"\",\"updateTime\":\"2022-07-21 15:06:06\",\"usableColumn\":false},{\"capJavaField\":\"Times\",\"columnComment\":\"访问次数\",\"columnId\":16,\"columnName\":\"times\",\"columnType\":\"datetime\",\"createBy\":\"admin\",\"createTime\":\"2022-07-21 15:03:18\",\"dictType\":\"\",\"edit\":true,\"htmlType\":\"datetime\",\"increment\":false,\"insert\":true,\"isEdit\":\"1\",\"isIncrement\":\"0\",\"isInsert\":\"1\",\"isList\":\"1\",\"isPk\":\"0\",\"isQuery\":\"1\",\"ja', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 15:26:02');
INSERT INTO `sys_oper_log` VALUES (112, '代码生成', 8, 'com.salishBlog.generator.controller.GenController.batchGenCode()', 'GET', 1, 'admin', NULL, '/tool/gen/batchGenCode', '127.0.0.1', '内网IP', '{}', NULL, 0, NULL, '2022-07-21 15:26:05');
INSERT INTO `sys_oper_log` VALUES (113, '菜单管理', 2, 'com.salishBlog.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"createTime\":\"2022-07-20 16:56:51\",\"icon\":\"tool\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":3,\"menuName\":\"系统工具\",\"menuType\":\"M\",\"orderNum\":0,\"params\":{},\"parentId\":0,\"path\":\"tool\",\"perms\":\"\",\"query\":\"\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 15:26:17');
INSERT INTO `sys_oper_log` VALUES (114, '菜单管理', 2, 'com.salishBlog.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"createTime\":\"2022-07-20 16:56:51\",\"icon\":\"tool\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":3,\"menuName\":\"系统工具\",\"menuType\":\"M\",\"orderNum\":100,\"params\":{},\"parentId\":0,\"path\":\"tool\",\"perms\":\"\",\"query\":\"\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 15:26:24');
INSERT INTO `sys_oper_log` VALUES (115, '菜单管理', 2, 'com.salishBlog.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"createTime\":\"2022-07-20 16:56:51\",\"icon\":\"system\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":1,\"menuName\":\"系统管理\",\"menuType\":\"M\",\"orderNum\":111,\"params\":{},\"parentId\":0,\"path\":\"system\",\"perms\":\"\",\"query\":\"\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 15:26:29');
INSERT INTO `sys_oper_log` VALUES (116, '菜单管理', 2, 'com.salishBlog.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"createTime\":\"2022-07-20 16:56:51\",\"icon\":\"monitor\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2,\"menuName\":\"系统监控\",\"menuType\":\"M\",\"orderNum\":112,\"params\":{},\"parentId\":0,\"path\":\"monitor\",\"perms\":\"\",\"query\":\"\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 15:26:34');
INSERT INTO `sys_oper_log` VALUES (117, '菜单管理', 3, 'com.salishBlog.web.controller.system.SysMenuController.remove()', 'DELETE', 1, 'admin', NULL, '/system/menu/4', '127.0.0.1', '内网IP', '{menuId=4}', '{\"msg\":\"菜单已分配,不允许删除\",\"code\":500}', 0, NULL, '2022-07-21 15:26:37');
INSERT INTO `sys_oper_log` VALUES (118, '菜单管理', 2, 'com.salishBlog.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"createTime\":\"2022-07-20 16:56:51\",\"icon\":\"guide\",\"isCache\":\"0\",\"isFrame\":\"0\",\"menuId\":4,\"menuName\":\"若依官网\",\"menuType\":\"M\",\"orderNum\":9999,\"params\":{},\"parentId\":0,\"path\":\"http://ruoyi.vip\",\"perms\":\"\",\"query\":\"\",\"status\":\"1\",\"updateBy\":\"admin\",\"visible\":\"1\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 15:26:50');
INSERT INTO `sys_oper_log` VALUES (119, '菜单管理', 2, 'com.salishBlog.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"component\":\"buisiness/tag/index\",\"createTime\":\"2022-07-21 15:21:47\",\"icon\":\"#\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2006,\"menuName\":\"标签\",\"menuType\":\"C\",\"orderNum\":1,\"params\":{},\"parentId\":0,\"path\":\"tag\",\"perms\":\"buisiness:tag:list\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 15:27:03');
INSERT INTO `sys_oper_log` VALUES (120, '菜单管理', 2, 'com.salishBlog.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"component\":\"business/blog/index\",\"createTime\":\"2022-07-21 15:21:38\",\"icon\":\"#\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2000,\"menuName\":\"博客\",\"menuType\":\"C\",\"orderNum\":1,\"params\":{},\"parentId\":0,\"path\":\"blog\",\"perms\":\"business:blog:list\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 15:27:08');
INSERT INTO `sys_oper_log` VALUES (121, '菜单管理', 2, 'com.salishBlog.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"component\":\"buisiness/tag/index\",\"createTime\":\"2022-07-21 15:21:47\",\"icon\":\"#\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2006,\"menuName\":\"标签\",\"menuType\":\"C\",\"orderNum\":2,\"params\":{},\"parentId\":0,\"path\":\"tag\",\"perms\":\"buisiness:tag:list\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 15:27:22');
INSERT INTO `sys_oper_log` VALUES (122, '代码生成', 8, 'com.salishBlog.generator.controller.GenController.batchGenCode()', 'GET', 1, 'admin', NULL, '/tool/gen/batchGenCode', '127.0.0.1', '内网IP', '{}', NULL, 0, NULL, '2022-07-21 16:49:34');
INSERT INTO `sys_oper_log` VALUES (123, '菜单管理', 2, 'com.salishBlog.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"component\":\"business/blog/index\",\"createTime\":\"2022-07-21 15:21:38\",\"icon\":\"documentation\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2000,\"menuName\":\"博客\",\"menuType\":\"C\",\"orderNum\":1,\"params\":{},\"parentId\":0,\"path\":\"blog\",\"perms\":\"business:blog:list\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 17:03:09');
INSERT INTO `sys_oper_log` VALUES (124, '菜单管理', 2, 'com.salishBlog.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"component\":\"buisiness/tag/index\",\"createTime\":\"2022-07-21 15:21:47\",\"icon\":\"rate\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2006,\"menuName\":\"标签\",\"menuType\":\"C\",\"orderNum\":2,\"params\":{},\"parentId\":0,\"path\":\"tag\",\"perms\":\"buisiness:tag:list\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 17:03:56');
INSERT INTO `sys_oper_log` VALUES (125, '菜单管理', 2, 'com.salishBlog.web.controller.system.SysMenuController.edit()', 'PUT', 1, 'admin', NULL, '/system/menu', '127.0.0.1', '内网IP', '{\"children\":[],\"component\":\"business/tag/index\",\"createTime\":\"2022-07-21 15:21:47\",\"icon\":\"rate\",\"isCache\":\"0\",\"isFrame\":\"1\",\"menuId\":2006,\"menuName\":\"标签\",\"menuType\":\"C\",\"orderNum\":2,\"params\":{},\"parentId\":0,\"path\":\"tag\",\"perms\":\"buisiness:tag:list\",\"status\":\"0\",\"updateBy\":\"admin\",\"visible\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 17:21:11');
INSERT INTO `sys_oper_log` VALUES (126, '字典类型', 1, 'com.salishBlog.web.controller.system.SysDictTypeController.add()', 'POST', 1, 'admin', NULL, '/system/dict/type', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"dictName\":\"博客类型\",\"dictType\":\"blog_type\",\"params\":{},\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 17:26:31');
INSERT INTO `sys_oper_log` VALUES (127, '字典数据', 1, 'com.salishBlog.web.controller.system.SysDictDataController.add()', 'POST', 1, 'admin', NULL, '/system/dict/data', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"dictLabel\":\"前端\",\"dictSort\":0,\"dictType\":\"blog_type\",\"dictValue\":\"1\",\"listClass\":\"default\",\"params\":{},\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 17:26:54');
INSERT INTO `sys_oper_log` VALUES (128, '字典数据', 1, 'com.salishBlog.web.controller.system.SysDictDataController.add()', 'POST', 1, 'admin', NULL, '/system/dict/data', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"dictLabel\":\"后端\",\"dictSort\":0,\"dictType\":\"blog_type\",\"dictValue\":\"2\",\"listClass\":\"default\",\"params\":{},\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 17:26:59');
INSERT INTO `sys_oper_log` VALUES (129, '字典数据', 1, 'com.salishBlog.web.controller.system.SysDictDataController.add()', 'POST', 1, 'admin', NULL, '/system/dict/data', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"dictLabel\":\"数据库\",\"dictSort\":0,\"dictType\":\"blog_type\",\"dictValue\":\"3\",\"listClass\":\"default\",\"params\":{},\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 17:27:13');
INSERT INTO `sys_oper_log` VALUES (130, '字典数据', 1, 'com.salishBlog.web.controller.system.SysDictDataController.add()', 'POST', 1, 'admin', NULL, '/system/dict/data', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"dictLabel\":\"实用教程\",\"dictSort\":4,\"dictType\":\"blog_type\",\"dictValue\":\"4\",\"listClass\":\"default\",\"params\":{},\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 17:27:47');
INSERT INTO `sys_oper_log` VALUES (131, '字典数据', 2, 'com.salishBlog.web.controller.system.SysDictDataController.edit()', 'PUT', 1, 'admin', NULL, '/system/dict/data', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"createTime\":\"2022-07-21 17:27:13\",\"dictCode\":102,\"dictLabel\":\"数据库\",\"dictSort\":3,\"dictType\":\"blog_type\",\"dictValue\":\"3\",\"isDefault\":\"N\",\"listClass\":\"default\",\"params\":{},\"status\":\"0\",\"updateBy\":\"admin\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 17:27:50');
INSERT INTO `sys_oper_log` VALUES (132, '字典数据', 2, 'com.salishBlog.web.controller.system.SysDictDataController.edit()', 'PUT', 1, 'admin', NULL, '/system/dict/data', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"createTime\":\"2022-07-21 17:26:59\",\"dictCode\":101,\"dictLabel\":\"后端\",\"dictSort\":2,\"dictType\":\"blog_type\",\"dictValue\":\"2\",\"isDefault\":\"N\",\"listClass\":\"default\",\"params\":{},\"status\":\"0\",\"updateBy\":\"admin\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 17:27:53');
INSERT INTO `sys_oper_log` VALUES (133, '字典数据', 2, 'com.salishBlog.web.controller.system.SysDictDataController.edit()', 'PUT', 1, 'admin', NULL, '/system/dict/data', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"createTime\":\"2022-07-21 17:26:54\",\"dictCode\":100,\"dictLabel\":\"前端\",\"dictSort\":1,\"dictType\":\"blog_type\",\"dictValue\":\"1\",\"isDefault\":\"N\",\"listClass\":\"default\",\"params\":{},\"status\":\"0\",\"updateBy\":\"admin\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-21 17:27:57');
INSERT INTO `sys_oper_log` VALUES (134, '字典类型', 1, 'com.salishBlog.web.controller.system.SysDictTypeController.add()', 'POST', 1, 'admin', NULL, '/system/dict/type', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"dictName\":\"博文类型\",\"dictType\":\"content_type\",\"params\":{},\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-25 14:05:31');
INSERT INTO `sys_oper_log` VALUES (135, '字典数据', 1, 'com.salishBlog.web.controller.system.SysDictDataController.add()', 'POST', 1, 'admin', NULL, '/system/dict/data', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"dictLabel\":\"markdown\",\"dictSort\":1,\"dictType\":\"content_type\",\"dictValue\":\"1\",\"listClass\":\"default\",\"params\":{},\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-25 14:05:42');
INSERT INTO `sys_oper_log` VALUES (136, '字典数据', 1, 'com.salishBlog.web.controller.system.SysDictDataController.add()', 'POST', 1, 'admin', NULL, '/system/dict/data', '127.0.0.1', '内网IP', '{\"createBy\":\"admin\",\"dictLabel\":\"富文本\",\"dictSort\":2,\"dictType\":\"content_type\",\"dictValue\":\"2\",\"listClass\":\"default\",\"params\":{},\"status\":\"0\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-25 14:05:49');
INSERT INTO `sys_oper_log` VALUES (137, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p><span style=\\\"color: rgb(77, 77, 77);\\\">如何对jar包进行</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%8A%A0%E5%AF%86&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">加密</a><span style=\\\"color: rgb(77, 77, 77);\\\">呢？其实没有想象中的那么困难，有一款开源工具已经提供了较为完善的加密方案，这款开源工具的名字叫做xjar。接下来我们就看一下使用xjar工具给jar包加密有多么的容易。</span></p><h2><strong style=\\\"color: rgb(79, 79, 79);\\\">前言</strong></h2><p><span style=\\\"color: rgb(77, 77, 77);\\\">jar包相信大家都很熟悉，是通过打包java工程而获得的产物，但是jar包是有一个致命的缺点的，那就是很容易被反编译，只需要使用jd-gui就可以很容易的获取到java源码。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">如果你想要防止别人反编译做逆向工程，那么对jar包进行一次加密就是一项很重要的工作了。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">开源jar加密分为两种一种代码混淆，一种</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%AD%97%E8%8A%82%E7%A0%81&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">字节码</a><span style=\\\"color: rgb(77, 77, 77);\\\">转换。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码混淆，主要思路就是的对类名，变量名和方法名，局部参数名进行替换，让其命名变得无意义，很难读懂，但不影响其逻辑，但对于有耐心的人，还是能看明白！具体实现是在编译前做的混淆，还是编译后做的混淆，这个没用过不太清楚。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码转换，分为两块，一块是加密，对编译后class文件进行字节码转换(可以采用加密算法，字节码异或运算或自己定义规则)；一块是解密，就是在类加载的时候对加密的字节码进行解密。加密这块因为在本地对class文件字节码转换，比较简单，方式也随意；解密这块主要围绕类加载器来做文章，又可分为java版实现和C/C++版实现，java版主要基于-agentJava:xxx.jar，通过Premain-Class，向Instrumentation注入ClassFileTransformer实现，自己在ClassFileTransformer中对需要解密的class文件进行解密；C/C++主要使用-agentpath:xxx.so，基于JVMTI通过C/C++实现，对类加载过程进行操作。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">总体来说：代码混淆和字节码转换可以结合，例如，先代码混淆后，再对字节码加密，运行时对字节码解密。代码混淆，上手最简单，加密级别比较低，也容易破解。字节码转换，java版本对于java熟练人员上手很快，加密级别一般，个人理解该方式一个缺陷就是对于想加密的内容加密了，但解密方式暴露了，如果能够隐藏好解密方式，加密安全系数还是蛮高；C/C++版加密级别最高，但需要对java和C/C++都很熟练，而且需要研究JVMTI相关知识，如果真的实现了基本无破解风险，不过对于SpringBoot等框架，其内部会直接分析class文件，有些坑需要解决。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">另外一', '{\"msg\":\"操作失败\",\"code\":500}', 0, NULL, '2022-07-25 14:53:21');
INSERT INTO `sys_oper_log` VALUES (138, '博客', 1, 'com.salishBlog.web.controller.business.TBlogController.add()', 'POST', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"1\",\"content\":\"<p>123</p>\",\"contentType\":\"2\",\"createBy\":\"若依\",\"createTime\":\"2022-07-25T14:54:02.942+08:00\",\"title\":\"123\"}', NULL, 1, '\r\n### Error updating database.  Cause: com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Out of range value for column \'id\' at row 1\r\n### The error may exist in com/salishBlog/business/mapper/TBlogMapper.java (best guess)\r\n### The error may involve com.salishBlog.business.mapper.TBlogMapper.insert-Inline\r\n### The error occurred while setting parameters\r\n### SQL: INSERT INTO t_blog  ( id, title,   content,  blog_type, content_type, create_time, create_by, update_time, update_by )  VALUES  ( ?, ?,   ?,  ?, ?, ?, ?, ?, ? )\r\n### Cause: com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Out of range value for column \'id\' at row 1\n; Data truncation: Out of range value for column \'id\' at row 1; nested exception is com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Out of range value for column \'id\' at row 1', '2022-07-25 14:54:03');
INSERT INTO `sys_oper_log` VALUES (139, '博客', 1, 'com.salishBlog.web.controller.business.TBlogController.add()', 'POST', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p>1234</p>\",\"contentType\":\"2\",\"createBy\":\"若依\",\"createTime\":\"2022-07-25T14:55:03.166+08:00\",\"title\":\"1234\"}', NULL, 1, '\r\n### Error updating database.  Cause: com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Out of range value for column \'id\' at row 1\r\n### The error may exist in com/salishBlog/business/mapper/TBlogMapper.java (best guess)\r\n### The error may involve com.salishBlog.business.mapper.TBlogMapper.insert-Inline\r\n### The error occurred while setting parameters\r\n### SQL: INSERT INTO t_blog  ( id, title,   content,  blog_type, content_type, create_time, create_by, update_time, update_by )  VALUES  ( ?, ?,   ?,  ?, ?, ?, ?, ?, ? )\r\n### Cause: com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Out of range value for column \'id\' at row 1\n; Data truncation: Out of range value for column \'id\' at row 1; nested exception is com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Out of range value for column \'id\' at row 1', '2022-07-25 14:55:03');
INSERT INTO `sys_oper_log` VALUES (140, '博客', 1, 'com.salishBlog.web.controller.business.TBlogController.add()', 'POST', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p>1234</p>\",\"contentType\":\"2\",\"createBy\":\"若依\",\"createTime\":\"2022-07-25T14:55:07.755+08:00\",\"title\":\"1234\"}', NULL, 1, '\r\n### Error updating database.  Cause: com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Out of range value for column \'id\' at row 1\r\n### The error may exist in com/salishBlog/business/mapper/TBlogMapper.java (best guess)\r\n### The error may involve com.salishBlog.business.mapper.TBlogMapper.insert-Inline\r\n### The error occurred while setting parameters\r\n### SQL: INSERT INTO t_blog  ( id, title,   content,  blog_type, content_type, create_time, create_by, update_time, update_by )  VALUES  ( ?, ?,   ?,  ?, ?, ?, ?, ?, ? )\r\n### Cause: com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Out of range value for column \'id\' at row 1\n; Data truncation: Out of range value for column \'id\' at row 1; nested exception is com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Out of range value for column \'id\' at row 1', '2022-07-25 14:55:07');
INSERT INTO `sys_oper_log` VALUES (141, '博客', 1, 'com.salishBlog.web.controller.business.TBlogController.add()', 'POST', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"1\",\"content\":\"<p>123</p>\",\"contentType\":\"2\",\"createBy\":\"若依\",\"createTime\":\"2022-07-25T14:55:44.964+08:00\",\"title\":\"123\"}', NULL, 1, '\r\n### Error updating database.  Cause: com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Out of range value for column \'id\' at row 1\r\n### The error may exist in com/salishBlog/business/mapper/TBlogMapper.java (best guess)\r\n### The error may involve com.salishBlog.business.mapper.TBlogMapper.insert-Inline\r\n### The error occurred while setting parameters\r\n### SQL: INSERT INTO t_blog  ( id, title,   content,  blog_type, content_type, create_time, create_by, update_time, update_by )  VALUES  ( ?, ?,   ?,  ?, ?, ?, ?, ?, ? )\r\n### Cause: com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Out of range value for column \'id\' at row 1\n; Data truncation: Out of range value for column \'id\' at row 1; nested exception is com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Out of range value for column \'id\' at row 1', '2022-07-25 14:55:44');
INSERT INTO `sys_oper_log` VALUES (142, '博客', 1, 'com.salishBlog.web.controller.business.TBlogController.add()', 'POST', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"1\",\"content\":\"<p>123</p>\",\"contentType\":\"2\",\"createBy\":\"若依\",\"createTime\":\"2022-07-25T14:57:27.43+08:00\",\"title\":\"123\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-25 14:57:27');
INSERT INTO `sys_oper_log` VALUES (143, '博客', 1, 'com.salishBlog.web.controller.business.TBlogController.add()', 'POST', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p><span style=\\\"color: rgb(77, 77, 77);\\\">如何对jar包进行</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%8A%A0%E5%AF%86&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">加密</a><span style=\\\"color: rgb(77, 77, 77);\\\">呢？其实没有想象中的那么困难，有一款开源工具已经提供了较为完善的加密方案，这款开源工具的名字叫做xjar。接下来我们就看一下使用xjar工具给jar包加密有多么的容易。</span></p><h2><strong style=\\\"color: rgb(79, 79, 79);\\\">前言</strong></h2><p><span style=\\\"color: rgb(77, 77, 77);\\\">jar包相信大家都很熟悉，是通过打包java工程而获得的产物，但是jar包是有一个致命的缺点的，那就是很容易被反编译，只需要使用jd-gui就可以很容易的获取到java源码。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">如果你想要防止别人反编译做逆向工程，那么对jar包进行一次加密就是一项很重要的工作了。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">开源jar加密分为两种一种代码混淆，一种</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%AD%97%E8%8A%82%E7%A0%81&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">字节码</a><span style=\\\"color: rgb(77, 77, 77);\\\">转换。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码混淆，主要思路就是的对类名，变量名和方法名，局部参数名进行替换，让其命名变得无意义，很难读懂，但不影响其逻辑，但对于有耐心的人，还是能看明白！具体实现是在编译前做的混淆，还是编译后做的混淆，这个没用过不太清楚。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码转换，分为两块，一块是加密，对编译后class文件进行字节码转换(可以采用加密算法，字节码异或运算或自己定义规则)；一块是解密，就是在类加载的时候对加密的字节码进行解密。加密这块因为在本地对class文件字节码转换，比较简单，方式也随意；解密这块主要围绕类加载器来做文章，又可分为java版实现和C/C++版实现，java版主要基于-agentJava:xxx.jar，通过Premain-Class，向Instrumentation注入ClassFileTransformer实现，自己在ClassFileTransformer中对需要解密的class文件进行解密；C/C++主要使用-agentpath:xxx.so，基于JVMTI通过C/C++实现，对类加载过程进行操作。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">总体来说：代码混淆和字节码转换可以结合，例如，先代码混淆后，再对字节码加密，运行时对字节码解密。代码混淆，上手最简单，加密级别比较低，也容易破解。字节码转换，java版本对于java熟练人员上手很快，加密级别一般，个人理解该方式一个缺陷就是对于想加密的内容加密了，但解密方式暴露了，如果能够隐藏好解密方式，加密安全系数还是蛮高；C/C++版加密级别最高，但需要对java和C/C++都很熟练，而且需要研究JVMTI相关知识，如果真的实现了基本无破解风险，不过对于SpringBoot等框架，其内部会直接分析class文件，有些坑需要解决。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">另外一', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-25 14:58:22');
INSERT INTO `sys_oper_log` VALUES (144, '博客', 3, 'com.salishBlog.web.controller.business.TBlogController.remove()', 'DELETE', 1, 'admin', NULL, '/tBlog/blog/1', '127.0.0.1', '内网IP', '{ids=1}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-25 14:59:52');
INSERT INTO `sys_oper_log` VALUES (145, '标签', 1, 'com.salishBlog.web.controller.business.TTagController.add()', 'POST', 1, 'admin', NULL, '/tTag/tag', '127.0.0.1', '内网IP', '{\"tag\":\"java\",\"tagColor\":\"rgba(0, 186, 189, 1)\"}', NULL, 1, '\r\n### Error updating database.  Cause: com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Out of range value for column \'id\' at row 1\r\n### The error may exist in com/salishBlog/business/mapper/TTagMapper.java (best guess)\r\n### The error may involve com.salishBlog.business.mapper.TTagMapper.insert-Inline\r\n### The error occurred while setting parameters\r\n### SQL: INSERT INTO t_tag  ( id, tag, tag_color )  VALUES  ( ?, ?, ? )\r\n### Cause: com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Out of range value for column \'id\' at row 1\n; Data truncation: Out of range value for column \'id\' at row 1; nested exception is com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Out of range value for column \'id\' at row 1', '2022-07-25 17:00:18');
INSERT INTO `sys_oper_log` VALUES (146, '标签', 1, 'com.salishBlog.web.controller.business.TTagController.add()', 'POST', 1, 'admin', NULL, '/tTag/tag', '127.0.0.1', '内网IP', '{\"tag\":\"java\",\"tagColor\":\"rgba(0, 186, 189, 1)\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-25 17:02:08');
INSERT INTO `sys_oper_log` VALUES (147, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p><span style=\\\"color: rgb(77, 77, 77);\\\">如何对jar包进行</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%8A%A0%E5%AF%86&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">加密</a><span style=\\\"color: rgb(77, 77, 77);\\\">呢？其实没有想象中的那么困难，有一款开源工具已经提供了较为完善的加密方案，这款开源工具的名字叫做xjar。接下来我们就看一下使用xjar工具给jar包加密有多么的容易。</span></p><p><br></p><h2><strong style=\\\"color: rgb(79, 79, 79);\\\">前言</strong></h2><p><span style=\\\"color: rgb(77, 77, 77);\\\">jar包相信大家都很熟悉，是通过打包java工程而获得的产物，但是jar包是有一个致命的缺点的，那就是很容易被反编译，只需要使用jd-gui就可以很容易的获取到java源码。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">如果你想要防止别人反编译做逆向工程，那么对jar包进行一次加密就是一项很重要的工作了。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">开源jar加密分为两种一种代码混淆，一种</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%AD%97%E8%8A%82%E7%A0%81&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">字节码</a><span style=\\\"color: rgb(77, 77, 77);\\\">转换。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码混淆，主要思路就是的对类名，变量名和方法名，局部参数名进行替换，让其命名变得无意义，很难读懂，但不影响其逻辑，但对于有耐心的人，还是能看明白！具体实现是在编译前做的混淆，还是编译后做的混淆，这个没用过不太清楚。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码转换，分为两块，一块是加密，对编译后class文件进行字节码转换(可以采用加密算法，字节码异或运算或自己定义规则)；一块是解密，就是在类加载的时候对加密的字节码进行解密。加密这块因为在本地对class文件字节码转换，比较简单，方式也随意；解密这块主要围绕类加载器来做文章，又可分为java版实现和C/C++版实现，java版主要基于-agentJava:xxx.jar，通过Premain-Class，向Instrumentation注入ClassFileTransformer实现，自己在ClassFileTransformer中对需要解密的class文件进行解密；C/C++主要使用-agentpath:xxx.so，基于JVMTI通过C/C++实现，对类加载过程进行操作。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">总体来说：代码混淆和字节码转换可以结合，例如，先代码混淆后，再对字节码加密，运行时对字节码解密。代码混淆，上手最简单，加密级别比较低，也容易破解。字节码转换，java版本对于java熟练人员上手很快，加密级别一般，个人理解该方式一个缺陷就是对于想加密的内容加密了，但解密方式暴露了，如果能够隐藏好解密方式，加密安全系数还是蛮高；C/C++版加密级别最高，但需要对java和C/C++都很熟练，而且需要研究JVMTI相关知识，如果真的实现了基本无破解风险，不过对于SpringBoot等框架，其内部会直接分析class文件，有些坑需要解决。</span></p><p><span style=\\\"color: rgb(77, 77,', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-25 17:17:14');
INSERT INTO `sys_oper_log` VALUES (148, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p><span style=\\\"color: rgb(77, 77, 77);\\\">如何对jar包进行</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%8A%A0%E5%AF%86&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">加密</a><span style=\\\"color: rgb(77, 77, 77);\\\">呢？其实没有想象中的那么困难，有一款开源工具已经提供了较为完善的加密方案，这款开源工具的名字叫做xjar。接下来我们就看一下使用xjar工具给jar包加密有多么的容易。</span></p><p><br></p><h2><strong style=\\\"color: rgb(79, 79, 79);\\\">前言</strong></h2><p><span style=\\\"color: rgb(77, 77, 77);\\\">jar包相信大家都很熟悉，是通过打包java工程而获得的产物，但是jar包是有一个致命的缺点的，那就是很容易被反编译，只需要使用jd-gui就可以很容易的获取到java源码。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">如果你想要防止别人反编译做逆向工程，那么对jar包进行一次加密就是一项很重要的工作了。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">开源jar加密分为两种一种代码混淆，一种</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%AD%97%E8%8A%82%E7%A0%81&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">字节码</a><span style=\\\"color: rgb(77, 77, 77);\\\">转换。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码混淆，主要思路就是的对类名，变量名和方法名，局部参数名进行替换，让其命名变得无意义，很难读懂，但不影响其逻辑，但对于有耐心的人，还是能看明白！具体实现是在编译前做的混淆，还是编译后做的混淆，这个没用过不太清楚。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码转换，分为两块，一块是加密，对编译后class文件进行字节码转换(可以采用加密算法，字节码异或运算或自己定义规则)；一块是解密，就是在类加载的时候对加密的字节码进行解密。加密这块因为在本地对class文件字节码转换，比较简单，方式也随意；解密这块主要围绕类加载器来做文章，又可分为java版实现和C/C++版实现，java版主要基于-agentJava:xxx.jar，通过Premain-Class，向Instrumentation注入ClassFileTransformer实现，自己在ClassFileTransformer中对需要解密的class文件进行解密；C/C++主要使用-agentpath:xxx.so，基于JVMTI通过C/C++实现，对类加载过程进行操作。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">总体来说：代码混淆和字节码转换可以结合，例如，先代码混淆后，再对字节码加密，运行时对字节码解密。代码混淆，上手最简单，加密级别比较低，也容易破解。字节码转换，java版本对于java熟练人员上手很快，加密级别一般，个人理解该方式一个缺陷就是对于想加密的内容加密了，但解密方式暴露了，如果能够隐藏好解密方式，加密安全系数还是蛮高；C/C++版加密级别最高，但需要对java和C/C++都很熟练，而且需要研究JVMTI相关知识，如果真的实现了基本无破解风险，不过对于SpringBoot等框架，其内部会直接分析class文件，有些坑需要解决。</span></p><p><span style=\\\"color: rgb(77, 77,', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-25 17:18:34');
INSERT INTO `sys_oper_log` VALUES (149, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p><span style=\\\"color: rgb(77, 77, 77);\\\">如何对jar包进行</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%8A%A0%E5%AF%86&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">加密</a><span style=\\\"color: rgb(77, 77, 77);\\\">呢？其实没有想象中的那么困难，有一款开源工具已经提供了较为完善的加密方案，这款开源工具的名字叫做xjar。接下来我们就看一下使用xjar工具给jar包加密有多么的容易。</span></p><p><br></p><h2><strong style=\\\"color: rgb(79, 79, 79);\\\">前言</strong></h2><p><span style=\\\"color: rgb(77, 77, 77);\\\">jar包相信大家都很熟悉，是通过打包java工程而获得的产物，但是jar包是有一个致命的缺点的，那就是很容易被反编译，只需要使用jd-gui就可以很容易的获取到java源码。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">如果你想要防止别人反编译做逆向工程，那么对jar包进行一次加密就是一项很重要的工作了。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">开源jar加密分为两种一种代码混淆，一种</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%AD%97%E8%8A%82%E7%A0%81&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">字节码</a><span style=\\\"color: rgb(77, 77, 77);\\\">转换。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码混淆，主要思路就是的对类名，变量名和方法名，局部参数名进行替换，让其命名变得无意义，很难读懂，但不影响其逻辑，但对于有耐心的人，还是能看明白！具体实现是在编译前做的混淆，还是编译后做的混淆，这个没用过不太清楚。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码转换，分为两块，一块是加密，对编译后class文件进行字节码转换(可以采用加密算法，字节码异或运算或自己定义规则)；一块是解密，就是在类加载的时候对加密的字节码进行解密。加密这块因为在本地对class文件字节码转换，比较简单，方式也随意；解密这块主要围绕类加载器来做文章，又可分为java版实现和C/C++版实现，java版主要基于-agentJava:xxx.jar，通过Premain-Class，向Instrumentation注入ClassFileTransformer实现，自己在ClassFileTransformer中对需要解密的class文件进行解密；C/C++主要使用-agentpath:xxx.so，基于JVMTI通过C/C++实现，对类加载过程进行操作。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">总体来说：代码混淆和字节码转换可以结合，例如，先代码混淆后，再对字节码加密，运行时对字节码解密。代码混淆，上手最简单，加密级别比较低，也容易破解。字节码转换，java版本对于java熟练人员上手很快，加密级别一般，个人理解该方式一个缺陷就是对于想加密的内容加密了，但解密方式暴露了，如果能够隐藏好解密方式，加密安全系数还是蛮高；C/C++版加密级别最高，但需要对java和C/C++都很熟练，而且需要研究JVMTI相关知识，如果真的实现了基本无破解风险，不过对于SpringBoot等框架，其内部会直接分析class文件，有些坑需要解决。</span></p><p><span style=\\\"color: rgb(77, 77,', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-25 17:19:30');
INSERT INTO `sys_oper_log` VALUES (150, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p><span style=\\\"color: rgb(77, 77, 77);\\\">如何对jar包进行</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%8A%A0%E5%AF%86&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">加密</a><span style=\\\"color: rgb(77, 77, 77);\\\">呢？其实没有想象中的那么困难，有一款开源工具已经提供了较为完善的加密方案，这款开源工具的名字叫做xjar。接下来我们就看一下使用xjar工具给jar包加密有多么的容易。</span></p><p><br></p><h2><strong style=\\\"color: rgb(79, 79, 79);\\\">前言</strong></h2><p><span style=\\\"color: rgb(77, 77, 77);\\\">jar包相信大家都很熟悉，是通过打包java工程而获得的产物，但是jar包是有一个致命的缺点的，那就是很容易被反编译，只需要使用jd-gui就可以很容易的获取到java源码。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">如果你想要防止别人反编译做逆向工程，那么对jar包进行一次加密就是一项很重要的工作了。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">开源jar加密分为两种一种代码混淆，一种</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%AD%97%E8%8A%82%E7%A0%81&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">字节码</a><span style=\\\"color: rgb(77, 77, 77);\\\">转换。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码混淆，主要思路就是的对类名，变量名和方法名，局部参数名进行替换，让其命名变得无意义，很难读懂，但不影响其逻辑，但对于有耐心的人，还是能看明白！具体实现是在编译前做的混淆，还是编译后做的混淆，这个没用过不太清楚。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码转换，分为两块，一块是加密，对编译后class文件进行字节码转换(可以采用加密算法，字节码异或运算或自己定义规则)；一块是解密，就是在类加载的时候对加密的字节码进行解密。加密这块因为在本地对class文件字节码转换，比较简单，方式也随意；解密这块主要围绕类加载器来做文章，又可分为java版实现和C/C++版实现，java版主要基于-agentJava:xxx.jar，通过Premain-Class，向Instrumentation注入ClassFileTransformer实现，自己在ClassFileTransformer中对需要解密的class文件进行解密；C/C++主要使用-agentpath:xxx.so，基于JVMTI通过C/C++实现，对类加载过程进行操作。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">总体来说：代码混淆和字节码转换可以结合，例如，先代码混淆后，再对字节码加密，运行时对字节码解密。代码混淆，上手最简单，加密级别比较低，也容易破解。字节码转换，java版本对于java熟练人员上手很快，加密级别一般，个人理解该方式一个缺陷就是对于想加密的内容加密了，但解密方式暴露了，如果能够隐藏好解密方式，加密安全系数还是蛮高；C/C++版加密级别最高，但需要对java和C/C++都很熟练，而且需要研究JVMTI相关知识，如果真的实现了基本无破解风险，不过对于SpringBoot等框架，其内部会直接分析class文件，有些坑需要解决。</span></p><p><span style=\\\"color: rgb(77, 77,', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-25 17:21:52');
INSERT INTO `sys_oper_log` VALUES (151, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p><span style=\\\"color: rgb(77, 77, 77);\\\">如何对jar包进行</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%8A%A0%E5%AF%86&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">加密</a><span style=\\\"color: rgb(77, 77, 77);\\\">呢？其实没有想象中的那么困难，有一款开源工具已经提供了较为完善的加密方案，这款开源工具的名字叫做xjar。接下来我们就看一下使用xjar工具给jar包加密有多么的容易。</span></p><p><br></p><h2><strong style=\\\"color: rgb(79, 79, 79);\\\">前言</strong></h2><p><span style=\\\"color: rgb(77, 77, 77);\\\">jar包相信大家都很熟悉，是通过打包java工程而获得的产物，但是jar包是有一个致命的缺点的，那就是很容易被反编译，只需要使用jd-gui就可以很容易的获取到java源码。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">如果你想要防止别人反编译做逆向工程，那么对jar包进行一次加密就是一项很重要的工作了。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">开源jar加密分为两种一种代码混淆，一种</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%AD%97%E8%8A%82%E7%A0%81&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">字节码</a><span style=\\\"color: rgb(77, 77, 77);\\\">转换。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码混淆，主要思路就是的对类名，变量名和方法名，局部参数名进行替换，让其命名变得无意义，很难读懂，但不影响其逻辑，但对于有耐心的人，还是能看明白！具体实现是在编译前做的混淆，还是编译后做的混淆，这个没用过不太清楚。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码转换，分为两块，一块是加密，对编译后class文件进行字节码转换(可以采用加密算法，字节码异或运算或自己定义规则)；一块是解密，就是在类加载的时候对加密的字节码进行解密。加密这块因为在本地对class文件字节码转换，比较简单，方式也随意；解密这块主要围绕类加载器来做文章，又可分为java版实现和C/C++版实现，java版主要基于-agentJava:xxx.jar，通过Premain-Class，向Instrumentation注入ClassFileTransformer实现，自己在ClassFileTransformer中对需要解密的class文件进行解密；C/C++主要使用-agentpath:xxx.so，基于JVMTI通过C/C++实现，对类加载过程进行操作。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">总体来说：代码混淆和字节码转换可以结合，例如，先代码混淆后，再对字节码加密，运行时对字节码解密。代码混淆，上手最简单，加密级别比较低，也容易破解。字节码转换，java版本对于java熟练人员上手很快，加密级别一般，个人理解该方式一个缺陷就是对于想加密的内容加密了，但解密方式暴露了，如果能够隐藏好解密方式，加密安全系数还是蛮高；C/C++版加密级别最高，但需要对java和C/C++都很熟练，而且需要研究JVMTI相关知识，如果真的实现了基本无破解风险，不过对于SpringBoot等框架，其内部会直接分析class文件，有些坑需要解决。</span></p><p><span style=\\\"color: rgb(77, 77,', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-25 17:24:32');
INSERT INTO `sys_oper_log` VALUES (152, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p><span style=\\\"color: rgb(77, 77, 77);\\\">如何对jar包进行</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%8A%A0%E5%AF%86&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">加密</a><span style=\\\"color: rgb(77, 77, 77);\\\">呢？其实没有想象中的那么困难，有一款开源工具已经提供了较为完善的加密方案，这款开源工具的名字叫做xjar。接下来我们就看一下使用xjar工具给jar包加密有多么的容易。</span></p><p><br></p><h2><strong style=\\\"color: rgb(79, 79, 79);\\\">前言</strong></h2><p><span style=\\\"color: rgb(77, 77, 77);\\\">jar包相信大家都很熟悉，是通过打包java工程而获得的产物，但是jar包是有一个致命的缺点的，那就是很容易被反编译，只需要使用jd-gui就可以很容易的获取到java源码。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">如果你想要防止别人反编译做逆向工程，那么对jar包进行一次加密就是一项很重要的工作了。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">开源jar加密分为两种一种代码混淆，一种</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%AD%97%E8%8A%82%E7%A0%81&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">字节码</a><span style=\\\"color: rgb(77, 77, 77);\\\">转换。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码混淆，主要思路就是的对类名，变量名和方法名，局部参数名进行替换，让其命名变得无意义，很难读懂，但不影响其逻辑，但对于有耐心的人，还是能看明白！具体实现是在编译前做的混淆，还是编译后做的混淆，这个没用过不太清楚。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码转换，分为两块，一块是加密，对编译后class文件进行字节码转换(可以采用加密算法，字节码异或运算或自己定义规则)；一块是解密，就是在类加载的时候对加密的字节码进行解密。加密这块因为在本地对class文件字节码转换，比较简单，方式也随意；解密这块主要围绕类加载器来做文章，又可分为java版实现和C/C++版实现，java版主要基于-agentJava:xxx.jar，通过Premain-Class，向Instrumentation注入ClassFileTransformer实现，自己在ClassFileTransformer中对需要解密的class文件进行解密；C/C++主要使用-agentpath:xxx.so，基于JVMTI通过C/C++实现，对类加载过程进行操作。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">总体来说：代码混淆和字节码转换可以结合，例如，先代码混淆后，再对字节码加密，运行时对字节码解密。代码混淆，上手最简单，加密级别比较低，也容易破解。字节码转换，java版本对于java熟练人员上手很快，加密级别一般，个人理解该方式一个缺陷就是对于想加密的内容加密了，但解密方式暴露了，如果能够隐藏好解密方式，加密安全系数还是蛮高；C/C++版加密级别最高，但需要对java和C/C++都很熟练，而且需要研究JVMTI相关知识，如果真的实现了基本无破解风险，不过对于SpringBoot等框架，其内部会直接分析class文件，有些坑需要解决。</span></p><p><span style=\\\"color: rgb(77, 77,', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-25 17:25:01');
INSERT INTO `sys_oper_log` VALUES (153, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p><span style=\\\"color: rgb(77, 77, 77);\\\">如何对jar包进行</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%8A%A0%E5%AF%86&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">加密</a><span style=\\\"color: rgb(77, 77, 77);\\\">呢？其实没有想象中的那么困难，有一款开源工具已经提供了较为完善的加密方案，这款开源工具的名字叫做xjar。接下来我们就看一下使用xjar工具给jar包加密有多么的容易。</span></p><p><br></p><h2><strong style=\\\"color: rgb(79, 79, 79);\\\">前言</strong></h2><p><span style=\\\"color: rgb(77, 77, 77);\\\">jar包相信大家都很熟悉，是通过打包java工程而获得的产物，但是jar包是有一个致命的缺点的，那就是很容易被反编译，只需要使用jd-gui就可以很容易的获取到java源码。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">如果你想要防止别人反编译做逆向工程，那么对jar包进行一次加密就是一项很重要的工作了。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">开源jar加密分为两种一种代码混淆，一种</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%AD%97%E8%8A%82%E7%A0%81&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">字节码</a><span style=\\\"color: rgb(77, 77, 77);\\\">转换。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码混淆，主要思路就是的对类名，变量名和方法名，局部参数名进行替换，让其命名变得无意义，很难读懂，但不影响其逻辑，但对于有耐心的人，还是能看明白！具体实现是在编译前做的混淆，还是编译后做的混淆，这个没用过不太清楚。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码转换，分为两块，一块是加密，对编译后class文件进行字节码转换(可以采用加密算法，字节码异或运算或自己定义规则)；一块是解密，就是在类加载的时候对加密的字节码进行解密。加密这块因为在本地对class文件字节码转换，比较简单，方式也随意；解密这块主要围绕类加载器来做文章，又可分为java版实现和C/C++版实现，java版主要基于-agentJava:xxx.jar，通过Premain-Class，向Instrumentation注入ClassFileTransformer实现，自己在ClassFileTransformer中对需要解密的class文件进行解密；C/C++主要使用-agentpath:xxx.so，基于JVMTI通过C/C++实现，对类加载过程进行操作。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">总体来说：代码混淆和字节码转换可以结合，例如，先代码混淆后，再对字节码加密，运行时对字节码解密。代码混淆，上手最简单，加密级别比较低，也容易破解。字节码转换，java版本对于java熟练人员上手很快，加密级别一般，个人理解该方式一个缺陷就是对于想加密的内容加密了，但解密方式暴露了，如果能够隐藏好解密方式，加密安全系数还是蛮高；C/C++版加密级别最高，但需要对java和C/C++都很熟练，而且需要研究JVMTI相关知识，如果真的实现了基本无破解风险，不过对于SpringBoot等框架，其内部会直接分析class文件，有些坑需要解决。</span></p><p><span style=\\\"color: rgb(77, 77,', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-25 17:29:03');
INSERT INTO `sys_oper_log` VALUES (154, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p><span style=\\\"color: rgb(77, 77, 77);\\\">如何对jar包进行</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%8A%A0%E5%AF%86&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">加密</a><span style=\\\"color: rgb(77, 77, 77);\\\">呢？其实没有想象中的那么困难，有一款开源工具已经提供了较为完善的加密方案，这款开源工具的名字叫做xjar。接下来我们就看一下使用xjar工具给jar包加密有多么的容易。</span></p><p><br></p><h2><strong style=\\\"color: rgb(79, 79, 79);\\\">前言</strong></h2><p><span style=\\\"color: rgb(77, 77, 77);\\\">jar包相信大家都很熟悉，是通过打包java工程而获得的产物，但是jar包是有一个致命的缺点的，那就是很容易被反编译，只需要使用jd-gui就可以很容易的获取到java源码。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">如果你想要防止别人反编译做逆向工程，那么对jar包进行一次加密就是一项很重要的工作了。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">开源jar加密分为两种一种代码混淆，一种</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%AD%97%E8%8A%82%E7%A0%81&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">字节码</a><span style=\\\"color: rgb(77, 77, 77);\\\">转换。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码混淆，主要思路就是的对类名，变量名和方法名，局部参数名进行替换，让其命名变得无意义，很难读懂，但不影响其逻辑，但对于有耐心的人，还是能看明白！具体实现是在编译前做的混淆，还是编译后做的混淆，这个没用过不太清楚。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码转换，分为两块，一块是加密，对编译后class文件进行字节码转换(可以采用加密算法，字节码异或运算或自己定义规则)；一块是解密，就是在类加载的时候对加密的字节码进行解密。加密这块因为在本地对class文件字节码转换，比较简单，方式也随意；解密这块主要围绕类加载器来做文章，又可分为java版实现和C/C++版实现，java版主要基于-agentJava:xxx.jar，通过Premain-Class，向Instrumentation注入ClassFileTransformer实现，自己在ClassFileTransformer中对需要解密的class文件进行解密；C/C++主要使用-agentpath:xxx.so，基于JVMTI通过C/C++实现，对类加载过程进行操作。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">总体来说：代码混淆和字节码转换可以结合，例如，先代码混淆后，再对字节码加密，运行时对字节码解密。代码混淆，上手最简单，加密级别比较低，也容易破解。字节码转换，java版本对于java熟练人员上手很快，加密级别一般，个人理解该方式一个缺陷就是对于想加密的内容加密了，但解密方式暴露了，如果能够隐藏好解密方式，加密安全系数还是蛮高；C/C++版加密级别最高，但需要对java和C/C++都很熟练，而且需要研究JVMTI相关知识，如果真的实现了基本无破解风险，不过对于SpringBoot等框架，其内部会直接分析class文件，有些坑需要解决。</span></p><p><span style=\\\"color: rgb(77, 77,', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-26 14:48:35');
INSERT INTO `sys_oper_log` VALUES (155, '博客', 3, 'com.salishBlog.web.controller.business.TBlogController.remove()', 'DELETE', 1, 'admin', NULL, '/tBlog/blog/4', '127.0.0.1', '内网IP', '{ids=4}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-26 15:15:27');
INSERT INTO `sys_oper_log` VALUES (156, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p><span style=\\\"color: rgb(77, 77, 77);\\\">如何对jar包进行</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%8A%A0%E5%AF%86&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">加密</a><span style=\\\"color: rgb(77, 77, 77);\\\">呢？其实没有想象中的那么困难，有一款开源工具已经提供了较为完善的加密方案，这款开源工具的名字叫做xjar。接下来我们就看一下使用xjar工具给jar包加密有多么的容易。</span></p><p><br></p><h2><strong style=\\\"color: rgb(79, 79, 79);\\\">前言</strong></h2><p><span style=\\\"color: rgb(77, 77, 77);\\\">jar包相信大家都很熟悉，是通过打包java工程而获得的产物，但是jar包是有一个致命的缺点的，那就是很容易被反编译，只需要使用jd-gui就可以很容易的获取到java源码。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">如果你想要防止别人反编译做逆向工程，那么对jar包进行一次加密就是一项很重要的工作了。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">开源jar加密分为两种一种代码混淆，一种</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%AD%97%E8%8A%82%E7%A0%81&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">字节码</a><span style=\\\"color: rgb(77, 77, 77);\\\">转换。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码混淆，主要思路就是的对类名，变量名和方法名，局部参数名进行替换，让其命名变得无意义，很难读懂，但不影响其逻辑，但对于有耐心的人，还是能看明白！具体实现是在编译前做的混淆，还是编译后做的混淆，这个没用过不太清楚。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码转换，分为两块，一块是加密，对编译后class文件进行字节码转换(可以采用加密算法，字节码异或运算或自己定义规则)；一块是解密，就是在类加载的时候对加密的字节码进行解密。加密这块因为在本地对class文件字节码转换，比较简单，方式也随意；解密这块主要围绕类加载器来做文章，又可分为java版实现和C/C++版实现，java版主要基于-agentJava:xxx.jar，通过Premain-Class，向Instrumentation注入ClassFileTransformer实现，自己在ClassFileTransformer中对需要解密的class文件进行解密；C/C++主要使用-agentpath:xxx.so，基于JVMTI通过C/C++实现，对类加载过程进行操作。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">总体来说：代码混淆和字节码转换可以结合，例如，先代码混淆后，再对字节码加密，运行时对字节码解密。代码混淆，上手最简单，加密级别比较低，也容易破解。字节码转换，java版本对于java熟练人员上手很快，加密级别一般，个人理解该方式一个缺陷就是对于想加密的内容加密了，但解密方式暴露了，如果能够隐藏好解密方式，加密安全系数还是蛮高；C/C++版加密级别最高，但需要对java和C/C++都很熟练，而且需要研究JVMTI相关知识，如果真的实现了基本无破解风险，不过对于SpringBoot等框架，其内部会直接分析class文件，有些坑需要解决。</span></p><p><span style=\\\"color: rgb(77, 77,', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-26 15:42:02');
INSERT INTO `sys_oper_log` VALUES (157, '标签', 2, 'com.salishBlog.web.controller.business.TTagController.edit()', 'PUT', 1, 'admin', NULL, '/tTag/tag', '127.0.0.1', '内网IP', '{\"id\":1,\"tag\":\"java\",\"tagColor\":\"rgba(146, 151, 156, 0.73)\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-26 16:27:48');
INSERT INTO `sys_oper_log` VALUES (158, '标签', 2, 'com.salishBlog.web.controller.business.TTagController.edit()', 'PUT', 1, 'admin', NULL, '/tTag/tag', '127.0.0.1', '内网IP', '{\"id\":1,\"tag\":\"java\",\"tagColor\":\"rgba(136, 204, 141, 0.73)\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-26 16:28:51');
INSERT INTO `sys_oper_log` VALUES (159, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p><span style=\\\"color: rgb(77, 77, 77);\\\">如何对jar包进行</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%8A%A0%E5%AF%86&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">加密</a><span style=\\\"color: rgb(77, 77, 77);\\\">呢？其实没有想象中的那么困难，有一款开源工具已经提供了较为完善的加密方案，这款开源工具的名字叫做xjar。接下来我们就看一下使用xjar工具给jar包加密有多么的容易。</span></p><p><br></p><h2><strong style=\\\"color: rgb(79, 79, 79);\\\">前言</strong></h2><p><span style=\\\"color: rgb(77, 77, 77);\\\">jar包相信大家都很熟悉，是通过打包java工程而获得的产物，但是jar包是有一个致命的缺点的，那就是很容易被反编译，只需要使用jd-gui就可以很容易的获取到java源码。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">如果你想要防止别人反编译做逆向工程，那么对jar包进行一次加密就是一项很重要的工作了。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">开源jar加密分为两种一种代码混淆，一种</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%AD%97%E8%8A%82%E7%A0%81&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">字节码</a><span style=\\\"color: rgb(77, 77, 77);\\\">转换。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码混淆，主要思路就是的对类名，变量名和方法名，局部参数名进行替换，让其命名变得无意义，很难读懂，但不影响其逻辑，但对于有耐心的人，还是能看明白！具体实现是在编译前做的混淆，还是编译后做的混淆，这个没用过不太清楚。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码转换，分为两块，一块是加密，对编译后class文件进行字节码转换(可以采用加密算法，字节码异或运算或自己定义规则)；一块是解密，就是在类加载的时候对加密的字节码进行解密。加密这块因为在本地对class文件字节码转换，比较简单，方式也随意；解密这块主要围绕类加载器来做文章，又可分为java版实现和C/C++版实现，java版主要基于-agentJava:xxx.jar，通过Premain-Class，向Instrumentation注入ClassFileTransformer实现，自己在ClassFileTransformer中对需要解密的class文件进行解密；C/C++主要使用-agentpath:xxx.so，基于JVMTI通过C/C++实现，对类加载过程进行操作。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">总体来说：代码混淆和字节码转换可以结合，例如，先代码混淆后，再对字节码加密，运行时对字节码解密。代码混淆，上手最简单，加密级别比较低，也容易破解。字节码转换，java版本对于java熟练人员上手很快，加密级别一般，个人理解该方式一个缺陷就是对于想加密的内容加密了，但解密方式暴露了，如果能够隐藏好解密方式，加密安全系数还是蛮高；C/C++版加密级别最高，但需要对java和C/C++都很熟练，而且需要研究JVMTI相关知识，如果真的实现了基本无破解风险，不过对于SpringBoot等框架，其内部会直接分析class文件，有些坑需要解决。</span></p><p><span style=\\\"color: rgb(77, 77,', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-27 17:32:10');
INSERT INTO `sys_oper_log` VALUES (160, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p><span style=\\\"color: rgb(77, 77, 77);\\\">如何对jar包进行</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%8A%A0%E5%AF%86&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">加密</a><span style=\\\"color: rgb(77, 77, 77);\\\">呢？其实没有想象中的那么困难，有一款开源工具已经提供了较为完善的加密方案，这款开源工具的名字叫做xjar。接下来我们就看一下使用xjar工具给jar包加密有多么的容易。</span></p><p><br></p><h2><strong style=\\\"color: rgb(79, 79, 79);\\\">前言</strong></h2><p><span style=\\\"color: rgb(77, 77, 77);\\\">jar包相信大家都很熟悉，是通过打包java工程而获得的产物，但是jar包是有一个致命的缺点的，那就是很容易被反编译，只需要使用jd-gui就可以很容易的获取到java源码。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">如果你想要防止别人反编译做逆向工程，那么对jar包进行一次加密就是一项很重要的工作了。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">开源jar加密分为两种一种代码混淆，一种</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%AD%97%E8%8A%82%E7%A0%81&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">字节码</a><span style=\\\"color: rgb(77, 77, 77);\\\">转换。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码混淆，主要思路就是的对类名，变量名和方法名，局部参数名进行替换，让其命名变得无意义，很难读懂，但不影响其逻辑，但对于有耐心的人，还是能看明白！具体实现是在编译前做的混淆，还是编译后做的混淆，这个没用过不太清楚。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码转换，分为两块，一块是加密，对编译后class文件进行字节码转换(可以采用加密算法，字节码异或运算或自己定义规则)；一块是解密，就是在类加载的时候对加密的字节码进行解密。加密这块因为在本地对class文件字节码转换，比较简单，方式也随意；解密这块主要围绕类加载器来做文章，又可分为java版实现和C/C++版实现，java版主要基于-agentJava:xxx.jar，通过Premain-Class，向Instrumentation注入ClassFileTransformer实现，自己在ClassFileTransformer中对需要解密的class文件进行解密；C/C++主要使用-agentpath:xxx.so，基于JVMTI通过C/C++实现，对类加载过程进行操作。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">总体来说：代码混淆和字节码转换可以结合，例如，先代码混淆后，再对字节码加密，运行时对字节码解密。代码混淆，上手最简单，加密级别比较低，也容易破解。字节码转换，java版本对于java熟练人员上手很快，加密级别一般，个人理解该方式一个缺陷就是对于想加密的内容加密了，但解密方式暴露了，如果能够隐藏好解密方式，加密安全系数还是蛮高；C/C++版加密级别最高，但需要对java和C/C++都很熟练，而且需要研究JVMTI相关知识，如果真的实现了基本无破解风险，不过对于SpringBoot等框架，其内部会直接分析class文件，有些坑需要解决。</span></p><p><span style=\\\"color: rgb(77, 77,', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-29 16:32:47');
INSERT INTO `sys_oper_log` VALUES (161, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p><span style=\\\"color: rgb(77, 77, 77);\\\">如何对jar包进行</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%8A%A0%E5%AF%86&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">加密</a><span style=\\\"color: rgb(77, 77, 77);\\\">呢？其实没有想象中的那么困难，有一款开源工具已经提供了较为完善的加密方案，这款开源工具的名字叫做xjar。接下来我们就看一下使用xjar工具给jar包加密有多么的容易。</span></p><p><br></p><h2><strong style=\\\"color: rgb(79, 79, 79);\\\">前言</strong></h2><p><span style=\\\"color: rgb(77, 77, 77);\\\">jar包相信大家都很熟悉，是通过打包java工程而获得的产物，但是jar包是有一个致命的缺点的，那就是很容易被反编译，只需要使用jd-gui就可以很容易的获取到java源码。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">如果你想要防止别人反编译做逆向工程，那么对jar包进行一次加密就是一项很重要的工作了。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">开源jar加密分为两种一种代码混淆，一种</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%AD%97%E8%8A%82%E7%A0%81&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">字节码</a><span style=\\\"color: rgb(77, 77, 77);\\\">转换。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码混淆，主要思路就是的对类名，变量名和方法名，局部参数名进行替换，让其命名变得无意义，很难读懂，但不影响其逻辑，但对于有耐心的人，还是能看明白！具体实现是在编译前做的混淆，还是编译后做的混淆，这个没用过不太清楚。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码转换，分为两块，一块是加密，对编译后class文件进行字节码转换(可以采用加密算法，字节码异或运算或自己定义规则)；一块是解密，就是在类加载的时候对加密的字节码进行解密。加密这块因为在本地对class文件字节码转换，比较简单，方式也随意；解密这块主要围绕类加载器来做文章，又可分为java版实现和C/C++版实现，java版主要基于-agentJava:xxx.jar，通过Premain-Class，向Instrumentation注入ClassFileTransformer实现，自己在ClassFileTransformer中对需要解密的class文件进行解密；C/C++主要使用-agentpath:xxx.so，基于JVMTI通过C/C++实现，对类加载过程进行操作。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">总体来说：代码混淆和字节码转换可以结合，例如，先代码混淆后，再对字节码加密，运行时对字节码解密。代码混淆，上手最简单，加密级别比较低，也容易破解。字节码转换，java版本对于java熟练人员上手很快，加密级别一般，个人理解该方式一个缺陷就是对于想加密的内容加密了，但解密方式暴露了，如果能够隐藏好解密方式，加密安全系数还是蛮高；C/C++版加密级别最高，但需要对java和C/C++都很熟练，而且需要研究JVMTI相关知识，如果真的实现了基本无破解风险，不过对于SpringBoot等框架，其内部会直接分析class文件，有些坑需要解决。</span></p><p><span style=\\\"color: rgb(77, 77,', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-29 16:35:51');
INSERT INTO `sys_oper_log` VALUES (162, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p><span style=\\\"color: rgb(77, 77, 77);\\\">如何对jar包进行</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%8A%A0%E5%AF%86&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">加密</a><span style=\\\"color: rgb(77, 77, 77);\\\">呢？其实没有想象中的那么困难，有一款开源工具已经提供了较为完善的加密方案，这款开源工具的名字叫做xjar。接下来我们就看一下使用xjar工具给jar包加密有多么的容易。</span></p><p><br></p><h2><strong style=\\\"color: rgb(79, 79, 79);\\\">前言</strong></h2><p><span style=\\\"color: rgb(77, 77, 77);\\\">jar包相信大家都很熟悉，是通过打包java工程而获得的产物，但是jar包是有一个致命的缺点的，那就是很容易被反编译，只需要使用jd-gui就可以很容易的获取到java源码。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">如果你想要防止别人反编译做逆向工程，那么对jar包进行一次加密就是一项很重要的工作了。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">开源jar加密分为两种一种代码混淆，一种</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%AD%97%E8%8A%82%E7%A0%81&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">字节码</a><span style=\\\"color: rgb(77, 77, 77);\\\">转换。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码混淆，主要思路就是的对类名，变量名和方法名，局部参数名进行替换，让其命名变得无意义，很难读懂，但不影响其逻辑，但对于有耐心的人，还是能看明白！具体实现是在编译前做的混淆，还是编译后做的混淆，这个没用过不太清楚。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码转换，分为两块，一块是加密，对编译后class文件进行字节码转换(可以采用加密算法，字节码异或运算或自己定义规则)；一块是解密，就是在类加载的时候对加密的字节码进行解密。加密这块因为在本地对class文件字节码转换，比较简单，方式也随意；解密这块主要围绕类加载器来做文章，又可分为java版实现和C/C++版实现，java版主要基于-agentJava:xxx.jar，通过Premain-Class，向Instrumentation注入ClassFileTransformer实现，自己在ClassFileTransformer中对需要解密的class文件进行解密；C/C++主要使用-agentpath:xxx.so，基于JVMTI通过C/C++实现，对类加载过程进行操作。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">总体来说：代码混淆和字节码转换可以结合，例如，先代码混淆后，再对字节码加密，运行时对字节码解密。代码混淆，上手最简单，加密级别比较低，也容易破解。字节码转换，java版本对于java熟练人员上手很快，加密级别一般，个人理解该方式一个缺陷就是对于想加密的内容加密了，但解密方式暴露了，如果能够隐藏好解密方式，加密安全系数还是蛮高；C/C++版加密级别最高，但需要对java和C/C++都很熟练，而且需要研究JVMTI相关知识，如果真的实现了基本无破解风险，不过对于SpringBoot等框架，其内部会直接分析class文件，有些坑需要解决。</span></p><p><span style=\\\"color: rgb(77, 77,', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-29 16:36:49');
INSERT INTO `sys_oper_log` VALUES (163, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"<p><span style=\\\"color: rgb(77, 77, 77);\\\">如何对jar包进行</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%8A%A0%E5%AF%86&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">加密</a><span style=\\\"color: rgb(77, 77, 77);\\\">呢？其实没有想象中的那么困难，有一款开源工具已经提供了较为完善的加密方案，这款开源工具的名字叫做xjar。接下来我们就看一下使用xjar工具给jar包加密有多么的容易。</span></p><p><br></p><h2><strong style=\\\"color: rgb(79, 79, 79);\\\">前言</strong></h2><p><span style=\\\"color: rgb(77, 77, 77);\\\">jar包相信大家都很熟悉，是通过打包java工程而获得的产物，但是jar包是有一个致命的缺点的，那就是很容易被反编译，只需要使用jd-gui就可以很容易的获取到java源码。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">如果你想要防止别人反编译做逆向工程，那么对jar包进行一次加密就是一项很重要的工作了。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">开源jar加密分为两种一种代码混淆，一种</span><a href=\\\"https://so.csdn.net/so/search?q=%E5%AD%97%E8%8A%82%E7%A0%81&amp;spm=1001.2101.3001.7020\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\" style=\\\"color: rgb(252, 85, 49); background-color: transparent;\\\">字节码</a><span style=\\\"color: rgb(77, 77, 77);\\\">转换。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码混淆，主要思路就是的对类名，变量名和方法名，局部参数名进行替换，让其命名变得无意义，很难读懂，但不影响其逻辑，但对于有耐心的人，还是能看明白！具体实现是在编译前做的混淆，还是编译后做的混淆，这个没用过不太清楚。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">字节码转换，分为两块，一块是加密，对编译后class文件进行字节码转换(可以采用加密算法，字节码异或运算或自己定义规则)；一块是解密，就是在类加载的时候对加密的字节码进行解密。加密这块因为在本地对class文件字节码转换，比较简单，方式也随意；解密这块主要围绕类加载器来做文章，又可分为java版实现和C/C++版实现，java版主要基于-agentJava:xxx.jar，通过Premain-Class，向Instrumentation注入ClassFileTransformer实现，自己在ClassFileTransformer中对需要解密的class文件进行解密；C/C++主要使用-agentpath:xxx.so，基于JVMTI通过C/C++实现，对类加载过程进行操作。</span></p><p><span style=\\\"color: rgb(77, 77, 77);\\\">总体来说：代码混淆和字节码转换可以结合，例如，先代码混淆后，再对字节码加密，运行时对字节码解密。代码混淆，上手最简单，加密级别比较低，也容易破解。字节码转换，java版本对于java熟练人员上手很快，加密级别一般，个人理解该方式一个缺陷就是对于想加密的内容加密了，但解密方式暴露了，如果能够隐藏好解密方式，加密安全系数还是蛮高；C/C++版加密级别最高，但需要对java和C/C++都很熟练，而且需要研究JVMTI相关知识，如果真的实现了基本无破解风险，不过对于SpringBoot等框架，其内部会直接分析class文件，有些坑需要解决。</span></p><p><span style=\\\"color: rgb(77, 77,', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-29 16:38:19');
INSERT INTO `sys_oper_log` VALUES (164, '标签', 1, 'com.salishBlog.web.controller.business.TTagController.add()', 'POST', 1, 'admin', NULL, '/tTag/tag', '127.0.0.1', '内网IP', '{\"tag\":\"vue\",\"tagColor\":\"rgba(30, 144, 255, 1)\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-07-29 17:27:24');
INSERT INTO `sys_oper_log` VALUES (165, '博客', 1, 'com.salishBlog.web.controller.business.TBlogController.add()', 'POST', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"4\",\"content\":\"KingRan/KR（集合库）\\n\\n``` language\\n  ql repo https://github.com/KingRan/KR.git \\\"jd_|jx_|jdCookie\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|utils|function|sign|sendNotify|ql|JDJR\\\"\\n```\\nCurtinlv 仓库（库还在，但是长期没有更新，建议停用观察）\\n\\n``` language\\n  ql repo https://github.com/curtinlv/JD-Script.git\\n```\\nZy143L/wskey（wskey转换库）\\n\\n``` language\\n  ql repo https://github.com/Zy143L/wskey.git \\\"wskey\\\"\\n```\\n国内的服务器请使用下面这个：\\n\\n``` language\\n  ql repo https://e.coding.net/HelloDNS/sign/wskey.git \\\"wskey\\\"\\n```\\nsmiek2121（开卡库）\\n\\n``` language\\n  ql repo ql repo https://github.com/smiek2121/scripts.git \\\"jd_|gua_\\\" \\\"\\\" \\\"ZooFaker_Necklace.js|JDJRValidator_Pure.js|sign_graphics_validate.js|cleancart_activity.js|jdCookie.js|sendNotify.js\\\"\\n```\\nYun-City/City（集合库）\\n\\n``` language\\n  ql repo https://github.com/Yun-City/City.git \\\"jd_|jx_|gua_|jddj_|getJDCookie\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|function|utils|sendnotify|ZooFaker_Necklace|jd_Cookie|JDJRValidator_|sign_graphics_validate|ql|magic|cleancart_activity\\\"\\n```\\n6dylan6/jdpro（集合库）任务定时建议50 7-23/2 * * *\\n\\n``` language\\n  ql repo https://github.com/6dylan6/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\n国内服务器请使用以下命令：\\n\\n``` language\\n  ql repo https://js.dayplus.xyz/https://github.com/6dylan6/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\n上述方式还不行的话，可以考虑使用 gitee 版本，更新相比 GitHub 可能会稍慢点。\\n\\n``` language\\n  ql repo https://gitee.com/dylanote/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\ngys619/Absinthe（集合库）\\n\\n``` language\\n  ql repo https://github.com/gys619/Absinthe.git \\\"jd_|jx_|jddj_|gua_|getJDCookie|wskey\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|utils|ZooFaker_Necklace|JDJRValidator_|sign_graphics_validate|jddj_cookie|function|ql|magic|JDJR|JD\\\" \\\"main\\\"\\n```\\t\\nzero205/JD_tencent_scf\\n``` language\\n  \\nql repo https://github.com/zero205/JD_tencent_scf.git \\\"jd_|jx_|jdCookie\\\" \\\"backUp|icon\\\" \\\"^jd[^_', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-08-01 09:14:58');
INSERT INTO `sys_oper_log` VALUES (166, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"4\",\"content\":\"KingRan/KR（集合库）\\n\\n``` language\\n  ql repo https://github.com/KingRan/KR.git \\\"jd_|jx_|jdCookie\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|utils|function|sign|sendNotify|ql|JDJR\\\"\\n```\\nCurtinlv 仓库（库还在，但是长期没有更新，建议停用观察）\\n\\n``` language\\n  ql repo https://github.com/curtinlv/JD-Script.git\\n```\\nZy143L/wskey（wskey转换库）\\n\\n``` language\\n  ql repo https://github.com/Zy143L/wskey.git \\\"wskey\\\"\\n```\\n国内的服务器请使用下面这个：\\n\\n``` language\\n  ql repo https://e.coding.net/HelloDNS/sign/wskey.git \\\"wskey\\\"\\n```\\nsmiek2121（开卡库）\\n\\n``` language\\n  ql repo ql repo https://github.com/smiek2121/scripts.git \\\"jd_|gua_\\\" \\\"\\\" \\\"ZooFaker_Necklace.js|JDJRValidator_Pure.js|sign_graphics_validate.js|cleancart_activity.js|jdCookie.js|sendNotify.js\\\"\\n```\\nYun-City/City（集合库）\\n\\n``` language\\n  ql repo https://github.com/Yun-City/City.git \\\"jd_|jx_|gua_|jddj_|getJDCookie\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|function|utils|sendnotify|ZooFaker_Necklace|jd_Cookie|JDJRValidator_|sign_graphics_validate|ql|magic|cleancart_activity\\\"\\n```\\n6dylan6/jdpro（集合库）任务定时建议50 7-23/2 * * *\\n\\n``` language\\n  ql repo https://github.com/6dylan6/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\n国内服务器请使用以下命令：\\n\\n``` language\\n  ql repo https://js.dayplus.xyz/https://github.com/6dylan6/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\n上述方式还不行的话，可以考虑使用 gitee 版本，更新相比 GitHub 可能会稍慢点。\\n\\n``` language\\n  ql repo https://gitee.com/dylanote/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\ngys619/Absinthe（集合库）\\n\\n``` language\\n  ql repo https://github.com/gys619/Absinthe.git \\\"jd_|jx_|jddj_|gua_|getJDCookie|wskey\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|utils|ZooFaker_Necklace|JDJRValidator_|sign_graphics_validate|jddj_cookie|function|ql|magic|JDJR|JD\\\" \\\"main\\\"\\n```\\t\\nzero205/JD_tencent_scf\\n``` language\\n  \\nql repo https://github.com/zero205/JD_tencent_scf.git \\\"jd_|jx_|jdCookie\\\" \\\"backUp|icon\\\" \\\"^jd[^_', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-08-01 09:17:37');
INSERT INTO `sys_oper_log` VALUES (167, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"4\",\"content\":\"KingRan/KR（集合库）\\n\\n``` bash\\n  ql repo https://github.com/KingRan/KR.git \\\"jd_|jx_|jdCookie\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|utils|function|sign|sendNotify|ql|JDJR\\\"\\n```\\nCurtinlv 仓库（库还在，但是长期没有更新，建议停用观察）\\n\\n``` bash\\n  ql repo https://github.com/curtinlv/JD-Script.git\\n```\\nZy143L/wskey（wskey转换库）\\n\\n``` bash\\n  ql repo https://github.com/Zy143L/wskey.git \\\"wskey\\\"\\n```\\n国内的服务器请使用下面这个：\\n\\n``` bash\\n  ql repo https://e.coding.net/HelloDNS/sign/wskey.git \\\"wskey\\\"\\n```\\nsmiek2121（开卡库）\\n\\n``` bash\\n  ql repo ql repo https://github.com/smiek2121/scripts.git \\\"jd_|gua_\\\" \\\"\\\" \\\"ZooFaker_Necklace.js|JDJRValidator_Pure.js|sign_graphics_validate.js|cleancart_activity.js|jdCookie.js|sendNotify.js\\\"\\n```\\nYun-City/City（集合库）\\n\\n``` bash\\n  ql repo https://github.com/Yun-City/City.git \\\"jd_|jx_|gua_|jddj_|getJDCookie\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|function|utils|sendnotify|ZooFaker_Necklace|jd_Cookie|JDJRValidator_|sign_graphics_validate|ql|magic|cleancart_activity\\\"\\n```\\n6dylan6/jdpro（集合库）任务定时建议50 7-23/2 * * *\\n\\n``` bash\\n  ql repo https://github.com/6dylan6/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\n国内服务器请使用以下命令：\\n\\n``` bash\\n  ql repo https://js.dayplus.xyz/https://github.com/6dylan6/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\n上述方式还不行的话，可以考虑使用 gitee 版本，更新相比 GitHub 可能会稍慢点。\\n\\n``` bash\\n  ql repo https://gitee.com/dylanote/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\ngys619/Absinthe（集合库）\\n\\n``` bash\\n  ql repo https://github.com/gys619/Absinthe.git \\\"jd_|jx_|jddj_|gua_|getJDCookie|wskey\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|utils|ZooFaker_Necklace|JDJRValidator_|sign_graphics_validate|jddj_cookie|function|ql|magic|JDJR|JD\\\" \\\"main\\\"\\n```\\t\\nzero205/JD_tencent_scf\\n``` bash\\n  \\nql repo https://github.com/zero205/JD_tencent_scf.git \\\"jd_|jx_|jdCookie\\\" \\\"backUp|icon\\\" \\\"^jd[^_]|USER|sendNotify|sign_graphics_validate|JDJ', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-08-01 09:44:17');
INSERT INTO `sys_oper_log` VALUES (168, '标签', 1, 'com.salishBlog.web.controller.business.TTagController.add()', 'POST', 1, 'admin', NULL, '/tTag/tag', '127.0.0.1', '内网IP', '{\"tag\":\"工具\",\"tagColor\":\"rgba(225, 145, 33, 0.87)\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-08-02 09:54:46');
INSERT INTO `sys_oper_log` VALUES (169, '标签', 1, 'com.salishBlog.web.controller.business.TTagController.add()', 'POST', 1, 'admin', NULL, '/tTag/tag', '127.0.0.1', '内网IP', '{\"tag\":\"nas\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-08-02 09:56:29');
INSERT INTO `sys_oper_log` VALUES (170, '标签', 2, 'com.salishBlog.web.controller.business.TTagController.edit()', 'PUT', 1, 'admin', NULL, '/tTag/tag', '127.0.0.1', '内网IP', '{\"id\":4,\"tag\":\"nas\",\"tagColor\":\"rgba(48, 215, 176, 0.87)\"}', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-08-02 09:56:38');
INSERT INTO `sys_oper_log` VALUES (171, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"4\",\"content\":\"KingRan/KR（集合库）\\n\\n``` bash\\n  ql repo https://github.com/KingRan/KR.git \\\"jd_|jx_|jdCookie\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|utils|function|sign|sendNotify|ql|JDJR\\\"\\n```\\nCurtinlv 仓库（库还在，但是长期没有更新，建议停用观察）\\n\\n``` bash\\n  ql repo https://github.com/curtinlv/JD-Script.git\\n```\\nZy143L/wskey（wskey转换库）\\n\\n``` bash\\n  ql repo https://github.com/Zy143L/wskey.git \\\"wskey\\\"\\n```\\n国内的服务器请使用下面这个：\\n\\n``` bash\\n  ql repo https://e.coding.net/HelloDNS/sign/wskey.git \\\"wskey\\\"\\n```\\nsmiek2121（开卡库）\\n\\n``` bash\\n  ql repo ql repo https://github.com/smiek2121/scripts.git \\\"jd_|gua_\\\" \\\"\\\" \\\"ZooFaker_Necklace.js|JDJRValidator_Pure.js|sign_graphics_validate.js|cleancart_activity.js|jdCookie.js|sendNotify.js\\\"\\n```\\nYun-City/City（集合库）\\n\\n``` bash\\n  ql repo https://github.com/Yun-City/City.git \\\"jd_|jx_|gua_|jddj_|getJDCookie\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|function|utils|sendnotify|ZooFaker_Necklace|jd_Cookie|JDJRValidator_|sign_graphics_validate|ql|magic|cleancart_activity\\\"\\n```\\n6dylan6/jdpro（集合库）任务定时建议50 7-23/2 * * *\\n\\n``` bash\\n  ql repo https://github.com/6dylan6/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\n国内服务器请使用以下命令：\\n\\n``` bash\\n  ql repo https://js.dayplus.xyz/https://github.com/6dylan6/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\n上述方式还不行的话，可以考虑使用 gitee 版本，更新相比 GitHub 可能会稍慢点。\\n\\n``` bash\\n  ql repo https://gitee.com/dylanote/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\ngys619/Absinthe（集合库）\\n\\n``` bash\\n  ql repo https://github.com/gys619/Absinthe.git \\\"jd_|jx_|jddj_|gua_|getJDCookie|wskey\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|utils|ZooFaker_Necklace|JDJRValidator_|sign_graphics_validate|jddj_cookie|function|ql|magic|JDJR|JD\\\" \\\"main\\\"\\n```\\t\\nzero205/JD_tencent_scf\\n``` bash\\n  \\nql repo https://github.com/zero205/JD_tencent_scf.git \\\"jd_|jx_|jdCookie\\\" \\\"backUp|icon\\\" \\\"^jd[^_]|USER|sendNotify|sign_graphics_validate|JDJ', NULL, 1, '\r\n### Error updating database.  Cause: java.sql.SQLSyntaxErrorException: You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use near \'}\' at line 1\r\n### The error may exist in file [F:\\练习项目\\salishBlog\\blog-api\\salishBlog-system\\target\\classes\\mapper\\business\\TTagMapper.xml]\r\n### The error may involve com.salishBlog.business.mapper.TTagMapper.increaseTimes-Inline\r\n### The error occurred while setting parameters\r\n### SQL: update t_tag set times =  times+1 where id = {id}\r\n### Cause: java.sql.SQLSyntaxErrorException: You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use near \'}\' at line 1\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use near \'}\' at line 1', '2022-08-02 10:50:26');
INSERT INTO `sys_oper_log` VALUES (172, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"4\",\"content\":\"KingRan/KR（集合库）\\n\\n``` bash\\n  ql repo https://github.com/KingRan/KR.git \\\"jd_|jx_|jdCookie\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|utils|function|sign|sendNotify|ql|JDJR\\\"\\n```\\nCurtinlv 仓库（库还在，但是长期没有更新，建议停用观察）\\n\\n``` bash\\n  ql repo https://github.com/curtinlv/JD-Script.git\\n```\\nZy143L/wskey（wskey转换库）\\n\\n``` bash\\n  ql repo https://github.com/Zy143L/wskey.git \\\"wskey\\\"\\n```\\n国内的服务器请使用下面这个：\\n\\n``` bash\\n  ql repo https://e.coding.net/HelloDNS/sign/wskey.git \\\"wskey\\\"\\n```\\nsmiek2121（开卡库）\\n\\n``` bash\\n  ql repo ql repo https://github.com/smiek2121/scripts.git \\\"jd_|gua_\\\" \\\"\\\" \\\"ZooFaker_Necklace.js|JDJRValidator_Pure.js|sign_graphics_validate.js|cleancart_activity.js|jdCookie.js|sendNotify.js\\\"\\n```\\nYun-City/City（集合库）\\n\\n``` bash\\n  ql repo https://github.com/Yun-City/City.git \\\"jd_|jx_|gua_|jddj_|getJDCookie\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|function|utils|sendnotify|ZooFaker_Necklace|jd_Cookie|JDJRValidator_|sign_graphics_validate|ql|magic|cleancart_activity\\\"\\n```\\n6dylan6/jdpro（集合库）任务定时建议50 7-23/2 * * *\\n\\n``` bash\\n  ql repo https://github.com/6dylan6/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\n国内服务器请使用以下命令：\\n\\n``` bash\\n  ql repo https://js.dayplus.xyz/https://github.com/6dylan6/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\n上述方式还不行的话，可以考虑使用 gitee 版本，更新相比 GitHub 可能会稍慢点。\\n\\n``` bash\\n  ql repo https://gitee.com/dylanote/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\ngys619/Absinthe（集合库）\\n\\n``` bash\\n  ql repo https://github.com/gys619/Absinthe.git \\\"jd_|jx_|jddj_|gua_|getJDCookie|wskey\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|utils|ZooFaker_Necklace|JDJRValidator_|sign_graphics_validate|jddj_cookie|function|ql|magic|JDJR|JD\\\" \\\"main\\\"\\n```\\t\\nzero205/JD_tencent_scf\\n``` bash\\n  \\nql repo https://github.com/zero205/JD_tencent_scf.git \\\"jd_|jx_|jdCookie\\\" \\\"backUp|icon\\\" \\\"^jd[^_]|USER|sendNotify|sign_graphics_validate|JDJ', NULL, 1, '\r\n### Error updating database.  Cause: com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Incorrect datetime value: \'Tue Aug 02 10:51:29 CST 2022\' for column \'update_time\' at row 1\r\n### The error may exist in com/salishBlog/business/mapper/TBlogMapper.java (best guess)\r\n### The error may involve com.salishBlog.business.mapper.TBlogMapper.updateById-Inline\r\n### The error occurred while setting parameters\r\n### SQL: UPDATE t_blog  SET title=?,  summary=?, content=?, tag_id=?, blog_type=?, content_type=?,   update_time=?, update_by=?  WHERE id=?\r\n### Cause: com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Incorrect datetime value: \'Tue Aug 02 10:51:29 CST 2022\' for column \'update_time\' at row 1\n; Data truncation: Incorrect datetime value: \'Tue Aug 02 10:51:29 CST 2022\' for column \'update_time\' at row 1; nested exception is com.mysql.cj.jdbc.exceptions.MysqlDataTruncation: Data truncation: Incorrect datetime value: \'Tue Aug 02 10:51:29 CST 2022\' for column \'update_time\' at row 1', '2022-08-02 10:51:29');
INSERT INTO `sys_oper_log` VALUES (173, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"4\",\"content\":\"KingRan/KR（集合库）\\n\\n``` bash\\n  ql repo https://github.com/KingRan/KR.git \\\"jd_|jx_|jdCookie\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|utils|function|sign|sendNotify|ql|JDJR\\\"\\n```\\nCurtinlv 仓库（库还在，但是长期没有更新，建议停用观察）\\n\\n``` bash\\n  ql repo https://github.com/curtinlv/JD-Script.git\\n```\\nZy143L/wskey（wskey转换库）\\n\\n``` bash\\n  ql repo https://github.com/Zy143L/wskey.git \\\"wskey\\\"\\n```\\n国内的服务器请使用下面这个：\\n\\n``` bash\\n  ql repo https://e.coding.net/HelloDNS/sign/wskey.git \\\"wskey\\\"\\n```\\nsmiek2121（开卡库）\\n\\n``` bash\\n  ql repo ql repo https://github.com/smiek2121/scripts.git \\\"jd_|gua_\\\" \\\"\\\" \\\"ZooFaker_Necklace.js|JDJRValidator_Pure.js|sign_graphics_validate.js|cleancart_activity.js|jdCookie.js|sendNotify.js\\\"\\n```\\nYun-City/City（集合库）\\n\\n``` bash\\n  ql repo https://github.com/Yun-City/City.git \\\"jd_|jx_|gua_|jddj_|getJDCookie\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|function|utils|sendnotify|ZooFaker_Necklace|jd_Cookie|JDJRValidator_|sign_graphics_validate|ql|magic|cleancart_activity\\\"\\n```\\n6dylan6/jdpro（集合库）任务定时建议50 7-23/2 * * *\\n\\n``` bash\\n  ql repo https://github.com/6dylan6/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\n国内服务器请使用以下命令：\\n\\n``` bash\\n  ql repo https://js.dayplus.xyz/https://github.com/6dylan6/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\n上述方式还不行的话，可以考虑使用 gitee 版本，更新相比 GitHub 可能会稍慢点。\\n\\n``` bash\\n  ql repo https://gitee.com/dylanote/jdpro.git \\\"jd_|jx_|jddj_\\\" \\\"backUp\\\" \\\"^jd[^_]|USER|JD|function|sendNotify\\\"\\n```\\ngys619/Absinthe（集合库）\\n\\n``` bash\\n  ql repo https://github.com/gys619/Absinthe.git \\\"jd_|jx_|jddj_|gua_|getJDCookie|wskey\\\" \\\"activity|backUp\\\" \\\"^jd[^_]|USER|utils|ZooFaker_Necklace|JDJRValidator_|sign_graphics_validate|jddj_cookie|function|ql|magic|JDJR|JD\\\" \\\"main\\\"\\n```\\t\\nzero205/JD_tencent_scf\\n``` bash\\n  \\nql repo https://github.com/zero205/JD_tencent_scf.git \\\"jd_|jx_|jdCookie\\\" \\\"backUp|icon\\\" \\\"^jd[^_]|USER|sendNotify|sign_graphics_validate|JDJ', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-08-02 10:52:53');
INSERT INTO `sys_oper_log` VALUES (174, '博客', 1, 'com.salishBlog.web.controller.business.TBlogController.add()', 'POST', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"1.首先是在官网下载Docker Desktop，这个就不多介绍了小伙伴可以自行百度\\n\\n2.在docker安装完成后检查虚拟化是否开启\\n![Description](https://img-blog.csdnimg.cn/59cfce13333d4052a02416beac1f4bf4.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_19,color_FFFFFF,t_70,g_se,x_16)\\n3.然后再是进入电脑的控制面板->程序->启用或关闭Windows功能->把Hyper-v勾上，启用后电脑会重启，然后把适用于linux的windows的子系统也勾选上。\\n![Description](https://img-blog.csdnimg.cn/2895eb0fed024d38bf9743d2d9890104.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_17,color_FFFFFF,t_70,g_se,x_16)\\n![Description](https://img-blog.csdnimg.cn/2f3de73347ee404d865acbe0cb27c3dc.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_9,color_FFFFFF,t_70,g_se,x_16)\\n4.电脑重启，进入你安装好的 Docker Desktop再设置一下，把这些也勾选上\\n![Description](https://img-blog.csdnimg.cn/69134c0d13174ba08524f8dea0a2e2c4.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_20,color_FFFFFF,t_70,g_se,x_16)\\n5. 接下来正式进入springboot的部署，首先在springboot项目的pom.xml文件中添加Docker镜像名称\\n\\n``` xml\\n<properties>\\n    <docker.image.prefix>springboot</docker.image.prefix>\\n</properties>\\n```\\n6.在plugin中添加docker构建插件\\n``` xml\\n <!-- Docker maven plugin -->\\n            <plugin>\\n                <groupId>com.spotify</groupId>\\n                <artifactId>docker-maven-plugin</artifactId>\\n                <version>1.0.0</version>\\n                <configuration>\\n                    <imageName>parkingapron</imageName>\\n                    <dockerDirectory>src/main/docker</dockerDirectory>\\n                    <dockerHost>http://localhost:2375</dockerHost>\\n                    <resources>\\n                        <resource>\\n                            <targetPath>/</targetPath>\\n                            <directory>${project.build.directory}</directory>\\n                            <include', NULL, 1, 'For input string: \"3,1\"', '2022-08-03 17:52:33');
INSERT INTO `sys_oper_log` VALUES (175, '博客', 1, 'com.salishBlog.web.controller.business.TBlogController.add()', 'POST', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"1.首先是在官网下载Docker Desktop，这个就不多介绍了小伙伴可以自行百度\\n\\n2.在docker安装完成后检查虚拟化是否开启\\n![Description](https://img-blog.csdnimg.cn/59cfce13333d4052a02416beac1f4bf4.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_19,color_FFFFFF,t_70,g_se,x_16)\\n3.然后再是进入电脑的控制面板->程序->启用或关闭Windows功能->把Hyper-v勾上，启用后电脑会重启，然后把适用于linux的windows的子系统也勾选上。\\n![Description](https://img-blog.csdnimg.cn/2895eb0fed024d38bf9743d2d9890104.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_17,color_FFFFFF,t_70,g_se,x_16)\\n![Description](https://img-blog.csdnimg.cn/2f3de73347ee404d865acbe0cb27c3dc.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_9,color_FFFFFF,t_70,g_se,x_16)\\n4.电脑重启，进入你安装好的 Docker Desktop再设置一下，把这些也勾选上\\n![Description](https://img-blog.csdnimg.cn/69134c0d13174ba08524f8dea0a2e2c4.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_20,color_FFFFFF,t_70,g_se,x_16)\\n5. 接下来正式进入springboot的部署，首先在springboot项目的pom.xml文件中添加Docker镜像名称\\n\\n``` xml\\n<properties>\\n    <docker.image.prefix>springboot</docker.image.prefix>\\n</properties>\\n```\\n6.在plugin中添加docker构建插件\\n``` xml\\n <!-- Docker maven plugin -->\\n            <plugin>\\n                <groupId>com.spotify</groupId>\\n                <artifactId>docker-maven-plugin</artifactId>\\n                <version>1.0.0</version>\\n                <configuration>\\n                    <imageName>parkingapron</imageName>\\n                    <dockerDirectory>src/main/docker</dockerDirectory>\\n                    <dockerHost>http://localhost:2375</dockerHost>\\n                    <resources>\\n                        <resource>\\n                            <targetPath>/</targetPath>\\n                            <directory>${project.build.directory}</directory>\\n                            <include', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-08-03 17:52:41');
INSERT INTO `sys_oper_log` VALUES (176, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"1.首先是在官网下载Docker Desktop，这个就不多介绍了小伙伴可以自行百度\\n\\n2.在docker安装完成后检查虚拟化是否开启\\n![Description](https://img-blog.csdnimg.cn/59cfce13333d4052a02416beac1f4bf4.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_19,color_FFFFFF,t_70,g_se,x_16)\\n3.然后再是进入电脑的控制面板->程序->启用或关闭Windows功能->把Hyper-v勾上，启用后电脑会重启，然后把适用于linux的windows的子系统也勾选上。\\n![Description](https://img-blog.csdnimg.cn/2895eb0fed024d38bf9743d2d9890104.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_17,color_FFFFFF,t_70,g_se,x_16)\\n![Description](https://img-blog.csdnimg.cn/2f3de73347ee404d865acbe0cb27c3dc.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_9,color_FFFFFF,t_70,g_se,x_16)\\n4.电脑重启，进入你安装好的 Docker Desktop再设置一下，把这些也勾选上\\n![Description](https://img-blog.csdnimg.cn/69134c0d13174ba08524f8dea0a2e2c4.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_20,color_FFFFFF,t_70,g_se,x_16)\\n5. 接下来正式进入springboot的部署，首先在springboot项目的pom.xml文件中添加Docker镜像名称\\n\\n``` xml\\n<properties>\\n    <docker.image.prefix>springboot</docker.image.prefix>\\n</properties>\\n```\\n6.在plugin中添加docker构建插件\\n``` xml\\n <!-- Docker maven plugin -->\\n            <plugin>\\n                <groupId>com.spotify</groupId>\\n                <artifactId>docker-maven-plugin</artifactId>\\n                <version>1.0.0</version>\\n                <configuration>\\n                    <imageName>parkingapron</imageName>\\n                    <dockerDirectory>src/main/docker</dockerDirectory>\\n                    <dockerHost>http://localhost:2375</dockerHost>\\n                    <resources>\\n                        <resource>\\n                            <targetPath>/</targetPath>\\n                            <directory>${project.build.directory}</directory>\\n                            <include', NULL, 1, 'For input string: \"3,1\"', '2022-08-03 17:52:55');
INSERT INTO `sys_oper_log` VALUES (177, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"1.首先是在官网下载Docker Desktop，这个就不多介绍了小伙伴可以自行百度\\n\\n2.在docker安装完成后检查虚拟化是否开启\\n![Description](https://img-blog.csdnimg.cn/59cfce13333d4052a02416beac1f4bf4.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_19,color_FFFFFF,t_70,g_se,x_16)\\n3.然后再是进入电脑的控制面板->程序->启用或关闭Windows功能->把Hyper-v勾上，启用后电脑会重启，然后把适用于linux的windows的子系统也勾选上。\\n![Description](https://img-blog.csdnimg.cn/2895eb0fed024d38bf9743d2d9890104.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_17,color_FFFFFF,t_70,g_se,x_16)\\n![Description](https://img-blog.csdnimg.cn/2f3de73347ee404d865acbe0cb27c3dc.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_9,color_FFFFFF,t_70,g_se,x_16)\\n4.电脑重启，进入你安装好的 Docker Desktop再设置一下，把这些也勾选上\\n![Description](https://img-blog.csdnimg.cn/69134c0d13174ba08524f8dea0a2e2c4.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_20,color_FFFFFF,t_70,g_se,x_16)\\n5. 接下来正式进入springboot的部署，首先在springboot项目的pom.xml文件中添加Docker镜像名称\\n\\n``` xml\\n<properties>\\n    <docker.image.prefix>springboot</docker.image.prefix>\\n</properties>\\n```\\n6.在plugin中添加docker构建插件\\n``` xml\\n <!-- Docker maven plugin -->\\n            <plugin>\\n                <groupId>com.spotify</groupId>\\n                <artifactId>docker-maven-plugin</artifactId>\\n                <version>1.0.0</version>\\n                <configuration>\\n                    <imageName>parkingapron</imageName>\\n                    <dockerDirectory>src/main/docker</dockerDirectory>\\n                    <dockerHost>http://localhost:2375</dockerHost>\\n                    <resources>\\n                        <resource>\\n                            <targetPath>/</targetPath>\\n                            <directory>${project.build.directory}</directory>\\n                            <include', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-08-03 17:54:32');
INSERT INTO `sys_oper_log` VALUES (178, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"1.首先是在官网下载Docker Desktop，这个就不多介绍了小伙伴可以自行百度\\n\\n2.在docker安装完成后检查虚拟化是否开启\\n![Description](https://img-blog.csdnimg.cn/59cfce13333d4052a02416beac1f4bf4.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_19,color_FFFFFF,t_70,g_se,x_16)\\n3.然后再是进入电脑的控制面板->程序->启用或关闭Windows功能->把Hyper-v勾上，启用后电脑会重启，然后把适用于linux的windows的子系统也勾选上。\\n![Description](https://img-blog.csdnimg.cn/2895eb0fed024d38bf9743d2d9890104.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_17,color_FFFFFF,t_70,g_se,x_16)\\n![Description](https://img-blog.csdnimg.cn/2f3de73347ee404d865acbe0cb27c3dc.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_9,color_FFFFFF,t_70,g_se,x_16)\\n4.电脑重启，进入你安装好的 Docker Desktop再设置一下，把这些也勾选上\\n![Description](https://img-blog.csdnimg.cn/69134c0d13174ba08524f8dea0a2e2c4.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_20,color_FFFFFF,t_70,g_se,x_16)\\n5. 接下来正式进入springboot的部署，首先在springboot项目的pom.xml文件中添加Docker镜像名称\\n\\n``` xml\\n<properties>\\n    <docker.image.prefix>springboot</docker.image.prefix>\\n</properties>\\n```\\n6.在plugin中添加docker构建插件\\n``` xml\\n <!-- Docker maven plugin -->\\n            <plugin>\\n                <groupId>com.spotify</groupId>\\n                <artifactId>docker-maven-plugin</artifactId>\\n                <version>1.0.0</version>\\n                <configuration>\\n                    <imageName>parkingapron</imageName>\\n                    <dockerDirectory>src/main/docker</dockerDirectory>\\n                    <dockerHost>http://localhost:2375</dockerHost>\\n                    <resources>\\n                        <resource>\\n                            <targetPath>/</targetPath>\\n                            <directory>${project.build.directory}</directory>\\n                            <include', NULL, 1, 'For input string: \"3,1\"', '2022-08-03 17:55:28');
INSERT INTO `sys_oper_log` VALUES (179, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"1.首先是在官网下载Docker Desktop，这个就不多介绍了小伙伴可以自行百度\\n\\n2.在docker安装完成后检查虚拟化是否开启\\n![Description](https://img-blog.csdnimg.cn/59cfce13333d4052a02416beac1f4bf4.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_19,color_FFFFFF,t_70,g_se,x_16)\\n3.然后再是进入电脑的控制面板->程序->启用或关闭Windows功能->把Hyper-v勾上，启用后电脑会重启，然后把适用于linux的windows的子系统也勾选上。\\n![Description](https://img-blog.csdnimg.cn/2895eb0fed024d38bf9743d2d9890104.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_17,color_FFFFFF,t_70,g_se,x_16)\\n![Description](https://img-blog.csdnimg.cn/2f3de73347ee404d865acbe0cb27c3dc.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_9,color_FFFFFF,t_70,g_se,x_16)\\n4.电脑重启，进入你安装好的 Docker Desktop再设置一下，把这些也勾选上\\n![Description](https://img-blog.csdnimg.cn/69134c0d13174ba08524f8dea0a2e2c4.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_20,color_FFFFFF,t_70,g_se,x_16)\\n5. 接下来正式进入springboot的部署，首先在springboot项目的pom.xml文件中添加Docker镜像名称\\n\\n``` xml\\n<properties>\\n    <docker.image.prefix>springboot</docker.image.prefix>\\n</properties>\\n```\\n6.在plugin中添加docker构建插件\\n``` xml\\n <!-- Docker maven plugin -->\\n            <plugin>\\n                <groupId>com.spotify</groupId>\\n                <artifactId>docker-maven-plugin</artifactId>\\n                <version>1.0.0</version>\\n                <configuration>\\n                    <imageName>parkingapron</imageName>\\n                    <dockerDirectory>src/main/docker</dockerDirectory>\\n                    <dockerHost>http://localhost:2375</dockerHost>\\n                    <resources>\\n                        <resource>\\n                            <targetPath>/</targetPath>\\n                            <directory>${project.build.directory}</directory>\\n                            <include', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-08-03 17:56:24');
INSERT INTO `sys_oper_log` VALUES (180, '博客', 2, 'com.salishBlog.web.controller.business.TBlogController.edit()', 'PUT', 1, 'admin', NULL, '/tBlog/blog', '127.0.0.1', '内网IP', '{\"blogType\":\"2\",\"content\":\"1.首先是在官网下载Docker Desktop，这个就不多介绍了小伙伴可以自行百度\\n\\n2.在docker安装完成后检查虚拟化是否开启\\n![Description](https://img-blog.csdnimg.cn/59cfce13333d4052a02416beac1f4bf4.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_19,color_FFFFFF,t_70,g_se,x_16)\\n3.然后再是进入电脑的控制面板->程序->启用或关闭Windows功能->把Hyper-v勾上，启用后电脑会重启，然后把适用于linux的windows的子系统也勾选上。\\n![Description](https://img-blog.csdnimg.cn/2895eb0fed024d38bf9743d2d9890104.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_17,color_FFFFFF,t_70,g_se,x_16)\\n![Description](https://img-blog.csdnimg.cn/2f3de73347ee404d865acbe0cb27c3dc.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_9,color_FFFFFF,t_70,g_se,x_16)\\n4.电脑重启，进入你安装好的 Docker Desktop再设置一下，把这些也勾选上\\n![Description](https://img-blog.csdnimg.cn/69134c0d13174ba08524f8dea0a2e2c4.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_20,color_FFFFFF,t_70,g_se,x_16)\\n5. 接下来正式进入springboot的部署，首先在springboot项目的pom.xml文件中添加Docker镜像名称\\n\\n``` xml\\n<properties>\\n    <docker.image.prefix>springboot</docker.image.prefix>\\n</properties>\\n```\\n6.在plugin中添加docker构建插件\\n``` xml\\n <!-- Docker maven plugin -->\\n            <plugin>\\n                <groupId>com.spotify</groupId>\\n                <artifactId>docker-maven-plugin</artifactId>\\n                <version>1.0.0</version>\\n                <configuration>\\n                    <imageName>parkingapron</imageName>\\n                    <dockerDirectory>src/main/docker</dockerDirectory>\\n                    <dockerHost>http://localhost:2375</dockerHost>\\n                    <resources>\\n                        <resource>\\n                            <targetPath>/</targetPath>\\n                            <directory>${project.build.directory}</directory>\\n                            <include', '{\"msg\":\"操作成功\",\"code\":200}', 0, NULL, '2022-08-03 17:56:40');

-- ----------------------------
-- Table structure for sys_post
-- ----------------------------
DROP TABLE IF EXISTS `sys_post`;
CREATE TABLE `sys_post`  (
  `post_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '岗位ID',
  `post_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '岗位编码',
  `post_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '岗位名称',
  `post_sort` int(0) NOT NULL COMMENT '显示顺序',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`post_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '岗位信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_post
-- ----------------------------
INSERT INTO `sys_post` VALUES (1, 'ceo', '董事长', 1, '0', 'admin', '2022-07-20 16:56:50', '', NULL, '');
INSERT INTO `sys_post` VALUES (2, 'se', '项目经理', 2, '0', 'admin', '2022-07-20 16:56:50', '', NULL, '');
INSERT INTO `sys_post` VALUES (3, 'hr', '人力资源', 3, '0', 'admin', '2022-07-20 16:56:50', '', NULL, '');
INSERT INTO `sys_post` VALUES (4, 'user', '普通员工', 4, '0', 'admin', '2022-07-20 16:56:50', '', NULL, '');

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role`  (
  `role_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '角色名称',
  `role_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '角色权限字符串',
  `role_sort` int(0) NOT NULL COMMENT '显示顺序',
  `data_scope` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '1' COMMENT '数据范围（1：全部数据权限 2：自定数据权限 3：本部门数据权限 4：本部门及以下数据权限）',
  `menu_check_strictly` tinyint(1) NULL DEFAULT 1 COMMENT '菜单树选择项是否关联显示',
  `dept_check_strictly` tinyint(1) NULL DEFAULT 1 COMMENT '部门树选择项是否关联显示',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '角色状态（0正常 1停用）',
  `del_flag` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '角色信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role
-- ----------------------------
INSERT INTO `sys_role` VALUES (1, '超级管理员', 'admin', 1, '1', 1, 1, '0', '0', 'admin', '2022-07-20 16:56:50', '', NULL, '超级管理员');
INSERT INTO `sys_role` VALUES (2, '普通角色', 'common', 2, '2', 1, 1, '0', '0', 'admin', '2022-07-20 16:56:50', '', NULL, '普通角色');

-- ----------------------------
-- Table structure for sys_role_dept
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_dept`;
CREATE TABLE `sys_role_dept`  (
  `role_id` bigint(0) NOT NULL COMMENT '角色ID',
  `dept_id` bigint(0) NOT NULL COMMENT '部门ID',
  PRIMARY KEY (`role_id`, `dept_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '角色和部门关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role_dept
-- ----------------------------
INSERT INTO `sys_role_dept` VALUES (2, 100);
INSERT INTO `sys_role_dept` VALUES (2, 101);
INSERT INTO `sys_role_dept` VALUES (2, 105);

-- ----------------------------
-- Table structure for sys_role_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_menu`;
CREATE TABLE `sys_role_menu`  (
  `role_id` bigint(0) NOT NULL COMMENT '角色ID',
  `menu_id` bigint(0) NOT NULL COMMENT '菜单ID',
  PRIMARY KEY (`role_id`, `menu_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '角色和菜单关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role_menu
-- ----------------------------
INSERT INTO `sys_role_menu` VALUES (2, 1);
INSERT INTO `sys_role_menu` VALUES (2, 2);
INSERT INTO `sys_role_menu` VALUES (2, 3);
INSERT INTO `sys_role_menu` VALUES (2, 4);
INSERT INTO `sys_role_menu` VALUES (2, 100);
INSERT INTO `sys_role_menu` VALUES (2, 101);
INSERT INTO `sys_role_menu` VALUES (2, 102);
INSERT INTO `sys_role_menu` VALUES (2, 103);
INSERT INTO `sys_role_menu` VALUES (2, 104);
INSERT INTO `sys_role_menu` VALUES (2, 105);
INSERT INTO `sys_role_menu` VALUES (2, 106);
INSERT INTO `sys_role_menu` VALUES (2, 107);
INSERT INTO `sys_role_menu` VALUES (2, 108);
INSERT INTO `sys_role_menu` VALUES (2, 109);
INSERT INTO `sys_role_menu` VALUES (2, 110);
INSERT INTO `sys_role_menu` VALUES (2, 111);
INSERT INTO `sys_role_menu` VALUES (2, 112);
INSERT INTO `sys_role_menu` VALUES (2, 113);
INSERT INTO `sys_role_menu` VALUES (2, 114);
INSERT INTO `sys_role_menu` VALUES (2, 115);
INSERT INTO `sys_role_menu` VALUES (2, 116);
INSERT INTO `sys_role_menu` VALUES (2, 117);
INSERT INTO `sys_role_menu` VALUES (2, 500);
INSERT INTO `sys_role_menu` VALUES (2, 501);
INSERT INTO `sys_role_menu` VALUES (2, 1000);
INSERT INTO `sys_role_menu` VALUES (2, 1001);
INSERT INTO `sys_role_menu` VALUES (2, 1002);
INSERT INTO `sys_role_menu` VALUES (2, 1003);
INSERT INTO `sys_role_menu` VALUES (2, 1004);
INSERT INTO `sys_role_menu` VALUES (2, 1005);
INSERT INTO `sys_role_menu` VALUES (2, 1006);
INSERT INTO `sys_role_menu` VALUES (2, 1007);
INSERT INTO `sys_role_menu` VALUES (2, 1008);
INSERT INTO `sys_role_menu` VALUES (2, 1009);
INSERT INTO `sys_role_menu` VALUES (2, 1010);
INSERT INTO `sys_role_menu` VALUES (2, 1011);
INSERT INTO `sys_role_menu` VALUES (2, 1012);
INSERT INTO `sys_role_menu` VALUES (2, 1013);
INSERT INTO `sys_role_menu` VALUES (2, 1014);
INSERT INTO `sys_role_menu` VALUES (2, 1015);
INSERT INTO `sys_role_menu` VALUES (2, 1016);
INSERT INTO `sys_role_menu` VALUES (2, 1017);
INSERT INTO `sys_role_menu` VALUES (2, 1018);
INSERT INTO `sys_role_menu` VALUES (2, 1019);
INSERT INTO `sys_role_menu` VALUES (2, 1020);
INSERT INTO `sys_role_menu` VALUES (2, 1021);
INSERT INTO `sys_role_menu` VALUES (2, 1022);
INSERT INTO `sys_role_menu` VALUES (2, 1023);
INSERT INTO `sys_role_menu` VALUES (2, 1024);
INSERT INTO `sys_role_menu` VALUES (2, 1025);
INSERT INTO `sys_role_menu` VALUES (2, 1026);
INSERT INTO `sys_role_menu` VALUES (2, 1027);
INSERT INTO `sys_role_menu` VALUES (2, 1028);
INSERT INTO `sys_role_menu` VALUES (2, 1029);
INSERT INTO `sys_role_menu` VALUES (2, 1030);
INSERT INTO `sys_role_menu` VALUES (2, 1031);
INSERT INTO `sys_role_menu` VALUES (2, 1032);
INSERT INTO `sys_role_menu` VALUES (2, 1033);
INSERT INTO `sys_role_menu` VALUES (2, 1034);
INSERT INTO `sys_role_menu` VALUES (2, 1035);
INSERT INTO `sys_role_menu` VALUES (2, 1036);
INSERT INTO `sys_role_menu` VALUES (2, 1037);
INSERT INTO `sys_role_menu` VALUES (2, 1038);
INSERT INTO `sys_role_menu` VALUES (2, 1039);
INSERT INTO `sys_role_menu` VALUES (2, 1040);
INSERT INTO `sys_role_menu` VALUES (2, 1041);
INSERT INTO `sys_role_menu` VALUES (2, 1042);
INSERT INTO `sys_role_menu` VALUES (2, 1043);
INSERT INTO `sys_role_menu` VALUES (2, 1044);
INSERT INTO `sys_role_menu` VALUES (2, 1045);
INSERT INTO `sys_role_menu` VALUES (2, 1046);
INSERT INTO `sys_role_menu` VALUES (2, 1047);
INSERT INTO `sys_role_menu` VALUES (2, 1048);
INSERT INTO `sys_role_menu` VALUES (2, 1049);
INSERT INTO `sys_role_menu` VALUES (2, 1050);
INSERT INTO `sys_role_menu` VALUES (2, 1051);
INSERT INTO `sys_role_menu` VALUES (2, 1052);
INSERT INTO `sys_role_menu` VALUES (2, 1053);
INSERT INTO `sys_role_menu` VALUES (2, 1054);
INSERT INTO `sys_role_menu` VALUES (2, 1055);
INSERT INTO `sys_role_menu` VALUES (2, 1056);
INSERT INTO `sys_role_menu` VALUES (2, 1057);
INSERT INTO `sys_role_menu` VALUES (2, 1058);
INSERT INTO `sys_role_menu` VALUES (2, 1059);

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user`  (
  `user_id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT '用户ID',
  `dept_id` bigint(0) NULL DEFAULT NULL COMMENT '部门ID',
  `user_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '用户账号',
  `nick_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '用户昵称',
  `user_type` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '00' COMMENT '用户类型（00系统用户）',
  `email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '用户邮箱',
  `phonenumber` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '手机号码',
  `sex` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '0' COMMENT '用户性别（0男 1女 2未知）',
  `avatar` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '头像地址',
  `password` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '密码',
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '0' COMMENT '帐号状态（0正常 1停用）',
  `del_flag` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `login_ip` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '最后登录IP',
  `login_date` datetime(0) NULL DEFAULT NULL COMMENT '最后登录时间',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '用户信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user
-- ----------------------------
INSERT INTO `sys_user` VALUES (1, 103, 'admin', '若依', '00', 'ry@163.com', '15888888888', '1', '', '$2a$10$7JB720yubVSZvUI0rEqK/.VqGOZTH.ulu33dHOiBE8ByOhJIrdAu2', '0', '0', '127.0.0.1', '2022-08-03 17:45:30', 'admin', '2022-07-20 16:56:49', '', '2022-08-03 17:45:30', '管理员');
INSERT INTO `sys_user` VALUES (2, 105, 'ry', '若依', '00', 'ry@qq.com', '15666666666', '1', '', '$2a$10$7JB720yubVSZvUI0rEqK/.VqGOZTH.ulu33dHOiBE8ByOhJIrdAu2', '0', '0', '127.0.0.1', '2022-07-20 16:56:49', 'admin', '2022-07-20 16:56:49', '', NULL, '测试员');

-- ----------------------------
-- Table structure for sys_user_post
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_post`;
CREATE TABLE `sys_user_post`  (
  `user_id` bigint(0) NOT NULL COMMENT '用户ID',
  `post_id` bigint(0) NOT NULL COMMENT '岗位ID',
  PRIMARY KEY (`user_id`, `post_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '用户与岗位关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_post
-- ----------------------------
INSERT INTO `sys_user_post` VALUES (1, 1);
INSERT INTO `sys_user_post` VALUES (2, 2);

-- ----------------------------
-- Table structure for sys_user_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_role`;
CREATE TABLE `sys_user_role`  (
  `user_id` bigint(0) NOT NULL COMMENT '用户ID',
  `role_id` bigint(0) NOT NULL COMMENT '角色ID',
  PRIMARY KEY (`user_id`, `role_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '用户和角色关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_role
-- ----------------------------
INSERT INTO `sys_user_role` VALUES (1, 1);
INSERT INTO `sys_user_role` VALUES (2, 2);

-- ----------------------------
-- Table structure for t_blog
-- ----------------------------
DROP TABLE IF EXISTS `t_blog`;
CREATE TABLE `t_blog`  (
  `id` int(0) NOT NULL AUTO_INCREMENT COMMENT '博客id',
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL COMMENT '标题',
  `cover` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '封面',
  `summary` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '简介',
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL COMMENT '内容',
  `tag_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '标签id',
  `blog_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '类型',
  `content_type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '内容类型',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '创建人',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '更新人',
  `is_delete` tinyint(0) NULL DEFAULT NULL COMMENT '是否删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 6 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_blog
-- ----------------------------
INSERT INTO `t_blog` VALUES (2, 'jar包加密', 'http://localhost:9091/profile/upload/2022/07/27/04e812ad38dc63cd9d94b879df76fa23_20220727173207A001.jpeg', '使用xjar工具给jar包加密', '<p><span style=\"color: rgb(77, 77, 77);\">如何对jar包进行</span><a href=\"https://so.csdn.net/so/search?q=%E5%8A%A0%E5%AF%86&amp;spm=1001.2101.3001.7020\" rel=\"noopener noreferrer\" target=\"_blank\" style=\"color: rgb(252, 85, 49); background-color: transparent;\">加密</a><span style=\"color: rgb(77, 77, 77);\">呢？其实没有想象中的那么困难，有一款开源工具已经提供了较为完善的加密方案，这款开源工具的名字叫做xjar。接下来我们就看一下使用xjar工具给jar包加密有多么的容易。</span></p><p><br></p><h2><strong style=\"color: rgb(79, 79, 79);\">前言</strong></h2><p><span style=\"color: rgb(77, 77, 77);\">jar包相信大家都很熟悉，是通过打包java工程而获得的产物，但是jar包是有一个致命的缺点的，那就是很容易被反编译，只需要使用jd-gui就可以很容易的获取到java源码。</span></p><p><span style=\"color: rgb(77, 77, 77);\">如果你想要防止别人反编译做逆向工程，那么对jar包进行一次加密就是一项很重要的工作了。</span></p><p><span style=\"color: rgb(77, 77, 77);\">开源jar加密分为两种一种代码混淆，一种</span><a href=\"https://so.csdn.net/so/search?q=%E5%AD%97%E8%8A%82%E7%A0%81&amp;spm=1001.2101.3001.7020\" rel=\"noopener noreferrer\" target=\"_blank\" style=\"color: rgb(252, 85, 49); background-color: transparent;\">字节码</a><span style=\"color: rgb(77, 77, 77);\">转换。</span></p><p><span style=\"color: rgb(77, 77, 77);\">字节码混淆，主要思路就是的对类名，变量名和方法名，局部参数名进行替换，让其命名变得无意义，很难读懂，但不影响其逻辑，但对于有耐心的人，还是能看明白！具体实现是在编译前做的混淆，还是编译后做的混淆，这个没用过不太清楚。</span></p><p><span style=\"color: rgb(77, 77, 77);\">字节码转换，分为两块，一块是加密，对编译后class文件进行字节码转换(可以采用加密算法，字节码异或运算或自己定义规则)；一块是解密，就是在类加载的时候对加密的字节码进行解密。加密这块因为在本地对class文件字节码转换，比较简单，方式也随意；解密这块主要围绕类加载器来做文章，又可分为java版实现和C/C++版实现，java版主要基于-agentJava:xxx.jar，通过Premain-Class，向Instrumentation注入ClassFileTransformer实现，自己在ClassFileTransformer中对需要解密的class文件进行解密；C/C++主要使用-agentpath:xxx.so，基于JVMTI通过C/C++实现，对类加载过程进行操作。</span></p><p><span style=\"color: rgb(77, 77, 77);\">总体来说：代码混淆和字节码转换可以结合，例如，先代码混淆后，再对字节码加密，运行时对字节码解密。代码混淆，上手最简单，加密级别比较低，也容易破解。字节码转换，java版本对于java熟练人员上手很快，加密级别一般，个人理解该方式一个缺陷就是对于想加密的内容加密了，但解密方式暴露了，如果能够隐藏好解密方式，加密安全系数还是蛮高；C/C++版加密级别最高，但需要对java和C/C++都很熟练，而且需要研究JVMTI相关知识，如果真的实现了基本无破解风险，不过对于SpringBoot等框架，其内部会直接分析class文件，有些坑需要解决。</span></p><p><span style=\"color: rgb(77, 77, 77);\">另外一个问题就是，使用jar加密这块，需要确定好是对运行的主程序jar包加密，还是第三方jar加密，其还是有部分差异的。</span></p><p><br></p><h2><strong style=\"color: rgb(79, 79, 79);\">基础环境准备</strong></h2><p><span style=\"color: rgb(77, 77, 77);\">现在假设你的项目是一个maven项目（目前不使用maven的项目已经不多了），那么加密起来特别的容易，</span></p><p><span style=\"color: rgb(77, 77, 77);\">首先就是要在你的pom文件中增加插件仓库地址，如下：\n	\n``` xml\n<pluginRepositories>\n<pluginRepository>\n<id>jitpack.io</id>\n<url>https://jitpack.io</url>\n</pluginRepository>\n</pluginRepositories>\n```\n\n然后在pom文件中增加如下插件\n	\n``` xml\n<plugin>\n<groupId>com.github.core-lib</groupId>\n<artifactId>xjar-maven-plugin</artifactId>\n<version>4.0.1</version>\n<executions>\n<execution>\n<goals>\n<goal>build</goal>\n</goals>\n<phase>install</phase>\n<configuration>\n<includes>\n<include>/com/huc/**/*.class</include>\n<include>/mapper/**/*Mapper.xml</include>\n<include>/*.yml</include>\n</includes>\n<excludes>\n<exclude>/templates/**.*</exclude>\n<exclude>/static/**.*</exclude>\n</excludes>\n</configuration>\n</execution>\n</executions>\n</plugin>\n```\n这样，我们的准备工作就做完了，需要注意的是，includes代表我们想要加密的内容，采用的是Ant表达式，excludes代表的是不需要加密的内容，同样使用的Ant表达式。</span></p><p><span style=\"color: rgb(77, 77, 77);\">一般情况下我们建议这两处内容必填，如果不填写，会加密整个jar包中的所有文件，这样其实是没有必要的，而且全部加密后启动的时候也可能产生意料之外的错误。</span></p><p><span style=\"color: rgb(77, 77, 77);\">另外要说明的是，加密后的jar包是需要通过golang环境运行的，所以我们需要提前把golang的运行环境安装好，安装过程请自行百度。</span></p><p><br></p><h2><strong style=\"color: rgb(79, 79, 79);\">开始加密</strong></h2><p><span style=\"color: rgb(77, 77, 77);\">现在我们就开始正式的加密工作了，加密过程非常简单，只需要使用maven的install命令即可自动打包，命令如下：</span></p>\n``` shell\n  mvn clean install -Dxjar.password=password -Dmaven.test.skip=true\n```\n<p><span style=\"color: rgb(77, 77, 77);\">这里的password可以自行指定密码，是必填项。</span></p><p><span style=\"color: rgb(77, 77, 77);\">执行后就会得到两个文件：一个是xjar.go的go源文件，一个是你项目的xjar包，也就是加密后的jar包。</span></p><p><br></p><h2><strong style=\"color: rgb(79, 79, 79);\">运行加密后的jar包</strong></h2><p><span style=\"color: rgb(77, 77, 77);\">运行加密后的jar包是需要先编译xjar.go源文件生成jar包启动器的。编译方式如下：</span></p>\n\n``` shell\n	go build ./xjar.go\n```\n\n<p><span style=\"color: rgb(77, 77, 77);\">编译后会生成xjar.exe启动器（王子使用的是window系统，如果是linux系统就不是exe后缀了）。</span></p><p><span style=\"color: rgb(77, 77, 77);\">之后使用如下命令即可运行加密后的jar包：</span></p>\n\n\n``` shell\n  ./xjar.exe java -jar ./**.xjar\n```\n\n<p><span style=\"color: rgb(77, 77, 77);\">可以看出，只是在使用java -jar的前边加上启动器即可，还是很方便的。</span></p><p><br></p><h2><strong style=\"color: rgb(79, 79, 79);\">后记</strong></h2><p><span style=\"color: rgb(77, 77, 77);\">防止反编译只能防止jar包被逆向破解，如果想要限制用户的使用时间，按时间付费需要怎么做呢？</span></p><p><span style=\"color: rgb(77, 77, 77);\">这就要说到license加密技术了，我们下篇文章就来说说如何在你的项目中增加license，限制用户的使用。</span></p><p><br></p><h2><strong style=\"color: rgb(79, 79, 79);\">其他的加密方案参考:</strong></h2><p><span style=\"color: rgb(77, 77, 77);\">ClassFinal：</span><a href=\"https://link.zhihu.com/?target=https%3A//gitee.com/roseboy/classfinal\" rel=\"noopener noreferrer\" target=\"_blank\" style=\"color: rgb(78, 161, 219);\">Mr.K/ClassFinal</a></p><p><span style=\"color: rgb(77, 77, 77);\">基于字节码转换java版，国人实现的，蛮不错的，对SpringBoot支持也好，其逻辑就是基于-agentJava:xxx.jar这一套原理，加密时对class文件做了两次处理，一次是对class文件的字节码完全加密，一次是对class文件混淆，这个混淆是保留成员和方法，对方法内部实现进行隐藏；解密时，判断如果该类是自己加密过的，找到完全加密的字节码进行解密，如果不是自己加密的就跳过。其对class文件混淆，就是方便类似SpringBoot等三方框架直接分析class文件。好处就是，如果你是个工具包，加密后给其它人，其他人编程时引用或者编译都不影响，但是运行时需要加密方支持，给出秘钥之类的。比较灵活和好用，也存在该方式的统一缺陷，不过其支持主程序jar加密，也支持单独的第三方工具jar加密。</span></p><p><span style=\"color: rgb(77, 77, 77);\">JarEncrypt：</span><a href=\"https://github.com/zhikun0704/api-zxv-jvmit\" rel=\"noopener noreferrer\" target=\"_blank\" style=\"color: rgb(78, 161, 219);\">https://github.com/zhikun0704/api-zxv-jvmit</a></p><p><span style=\"color: rgb(77, 77, 77);\">基于字节码转换C/C++版，基于JVMIT个人实现的，稍微研究了下，其支持对部分class加密，对应一般java应用问题不大，但对于SpringBoot项目支持可能有些问题。因本人C++水平有限，没有深层次研究，希望有C/C++和java都熟悉的大神有空搞一套完整的。</span></p>\n\n\n转载自 <a href=\"https://blog.csdn.net/lisiping317/article/details/123256984\">jar包加密方案</a>', '1', '2', '1', '2022-07-25 14:58:22', '若依', '2022-07-29 16:38:20', '若依', NULL);
INSERT INTO `t_blog` VALUES (5, '青龙面板脚本', NULL, '2022-8-1 青龙 京东', 'KingRan/KR（集合库）\n\n``` bash\n  ql repo https://github.com/KingRan/KR.git \"jd_|jx_|jdCookie\" \"activity|backUp\" \"^jd[^_]|USER|utils|function|sign|sendNotify|ql|JDJR\"\n```\nCurtinlv 仓库（库还在，但是长期没有更新，建议停用观察）\n\n``` bash\n  ql repo https://github.com/curtinlv/JD-Script.git\n```\nZy143L/wskey（wskey转换库）\n\n``` bash\n  ql repo https://github.com/Zy143L/wskey.git \"wskey\"\n```\n国内的服务器请使用下面这个：\n\n``` bash\n  ql repo https://e.coding.net/HelloDNS/sign/wskey.git \"wskey\"\n```\nsmiek2121（开卡库）\n\n``` bash\n  ql repo ql repo https://github.com/smiek2121/scripts.git \"jd_|gua_\" \"\" \"ZooFaker_Necklace.js|JDJRValidator_Pure.js|sign_graphics_validate.js|cleancart_activity.js|jdCookie.js|sendNotify.js\"\n```\nYun-City/City（集合库）\n\n``` bash\n  ql repo https://github.com/Yun-City/City.git \"jd_|jx_|gua_|jddj_|getJDCookie\" \"activity|backUp\" \"^jd[^_]|USER|function|utils|sendnotify|ZooFaker_Necklace|jd_Cookie|JDJRValidator_|sign_graphics_validate|ql|magic|cleancart_activity\"\n```\n6dylan6/jdpro（集合库）任务定时建议50 7-23/2 * * *\n\n``` bash\n  ql repo https://github.com/6dylan6/jdpro.git \"jd_|jx_|jddj_\" \"backUp\" \"^jd[^_]|USER|JD|function|sendNotify\"\n```\n国内服务器请使用以下命令：\n\n``` bash\n  ql repo https://js.dayplus.xyz/https://github.com/6dylan6/jdpro.git \"jd_|jx_|jddj_\" \"backUp\" \"^jd[^_]|USER|JD|function|sendNotify\"\n```\n上述方式还不行的话，可以考虑使用 gitee 版本，更新相比 GitHub 可能会稍慢点。\n\n``` bash\n  ql repo https://gitee.com/dylanote/jdpro.git \"jd_|jx_|jddj_\" \"backUp\" \"^jd[^_]|USER|JD|function|sendNotify\"\n```\ngys619/Absinthe（集合库）\n\n``` bash\n  ql repo https://github.com/gys619/Absinthe.git \"jd_|jx_|jddj_|gua_|getJDCookie|wskey\" \"activity|backUp\" \"^jd[^_]|USER|utils|ZooFaker_Necklace|JDJRValidator_|sign_graphics_validate|jddj_cookie|function|ql|magic|JDJR|JD\" \"main\"\n```	\nzero205/JD_tencent_scf\n``` bash\n  \nql repo https://github.com/zero205/JD_tencent_scf.git \"jd_|jx_|jdCookie\" \"backUp|icon\" \"^jd[^_]|USER|sendNotify|sign_graphics_validate|JDJR|JDSign|ql\" \"main\"\n```', '3', '4', '1', '2022-08-01 09:14:59', '若依', '2022-08-02 10:52:53', '若依', NULL);
INSERT INTO `t_blog` VALUES (6, 'windows10上安装docker，在docker中部署springboot项目', NULL, NULL, '1.首先是在官网下载Docker Desktop，这个就不多介绍了小伙伴可以自行百度\n\n2.在docker安装完成后检查虚拟化是否开启\n![Description](https://img-blog.csdnimg.cn/59cfce13333d4052a02416beac1f4bf4.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_19,color_FFFFFF,t_70,g_se,x_16)\n3.然后再是进入电脑的控制面板->程序->启用或关闭Windows功能->把Hyper-v勾上，启用后电脑会重启，然后把适用于linux的windows的子系统也勾选上。\n![Description](https://img-blog.csdnimg.cn/2895eb0fed024d38bf9743d2d9890104.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_17,color_FFFFFF,t_70,g_se,x_16)\n![Description](https://img-blog.csdnimg.cn/2f3de73347ee404d865acbe0cb27c3dc.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_9,color_FFFFFF,t_70,g_se,x_16)\n4.电脑重启，进入你安装好的 Docker Desktop再设置一下，把这些也勾选上\n![Description](https://img-blog.csdnimg.cn/69134c0d13174ba08524f8dea0a2e2c4.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_20,color_FFFFFF,t_70,g_se,x_16)\n5. 接下来正式进入springboot的部署，首先在springboot项目的pom.xml文件中添加Docker镜像名称\n\n``` xml\n<properties>\n    <docker.image.prefix>springboot</docker.image.prefix>\n</properties>\n```\n6.在plugin中添加docker构建插件\n``` xml\n <!-- Docker maven plugin -->\n            <plugin>\n                <groupId>com.spotify</groupId>\n                <artifactId>docker-maven-plugin</artifactId>\n                <version>1.0.0</version>\n                <configuration>\n                    <imageName>parkingapron</imageName>\n                    <dockerDirectory>src/main/docker</dockerDirectory>\n                    <dockerHost>http://localhost:2375</dockerHost>\n                    <resources>\n                        <resource>\n                            <targetPath>/</targetPath>\n                            <directory>${project.build.directory}</directory>\n                            <include>${project.build.finalName}.jar</include>\n                        </resource>\n                    </resources>\n                </configuration>\n                <dependencies>\n                    <dependency>\n                        <groupId>javax.activation</groupId>\n                        <artifactId>activation</artifactId>\n                        <version>1.1.1</version>\n                    </dependency>\n                </dependencies>\n            </plugin>\n<!-- Docker maven plugin -->\n<imageName> 这个就是镜像名称，必须要全小写，我写的是我的项目名称\n\n<dockerHost>这个是docker的地址\n```\n7.然后我们需要在java的同级目录main下面建一个docker文件夹并编写Dockerfile文件,Dockerfile相当于说明书，告诉docker容器应该如何运行项目，规定项目运行的一些规则\n![Description](https://img-blog.csdnimg.cn/10e65c91a2e54014900ca2f31b2b3dbb.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_20,color_FFFFFF,t_70,g_se,x_16)\n```\nFROM openjdk:8-jdk-alpine\nVOLUME /tmp\nADD EFParkingApron.jar /app.jar\nENTRYPOINT [\"java\",\"-Djava.security.egd=file:/dev/./urandom\",\"-jar\",\"/app.jar\"]\nEXPOSE 8080\n```\nFROM：表示基础镜像，即运行环境 jdk8\n\nVOLUME：一个特别指定的目录，用于存储数据，该命令的作用是在/var/lib/docker创建一个名为tmp的目录，在开启redis服务时，需要特别指定redis的数据存储在哪个文件夹，此时这个命令就十分有用\n\nADD：拷贝文件并且重命名,这个放你们自己项目的名字，\n\nEXPOSE：并不是真正的发布端口，这个只是容器部署人员与建立image的人员之间的交流，即建立image的人员告诉容器布署人员容器应该映射哪个端口给外界\n\nENTRYPOINT：容器启动时运行的命令，相当于我们在命令行中输入java -jar xxxx.jar，为了缩短 Tomcat 的启动时间，添加java.security.egd的系统属性指向/dev/urandom作为 ENTRYPOINT\n\n8.在docker上安装mysql\ncmd命令提示符进入\n```\ndockers pull mysql\nmysql运行命令\ndocker run  -p 3307:3306 -e MYSQL_ROOT_PASSWORD=123456 -d mysql\n```\n在后台启动mysql，并将密码设置为123456，如果我们本机上运行了mysql，可以将上述的-p参数改为3307：3306，-p表示端口映射，冒号左边为docker容器外的端口号，右边为容器内的端口号，-d表示后台运行 docker表示REPOSITORY的值\n\n然后命令查看正在运行的容器，\n```\ndocker ps\n```\n![Description](https://img-blog.csdnimg.cn/7844378fb0ed488e948f1814c16e7d7c.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_20,color_FFFFFF,t_70,g_se,x_16)\n 然后以此安装项目中需要的redis等等，这些都安装完成后，再到咱们的yml里面修改配置文件\n\n把你的redis端口号改成docker的外部暴露端口号，我的改为了6380，然后数据库地址也要改，改为你的ip地址加端口号我的端口号改为了3307，上面灰色的就是开始服务器的地址\n![Description](https://img-blog.csdnimg.cn/db85654d744f4be28ceca1682063c46d.png)\n\n 你可以用Navicat可视化工具连接你的docker里面的mysql，把你的sql文件导入进去，\n\n这些你都做好后，你可以打包部署了，首先clean，package，然后再docker：build\n![Description](https://img-blog.csdnimg.cn/80482bbb81194c7393c08171499d2c86.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_10,color_FFFFFF,t_70,g_se,x_16)\n 然后你就可以看到你的docker小鲸鱼有你部署的东西\n\n![Description](https://img-blog.csdnimg.cn/7c7551bdb03647ce829993fcd8ca6522.png?x-oss-process=image/watermark,type_d3F5LXplbmhlaQ,shadow_50,text_Q1NETiBA5piO5aSp5Lmf5piv5aSq6Ziz6Iqx77yB,size_20,color_FFFFFF,t_70,g_se,x_16)\n\n然后点进去可以看到你的项目正在运行 ，以上就是windows的docker部署springboot项目，这也是我自己摸索两天玩明白的，里面还有很多细节没讲到，兄弟们按照这个步骤肯定是可以的，记录一下。\n————————————————\n版权声明：本文为CSDN博主「明天也是太阳花！」的原创文章，遵循CC 4.0 BY-SA版权协议，转载请附上原文出处链接及本声明。\n原文链接：https://blog.csdn.net/m0_61367109/article/details/123631038', '3,1', '2', '1', '2022-08-03 17:52:42', '若依', '2022-08-03 17:56:37', '若依', NULL);

-- ----------------------------
-- Table structure for t_tag
-- ----------------------------
DROP TABLE IF EXISTS `t_tag`;
CREATE TABLE `t_tag`  (
  `id` int(0) NOT NULL AUTO_INCREMENT COMMENT '标签id',
  `tag` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '标签',
  `tag_color` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '标签色彩',
  `times` int(0) NULL DEFAULT 0 COMMENT '访问次数',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_tag
-- ----------------------------
INSERT INTO `t_tag` VALUES (1, 'java', 'rgba(136, 204, 141, 0.73)', 2);
INSERT INTO `t_tag` VALUES (2, 'vue', 'rgba(30, 144, 255, 1)', 0);
INSERT INTO `t_tag` VALUES (3, '工具', 'rgba(225, 145, 33, 0.87)', 2);
INSERT INTO `t_tag` VALUES (4, 'nas', 'rgba(48, 215, 176, 0.87)', 0);

SET FOREIGN_KEY_CHECKS = 1;
