package mnj.ont.model.services;

import java.math.BigDecimal;

import java.sql.CallableStatement;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

import java.sql.SQLException;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;

import java.util.Set;

import javax.faces.application.FacesMessage;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

import javax.servlet.http.HttpSession;

import mnj.ont.model.lov.vo.popuplineVOImpl;
import mnj.ont.model.services.common.AppModule;
import mnj.ont.model.views.BomBpoLinesAllVOImpl;

import mnj.ont.model.views.CustMnjOntBomHeaderViewImpl;
import mnj.ont.model.views.CustMnjOntBomOblineDetailsViewImpl;
import mnj.ont.model.views.CustMnjOntBomRmlineLinesViewImpl;
import mnj.ont.model.views.CustMnjOntBomRmlineLinesViewRowImpl;
import mnj.ont.model.views.POInformationVOImpl;
import mnj.ont.model.views.PopulateVOImpl;

import oracle.binding.BindingContainer;

import oracle.adf.model.BindingContext;

import oracle.binding.OperationBinding;

import oracle.jbo.Row;
import oracle.jbo.RowIterator;
import oracle.jbo.RowSetIterator;
import oracle.jbo.ViewObject;
import oracle.jbo.common.RowSetIteratorHelper;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.TransactionEvent;
import oracle.jbo.server.ViewLinkImpl;


import oracle.jbo.server.ViewObjectImpl;

import oracle.jdbc.OracleTypes;
// ---------------------------------------------------------------------
// ---    File generated by Oracle ADF Business Components Design Time.
// ---    Mon Feb 09 18:38:09 PKT 2015
// ---    Custom code may be added to this class.
// ---    Warning: Do not modify method signatures of generated methods.
// ---------------------------------------------------------------------
public class AppModuleImpl extends ApplicationModuleImpl implements AppModule {
    /**
     * This is the default constructor (do not remove).
     */
    public AppModuleImpl() {
    }

    /**
     * Container's getter for CustMnjOntBomHeaderView1.
     * @return CustMnjOntBomHeaderView1
     */
    public ViewObjectImpl getCustMnjOntBomHeaderView1() {
        return (ViewObjectImpl)findViewObject("CustMnjOntBomHeaderView1");
    }

    /**
     * Container's getter for CustMnjOntBomRmlineLinesView1.
     * @return CustMnjOntBomRmlineLinesView1
     */
    public ViewObjectImpl getCustMnjOntBomRmlineLinesView1() {
        return (ViewObjectImpl)findViewObject("CustMnjOntBomRmlineLinesView1");
    }

    /**
     * Container's getter for CustMnjOntBomOblineDetailsView1.
     * @return CustMnjOntBomOblineDetailsView1
     */
    public ViewObjectImpl getCustMnjOntBomOblineDetailsView1() {
        return (ViewObjectImpl)findViewObject("CustMnjOntBomOblineDetailsView1");
    }

    /**
     * Container's getter for PkBomLineFkLink1.
     * @return PkBomLineFkLink1
     */
    public ViewLinkImpl getPkBomLineFkLink1() {
        return (ViewLinkImpl)findViewLink("PkBomLineFkLink1");
    }

    /**
     * Container's getter for CustMnjOntBomOblineFkLink1.
     * @return CustMnjOntBomOblineFkLink1
     */
    public ViewLinkImpl getCustMnjOntBomOblineFkLink1() {
        return (ViewLinkImpl)findViewLink("CustMnjOntBomOblineFkLink1");
    }

    public void fetchLines() {

        return;

    } //end of fetch lines method

    public void fetchMethod(oracle.jbo.domain.Number pId) {


        ViewObject populatevo = getPopulateVO1();
        populatevo.setWhereClause("HEADER_ID = " + pId);
        populatevo.executeQuery();


        if (populatevo.getRowCount() == 0)
            ;
        RowSetIterator it = populatevo.createRowSetIterator("ll");

        while (it.hasNext()) {

            Row r = it.next();
            populateLines(r);
        }

        it.closeRowSetIterator();
    }


    public void showRecords() {

    } //end of showRecords

    public void populateLines(Row poprow) {

        Row linerow = createLines();
        linerow.setAttribute("InventoryItemId",
                             getPopulateValue(poprow, "InventoryItemId"));
        linerow.setAttribute("ItemCode", getPopulateValue(poprow, "ItemCode"));
        linerow.setAttribute("PDesc", getPopulateValue(poprow, "Prefix"));
        linerow.setAttribute("MeasureUnitId",
                             getPopulateValue(poprow, "PrimaryUomCode"));
        linerow.setAttribute("UsageMoUnit",
                             getPopulateValue(poprow, "RawmaterialPcons"));
        linerow.setAttribute("Rate",
                             getPopulateValue(poprow, "RawmaterialRate"));
        linerow.setAttribute("ItemDesc",
                             getPopulateValue(poprow, "Description")); //LegacyCode


    } //end of populateLines

    public Row createLines() {

        ViewObject vo = getCustMnjOntBomRmlineLinesView1();
        Row row = vo.createRow();
        vo.insertRow(row);
        row.setNewRowState(Row.STATUS_INITIALIZED);
        return row;
    } //end of createHeader

    public String getPopulateValue(Row r, String columnName) {

        String value = null;
        try {
            value = r.getAttribute(columnName).toString();
        } catch (Exception e) {
            ;
        }
        return value;
    }

    /**
     * Container's getter for PopulateVO1.
     * @return PopulateVO1
     */
    public ViewObjectImpl getPopulateVO1() {
        return (ViewObjectImpl)findViewObject("PopulateVO1");
    }

    public int callPost(String hederId) {
        int srno = 0;
        String stmt =
            "BEGIN :1 := cust_mnj_ont_pkg.cust_mnj_ont_bom_revision(:2,:3); end;";
        java.sql.CallableStatement cs =
            getDBTransaction().createCallableStatement(stmt, 1);
        try {
            cs.registerOutParameter(1, oracle.jdbc.OracleTypes.VARCHAR);
            cs.setString(2, hederId);
            cs.setString(3, " ");
            cs.execute();
            cs.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return srno;
    }


    public String createPR(String bomId, String bomLineId) {

        System.out.println("----------createPR Func-----------");
        String stmt =
            "BEGIN :1 := mnj_ont_mega_bom_pkg.CREATE_REQUISITION(:2); end;";
        java.sql.CallableStatement cs =
            getDBTransaction().createCallableStatement(stmt, 1);
        String prNo = null;

        getDBTransaction().commit();

        try {
            cs.registerOutParameter(1, OracleTypes.VARCHAR);
            cs.setString(2, bomId);
            cs.execute();
            prNo = cs.getString(1);
            cs.close();
        } catch (Exception e) {
            prNo = e.getMessage();
        }
        
        // Refresh Size Break up After Create PR //
        ViewObject vos =  getSizeWiseDetailVO1();
        vos.setWhereClause("FLAG ='A'");
        vos.executeQuery();
        

        return prNo;
    }

    public String CopyBOM(String bomId) {
        String stmt =
            "BEGIN :1 := cust_mnj_ont_pkg.cust_mnj_ont_bom_copy(:2); end;";
        java.sql.CallableStatement cs =
            getDBTransaction().createCallableStatement(stmt, 1);
        String bomNo = null;
        try {
            cs.registerOutParameter(1, OracleTypes.VARCHAR);
            cs.setString(2, bomId);
            cs.execute();
            bomNo = cs.getString(1);
            cs.close();
        } catch (Exception e) {
            bomNo = e.getMessage();
        }

        return bomNo;
    }


    /**
     * Container's getter for POInformationVO1.
     * @return POInformationVO1
     */
    public ViewObjectImpl getPOInformationVO1() {
        return (ViewObjectImpl)findViewObject("POInformationVO1");
    }

    public void findSelLines() {

        ViewObject vo = getpopuplineVO1();


        RowSetIterator it = vo.createRowSetIterator("bb");
        String flag = null;

        while (it.hasNext()) {
            Row r = it.next();
            try {
                flag = r.getAttribute("Multiselect").toString();
                if (flag != null && flag.equals("Y"))
                    populateLines1(r, null);
            } catch (Exception e) {
                ;
            }
            //populateLines(r);

        }

        it.closeRowSetIterator();


    } //findSelLines

    public void populateOrderLines(String bomId) {


        ViewObject populatevo = getpopuplineVO1();
        populatevo.setWhereClause("BOM_ID = " + bomId);
        populatevo.executeQuery();

        //        if (populatevo.getRowCount() == 0) {
        //            populatevo.setWhereClause(null);
        //            populatevo.setWhereClause("HEADER_ID = " + saleOrderID +
        //                                      " AND DCPO_NO ='BPO Line' AND SIZE_QTY IS NOT NULL");
        //            populatevo.executeQuery();
        //        }


    } //end of populateOrderLines method

    public void populateLines1(Row poprow, String lineId) {

        Row linerow = createLinesSTN();

        linerow.setAttribute("InventoryItemId",
                             getPopulateValue(poprow, "InventoryItemId"));
        linerow.setAttribute("ItemCode",
                             getPopulateValue(poprow, "OrderedItem"));
        linerow.setAttribute("SoObno", getPopulateValue(poprow, "ObRef"));
        linerow.setAttribute("SizeQuantity",
                             getPopulateValue(poprow, "SizeQty")); //DcpoNo
        linerow.setAttribute("DcpoNo", getPopulateValue(poprow, "DcpoNo"));
        linerow.setAttribute("Attribute1",
                             getPopulateValue(poprow, "Country"));
        linerow.setAttribute("Color", getPopulateValue(poprow, "Color"));
        linerow.setAttribute("SizeVal",
                             getPopulateValue(poprow, "InseamSizeConcat")); //SizeVal
        linerow.setAttribute("Linerefno",
                             getPopulateValue(poprow, "HeaderId"));

        if (lineId != null) { //This condition is used only in refresh sizes
            linerow.setAttribute("BomRmlineId", lineId);
        }

    } //end of populateLines

    public Row createLinesSTN() {

        ViewObject vo = getCustMnjOntBomOblineDetailsView1();
        Row row = vo.createRow();
        vo.insertRow(row);
        row.setNewRowState(Row.STATUS_INITIALIZED);
        return row;
    } //end of createHeader

    /**
     * Container's getter for popuplineVO1.
     * @return popuplineVO1
     */
    public popuplineVOImpl getpopuplineVO1() {
        return (popuplineVOImpl)findViewObject("popuplineVO1");
    }

    /**
     * Container's getter for ComponentLov1.
     * @return ComponentLov1
     */
    public ViewObjectImpl getComponentLov1() {
        return (ViewObjectImpl)findViewObject("ComponentLov1");
    }

    public double geConsVal() {

        ViewObject consVo = getThreadConsVO1();
        consVo.setWhereClause("STYLE ='" + getStyle() + "'");
        consVo.executeQuery();
        consVo.first();
        double consval = 0.0;
        try {
            consval =
                    Double.parseDouble(consVo.getCurrentRow().getAttribute("Cons").toString());
        } catch (Exception e) {
            // TODO: Add catch code
            ;
        }
        System.out.println("Level 3------>"+consval);

        return consval;
    }
    
    
    public void callMatFetch() {
        System.out.println("FillLines enter ----------->");

        ViewObject vo = getComponentLov1();        
       
        RowSetIterator it = vo.createRowSetIterator("kk");
        String flag = "true";
        

        while (it.hasNext()) {
            Row r = it.next();
            try {
                flag = r.getAttribute("MultiSelect").toString();
                System.out.println("MultiSelect -->"+flag);
                if (flag != null && flag.equals("true")){
                   
                    populateMaterialLines(r, geConsVal());
                }
            } catch (Exception e) {
                ;
            }
            //populateLines(r);

        }

        it.closeRowSetIterator();


    } //findSelLines
    
    
    public int checkOrgAssignment(Row r) throws SQLException {
        //System.out.println("Check for org assignment ");
        int count = 0;
        ViewObject header = getCustMnjOntBomHeaderView1();
        String org = null;
        try{
            org = header.getCurrentRow().getAttribute("OrgId").toString();
        }catch(Exception e){
            org = null;
        }
        String item = getPopulateValue(r, "InventoryItemId");
        //System.out.println("Check for org assignment 2 ");
        
        if(org != null){
            //System.out.println("Check for org assignment in if--- "+org+"---"+item);
            String query= "SELECT COUNT(*) ITEM FROM MTL_SYSTEM_ITEMS MSI,ORG_ORGANIZATION_DEFINITIONS OOD WHERE MSI.ORGANIZATION_ID = OOD.ORGANIZATION_ID " +
                "AND OOD.OPERATING_UNIT = ? AND MSI.INVENTORY_ITEM_ID = ?";
            ResultSet resultSet = null;                                                                                 
            PreparedStatement createStatement= getDBTransaction().createPreparedStatement(query,0);
            //System.out.println("Check for org assignment in if 2");
            createStatement.setString(1, org);
            createStatement.setString(2, item);
            //System.out.println("Check for org assignment in if 3");
            resultSet=createStatement.executeQuery();
            //System.out.println("Check for org assignment in if 4");
            
            while(resultSet.next()) {
                count = Integer.parseInt(resultSet.getString("ITEM"));
                break;
            }
            System.out.println("Item exists--"+count);
            resultSet.close();
            createStatement.close();
        }
        return count;
    }
    
    public boolean checkDuplicate(Row row){
        
        ViewObject itemvo = getCustMnjOntBomRmlineLinesView1();
        RowSetIterator it = itemvo.createRowSetIterator(null);
        
        while (it.hasNext()) {
            Row r = it.next();
            if (r.getAttribute("ItemDesc").toString().equals(row.getAttribute("Description").toString()))
                return true;
        }
        return false;
    }

//    public void callMatFetch() {
//
//        System.out.println("Level 1");
//        
//
//        ViewObject populatevo = getComponentLov1();
//
//
//        if (populatevo.getRowCount() == 0)
//            ;
//        RowSetIterator it = populatevo.createRowSetIterator("jj");
//        Row r[] = populatevo.getAllRowsInRange();
//        //  Row r [] = populatevo.getFilteredRows("MultiSelect", "Y");
//        
//
//        for (Row row : r) {
//
//            try {
//                String flag = row.getAttribute("MultiSelect").toString();
//                System.out.println("Before MultiSelect");
//                
//                if (flag.equals("true"))
//                    System.out.println("After MultiSelect 1---->>");
//                     populateMaterialLines(row, geConsVal());
//                System.out.println("After MultiSelect 2---->>");
//                
//
//            } catch (Exception e) {
//                System.out.println("Level 6----------->"+e.getMessage());
//                
//                ;
//
//            }
//
//
//        }
//
//        it.closeRowSetIterator();
//    }


    public void populateMaterialLines(Row poprow, double consVal) throws SQLException {

        System.out.println("Level 2   1");

        ViewObject vo = getCustMnjOntBomHeaderView1();
        String bomId = getBomId();

        System.out.println("Level 2   2");
        String item = getPopulateValue(poprow, "InventoryItemId");
        
        if(checkOrgAssignment(poprow) == 0){
            System.out.println(" inside item check ---not exists");
            FacesMessage Message = new FacesMessage("Org is not assigned in the following item with Item ID : "+item+ " !!");   
            Message.setSeverity(FacesMessage.SEVERITY_WARN);   
            FacesContext fc = FacesContext.getCurrentInstance();   
            fc.addMessage(null, Message); 
        }else{
            
            System.out.println(" inside item check --- exists");
            if (checkDuplicate(poprow) == true){
                System.out.println(" inside duplicate check ---exists");
                FacesMessage Message = new FacesMessage("This item is already tagged here !!");   
                Message.setSeverity(FacesMessage.SEVERITY_ERROR);   
                FacesContext fc = FacesContext.getCurrentInstance();   
                fc.addMessage(null, Message); 
            }
            else{
                Row linerow = createMaterialLines();
                String seg1 = getPopulateValue(poprow, "Segment1");
                String seg2 = getPopulateValue(poprow, "Segment2");
                String seg4 = getPopulateValue(poprow, "Segment4");
        
        
                if (getPopulateValue(poprow,
                                     "ValueDescription").equalsIgnoreCase("Thread")) {
        
                    linerow.setAttribute("UsageMoUnit", consVal); //
                    System.out.println("Level 2   3");
        
        
                } //
                linerow.setAttribute("InventoryItemId",
                                     getPopulateValue(poprow, "InventoryItemId"));
                linerow.setAttribute("ItemCode",
                                     getPopulateValue(poprow, "OrderedItem"));
                linerow.setAttribute("ItemPrefix",
                                     getPopulateValue(poprow, "ValueDescription"));
                linerow.setAttribute("MeasureUnitId",
                                     getPopulateValue(poprow, "PrimaryUnitOfMeasure"));
                linerow.setAttribute("ItemDesc",
                                     getPopulateValue(poprow, "Description"));
                linerow.setAttribute("LegacyCode",
                                     getPopulateValue(poprow, "LegacyCode")); //OnhandQty
        
                /**********************Onhand Qty & Alocate Qty**************************/
                linerow.setAttribute("OnhandQty1",
                                     getPopulateValue(poprow, "OnhandQty"));
        
                double val1 = get03StatusQty(seg1, seg2, seg4, 354);
                linerow.setAttribute("AllocateQty1", val1);
        
                linerow.setAttribute("OnhandCgl",
                                     getPopulateValue(poprow, "OnhandQtyCgl"));
        
                double val2 = get03StatusQty(seg1, seg2, seg4, 355);
                linerow.setAttribute("AlocateCgl", val2);
        
                linerow.setAttribute("OnhahndGfl",
                                     getPopulateValue(poprow, "OnhandQtyGfl"));
        
                double val3 = get03StatusQty(seg1, seg2, seg4, 356);
                linerow.setAttribute("AlocateGfl", val3);
                linerow.setAttribute("LeftOverQty", (val1 + val2 + val3));
        
        
                String prefix = getPopulateValue(poprow, "ValueDescription");
                if (prefix.equalsIgnoreCase("Thread")) {
                    linerow.setAttribute("UomConvRate",
                                         getPopulateValue(poprow, "Threadlength")); //UomConvRate
                }
                System.out.println("Level 2   4");
        
                populateOrderLines(bomId);
                System.out.println("Level 2   5");
        
        
                //        if (!(prefix.equalsIgnoreCase("Label") ||
                //              prefix.equalsIgnoreCase("Rivet"))){
               autoPopulateSizes(null);
                //            System.out.println("If condition true for other prefix-=========??"+prefix);
        
                //  }
            }
        }
    } //end of populateLines

    public Row createMaterialLines() {

        ViewObject vo = getCustMnjOntBomRmlineLinesView1();
        Row row = vo.createRow();
        vo.insertRow(row);
        row.setNewRowState(Row.STATUS_INITIALIZED);
        return row;
    } //end of createHeader

    @Override
    public void afterCommit(TransactionEvent transactionEvent) {
        super.afterCommit(transactionEvent);
        
        String BomId = getBomId();
        
        String stmt = "BEGIN cust_mnj_ont_pkg.SET_TRACKING_NO(:1); end;";

        CallableStatement cs =
            getDBTransaction().createCallableStatement(stmt, 1);
        try {
            cs.setString(1, BomId);
            cs.execute();
            cs.close();

        } catch (Exception e) {
            ;
        }
        
      
        
        FacesContext context = FacesContext.getCurrentInstance();
        FacesMessage message = new FacesMessage("Successfully saved record. ");
        context.addMessage(null, message);
    }

    /**
     * Container's getter for DeliveryDatesVO1.
     * @return DeliveryDatesVO1
     */
    public ViewObjectImpl getDeliveryDatesVO1() {
        return (ViewObjectImpl)findViewObject("DeliveryDatesVO1");
    }

    /**
     * Container's getter for LinesDeliveryDatesVL1.
     * @return LinesDeliveryDatesVL1
     */
    public ViewLinkImpl getLinesDeliveryDatesVL1() {
        return (ViewLinkImpl)findViewLink("LinesDeliveryDatesVL1");
    }

    /**
     * Container's getter for FillZipperVO1.
     * @return FillZipperVO1
     */
    public ViewObjectImpl getFillZipperVO1() {
        return (ViewObjectImpl)findViewObject("FillZipperVO1");
    }


    public String fillZipper(String bomId) {


        getDBTransaction().commit();

        ViewObject populatevo = getFillZipperVO1();
        populatevo.setWhereClause("BOM_ID = " + bomId);
        populatevo.executeQuery();

        //        ViewObject ziperSize = getZipperSizesVO1();
        //        ziperSize.setWhereClause("BOM_ID = " + bomId);
        //        ziperSize.executeQuery();


        int count = 0;

        if (populatevo.getRowCount() == 0)
            ;
        RowSetIterator it = populatevo.createRowSetIterator("ii");

        while (it.hasNext()) {

            count++;
            Row r = it.next();
            populateZipper(r, bomId);
        }

        if (count == 0) {
            it.closeRowSetIterator();
            return "No any item matched to these criteria .";
        }
        it.closeRowSetIterator();
        return null;
    }


    public void populateZipper(Row poprow, String bomId) {

        Row linerow = createMaterialLines();
        String seg1 = getPopulateValue(poprow, "Segment1");
        String seg2 = getPopulateValue(poprow, "Segment2");
        String seg4 = getPopulateValue(poprow, "Segment4");

        linerow.setAttribute("InventoryItemId",
                             getPopulateValue(poprow, "InventoryItemId"));
        linerow.setAttribute("LegacyCode",
                             getPopulateValue(poprow, "SupplierCode"));
        linerow.setAttribute("ItemDesc",
                             getPopulateValue(poprow, "Description"));
        linerow.setAttribute("MeasureUnitId",
                             getPopulateValue(poprow, "PrimaryUnitOfMeasure"));
        linerow.setAttribute("OnhandQty1",
                             getPopulateValue(poprow, "OnhandQty"));

        double val1 = get03StatusQty(seg1, seg2, seg4, 354);
        linerow.setAttribute("AllocateQty1", val1);

        linerow.setAttribute("OnhandCgl",
                             getPopulateValue(poprow, "OnhandQtyCgl"));

        double val2 = get03StatusQty(seg1, seg2, seg4, 355);
        linerow.setAttribute("AlocateCgl", val2);

        linerow.setAttribute("OnhahndGfl",
                             getPopulateValue(poprow, "OnhandQtyGfl"));

        double val3 = get03StatusQty(seg1, seg2, seg4, 356);
        linerow.setAttribute("AlocateGfl", val3);
        linerow.setAttribute("LeftOverQty", (val1 + val2 + val3));


        /****************************************************************
         * Fill All size
         * **************************/
        String sizeVal = getPopulateValue(poprow, "SizeVal");

        ViewObject ziperSize = getZipperSizesVO1();
        ziperSize.setWhereClause("BOM_ID = " + bomId + " AND SIZE_VAL='" +
                                 sizeVal + "'");
        ziperSize.executeQuery();

        RowSetIterator it = getZipperSizesVO1().createRowSetIterator("zasd");

        while (it.hasNext()) {
            Row r = it.next();
            String size = getPopulateValue(r, "SizeVal");
            FillZprDffSizes(size);
        }
        it.closeRowSetIterator();


    } //end of populateLines

    /**
     * Container's getter for FillThreadVO1.
     * @return FillThreadVO1
     */
    public ViewObjectImpl getFillThreadVO1() {
        return (ViewObjectImpl)findViewObject("FillThreadVO1");
    }


    public String fillThread(String bpo, String style) {

        getDBTransaction().commit();

        ViewObject populatevo = getFillThreadVO1();
        populatevo.setWhereClause("STYLE = '" + style + "'");
        populatevo.executeQuery();


        int count = 0;

        if (populatevo.getRowCount() == 0)
            ;
        RowSetIterator it = populatevo.createRowSetIterator("hh");

        while (it.hasNext()) {

            count++;
            Row r = it.next();
            populateThread(r);
        }

        if (count == 0) {
            it.closeRowSetIterator();
            return "No any item matched to Style .";
        }
        it.closeRowSetIterator();

        return null;

    }

    public void populateThread(Row poprow) {

        Row linerow = createMaterialLines();
        String seg1 = getPopulateValue(poprow, "Segment1");
        String seg2 = getPopulateValue(poprow, "Segment2");
        String seg4 = getPopulateValue(poprow, "Segment4");

        linerow.setAttribute("UsageMoUnit", getPopulateValue(poprow, "Cons"));


        linerow.setAttribute("InventoryItemId",
                             getPopulateValue(poprow, "InventoryItemId"));
        linerow.setAttribute("LegacyCode",
                             getPopulateValue(poprow, "SupplierCode"));
        linerow.setAttribute("ItemDesc",
                             getPopulateValue(poprow, "Description"));
        linerow.setAttribute("MeasureUnitId",
                             getPopulateValue(poprow, "PrimaryUnitOfMeasure"));

        linerow.setAttribute("OnhandQty1",
                             getPopulateValue(poprow, "OnhandQty"));

        double val1 = get03StatusQty(seg1, seg2, seg4, 354);
        linerow.setAttribute("AllocateQty1", val1);

        linerow.setAttribute("OnhandCgl",
                             getPopulateValue(poprow, "OnhandQtyCgl"));

        double val2 = get03StatusQty(seg1, seg2, seg4, 355);
        linerow.setAttribute("AlocateCgl", val2);

        linerow.setAttribute("OnhahndGfl",
                             getPopulateValue(poprow, "OnhandQtyGfl"));

        double val3 = get03StatusQty(seg1, seg2, seg4, 356);
        linerow.setAttribute("AlocateGfl", val3);
        linerow.setAttribute("LeftOverQty", (val1 + val2 + val3));

        linerow.setAttribute("UomConvRate",
                             Double.parseDouble(getPopulateValue(poprow,
                                                                 "ThreadLength")));
        //        System.out.println("Thread value --->"+getPopulateValue(poprow, "ThreadLength"));

        populateOrderLines(getBomId());
        autoPopulateSizes(null);


    } //end of populateLines


    public void autoPopulateSizes(String lineId) {

        ViewObject vo = getpopuplineVO1();
        RowSetIterator it = vo.createRowSetIterator("gg");
        String flag = null;

        while (it.hasNext()) {

            Row r = it.next();

            try {

                populateLines1(r, lineId);
            } catch (Exception e) {
                ;
            }

            //populateLines(r);

        }

        it.closeRowSetIterator();

    }

    public String getBomId() {


        ViewObject vo = getCustMnjOntBomHeaderView1();
        String orderHeaderId = null;
        try {

            orderHeaderId =
                    vo.getCurrentRow().getAttribute("BomId").toString();

        } catch (Exception e) {
            // TODO: Add catch code
            ;
        }
        return orderHeaderId;
    }

    public String getStyle() {


        ViewObject vo = getCustMnjOntBomHeaderView1();
        String style = null;
        try {

            style = vo.getCurrentRow().getAttribute("StyleNameC").toString();

        } catch (Exception e) {
            // TODO: Add catch code
            ;
        }
        return style;
    }


    public void FillZprDffSizes(String size) {

        String bomId = getBomId();
        ViewObject populatevo = getpopuplineVO1();
        populatevo.setWhereClause("BOM_ID = " + bomId +
                                  " AND INSEAM_SIZE_CONCAT ='" + size + "'");
        populatevo.executeQuery();

        //        if (populatevo.getRowCount() == 0) {
        //            populatevo.setWhereClause(null);
        //            populatevo.setWhereClause("HEADER_ID = " + orderHeaderId +
        //                                      " AND DCPO_NO ='BPO Line' AND SIZE_QTY IS NOT NULL AND SIZE_VALUE = '"+size+"'");
        //
        //            populatevo.executeQuery();
        //        }

        autoPopulateSizes(null); // Call autopopulate all sizes
    }


    public void HeaderActions(String type) {
        ViewObject vo = getCustMnjOntBomHeaderView1();

        String headerId = vo.getCurrentRow().getAttribute("BomId").toString();

        String stmt = "BEGIN cust_mnj_ont_pkg.COPY_BOM(:1,:2); end;";
        java.sql.CallableStatement cs =
            getDBTransaction().createCallableStatement(stmt, 1);
        try {
            cs.registerOutParameter(1, OracleTypes.VARCHAR);
            cs.setString(1, headerId);
            cs.setString(2, type);
            cs.execute();
            cs.close();
        } catch (Exception e) {
            ;
        }
        vo.executeQuery();

    }

    public void setSessionValues(String orgId, String userId, String respId,
                                 String respAppl) {


        if (userId != null) {
            System.out.println("User ID-------------->>"+userId);
            
            FacesContext fctx = FacesContext.getCurrentInstance();
            ExternalContext ectx = fctx.getExternalContext();
            HttpSession userSession = (HttpSession)ectx.getSession(false);
            userSession.setAttribute("userId", userId);
            userSession.setAttribute("orgId", orgId);
       System.out.println("User ID-------------->>"+userId);
        }

    } //end of session values
    
    public void setSession(String orgId, String userId, String respId,
                           String respAppl){
                               
                               if (userId != null) {
                                   System.out.println("User ID-------------->>"+userId);
                                   
                                   FacesContext fctx = FacesContext.getCurrentInstance();
                                   ExternalContext ectx = fctx.getExternalContext();
                                   HttpSession userSession = (HttpSession)ectx.getSession(false);
                                   userSession.setAttribute("userId", userId);
                                   userSession.setAttribute("orgId", orgId);
                               System.out.println("User ID-------------->>"+userId);
                               }   
                                         
         }
    
    

    public double get03StatusQty(String seg1, String seg2, String seg4,
                                 int orgId) {

        String stmt =
            "BEGIN :1 := mnj_get03_status_itemQty(:2,:3,:4, :5); end;";
        java.sql.CallableStatement cs =
            getDBTransaction().createCallableStatement(stmt, 1);
        double qty = 0;

        try {
            cs.registerOutParameter(1, OracleTypes.NUMBER);
            cs.setString(2, seg1);
            cs.setString(3, seg2);
            cs.setString(4, seg4);
            cs.setInt(5, orgId);
            cs.execute();
            qty = cs.getDouble(1);
            cs.close();
        } catch (Exception e) {
            e.printStackTrace();
        }

        return qty;
    }


    public void refreshSizes() {

        String bomId = getBomId();
        ViewObject linesVO = getCustMnjOntBomRmlineLinesView1();
        RowSetIterator it = linesVO.createRowSetIterator("adsf");
        Row r = null;
        populateOrderLines(bomId);
        while (it.hasNext()) {

            r = it.next();
            autoPopulateSizes(r.getAttribute("BomRmlineId").toString());

        }
        it.closeRowSetIterator();


    }

    public String getAttachments() {


        String status = null;
        String doc = null;
        ViewObject vo = getCustMnjOntBomHeaderView1();
        try {
            doc = vo.getCurrentRow().getAttribute("BomNumber").toString();
        } catch (Exception e) {
            // TODO: Add catch code
            ;
        }


        String stmt = "BEGIN mnj_get_attach_names(:1, :2, :3); end;";

        CallableStatement cs =
            getDBTransaction().createCallableStatement(stmt, 1);
        try {
            cs.registerOutParameter(3, OracleTypes.VARCHAR);
            cs.setString(1, "MB");
            cs.setString(2, doc);
            cs.execute();
            status = cs.getString(3);
            cs.close();

        } catch (Exception e) {
            ;
        }
        return status;


    } //end of

    public void selectAllLines(String flag) {


        ViewObject populatevo = getpopuplineVO1();
        //populatevo.executeQuery();

        //Row[] r = populatevo.getAllRowsInRange();
        RowSetIterator it = populatevo.createRowSetIterator("yy");


        while (it.hasNext()) {
            Row row = it.next();

            row.setAttribute("Multiselect", flag);


        }
        it.closeRowSetIterator();
    }

    /**
     * Container's getter for ColorSearch1.
     * @return ColorSearch1
     */
    public ViewObjectImpl getColorSearch1() {
        return (ViewObjectImpl)findViewObject("ColorSearch1");
    }

    /**
     * Container's getter for SizeSearch1.
     * @return SizeSearch1
     */
    public ViewObjectImpl getSizeSearch1() {
        return (ViewObjectImpl)findViewObject("SizeSearch1");
    }

    /**
     * Container's getter for CountrySearch1.
     * @return CountrySearch1
     */
    public ViewObjectImpl getCountrySearch1() {
        return (ViewObjectImpl)findViewObject("CountrySearch1");
    }

    public void setMultiSearchWherClause(String saleOrderID) {

        ViewObject countryVo = getCountrySearch1();
        ViewObject colorVo = getColorSearch1();
        ViewObject sizeVo = getSizeSearch1();
        ViewObject bpoVO = getBPOSearch1();

        //countryVo.setWhereClause("HEADER_ID = "+saleOrderID);
        countryVo.executeQuery();

        //colorVo.setWhereClause("HEADER_ID = "+saleOrderID);
        colorVo.executeQuery();

        //   sizeVo.setWhereClause("HEADER_ID = "+saleOrderID);
        sizeVo.executeQuery();

        // poplateMultiSearch(saleOrderID);
        bpoVO.executeQuery();

    } //end of populateOrderLines method

    public void poplateMultiSearch(String headerId) {

        clearAllSizes();

        ViewObject bpoVo = getBPOSearch1();
        ViewObject countryVo = getCountrySearch1();
        ViewObject colorVo = getColorSearch1();
        ViewObject sizeVo = getSizeSearch1();
        String flag0 = null, flag1 = null, flag2 = null, flag3 =
            null, country = null, color = null, size = null;

        RowSetIterator it0 = bpoVo.createRowSetIterator("w");
        while (it0.hasNext()) {
            Row r0 = it0.next();
            try {
                flag0 = r0.getAttribute("BPOFlag").toString();
            } catch (Exception e) {
                flag0 = "N";
            }
            //            System.out.println("Bpo loop flag--?"+flag0);
            if (flag0 != null && flag0.equals("Y")) {
                headerId = r0.getAttribute("SaleOrderId").toString();

                RowSetIterator it1 = countryVo.createRowSetIterator("x");
                while (it1.hasNext()) {
                    Row r = it1.next();

                    try {
                        flag1 = r.getAttribute("CountryFlag").toString();
                    } catch (Exception e) {
                        flag1 = "N";
                    }
                    //                    System.out.println("Country loop flag ----->"+flag1);

                    if (flag1 != null && flag1.equals("Y")) {
                        try{
                            country =r.getAttribute("Country").toString(); //criteria 1
                        }
                        catch(Exception e){
                            ;
                        }
                       

                        RowSetIterator it2 = colorVo.createRowSetIterator("y");
                        while (it2.hasNext()) {
                            Row r2 = it2.next();
                            try {
                                flag2 = r2.getAttribute("ColorFlag").toString();
                            } catch (Exception e) {
                                flag2 = "N";
                            }
                                                System.out.println("Color loop flag ---------------->"+flag2);
                            if (flag2 != null && flag2.equals("Y")) {
                                color = (String)r2.getAttribute("Color");
                                                System.out.println("Color ---------------->"+color);
                                RowSetIterator it3 =
                                    sizeVo.createRowSetIterator("z");
                                while (it3.hasNext()) {
                                    Row r3 = it3.next();
                                    try {
                                        flag3 =
                                                r3.getAttribute("SizeFlag").toString();
                                    } catch (Exception e) {
                                        flag3 = "N";
                                    }
                                    //                                System.out.println("Size loop flag ---------->"+flag3);
                                    if (flag3 != null && flag3.equals("Y")) {
                                        flag3 = "N";
                                        //                                        System.out.println("Size if condition--->");
                                        size =(String)r3.getAttribute("InseamSizeConcat");
                                        processMultiSizes(headerId, country,
                                                          color, size);

                                    } //end of most inner if

                                } //end of most inner while loop
                                it3.closeRowSetIterator();
                            }
                        } //end of inner while looop
                        it2.closeRowSetIterator();

                    } //end of outer if condition
                } //end of outer while loop
                it1.closeRowSetIterator();
            } //end of most outer if
        } //end of most outer while
        it0.closeRowSetIterator();
    }


    public void processMultiSizes(String headerId, String country,
                                  String color, String size) {

        ViewObject vo = getpopuplineVO1();
        vo.setWhereClause(null);
        vo.setWhereClause("HEADER_ID =" + headerId + " AND Country ='" +
                          country + "' and Color = '" + color +
                          "' and INSEAM_SIZE_CONCAT='" + size + "'");
        vo.executeQuery();

        RowSetIterator it = vo.createRowSetIterator("sz");

        String flag = null;

        while (it.hasNext()) {
            Row r = it.next();
            populateLines1(r, null);

        }

        it.closeRowSetIterator();

    }

    public void clearAllSizes() {
        ViewObject vo = getCustMnjOntBomOblineDetailsView1();
        RowSetIterator it = vo.createRowSetIterator("pp");
        while (it.hasNext()) {
            it.next().remove();
        }
        it.closeRowSetIterator();
    }

    /**
     * Container's getter for BomBpoLinesAllVO1.
     * @return BomBpoLinesAllVO1
     */
    public ViewObjectImpl getBomBpoLinesAllVO1() {
        return (ViewObjectImpl)findViewObject("BomBpoLinesAllVO1");
    }

    /**
     * Container's getter for HeaderLinesVL1.
     * @return HeaderLinesVL1
     */
    public ViewLinkImpl getHeaderLinesVL1() {
        return (ViewLinkImpl)findViewLink("HeaderLinesVL1");
    }

    /**
     * Container's getter for BPOSearch1.
     * @return BPOSearch1
     */
    public ViewObjectImpl getBPOSearch1() {
        return (ViewObjectImpl)findViewObject("BPOSearch1");
    }

    public void sizesCiritSelectDesel(String flag, String type) {

        ViewObject populatevo = null;
        String flagName = null;

        if (type.equalsIgnoreCase("BPO")) {
            populatevo = getBPOSearch1();
            flagName = "BPOFlag";
        } //populatevo.executeQuery();
        else if (type.equalsIgnoreCase("Country")) {
            populatevo = getCountrySearch1();
            flagName = "CountryFlag";
        } else if (type.equalsIgnoreCase("Color")) {
            populatevo = getColorSearch1();
            flagName = "ColorFlag";
        } else if (type.equalsIgnoreCase("Size")) {
            populatevo = getSizeSearch1();
            flagName = "SizeFlag";
        }

        Row[] r = populatevo.getAllRowsInRange();

        for (Row row : r) {
            //            System.out.println("Loop select");
            row.setAttribute(flagName, flag);

        }
    }

    /**
     * Container's getter for ZipperSizesVO1.
     * @return ZipperSizesVO1
     */
    public ViewObjectImpl getZipperSizesVO1() {
        return (ViewObjectImpl)findViewObject("ZipperSizesVO1");
    }

    /**
     * Container's getter for ThreadConsVO1.
     * @return ThreadConsVO1
     */
    public ViewObjectImpl getThreadConsVO1() {
        return (ViewObjectImpl)findViewObject("ThreadConsVO1");
    }

    /**
     * Container's getter for BomLinesPRHistoryVO1.
     * @return BomLinesPRHistoryVO1
     */
    public ViewObjectImpl getBomLinesPRHistoryVO1() {
        return (ViewObjectImpl)findViewObject("BomLinesPRHistoryVO1");
    }

    /**
     * Container's getter for HeaderPRHistoryLinesVL1.
     * @return HeaderPRHistoryLinesVL1
     */
    public ViewLinkImpl getHeaderPRHistoryLinesVL1() {
        return (ViewLinkImpl)findViewLink("HeaderPRHistoryLinesVL1");
    }

    /**
     * Container's getter for SizeWiseDetailVO1.
     * @return SizeWiseDetailVO1
     */
    public ViewObjectImpl getSizeWiseDetailVO1() {
        return (ViewObjectImpl)findViewObject("SizeWiseDetailVO1");
    }

    /**
     * Container's getter for RmLinesSizeWiseVL1.
     * @return RmLinesSizeWiseVL1
     */
    public ViewLinkImpl getRmLinesSizeWiseVL1() {
        return (ViewLinkImpl)findViewLink("RmLinesSizeWiseVL1");
    }
    
    public void clearSizeBreakUpAll(){
        
        getDBTransaction().commit();
        
        ViewObject vos =  getSizeWiseDetailVO1();
        vos.setWhereClause("FLAG ='A'");
        vos.executeQuery();
        

        ViewObject vo = getSizeWiseDetailVO1();
        RowSetIterator it = vo.createRowSetIterator("ff");
        while(it.hasNext()){
            it.next().remove();
        }
       it.closeRowSetIterator();
       //getDBTransaction().commit();

        
    }

    public void fillSizeBreakUp() {
    
        clearSizeBreakUpAll();
    
//        ViewObject lVo = getCustMnjOntBomRmlineLinesView1();
//        Row lineR = lVo.getCurrentRow();
        
        ViewObject vo = getCustMnjOntBomOblineDetailsView1();
        RowSetIterator it = vo.createRowSetIterator(null);
        it.reset();
//        String PrFlag = null;
//        
//        try {
//            PrFlag = lineR.getAttribute("Flag").toString();
//        } catch (Exception e) {
//            
//            PrFlag = "N";
//         
//        }
//        
//        if (PrFlag != null && PrFlag.equalsIgnoreCase("Y")){   
//            
//            if(it.getRangeSize() != 0)
//            markSizeWiseBlockFlag();
//        }
//        else {
//            it.closeRowSetIterator();
//            
//            FacesContext context = FacesContext.getCurrentInstance();
//            FacesMessage message = new FacesMessage("Can't create size break up either clear or generate PR first. ");
//            context.addMessage(null, message);
//            
//            return ;    
//        }
        
       

        
        Hashtable<String, Integer> table = new Hashtable<String, Integer>();
        //Set<String> uniques = new HashSet<String>();

        //table.put("one", 1);

        while (it.hasNext()) {
            Row r = it.next();
            int sizeQty =
                Integer.parseInt(r.getAttribute("SizeQuantity").toString());
            String size = r.getAttribute("SizeVal").toString();
            System.out.println("Size value----->" + table.containsKey(size));

            if (!table.containsKey(size)) {
                table.put(size, sizeQty);
                System.out.println("if conditions---->");
            } //end of if
            else {
                int value = table.get(size);
                sizeQty = sizeQty + value;
                System.out.println(value + "Size qty after sum" + sizeQty);
                table.remove(size);
                table.put(size, sizeQty);

            }
        }
        it.reset();
        it.closeRowSetIterator();

        Enumeration names = table.keys();

        while (names.hasMoreElements()) {
            Row r = createSizeBreakup();
            String size = (String)names.nextElement();
            int sizeQty = table.get(size);
            setSizeBreakupValues(r, size,
                                 sizeQty); // set size wise break up block values


        }
        //       System.out.println("Total value in "+table.size());
        table.clear();
        getDBTransaction().commit();

      //  System.out.println("Query-->"+vos.getQuery());
        

    }

    public void setSizeBreakupValues(Row r, String size, int sizeQty) {

        ViewObject lVo = getCustMnjOntBomRmlineLinesView1();
        Row lineR = lVo.getCurrentRow();
        double consQtyVal = 0.0, wastageQtyVal = 0.0, prcntg =
            0.0, pricePerUnitVal = 0.0,unitConvRateVal=0.0;
        try {
            consQtyVal =
                    Double.parseDouble(lineR.getAttribute("UsageMoUnit").toString());
        } catch (Exception e) {
            ;
        }
        try {
            wastageQtyVal =
                    Double.parseDouble(lineR.getAttribute("ExtraUsage").toString());
        } catch (Exception e) {
            ;
        }

        try {
            prcntg =
                    Double.parseDouble(lineR.getAttribute("Perntg").toString());
        } catch (Exception e) {
            ;
        }
        
        unitConvRateVal=numeric3(lineR.getAttribute("UomConvRate"));

        double reqQtyVal =
            Math.ceil((double)(sizeQty * consQtyVal) * (1 + (wastageQtyVal /
                                                             100)));
        
        if (unitConvRateVal > 0) {
            reqQtyVal = reqQtyVal / unitConvRateVal;
        }
        
        reqQtyVal= roundUp(reqQtyVal);
        
        double projPRQty = prcntg * reqQtyVal / 100;

        r.setAttribute("SizeVal", size);
        r.setAttribute("SizeWiseOrderQty", sizeQty);
        r.setAttribute("SizeWiseBomReqQty", reqQtyVal);
        r.setAttribute("BookingPercent", prcntg);
        r.setAttribute("SizeWiseProjQty", projPRQty);
        r.setAttribute("ActualQty", projPRQty);
        r.setAttribute("Flag", "A");


    }

    public Row createSizeBreakup() {

        ViewObject vo = getSizeWiseDetailVO1();
        Row row = vo.createRow();
        vo.insertRow(row);
        row.setNewRowState(Row.STATUS_INITIALIZED);
        return row;
    } //end of createHeader

    public void postAdditionalQty() {
        
//        ViewObject vos =  getSizeWiseDetailVO1();
//        vos.setWhereClause("FLAG ='A'");
//        vos.executeQuery();
            
        ViewObject vo = getSizeWiseDetailVO1();
        RowSetIterator it = vo.createRowSetIterator("aad");
        double addiQtyVal = 0.0;
        while (it.hasNext()) {
            Row r = it.next();
            try {
                addiQtyVal =
                        addiQtyVal + Double.parseDouble(r.getAttribute("AddDeduct").toString());
            } catch (Exception e) {
                ;
            }
        }
        it.closeRowSetIterator();

        getCustMnjOntBomRmlineLinesView1().getCurrentRow().setAttribute("AdditionalQty",
                                                                        addiQtyVal);
        System.out.println("Post qty ---->" + addiQtyVal);


        /***Set Line Qty Refresh***/
        ViewObject lVo = getCustMnjOntBomRmlineLinesView1();
        Row lineR = lVo.getCurrentRow();
        double pricePerUnitVal = 0.0, projPrQtyVal = 0.0, bomReqQtyVal =
            0.0, actualPrcntVal = 0.0;
        String itemId = null;

       
        pricePerUnitVal =numeric3(lineR.getAttribute("PricePerUnit"));       

       
        projPrQtyVal =numeric3(lineR.getAttribute("ProjPrQty"));
                 

      
        bomReqQtyVal =numeric3(lineR.getAttribute("NoOfGarment"));
                
        try {
            itemId = lineR.getAttribute("InventoryItemId").toString();
        } catch (Exception e) {
            ;
        }


        double prQtyVal = addiQtyVal + projPrQtyVal;

        double actualPrQtySumVal =
            getLineQtySum("BookedQty", prQtyVal, itemId);
        System.out.println("Actual PR Qty sum in AM----------------->"+actualPrQtySumVal);

        try {
            actualPrcntVal =
                    changeToDouble(actualPrQtySumVal / bomReqQtyVal * 100);
        } catch (Exception e) {
            actualPrcntVal = 0.0;
        }

        double pendingPrcnt = 100 - ((actualPrQtySumVal) / bomReqQtyVal * 100);

        lineR.setAttribute("Total", (prQtyVal * pricePerUnitVal));
        lineR.setAttribute("BookedQty", (prQtyVal));
        lineR.setAttribute("ActualPrcnt", (actualPrcntVal));
        lineR.setAttribute("PendingPrcnt", (pendingPrcnt));
        lineR.setAttribute("AccumPrcnt", (actualPrQtySumVal));


    }


    public double getLineQtySum(String name, double curntVal, String itemId) {

        ViewObject lVo = getBomLinesPRHistoryVO1();


        RowSetIterator it = lVo.createRowSetIterator("a");
        Row currentRow = lVo.getCurrentRow();

        double total = curntVal;
        int inventoryItemId = Integer.parseInt(itemId);
        String itemIdCheck = null;
        while (it.hasNext()) {
            Row r = it.next();

            String itemid2 =
                r.getAttribute("InventoryItemId").toString(); //InventoryItemId
          //  if (r != currentRow){  
                if (itemid2.equals(itemId)) {
                    System.out.println("Booked qty AM count----------------->"+numeric3(r.getAttribute(name)));
                    total = total + numeric3(r.getAttribute(name));

                }
          //  }
        }
        it.closeRowSetIterator();
        return total;

    } //end of method line

    public static double numeric3(Object ob) {


        try {
            if (ob != null)
                return Double.parseDouble(String.valueOf(ob));
            else
                return 0;
        } catch (Exception e) {
            ;
        }

        return 0;
    }

    public static double changeToDouble(double n) {

        if (Double.isNaN(n)) {
            return 0;
        }
        if (Double.isInfinite(n)) {
            return 0;
        }
        return n;

    }
    
    public static double roundUp(double n){
    
       // n = 1.6234;
        String value = String.valueOf(n);
    
        if(!value.contains(".")){
            
            return n;    
        }        
        
        char[] charArray = value.toCharArray();              
      
        if (charArray.length - (value.substring(0, value.indexOf(".")+1).length()) > 0){
            BigDecimal bdTest1 = new BigDecimal(value);
            BigDecimal another = bdTest1.setScale(0,BigDecimal.ROUND_CEILING);
            return another.doubleValue();
        }                    
        
        
        return n;
    }

    /**
     * Container's getter for BuyerCriteria1.
     * @return BuyerCriteria1
     */
    public ViewObjectImpl getBuyerCriteria1() {
        return (ViewObjectImpl)findViewObject("BuyerCriteria1");
    }

    /**
     * Container's getter for FillBPOVO1.
     * @return FillBPOVO1
     */
    public ViewObjectImpl getFillBPOVO1() {
        return (ViewObjectImpl)findViewObject("FillBPOVO1");
    }


    public void populateBPOLines1() {

       // System.out.println("Season_c = ");
        
        String  StyleNo=null;
        String  StyleName=null;
        String  Season=null;
        String  vBuyerID=null;
       // System.out.println("Season_c2 = ");
            
        ViewObject lVo = getCustMnjOntBomHeaderView1();
        Row lineR = lVo.getCurrentRow();
      //  System.out.println("Season_c3 = ");
        
        try {
            vBuyerID=lVo.getCurrentRow().getAttribute("BuyerId").toString();
        }catch (Exception e){;}

        try {
            StyleNo=lVo.getCurrentRow().getAttribute("StyleNoC").toString();
        }catch (Exception e){;}

        
        //System.out.println("Season_c41 = ");
        
       try {
            StyleName = lineR.getAttribute("StyleNameC").toString();
            } catch (Exception e){;}
      
        //System.out.println("Season_c5 = ");
        
        try {
                Season =    lineR.getAttribute("SeasonC").toString();
                    } catch (Exception e){;}
        
      //  System.out.println("Season = " +"Nvl('"+ Season+"',Season) "+" Or style_name = "+"Nvl('"+ StyleName+"',style_name) "+" Or style_no = "+"Nvl('"+ StyleNo+"',style_no)");
        ViewObject populatevo = getFillBPOVO1();
        populatevo.setWhereClause("Season = " +"Nvl('"+ Season+"',Season) "+"and  Buyer_Id = " +"Nvl('"+ vBuyerID+"',Buyer_Id) "+" And (style_name = "+"Nvl('"+ StyleName+"',style_name) "+" Or style_no = "+"Nvl('"+ StyleNo+"',style_no))");
        System.out.println("Season = " + Season+" and  Buyer_Id = " + vBuyerID+" And style_name = "+ StyleName+" Or style_no = "+ StyleNo);
        populatevo.executeQuery();
        //System.out.println("--- END --");
    
    } //end of populateOrderLines method


    public void callBPOFetch() {
        //System.out.println("--- START --");
        ViewObject populatevo = getFillBPOVO1();
    
         if (populatevo.getRowCount() == 0);
        RowSetIterator it = populatevo.createRowSetIterator("cc");
        Row r[] = populatevo.getAllRowsInRange();
        //System.out.println("callBPOFetch");
    for (Row row : r) {
            //System.out.println("loop count");
            try {
                String flag =row.getAttribute("SelectAll").toString();
               
                System.out.println("Flag Code -->" + flag);
                if (flag.equals("Y"))
                //    System.out.println("Faraz 2----->");
                    
                   populateBPOLines(row);
               // System.out.println("Faraz 3----->");
                

            } catch (Exception e)
            {
              ;
            }
        }

        it.closeRowSetIterator();
    }  


            public Row createBPOLines() {
                ViewObject vo = getBomBpoLinesAllVO1();
                Row row = vo.createRow();
                vo.insertRow(row);
                row.setNewRowState(Row.STATUS_INITIALIZED);
                return row;
            } //


            public void populateBPOLines(Row poprow) {
               // System.out.println("Populate Lines 1 -->");
            
                ViewObject vo = getBomBpoLinesAllVO1();
                Row linerow = createBPOLines();
                  
                        
                        linerow.setAttribute("BpoNo",
                                             getPopulateValue(poprow, "BpoNo"));
                        System.out.println("BpoNo----"+getPopulateValue(poprow, "BpoNo"));
                        linerow.setAttribute("Category",
                                             getPopulateValue(poprow, "Category"));
                        System.out.println("Category----"+getPopulateValue(poprow, "Category"));
                        linerow.setAttribute("OrderQty",
                                             getPopulateValue(poprow, "OrderedQty"));
                        linerow.setAttribute("EndUserDesc",
                                             getPopulateValue(poprow, "EndUser"));
                        linerow.setAttribute("Fit",
                                             getPopulateValue(poprow, "Fit"));
                        linerow.setAttribute("UserItemDesc",getPopulateValue(poprow,"ItemDescription"));
                        linerow.setAttribute("Brand",getPopulateValue(poprow,"Brand"));
                        linerow.setAttribute("SaleOrderId",getPopulateValue(poprow,"HeaderId"));
                        linerow.setAttribute("Season",getPopulateValue(poprow,"Season"));
                        
                   populateBPOLines1();
                    } //end of populateLines



                    public void selectAllBPO(String flag) {

//                     System.out.println("Level 1");
                     ViewObject populatevo = getFillBPOVO1();
                     RowSetIterator it = populatevo.createRowSetIterator("yy");

  //                      System.out.println("Level 2");

                     while (it.hasNext()) {
    //                     System.out.println("Level 3");

                         Row row = it.next();
                         row.setAttribute("SelectAll", flag);
      //                   System.out.println("Level 4");

                     }
                     it.closeRowSetIterator();
                    }


    /**
     * Container's getter for FabricCustomReportVO1.
     * @return FabricCustomReportVO1
     */
    public ViewObjectImpl getFabricCustomReportVO1() {
        return (ViewObjectImpl)findViewObject("FabricCustomReportVO1");
    }

    /**
     * Container's getter for FabricCustomReportVLink1.
     * @return FabricCustomReportVLink1
     */
    public ViewLinkImpl getFabricCustomReportVLink1() {
        return (ViewLinkImpl)findViewLink("FabricCustomReportVLink1");
    }

    /**
     * Container's getter for FabricCustomReportItemVO1.
     * @return FabricCustomReportItemVO1
     */
    public ViewObjectImpl getFabricCustomReportItemVO1() {
        return (ViewObjectImpl)findViewObject("FabricCustomReportItemVO1");
    }

    /**
     * Container's getter for CustomReportHeaderItemVLink1.
     * @return CustomReportHeaderItemVLink1
     */
    public ViewLinkImpl getCustomReportHeaderItemVLink1() {
        return (ViewLinkImpl)findViewLink("CustomReportHeaderItemVLink1");
    }

    /**
     * Container's getter for MaterialSheetVO1.
     * @return MaterialSheetVO1
     */
    public ViewObjectImpl getMaterialSheetVO1() {
        return (ViewObjectImpl)findViewObject("MaterialSheetVO1");
    }

    /**
     * Container's getter for MaterialSheetViewLink1.
     * @return MaterialSheetViewLink1
     */
    public ViewLinkImpl getMaterialSheetViewLink1() {
        return (ViewLinkImpl)findViewLink("MaterialSheetViewLink1");
    }


    /**
     * Container's getter for UserInfoVO1.
     * @return UserInfoVO1
     */
    public ViewObjectImpl getUserInfoVO1() {
        return (ViewObjectImpl)findViewObject("UserInfoVO1");
    }

    /**
     * Container's getter for SPOAndBOMVO1.
     * @return SPOAndBOMVO1
     */
    public ViewObjectImpl getSPOAndBOMVO1() {
        return (ViewObjectImpl)findViewObject("SPOAndBOMVO1");
    }

    /**
     * Container's getter for multi_Bom_Header_VO1.
     * @return multi_Bom_Header_VO1
     */
    public ViewObjectImpl getmulti_Bom_Header_VO1() {
        return (ViewObjectImpl)findViewObject("multi_Bom_Header_VO1");
    }

    /**
     * Container's getter for CustMnjOntBomRmlineEO_autoView1.
     * @return CustMnjOntBomRmlineEO_autoView1
     */
    public ViewObjectImpl getCustMnjOntBomRmlineEO_autoView1() {
        return (ViewObjectImpl)findViewObject("CustMnjOntBomRmlineEO_autoView1");
    }

    /**
     * Container's getter for filterVO1.
     * @return filterVO1
     */
    public ViewObjectImpl getfilterVO1() {
        return (ViewObjectImpl)findViewObject("filterVO1");
    }

    /**
     * Container's getter for headerSearchVO1.
     * @return headerSearchVO1
     */
    public ViewObjectImpl getheaderSearchVO1() {
        return (ViewObjectImpl)findViewObject("headerSearchVO1");
    }

    /**
     * Container's getter for AssignBPOQtyForMultiBOM1.
     * @return AssignBPOQtyForMultiBOM1
     */
    public ViewObjectImpl getAssignBPOQtyForMultiBOM1() {
        return (ViewObjectImpl)findViewObject("AssignBPOQtyForMultiBOM1");
    }

    /**
     * Container's getter for POInfoVO1.
     * @return POInfoVO1
     */
    public ViewObjectImpl getPOInfoVO1() {
        return (ViewObjectImpl)findViewObject("POInfoVO1");
    }

    /**
     * Container's getter for MnjBomPoDffVO1.
     * @return MnjBomPoDffVO1
     */
    public ViewObjectImpl getMnjBomPoDffVO1() {
        return (ViewObjectImpl)findViewObject("MnjBomPoDffVO1");
    }

    /**
     * Container's getter for poInformationVSpoDffViewLink1.
     * @return poInformationVSpoDffViewLink1
     */
    public ViewLinkImpl getpoInformationVSpoDffViewLink1() {
        return (ViewLinkImpl)findViewLink("poInformationVSpoDffViewLink1");
    }

    /**
     * Container's getter for priceSupplierProdAreaLOV1.
     * @return priceSupplierProdAreaLOV1
     */
    public ViewObjectImpl getpriceSupplierProdAreaLOV1() {
        return (ViewObjectImpl)findViewObject("priceSupplierProdAreaLOV1");
    }
}//end of
