/*
 * Decompiled with CFR 0.152.
 */
package mnj.ont.model.services;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSession;
import mnj.ont.model.lov.vo.popuplineVOImpl;
import mnj.ont.model.services.common.AppModule;
import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;
import oracle.jbo.domain.Number;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.TransactionEvent;
import oracle.jbo.server.ViewLinkImpl;
import oracle.jbo.server.ViewObjectImpl;

public class AppModuleImpl
extends ApplicationModuleImpl
implements AppModule {
    public ViewObjectImpl getCustMnjOntBomHeaderView1() {
        return (ViewObjectImpl)this.findViewObject("CustMnjOntBomHeaderView1");
    }

    public ViewObjectImpl getCustMnjOntBomRmlineLinesView1() {
        return (ViewObjectImpl)this.findViewObject("CustMnjOntBomRmlineLinesView1");
    }

    public ViewObjectImpl getCustMnjOntBomOblineDetailsView1() {
        return (ViewObjectImpl)this.findViewObject("CustMnjOntBomOblineDetailsView1");
    }

    public ViewLinkImpl getPkBomLineFkLink1() {
        return (ViewLinkImpl)this.findViewLink("PkBomLineFkLink1");
    }

    public ViewLinkImpl getCustMnjOntBomOblineFkLink1() {
        return (ViewLinkImpl)this.findViewLink("CustMnjOntBomOblineFkLink1");
    }

    @Override
    public void fetchLines() {
    }

    @Override
    public void fetchMethod(Number pId) {
        ViewObjectImpl populatevo = this.getPopulateVO1();
        populatevo.setWhereClause("HEADER_ID = " + pId);
        populatevo.executeQuery();
        if (populatevo.getRowCount() == 0) {
            // empty if block
        }
        RowSetIterator it = populatevo.createRowSetIterator("ll");
        while (it.hasNext()) {
            Row r = it.next();
            this.populateLines(r);
        }
        it.closeRowSetIterator();
    }

    public void showRecords() {
    }

    public void populateLines(Row poprow) {
        Row linerow = this.createLines();
        linerow.setAttribute("InventoryItemId", (Object)this.getPopulateValue(poprow, "InventoryItemId"));
        linerow.setAttribute("ItemCode", (Object)this.getPopulateValue(poprow, "ItemCode"));
        linerow.setAttribute("PDesc", (Object)this.getPopulateValue(poprow, "Prefix"));
        linerow.setAttribute("MeasureUnitId", (Object)this.getPopulateValue(poprow, "PrimaryUomCode"));
        linerow.setAttribute("UsageMoUnit", (Object)this.getPopulateValue(poprow, "RawmaterialPcons"));
        linerow.setAttribute("Rate", (Object)this.getPopulateValue(poprow, "RawmaterialRate"));
        linerow.setAttribute("ItemDesc", (Object)this.getPopulateValue(poprow, "Description"));
    }

    public Row createLines() {
        ViewObjectImpl vo = this.getCustMnjOntBomRmlineLinesView1();
        Row row = vo.createRow();
        vo.insertRow(row);
        row.setNewRowState((byte)-1);
        return row;
    }

    public String getPopulateValue(Row r, String columnName) {
        String value = null;
        try {
            value = r.getAttribute(columnName).toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        return value;
    }

    public ViewObjectImpl getPopulateVO1() {
        return (ViewObjectImpl)this.findViewObject("PopulateVO1");
    }

    @Override
    public int callPost(String hederId) {
        int srno = 0;
        String stmt = "BEGIN :1 := cust_mnj_ont_pkg.cust_mnj_ont_bom_revision(:2,:3); end;";
        CallableStatement cs = this.getDBTransaction().createCallableStatement(stmt, 1);
        try {
            cs.registerOutParameter(1, 12);
            cs.setString(2, hederId);
            cs.setString(3, " ");
            cs.execute();
            cs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return srno;
    }

    @Override
    public String createPR(String bomId, String bomLineId) {
        System.out.println("----------createPR Func-----------");
        String stmt = "BEGIN :1 := mnj_ont_mega_bom_pkg.CREATE_REQUISITION(:2); end;";
        CallableStatement cs = this.getDBTransaction().createCallableStatement(stmt, 1);
        String prNo = null;
        this.getDBTransaction().commit();
        try {
            cs.registerOutParameter(1, 12);
            cs.setString(2, bomId);
            cs.execute();
            prNo = cs.getString(1);
            cs.close();
        }
        catch (Exception e) {
            prNo = e.getMessage();
        }
        ViewObjectImpl vos = this.getSizeWiseDetailVO1();
        vos.setWhereClause("FLAG ='A'");
        vos.executeQuery();
        return prNo;
    }

    @Override
    public String CopyBOM(String bomId) {
        String stmt = "BEGIN :1 := cust_mnj_ont_pkg.cust_mnj_ont_bom_copy(:2); end;";
        CallableStatement cs = this.getDBTransaction().createCallableStatement(stmt, 1);
        String bomNo = null;
        try {
            cs.registerOutParameter(1, 12);
            cs.setString(2, bomId);
            cs.execute();
            bomNo = cs.getString(1);
            cs.close();
        }
        catch (Exception e) {
            bomNo = e.getMessage();
        }
        return bomNo;
    }

    public ViewObjectImpl getPOInformationVO1() {
        return (ViewObjectImpl)this.findViewObject("POInformationVO1");
    }

    @Override
    public void findSelLines() {
        popuplineVOImpl vo = this.getpopuplineVO1();
        RowSetIterator it = vo.createRowSetIterator("bb");
        String flag = null;
        while (it.hasNext()) {
            Row r = it.next();
            try {
                flag = r.getAttribute("Multiselect").toString();
                if (flag == null || !flag.equals("Y")) continue;
                this.populateLines1(r, null);
            }
            catch (Exception e) {}
        }
        it.closeRowSetIterator();
    }

    @Override
    public void populateOrderLines(String bomId) {
        popuplineVOImpl populatevo = this.getpopuplineVO1();
        populatevo.setWhereClause("BOM_ID = " + bomId);
        populatevo.executeQuery();
    }

    public void populateLines1(Row poprow, String lineId) {
        Row linerow = this.createLinesSTN();
        linerow.setAttribute("InventoryItemId", (Object)this.getPopulateValue(poprow, "InventoryItemId"));
        linerow.setAttribute("ItemCode", (Object)this.getPopulateValue(poprow, "OrderedItem"));
        linerow.setAttribute("SoObno", (Object)this.getPopulateValue(poprow, "ObRef"));
        linerow.setAttribute("SizeQuantity", (Object)this.getPopulateValue(poprow, "SizeQty"));
        linerow.setAttribute("DcpoNo", (Object)this.getPopulateValue(poprow, "DcpoNo"));
        linerow.setAttribute("Attribute1", (Object)this.getPopulateValue(poprow, "Country"));
        linerow.setAttribute("Color", (Object)this.getPopulateValue(poprow, "Color"));
        linerow.setAttribute("SizeVal", (Object)this.getPopulateValue(poprow, "InseamSizeConcat"));
        linerow.setAttribute("Linerefno", (Object)this.getPopulateValue(poprow, "HeaderId"));
        if (lineId != null) {
            linerow.setAttribute("BomRmlineId", (Object)lineId);
        }
    }

    public Row createLinesSTN() {
        ViewObjectImpl vo = this.getCustMnjOntBomOblineDetailsView1();
        Row row = vo.createRow();
        vo.insertRow(row);
        row.setNewRowState((byte)-1);
        return row;
    }

    public popuplineVOImpl getpopuplineVO1() {
        return (popuplineVOImpl)this.findViewObject("popuplineVO1");
    }

    public ViewObjectImpl getComponentLov1() {
        return (ViewObjectImpl)this.findViewObject("ComponentLov1");
    }

    public double geConsVal() {
        ViewObjectImpl consVo = this.getThreadConsVO1();
        consVo.setWhereClause("STYLE ='" + this.getStyle() + "'");
        consVo.executeQuery();
        consVo.first();
        double consval = 0.0;
        try {
            consval = Double.parseDouble(consVo.getCurrentRow().getAttribute("Cons").toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println("Level 3------>" + consval);
        return consval;
    }

    @Override
    public void callMatFetch() {
        System.out.println("FillLines enter ----------->");
        ViewObjectImpl vo = this.getComponentLov1();
        RowSetIterator it = vo.createRowSetIterator("kk");
        String flag = "true";
        while (it.hasNext()) {
            Row r = it.next();
            try {
                flag = r.getAttribute("MultiSelect").toString();
                System.out.println("MultiSelect -->" + flag);
                if (flag == null || !flag.equals("true")) continue;
                this.populateMaterialLines(r, this.geConsVal());
            }
            catch (Exception e) {}
        }
        it.closeRowSetIterator();
    }

    public int checkOrgAssignment(Row r) throws SQLException {
        int count = 0;
        ViewObjectImpl header = this.getCustMnjOntBomHeaderView1();
        String org = null;
        try {
            org = header.getCurrentRow().getAttribute("OrgId").toString();
        }
        catch (Exception e) {
            org = null;
        }
        String item = this.getPopulateValue(r, "InventoryItemId");
        if (org != null) {
            String query = "SELECT COUNT(*) ITEM FROM MTL_SYSTEM_ITEMS MSI,ORG_ORGANIZATION_DEFINITIONS OOD WHERE MSI.ORGANIZATION_ID = OOD.ORGANIZATION_ID AND OOD.OPERATING_UNIT = ? AND MSI.INVENTORY_ITEM_ID = ?";
            ResultSet resultSet = null;
            PreparedStatement createStatement = this.getDBTransaction().createPreparedStatement(query, 0);
            createStatement.setString(1, org);
            createStatement.setString(2, item);
            resultSet = createStatement.executeQuery();
            if (resultSet.next()) {
                count = Integer.parseInt(resultSet.getString("ITEM"));
            }
            System.out.println("Item exists--" + count);
            resultSet.close();
            createStatement.close();
        }
        return count;
    }

    public boolean checkDuplicate(Row row) {
        ViewObjectImpl itemvo = this.getCustMnjOntBomRmlineLinesView1();
        RowSetIterator it = itemvo.createRowSetIterator(null);
        while (it.hasNext()) {
            Row r = it.next();
            if (!r.getAttribute("ItemDesc").toString().equals(row.getAttribute("Description").toString())) continue;
            return true;
        }
        return false;
    }

    public void populateMaterialLines(Row poprow, double consVal) throws SQLException {
        System.out.println("Level 2   1");
        ViewObjectImpl vo = this.getCustMnjOntBomHeaderView1();
        String bomId = this.getBomId();
        System.out.println("Level 2   2");
        String item = this.getPopulateValue(poprow, "InventoryItemId");
        if (this.checkOrgAssignment(poprow) == 0) {
            System.out.println(" inside item check ---not exists");
            FacesMessage Message = new FacesMessage("Org is not assigned in the following item with Item ID : " + item + " !!");
            Message.setSeverity(FacesMessage.SEVERITY_WARN);
            FacesContext fc = FacesContext.getCurrentInstance();
            fc.addMessage(null, Message);
        } else {
            System.out.println(" inside item check --- exists");
            if (this.checkDuplicate(poprow)) {
                System.out.println(" inside duplicate check ---exists");
                FacesMessage Message = new FacesMessage("This item is already tagged here !!");
                Message.setSeverity(FacesMessage.SEVERITY_ERROR);
                FacesContext fc = FacesContext.getCurrentInstance();
                fc.addMessage(null, Message);
            } else {
                Row linerow = this.createMaterialLines();
                String seg1 = this.getPopulateValue(poprow, "Segment1");
                String seg2 = this.getPopulateValue(poprow, "Segment2");
                String seg4 = this.getPopulateValue(poprow, "Segment4");
                if (this.getPopulateValue(poprow, "ValueDescription").equalsIgnoreCase("Thread")) {
                    linerow.setAttribute("UsageMoUnit", (Object)consVal);
                    System.out.println("Level 2   3");
                }
                linerow.setAttribute("InventoryItemId", (Object)this.getPopulateValue(poprow, "InventoryItemId"));
                linerow.setAttribute("ItemCode", (Object)this.getPopulateValue(poprow, "OrderedItem"));
                linerow.setAttribute("ItemPrefix", (Object)this.getPopulateValue(poprow, "ValueDescription"));
                linerow.setAttribute("MeasureUnitId", (Object)this.getPopulateValue(poprow, "PrimaryUnitOfMeasure"));
                linerow.setAttribute("ItemDesc", (Object)this.getPopulateValue(poprow, "Description"));
                linerow.setAttribute("LegacyCode", (Object)this.getPopulateValue(poprow, "LegacyCode"));
                linerow.setAttribute("OnhandQty1", (Object)this.getPopulateValue(poprow, "OnhandQty"));
                double val1 = this.get03StatusQty(seg1, seg2, seg4, 354);
                linerow.setAttribute("AllocateQty1", (Object)val1);
                linerow.setAttribute("OnhandCgl", (Object)this.getPopulateValue(poprow, "OnhandQtyCgl"));
                double val2 = this.get03StatusQty(seg1, seg2, seg4, 355);
                linerow.setAttribute("AlocateCgl", (Object)val2);
                linerow.setAttribute("OnhahndGfl", (Object)this.getPopulateValue(poprow, "OnhandQtyGfl"));
                double val3 = this.get03StatusQty(seg1, seg2, seg4, 356);
                linerow.setAttribute("AlocateGfl", (Object)val3);
                linerow.setAttribute("LeftOverQty", (Object)(val1 + val2 + val3));
                String prefix = this.getPopulateValue(poprow, "ValueDescription");
                if (prefix.equalsIgnoreCase("Thread")) {
                    linerow.setAttribute("UomConvRate", (Object)this.getPopulateValue(poprow, "Threadlength"));
                }
                System.out.println("Level 2   4");
                this.populateOrderLines(bomId);
                System.out.println("Level 2   5");
                this.autoPopulateSizes(null);
            }
        }
    }

    public Row createMaterialLines() {
        ViewObjectImpl vo = this.getCustMnjOntBomRmlineLinesView1();
        Row row = vo.createRow();
        vo.insertRow(row);
        row.setNewRowState((byte)-1);
        return row;
    }

    public void afterCommit(TransactionEvent transactionEvent) {
        super.afterCommit(transactionEvent);
        String BomId = this.getBomId();
        String stmt = "BEGIN cust_mnj_ont_pkg.SET_TRACKING_NO(:1); end;";
        CallableStatement cs = this.getDBTransaction().createCallableStatement(stmt, 1);
        try {
            cs.setString(1, BomId);
            cs.execute();
            cs.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        FacesContext context = FacesContext.getCurrentInstance();
        FacesMessage message = new FacesMessage("Successfully saved record. ");
        context.addMessage(null, message);
    }

    public ViewObjectImpl getDeliveryDatesVO1() {
        return (ViewObjectImpl)this.findViewObject("DeliveryDatesVO1");
    }

    public ViewLinkImpl getLinesDeliveryDatesVL1() {
        return (ViewLinkImpl)this.findViewLink("LinesDeliveryDatesVL1");
    }

    public ViewObjectImpl getFillZipperVO1() {
        return (ViewObjectImpl)this.findViewObject("FillZipperVO1");
    }

    @Override
    public String fillZipper(String bomId) {
        this.getDBTransaction().commit();
        ViewObjectImpl populatevo = this.getFillZipperVO1();
        populatevo.setWhereClause("BOM_ID = " + bomId);
        populatevo.executeQuery();
        int count = 0;
        if (populatevo.getRowCount() == 0) {
            // empty if block
        }
        RowSetIterator it = populatevo.createRowSetIterator("ii");
        while (it.hasNext()) {
            ++count;
            Row r = it.next();
            this.populateZipper(r, bomId);
        }
        if (count == 0) {
            it.closeRowSetIterator();
            return "No any item matched to these criteria .";
        }
        it.closeRowSetIterator();
        return null;
    }

    public void populateZipper(Row poprow, String bomId) {
        Row linerow = this.createMaterialLines();
        String seg1 = this.getPopulateValue(poprow, "Segment1");
        String seg2 = this.getPopulateValue(poprow, "Segment2");
        String seg4 = this.getPopulateValue(poprow, "Segment4");
        linerow.setAttribute("InventoryItemId", (Object)this.getPopulateValue(poprow, "InventoryItemId"));
        linerow.setAttribute("LegacyCode", (Object)this.getPopulateValue(poprow, "SupplierCode"));
        linerow.setAttribute("ItemDesc", (Object)this.getPopulateValue(poprow, "Description"));
        linerow.setAttribute("MeasureUnitId", (Object)this.getPopulateValue(poprow, "PrimaryUnitOfMeasure"));
        linerow.setAttribute("OnhandQty1", (Object)this.getPopulateValue(poprow, "OnhandQty"));
        double val1 = this.get03StatusQty(seg1, seg2, seg4, 354);
        linerow.setAttribute("AllocateQty1", (Object)val1);
        linerow.setAttribute("OnhandCgl", (Object)this.getPopulateValue(poprow, "OnhandQtyCgl"));
        double val2 = this.get03StatusQty(seg1, seg2, seg4, 355);
        linerow.setAttribute("AlocateCgl", (Object)val2);
        linerow.setAttribute("OnhahndGfl", (Object)this.getPopulateValue(poprow, "OnhandQtyGfl"));
        double val3 = this.get03StatusQty(seg1, seg2, seg4, 356);
        linerow.setAttribute("AlocateGfl", (Object)val3);
        linerow.setAttribute("LeftOverQty", (Object)(val1 + val2 + val3));
        String sizeVal = this.getPopulateValue(poprow, "SizeVal");
        ViewObjectImpl ziperSize = this.getZipperSizesVO1();
        ziperSize.setWhereClause("BOM_ID = " + bomId + " AND SIZE_VAL='" + sizeVal + "'");
        ziperSize.executeQuery();
        RowSetIterator it = this.getZipperSizesVO1().createRowSetIterator("zasd");
        while (it.hasNext()) {
            Row r = it.next();
            String size = this.getPopulateValue(r, "SizeVal");
            this.FillZprDffSizes(size);
        }
        it.closeRowSetIterator();
    }

    public ViewObjectImpl getFillThreadVO1() {
        return (ViewObjectImpl)this.findViewObject("FillThreadVO1");
    }

    @Override
    public String fillThread(String bpo, String style) {
        this.getDBTransaction().commit();
        ViewObjectImpl populatevo = this.getFillThreadVO1();
        populatevo.setWhereClause("STYLE = '" + style + "'");
        populatevo.executeQuery();
        int count = 0;
        if (populatevo.getRowCount() == 0) {
            // empty if block
        }
        RowSetIterator it = populatevo.createRowSetIterator("hh");
        while (it.hasNext()) {
            ++count;
            Row r = it.next();
            this.populateThread(r);
        }
        if (count == 0) {
            it.closeRowSetIterator();
            return "No any item matched to Style .";
        }
        it.closeRowSetIterator();
        return null;
    }

    public void populateThread(Row poprow) {
        Row linerow = this.createMaterialLines();
        String seg1 = this.getPopulateValue(poprow, "Segment1");
        String seg2 = this.getPopulateValue(poprow, "Segment2");
        String seg4 = this.getPopulateValue(poprow, "Segment4");
        linerow.setAttribute("UsageMoUnit", (Object)this.getPopulateValue(poprow, "Cons"));
        linerow.setAttribute("InventoryItemId", (Object)this.getPopulateValue(poprow, "InventoryItemId"));
        linerow.setAttribute("LegacyCode", (Object)this.getPopulateValue(poprow, "SupplierCode"));
        linerow.setAttribute("ItemDesc", (Object)this.getPopulateValue(poprow, "Description"));
        linerow.setAttribute("MeasureUnitId", (Object)this.getPopulateValue(poprow, "PrimaryUnitOfMeasure"));
        linerow.setAttribute("OnhandQty1", (Object)this.getPopulateValue(poprow, "OnhandQty"));
        double val1 = this.get03StatusQty(seg1, seg2, seg4, 354);
        linerow.setAttribute("AllocateQty1", (Object)val1);
        linerow.setAttribute("OnhandCgl", (Object)this.getPopulateValue(poprow, "OnhandQtyCgl"));
        double val2 = this.get03StatusQty(seg1, seg2, seg4, 355);
        linerow.setAttribute("AlocateCgl", (Object)val2);
        linerow.setAttribute("OnhahndGfl", (Object)this.getPopulateValue(poprow, "OnhandQtyGfl"));
        double val3 = this.get03StatusQty(seg1, seg2, seg4, 356);
        linerow.setAttribute("AlocateGfl", (Object)val3);
        linerow.setAttribute("LeftOverQty", (Object)(val1 + val2 + val3));
        linerow.setAttribute("UomConvRate", (Object)Double.parseDouble(this.getPopulateValue(poprow, "ThreadLength")));
        this.populateOrderLines(this.getBomId());
        this.autoPopulateSizes(null);
    }

    public void autoPopulateSizes(String lineId) {
        popuplineVOImpl vo = this.getpopuplineVO1();
        RowSetIterator it = vo.createRowSetIterator("gg");
        Object flag = null;
        while (it.hasNext()) {
            Row r = it.next();
            try {
                this.populateLines1(r, lineId);
            }
            catch (Exception e) {}
        }
        it.closeRowSetIterator();
    }

    public String getBomId() {
        ViewObjectImpl vo = this.getCustMnjOntBomHeaderView1();
        String orderHeaderId = null;
        try {
            orderHeaderId = vo.getCurrentRow().getAttribute("BomId").toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return orderHeaderId;
    }

    public String getStyle() {
        ViewObjectImpl vo = this.getCustMnjOntBomHeaderView1();
        String style = null;
        try {
            style = vo.getCurrentRow().getAttribute("StyleNameC").toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return style;
    }

    public void FillZprDffSizes(String size) {
        String bomId = this.getBomId();
        popuplineVOImpl populatevo = this.getpopuplineVO1();
        populatevo.setWhereClause("BOM_ID = " + bomId + " AND INSEAM_SIZE_CONCAT ='" + size + "'");
        populatevo.executeQuery();
        this.autoPopulateSizes(null);
    }

    @Override
    public void HeaderActions(String type) {
        ViewObjectImpl vo = this.getCustMnjOntBomHeaderView1();
        String headerId = vo.getCurrentRow().getAttribute("BomId").toString();
        String stmt = "BEGIN cust_mnj_ont_pkg.COPY_BOM(:1,:2); end;";
        CallableStatement cs = this.getDBTransaction().createCallableStatement(stmt, 1);
        try {
            cs.registerOutParameter(1, 12);
            cs.setString(1, headerId);
            cs.setString(2, type);
            cs.execute();
            cs.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        vo.executeQuery();
    }

    @Override
    public void setSessionValues(String orgId, String userId, String respId, String respAppl) {
        if (userId != null) {
            System.out.println("User ID-------------->>" + userId);
            FacesContext fctx = FacesContext.getCurrentInstance();
            ExternalContext ectx = fctx.getExternalContext();
            HttpSession userSession = (HttpSession)ectx.getSession(false);
            userSession.setAttribute("userId", (Object)userId);
            userSession.setAttribute("orgId", (Object)orgId);
            System.out.println("User ID-------------->>" + userId);
        }
    }

    @Override
    public void setSession(String orgId, String userId, String respId, String respAppl) {
        if (userId != null) {
            System.out.println("User ID-------------->>" + userId);
            FacesContext fctx = FacesContext.getCurrentInstance();
            ExternalContext ectx = fctx.getExternalContext();
            HttpSession userSession = (HttpSession)ectx.getSession(false);
            userSession.setAttribute("userId", (Object)userId);
            userSession.setAttribute("orgId", (Object)orgId);
            System.out.println("User ID-------------->>" + userId);
        }
    }

    public double get03StatusQty(String seg1, String seg2, String seg4, int orgId) {
        String stmt = "BEGIN :1 := mnj_get03_status_itemQty(:2,:3,:4, :5); end;";
        CallableStatement cs = this.getDBTransaction().createCallableStatement(stmt, 1);
        double qty = 0.0;
        try {
            cs.registerOutParameter(1, 2);
            cs.setString(2, seg1);
            cs.setString(3, seg2);
            cs.setString(4, seg4);
            cs.setInt(5, orgId);
            cs.execute();
            qty = cs.getDouble(1);
            cs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return qty;
    }

    @Override
    public void refreshSizes() {
        String bomId = this.getBomId();
        ViewObjectImpl linesVO = this.getCustMnjOntBomRmlineLinesView1();
        RowSetIterator it = linesVO.createRowSetIterator("adsf");
        Row r = null;
        this.populateOrderLines(bomId);
        while (it.hasNext()) {
            r = it.next();
            this.autoPopulateSizes(r.getAttribute("BomRmlineId").toString());
        }
        it.closeRowSetIterator();
    }

    @Override
    public String getAttachments() {
        String status = null;
        String doc = null;
        ViewObjectImpl vo = this.getCustMnjOntBomHeaderView1();
        try {
            doc = vo.getCurrentRow().getAttribute("BomNumber").toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        String stmt = "BEGIN mnj_get_attach_names(:1, :2, :3); end;";
        CallableStatement cs = this.getDBTransaction().createCallableStatement(stmt, 1);
        try {
            cs.registerOutParameter(3, 12);
            cs.setString(1, "MB");
            cs.setString(2, doc);
            cs.execute();
            status = cs.getString(3);
            cs.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return status;
    }

    @Override
    public void selectAllLines(String flag) {
        popuplineVOImpl populatevo = this.getpopuplineVO1();
        RowSetIterator it = populatevo.createRowSetIterator("yy");
        while (it.hasNext()) {
            Row row = it.next();
            row.setAttribute("Multiselect", (Object)flag);
        }
        it.closeRowSetIterator();
    }

    public ViewObjectImpl getColorSearch1() {
        return (ViewObjectImpl)this.findViewObject("ColorSearch1");
    }

    public ViewObjectImpl getSizeSearch1() {
        return (ViewObjectImpl)this.findViewObject("SizeSearch1");
    }

    public ViewObjectImpl getCountrySearch1() {
        return (ViewObjectImpl)this.findViewObject("CountrySearch1");
    }

    @Override
    public void setMultiSearchWherClause(String saleOrderID) {
        ViewObjectImpl countryVo = this.getCountrySearch1();
        ViewObjectImpl colorVo = this.getColorSearch1();
        ViewObjectImpl sizeVo = this.getSizeSearch1();
        ViewObjectImpl bpoVO = this.getBPOSearch1();
        countryVo.executeQuery();
        colorVo.executeQuery();
        sizeVo.executeQuery();
        bpoVO.executeQuery();
    }

    @Override
    public void poplateMultiSearch(String headerId) {
        this.clearAllSizes();
        ViewObjectImpl bpoVo = this.getBPOSearch1();
        ViewObjectImpl countryVo = this.getCountrySearch1();
        ViewObjectImpl colorVo = this.getColorSearch1();
        ViewObjectImpl sizeVo = this.getSizeSearch1();
        String flag0 = null;
        String flag1 = null;
        String flag2 = null;
        String flag3 = null;
        String country = null;
        String color = null;
        String size = null;
        RowSetIterator it0 = bpoVo.createRowSetIterator("w");
        while (it0.hasNext()) {
            Row r0 = it0.next();
            try {
                flag0 = r0.getAttribute("BPOFlag").toString();
            }
            catch (Exception e) {
                flag0 = "N";
            }
            if (flag0 == null || !flag0.equals("Y")) continue;
            headerId = r0.getAttribute("SaleOrderId").toString();
            RowSetIterator it1 = countryVo.createRowSetIterator("x");
            while (it1.hasNext()) {
                Row r = it1.next();
                try {
                    flag1 = r.getAttribute("CountryFlag").toString();
                }
                catch (Exception e) {
                    flag1 = "N";
                }
                if (flag1 == null || !flag1.equals("Y")) continue;
                try {
                    country = r.getAttribute("Country").toString();
                }
                catch (Exception e) {
                    // empty catch block
                }
                RowSetIterator it2 = colorVo.createRowSetIterator("y");
                while (it2.hasNext()) {
                    Row r2 = it2.next();
                    try {
                        flag2 = r2.getAttribute("ColorFlag").toString();
                    }
                    catch (Exception e) {
                        flag2 = "N";
                    }
                    System.out.println("Color loop flag ---------------->" + flag2);
                    if (flag2 == null || !flag2.equals("Y")) continue;
                    color = (String)r2.getAttribute("Color");
                    System.out.println("Color ---------------->" + color);
                    RowSetIterator it3 = sizeVo.createRowSetIterator("z");
                    while (it3.hasNext()) {
                        Row r3 = it3.next();
                        try {
                            flag3 = r3.getAttribute("SizeFlag").toString();
                        }
                        catch (Exception e) {
                            flag3 = "N";
                        }
                        if (flag3 == null || !flag3.equals("Y")) continue;
                        flag3 = "N";
                        size = (String)r3.getAttribute("InseamSizeConcat");
                        this.processMultiSizes(headerId, country, color, size);
                    }
                    it3.closeRowSetIterator();
                }
                it2.closeRowSetIterator();
            }
            it1.closeRowSetIterator();
        }
        it0.closeRowSetIterator();
    }

    public void processMultiSizes(String headerId, String country, String color, String size) {
        popuplineVOImpl vo = this.getpopuplineVO1();
        vo.setWhereClause(null);
        vo.setWhereClause("HEADER_ID =" + headerId + " AND Country ='" + country + "' and Color = '" + color + "' and INSEAM_SIZE_CONCAT='" + size + "'");
        vo.executeQuery();
        RowSetIterator it = vo.createRowSetIterator("sz");
        Object flag = null;
        while (it.hasNext()) {
            Row r = it.next();
            this.populateLines1(r, null);
        }
        it.closeRowSetIterator();
    }

    public void clearAllSizes() {
        ViewObjectImpl vo = this.getCustMnjOntBomOblineDetailsView1();
        RowSetIterator it = vo.createRowSetIterator("pp");
        while (it.hasNext()) {
            it.next().remove();
        }
        it.closeRowSetIterator();
    }

    public ViewObjectImpl getBomBpoLinesAllVO1() {
        return (ViewObjectImpl)this.findViewObject("BomBpoLinesAllVO1");
    }

    public ViewLinkImpl getHeaderLinesVL1() {
        return (ViewLinkImpl)this.findViewLink("HeaderLinesVL1");
    }

    public ViewObjectImpl getBPOSearch1() {
        return (ViewObjectImpl)this.findViewObject("BPOSearch1");
    }

    @Override
    public void sizesCiritSelectDesel(String flag, String type) {
        Row[] r;
        ViewObjectImpl populatevo = null;
        String flagName = null;
        if (type.equalsIgnoreCase("BPO")) {
            populatevo = this.getBPOSearch1();
            flagName = "BPOFlag";
        } else if (type.equalsIgnoreCase("Country")) {
            populatevo = this.getCountrySearch1();
            flagName = "CountryFlag";
        } else if (type.equalsIgnoreCase("Color")) {
            populatevo = this.getColorSearch1();
            flagName = "ColorFlag";
        } else if (type.equalsIgnoreCase("Size")) {
            populatevo = this.getSizeSearch1();
            flagName = "SizeFlag";
        }
        for (Row row : r = populatevo.getAllRowsInRange()) {
            row.setAttribute(flagName, (Object)flag);
        }
    }

    public ViewObjectImpl getZipperSizesVO1() {
        return (ViewObjectImpl)this.findViewObject("ZipperSizesVO1");
    }

    public ViewObjectImpl getThreadConsVO1() {
        return (ViewObjectImpl)this.findViewObject("ThreadConsVO1");
    }

    public ViewObjectImpl getBomLinesPRHistoryVO1() {
        return (ViewObjectImpl)this.findViewObject("BomLinesPRHistoryVO1");
    }

    public ViewLinkImpl getHeaderPRHistoryLinesVL1() {
        return (ViewLinkImpl)this.findViewLink("HeaderPRHistoryLinesVL1");
    }

    public ViewObjectImpl getSizeWiseDetailVO1() {
        return (ViewObjectImpl)this.findViewObject("SizeWiseDetailVO1");
    }

    public ViewLinkImpl getRmLinesSizeWiseVL1() {
        return (ViewLinkImpl)this.findViewLink("RmLinesSizeWiseVL1");
    }

    public void clearSizeBreakUpAll() {
        this.getDBTransaction().commit();
        ViewObjectImpl vos = this.getSizeWiseDetailVO1();
        vos.setWhereClause("FLAG ='A'");
        vos.executeQuery();
        ViewObjectImpl vo = this.getSizeWiseDetailVO1();
        RowSetIterator it = vo.createRowSetIterator("ff");
        while (it.hasNext()) {
            it.next().remove();
        }
        it.closeRowSetIterator();
    }

    @Override
    public void fillSizeBreakUp() {
        String size;
        this.clearSizeBreakUpAll();
        ViewObjectImpl vo = this.getCustMnjOntBomOblineDetailsView1();
        RowSetIterator it = vo.createRowSetIterator(null);
        it.reset();
        Hashtable<String, Integer> table = new Hashtable<String, Integer>();
        while (it.hasNext()) {
            Row r = it.next();
            int sizeQty = Integer.parseInt(r.getAttribute("SizeQuantity").toString());
            size = r.getAttribute("SizeVal").toString();
            System.out.println("Size value----->" + table.containsKey(size));
            if (!table.containsKey(size)) {
                table.put(size, sizeQty);
                System.out.println("if conditions---->");
                continue;
            }
            int value = (Integer)table.get(size);
            System.out.println(value + "Size qty after sum" + (sizeQty += value));
            table.remove(size);
            table.put(size, sizeQty);
        }
        it.reset();
        it.closeRowSetIterator();
        Enumeration names = table.keys();
        while (names.hasMoreElements()) {
            Row r = this.createSizeBreakup();
            size = (String)names.nextElement();
            int sizeQty = (Integer)table.get(size);
            this.setSizeBreakupValues(r, size, sizeQty);
        }
        table.clear();
        this.getDBTransaction().commit();
    }

    public void setSizeBreakupValues(Row r, String size, int sizeQty) {
        ViewObjectImpl lVo = this.getCustMnjOntBomRmlineLinesView1();
        Row lineR = lVo.getCurrentRow();
        double consQtyVal = 0.0;
        double wastageQtyVal = 0.0;
        double prcntg = 0.0;
        double pricePerUnitVal = 0.0;
        double unitConvRateVal = 0.0;
        try {
            consQtyVal = Double.parseDouble(lineR.getAttribute("UsageMoUnit").toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            wastageQtyVal = Double.parseDouble(lineR.getAttribute("ExtraUsage").toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            prcntg = Double.parseDouble(lineR.getAttribute("Perntg").toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        unitConvRateVal = AppModuleImpl.numeric3(lineR.getAttribute("UomConvRate"));
        double reqQtyVal = Math.ceil((double)sizeQty * consQtyVal * (1.0 + wastageQtyVal / 100.0));
        if (unitConvRateVal > 0.0) {
            reqQtyVal /= unitConvRateVal;
        }
        reqQtyVal = AppModuleImpl.roundUp(reqQtyVal);
        double projPRQty = prcntg * reqQtyVal / 100.0;
        r.setAttribute("SizeVal", (Object)size);
        r.setAttribute("SizeWiseOrderQty", (Object)sizeQty);
        r.setAttribute("SizeWiseBomReqQty", (Object)reqQtyVal);
        r.setAttribute("BookingPercent", (Object)prcntg);
        r.setAttribute("SizeWiseProjQty", (Object)projPRQty);
        r.setAttribute("ActualQty", (Object)projPRQty);
        r.setAttribute("Flag", (Object)"A");
    }

    public Row createSizeBreakup() {
        ViewObjectImpl vo = this.getSizeWiseDetailVO1();
        Row row = vo.createRow();
        vo.insertRow(row);
        row.setNewRowState((byte)-1);
        return row;
    }

    @Override
    public void postAdditionalQty() {
        ViewObjectImpl vo = this.getSizeWiseDetailVO1();
        RowSetIterator it = vo.createRowSetIterator("aad");
        double addiQtyVal = 0.0;
        while (it.hasNext()) {
            Row r = it.next();
            try {
                addiQtyVal += Double.parseDouble(r.getAttribute("AddDeduct").toString());
            }
            catch (Exception e) {}
        }
        it.closeRowSetIterator();
        this.getCustMnjOntBomRmlineLinesView1().getCurrentRow().setAttribute("AdditionalQty", (Object)addiQtyVal);
        System.out.println("Post qty ---->" + addiQtyVal);
        ViewObjectImpl lVo = this.getCustMnjOntBomRmlineLinesView1();
        Row lineR = lVo.getCurrentRow();
        double pricePerUnitVal = 0.0;
        double projPrQtyVal = 0.0;
        double bomReqQtyVal = 0.0;
        double actualPrcntVal = 0.0;
        String itemId = null;
        pricePerUnitVal = AppModuleImpl.numeric3(lineR.getAttribute("PricePerUnit"));
        projPrQtyVal = AppModuleImpl.numeric3(lineR.getAttribute("ProjPrQty"));
        bomReqQtyVal = AppModuleImpl.numeric3(lineR.getAttribute("NoOfGarment"));
        try {
            itemId = lineR.getAttribute("InventoryItemId").toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        double prQtyVal = addiQtyVal + projPrQtyVal;
        double actualPrQtySumVal = this.getLineQtySum("BookedQty", prQtyVal, itemId);
        System.out.println("Actual PR Qty sum in AM----------------->" + actualPrQtySumVal);
        try {
            actualPrcntVal = AppModuleImpl.changeToDouble(actualPrQtySumVal / bomReqQtyVal * 100.0);
        }
        catch (Exception e) {
            actualPrcntVal = 0.0;
        }
        double pendingPrcnt = 100.0 - actualPrQtySumVal / bomReqQtyVal * 100.0;
        lineR.setAttribute("Total", (Object)(prQtyVal * pricePerUnitVal));
        lineR.setAttribute("BookedQty", (Object)prQtyVal);
        lineR.setAttribute("ActualPrcnt", (Object)actualPrcntVal);
        lineR.setAttribute("PendingPrcnt", (Object)pendingPrcnt);
        lineR.setAttribute("AccumPrcnt", (Object)actualPrQtySumVal);
    }

    public double getLineQtySum(String name, double curntVal, String itemId) {
        ViewObjectImpl lVo = this.getBomLinesPRHistoryVO1();
        RowSetIterator it = lVo.createRowSetIterator("a");
        Row currentRow = lVo.getCurrentRow();
        double total = curntVal;
        int inventoryItemId = Integer.parseInt(itemId);
        Object itemIdCheck = null;
        while (it.hasNext()) {
            Row r = it.next();
            String itemid2 = r.getAttribute("InventoryItemId").toString();
            if (!itemid2.equals(itemId)) continue;
            System.out.println("Booked qty AM count----------------->" + AppModuleImpl.numeric3(r.getAttribute(name)));
            total += AppModuleImpl.numeric3(r.getAttribute(name));
        }
        it.closeRowSetIterator();
        return total;
    }

    public static double numeric3(Object ob) {
        try {
            if (ob != null) {
                return Double.parseDouble(String.valueOf(ob));
            }
            return 0.0;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public static double changeToDouble(double n) {
        if (Double.isNaN(n)) {
            return 0.0;
        }
        if (Double.isInfinite(n)) {
            return 0.0;
        }
        return n;
    }

    public static double roundUp(double n) {
        String value = String.valueOf(n);
        if (!value.contains(".")) {
            return n;
        }
        char[] charArray = value.toCharArray();
        if (charArray.length - value.substring(0, value.indexOf(".") + 1).length() > 0) {
            BigDecimal bdTest1 = new BigDecimal(value);
            BigDecimal another = bdTest1.setScale(0, 2);
            return another.doubleValue();
        }
        return n;
    }

    public ViewObjectImpl getBuyerCriteria1() {
        return (ViewObjectImpl)this.findViewObject("BuyerCriteria1");
    }

    public ViewObjectImpl getFillBPOVO1() {
        return (ViewObjectImpl)this.findViewObject("FillBPOVO1");
    }

    @Override
    public void populateBPOLines1() {
        String StyleNo = null;
        String StyleName = null;
        String Season = null;
        String vBuyerID = null;
        ViewObjectImpl lVo = this.getCustMnjOntBomHeaderView1();
        Row lineR = lVo.getCurrentRow();
        try {
            vBuyerID = lVo.getCurrentRow().getAttribute("BuyerId").toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            StyleNo = lVo.getCurrentRow().getAttribute("StyleNoC").toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            StyleName = lineR.getAttribute("StyleNameC").toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Season = lineR.getAttribute("SeasonC").toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        ViewObjectImpl populatevo = this.getFillBPOVO1();
        populatevo.setWhereClause("Season = Nvl('" + Season + "',Season) " + "and  Buyer_Id = " + "Nvl('" + vBuyerID + "',Buyer_Id) " + " And (style_name = " + "Nvl('" + StyleName + "',style_name) " + " Or style_no = " + "Nvl('" + StyleNo + "',style_no))");
        System.out.println("Season = " + Season + " and  Buyer_Id = " + vBuyerID + " And style_name = " + StyleName + " Or style_no = " + StyleNo);
        populatevo.executeQuery();
    }

    @Override
    public void callBPOFetch() {
        Row[] r;
        ViewObjectImpl populatevo = this.getFillBPOVO1();
        if (populatevo.getRowCount() == 0) {
            // empty if block
        }
        RowSetIterator it = populatevo.createRowSetIterator("cc");
        for (Row row : r = populatevo.getAllRowsInRange()) {
            try {
                String flag = row.getAttribute("SelectAll").toString();
                System.out.println("Flag Code -->" + flag);
                if (!flag.equals("Y")) continue;
                this.populateBPOLines(row);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        it.closeRowSetIterator();
    }

    public Row createBPOLines() {
        ViewObjectImpl vo = this.getBomBpoLinesAllVO1();
        Row row = vo.createRow();
        vo.insertRow(row);
        row.setNewRowState((byte)-1);
        return row;
    }

    public void populateBPOLines(Row poprow) {
        ViewObjectImpl vo = this.getBomBpoLinesAllVO1();
        Row linerow = this.createBPOLines();
        linerow.setAttribute("BpoNo", (Object)this.getPopulateValue(poprow, "BpoNo"));
        System.out.println("BpoNo----" + this.getPopulateValue(poprow, "BpoNo"));
        linerow.setAttribute("Category", (Object)this.getPopulateValue(poprow, "Category"));
        System.out.println("Category----" + this.getPopulateValue(poprow, "Category"));
        linerow.setAttribute("OrderQty", (Object)this.getPopulateValue(poprow, "OrderedQty"));
        linerow.setAttribute("EndUserDesc", (Object)this.getPopulateValue(poprow, "EndUser"));
        linerow.setAttribute("Fit", (Object)this.getPopulateValue(poprow, "Fit"));
        linerow.setAttribute("UserItemDesc", (Object)this.getPopulateValue(poprow, "ItemDescription"));
        linerow.setAttribute("Brand", (Object)this.getPopulateValue(poprow, "Brand"));
        linerow.setAttribute("SaleOrderId", (Object)this.getPopulateValue(poprow, "HeaderId"));
        linerow.setAttribute("Season", (Object)this.getPopulateValue(poprow, "Season"));
        this.populateBPOLines1();
    }

    @Override
    public void selectAllBPO(String flag) {
        ViewObjectImpl populatevo = this.getFillBPOVO1();
        RowSetIterator it = populatevo.createRowSetIterator("yy");
        while (it.hasNext()) {
            Row row = it.next();
            row.setAttribute("SelectAll", (Object)flag);
        }
        it.closeRowSetIterator();
    }

    public ViewObjectImpl getFabricCustomReportVO1() {
        return (ViewObjectImpl)this.findViewObject("FabricCustomReportVO1");
    }

    public ViewLinkImpl getFabricCustomReportVLink1() {
        return (ViewLinkImpl)this.findViewLink("FabricCustomReportVLink1");
    }

    public ViewObjectImpl getFabricCustomReportItemVO1() {
        return (ViewObjectImpl)this.findViewObject("FabricCustomReportItemVO1");
    }

    public ViewLinkImpl getCustomReportHeaderItemVLink1() {
        return (ViewLinkImpl)this.findViewLink("CustomReportHeaderItemVLink1");
    }

    public ViewObjectImpl getMaterialSheetVO1() {
        return (ViewObjectImpl)this.findViewObject("MaterialSheetVO1");
    }

    public ViewLinkImpl getMaterialSheetViewLink1() {
        return (ViewLinkImpl)this.findViewLink("MaterialSheetViewLink1");
    }

    public ViewObjectImpl getUserInfoVO1() {
        return (ViewObjectImpl)this.findViewObject("UserInfoVO1");
    }

    public ViewObjectImpl getSPOAndBOMVO1() {
        return (ViewObjectImpl)this.findViewObject("SPOAndBOMVO1");
    }

    public ViewObjectImpl getmulti_Bom_Header_VO1() {
        return (ViewObjectImpl)this.findViewObject("multi_Bom_Header_VO1");
    }

    public ViewObjectImpl getCustMnjOntBomRmlineEO_autoView1() {
        return (ViewObjectImpl)this.findViewObject("CustMnjOntBomRmlineEO_autoView1");
    }

    public ViewObjectImpl getfilterVO1() {
        return (ViewObjectImpl)this.findViewObject("filterVO1");
    }

    public ViewObjectImpl getheaderSearchVO1() {
        return (ViewObjectImpl)this.findViewObject("headerSearchVO1");
    }

    public ViewObjectImpl getAssignBPOQtyForMultiBOM1() {
        return (ViewObjectImpl)this.findViewObject("AssignBPOQtyForMultiBOM1");
    }

    public ViewObjectImpl getPOInfoVO1() {
        return (ViewObjectImpl)this.findViewObject("POInfoVO1");
    }

    public ViewObjectImpl getMnjBomPoDffVO1() {
        return (ViewObjectImpl)this.findViewObject("MnjBomPoDffVO1");
    }

    public ViewLinkImpl getpoInformationVSpoDffViewLink1() {
        return (ViewLinkImpl)this.findViewLink("poInformationVSpoDffViewLink1");
    }

    public ViewObjectImpl getpriceSupplierProdAreaLOV1() {
        return (ViewObjectImpl)this.findViewObject("priceSupplierProdAreaLOV1");
    }
}

