# Hepek ![master](https://github.com/sake92/hepek/actions/workflows/ci.yml/badge.svg?branch=master)

The main theme of Hepek projects is **typesafe but flexible HTML**.  
See these posts for motivation: 
- [Why templates are dead](https://codeburst.io/80-of-my-coding-is-doing-this-or-why-templates-are-dead-b640fc149e22)
- [Modern Type-Safe Template Engines](https://dzone.com/articles/modern-type-safe-template-engines)

## Projects:

### [Hepek Components](https://sake92.github.io/hepek/hepek/components/index.html) [![Maven Central](https://img.shields.io/maven-central/v/ba.sake/hepek-components_3.svg?style=flat-square&label=Scala+3)](https://mvnrepository.com/artifact/ba.sake/hepek-components)
Typesafe templates, grids, forms, code highlighting, markdown etc.  
JVM and ScalaJS supported! 

Support for custom attributes:
- [HTMX](https://htmx.org/reference/#attributes)
- [AlpineJS](https://alpinejs.dev/directives/data)

---
### [Hepek SSG](https://sake92.github.io/hepek/hepek/index.html)  [![Maven Central](https://img.shields.io/maven-central/v/ba.sake/hepek_3.svg?style=flat-square&label=Scala+3)](https://mvnrepository.com/artifact/ba.sake/hepek)
Static site generator for developers.  
Make your own website and deploy it with Netlify (yes, for free) in just a few clicks:  
[![Deploy to Netlify](https://www.netlify.com/img/deploy/button.svg)](https://app.netlify.com/start/deploy?repository=https://github.com/sake92/hepek-starter)

Resources:
- [documentation](https://sake92.github.io/hepek)
- [starter template](https://github.com/sake92/hepek-starter)
- [examples](https://github.com/sake92/hepek-examples)
- [source code](https://github.com/sake92/sake-ba-source) of sake.ba
- [source code](https://github.com/sake92/sake-ba-blog-source) of blog.sake.ba (code examples, math snippets etc.)

---
### Integrations

#### [Sharaf](https://github.com/sake92/sharaf)
Shraf integration.
- [fullstack example](https://github.com/sake92/sharaf/tree/main/examples/fullstack)
- [petclinic implementation](https://github.com/sake92/sharaf-petclinic)

#### [Hepek Play](https://sake92.github.io/hepek/integrations/play-framework.html)  [![Maven Central](https://img.shields.io/maven-central/v/ba.sake/hepek-play_3.svg?style=flat-square&label=Scala+3)](https://mvnrepository.com/artifact/ba.sake/hepek-play)
Play framework integration.
- [hepek-play-example](https://github.com/sake92/hepek-play-example)

#### [Hepek Http4s](https://sake92.github.io/hepek/integrations/http4s.html)  [![Maven Central](https://img.shields.io/maven-central/v/ba.sake/hepek-http4s_3.svg?style=flat-square&label=Scala+3)](https://mvnrepository.com/artifact/ba.sake/hepek-http4s)
Http4s integration.
- [hepek-http4s-example](https://github.com/sake92/hepek-http4s-example)

#### [Hepek ZIO](https://sake92.github.io/hepek/integrations/zio.html)  [![Maven Central](https://img.shields.io/maven-central/v/ba.sake/hepek-zio_3.svg?style=flat-square&label=Scala+3)](https://mvnrepository.com/artifact/ba.sake/hepek-zio)
ZIO integration.
- [hepek-zio-example](https://github.com/sake92/hepek-zio-example)



