/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.ASTVector;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Model;
import com.microsoft.z3.Native;
import com.microsoft.z3.ParamDescrs;
import com.microsoft.z3.Params;
import com.microsoft.z3.Statistics;
import com.microsoft.z3.Status;
import com.microsoft.z3.StringSymbol;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.enumerations.Z3_lbool;

public class Optimize
extends Z3Object {
    public String getHelp() {
        return Native.optimizeGetHelp(this.getContext().nCtx(), this.getNativeObject());
    }

    public void setParameters(Params params) {
        Native.optimizeSetParams(this.getContext().nCtx(), this.getNativeObject(), params.getNativeObject());
    }

    public ParamDescrs getParameterDescriptions() {
        return new ParamDescrs(this.getContext(), Native.optimizeGetParamDescrs(this.getContext().nCtx(), this.getNativeObject()));
    }

    public void Assert(BoolExpr ... boolExprArray) {
        this.getContext().checkContextMatch(boolExprArray);
        for (BoolExpr boolExpr : boolExprArray) {
            Native.optimizeAssert(this.getContext().nCtx(), this.getNativeObject(), boolExpr.getNativeObject());
        }
    }

    public void Add(BoolExpr ... boolExprArray) {
        this.Assert(boolExprArray);
    }

    public Handle AssertSoft(BoolExpr boolExpr, int n, String string) {
        this.getContext().checkContextMatch(boolExpr);
        StringSymbol stringSymbol = this.getContext().mkSymbol(string);
        return new Handle(this, Native.optimizeAssertSoft(this.getContext().nCtx(), this.getNativeObject(), boolExpr.getNativeObject(), Integer.toString(n), stringSymbol.getNativeObject()));
    }

    public Status Check() {
        Z3_lbool z3_lbool = Z3_lbool.fromInt(Native.optimizeCheck(this.getContext().nCtx(), this.getNativeObject()));
        switch (z3_lbool) {
            case Z3_L_TRUE: {
                return Status.SATISFIABLE;
            }
            case Z3_L_FALSE: {
                return Status.UNSATISFIABLE;
            }
        }
        return Status.UNKNOWN;
    }

    public void Push() {
        Native.optimizePush(this.getContext().nCtx(), this.getNativeObject());
    }

    public void Pop() {
        Native.optimizePop(this.getContext().nCtx(), this.getNativeObject());
    }

    public Model getModel() {
        long l = Native.optimizeGetModel(this.getContext().nCtx(), this.getNativeObject());
        if (l == 0L) {
            return null;
        }
        return new Model(this.getContext(), l);
    }

    public Handle MkMaximize(Expr expr) {
        return new Handle(this, Native.optimizeMaximize(this.getContext().nCtx(), this.getNativeObject(), expr.getNativeObject()));
    }

    public Handle MkMinimize(Expr expr) {
        return new Handle(this, Native.optimizeMinimize(this.getContext().nCtx(), this.getNativeObject(), expr.getNativeObject()));
    }

    private Expr GetLower(int n) {
        return Expr.create(this.getContext(), Native.optimizeGetLower(this.getContext().nCtx(), this.getNativeObject(), n));
    }

    private Expr GetUpper(int n) {
        return Expr.create(this.getContext(), Native.optimizeGetUpper(this.getContext().nCtx(), this.getNativeObject(), n));
    }

    private Expr[] GetUpperAsVector(int n) {
        return this.unpackObjectiveValueVector(Native.optimizeGetUpperAsVector(this.getContext().nCtx(), this.getNativeObject(), n));
    }

    private Expr[] GetLowerAsVector(int n) {
        return this.unpackObjectiveValueVector(Native.optimizeGetLowerAsVector(this.getContext().nCtx(), this.getNativeObject(), n));
    }

    private Expr[] unpackObjectiveValueVector(long l) {
        ASTVector aSTVector = new ASTVector(this.getContext(), l);
        return new Expr[]{(Expr)aSTVector.get(0), (Expr)aSTVector.get(1), (Expr)aSTVector.get(2)};
    }

    public String getReasonUnknown() {
        return Native.optimizeGetReasonUnknown(this.getContext().nCtx(), this.getNativeObject());
    }

    public String toString() {
        return Native.optimizeToString(this.getContext().nCtx(), this.getNativeObject());
    }

    public void fromFile(String string) {
        Native.optimizeFromFile(this.getContext().nCtx(), this.getNativeObject(), string);
    }

    public void fromString(String string) {
        Native.optimizeFromString(this.getContext().nCtx(), this.getNativeObject(), string);
    }

    public Statistics getStatistics() {
        return new Statistics(this.getContext(), Native.optimizeGetStatistics(this.getContext().nCtx(), this.getNativeObject()));
    }

    Optimize(Context context, long l) throws Z3Exception {
        super(context, l);
    }

    Optimize(Context context) throws Z3Exception {
        super(context, Native.mkOptimize(context.nCtx()));
    }

    @Override
    void incRef() {
        Native.optimizeIncRef(this.getContext().nCtx(), this.getNativeObject());
    }

    @Override
    void addToReferenceQueue() {
        this.getContext().getOptimizeDRQ().storeReference(this.getContext(), this);
    }

    public static class Handle {
        private final Optimize opt;
        private final int handle;

        Handle(Optimize optimize, int n) {
            this.opt = optimize;
            this.handle = n;
        }

        public Expr getLower() {
            return this.opt.GetLower(this.handle);
        }

        public Expr getUpper() {
            return this.opt.GetUpper(this.handle);
        }

        public Expr[] getUpperAsVector() {
            return this.opt.GetUpperAsVector(this.handle);
        }

        public Expr[] getLowerAsVector() {
            return this.opt.GetLowerAsVector(this.handle);
        }

        public Expr getValue() {
            return this.getLower();
        }

        public String toString() {
            return this.getValue().toString();
        }
    }
}

