import mongoose from "mongoose";

const DevProjectSchema = new mongoose.Schema(
  {
    title: {
      type: String,
      required: true,
    },
    description: {
      type: String,
      required: true,
    },
    link: {
      type: String,
    },
    technologies: [],
    user: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "Developer",
    },
  },
  {
    timestamps: true,
  }
);

const DevProject = mongoose.model("DevProject", DevProjectSchema);
export default DevProject;
