import mongoose from "mongoose";

const CommentSchema = new mongoose.Schema(
  {
    article: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "Article",
    },
    comment: {
      type: String,
      required: true,
    },
    user: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "Developer",
    },
  },
  {
    timestamps: true,
  }
);

const ArticleComment = mongoose.model("ArticleComment", CommentSchema);

export default ArticleComment;
