#ifndef HZ_UCD_9_0_0_H
#define HZ_UCD_9_0_0_H

#include <stdint.h>

#define HZ_UCD_VERSION HZ_MAKE_VERSION(9,0,0)

typedef enum {
    HZ_JOINING_TYPE_C = 1 << 16,
    HZ_JOINING_TYPE_D = 1 << 17,
    HZ_JOINING_TYPE_L = 1 << 18,
    HZ_JOINING_TYPE_R = 1 << 19,
    HZ_JOINING_TYPE_T = 1 << 20,
    HZ_JOINING_TYPE_U = 1 << 21,
} hz_joining_type_t;

typedef enum {
    HZ_JOINING_GROUP_NONE,
    HZ_JOINING_GROUP_AFRICAN_FEH,
    HZ_JOINING_GROUP_AFRICAN_NOON,
    HZ_JOINING_GROUP_AFRICAN_QAF,
    HZ_JOINING_GROUP_AIN,
    HZ_JOINING_GROUP_ALAPH,
    HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_GROUP_BEH,
    HZ_JOINING_GROUP_BETH,
    HZ_JOINING_GROUP_BURUSHASKI_YEH_BARREE,
    HZ_JOINING_GROUP_DAL,
    HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_GROUP_E,
    HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_GROUP_FE,
    HZ_JOINING_GROUP_FEH,
    HZ_JOINING_GROUP_FINAL_SEMKATH,
    HZ_JOINING_GROUP_GAF,
    HZ_JOINING_GROUP_GAMAL,
    HZ_JOINING_GROUP_HAH,
    HZ_JOINING_GROUP_HE,
    HZ_JOINING_GROUP_HEH,
    HZ_JOINING_GROUP_HEH_GOAL,
    HZ_JOINING_GROUP_HETH,
    HZ_JOINING_GROUP_KAF,
    HZ_JOINING_GROUP_KAPH,
    HZ_JOINING_GROUP_KHAPH,
    HZ_JOINING_GROUP_KNOTTED_HEH,
    HZ_JOINING_GROUP_LAM,
    HZ_JOINING_GROUP_LAMADH,
    HZ_JOINING_GROUP_MANICHAEAN_ALEPH,
    HZ_JOINING_GROUP_MANICHAEAN_AYIN,
    HZ_JOINING_GROUP_MANICHAEAN_BETH,
    HZ_JOINING_GROUP_MANICHAEAN_DALETH,
    HZ_JOINING_GROUP_MANICHAEAN_DHAMEDH,
    HZ_JOINING_GROUP_MANICHAEAN_FIVE,
    HZ_JOINING_GROUP_MANICHAEAN_GIMEL,
    HZ_JOINING_GROUP_MANICHAEAN_HETH,
    HZ_JOINING_GROUP_MANICHAEAN_HUNDRED,
    HZ_JOINING_GROUP_MANICHAEAN_KAPH,
    HZ_JOINING_GROUP_MANICHAEAN_LAMEDH,
    HZ_JOINING_GROUP_MANICHAEAN_MEM,
    HZ_JOINING_GROUP_MANICHAEAN_NUN,
    HZ_JOINING_GROUP_MANICHAEAN_ONE,
    HZ_JOINING_GROUP_MANICHAEAN_PE,
    HZ_JOINING_GROUP_MANICHAEAN_QOPH,
    HZ_JOINING_GROUP_MANICHAEAN_RESH,
    HZ_JOINING_GROUP_MANICHAEAN_SADHE,
    HZ_JOINING_GROUP_MANICHAEAN_SAMEKH,
    HZ_JOINING_GROUP_MANICHAEAN_TAW,
    HZ_JOINING_GROUP_MANICHAEAN_TEN,
    HZ_JOINING_GROUP_MANICHAEAN_TETH,
    HZ_JOINING_GROUP_MANICHAEAN_THAMEDH,
    HZ_JOINING_GROUP_MANICHAEAN_TWENTY,
    HZ_JOINING_GROUP_MANICHAEAN_WAW,
    HZ_JOINING_GROUP_MANICHAEAN_YODH,
    HZ_JOINING_GROUP_MANICHAEAN_ZAYIN,
    HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_GROUP_MIM,
    HZ_JOINING_GROUP_NOON,
    HZ_JOINING_GROUP_NUN,
    HZ_JOINING_GROUP_NYA,
    HZ_JOINING_GROUP_PE,
    HZ_JOINING_GROUP_QAF,
    HZ_JOINING_GROUP_QAPH,
    HZ_JOINING_GROUP_REH,
    HZ_JOINING_GROUP_REVERSED_PE,
    HZ_JOINING_GROUP_ROHINGYA_YEH,
    HZ_JOINING_GROUP_SAD,
    HZ_JOINING_GROUP_SADHE,
    HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_GROUP_SEMKATH,
    HZ_JOINING_GROUP_SHIN,
    HZ_JOINING_GROUP_STRAIGHT_WAW,
    HZ_JOINING_GROUP_SWASH_KAF,
    HZ_JOINING_GROUP_SYRIAC_WAW,
    HZ_JOINING_GROUP_TAH,
    HZ_JOINING_GROUP_TAW,
    HZ_JOINING_GROUP_TEH_MARBUTA,
    HZ_JOINING_GROUP_HAMZA_ON_HEH_GOAL,
    HZ_JOINING_GROUP_TETH,
    HZ_JOINING_GROUP_WAW,
    HZ_JOINING_GROUP_YEH,
    HZ_JOINING_GROUP_YEH_BARREE,
    HZ_JOINING_GROUP_YEH_WITH_TAIL,
    HZ_JOINING_GROUP_YUDH,
    HZ_JOINING_GROUP_YUDH_HE,
    HZ_JOINING_GROUP_ZAIN,
    HZ_JOINING_GROUP_ZHAIN,
} hz_joining_group_t;

static int32_t hz_ucd_arabic_joining_k2[601] = {
       0,   0,   0,-583,   1,   0,
       1,  23,   0,-564,   9,-550,
       6,   1,   2,-548,   0,   2,
       0,   0,   1,   2,-527,   0,
       0,   3,   0,   0,   2,   0,
    -512,-498,   0,   0,   2,   0,
    -487,   1,   0,   1,   0,-475,
       2,   0,   0,   1,-464,   2,
       1,   0,   0,   0,-438,   0,
       2,   0,-428,   1,   1,-418,
    -411,   0,   0,   0,   0,-396,
       0,   3,-394,   0,   1,   2,
       1,   2,   1,-371,-345,   0,
       1,-323,   2,   2,   0,   4,
       1,   0,   1,   1,   0,   2,
    -297,   0,   0,   3,   0,   0,
    -278,-274,   1,-268,-264,-262,
    -261,   0,   0,   0,-252,   0,
       0,   2,-238,   2,   5,  16,
       1,   0,-219,   0,   2,   4,
       0,-209,-199,-190,   5,   0,
       1,   2,-176,-175,-163,-160,
       0,   1,   0,   3,   0,   0,
    -129,-126,  13,  14,-108,   0,
      12,   0,   1,   0,   2, -86,
     -80, -74,  23,   0, -70,   0,
       5,   0,   0,   0,   0,   0,
     -17,   0,   6,  -9,   0,   0,
      -2,  -4,   1,   0, -10, -12,
     -13,   2, -20,   0, -24, -27,
       0,   2, -42, -44,   1,   7,
       0,   2,  11,   0,   1, -81,
       0,   0,   0,  25,   0,   6,
    -104,   0,-117,-119,   0,   0,
       1,   0,-138,-144,   0,   0,
    -151,-154,   0,   0,   9,   0,
    -167,-172,-173,   0,   0,-179,
       0,-187,   1,   3,-193,   1,
    -201,-208,   8,   0,   0,-216,
       1,-224,   1,   0,   0,   0,
       0,   0,   0,-258,   1,   5,
       0,   0,   0,   0,   0,   0,
       0,  13,   0,   1,   0,-292,
       2,   1,   0,-301,   0,-308,
    -309,-316,   0,-321,   4,-325,
       0,-336,-338,-344,   1,   0,
    -353,   0,-358,-360,-361,-368,
       9,   0,   0,   0,-388,-393,
       2,   0,-397,   2,-399,   2,
    -407,   0,   3,-416,   8,   2,
       0,   2,   4,   0,   0,   0,
       0,   0,   1,   1,-453,   0,
       0,   0,   3,   4,   0,   0,
    -477,   0,-479,-485,   0,   0,
       1,-492,   2,-503,   0,-508,
       5,-513,-519,   1,   0,   1,
       0,-528,   0,   0,   1,   3,
       0,   7,   0,-558,   0,-561,
      10,-566,   0,-575,   0,   0,
       2,   8,-585,   0,   1,   1,
    -600,   0,  12,-579,   0,   0,
       0,-576,   0,-568,-559,   0,
       0,-557,   0,   1,-537,   0,
       0,-535,   3,   0,   1,-507,
       0,   8,   1,   0,-478,   6,
       0,   0,-473,   3,-460,   0,
    -454,-449,-441,   2,-436,   0,
    -433,-425,   0,   0,   1,   7,
    -387,-376,-372,   0,-357,-347,
    -331,-318,   0,   0,   7,-299,
       2,   5,-275,   0,   5,-273,
       0,-271,   7,   1,   0,-263,
    -255,   0,   0,   1,   4,-250,
       5,   0,   6,   1,   6,-184,
       1,   5,-166,   0,   5,-158,
       0,   0,   0,   1,   0,-149,
       1,-127,   0,   3,   2,   0,
     -99, -88,   0,   1, -83,   0,
      10, -61,  21,   2,   1,   0,
       0,-597,   0,  -7,   0,   4,
     -23, -28, -39, -51,   0, -56,
       0,   0, -64,   0,   0,   0,
       0,   2, -96,-102,   0,   1,
    -134,   4,   2,   0,-150,   0,
       0,   0,-188,   0,   0,-214,
       0,   0,-215,-229,-248,  11,
       0,   1,   0,   2,-254,   0,
    -281,   0,   0,-282,-291,   0,
       0,   3,-298,   0,   0,   0,
       2,   0,-307,   4,   1,   7,
       0,   0,-398,   1,-404,   0,
       0,   0,-408,   1,   0,   0,
       0,   0,   0,   0,   0,   0,
    -430,   0,   0,-451,   0,-452,
       3,-465,-468,-486,   0,   0,
       1,   0,   6,   2,   0,-491,
       0,   0,   0,-520,-524,-525,
       0,   6,   1,-541,-545,   0,
      10,   0,   0,   0,-582,   0,
       1,-591,-595,   0,-423,   0,
       0,
};

static uint32_t hz_ucd_arabic_joining_ucs_codepoints[601] = {
        1658,    2005,  125209,    1875,    2213,    6206,
        6285,    1651,   68324,    6310,    2230,   68321,
        1830,    1595,   68292,    2012,  125217,    1684,
        6213,    1583,    6228,    1609,    1722,    1540,
        1673,    1836,   68488,  125221,    6298,    6236,
        1707,    1879,    6284,   68493,    1679,    1915,
      125193,  125248,    1994,  125214,    1662,    6261,
        1901,    6292,  125243,    2274,   68311,    1914,
        1876,    2131,    6176,  125207,  125196,    1663,
        6280,    6208,    1826,    2023,   68306,    1827,
        2225,    1570,    1719,    2017,    1894,    6214,
      125250,    6305,    1671,    6221,   68298,    1688,
        1698,    2235,   68483,   68317,    1812,    1703,
        2221,    6217,  125190,    1998,    1601,    6178,
      125231,    1695,    6244,    1699,    1823,    6241,
        6154,    1539,    6301,   68521,    6278,    1886,
        6311,    6193,  125230,    2227,    2000,    1581,
        2218,    1897,   68312,    2120,    6282,   68524,
        1870,  125205,    1666,    1918,   68305,    1744,
        6209,    6180,    6188,    6205,    6235,   68320,
      125234,    6187,  125215,    1693,    6281,    6304,
       68303,   68492,    1696,    1607,    1892,    1893,
       68319,    1721,    6303,    1661,    1706,    2127,
        6276,    1736,    1910,  125198,    2135,    1731,
        2117,    1815,    1733,   68527,    1739,  125216,
        1709,    2113,    1538,    6195,   68295,    1885,
        1588,   68308,    2115,  125239,   68302,    8296,
        1577,    1908,   68482,  125194,    1730,    2018,
      125184,   68525,   68484,    1680,    6260,  125213,
        6158,  125225,    2237,    1660,  125189,    1813,
        2208,    1571,    6197,    1835,    2228,    6262,
        1898,    2211,  125211,    1701,    6257,    6258,
        1903,   68481,    1824,    2130,   68307,    1579,
        1882,   68300,    6248,    6233,    1873,    1883,
        6194,    1686,    2015,    1665,   68480,   68494,
        6190,    6202,    1656,    2214,    1668,    1757,
        1907,    2215,    6212,  125195,    1681,    1728,
      125244,    6246,  125224,    1817,    1578,    6196,
      125202,    2223,    1741,    1708,  125204,    1895,
        1602,    1592,   68299,    2234,    1574,    2220,
        1694,   68495,    1587,   68489,    1749,  125247,
      125240,  125201,    1737,    6199,   68335,    1569,
        2025,    2129,    1606,    1745,    1811,    1652,
        2024,    1889,    1819,    1726,    1884,    1888,
        6222,  125235,    6286,    1597,    6263,    2231,
        1575,   68301,    2010,    2123,    2026,    1713,
        1593,   68523,    2014,    1582,   68490,    1657,
        1786,    6230,    1586,  125251,    2008,    1697,
        1838,    2232,    1832,   68313,    1911,    1649,
       68526,  125186,    1734,    2212,  125241,    2112,
        2226,    6302,  125218,    1997,    1572,    6312,
      125233,    1580,    1816,  125222,    1995,   68322,
        1599,   68522,    2011,    6179,    6307,    1664,
        2217,   68486,    1874,    1814,    1740,   68310,
        1887,    1690,    1788,    2136,    6203,    1720,
        2125,    2021,    6243,    1675,  125203,    6250,
        1871,    6274,    1541,    6192,    1547,    1881,
      125187,    1775,    2006,    2009,    1676,   68289,
        1899,    6239,    1674,   68331,    1999,    2013,
        1810,    6177,    6234,    1825,    6240,    1646,
        6273,    1729,    1537,    6215,    6295,    6227,
        2210,    6249,    1700,    1600,    1672,    6183,
       68293,    6293,    1917,    2019,    2119,   68297,
       68288,  125199,    1677,    1735,    6314,   68294,
        2128,    6224,    1890,    1724,    1590,    1650,
        2209,    6200,    1605,   68323,    1594,    1833,
        1913,    1732,  125212,    1670,    2020,    6198,
      125237,    1682,    6275,    1996,    1742,    6288,
        2118,  125232,    6242,  125245,    6238,    1717,
        1831,    1568,    1820,   68296,  125236,  125238,
      125246,    2219,    6220,    1808,    1869,    1683,
        1654,    1573,    6300,    1747,    6182,    6294,
        6272,    1710,   68314,    6181,    1872,   68304,
        1598,    6189,    1653,    8297,    2224,    1715,
        1608,    1702,    1603,  125208,    1877,    1655,
        1906,    6207,    6185,    1828,    1822,    6299,
        6259,    1896,    6297,    6186,    2114,    2004,
        6277,    6211,    1818,    1689,    1687,    1746,
        2133,    1610,    6287,    1596,    1536,    2003,
        6283,  125210,  125223,    1544,    6150,    2042,
        6231,  125227,    1584,    6223,    6204,    1909,
        2022,    1589,    1904,    6289,    1678,    2002,
        6306,   68487,    1743,   68497,    6216,   68318,
        8205,    6219,    1727,  125242,    1723,   68316,
        1591,    2016,    2134,    6245,    1787,    1791,
        6210,    6308,    6201,    6225,    2132,    1839,
      125229,    6151,  125220,   68334,    1704,   68291,
        1829,    1912,    1837,    1714,    6309,    1718,
      125226,   68309,    2001,   68290,    1659,    1585,
        2222,   68332,    2126,  125219,    6191,    1878,
        6256,    6291,    1692,    1905,    1711,    1821,
        6255,    6253,    2216,  125188,    6251,    1774,
        6290,  125191,    1576,   68333,    1647,    1880,
        6226,   68496,    6279,    2236,    6247,    1667,
        1604,    2007,    1902,    6237,    1685,    1691,
        1834,  125249,    2124,   68315,    1900,    1712,
        1725,  125192,    1916,    1705,    2121,    6184,
        2233,  125228,  125197,    2122,  125200,    1738,
        6254,    6229,    6296,  125206,    1919,  125185,
        1716,    6218,    2116,    6232,    1891,    1669,
        6252,
};

static uint32_t hz_ucd_arabic_joining_data[601] = {
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_TAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_RESH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_PE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_GIMEL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BURUSHASKI_YEH_BARREE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_L | HZ_JOINING_GROUP_MANICHAEAN_NUN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BURUSHASKI_YEH_BARREE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NUN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_KAPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEMKATH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_STRAIGHT_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_ZAYIN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AFRICAN_FEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_SADHE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAMAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_C | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_T | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_SAMEKH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KHAPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_KAPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_QOPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_YODH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_QOPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SWASH_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TEH_MARBUTA_GOAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_HE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_DHAMEDH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_TETH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TEH_MARBUTA,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HEH_GOAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AFRICAN_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SHIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAMADH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_LAMEDH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TEH_MARBUTA,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ZAIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_YEH_WITH_TAIL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TAH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ROHINGYA_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TEH_MARBUTA,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_HUNDRED,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAMAL,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KNOTTED_HEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_L | HZ_JOINING_GROUP_MANICHAEAN_HETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAMAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_SADHE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_AYIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_SYRIAC_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_MEM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_BETH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_ONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MIM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HEH_GOAL,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_C | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_DALETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_ZAYIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_ALEPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAPH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_REVERSED_PE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TETH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALAPH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ZHAIN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_YEH_BARREE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_AYIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_KAPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FINAL_SEMKATH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_YUDH_HE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_T | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HETH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_YEH_BARREE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_C | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_QOPH,
    HZ_JOINING_TYPE_C | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_PE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KNOTTED_HEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_TWENTY,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_GIMEL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_E,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_THAMEDH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_BETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_FIVE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YUDH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_TEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AFRICAN_QAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_PE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NYA,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
};

#endif /* HZ_UCD_9_0_0_H */