#ifndef HZ_UCD_8_0_0_H
#define HZ_UCD_8_0_0_H

#include <stdint.h>

#define HZ_UCD_VERSION HZ_MAKE_VERSION(8,0,0)

typedef enum {
    HZ_JOINING_TYPE_C = 1 << 16,
    HZ_JOINING_TYPE_D = 1 << 17,
    HZ_JOINING_TYPE_L = 1 << 18,
    HZ_JOINING_TYPE_R = 1 << 19,
    HZ_JOINING_TYPE_T = 1 << 20,
    HZ_JOINING_TYPE_U = 1 << 21,
} hz_joining_type_t;

typedef enum {
    HZ_JOINING_GROUP_NONE,
    HZ_JOINING_GROUP_AIN,
    HZ_JOINING_GROUP_ALAPH,
    HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_GROUP_BEH,
    HZ_JOINING_GROUP_BETH,
    HZ_JOINING_GROUP_BURUSHASKI_YEH_BARREE,
    HZ_JOINING_GROUP_DAL,
    HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_GROUP_E,
    HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_GROUP_FE,
    HZ_JOINING_GROUP_FEH,
    HZ_JOINING_GROUP_FINAL_SEMKATH,
    HZ_JOINING_GROUP_GAF,
    HZ_JOINING_GROUP_GAMAL,
    HZ_JOINING_GROUP_HAH,
    HZ_JOINING_GROUP_HE,
    HZ_JOINING_GROUP_HEH,
    HZ_JOINING_GROUP_HEH_GOAL,
    HZ_JOINING_GROUP_HETH,
    HZ_JOINING_GROUP_KAF,
    HZ_JOINING_GROUP_KAPH,
    HZ_JOINING_GROUP_KHAPH,
    HZ_JOINING_GROUP_KNOTTED_HEH,
    HZ_JOINING_GROUP_LAM,
    HZ_JOINING_GROUP_LAMADH,
    HZ_JOINING_GROUP_MANICHAEAN_ALEPH,
    HZ_JOINING_GROUP_MANICHAEAN_AYIN,
    HZ_JOINING_GROUP_MANICHAEAN_BETH,
    HZ_JOINING_GROUP_MANICHAEAN_DALETH,
    HZ_JOINING_GROUP_MANICHAEAN_DHAMEDH,
    HZ_JOINING_GROUP_MANICHAEAN_FIVE,
    HZ_JOINING_GROUP_MANICHAEAN_GIMEL,
    HZ_JOINING_GROUP_MANICHAEAN_HETH,
    HZ_JOINING_GROUP_MANICHAEAN_HUNDRED,
    HZ_JOINING_GROUP_MANICHAEAN_KAPH,
    HZ_JOINING_GROUP_MANICHAEAN_LAMEDH,
    HZ_JOINING_GROUP_MANICHAEAN_MEM,
    HZ_JOINING_GROUP_MANICHAEAN_NUN,
    HZ_JOINING_GROUP_MANICHAEAN_ONE,
    HZ_JOINING_GROUP_MANICHAEAN_PE,
    HZ_JOINING_GROUP_MANICHAEAN_QOPH,
    HZ_JOINING_GROUP_MANICHAEAN_RESH,
    HZ_JOINING_GROUP_MANICHAEAN_SADHE,
    HZ_JOINING_GROUP_MANICHAEAN_SAMEKH,
    HZ_JOINING_GROUP_MANICHAEAN_TAW,
    HZ_JOINING_GROUP_MANICHAEAN_TEN,
    HZ_JOINING_GROUP_MANICHAEAN_TETH,
    HZ_JOINING_GROUP_MANICHAEAN_THAMEDH,
    HZ_JOINING_GROUP_MANICHAEAN_TWENTY,
    HZ_JOINING_GROUP_MANICHAEAN_WAW,
    HZ_JOINING_GROUP_MANICHAEAN_YODH,
    HZ_JOINING_GROUP_MANICHAEAN_ZAYIN,
    HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_GROUP_MIM,
    HZ_JOINING_GROUP_NOON,
    HZ_JOINING_GROUP_NUN,
    HZ_JOINING_GROUP_NYA,
    HZ_JOINING_GROUP_PE,
    HZ_JOINING_GROUP_QAF,
    HZ_JOINING_GROUP_QAPH,
    HZ_JOINING_GROUP_REH,
    HZ_JOINING_GROUP_REVERSED_PE,
    HZ_JOINING_GROUP_ROHINGYA_YEH,
    HZ_JOINING_GROUP_SAD,
    HZ_JOINING_GROUP_SADHE,
    HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_GROUP_SEMKATH,
    HZ_JOINING_GROUP_SHIN,
    HZ_JOINING_GROUP_STRAIGHT_WAW,
    HZ_JOINING_GROUP_SWASH_KAF,
    HZ_JOINING_GROUP_SYRIAC_WAW,
    HZ_JOINING_GROUP_TAH,
    HZ_JOINING_GROUP_TAW,
    HZ_JOINING_GROUP_TEH_MARBUTA,
    HZ_JOINING_GROUP_HAMZA_ON_HEH_GOAL,
    HZ_JOINING_GROUP_TETH,
    HZ_JOINING_GROUP_WAW,
    HZ_JOINING_GROUP_YEH,
    HZ_JOINING_GROUP_YEH_BARREE,
    HZ_JOINING_GROUP_YEH_WITH_TAIL,
    HZ_JOINING_GROUP_YUDH,
    HZ_JOINING_GROUP_YUDH_HE,
    HZ_JOINING_GROUP_ZAIN,
    HZ_JOINING_GROUP_ZHAIN,
} hz_joining_group_t;

static int32_t hz_ucd_arabic_joining_k2[524] = {
       0,   1,-509,-496,   4,   0,
       6,-484,   1,   2,   0,   5,
       0,   0,-470,   0,-467,   0,
    -456,   0,-451,   0,   0,   3,
    -438,-435,   4,-433,   1,   1,
       0,-424,-406,   0,-370,   2,
       0,-363,   1,-362,-359,   0,
    -355,-346,   0,   0,   0,-330,
    -326,   0,-321,   3,-305,   0,
       1,   2,-304,-300,   0,-292,
       1,   0,   0,-281,   0,-277,
    -274,-255,   1,   2,-247,   1,
    -246,-245,   1,-235,   3,   0,
       0,   0,   8,   0,   1,   0,
       0,-205,   1,-196,-191,   1,
       0,   0,-180,-172,   1,   4,
       1,   0,-170,   2,-142,   0,
       0,-121,-118,   0,   0,   4,
     -93,   0,   0,   9, -83,   0,
       1, -74,   3,   0, -63,   0,
     -60,   2, -56, -51,   0,   0,
       2,   0, -28, -24,   0,   1,
     -10,   0,   4,  -9,  -4,   0,
       1,   8,   0,   0, -13,   0,
       0,   1,   6,   0,   1,   0,
     -42,   0, -45, -50,   6,   0,
       0, -59,   0,   0,   0, -65,
     -67,   1,   0, -75, -78,   0,
       2,   0,   3, -91,   9,   0,
       0,   0,   1,-122,   0,   1,
       0,-131,-132,-137,   0,   0,
       0,   0,-157,   0,-164,   0,
       1,   0,-174,-176,-177,   0,
       1,-192,-194,   0,   0,   1,
       0,-212,-215,   4,   0,-222,
       0,   0,   0,   2,-237,-241,
       2,   0,   1,-248,-249,-250,
    -252,-253,   1,-257,   0,-265,
    -267,-271,   5,   0,   0,   0,
       0,   0,   0,   1,   0,-298,
    -299,   6,-301,   0,   0,   2,
       0,   0,-320,   0,-322,   1,
       1,   0,   2,-333,   3,-335,
    -339,   0,-349,-514,   0,-358,
       1,   0,   1,   0,   0,   1,
    -374,-380,-382,-383,-384,-393,
    -395,   2,   3,-413,-414,   0,
       0,   8,   0,   0,   0,-432,
       2,   0,   0,-439,   0,   3,
    -445,-447,   0,   0,   1,-452,
       2,   2,-458,   2,   0,   2,
       0,   0,-478,-479,   9,  11,
       0,   0,-497,-498,   0,-507,
    -508,   0,   2,-515,   0,-521,
    -523,-524,-517,   2,   0,   0,
       0,   0,-503,   1,-489,   0,
       2,   1,   0,   2,-450,-449,
    -441,   0,   4,   1,   1,-430,
       0,-426,-422,-417,   0,   1,
       1,-360,   1,   1,   0,   0,
       0,   0,   0,-328,   3,-319,
    -316,   0,   1,-303,   0,   3,
       0,-291,   1,   1,   0,-280,
    -279,   0,   1,   0,-259,   0,
       3,   0,-233,-232,   0,-228,
       3,   6,   0,-204,   1,   1,
    -173,   3,   0,-159,   0,-153,
    -147,   0,   3,   0,   0,-140,
    -128,   0,   1,   0,   0,   0,
      12,   0,   0,   0,   2,   2,
     -84, -79,   0,   6,   1,   1,
      13, -58,   0,   0,   0,   7,
       0,   7, -34, -29, -23,   0,
       0, -20, -11,   0,   1,  -2,
       0,   0,   1,   3,   8, -30,
     -44,   0, -61,   0, -68,   9,
       0, -87,   0,   5, -98,-104,
    -124,-125,   0,   1,   0,   0,
       2,   0,   0,   0,   1,   0,
       1,   0,   0,   1,   0,   3,
       0,   0,-206,-220,-221,   1,
       0,   0,   0,   0,   0,   0,
    -282,   0,   0,   2,-296,   0,
       6,-324,   1,   3,   0,-334,
       4,   0,-369,   0,-401,   0,
    -431,-444,   3,-455,-460,-468,
       5,-473,   0,   0,   3,-485,
    -351,   0,
};

static uint32_t hz_ucd_arabic_joining_ucs_codepoints[524] = {
        6312,    1870,    1724,    1590,    1651,    1757,
       68293,    1571,    2118,    1540,    6286,    2015,
       68308,    1892,    1818,   68310,    6278,    6239,
        2017,    6252,    6304,    1894,    1917,    6194,
        6275,   68322,   68305,    2023,    1699,   68292,
        1883,    1609,    6215,    6276,    6292,    2222,
        1650,    2120,    1811,    1715,    1827,    1869,
       68527,    1583,    1899,    1997,    2026,    1914,
        1578,    1593,    1775,    1909,    6237,    1657,
        1915,    2020,    1908,    1898,    1707,    6305,
        6240,    1705,    2022,    1743,   68489,    1706,
        1720,    6302,    8296,    1736,    2220,    1826,
        6184,    2126,    1675,    6226,    2002,    1686,
        6272,    1913,   68306,    1838,    1717,    1725,
        2116,    2113,    2013,    1746,    6224,    1829,
        1787,    1674,    1723,    1610,    1998,    6177,
        6189,    1839,   68486,   68291,    1598,    6290,
        6225,    1668,   68523,    6245,    2122,    1786,
        6223,    1664,    6151,    1878,    2129,    6227,
        1916,    1877,    2210,    1875,    6254,    1810,
        6211,   68324,   68290,    6183,   68315,    1820,
        6204,   68314,    1684,    1774,    1654,    6289,
       68295,   68320,    6306,    6154,    6220,    1999,
        6199,    1719,    1589,    2223,    6238,    6298,
        1747,    1680,    1732,    1718,   68289,    1695,
        6233,    2227,    2214,    6296,    6202,    2218,
        1712,   68288,    2135,    6192,   68495,    6285,
        1685,    1700,    6208,    6257,    6229,    2216,
        1671,    2212,    1592,   68521,    1871,    2007,
        2213,    1733,   68309,    1597,    6228,    1647,
        6178,    6197,    2217,    1745,    1692,    1834,
        1697,   68333,    1687,    6249,   68335,    2130,
        1709,    1568,    6186,   68312,    2005,    1599,
        1819,    6195,    6205,    1872,    6274,    2117,
        1739,    2000,    1544,    2025,    1662,    1653,
        6179,    1591,    1884,   68307,    1918,    2003,
        1735,    1833,    1876,    6260,    1694,    2006,
       68487,    2018,    1882,    1594,    1885,    1661,
        6235,    1823,   68332,    1828,    1574,   68301,
        2114,    1701,    6207,    1711,    2127,    6279,
       68497,    1808,    1710,    1727,   68321,    1896,
        1721,    6201,   68298,    1817,   68302,    2221,
        6281,    6230,    6273,    2215,    2123,    1726,
        6300,    1815,   68311,    1890,    1729,    1608,
        2112,    6221,    1602,   68331,   68323,    6193,
        1825,    1584,    6187,    1603,    6297,    1669,
        1601,    1887,    6198,    1744,    2219,    6158,
        1742,    1596,    1813,   68313,    1582,    6284,
        6262,    6203,    1893,    6258,    1901,   68334,
        1886,    1714,    6214,    2209,    1738,    6247,
        6314,    1879,    6287,    1659,    6307,    1690,
        1693,    6190,    1677,    1728,    1788,    1573,
        6251,    1716,    6309,    1681,    1713,    6216,
        6288,    1667,    6217,    2012,    6212,   68490,
       68494,    1907,    2211,    2119,    1702,   68480,
        1682,    2014,   68319,   68294,    1676,    6236,
        1910,    6280,    6206,    1722,    1537,    6261,
        1579,    1570,   68297,    1734,    2021,    2016,
        2131,    1731,   68318,    2115,    6310,   68493,
        1536,    6263,    1912,    1741,    6291,    2001,
       68296,    1737,    2132,    1595,   68299,    1836,
        6231,    2011,    1580,   68525,    1585,   68526,
        1902,    6180,    2004,    1835,    1541,    1740,
        6255,    1830,    1821,    2226,    1600,    6241,
        2121,    1906,    6181,    6200,   68488,    6311,
        6293,    1658,    6219,   68483,    6250,    1703,
        1660,    2042,    6222,    2024,    6248,    1646,
        1652,    1994,    6282,    1604,    1663,    1655,
        6210,    1995,    1873,    1895,    1683,    8205,
        1897,    6209,    1880,    6277,    1666,    1678,
        1665,    6283,    1919,    1673,    1881,    2136,
       68492,    2125,    1576,    1832,    2010,    6196,
        1689,    6295,    6308,    2133,    1688,    6213,
        1730,    6218,   68300,    1814,    6253,    6259,
        6256,    2124,    1696,    6234,    2019,    1831,
        1837,    1911,    2208,    6150,    1822,    2008,
        1691,    6244,    1577,    1698,   68481,    1874,
        1547,    6182,    6191,   68316,    1672,   68522,
        1903,    1572,   68304,    1905,    1891,   68484,
        1538,    1679,    6301,    1708,    1816,    1606,
        1996,    1605,    1749,    1704,    2225,    2228,
        1791,    1581,    2009,   68482,    2224,    2128,
        6299,    6188,    6242,    1889,    1649,    1607,
        8297,    6246,    2134,    1824,    1587,    1575,
        6185,    1588,    6294,    6232,    1670,    1539,
        1586,   68496,    1656,   68317,    1812,    6243,
        1904,   68524,    6176,   68303,    6303,    1888,
        1900,    1569,
};

static uint32_t hz_ucd_arabic_joining_data[524] = {
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KHAPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_DALETH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_DHAMEDH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_MEM,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_KAPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_GIMEL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAMAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEMKATH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ZHAIN,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BURUSHASKI_YEH_BARREE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BURUSHASKI_YEH_BARREE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SWASH_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ROHINGYA_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NUN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_KAPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAMAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NYA,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_YEH_BARREE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_E,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_GIMEL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_TAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_BETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_PE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_AYIN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_QOPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_C | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_YEH_BARREE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_BETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_ALEPH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TAH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_THAMEDH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_TEN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_HUNDRED,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_SAMEKH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_LAMEDH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_FIVE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FINAL_SEMKATH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_L | HZ_JOINING_GROUP_MANICHAEAN_HETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALAPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_RESH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_ZAYIN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ZAIN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_TETH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KNOTTED_HEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_HE,
    HZ_JOINING_TYPE_L | HZ_JOINING_GROUP_MANICHAEAN_NUN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HEH_GOAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_ONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MIM,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_AYIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_TWENTY,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TEH_MARBUTA,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TAH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_QOPH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_ZAYIN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TEH_MARBUTA_GOAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_QOPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_YEH_WITH_TAIL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SHIN,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_PE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YUDH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_C | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_C | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_C | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_SADHE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HEH_GOAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_REVERSED_PE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_YUDH_HE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TEH_MARBUTA,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_PE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_KAPH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_SYRIAC_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TEH_MARBUTA,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_STRAIGHT_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KNOTTED_HEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HEH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAMADH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_SADHE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAMAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_YODH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
};

#endif /* HZ_UCD_8_0_0_H */