#ifndef HZ_UCD_7_0_0_H
#define HZ_UCD_7_0_0_H

#include <stdint.h>

#define HZ_UCD_VERSION HZ_MAKE_VERSION(7,0,0)

typedef enum {
    HZ_JOINING_TYPE_C = 1 << 16,
    HZ_JOINING_TYPE_D = 1 << 17,
    HZ_JOINING_TYPE_L = 1 << 18,
    HZ_JOINING_TYPE_R = 1 << 19,
    HZ_JOINING_TYPE_T = 1 << 20,
    HZ_JOINING_TYPE_U = 1 << 21,
} hz_joining_type_t;

typedef enum {
    HZ_JOINING_GROUP_NONE,
    HZ_JOINING_GROUP_AIN,
    HZ_JOINING_GROUP_ALAPH,
    HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_GROUP_BEH,
    HZ_JOINING_GROUP_BETH,
    HZ_JOINING_GROUP_BURUSHASKI_YEH_BARREE,
    HZ_JOINING_GROUP_DAL,
    HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_GROUP_E,
    HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_GROUP_FE,
    HZ_JOINING_GROUP_FEH,
    HZ_JOINING_GROUP_FINAL_SEMKATH,
    HZ_JOINING_GROUP_GAF,
    HZ_JOINING_GROUP_GAMAL,
    HZ_JOINING_GROUP_HAH,
    HZ_JOINING_GROUP_HE,
    HZ_JOINING_GROUP_HEH,
    HZ_JOINING_GROUP_HEH_GOAL,
    HZ_JOINING_GROUP_HETH,
    HZ_JOINING_GROUP_KAF,
    HZ_JOINING_GROUP_KAPH,
    HZ_JOINING_GROUP_KHAPH,
    HZ_JOINING_GROUP_KNOTTED_HEH,
    HZ_JOINING_GROUP_LAM,
    HZ_JOINING_GROUP_LAMADH,
    HZ_JOINING_GROUP_MANICHAEAN_ALEPH,
    HZ_JOINING_GROUP_MANICHAEAN_AYIN,
    HZ_JOINING_GROUP_MANICHAEAN_BETH,
    HZ_JOINING_GROUP_MANICHAEAN_DALETH,
    HZ_JOINING_GROUP_MANICHAEAN_DHAMEDH,
    HZ_JOINING_GROUP_MANICHAEAN_FIVE,
    HZ_JOINING_GROUP_MANICHAEAN_GIMEL,
    HZ_JOINING_GROUP_MANICHAEAN_HETH,
    HZ_JOINING_GROUP_MANICHAEAN_HUNDRED,
    HZ_JOINING_GROUP_MANICHAEAN_KAPH,
    HZ_JOINING_GROUP_MANICHAEAN_LAMEDH,
    HZ_JOINING_GROUP_MANICHAEAN_MEM,
    HZ_JOINING_GROUP_MANICHAEAN_NUN,
    HZ_JOINING_GROUP_MANICHAEAN_ONE,
    HZ_JOINING_GROUP_MANICHAEAN_PE,
    HZ_JOINING_GROUP_MANICHAEAN_QOPH,
    HZ_JOINING_GROUP_MANICHAEAN_RESH,
    HZ_JOINING_GROUP_MANICHAEAN_SADHE,
    HZ_JOINING_GROUP_MANICHAEAN_SAMEKH,
    HZ_JOINING_GROUP_MANICHAEAN_TAW,
    HZ_JOINING_GROUP_MANICHAEAN_TEN,
    HZ_JOINING_GROUP_MANICHAEAN_TETH,
    HZ_JOINING_GROUP_MANICHAEAN_THAMEDH,
    HZ_JOINING_GROUP_MANICHAEAN_TWENTY,
    HZ_JOINING_GROUP_MANICHAEAN_WAW,
    HZ_JOINING_GROUP_MANICHAEAN_YODH,
    HZ_JOINING_GROUP_MANICHAEAN_ZAYIN,
    HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_GROUP_MIM,
    HZ_JOINING_GROUP_NOON,
    HZ_JOINING_GROUP_NUN,
    HZ_JOINING_GROUP_NYA,
    HZ_JOINING_GROUP_PE,
    HZ_JOINING_GROUP_QAF,
    HZ_JOINING_GROUP_QAPH,
    HZ_JOINING_GROUP_REH,
    HZ_JOINING_GROUP_REVERSED_PE,
    HZ_JOINING_GROUP_ROHINGYA_YEH,
    HZ_JOINING_GROUP_SAD,
    HZ_JOINING_GROUP_SADHE,
    HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_GROUP_SEMKATH,
    HZ_JOINING_GROUP_SHIN,
    HZ_JOINING_GROUP_STRAIGHT_WAW,
    HZ_JOINING_GROUP_SWASH_KAF,
    HZ_JOINING_GROUP_SYRIAC_WAW,
    HZ_JOINING_GROUP_TAH,
    HZ_JOINING_GROUP_TAW,
    HZ_JOINING_GROUP_TEH_MARBUTA,
    HZ_JOINING_GROUP_HAMZA_ON_HEH_GOAL,
    HZ_JOINING_GROUP_TETH,
    HZ_JOINING_GROUP_WAW,
    HZ_JOINING_GROUP_YEH,
    HZ_JOINING_GROUP_YEH_BARREE,
    HZ_JOINING_GROUP_YEH_WITH_TAIL,
    HZ_JOINING_GROUP_YUDH,
    HZ_JOINING_GROUP_YUDH_HE,
    HZ_JOINING_GROUP_ZAIN,
    HZ_JOINING_GROUP_ZHAIN,
} hz_joining_group_t;

static int32_t hz_ucd_arabic_joining_k2[522] = {
       3,   0,   0,-498,   0,-490,
       0,   0,   0,-479,-469,   0,
       0,   0,   0,   1,   0,   1,
    -435,-433,   0,   0,   0,   0,
    -382,   0,   0,   0,   2,  11,
       0,   0,   7,   2,   0,   0,
       1,   0,-361,   0,-352,-344,
    -334,-331,-328,   0,-323,-321,
       0,   3,-304,-296,-294,-289,
       3,   3,-282,-251,-246,   1,
       1,-240,   1,-231,   0,   6,
    -224,-217,   0,-213,   0,-207,
    -206,   1,   2,   0,   0,   1,
       3,   0,-199,-196,   0,   1,
       0,   0,   0,   1,   0,-179,
       5,   6,-176,   2,   0,-170,
       1,-163,-158,   5,-152,   1,
       0,   0,   0,   1,-128,-104,
       1,   2, -95,  12,   0, -72,
     -65,   0,   1, -62,   0, -45,
       0, -39, -32,   0, -29,   0,
      16,   0,  34, -20,   0,   0,
       5, -16, -13,  -6,   4,  -4,
       3,   0,  -1,   4,   3,  -8,
       4,   0,   0,   5,   1,   0,
       7,   0,   0,   0,   1, -31,
       0, -36, -37,   0,-507, -46,
     -53,   3,   0, -58,   0,   1,
       1, -73,   0,   0,   3, -92,
     -93,   2, -99,   0,   0,-110,
       0,   0,   0,   2,   0,-135,
       0,-138,   0,   0,-144,   1,
       6,   0,-156,   1,-159,   0,
       2,-169,   1,-171,   2,   3,
    -177,   0,-184,-185,-186,   0,
       4,   1,   8,-194,   5,-197,
       0,   1,   2,   1,   5,   0,
       3,   6,-216,   1,-218,-221,
       0,   0,-234,   0,   1,   4,
       1,-253,   0,-259,   0,-266,
    -268,-278,   0,   0,   1,   0,
       3,   0,-299,-300,-303,   2,
       1,   0,   0,-319,   0,   0,
    -325,   0,   6,-330,   0,   1,
    -337,   0,   0,   0,  10,-353,
       2,-358,   0,-363,-366,   0,
       0,-372,   2,   1,   0,   2,
       0,-385,   1,-394,-398,-403,
    -405,   0,-422,   0,-430,   0,
       0,   0,   1,   0,   5,  11,
    -446,   0,   0,   0,   0,   2,
       0,  12,   0,   0,   0,   0,
       1,   2,   0,   0,-501,   2,
    -505,   4,-510,-511,   0,   0,
       0,   0,-515,   0,   1,-499,
    -492,-491,  11,   0,   0,   0,
       6,-474,   1,   0,-463,-453,
       0,-452,  19,-434,   2,-431,
       0,-423,   0,   0,   0,-411,
       0,   0,   7,   0,   1,-371,
       1,   0,   1,   0,   0,-348,
       0,   0,   2,-342,   3,-326,
       1,   0,   2,-317,   0,-315,
       2,   0,-293,   0,   0,   0,
       0,-285,   0,   2,-264,-254,
       0,-239,   0,   3,   2,-208,
       1,-187,   2,-161,-155,-142,
       0,   0,   0,   0,-139,   4,
    -133,   0,  11,-121,-120,   0,
       2,-103,   0,   0, -81, -77,
       2, -57,   1,   7,   0,   1,
       0, -26,   1,   0,   0, -21,
       2,   0, -14,   1,   0, -19,
      15, -22, -23,   0,   0,   0,
     -30,   0,   1, -56,   0,   0,
       1, -85,-132,   0,   0,-136,
       0,-145,   0,-175,   0,-188,
       2,   0,-190,   2,-192,   0,
       3,   0,-200,-204,   0,   0,
    -209,   0,   3,   0,   2,-308,
       1,-357,   0,-368,-374,   0,
       1,   0,-376,   0,-379,   2,
       0,   2,   0,-380,   0,   0,
       1,   0,-389,   0,   2,   0,
       0,   1,   1,-442,   0,-444,
    -445,-467,   5,   0,-481,   0,
       1,-495,-500,   0,-504,-521,
};

static uint32_t hz_ucd_arabic_joining_ucs_codepoints[522] = {
        1571,    6191,    1712,    1579,    1735,   68321,
        6294,    1680,   68480,    1603,    6249,    2002,
        1572,   68291,    1874,    1683,    6240,    2018,
        6189,    1742,    1745,    6260,    1887,   68333,
        1658,    1675,    1885,    6227,    6290,    2212,
        1678,    6233,    2210,    1997,    1685,   68319,
        6277,    1713,    1573,    6236,    2007,    1909,
       68481,    6256,   68315,    1651,    1916,    1786,
        2123,    6285,    1897,    1662,   68493,    1607,
        2026,    6252,   68521,    6245,    2119,   68289,
       68482,    6275,    1690,    6220,    6242,   68525,
        6225,    1757,    6235,    1585,    1999,    1576,
        1582,    8297,    1654,    1832,    6209,    1667,
        6151,    2000,    2213,    1718,    1892,    6279,
        1707,    1728,    1647,    1670,    6150,   68298,
        6230,    2132,    1598,    1646,    6307,    1605,
        6180,    1995,    1694,    2006,    1610,    1905,
       68294,    6304,    1544,    1872,    1600,    1714,
        1911,    6288,    1696,    1724,    2005,    2042,
       68524,    2025,    2130,    6208,    6246,    6231,
       68320,    6232,    6190,    1734,    2001,    2225,
        2226,    2131,    6281,    6259,    6309,    6154,
        1738,    1839,    1893,    2117,    6312,    1815,
        6257,    1741,    1896,    6201,    1540,    2125,
        1657,    1595,    6243,    2135,    1547,    1917,
       68486,    6206,    1725,    1592,    6181,    1837,
        1536,    1686,    6255,    6158,    8296,    6251,
        1910,    2013,    2015,    2129,    2010,    2118,
       68293,   68306,    2003,    1596,    1606,   68317,
        1591,   68311,    6182,    1704,    2021,    6228,
       68301,    2115,    6297,    1831,    1878,    1659,
       68527,    2112,    6244,    1709,    1688,    1706,
        1826,    1537,    1710,    1880,    6308,    1705,
        6296,    2134,    1900,    1727,    1820,    1569,
        1904,    1539,    6222,    1668,    6241,    2019,
        6306,    6229,    6218,    1671,    1889,    2217,
        6301,    2004,    1666,   68288,    6221,   68489,
        6303,    1811,   68488,    1674,    1589,    1733,
        1679,   68334,    6272,    1994,   68484,    1808,
        1702,    1898,    6292,    1672,    2222,    6239,
        1698,    1835,    1609,    6211,    1871,    1608,
        6300,    1886,    1823,    1907,    6258,    6210,
       68290,    6287,   68494,   68297,   68523,    1877,
        2136,    1692,    1587,    1661,    6280,    2215,
        6223,    1816,    2008,    1677,    2209,    1743,
        1825,    1833,    1998,   68495,    6193,    1890,
        6283,    6186,    1660,    2221,    2219,    1869,
        6203,    8205,    6274,    6305,    6310,    2020,
       68312,    6262,    1578,    2014,    6198,    6207,
       68526,    2216,    1824,    1906,    1568,    1722,
        1821,    1708,    1918,    1574,    1599,    2220,
        1716,    2121,    2024,    6204,   68303,    1665,
        6184,    1577,   68316,    1810,    1813,    1703,
        6282,    1593,    2122,    6234,    1583,    2009,
        1827,    1919,    1699,    1590,    2023,    1915,
        1822,    6314,    1775,    1664,   68332,   68496,
        1663,   68310,    1570,    1817,    2128,    6237,
        1669,    1913,    1875,    1653,    1684,   68322,
        1715,   68522,    1655,    1541,    1739,    6238,
        1719,    2218,    2017,    1744,   68483,    6213,
       68331,    1594,    1691,    1737,    1687,    2127,
        1720,   68295,   68299,    1879,    1588,    6176,
        1723,    2211,    6250,    1695,   68300,    6215,
       68314,    6202,   68296,    6261,    6179,    1814,
        6273,    6187,    1656,    6286,   68309,    1717,
       68492,    1894,    1693,    1903,    1732,    6284,
        6219,   68305,    1901,    2016,    1650,    6177,
        1701,    1649,    6291,    6293,    1538,    6216,
        2124,    2133,   68292,    1689,    2208,   68487,
        1730,    1575,   68324,   68302,    1746,   68313,
       68304,    1791,    6299,    6197,    2114,    6295,
        6311,    1836,    6302,   68335,    1787,    2224,
        6196,    1747,    2223,    1812,    1899,    6263,
        1597,    1914,    6192,    1891,    6212,    1788,
        6183,    2012,    6253,    1700,    1584,    6226,
        1729,    1601,    6247,    1682,    6199,    2022,
        1996,    2113,    2116,    1884,    6254,    6214,
        1736,    6195,    1873,    1870,    1652,    1673,
        1819,    2126,    6289,    2214,    1912,    6278,
        1604,    1697,    1830,    1580,    1838,    2011,
        1681,    1881,    6217,    1726,    1749,   68323,
       68308,    6298,    1902,    6194,   68490,    2120,
        1882,    1908,    1828,    1586,    6185,    1883,
        6205,    1829,    1602,    6276,   68318,    1876,
        6178,   68307,    1721,    6224,    6248,    1834,
        1888,    6188,   68497,    1711,    6200,    1731,
        1818,    1676,    1740,    1774,    1895,    1581,
};

static uint32_t hz_ucd_arabic_joining_data[522] = {
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_RESH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_GIMEL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_TEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_QOPH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_PE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_BETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_SADHE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TEH_MARBUTA,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_ZAYIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_C | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_C | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_QOPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_STRAIGHT_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_C | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_HE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_YEH_WITH_TAIL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NYA,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BETH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_DALETH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_KAPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_SADHE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TAH,
    HZ_JOINING_TYPE_L | HZ_JOINING_GROUP_MANICHAEAN_NUN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_L | HZ_JOINING_GROUP_MANICHAEAN_HETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_REVERSED_PE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SWASH_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NUN,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TETH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_ALEPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAMAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_TWENTY,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALAPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SHIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAPH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_BETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_ZAYIN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_SYRIAC_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MIM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ZHAIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_C | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_SAMEKH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAMADH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YUDH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ROHINGYA_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_YODH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TEH_MARBUTA,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_PE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BETH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEMKATH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BURUSHASKI_YEH_BARREE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_YUDH_HE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_FIVE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_MEM,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ZAIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_ONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_WAW,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TAH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_AYIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_THAMEDH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_KAPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_GIMEL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HEH_GOAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_TAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_TETH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_YEH_BARREE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_AYIN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_KAPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KNOTTED_HEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_MANICHAEAN_HUNDRED,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_YEH_BARREE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAMAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BURUSHASKI_YEH_BARREE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HEH_GOAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KHAPH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_PE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAMAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KNOTTED_HEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TEH_MARBUTA,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_DHAMEDH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FINAL_SEMKATH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_E,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_QOPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MANICHAEAN_LAMEDH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TEH_MARBUTA_GOAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HETH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
};

#endif /* HZ_UCD_7_0_0_H */