#ifndef HZ_UCD_5_2_0_H
#define HZ_UCD_5_2_0_H

#include <stdint.h>

#define HZ_UCD_VERSION HZ_MAKE_VERSION(5,2,0)

typedef enum {
    HZ_JOINING_TYPE_C = 1 << 16,
    HZ_JOINING_TYPE_D = 1 << 17,
    HZ_JOINING_TYPE_L = 1 << 18,
    HZ_JOINING_TYPE_R = 1 << 19,
    HZ_JOINING_TYPE_T = 1 << 20,
    HZ_JOINING_TYPE_U = 1 << 21,
} hz_joining_type_t;

typedef enum {
    HZ_JOINING_GROUP_NONE,
    HZ_JOINING_GROUP_AIN,
    HZ_JOINING_GROUP_ALAPH,
    HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_GROUP_BEH,
    HZ_JOINING_GROUP_BETH,
    HZ_JOINING_GROUP_BURUSHASKI_YEH_BARREE,
    HZ_JOINING_GROUP_DAL,
    HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_GROUP_E,
    HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_GROUP_FE,
    HZ_JOINING_GROUP_FEH,
    HZ_JOINING_GROUP_FINAL_SEMKATH,
    HZ_JOINING_GROUP_GAF,
    HZ_JOINING_GROUP_GAMAL,
    HZ_JOINING_GROUP_HAH,
    HZ_JOINING_GROUP_HAMZA_ON_HEH_GOAL,
    HZ_JOINING_GROUP_HE,
    HZ_JOINING_GROUP_HEH,
    HZ_JOINING_GROUP_HEH_GOAL,
    HZ_JOINING_GROUP_HETH,
    HZ_JOINING_GROUP_KAF,
    HZ_JOINING_GROUP_KAPH,
    HZ_JOINING_GROUP_KHAPH,
    HZ_JOINING_GROUP_KNOTTED_HEH,
    HZ_JOINING_GROUP_LAM,
    HZ_JOINING_GROUP_LAMADH,
    HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_GROUP_MIM,
    HZ_JOINING_GROUP_NOON,
    HZ_JOINING_GROUP_NUN,
    HZ_JOINING_GROUP_NYA,
    HZ_JOINING_GROUP_PE,
    HZ_JOINING_GROUP_QAF,
    HZ_JOINING_GROUP_QAPH,
    HZ_JOINING_GROUP_REH,
    HZ_JOINING_GROUP_REVERSED_PE,
    HZ_JOINING_GROUP_SAD,
    HZ_JOINING_GROUP_SADHE,
    HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_GROUP_SEMKATH,
    HZ_JOINING_GROUP_SHIN,
    HZ_JOINING_GROUP_SWASH_KAF,
    HZ_JOINING_GROUP_SYRIAC_WAW,
    HZ_JOINING_GROUP_TAH,
    HZ_JOINING_GROUP_TAW,
    HZ_JOINING_GROUP_TEH_MARBUTA,
    HZ_JOINING_GROUP_TETH,
    HZ_JOINING_GROUP_WAW,
    HZ_JOINING_GROUP_YEH,
    HZ_JOINING_GROUP_YEH_BARREE,
    HZ_JOINING_GROUP_YEH_WITH_TAIL,
    HZ_JOINING_GROUP_YUDH,
    HZ_JOINING_GROUP_YUDH_HE,
    HZ_JOINING_GROUP_ZAIN,
    HZ_JOINING_GROUP_ZHAIN,
} hz_joining_group_t;

static int32_t hz_ucd_arabic_joining_k2[274] = {
    -272,  -3, -23,   0,   0,   0,
       0,   0, -98,   0,   0,-142,
    -144,   1,   0,-150,   1,   0,
       4,   0,   0,   0,-238,-261,
       0,   3,-263,   1,   1,   0,
       4,   1,-264,   0,-269,-271,
    -265,   0,   4,   0,-256,   0,
    -230,-205,   0,   0,-189,-186,
       0,   3,   0,-154,   7,   1,
       0,   0,-137,   0,   0, -78,
       1,   3,   0,   3, -56,   1,
       0,   1, -29,   0,   0,   3,
       0,   5,  -1,   1,  -9, -11,
     -14,   0,   3,  10, -27, -28,
       2,   0,   1, -38, -42,   0,
       0, -47,   0, -51,   1, -57,
     -58, -59, -61, -62, -66, -68,
     -69,   0,  15,   0,   6,   3,
     -81, -89, -91,   3,-100,   0,
    -105,-110,-112,   0,-116,-118,
       0,   0,-130,   8,-141,   2,
       1,-149,   0,   0,   4,-156,
       0,-158,-161,-162,  13,   0,
      13,   1,   1,   1,-196,   0,
       0,   1,   1,   0,   0,   0,
       0,-225,   0,   0,-229,   2,
    -235,   2,   0,-239,-240,   0,
    -249,   1,   0,-260,   3,   1,
       0,   0,   1,   0,   0,   1,
       2,   0,   0,-267,   1,   0,
       1,   0,   0,   1,   1,   0,
    -262,   0,   0,   0,   1,   1,
    -257,   0,   0,-241,   1,   0,
       0,   0,-236,-228,   1,   0,
       0,   0,   0,-227,-216,-213,
    -212,-206,-202,-201,   0,   4,
       9,   0,-200,-195,-181,   0,
       1,   0,-180,-179,-157,-151,
       0,   1,   0,   2,   2,   2,
       1,   2,   0,-128,-124,-113,
       0,-102,   0,   0,   3, -79,
       0,   0, -76,   2,   0,   0,
     -75, -74,   6, -49,   2,   0,
       0, -44, -43,   1,   7, -36,
     -33,   0, -26,   0,   3,   0,
     -20,   2,   2,   0,
};

static uint32_t hz_ucd_arabic_joining_ucs_codepoints[274] = {
        2011,    1609,    1888,    1747,    1662,    1694,
        1681,    2007,    2012,    1588,    1683,    1918,
        1899,    1732,    1904,    1813,    1578,    1874,
        1666,    1996,    1886,    1725,    1592,    1838,
        1602,    1660,    1839,    1607,    1538,    1569,
        1696,    1787,    1664,    1815,    1587,    2003,
        1877,    1895,    1690,    1685,    1885,    1774,
        1656,    1703,    2026,    2020,    1680,    1668,
        1537,    1713,    1707,    1655,    1574,    1911,
        1720,    1735,    1817,    1717,    1605,    2002,
        1572,    1893,    1723,    1745,    1699,    1810,
        1823,    1882,    1738,    2009,    1898,    1603,
        1536,    1661,    1715,    1594,    2022,    1999,
        1610,    1712,    1900,    1581,    1901,    1995,
        1597,    1580,    8205,    1701,    1739,    1576,
        1684,    1872,    1600,    1647,    1828,    1657,
        1837,    1994,    1743,    1716,    1902,    1595,
        2017,    1598,    1894,    1711,    1702,    1746,
        1719,    1822,    1698,    1736,    1658,    1876,
        1884,    1727,    1897,    1744,    1599,    1726,
        1691,    2018,    1693,    1749,    1820,    1584,
        1737,    1570,    1808,    1583,    1869,    1879,
        1700,    2014,    1908,    1677,    1896,    1679,
        1709,    1824,    1674,    1665,    1891,    1829,
        2021,    1826,    1741,    1721,    2024,    1652,
        1816,    1906,    1834,    1547,    2013,    1579,
        1714,    1913,    1586,    1705,    1786,    1818,
        1835,    1539,    1650,    2006,    1734,    1830,
        1544,    1596,    1892,    1573,    1915,    1585,
        1673,    1878,    1742,    1871,    1601,    1718,
        1724,    1697,    1689,    1914,    1686,    1653,
        2005,    2008,    1997,    2004,    1919,    1819,
        1687,    1672,    1730,    2025,    1775,    1646,
        2023,    1695,    1890,    1682,    1912,    1692,
        1704,    1669,    1733,    1832,    1678,    1654,
        1649,    1811,    1889,    1788,    1608,    2042,
        1998,    1593,    1663,    1708,    2000,    1873,
        1688,    1814,    1881,    1791,    1916,    1757,
        2016,    1917,    2010,    1670,    1659,    1582,
        1875,    1589,    1825,    1729,    1651,    1706,
        1812,    1671,    1740,    1591,    1870,    1903,
        1833,    1676,    1590,    2019,    1880,    1905,
        1909,    1907,    2001,    1710,    1571,    1910,
        1731,    1577,    1675,    1831,    1887,    1821,
        1728,    1667,    1836,    1575,    1827,    1606,
        1722,    1604,    1883,    2015,
};

static uint32_t hz_ucd_arabic_joining_data[274] = {
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_YEH_BARREE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NYA,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAMAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HEH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_HE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ZAIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAPH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_C | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_C | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FINAL_SEMKATH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MEEM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_YEH_BARREE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_YUDH_HE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KNOTTED_HEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TEH_MARBUTA,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TETH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALAPH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ZHAIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAMADH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_E,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NUN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_YEH_WITH_TAIL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_SYRIAC_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HETH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SHIN,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_PE,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BURUSHASKI_YEH_BARREE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BURUSHASKI_YEH_BARREE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TETH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HEH_GOAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_SADHE,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAMAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_WAW,
    HZ_JOINING_TYPE_C | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DALATH_RISH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KNOTTED_HEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_U | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEEN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_BEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_MIM,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HEH_GOAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SWASH_KAF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_GAMAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_TAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KHAPH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_QAPH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SAD,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_KAF,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_FARSI_YEH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_HAMZA_ON_HEH_GOAL,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TEH_MARBUTA,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_DAL,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_REVERSED_PE,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_AIN,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_YUDH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TEH_MARBUTA,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_HAH,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_TAW,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_ALEF,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_SEMKATH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NOON,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_LAM,
    HZ_JOINING_TYPE_R | HZ_JOINING_GROUP_REH,
    HZ_JOINING_TYPE_D | HZ_JOINING_GROUP_NONE,
};

#endif /* HZ_UCD_5_2_0_H */