const char hz_gl4_stencil_kokojima_vertex_shader[] = 
{
    "#version 450 core\n"
    "#extension GL_ARB_separate_shader_objects : enable\n"
    "\n"
    "layout(location = 0) in vec2 v_pos;\n"
    "layout(location = 1) in vec2 v_uv;\n"
    "\n"
    "layout (std140, binding = 0) uniform UboData {\n"
    "    mat4 view_matrix;\n"
    "    float max_sdf_distance;\n"
    "};\n"
    "\n"
    "layout (location = 0) out vec2 uv;\n"
    "\n"
    "void main() {\n"
    "    vec4 ndc = view_matrix * vec4(v_pos,0.0,1.0);\n"
    "    gl_Position = vec4(ndc.xyz,1);\n"
    "    uv = v_uv;\n"
    "}\n"
};
