const char hz_gl4_curve_to_sdf_vertex_shader[] = 
{
    "#version 450 core\n"
    "#extension GL_ARB_separate_shader_objects : enable\n"
    "\n"
    "layout (location = 0) in vec2 v_v1;\n"
    "layout (location = 1) in vec2 v_v2;\n"
    "layout (location = 2) in vec2 v_c1;\n"
    "layout (location = 3) in vec2 v_c2;\n"
    "layout (location = 4) in int v_type;\n"
    "\n"
    "layout (std140, binding = 0) uniform UboData {\n"
    "    mat4 view_matrix;\n"
    "    float max_sdf_distance;\n"
    "};\n"
    "\n"
    "// Exact BBox to a quadratic bezier ( from iq )\n"
    "void bezier2_bbox(in vec2 p0, in vec2 p1, in vec2 p2 , out vec2 mi, out vec2 ma )\n"
    "{\n"
    "    // extremes\n"
    "    mi = min(p0,p2);\n"
    "    ma = max(p0,p2);\n"
    "\n"
    "    // maxima/minima point, if p1 is outside the current bbox/hull\n"
    "    if( p1.x<mi.x || p1.x>ma.x || p1.y<mi.y || p1.y>ma.y )\n"
    "    {\n"
    "        // p = (1-t)^2*p0 + 2(1-t)t*p1 + t^2*p2\n"
    "        // dp/dt = 2(t-1)*p0 + 2(1-2t)*p1 + 2t*p2 = t*(2*p0-4*p1+2*p2) + 2*(p1-p0)\n"
    "        // dp/dt = 0 -> t*(p0-2*p1+p2) = (p0-p1);\n"
    "\n"
    "        vec2 t = clamp((p0-p1)/(p0-2.0*p1+p2),0.0,1.0);\n"
    "        vec2 s = 1.0 - t;\n"
    "        vec2 q = s*s*p0 + 2.0*s*t*p1 + t*t*p2;\n"
    "        \n"
    "        mi = min(mi,q);\n"
    "        ma = max(ma,q);\n"
    "    }\n"
    "}\n"
    "\n"
    "const vec2 quad_vertices[4] = {vec2(0,0),vec2(1,0),vec2(0,1),vec2(1,1)};\n"
    "\n"
    "layout (location = 0) out vec2 f_pixel_coord;\n"
    "layout (location = 1) out flat vec2 f_bezier_v1;\n"
    "layout (location = 2) out flat vec2 f_bezier_v2;\n"
    "layout (location = 3) out flat vec2 f_bezier_c1;\n"
    "layout (location = 4) out flat vec2 f_bezier_c2;\n"
    "layout (location = 5) out flat int f_bezier_type;\n"
    "\n"
    "void main() {\n"
    "    vec2 pos = quad_vertices[gl_VertexID];\n"
    "\n"
    "    switch (v_type) {\n"
    "        default: break;\n"
    "        case 2: { // line\n"
    "            vec2 mi = min(v_v1,v_v2);\n"
    "            vec2 ma = max(v_v1,v_v2);\n"
    "            mi -= max_sdf_distance;\n"
    "            ma += max_sdf_distance;\n"
    "            pos = mi + pos * (ma-mi);//mix(mi,ma,pos);\n"
    "            break;\n"
    "        }\n"
    "\n"
    "        case 3: { // quadratic bezier\n"
    "            vec2 mi,ma;\n"
    "            bezier2_bbox(v_v1,v_c1,v_v2,mi,ma);\n"
    "            mi -= max_sdf_distance;\n"
    "            ma += max_sdf_distance;\n"
    "            pos = mi + pos * (ma-mi);//mix(mi,ma,pos);\n"
    "            break;\n"
    "        }\n"
    "        case 4: { // cubic bezier\n"
    "            break;\n"
    "        }\n"
    "    }\n"
    "\n"
    "    f_pixel_coord = pos;\n"
    "    f_bezier_v1 = v_v1;\n"
    "    f_bezier_v2 = v_v2;\n"
    "    f_bezier_c1 = v_c1;\n"
    "    f_bezier_c2 = v_c2;\n"
    "    f_bezier_type = v_type;\n"
    "\n"
    "    vec4 ndc = view_matrix * vec4(pos,0.0,1.0);\n"
    "    gl_Position = vec4(ndc.xyz,1.0);\n"
    "}\n"
};
