# Simulating a Cyclic Operations Network (CYCLONE) in Unity

I have simulated a CYCLONE in the Simphony Modeling Environment, demonstrating the logical sequences of the different operation scenarios, with the purpose of improving operation's efficiency. 

I have developed this method in Unity, implementing C# programming and VB.NET via Simphony.dll.

<p align="center">
  <img src="https://user-images.githubusercontent.com/64426415/139347727-f6ede3eb-546e-4d1f-8eb5-7b494e5e8ff7.JPG">
</p>

</p>
<p align = "center">
Fig.1 - Schematic of Earthwork Operation
</p>


# 

<p align="center">
  <img src="https://user-images.githubusercontent.com/64426415/138893513-23929452-83f7-4c0f-aea0-f2f91fb10614.jpg">
</p>

</p>
<p align = "center">
Fig.2 - CYCLONE Model of Earthwork Operation
</p>

# Assumption

| # | value |
| ------------- | ------------- |
| Loaders available at the loading area | 1 |
| Spotters available at the dumpsite | 1 |

|       #        | Large Truck | Small Truck |
| ------------- | ------------- | ------------- |
| Hauling to loading area (minutes)  |  15  | 10 |
| Loading (minutes)  | 10 | 5 |
| Hauling to dumpsite (minutes)  | 30 | 20 |
| Dumping (minutes)  | 5 | 3 |

# Result


* Utilizing 2 Trucks

![2 Trucks](https://user-images.githubusercontent.com/64426415/138893492-f7f83d84-5219-4d86-a2a2-5c2d72735844.JPG)

* Utilizing 4 Trucks

![4 Trucks](https://user-images.githubusercontent.com/64426415/138893503-885dadf6-5a00-40f8-86ea-197f85ccf687.JPG)

