# Examples

Prefer to learn by example? Wonderful! The source code for all of the examples on this site can be found in the GitHub repo's [examples](https://github.com/ryan-haskell/elm-spa/tree/main/examples) folder.

### Hello, world!

Get an introduction to the framework with a simple app.

[![Example 1 screenshot](/content/images/01-hello-world.png)](/examples/01-hello-world)

### Pages

Learn how pages and URL routing work together.

[![Example 2 screenshot](/content/images/02-pages.png)](/examples/02-pages)

### Local storage

Use ports and local storage to persist data on refresh.

[![Example 3 screenshot](/content/images/03-storage.png)](/examples/03-storage)

### User authentication

Explore the elm-spa's user authentication API.

[![Example 4 screenshot](/content/images/04-authentication.png)](/examples/04-authentication)

## Real world examples

### elm-css patterns

_Author_: [@bigardone](https://github.com/bigardone)

[![elm-css patterns screenshot](/content/images/community/01-elmcss-patterns.png)](https://elmcsspatterns.io/)

Source code: [GitHub](https://github.com/bigardone/elm-css-patterns)

### RealWorld Conduit App

_Author_: [@ryan-haskell](https://github.com/ryan-haskell)

Implements the [RealWorld app](https://github.com/gothinkster/realworld), inspired by Richard Feldman's "elm-spa-example" project. 

[![Realworld app screenshot](/content/images/realworld.png)](https://realworld.elm-spa.dev)

Source code: [GitHub](https://github.com/ryan-haskell/elm-spa-realworld)

### This website

_Author_: [@ryan-haskell](https://github.com/ryan-haskell)

The website you are looking at _right now_ was built with __elm-spa__. Mindbending, right?

[![Realworld app screenshot](/content/images/this-site.png)](https://elm-spa.dev)

Source code: [GitHub](https://github.com/ryan-haskell/elm-spa/tree/main/docs)

## More examples

There are more examples available on the official repo:

__[Working with NPM 🔗](https://github.com/ryan-haskell/elm-spa/tree/main/examples/05-vite)__

Use [Vite](https://vitejs.dev/) instead of the default __elm-spa server__ command. This gives you access to NPM, reading environment variables, and fancier JS ecosystem stuff.

__[Testing 🔗](https://github.com/ryan-haskell/elm-spa/tree/main/examples/06-testing)__

Use [elm-test](https://github.com/elm-explorations/test) and [elm-program-test](https://elm-program-test.netlify.app/) to write unit and end-to-end tests for your single page application.

__[Using Elm UI 🔗](https://github.com/ryan-haskell/elm-spa/tree/main/examples/07-elm-ui)__

Use the wonderful [elm-ui](https://package.elm-lang.org/packages/mdgriffith/elm-ui/latest) package to create web UIs without the need for HTML or CSS. This example can also be applied to [elm-css](https://package.elm-lang.org/packages/rtfeldman/elm-css/latest/) or any other custom UI of your choice.