/**
 * Author : Ryan
 * Date : 2022-11-20
 * Desc : Privacy components
 */

import styled from 'styled-components';

export default function PrivacyPage() {
  return (
    <Wrapper>
      <HeaderBlock>
        <h1>PROMPTY 서비스 이용약관</h1>
      </HeaderBlock>
      <ContentContainer>
        <Article>
          <Notice>제1장 총칙</Notice>
        </Article>
        <Article>
          <H2>제1조 (목적)</H2>
          <P>
            본 약관은 PROMPTY(이하 “회사”)가 제공하는 인터넷 서비스 및 기타 웹 어플리케이션(이하 “웹
            서비스”)과 관련하여 “회사”와 “이용자”의 권리, 의무 및 책임사항, 기타 필요한 사항을
            규정함을 목적으로 합니다.
          </P>
        </Article>
        <Article>
          <H2>제2조 (용어의 정의)</H2>
          <P>이 약관에서 사용하는 용어의 정의는 다음과 같습니다.</P>
          <OL>
            <li>
              <P>
                1. “PROMPTY”란 ”회사”가 운영하는 어플 및 웹사이트를 포함한 “서비스” 관련 제반
                시스템을 의미합니다.
              </P>
              <P>
                2. “서비스”란 “PROMPTY”의 ”회원”이 웹 서비스를 사용하는 모든 일련의 과정과 이용할 수
                있는 제반 서비스 모두를 의미합니다.
              </P>
              <P>
                3. “이용자”란 “PROMPTY”에 접속하여 “회사”가 제공하는 서비스를 이용하는 자를
                의미하며, “회원”과 “비회원”을 포함합니다.
              </P>
              <P>
                4. “회원”’이라 함은 “회사”에게 회원가입 등의 방법으로 개인정보를 제공하여 회원
                등록한 자로 “회사”가 제공하는 서비스를 계속적으로 이용할 수 있는 자를 말합니다.
              </P>
              <P>
                5. “비회원”이라 함은 “회원”으로 등록을 하지 않고 “회사”가 제공하는 서비스를 이용하는
                자를 말합니다.
              </P>
              <P>
                7. “인증등록회원”이라 함은 “회사”가 정한 소정의 절차를 거쳐서 서비스 계약을 맺은
                회원으로서 “서비스” 제공을 통해 “회원”에게 받은 정보를 바탕으로 상담 서비스 제공을
                할 수 있는 권한을 가진 자를 말합니다.
              </P>
              <P>
                8. “신청회원”이라 함은 “인증등록회원”이 되기 위한 모집절차를 거쳐 심사를 진행하는
                단계의 회원을 말합니다.
              </P>
              <P>
                9. 이 약관에 사용되는 용어 중 본 조에서 정하지 아니한 부분은 관계법령 및 일반 관례에
                따릅니다.
              </P>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>제3조 (약관의 명시와 개정)</H2>
          <OL>
            <li>
              <P>
                1. “회사”는 “이용자”가 본 약관의 내용을 쉽게 알 수 있도록 “회사”가 제공하는
                커뮤니티를 통해 공지합니다. 본 약관에 동의한 “회원” 모두에게 그 효력이 발생합니다.
              </P>
              <P>
                2. “회사”는 약관의 규제에 관한 법률, 정보통신망 이용 촉진 및 정보보호 등에 관한 법률
                등 관련 법령을 위배하지 않는 범위에서 본 약관을 개정할 수 있습니다.
              </P>
              <P>
                3. “회사”는 약관을 개정할 경우에는 적용일자 및 개정사유를 명시하여 “이용자”가 알기
                쉽도록 그 적용일자 7일 이전부터 적용일자 전일까지 공지하며 “이용자”에게 불리하게
                약관내용을 변경하는 경우에는 최소한 30일 이상의 사전 유예기간을 두고 공지합니다.
              </P>
              <P>
                4. “회사”가 약관을 개정할 경우에는 변경된 약관은 공지된 적용일자 시점부터 그 효력이
                발생하며, “이용자”는 약관이 변경된 후에도 본 “서비스”를 계속 이용함으로써 변경 후의
                약관에 대해 동의를 한 것으로 간주됩니다.
              </P>
              <P>
                5. “이용자”는 ”회사”가 개정한 약관에 동의하지 않을 경우 서비스 이용 신청을 취소할 수
                있습니다.
              </P>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>제4조 (약관 및 운영규정 등의 해석)</H2>
          <OL>
            <li>
              <P>
                1. “회사”는 “이용자”와 관련하여 서비스 운영을 위해 별도의 운영규정을 마련하여 운영할
                수 있으며, 사전 공지 후 적용합니다. 운영규정의 내용은 “이용자”가 알 수 있도록 플랫폼
                공지사항을 통해 “이용자”에게 공지하며, 본 약관에 동의한 “이용자” 모두에게 그 효력이
                발생합니다.
              </P>
              <P>
                2. “이용자”의 권리 또는 의무에 중대하거나 불리한 내용의 변경이 있거나 본 약관의
                내용을 변경하는 것과 동일한 효력이 발생하는 운영규정의 변경이 있는 경우에는 제3조
                제3항 내지 제5항의 절차를 따릅니다. 다만 운영규정이 다음 각호의 어느 하나에 해당하는
                경우에는 전항의 방법으로 공지합니다.
              </P>
              <OL2>
                <li>
                  <P2>2-1) “이용자”의 권리 · 의무와 관련 없는 경미한 사항을 변경하는 경우</P2>
                  <P2>
                    2-2) 운영규정의 내용이 본 약관에서 정한 내용과 본질적으로 다르지 않고,
                    “이용자”가 충분히 예측 가능한 범위 내에서 변경하는 경우
                  </P2>
                </li>
              </OL2>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>제5조 (약관 외 준칙)</H2>
          <P>
            본 약관 또는 개별약관에서 정하지 않은 사항은 전기통신사업법, 전자거래기본법,
            정보통신망법, 전자상거래 등에서의 소비자보호에 관한 법률, 개인정보보호법 등 관련 법령의
            규정과 일반적인 상관례에 의합니다.
          </P>
        </Article>
        <Article>
          <Notice>제2장 제공 서비스 및 회원 관리</Notice>
        </Article>
        <Article>
          <H2>제6조 (서비스의 제공 및 변경)</H2>
          <OL>
            <li>
              <P>
                1. “이용자”는 회원가입을 통해 “서비스” 이용 신청을 할 수 있습니다. 다만, “서비스”
                수행을 위해 필요한 정보를 제출하고 약관, 규정, 정책 등에 동의를 해야 합니다.
              </P>
              <P>2. “회사”는 다음과 같은 업무를 수행합니다.</P>
              <OL2>
                <li>
                  <P2>2-1) 서비스 전반에 관한 정보 제공</P2>
                  <P2>2-2) 기타 “회사”가 “이용자”를 위하여 제공하는 서비스</P2>
                  <P2>
                    2-3) “회사”가 제공하는 “회원”과 계약을 체결한 ‘서비스’의 내용을 기술적 사양의
                    변경 등의 사유로 변경할 경우에는, 그 변경이 실질적으로 “회원”’에게 불리할 경우
                    그 사유를 “회원”’에게 통지하거나, “회원”이 알아볼 수 있도록 공지사항으로
                    게시합니다.
                  </P2>
                  <P2>
                    2-4) “회사”는 정보 제공 목적으로 “회원”에게 이메일, 문자메시지, 푸시 알림(App
                    Push) 등을 발송할 수 있습니다.
                  </P2>
                </li>
              </OL2>
              <P>3. “회사”에서 중개하는 “상담 서비스”의 기준을 다음과 같이 정의합니다.</P>
              <OL2>
                <li>
                  <P2>
                    3-1) “상담 서비스”라 함은 ”회원”이 구매하고자 하는 제품의 스펙, 색상 등 정보와
                    가격 문의를 포괄하며, “등록회원”은 해당내용을 토대로 성실하게 상담할 것을
                    원칙으로 합니다.
                  </P2>
                </li>
              </OL2>
              <P>
                4. 사업 종목의 전환, 사업의 포기, 업체 간의 통합, 신규 서비스 개시 등의 이유로
                “서비스”의 내용이 변경되거나 “서비스”가 종료될 수 있습니다. “회사”가 “서비스”를
                제공할 수 없게 되는 경우에 “회사”는 “이용자”에게 문자메시지, 푸시 알림(App Push)
                등을 통해 통지하거나, “이용자”가 알아볼 수 있도록 “서비스”에 공지합니다.
              </P>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>제7조 (서비스 이용 시간 및 중단)</H2>
          <OL>
            <li>
              <P>
                1. “서비스”의 이용은 “회사”의 업무상 또는 기술상 특별한 지장이 없는 한 연중무휴를
                원칙으로 합니다. 다만, 정기점검 등의 필요로 “회사”가 정한 날이나 시간은 제외됩니다.
                정기점검 시간은 서비스 제공 화면에 공지한 바에 따릅니다.
              </P>
              <P>
                2. “회사”는 “서비스”의 원활한 수행을 위하여 필요한 기간을 정하여 사전에 공지하고
                “서비스”를 중지할 수 있습니다. 단, 불가피하게 긴급한 조치를 필요로 하는 경우 사후에
                통지할 수 있습니다.
              </P>
              <P>
                3. “회사”는 컴퓨터 등 정보통신 설비의 보수 점검, 교체 및 고장, 통신의 두절 등의
                사유가 발생한 경우에는 “서비스”의 제공을 일시적으로 중단할 수 있습니다.
              </P>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>제8조 (회원가입 및 회원 정보의 변경)</H2>
          <OL>
            <li>
              <P>
                1. 회원가입은 “회원”이 되고자 하는 자(이하 “가입신청자”라 함)가 약관의 내용에 동의를
                한 다음 “회사”가 정한 절차에 따라 가입신청을 하고, “회사”가 이러한 신청에 대하여
                승낙함으로써 체결됩니다. 회원가입 계약의 성립시기는 “회사”의 승낙이 “회원”에게
                도달한 시점으로 합니다.
              </P>
              <P>
                2. “회사”는 다음 각호에 해당하는 가입신청에 대하여는 승낙을 하지 않거나 사후에 이용
                계약을 해지할 수 있습니다.
              </P>
              <OL>
                <li>
                  <P2>
                    2-1) “가입신청자”가 이 약관에 의하여 이전에 회원자격을 상실한 적이 있는 경우.
                    (단, “회사”의 회원 재가입 승낙을 얻은 경우에는 예외로 함)
                  </P2>
                  <P2>2-2) 허위의 정보를 기재하거나 “회사”가 제시하는 내용을 기재하지 않은 경우</P2>
                  <P2>
                    2-3) “가입신청자”의 귀책 사유로 인하여 승인이 불가능하거나 기타 규정한 제반
                    사항을 위반하며 신청하는 경우
                  </P2>
                </li>
              </OL>
              <P>
                3. 제1항에 따른 신청에 있어 “회사”는 “가입신청자”에게 전문기관을 통한 실명확인 및
                본인인증을 요청할 수 있습니다.
              </P>
              <P>
                4. “회원”은 회원가입 신청 시 기재한 사항이 변경되었을 경우 온라인으로 수정을 하거나
                전자우편주소 또는 기타 방법으로 “회사”에 그 변경사항을 알려야 합니다. 변경사항을
                “회사”에 알리지 않아 발생한 불이익에 대하여 “회사”는 책임지지 않습니다.
              </P>
              <P>
                5. 회원가입은 반드시 본인의 진정한 정보를 통하여만 가입할 수 있으며 “회사”는
                “회원”이 등록한 정보에 대하여 확인 조치를 할 수 있습니다.
              </P>
              <P>
                6. 원칙적으로 “회원”의 ID와 비밀번호에 관한 관리책임은 “회원” 본인에게 있으며,
                “회원”은 자신의 ID 및 비밀번호를 제3자에게 이용하게 해서는 안 되며, 그로 인한 모든
                책임은 “회원”에게 있습니다.
              </P>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>제9조 (회원 탈퇴 및 자격상실)</H2>
          <OL>
            <li>
              <P>
                1. “회원”은 언제든지 “회사”에 “탈퇴”를 요청할 수 있으며, “회사”는 관련법 등이 정하는
                바에 따라 이를 즉시 처리하여야 합니다. 회원 탈퇴로 인해 발생하는 불이익에 대한
                책임은 모두 “회원” 본인에게 있습니다.
              </P>
              <P>
                2. “회원”이 “탈퇴”를 요청할 경우, 관련법 및 개인정보처리방침에 따라 “회사”가
                회원정보를 보유하는 경우를 제외하고는 지체없이 파기 절차를 진행합니다.
              </P>
              <P>
                3. 파기 절차는 고객 요구사항 처리 및 사후관리 목적으로 “탈퇴” 요청 후 30일간
                “회원”의 개인정보를 보유 후 파기되는 절차를 말합니다. 이는 고객의 실수 혹은 변심에
                의해 탈퇴 신청 철회 시 활동 내역 복구, 무분별한 회원 탈퇴 및 재가입으로 인한 부정
                이용 및 피해를 예방하기 위해서 입니다.
              </P>
              <P>
                4. “회원”이 “탈퇴”를 요청하는 경우, “회원”이 작성한 게시물은 사전 요청이 있지 않은
                한 삭제되지 않습니다.
              </P>
              <P>
                5. 제1항에 따라 “탈퇴”를 한 “회원”은 6개월 동안 재가입이 불가능하며, 이후 약관에서
                정하는 회원가입 절차와 관련 조항에 따라 신규 “회원”으로 다시 가입할 수 있습니다.
              </P>
              <P>
                6. “회원”의 운영규정 위반 사실이 확인될 경우 본 이용약관 제10조 5항에 적용을 받으며
                이 경우 “회원”에게 이를 통지하고 소명할 기회를 부여합니다.
              </P>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>제10조 (“회원”의 의무)</H2>
          <OL>
            <li>
              <P>
                1. “회원”은 관계법령 및 본 약관과 “회사”의 운영규정 및 정책 등 “회사”가 통지 또는
                공지하는 사항을 준수해야 하며, 기타 “회사” 업무에 방해되는 행위를 하여서는 안
                됩니다.
              </P>
              <P>
                2. “회원”이 입력한 정보는 진실해야 하며, 만일 허위 또는 기타 부정한 정보를 입력하여
                “회사”에게 피해가 발생할 경우, 그에 대한 모든 책임은 “회원”에게 귀속됩니다.
              </P>
              <P>3. “회원”은 다음 각 호의 사유에 해당하는 행위를 하여서는 안 됩니다.</P>
              <OL2>
                <li>
                  <P2>3-1) “회사”의 정보를 부정하게 취득하는 행위</P2>
                  <P2>
                    3-2) 비방 또는 악의적인 목적을 가지고 욕설 등 인격에 대한 모욕을 하는 경우
                  </P2>
                  <P2>3-3) 사실에 근거하지 않고 부당한 보상을 요구하는 경우</P2>
                  <P2>3-4) “회원”의 개인 정보를 허위 또는 타인의 것으로 등록하는 행위</P2>
                  <P2>
                    3-5) “회사” 홈페이지 또는 어플 해킹 또는 기타 유사한 프로그램 등을 이용하여
                    정상적인 운영을 어렵게 하는 경우
                  </P2>
                  <P2>3-6) “회사”와 상담 시 폭언, 욕설, 성희롱 등의 행위</P2>
                  <P2>3-7) 기타 “회사”의 영업을 부당한 방법으로 방해하는 행위</P2>
                  <P2>3-8) 기타 관련 법령에 위반되는 행위</P2>
                </li>
              </OL2>
              <P>
                4. 제4항에 해당하는 행위를 한 소비자가 있을 경우 “회사”는 다음 각호에서 정한 바에
                따라 회원자격을 제한 및 정지, 상실 시킬 수 있습니다.
              </P>
              <OL2>
                <li>
                  <P2>
                    4-1) “회사”는 회원 자격을 제한 또는 정지시킨 후, 동일한 행위가 2회 이상
                    반복되거나 14일 이내에 그 사유가 시정되지 아니하는 경우 회사는 회원자격을 상실
                    시킬 수 있습니다.
                  </P2>
                  <P2>
                    4-2) “회사”가 회원 자격을 상실시키는 경우에는 즉시 회원등록 기록을 말소하고
                    회원에게 이를 통지하며, 회원등록 말소 전에 소명할 기회를 부여합니다.
                  </P2>
                </li>
              </OL2>
              <P>5. 제4항에 해당할 경우 “회사”는 “회원”에게 손해배상을 청구할 수 있습니다.</P>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>제11조 (회사의 의무와 책임한계)</H2>
          <OL>
            <li>
              <P>
                1. “회사”는 “회원” 간 정보를 주고 받는 커뮤니티 서비스만을 제공할 뿐, 재화 등을
                판매하는 당사자가 아니며, 재화 또는 용역 등에 대한 정보 및 이행여부 등에 대한 책임은
                “회원”에게 있습니다. 다만, “회사”는 신의성실의 원칙에 따라 “회원” 간의 분쟁해결을
                위해 중재, 조정하는 역할을 할 수 있습니다.
              </P>
              <P>
                2. “회사”는 법령과 본 약관이 금지하거나 공서양속에 반하는 행위를 하지 않으며 이
                약관이 정하는 바에 따라 지속적이고, 안정적으로 서비스를 제공하는데 최선을 다하여야
                합니다.
              </P>
              <P>
                3. “회사”는 “회원”이 작성 및 등록 등의 방법으로 “서비스”에 게재된 정보, 자료, 사실의
                신뢰도, 정확성 등에 대해서는 보증을 하지 않으며, 이로 인해 발생한 “회원” 간의
                물리적, 신체적, 정신적, 금전적 등 손해 일체에 대해서는 “회사”가 해당 정보의 허위성을
                명백히 인지하였다는 특별한 사정이 없는 한, 어떠한 도덕적, 법적 책임이나 의무도
                부담하지 않습니다.
              </P>
              <P>
                4. “회원”이 “PROMPTY”에서 추천한 정보를 이용할지 여부는 전적으로 “회원” 스스로의
                판단에 따라 결정하는 것으로 “회사”는 회원이 해당 서비스를 이용하여 발생하는
                직,간접적 문제에 대한 책임을 지지 않습니다.
              </P>
              <P>
                5. “회사”는 “회원”이 “서비스”를 이용하여 기대하는 이익을 얻지 못하거나 상실한 것에
                대하여 책임을 지지 않으며, “회원” 상호 간 및 “회원”과 제3자 상호 간에 “서비스”를
                매개로 발생한 분쟁에 대해 개입할 의무가 없고, 이에 따른 손해를 배상 및 보상하는
                어떠한 도덕적, 법적 책임이나 의무도 부담하지 아니합니다.
              </P>
              <P>
                6. 문자, 푸시 알림(App Push) 등으로 발송되는 모든 정보는 참고 용도로만 사용할 수
                있으며, 시스템 오류, 천재지변 등으로 인하여 알림이 정상적으로 발송되지 않을 수
                있습니다. 이에 관련한 피해에 대해서 “회사”는 책임을 지지 않습니다.
              </P>
              <P>
                7. “회사”는 “회사”의 고의 또는 중대한 과실이 있지 않는 한 다음 호에서 발생하는
                손해배상 및 보상할 어떠한 도덕적, 법적 책임이나 의무도 부담하지 아니합니다.
              </P>
              <OL2>
                <li>
                  <P2>7-1) “회원” 간의 거래 분쟁 및 대금의 문제가 발생한 경우</P2>
                  <P2>
                    7-2) 천재지변 또는 이에 준하는 불가항력으로 인하여 서비스를 제공할 수 없는 경우
                  </P2>
                  <P2>7-3) “회원”의 귀책사유로 인한 서비스 이용의 장애</P2>
                  <P2>
                    7-4) 기간 통신 사업자가 전기통신 서비스를 중지하거나 정상적으로 제공하지
                    아니하여 손해가 발생한 경우
                  </P2>
                  <P2>
                    7-5) “이용자”의 컴퓨터 또는 휴대폰 오류에 의해 손해가 발생한 경우, 또는 신상정보
                    및 전자우편 주소를 부실하게 기재하여 손해가 발생한 경우
                  </P2>
                  <P2>
                    7-6) 기타 “이용자”가 발생한 손해중 “회사”의 고의 또는 중과실로 발생한 손해가
                    아닌 경우
                  </P2>
                </li>
              </OL2>
            </li>
          </OL>
        </Article>
        <Article>
          <Notice>제3장 이용자 관리 및 보호</Notice>
        </Article>
        <Article>
          <H2>제12조 (개인 정보의 보호 및 사용)</H2>
          <OL>
            <li>
              <P>
                1. “회사”는 “회원”의 개인 정보를 보호하기 위하여 정보통신망법 및 개인정보보호법 등
                관계 법령에서 정하는 바를 준수합니다.
              </P>
              <P>
                2. “회사”는 “회원”의 개인 정보를 보호하기 위하여 개인 정보 처리 방침을 제정하여
                커뮤니티에 게시합니다. 다만, 개인 정보 처리 방침의 구체적 내용은 연결 화면을 통하여
                볼 수 있습니다.
              </P>
              <P>
                3. “회사”는 개인 정보 처리 방침 마케팅 수집 이용 동의에 따라 “회원”의 개인정보를
                최대한 보호하기 위하여 노력합니다.
              </P>
              <P>
                4. “회사”의 공식 사이트 이외의 링크된 사이트에서는 “회사”의 개인 정보 처리 방침이
                적용되지 않습니다. 링크된 사이트 및 구매 상품이나 서비스를 제공하는 제3자의 개인정보
                취급과 관련하여는 해당 사이트 및 제3자의 개인 정보 처리 방침을 확인할 책임이
                “회원”에게 있으며, “회사”는 이에 대하여 책임을 부담하지 않습니다.
              </P>
              <P>
                5. “회사”는 다음과 같은 경우에 법이 허용하는 범위 내에서 “회원”의 개인 정보를
                제3자에게 제공할 수 있습니다.
              </P>
              <OL2>
                <li>
                  <P2>5-1) 수사기관이나 기타 정부기관으로부터 정보 제공을 요청 받은 경우</P2>
                  <P2>
                    5-2) “회원”의 법령 또는 약관의 위반을 포함하여 부정행위 확인 등의 정보보호
                    업무를 위해 필요한 경우
                  </P2>
                  <P2>5-3) “회원” 간의 분쟁 해결을 위해 필요한 경우</P2>
                  <P2>5-4) 기타 법률에 의해 요구되는 경우</P2>
                </li>
              </OL2>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>제13조 (“PROMPTY” 서비스 이용제한)</H2>
          <P>
            “PROMPTY” 서비스를 이용하는 “회원”은 별도로 동의한 “회사” 운영규정에 해당하는 과실
            행위를 하여서는 안되며, 이에 해당하는 문제 발생시 “회사”의 운영규정에 따라 규정 처리 및
            경우에 따라 “회사”에 의해 “회사”에게 피해보상 절차가 진행될 수 있습니다.
          </P>
        </Article>
        <Article>
          <H2>제14조 (“게시물”)</H2>
          <OL>
            <li>
              <P>
                1. 회원이 작성한 게시물에 대한 저작권 및 모든 책임은 이를 게시한 “회원”에게
                있습니다.
              </P>
              <P>
                2. 정보통신망 이용촉진 및 정보보호 등에 관한 법률(이하 “정보통신망법”이라 합니다)의
                규정에 의해 정보통신망을 통하여 일반에게 공개를 목적으로 제공된 정보로 사생활 침해나
                명예훼손 등 권리가 침해된 경우 그 침해를 받은 자는 해당 정보를 처리한 정보통신서비스
                제공자에게 침해사실을 소명하여 그 정보의 삭제 또는 반박내용의 게재 및 삭제를 요청할
                수 있습니다. 이 경우 회사는 해당 게시물 등의 권리 침해여부를 판단할 수 없거나 당사자
                간의 다툼이 예상되는 경우 해당 게시물 등에 대한 접근을 임시적으로 차단하는 조치(이하
                “임시조치”라 합니다)를 최장 30일까지 취할 수 있으며 임시조치한 날로부터 30일이
                도래하는 시점에 임시조치를 해제합니다.
              </P>
              <P>
                3. “회사”는 게시하거나 등록하는 게시물의 내용이 다음 각 호에 해당한다고 판단되는
                경우 삭제 또는 임시조치(비공개 처리) 할 수 있으며 그 결과에 대해서는 이용자에게
                고지합니다.
              </P>
              <OL>
                <li>
                  <P>3-1) 다른 이용자 또는 제3자를 비방하거나 명예를 손상시키는 내용인 경우</P>
                  <P>3-2) 공공질서 및 미풍양속에 위반되는 내용일 경우</P>
                  <P>3-3) 범죄적 행위에 결부된다고 인정되는 경우</P>
                  <P>3-4) ”회사”의 저작권, 제3자의 저작권 등 기타 권리를 침해하는 내용인 경우</P>
                  <P>
                    3-5) “회원”이 어플과 게시판에 음란물을 게재하거나 음란사이트를 링크하는 경우
                  </P>
                  <P>3-6) “회사”로부터 사전 승인 받지 아니한 상업광고, 판촉 내용을 게시하는 경우</P>
                  <P>3-7) 해당 “서비스”와 객관적으로 관련성이 없는 내용인 경우</P>
                  <P>
                    3-8) 동일한 내용을 “서비스”에 반복적으로 등록하거나 정상적인 “서비스” 이용으로
                    볼 수 없는 행위
                  </P>
                  <P>3-9) 정당한 사유 없이 “회사”의 영업을 방해하는 내용을 기재하는 경우</P>
                  <P>
                    3-10) 부당한 방법으로 리뷰 권한을 획득하여 “이용자” 또는 제3자의 계정을 이용하여
                    게시글을 게시하는 경우
                  </P>
                  <P>3-11) 의미 없는 문자 및 부호에 해당하는 경우</P>
                  <P>3-12) 제3자 등으로부터 권리침해신고가 접수된 경우</P>
                  <P>
                    3-13) “서비스” 명칭 또는 임직원이나 “서비스”와 관련한 운영진을 사칭하여 “회원”를
                    속이거나 이득을 취하는 등 피해와 혼란을 주는 행위
                  </P>
                  <P>3-14) 관계법령에 위반된다고 판단되는 경우</P>
                  <P>
                    3-15) “회사”의 서비스 약관, 운영정책 등 위반행위를 할 우려가 있거나 위반행위를
                    한 경우
                  </P>
                  <P>
                    3-16) 기타 중대한 사유로 인하여 “회사”가 “서비스” 제공을 지속하는 것이
                    부적당하다고 인정하는 경우
                  </P>
                </li>
              </OL>
            </li>
          </OL>
        </Article>
        <Article>
          <Notice>제4장 기타</Notice>
        </Article>
        <Article>
          <H2>제15조 (분쟁처리 및 분쟁조정)</H2>
          <P>
            “회원”과 상호간 거래 행위에 발생하는 분쟁은 당사자 협의를 원칙으로 합니다. 다만, 당사자
            간 협의가 이루어지지 않을 경우 한국소비자원에 구제신청을 할 수 있습니다.
          </P>
        </Article>
        <Article>
          <H2>제16조 (면책)</H2>
          <OL>
            <li>
              <P>
                1. “회사”는 천재지변 또는 이에 준하는 불가항력으로 인하여 서비스를 제공할 수 없는
                경우에는 고의 또는 과실이 없는 한 “회원”에게 발생한 손해에 대하여 서비스 제공에 관한
                책임이 면제됩니다.
              </P>
              <P>
                2. “회사”는 “회원”의 귀책사유로 인한 서비스 이용의 장애에 대하여 책임을 지지
                않습니다.
              </P>
              <P>
                3. “회사”는 “회원” 간 정보를 공유하는 커뮤니티 서비스만을 제공할 뿐, 재화 등을
                판매하는 당사자가 아니며, “회원” 간에 분쟁이 발생했을 경우 고의 또는 중과실이 없는
                한 법적 문제에 대하여 책임을 지지 않습니다.
              </P>
              <P>
                4. “회사”는 기간통신 사업자가 전기통신 서비스를 중지하거나 정상적으로 제공하지
                아니하여 손해가 발생할 경우 책임이 면제됩니다.
              </P>
              <P>
                5. “회원”은 자신의 개인정보 및 계정(아이디, 회원가입 계정의 로그인 비밀번호 등) 등을
                타인에게 제공하거나, 회원의 관리 소홀로 유출됨으로써 발생하는 피해에 대해서는
                “회사”가 책임을 부담하지 않습니다.
              </P>
              <P>
                6. “회사”는 무료로 제공되는 서비스 이용과 관련하여 관련법에 특별한 규정이 없는 한
                책임을 지지 않습니다.
              </P>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>제17조 (재판권 및 준거법)</H2>
          <OL>
            <li>
              <P>
                1. “회사”와 “이용자”간에 발생한 분쟁에 관한 소송은 민사소송법상의 관할 법원에
                제기합니다. 다만, 서비스 이용 시 관할 법원에 대한 별도 합의가 있는 경우에는 이에
                따릅니다.
              </P>
              <P>2. “회사”와 “이용자”간에 제기된 소송에는 대한민국법을 적용합니다.</P>
              <P>[부칙] 본 약관은 2023년 04월 02일부터 적용됩니다.</P>
            </li>
          </OL>
        </Article>
      </ContentContainer>
    </Wrapper>
  );
}

const Wrapper = styled.div`
  ${({ theme }) => theme.flexSet('center', 'center', 'column')}
`;

const HeaderBlock = styled.div`
  ${({ theme }) => theme.flexSet('center', 'center', 'row')};
  width: 100%;
  height: 55px;
  border-bottom: 1px solid #202020;
  & > h1 {
    ${({ theme }) => theme.fontSet(20, 500, 25)};
  }
  & > a {
    position: absolute;
    top: 32px;
    right: 32px;
    width: 30px;
    height: 30px;
    cursor: pointer;
    ${({ theme }) => theme.backgroundSet('/static/icons/button-close-black.svg', '20px 20px')};
  }
`;

const ContentContainer = styled.section`
  ${({ theme }) => theme.flexSet('center', 'flex-start', 'column')}
  max-width: 800px;
  margin: 20px 20px 60px 20px;
  padding: 15px;
`;

const Article = styled.article`
  margin-bottom: 17px;
`;

const Notice = styled.p`
  color: white;
  ${({ theme }) => theme.fontSet(18, 400, 27)};
  margin-top: 20px;
  margin-bottom: 10px;
`;

const H2 = styled.p`
  ${({ theme }) => theme.fontSet(16, 400, 24)};
  margin-top: 20px;
  margin-bottom: 5px;
`;

const P = styled.h2`
  margin-top: 7px;
  color: #707070;
  ${({ theme }) => theme.fontSet(14, 300, 21)};
`;

const P2 = styled.h3`
  margin-top: 7px;
  color: #404040;
  ${({ theme }) => theme.fontSet(13, 300, 17)};
`;

const OL = styled.ol`
  list-style-type: lower-alpha;
  li {
    margin-top: 7px;
    margin-left: 17px;
    color: #707070;
    ${({ theme }) => theme.fontSet(14, 300, 21)};
  }
`;

const OL2 = styled.ol`
  margin: 10px 0;
  li {
    margin-top: 7px;
    margin-left: 7px;
    ${({ theme }) => theme.fontSet(14, 300, 21)};
  }
`;
