/**
 * Author : Ryan
 * Date : 2022-11-20
 * Desc : Privacy components
 */

import styled from 'styled-components';

export default function PrivacyPage() {
  return (
    <Wrapper>
      <HeaderBlock>
        <h1>개인정보 수집 및 이용약관</h1>
      </HeaderBlock>
      <ContentContainer>
        <Article>
          <Notice>개인정보의 수집 항목 및 수집 방법</Notice>
          <P>
            PROMPY (이하 ”회사”)는 개인정보를 보호하며, 『정보통신망 이용촉진 및 정보보호에 관한
            법률』,『개인정보보호법』등에 관련 법령을 준수하며 다음과 같이 개인정보처리방침을 공개
            합니다.
          </P>
        </Article>
        <Article>
          <H2>1. 개인정보의 수집 및 이용목적</H2>
          <OL>
            <P>
              “회사” 는 다음의 목적을 위하여 개인정보를 처리합니다. 처리하고 있는 개인정보는 다음의
              목적 이외의 용도로는 이용되지 않으며, 이용 목적이 변경되는 경우에는 개인정보보호법
              제18조에 따라 별도의 동의를 받는 등 필요한 조치를 이행할 예정입니다.
            </P>
            <li>
              구분 목적
              <P>
                회원가입 회원제 서비스 제공에 따른 본인 식별 인증, 회원자격 유지/관리, 서비스
                부정이용 방지, 각종 고지/통지, 고충처리, 서비스 이용 및 상담, 문의 등 원활한
                의사소통 경로 확보를 목적으로 합니다.
              </P>
              <P>
                서비스 제공 컨텐츠 제공, 맞춤서비스 제공, 본인인증 등 마케팅 광고 회원의 서비스
                이용에 대한 통계, 이벤트, 혜택 등 광고성 정보 전달 및 맞춤형 온라인 광고에서 사용될
                수 있습니다.
              </P>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>2. 개인정보 수집 항목 및 방법</H2>
          <OL>
            <P>
              “단체”는 서비스 제공에 필요한 최소한의 개인정보를 수집하고 있습니다. 서비스 제공에
              필요한 최소한의 정보 외의 정보는 동의하지 않을 수 있습니다. “단체”가 수집하는 개인정보
              항목과 방법은 다음과 같습니다.
            </P>
            <li>
              대상 수집 항목 방법
              <P>
                일반회원 : 성명, 생년월일, 성별, 아이디, 휴대전화번호, DI(Duplication information)
                방법 일반회원 성명, 생년월일, 성별, 아이디, 휴대전화번호, DI(Duplication
                information) 홈페이지, 모바일 어플리케이션, 고객센터를 통한 전화 및 온라인 상담,
                이벤트 응모
              </P>
              <P>
                ※ 서비스 이용 과정에서 서비스 이용기록, 방문기록, 불량 이용기록, IP주소, 쿠키,
                MAC주소, 모바일 기기정보(앱 버전, OS 버전), ADID/IDFA(광고식별자) 등의 정보가
                자동으로 생성되어 수집될 수 있습니다.
              </P>
              <P>
                ※ 진행하는 이벤트에 따라 수집 항목이 상이할 수 있습니다. 이 경우, 이벤트 응모 시
                별도 동의를 받으며, 목적 달성 즉시 파기합니다.
              </P>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>3. 개인정보의 보유 및 이용 기간</H2>
          <OL>
            <P>
              "회사"는 개인정보의 처리 목적이 달성될 때까지 개인정보를 보유합니다. 단,
              정보주체로부터 사전에 동의를 받은 경우 또는 상법 등 관련 법령에 의하여 보존할 필요성이
              있는 다음의 경우에는 개인정보를 일정기간 동안 보유합니다.
            </P>
            <li>
              회원 가입 및 관리
              <P>
                고객 요구사항 처리 및 민원 해결 등의 목적으로 탈퇴 요청 후 30일간 “회원”의
                개인정보를 보유한 뒤 파기합니다. 이는 고객의 실수 혹은 변심에 의해 탈퇴 신청 철회 시
                활동 내역 복구, 무분별한 회원탈퇴 및 재가입으로 인한 부정 이용 및 피해를 예방하기
                위해서입니다.
              </P>
              <P>
                관계 법령에 따른 정보 보유 사유 및 이용기간은 다음과 같습니다.
                <OL2>
                  <li>
                    1) 법령 수집 및 이용 목적 수집 항목 보유 및 이용기간 통신 비밀보호법
                    통신사실확인 자료 제공 로그 기록 3개월 전자상거래 등에서의 소비자보호에 관한
                    법률 표시∙광고에 관한 기록 표시∙광고 기록 6개월
                  </li>
                  <li>
                    2) 대금결제 및 재화 등에 공급에 관한 기록 대금결제/재화 등의 공급 기록 5년
                  </li>
                  <li>
                    3) 계약 또는 청약 철회 등에 관한 기록 소비자 식별 정보 계약/청약 철회 기록 5년
                  </li>
                  <li>
                    4) 소비자 불만 또는 분쟁처리에 관한 기록 소비자 식별 정보 분쟁처리 기록 3년
                  </li>
                </OL2>
              </P>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>4. 장기 미이용 회원 개인정보 분리 보관</H2>
          <OL>
            <P>
              “회사”는 1년 동안 회사의 서비스를 이용하지 않은 휴면 회원의 개인정보는 ‘정보통신망
              이용촉진 및 정보 보호 등에 관한 법률 제 29조’에 근거하여 이용자에게 사전통지하고
              개인정보를 파기하거나 별도로 분리하여 저장합니다.
            </P>
            <li>
              <P>(1) 휴면 회원 : “PROMPY” 서비스를 1년 이상 이용하지 않은 회원</P>
              <P>(2) 휴면 회원의 개인정보는 별도로 분리되어 안전하게 보관합니다.</P>
              <P>
                (3) “회사”는 휴면 전환 30일 전까지 휴면 예정 회원에게 별도 분리 보관되는 사실 및
                휴면 예정일, 별도 분리 보관하는 개인정보 항목을 이메일, 서면, 모사전송, 문자메세지
                또는 이와 유사한 방법 중 어느 하나의 방법으로 이용자에게 알립니다.
              </P>
              <P>
                (4) 휴면 회원이 “PROMPY” 서비스에 로그인할 경우 휴면계정은 자동으로 일반 회원
                계정으로 복구됩니다.
              </P>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>5. 개인정보의 파기절차 및 방법</H2>
          <OL>
            <P>
              “회사”는 원칙적으로 처리 목적달성, 보유∙이용기간의 경과 등의 사유로 이용자의
              개인정보가 더 이상 필요하지 않을 경우 해당정보를 지체 없이 파기합니다.
            </P>
            <li>
              개인정보의 파기절차 및 방법은 다음과 같습니다.
              <P>
                (1) 파기절차 : “회사”는 파기 사유가 발생한 개인정보를 개인정보책임자의 책임 하에
                내부방침에 따라 파기합니다.
              </P>
              <P>
                (2) 파기방법 “회사”는 전자적 파일형태로 저장된 개인정보는 기록을 재생할 수 없는
                기술적 방법을 사용하여 삭제하며, 종이로 출력된 개인정보는 분쇄기로 분쇄하거나 소각
                등을 통하여 파기합니다.
              </P>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>6. 개인 정보의 제 3자 제공</H2>
          <OL>
            <P>
              “회사”는 개인정보의 수집 및 이용목적에서 고지한 범위에서 사용하며, 이용자의 사전 동의
              없이 개인정보 수집이용 목적 범위를 초과하여 이용하거나 제 3자에게 제공하지 않습니다.
              단, 아래의 경우 예외로 합니다.
              <li>
                <P>(1) 이용자가 사전에 공개한 경우 (글 등록, 댓글 등의 행위)</P>
                <P>(2) 관계법령의 규정에 의거 또는 수사 목적으로 수사기관의 요구가 있는 경우</P>
                <P>
                  ※ 또한 “회사”는 서비스 제공을 위하여 이용자의 개인정보 제 3자 제공이 필요한 경우,
                  “회사”는 사전에 제공받는 자, 제공 목적, 제공 항목, 보유 및 이용기간 등을
                  이용자에게 고지하고 동의를 받으며 그 내용은 아래와 같습니다. 용자가 아래 제공에
                  대해 동의하지 않는 경우 해당 서비스 이용은 제한됩니다.
                </P>
              </li>
            </P>
          </OL>
        </Article>
        <Article>
          <H2>7. 개인정보처리의 위탁</H2>
          <OL>
            <P>
              “회사”는 보다 나은 서비스 제공, 이용자 편의 제공 등 원활한 업무 수행을 위하여 다음과
              같이 개인정보 처리 업무를 전문업체에 위탁하여 운영하고 있습니다.
            </P>
            <P>
              위탁 받는 자 위탁하는 업무의 내용 제공 항목 보유 및 이용 기간 Amazon Web Services,
              Inc. 정보저장 휴대전화번호, 자택주소, 기타 서비스 제공에 필요한 정보 회원탈퇴 시 혹은
              위탁계약 종료 시까지
            </P>
            <P>
              “회사”는 위탁계약 체결 시 위탁업무 수행목적 외 개인정보 처리금지, 기술적 관리적
              보호조치, 재위탁 제한, 수탁자에 대한 관리 감독, 손해배상 등 책임에 관한 사항을 계약서
              등 문서에 명시하고, 수탁자가 개인정보를 안전하게 처리하는지 감독하고 있습니다.
            </P>
            <P>
              위탁업무의 내용이나 수탁자가 변경될 경우에는 개인정보보호법 제18조에 따라 미리 본
              개인정보 처리방침을 통하여 고지하고 동의를 받을 것임을 알려드립니다.
            </P>
          </OL>
        </Article>
        <Article>
          <H2>8. 이용자 및 법정대리인의 권리와 그 행사 방법</H2>
          <OL>
            <P>
              이용자는 “회사”에 대해 언제든지 다음 각 호의 개인정보 보호 관련 권리를 행사할 수
              있습니다.
              <li>
                <P>1) 개인정보 열람 요구 요구</P>
                <P>2) 오류 등이 있을 경우 정정 요구</P>
                <P>3) 삭제 요구</P>
                <P>4) 처리정지</P>
              </li>
            </P>
            <P>
              다음 각 호에 해당하는 경우에는 이용자에게 그 사유를 알리고 전항의 개인정보 열람 요구를
              제한하거나 거절할 수 있습니다.
              <li>
                <P>(1) 법률에 따라 열람이 금지되거나 제한되는 경우</P>
                <P>
                  (2) 다른 사람의 생명/신체를 해할 우려가 있거나 다른 사람의 재산과 그 밖의 이익을
                  부당하게 침해할 우려가 있는 경우
                </P>
                <P>(3) 이용자가 열람을 요구하는 정보가 없거나 파기되어 보관되지 않은 경우</P>
                <P>
                  (4) 이용자는 홈페이지의 “개인정보수정”,”회원탈퇴” 메뉴 및 “회사”에 대해 서면,
                  전화, 전자우편, 모사전송(FAX)등을 통하여 권리 행사를 하실 수 있으며 “회사”는 이에
                  대해 지체없이 조치하겠습니다.
                </P>
                <P>
                  (5) 이용자가 개인정보의 오류 등에 대한 정정 또는 삭제를 요구한 경우에는 “회사”는
                  정정 또는 삭제를 완료할 때까지 당해 개인정보를 이용하거나 제공하지 않습니다.
                </P>
                <P>
                  (6) 이용자에 따른 권리 행사는 이용자의 법정대리인이나 위임을 받은 자 등 대리인을
                  통하여 하실 수 있습니다. 이 경우 위임장을 제출하여야 합니다.
                </P>
                <P>
                  (7) 이용자는 개인정보 보호 유관법령을 위반하여 “회사”가 처리하고 있는 이용자
                  본인이나 타인의 개인정보 및 사생활을 침해해서는 안됩니다.
                </P>
              </li>
            </P>
          </OL>
        </Article>
        <Article>
          <H2>9. 개인정보 자동수집 장치의 설치, 운영 및 그 거부에 관한 사항</H2>
          <OL>
            <P>
              “회사”는 이용자에게 개별적인 맞춤 서비스를 제공하기 위해 이용정보를 저장하고 수시로
              불러오는 “쿠키(cookie)”를 사용합니다.
            </P>
            <P>
              쿠키는 웹사이트를 운영하는데 이용되는 서버(http)가 이용자의 컴퓨터 브라우저에게 보내는
              소량의 정보이고 접속 IP 주소, 서비스 이용 기록, 홈페이지 방문 기록, 기기정보 (하드웨어
              모델, 운영체제, 고유기기 식별번호 등) 등이 포함되며, 이용자의 컴퓨터를 식별하지만
              개인적으로 식별하지는 않습니다. 쿠키는 이용자들의 PC 컴퓨터내의 하드디스크에
              저장되기도 합니다.
            </P>
            <li>
              <P>
                (1) 쿠키의 사용 목적: 이용자가 방문한 각 서비스와 웹 사이트들에 대한 방문 및
                이용형태, 인기 검색어, 보안접속 여부 등을 파악하여 이용자에게 최적화된 정보제공을
                위해 사용됩니다.
              </P>
              <P>
                (2) 쿠키의 설치 운영 및 거부 방법
                <OL2>
                  <li>
                    <P>
                      - Internet Explorer의 경우: 웹브라우저 상단의 [도구] - [인터넷 옵션] -
                      [개인정보] 메뉴의 옵션 설정
                    </P>
                    <P>
                      - Google Chrome의 경우: Chrome 브라우저 우측 상단 [설정] - [개인정보 및 보안]
                      탭 - [쿠키 및 기타 사이트 데이터] - [일반 설정] 내 설정
                    </P>
                    <P>
                      - Safari의 경우: Safari - 환경설정을 선택하고 개인 정보 보호를 클릭한 후, 쿠키
                      및 웹 사이트 데이터 옵션 설정
                    </P>
                  </li>
                </OL2>
              </P>
              <P>
                (3)쿠키 저장을 거부할 경우 맞춤형 서비스 등 회사가 제공하는 일부 서비스 이용에
                어려움이 발생할 수 있습니다.
              </P>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>10. 모바일 앱 사용 시 광고 식별자(ADID/IDFA) 수집</H2>
          <OL>
            <P>
              “회사”는 이용자의 ADID/IDFA를 수집할 수 있습니다. ADID/IDFA란 모바일 앱 이용자의 광고
              식별값으로, 사용자의 맞춤 서비스 제공이나 더 나은 환경의 광고를 제공하기 위한 측정을
              위해 수집될 수 있습니다.
            </P>
            <P>
              거부방법
              <li>
                <P>- Android: 설정 - 구글(구글설정) - 광고 - 광고 맞춤설정 선택 해제</P>
                <P>- iOS: 설정 - 개인정보보호 - 광고 - 광고 추적 제한</P>
              </li>
            </P>
          </OL>
        </Article>
        <Article>
          <H2>11. 온라인 맞춤형 광고 서비스</H2>
          <OL>
            <P>
              “회사”는 다음과 같이 온라인 맞춤형 광고 사업자가 행태정보를 수집하도록 허용하고
              있습니다.
            </P>
            <li>
              <P>(1) 행태정보를 수집 및 처리하는 광고 사업자: 구글, 페이스북, Naver, 카카오</P>
              <P>
                (2) 행태정보 수집 방법: 이용자가 당사 웹사이트를 방문하거나 앱을 실행할 때 자동 수집
                및 전송
              </P>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>12. 개인정보의 안전성 확보조치</H2>
          <OL>
            <P>“회사”는 개인정보의 안정성 확보를 위해 다 과 같은 조치를 취하고 있습니다.</P>
            <li>
              <P>
                (1) 관리적 조치: 개인정보 접근권한 인원의 최소화, 내부관리계획 수립 시행, 보안서약서
                작성, 정기적 직원 교육 등
              </P>
              <P>
                (2) 기술적 조치: 개인정보처리 시스템 등의 접근권한 관리, 접근 통제 시스템 설치,
                고유식별정보 등의 암호화 등
              </P>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>13. 개인정보 보호 책임자</H2>
          <OL>
            <P>
              “회사”는 개인정보 처리에 관한 업무를 총괄해서 책임지고, 개인정보 처리와 관련한
              정보주체의 불만처리 및 피해구제 등을 위하여 아래와 같이 개인정보 보호 책임자를
              지정하고 있습니다.
            </P>
            <li>
              <P>개인정보 보호 책임자</P>
              <P>- 성명: 안상혁</P>
              <P>- 직책: 개발자</P>
              <P>- 연락처: 010-9779-6777</P>
              <P>- 이메일: kaaiinn4@gmail.com</P>
              <P>※ 개인정보 보호 담당부서로 연결 됩니다.</P>
            </li>
            <P>
              이용자는 “회사”의 서비스를 이용하시면서 발생한 모든 개인정보 보호 관련 문의, 불만처리,
              피해구제 등에 관한 사항을 인정보 보호책임자 및 담당자에게 문의할 수 있습니다. “회사”는
              이용자의 문의에대해지체없이답변해드릴것입니다.
            </P>
          </OL>
        </Article>
        <Article>
          <H2>14. 이용자의 권익침해에 대한 구제 방법</H2>
          <OL>
            <P>
              이용자는 아래의 기관에 대해 개인정보 침해에 대한 피해구제, 상담 등을 문의하실 수
              있습니다. 아래의 기관은 “회사”와는 별개의 기관으로, “회사”의 자체적인 개인정보
              불만처리, 피해구제 결과에 만족하지 못하시거나 보다 자세한 도움이 필요하실 경우
              문의하여 주시기 바랍니다.
            </P>
            <li>
              <P>문의처 연락처 홈페이지</P>
              <P>개인정보침해신고센터 (국번없이) 118 </P>
              <P>- privacy.kisa.or.kr</P>
              <P>개인정보분쟁조정위원회 1833-6972 </P>
              <P>- www.kopico.go.kr </P>
              <P>대검찰청 사이버수사과 (국번없이) 1301 </P>
              <P>www.spo.go.kr</P>
              <P>경찰청 사이버안전국 (국번없이) 182 </P>
              <P>cyberbureau.police.go.kr </P>
            </li>
          </OL>
        </Article>
        <Article>
          <H2>15. 개인정보처리방침의 개정과 그 공지</H2>
          <OL>
            <P>
              본 개인정보 처리방침을 개정할 경우에는 최소 7일 전 홈페이지 또는 이메일을 통해 변경 및
              내용 등을 공지하도록 하겠습니다. 다만 이용자의 소중한 권리 또는 의무에 중요한 내용
              변경이 발생하는 경우 시행일로부터 최소 30일 전에 공지하도록 하겠습니다.
            </P>
            <P>
              개정된 개인정보 처리방침과 관련하여 이용자는, 회원 탈퇴, 서비스 해지 방법으로 부동의
              하실 수 있습니다. 개정된 개인정보 처리방침에 명시적으로 의하지 않더라도, 개정 고지 후
              7일(중요한 내용 변경의 경우에는 30일) 내에 회원 탈퇴 또는 관련 서비스를 해지하는
              방법으로 부동의 하지 아니하지 경우에는, 정된 내용에 동의를 한 것으로 간주합니다.
            </P>
            <P>[부칙] 본 약관은 2023년 04월 02일부터 적용됩니다.</P>
          </OL>
        </Article>
      </ContentContainer>
    </Wrapper>
  );
}

const Wrapper = styled.div`
  ${({ theme }) => theme.flexSet('center', 'center', 'column')}
`;

const HeaderBlock = styled.div`
  ${({ theme }) => theme.flexSet('center', 'center', 'row')};
  width: 100%;
  height: 55px;
  border-bottom: 1px solid #202020;
  & > h1 {
    ${({ theme }) => theme.fontSet(20, 500, 25)};
  }
  & > a {
    position: absolute;
    top: 32px;
    right: 32px;
    width: 30px;
    height: 30px;
    cursor: pointer;
    ${({ theme }) => theme.backgroundSet('/static/icons/button-close-black.svg', '20px 20px')};
  }
`;

const ContentContainer = styled.section`
  ${({ theme }) => theme.flexSet('center', 'flex-start', 'column')}
  max-width: 800px;
  margin: 20px 20px 60px 20px;
  padding: 15px;
`;

const Article = styled.article`
  margin-bottom: 17px;
`;

const Notice = styled.p`
  color: white;
  ${({ theme }) => theme.fontSet(18, 400, 27)};
  margin-top: 20px;
  margin-bottom: 10px;
`;

const H2 = styled.p`
  ${({ theme }) => theme.fontSet(16, 400, 24)};
  margin-top: 20px;
  margin-bottom: 5px;
`;

const P = styled.h2`
  margin-top: 7px;
  color: #707070;
  ${({ theme }) => theme.fontSet(14, 300, 21)};
`;

const OL = styled.ol`
  list-style-type: lower-alpha;
  li {
    margin-top: 7px;
    margin-left: 17px;
    color: #707070;
    ${({ theme }) => theme.fontSet(14, 300, 21)};
  }
`;

const OL2 = styled.ol`
  margin: 10px 0;
  li {
    margin-top: 7px;
    margin-left: 0px;
    color: #404040;
    ${({ theme }) => theme.fontSet(14, 300, 21)};
  }
`;
