/**
 * Author : Ryan
 * Date : 2023-04-16
 * Desc : db
 */

const mongoose = require('mongoose');
const config = require('../config');

const connectDB = async () => {
  try {
    await mongoose.connect(config.mongoURI);
    mongoose.set('autoCreate', true);
    console.log('Mongoose Connected ...');
  } catch (err) {
    console.error(err.message);
    process.exit(1);
  }
};

module.exports = connectDB;
