# Rocket Community Code of Conduct

Like the technical community as a whole, the Rocket project, its teams, and its
community are made up of a mixture of professionals and volunteers from all over
the world, working on every aspect of the mission. Diversity is one of our huge
strengths, but it can also lead to communication issues and unhappiness. To that
end, we have a few ground rules that we ask people to adhere to. This code
applies equally to everyone in our community: maintainers, contributors, team
leads, mentors, those seeking help and guidance, and so on.

This isn’t an exhaustive list of things that you can’t do. Rather, take it in
the spirit in which it’s intended - a guide to make it easier to enrich all of
us and the technical communities in which we participate.

_If you believe someone is violating the code of conduct, we ask that you report
it by emailing community@rwf2.org._

- **Be friendly. Be Kind. Be patient.**

- **Be welcoming.** We strive to be a community that welcomes and supports
  everyone, of all backgrounds and identities. This includes, but is not limited
  to members of any race, ethnicity, culture, national origin, color,
  immigration status, social and economic class, educational level, sex, sexual
  orientation, gender identity and expression, age, size, family status,
  political belief, religion, and mental and physical ability.

- **Be considerate.** Your work will be used by other people, and you in turn
  will depend on the work of others. Any decision you take will affect users and
  colleagues, and you should take those consequences into account when making
  decisions. Remember that we're a global community, so you might not be
  communicating in someone else's primary language.

- **Be respectful.** We won't all agree all the time, but disagreement isn't an
  excuse for poor behavior or poor manners. While frustrations may occasionally
  arise, we cannot allow those frustrations to turn into personal attacks.
  Remember that a community where people feel uncomfortable or threatened is not
  a productive one. Be respectful, not just to fellow community members, but to
  individuals outside the community as well.

- **Be careful in the words that you choose.** We are a community of
  professionals, and we conduct ourselves professionally. Do not insult or put
  down other participants. Harassment and other exclusionary behavior aren't
  acceptable. This includes, but is not limited to:
  - Violent threats or language directed against another person.
  - Discriminatory jokes and language.
  - Posting sexually explicit or violent material.
  - Posting (or threatening to post) other people's personally identifying
    information ("doxing").
  - Personal insults, especially those using racist or sexist terms.
  - Unwelcome sexual attention.
  - Advocating for, or encouraging, any of the above behavior.
  - Repeated harassment of others. In general, if someone asks you to stop, then
    stop.

- **Be understanding.** Disagreements, both social and technical, happen all the
  time. It is important that we resolve differing views constructively. When we
  disagree, try to understand why. Our community consists of people from a wide
  range of backgrounds. Different people have different perspectives on issues.
  Being unable to understand why someone holds a viewpoint doesn’t mean that
  they’re wrong. Don’t forget that it is human to err; blame accomplishes
  nothing. Instead, focus on helping to resolve issues and learning from
  mistakes.

_This code of conduct applies to all spaces managed by Rocket or the Rocket Web
Framework Foundation including issues and discussions on GitHub, Matrix, and any
other forums which the community uses for communication._

_This Code of Conduct is adapted from the [Django Code of Conduct]. Original text
from the [Speak Up! project]._

[Django Code of Conduct]: https://www.djangoproject.com/conduct/
[Speak Up! project]: http://web.archive.org/web/20141109123859/http://speakup.io/coc.html
