import { z } from 'zod'

export type ComfyNodeID = Tagged<string, 'ComfyNodeID'>
export const ComfyNodeID$Schema = z.string({ description: 'ComfyNodeID' })

export type ComfyNodeMetadata = {
    id?: Maybe<ComfyNodeID>

    /** @deprecated */
    tag?: string

    /**
     * list of tags;
     * those tags will be copied to assets generated by this node.
     * e.g. you can add tags to SaveImage or PreviewImage to automatically tag images they'll produce.
     */
    tags?: string[]

    /**
     * If the node produces an image, image will be stored in an ImageStore with given name.
     * ImageStore are useful for example to always have access to the image when re-running a workflow despite ComfyUI caching.
     */
    storeAs?: string

    // 💡 /**
    // 💡  * when true, if this node produces an image,
    // 💡  * it will be hidden from the output list
    // 💡  */
    // 💡 hideFromOutput?: boolean
}
