import type { OpenRouter_Models } from './OpenRouter_models'

export type OopenRouter_ModelInfo = {
    id: OpenRouter_Models
    name: string
    pricing: { prompt: string; completion: string }
    context_length: number
    architecture: { tokenizer: string; instruct_type: InstructType | null }
    top_provider: { max_completion_tokens: number | null }
    per_request_limits?: Maybe<{ prompt_tokens: string; completion_tokens: string }>
}
export type InstructType = //
    'llama2' | 'zephyr' | 'openchat' | 'alpaca' | 'vicuna' | 'neural' | 'gpt' | 'airoboros' | 'claude'

export const openRouterInfos: { [key in OpenRouter_Models]: OopenRouter_ModelInfo } = {
    'openrouter/auto': {
        id: 'openrouter/auto',
        name: 'Auto (best for prompt)',
        pricing: { prompt: '-1', completion: '-1' },
        context_length: 128000,
        architecture: { tokenizer: 'Router', instruct_type: null },
        top_provider: { max_completion_tokens: null },
        per_request_limits: null,
    },
    'mistralai/mistral-7b-instruct': {
        id: 'mistralai/mistral-7b-instruct',
        name: 'Mistral 7B Instruct',
        pricing: { prompt: '0', completion: '0' },
        context_length: 8192,
        architecture: { tokenizer: 'Mistral', instruct_type: 'llama2' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: 'Infinity', completion_tokens: 'Infinity' },
    },
    'mistralai/mixtral-8x7b-instruct': {
        id: 'mistralai/mixtral-8x7b-instruct',
        name: 'Mistral 8x7b',
        pricing: { prompt: '0', completion: '0' },
        context_length: 32000,
        architecture: { tokenizer: 'Mistral', instruct_type: 'llama2' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: 'Infinity', completion_tokens: 'Infinity' },
    },
    'mistralai/mistral-large': {
        id: 'mistralai/mistral-large',
        name: 'Mistral Large',
        pricing: { prompt: '0', completion: '0' },
        context_length: 32000,
        architecture: { tokenizer: 'Mistral', instruct_type: 'llama2' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: 'Infinity', completion_tokens: 'Infinity' },
    },
    'huggingfaceh4/zephyr-7b-beta': {
        id: 'huggingfaceh4/zephyr-7b-beta',
        name: 'Hugging Face: Zephyr 7B',
        pricing: { prompt: '0', completion: '0' },
        context_length: 4096,
        architecture: { tokenizer: 'Mistral', instruct_type: 'zephyr' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: 'Infinity', completion_tokens: 'Infinity' },
    },
    'openchat/openchat-7b': {
        id: 'openchat/openchat-7b',
        name: 'OpenChat 3.5',
        pricing: { prompt: '0', completion: '0' },
        context_length: 8192,
        architecture: { tokenizer: 'Mistral', instruct_type: 'openchat' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: 'Infinity', completion_tokens: 'Infinity' },
    },
    'undi95/toppy-m-7b': {
        id: 'undi95/toppy-m-7b',
        name: 'Toppy M 7B',
        pricing: { prompt: '0', completion: '0' },
        context_length: 32768,
        architecture: { tokenizer: 'Mistral', instruct_type: 'alpaca' },
        top_provider: { max_completion_tokens: 2048 },
        per_request_limits: { prompt_tokens: 'Infinity', completion_tokens: 'Infinity' },
    },
    'gryphe/mythomist-7b': {
        id: 'gryphe/mythomist-7b',
        name: 'MythoMist 7B',
        pricing: { prompt: '0', completion: '0' },
        context_length: 32768,
        architecture: { tokenizer: 'Mistral', instruct_type: 'alpaca' },
        top_provider: { max_completion_tokens: 2048 },
        per_request_limits: { prompt_tokens: 'Infinity', completion_tokens: 'Infinity' },
    },
    'nousresearch/nous-capybara-34b': {
        id: 'nousresearch/nous-capybara-34b',
        name: 'Nous: Capybara 34B',
        pricing: { prompt: '0.000002', completion: '0.000002' },
        context_length: 32000,
        architecture: { tokenizer: 'Llama2', instruct_type: 'vicuna' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '1569799', completion_tokens: '1569799' },
    },
    'jebcarter/psyfighter-13b': {
        id: 'jebcarter/psyfighter-13b',
        name: 'Psyfighter 13B',
        pricing: { prompt: '0.000001', completion: '0.000001' },
        context_length: 4096,
        architecture: { tokenizer: 'Llama2', instruct_type: 'alpaca' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '3139598', completion_tokens: '3139598' },
    },
    'nousresearch/nous-hermes-llama2-13b': {
        id: 'nousresearch/nous-hermes-llama2-13b',
        name: 'Nous: Hermes 13B',
        pricing: { prompt: '0.00000015', completion: '0.00000015' },
        context_length: 4096,
        architecture: { tokenizer: 'Llama2', instruct_type: 'alpaca' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '20930657', completion_tokens: '20930657' },
    },
    'phind/phind-codellama-34b': {
        id: 'phind/phind-codellama-34b',
        name: 'Phind: CodeLlama 34B v2',
        pricing: { prompt: '0.0000004', completion: '0.0000004' },
        context_length: 4096,
        architecture: { tokenizer: 'Llama2', instruct_type: 'alpaca' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '7848996', completion_tokens: '7848996' },
    },
    'intel/neural-chat-7b': {
        id: 'intel/neural-chat-7b',
        name: 'Neural Chat 7B v3.1',
        pricing: { prompt: '0.000005', completion: '0.000005' },
        context_length: 4096,
        architecture: { tokenizer: 'Mistral', instruct_type: 'neural' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '627919', completion_tokens: '627919' },
    },
    'haotian-liu/llava-13b': {
        id: 'haotian-liu/llava-13b',
        name: 'Llava 13B',
        pricing: { prompt: '0.000005', completion: '0.000005' },
        context_length: 2048,
        architecture: { tokenizer: 'Llama2', instruct_type: null },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '627919', completion_tokens: '627919' },
    },
    'meta-llama/llama-2-13b-chat': {
        id: 'meta-llama/llama-2-13b-chat',
        name: 'Meta: Llama v2 13B Chat',
        pricing: { prompt: '0.0000002345', completion: '0.0000002345' },
        context_length: 4096,
        architecture: { tokenizer: 'Llama2', instruct_type: 'llama2' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '13388480', completion_tokens: '13388480' },
    },
    'alpindale/goliath-120b': {
        id: 'alpindale/goliath-120b',
        name: 'Goliath 120B',
        pricing: { prompt: '0.00000703125', completion: '0.00000703125' },
        context_length: 6144,
        architecture: { tokenizer: 'Llama2', instruct_type: 'vicuna' },
        top_provider: { max_completion_tokens: 300 },
        per_request_limits: { prompt_tokens: '446520', completion_tokens: '446520' },
    },
    'lizpreciatior/lzlv-70b-fp16-hf': {
        id: 'lizpreciatior/lzlv-70b-fp16-hf',
        name: 'lzlv 70B',
        pricing: { prompt: '0.00000056', completion: '0.00000076' },
        context_length: 4096,
        architecture: { tokenizer: 'Llama2', instruct_type: 'vicuna' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '5606426', completion_tokens: '4131050' },
    },
    'openai/gpt-3.5-turbo': {
        id: 'openai/gpt-3.5-turbo',
        name: 'OpenAI: GPT-3.5 Turbo',
        pricing: { prompt: '0.000001', completion: '0.000002' },
        context_length: 4095,
        architecture: { tokenizer: 'GPT', instruct_type: null },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '3139598', completion_tokens: '1569799' },
    },
    'openai/gpt-3.5-turbo-1106': {
        id: 'openai/gpt-3.5-turbo-1106',
        name: 'OpenAI: GPT-3.5 Turbo 16k (preview)',
        pricing: { prompt: '0.000001', completion: '0.000002' },
        context_length: 16385,
        architecture: { tokenizer: 'GPT', instruct_type: null },
        top_provider: { max_completion_tokens: 4096 },
        per_request_limits: { prompt_tokens: '3139598', completion_tokens: '1569799' },
    },
    'openai/gpt-3.5-turbo-0301': {
        id: 'openai/gpt-3.5-turbo-0301',
        name: 'OpenAI: GPT-3.5 Turbo (older v0301)',
        pricing: { prompt: '0.000001', completion: '0.000002' },
        context_length: 4095,
        architecture: { tokenizer: 'GPT', instruct_type: null },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '3139598', completion_tokens: '1569799' },
    },
    'openai/gpt-3.5-turbo-16k': {
        id: 'openai/gpt-3.5-turbo-16k',
        name: 'OpenAI: GPT-3.5 Turbo 16k',
        pricing: { prompt: '0.000003', completion: '0.000004' },
        context_length: 16385,
        architecture: { tokenizer: 'GPT', instruct_type: null },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '1046532', completion_tokens: '784899' },
    },
    'openai/gpt-4-1106-preview': {
        id: 'openai/gpt-4-1106-preview',
        name: 'OpenAI: GPT-4 Turbo (preview)',
        pricing: { prompt: '0.00001', completion: '0.00003' },
        context_length: 128000,
        architecture: { tokenizer: 'GPT', instruct_type: null },
        top_provider: { max_completion_tokens: 4096 },
        per_request_limits: { prompt_tokens: '313959', completion_tokens: '104653' },
    },
    'openai/gpt-4': {
        id: 'openai/gpt-4',
        name: 'OpenAI: GPT-4',
        pricing: { prompt: '0.00003', completion: '0.00006' },
        context_length: 8191,
        architecture: { tokenizer: 'GPT', instruct_type: null },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '104653', completion_tokens: '52326' },
    },
    'openai/gpt-4-0314': {
        id: 'openai/gpt-4-0314',
        name: 'OpenAI: GPT-4 (older v0314)',
        pricing: { prompt: '0.00003', completion: '0.00006' },
        context_length: 8191,
        architecture: { tokenizer: 'GPT', instruct_type: null },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '104653', completion_tokens: '52326' },
    },
    'openai/gpt-4-32k': {
        id: 'openai/gpt-4-32k',
        name: 'OpenAI: GPT-4 32k',
        pricing: { prompt: '0.00006', completion: '0.00012' },
        context_length: 32767,
        architecture: { tokenizer: 'GPT', instruct_type: null },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '52326', completion_tokens: '26163' },
    },
    'openai/gpt-4-32k-0314': {
        id: 'openai/gpt-4-32k-0314',
        name: 'OpenAI: GPT-4 32k (older v0314)',
        pricing: { prompt: '0.00006', completion: '0.00012' },
        context_length: 32767,
        architecture: { tokenizer: 'GPT', instruct_type: null },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '52326', completion_tokens: '26163' },
    },
    'openai/gpt-4-vision-preview': {
        id: 'openai/gpt-4-vision-preview',
        name: 'OpenAI: GPT-4 Vision (preview)',
        pricing: { prompt: '0.00001', completion: '0.00003' },
        context_length: 128000,
        architecture: { tokenizer: 'GPT', instruct_type: null },
        top_provider: { max_completion_tokens: 4096 },
        per_request_limits: { prompt_tokens: '313959', completion_tokens: '104653' },
    },
    'openai/text-davinci-002': {
        id: 'openai/text-davinci-002',
        name: 'OpenAI: Davinci 2',
        pricing: { prompt: '0.00002', completion: '0.00002' },
        context_length: 4095,
        architecture: { tokenizer: 'GPT', instruct_type: 'gpt' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '156979', completion_tokens: '156979' },
    },
    'openai/gpt-3.5-turbo-instruct': {
        id: 'openai/gpt-3.5-turbo-instruct',
        name: 'OpenAI: GPT-3.5 Turbo Instruct',
        pricing: { prompt: '0.0000015', completion: '0.000002' },
        context_length: 4095,
        architecture: { tokenizer: 'GPT', instruct_type: 'gpt' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '2093065', completion_tokens: '1569799' },
    },
    'google/palm-2-chat-bison': {
        id: 'google/palm-2-chat-bison',
        name: 'Google: PaLM 2 Chat',
        pricing: { prompt: '0.0000005', completion: '0.0000005' },
        context_length: 9216,
        architecture: { tokenizer: 'PaLM', instruct_type: null },
        top_provider: { max_completion_tokens: 1024 },
        per_request_limits: { prompt_tokens: '6279197', completion_tokens: '6279197' },
    },
    'google/palm-2-codechat-bison': {
        id: 'google/palm-2-codechat-bison',
        name: 'Google: PaLM 2 Code Chat',
        pricing: { prompt: '0.0000005', completion: '0.0000005' },
        context_length: 7168,
        architecture: { tokenizer: 'PaLM', instruct_type: null },
        top_provider: { max_completion_tokens: 1024 },
        per_request_limits: { prompt_tokens: '6279197', completion_tokens: '6279197' },
    },
    'google/palm-2-chat-bison-32k': {
        id: 'google/palm-2-chat-bison-32k',
        name: 'Google: PaLM 2 Chat 32k',
        pricing: { prompt: '0.0000005', completion: '0.0000005' },
        context_length: 32000,
        architecture: { tokenizer: 'PaLM', instruct_type: null },
        top_provider: { max_completion_tokens: 8192 },
        per_request_limits: { prompt_tokens: '6279197', completion_tokens: '6279197' },
    },
    'google/palm-2-codechat-bison-32k': {
        id: 'google/palm-2-codechat-bison-32k',
        name: 'Google: PaLM 2 Code Chat 32k',
        pricing: { prompt: '0.0000005', completion: '0.0000005' },
        context_length: 32000,
        architecture: { tokenizer: 'PaLM', instruct_type: null },
        top_provider: { max_completion_tokens: 8192 },
        per_request_limits: { prompt_tokens: '6279197', completion_tokens: '6279197' },
    },
    'perplexity/pplx-70b-online': {
        id: 'perplexity/pplx-70b-online',
        name: 'Perplexity: PPLX 70B Online',
        pricing: { prompt: '0', completion: '0.0000028' },
        context_length: 4096,
        architecture: { tokenizer: 'Llama2', instruct_type: null },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: 'Infinity', completion_tokens: 'Infinity' },
    },
    'perplexity/pplx-7b-online': {
        id: 'perplexity/pplx-7b-online',
        name: 'Perplexity: PPLX 7B Online',
        pricing: { prompt: '0', completion: '0.00000028' },
        context_length: 4096,
        architecture: { tokenizer: 'Llama2', instruct_type: null },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: 'Infinity', completion_tokens: 'Infinity' },
    },
    'perplexity/pplx-7b-chat': {
        id: 'perplexity/pplx-7b-chat',
        name: 'Perplexity: PPLX 7B Chat',
        pricing: { prompt: '0.00000007', completion: '0.00000028' },
        context_length: 8192,
        architecture: { tokenizer: 'Llama2', instruct_type: null },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '44851408', completion_tokens: '11212852' },
    },
    'perplexity/pplx-70b-chat': {
        id: 'perplexity/pplx-70b-chat',
        name: 'Perplexity: PPLX 70B Chat',
        pricing: { prompt: '0.0000007', completion: '0.0000028' },
        context_length: 4096,
        architecture: { tokenizer: 'Llama2', instruct_type: null },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '4485140', completion_tokens: '1121285' },
    },
    'meta-llama/llama-2-70b-chat': {
        id: 'meta-llama/llama-2-70b-chat',
        name: 'Meta: Llama v2 70B Chat',
        pricing: { prompt: '0.0000007', completion: '0.00000095' },
        context_length: 4096,
        architecture: { tokenizer: 'Llama2', instruct_type: 'llama2' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '4485140', completion_tokens: '3304840' },
    },
    'nousresearch/nous-hermes-llama2-70b': {
        id: 'nousresearch/nous-hermes-llama2-70b',
        name: 'Nous: Hermes 70B',
        pricing: { prompt: '0.0000009', completion: '0.0000009' },
        context_length: 4096,
        architecture: { tokenizer: 'Llama2', instruct_type: 'alpaca' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '3488442', completion_tokens: '3488442' },
    },
    'meta-llama/codellama-34b-instruct': {
        id: 'meta-llama/codellama-34b-instruct',
        name: 'Meta: CodeLlama 34B Instruct',
        pricing: { prompt: '0.00000035', completion: '0.0000014' },
        context_length: 16384,
        architecture: { tokenizer: 'Llama2', instruct_type: 'llama2' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '8970281', completion_tokens: '2242570' },
    },
    'jondurbin/airoboros-l2-70b': {
        id: 'jondurbin/airoboros-l2-70b',
        name: 'Airoboros 70B',
        pricing: { prompt: '0.0000007', completion: '0.00000095' },
        context_length: 4096,
        architecture: { tokenizer: 'Llama2', instruct_type: 'airoboros' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '4485140', completion_tokens: '3304840' },
    },
    'migtissera/synthia-70b': {
        id: 'migtissera/synthia-70b',
        name: 'Synthia 70B',
        pricing: { prompt: '0.0000065625', completion: '0.0000065625' },
        context_length: 8192,
        architecture: { tokenizer: 'Llama2', instruct_type: 'vicuna' },
        top_provider: { max_completion_tokens: 300 },
        per_request_limits: { prompt_tokens: '478415', completion_tokens: '478415' },
    },
    'open-orca/mistral-7b-openorca': {
        id: 'open-orca/mistral-7b-openorca',
        name: 'Mistral OpenOrca 7B',
        pricing: { prompt: '0.0000002', completion: '0.0000002' },
        context_length: 8192,
        architecture: { tokenizer: 'Mistral', instruct_type: 'gpt' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '15697993', completion_tokens: '15697993' },
    },
    'teknium/openhermes-2-mistral-7b': {
        id: 'teknium/openhermes-2-mistral-7b',
        name: 'OpenHermes 2 Mistral 7B',
        pricing: { prompt: '0.0000002', completion: '0.0000002' },
        context_length: 4096,
        architecture: { tokenizer: 'Mistral', instruct_type: 'gpt' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '15697993', completion_tokens: '15697993' },
    },
    'teknium/openhermes-2.5-mistral-7b': {
        id: 'teknium/openhermes-2.5-mistral-7b',
        name: 'OpenHermes 2.5 Mistral 7B',
        pricing: { prompt: '0.0000002', completion: '0.0000002' },
        context_length: 4096,
        architecture: { tokenizer: 'Mistral', instruct_type: 'gpt' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '15697993', completion_tokens: '15697993' },
    },
    'pygmalionai/mythalion-13b': {
        id: 'pygmalionai/mythalion-13b',
        name: 'Pygmalion: Mythalion 13B',
        pricing: { prompt: '0.000001125', completion: '0.000001125' },
        context_length: 8192,
        architecture: { tokenizer: 'Llama2', instruct_type: 'alpaca' },
        top_provider: { max_completion_tokens: 250 },
        per_request_limits: { prompt_tokens: '2790754', completion_tokens: '2790754' },
    },
    'undi95/remm-slerp-l2-13b': {
        id: 'undi95/remm-slerp-l2-13b',
        name: 'ReMM SLERP 13B',
        pricing: { prompt: '0.000001125', completion: '0.000001125' },
        context_length: 6144,
        architecture: { tokenizer: 'Llama2', instruct_type: 'alpaca' },
        top_provider: { max_completion_tokens: 250 },
        per_request_limits: { prompt_tokens: '2790754', completion_tokens: '2790754' },
    },
    'xwin-lm/xwin-lm-70b': {
        id: 'xwin-lm/xwin-lm-70b',
        name: 'Xwin 70B',
        pricing: { prompt: '0.0000065625', completion: '0.0000065625' },
        context_length: 8192,
        architecture: { tokenizer: 'Llama2', instruct_type: 'vicuna' },
        top_provider: { max_completion_tokens: 300 },
        per_request_limits: { prompt_tokens: '478415', completion_tokens: '478415' },
    },
    'gryphe/mythomax-l2-13b-8k': {
        id: 'gryphe/mythomax-l2-13b-8k',
        name: 'MythoMax 13B 8k',
        pricing: { prompt: '0.000001125', completion: '0.000001125' },
        context_length: 8192,
        architecture: { tokenizer: 'Llama2', instruct_type: 'alpaca' },
        top_provider: { max_completion_tokens: 250 },
        per_request_limits: { prompt_tokens: '2790754', completion_tokens: '2790754' },
    },
    'neversleep/noromaid-20b': {
        id: 'neversleep/noromaid-20b',
        name: 'Noromaid 20B',
        pricing: { prompt: '0.00000225', completion: '0.00000225' },
        context_length: 8192,
        architecture: { tokenizer: 'Llama2', instruct_type: 'alpaca' },
        top_provider: { max_completion_tokens: 300 },
        per_request_limits: { prompt_tokens: '1395377', completion_tokens: '1395377' },
    },
    'anthropic/claude-2': {
        id: 'anthropic/claude-2',
        name: 'Anthropic: Claude v2.1',
        pricing: { prompt: '0.000008', completion: '0.000024' },
        context_length: 200000,
        architecture: { tokenizer: 'Claude', instruct_type: 'claude' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '392449', completion_tokens: '130816' },
    },
    'anthropic/claude-2.0': {
        id: 'anthropic/claude-2.0',
        name: 'Anthropic: Claude v2.0',
        pricing: { prompt: '0.000008', completion: '0.000024' },
        context_length: 100000,
        architecture: { tokenizer: 'Claude', instruct_type: 'claude' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '392449', completion_tokens: '130816' },
    },
    'anthropic/claude-instant-v1': {
        id: 'anthropic/claude-instant-v1',
        name: 'Anthropic: Claude Instant v1',
        pricing: { prompt: '0.00000163', completion: '0.00000551' },
        context_length: 100000,
        architecture: { tokenizer: 'Claude', instruct_type: 'claude' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '1926134', completion_tokens: '569800' },
    },
    'anthropic/claude-v1': {
        id: 'anthropic/claude-v1',
        name: 'Anthropic: Claude v1',
        pricing: { prompt: '0.000008', completion: '0.000024' },
        context_length: 9000,
        architecture: { tokenizer: 'Claude', instruct_type: 'claude' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '392449', completion_tokens: '130816' },
    },
    'anthropic/claude-1.2': {
        id: 'anthropic/claude-1.2',
        name: 'Anthropic: Claude (older v1)',
        pricing: { prompt: '0.000008', completion: '0.000024' },
        context_length: 9000,
        architecture: { tokenizer: 'Claude', instruct_type: 'claude' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '392449', completion_tokens: '130816' },
    },
    'anthropic/claude-instant-v1-100k': {
        id: 'anthropic/claude-instant-v1-100k',
        name: 'Anthropic: Claude Instant 100k v1',
        pricing: { prompt: '0.00000163', completion: '0.00000551' },
        context_length: 100000,
        architecture: { tokenizer: 'Claude', instruct_type: 'claude' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '1926134', completion_tokens: '569800' },
    },
    'anthropic/claude-v1-100k': {
        id: 'anthropic/claude-v1-100k',
        name: 'Anthropic: Claude 100k v1',
        pricing: { prompt: '0.000008', completion: '0.000024' },
        context_length: 100000,
        architecture: { tokenizer: 'Claude', instruct_type: 'claude' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '392449', completion_tokens: '130816' },
    },
    'anthropic/claude-instant-1.0': {
        id: 'anthropic/claude-instant-1.0',
        name: 'Anthropic: Claude Instant (older v1)',
        pricing: { prompt: '0.00000163', completion: '0.00000551' },
        context_length: 9000,
        architecture: { tokenizer: 'Claude', instruct_type: 'claude' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '1926134', completion_tokens: '569800' },
    },
    'mancer/weaver': {
        id: 'mancer/weaver',
        name: 'Mancer: Weaver (alpha)',
        pricing: { prompt: '0.0000045', completion: '0.0000045' },
        context_length: 8000,
        architecture: { tokenizer: 'Llama2', instruct_type: 'alpaca' },
        top_provider: { max_completion_tokens: 350 },
        per_request_limits: { prompt_tokens: '697688', completion_tokens: '697688' },
    },
    'gryphe/mythomax-l2-13b': {
        id: 'gryphe/mythomax-l2-13b',
        name: 'MythoMax 13B',
        pricing: { prompt: '0.0000006', completion: '0.0000006' },
        context_length: 4096,
        architecture: { tokenizer: 'Llama2', instruct_type: 'alpaca' },
        top_provider: { max_completion_tokens: null },
        per_request_limits: { prompt_tokens: '5232664', completion_tokens: '5232664' },
    },
}
