
export const iconAliases: {
    [key: string]: string[]
} = {
    'mdiAbjadArabic': ["writing-system-arabic"],
    'mdiAbjadHebrew': ["writing-system-hebrew"],
    'mdiAbugidaDevanagari': ["writing-system-devanagari"],
    'mdiAbugidaThai': ["writing-system-thai"],
    'mdiAccessPoint': ["wireless"],
    'mdiAccessPointCheck': ["access-point-success","access-point-tick"],
    'mdiAccount': ["person","user"],
    'mdiAccountAlert': ["user-alert","account-warning","user-warning","person-alert","person-warning"],
    'mdiAccountAlertOutline': ["user-alert-outline","account-warning-outline","user-warning-outline","person-warning-outline","person-alert-outline"],
    'mdiAccountArrowDown': ["account-download"],
    'mdiAccountArrowDownOutline': ["account-download-outline"],
    'mdiAccountArrowLeft': ["user-arrow-left","person-arrow-left"],
    'mdiAccountArrowLeftOutline': ["user-arrow-left-outline","person-arrow-left-outline"],
    'mdiAccountArrowRight': ["user-arrow-right","person-arrow-right"],
    'mdiAccountArrowRightOutline': ["user-arrow-right-outline","person-arrow-right-outline"],
    'mdiAccountArrowUp': ["account-upload"],
    'mdiAccountArrowUpOutline': ["account-upload-outline"],
    'mdiAccountBadge': ["account-online","user-online"],
    'mdiAccountBadgeOutline': ["user-online-outline","account-online-outline"],
    'mdiAccountBox': ["selfie","user-box","person-box","contact"],
    'mdiAccountBoxMultiple': ["switch-account","user-box-multiple","account-boxes","user-boxes","person-box-multiple","person-boxes"],
    'mdiAccountBoxOutline': ["selfie-outline","user-box-outline","portrait","contact-outline","person-box-outline"],
    'mdiAccountCancel': ["user-cancel","user-block","person-cancel","person-block"],
    'mdiAccountCancelOutline': ["user-cancel-outline","user-block-outline","person-cancel-outline","person-block-outline"],
    'mdiAccountCheck': ["user-check","account-tick","user-tick","person-check","person-tick","how-to-reg","account-success"],
    'mdiAccountCheckOutline': ["account-tick-outline","user-check-outline","user-tick-outline","person-check-outline","person-tick-outline","how-to-reg-outline","account-success-outline"],
    'mdiAccountChild': ["user-child","person-child","guardian"],
    'mdiAccountChildCircle': ["user-child-circle","person-child-circle","guardian-circle"],
    'mdiAccountCircle': ["user-circle","person-circle"],
    'mdiAccountCircleOutline': ["user-circle-outline","person-circle-outline"],
    'mdiAccountClock': ["user-clock","account-pending","person-clock"],
    'mdiAccountClockOutline': ["user-clock-outline","account-pending-outline","person-clock-outline"],
    'mdiAccountCog': ["account-settings"],
    'mdiAccountCogOutline': ["account-settings-outline"],
    'mdiAccountConvert': ["user-convert","person-convert"],
    'mdiAccountCowboyHat': ["rancher"],
    'mdiAccountCowboyHatOutline': ["rancher-outline"],
    'mdiAccountCreditCard': ["account-payment","cardholder"],
    'mdiAccountCreditCardOutline': ["account-payment-outline","cardholder-outline"],
    'mdiAccountDetails': ["user-details","person-details"],
    'mdiAccountDetailsOutline': ["person-details-outline","user-details-outline"],
    'mdiAccountEdit': ["user-edit","person-edit"],
    'mdiAccountEye': ["account-view"],
    'mdiAccountEyeOutline': ["account-view-outline"],
    'mdiAccountFilter': ["account-funnel","leads"],
    'mdiAccountFilterOutline': ["account-funnel-outline","leads-outline"],
    'mdiAccountGroup': ["user-group","users-group","person-group","people-group","accounts-group"],
    'mdiAccountGroupOutline': ["user-group-outline","users-group-outline","person-group-outline","people-group-outline","accounts-group-outline"],
    'mdiAccountHardHat': ["worker","construction"],
    'mdiAccountHardHatOutline': ["worker-outline","construction-outline"],
    'mdiAccountHeart': ["user-heart","person-heart"],
    'mdiAccountHeartOutline': ["user-heart-outline","person-heart-outline"],
    'mdiAccountInjury': ["account-disability","patient","person-injury"],
    'mdiAccountInjuryOutline': ["account-disability-outline","patient-outline","person-injury-outline"],
    'mdiAccountKey': ["user-key","person-key"],
    'mdiAccountKeyOutline': ["user-key-outline","person-key-outline"],
    'mdiAccountLock': ["account-security","account-secure","user-lock","person-lock"],
    'mdiAccountLockOpen': ["account-unlocked","user-unlocked","user-lock-open"],
    'mdiAccountLockOpenOutline': ["user-lock-open-outline","user-unlocked-outline","account-unlocked-outline"],
    'mdiAccountLockOutline': ["account-security-outline","account-secure-outline","person-lock-outline","user-lock-outline"],
    'mdiAccountMinus': ["user-minus","person-minus"],
    'mdiAccountMinusOutline': ["user-minus-outline","person-minus-outline"],
    'mdiAccountMultiple': ["people","user-multiple","group","accounts","users","person-multiple"],
    'mdiAccountMultipleCheck': ["user-multiple-check","account-multiple-tick","accounts-check","accounts-tick","users-check","users-tick","user-multiple-tick","person-multiple-check","person-multiple-tick","people-check","people-tick","account-multiple-success"],
    'mdiAccountMultipleCheckOutline': ["user-multiple-check-outline","account-multiple-tick-outline","accounts-check-outline","accounts-tick-outline","users-check-outline","users-tick-outline","user-multiple-tick-outline","person-multiple-check-outline","person-multiple-tick-outline","people-check-outline","people-tick-outline","account-multiple-success-outline"],
    'mdiAccountMultipleMinus': ["user-multiple-minus","accounts-minus","users-minus","people-minus","person-multiple-minus"],
    'mdiAccountMultipleMinusOutline': ["accounts-minus-outline","people-minus-outline","user-multiple-minus-outline","users-minus-outline","person-multiple-minus-outline"],
    'mdiAccountMultipleOutline': ["user-multiple-outline","people-outline","accounts-outline","users-outline"],
    'mdiAccountMultiplePlus': ["user-multiple-plus","group-add","accounts-plus","users-plus","person-multiple-plus","people-plus","person-multiple-add","people-add","account-multiple-add","accounts-add","user-multiple-add","users-add","invite"],
    'mdiAccountMultiplePlusOutline': ["group-add-outline","user-multiple-plus-outline","accounts-plus-outline","users-plus-outline","person-multiple-plus-outline","people-plus-outline","person-multiple-add-outline","people-add-outline","account-multiple-add-outline","accounts-add-outline","user-multiple-add-outline","users-add-outline","invite"],
    'mdiAccountMultipleRemove': ["user-multiple-remove","person-multiple-remove"],
    'mdiAccountMultipleRemoveOutline': ["user-multiple-remove-outline","person-multiple-remove-outline"],
    'mdiAccountMusic': ["artist"],
    'mdiAccountMusicOutline': ["artist-outline"],
    'mdiAccountNetwork': ["user-network","person-network"],
    'mdiAccountNetworkOutline': ["user-network-outline","person-network-outline"],
    'mdiAccountOff': ["user-off","person-off"],
    'mdiAccountOffOutline': ["user-off-outline","person-off-outline"],
    'mdiAccountOutline': ["user-outline","perm-identity","person-outline"],
    'mdiAccountPlus': ["register","user-plus","person-add","account-add","person-plus","user-add","invite"],
    'mdiAccountPlusOutline': ["person-add-outline","register-outline","user-plus-outline","account-add-outline","person-plus-outline","user-add-outline","invite"],
    'mdiAccountQuestion': ["user-help","account-question-mark","account-help","user-question","person-question","person-help"],
    'mdiAccountQuestionOutline': ["account-question-mark-outline","user-help-outline","account-help-outline","user-question-outline","person-question-outline","person-help-outline"],
    'mdiAccountRemove': ["user-remove","person-remove"],
    'mdiAccountRemoveOutline': ["user-remove-outline","person-remove-outline"],
    'mdiAccountSchool': ["account-student","account-graduation"],
    'mdiAccountSchoolOutline': ["account-student-outline","account-graduation-outline"],
    'mdiAccountSearch': ["user-search","person-search"],
    'mdiAccountSearchOutline': ["user-search-outline","person-search-outline"],
    'mdiAccountSettings': ["user-settings","person-settings"],
    'mdiAccountStar': ["user-star","person-star","account-favorite"],
    'mdiAccountStarOutline': ["user-star-outline","person-star-outline"],
    'mdiAccountSupervisor': ["user-supervisor","person-supervisor"],
    'mdiAccountSupervisorCircle': ["user-supervisor-circle","person-supervisor-circle"],
    'mdiAccountSwitch': ["user-switch","accounts-switch","users-switch","person-switch","people-switch"],
    'mdiAccountSync': ["account-cache"],
    'mdiAccountSyncOutline': ["account-cache-outline"],
    'mdiAccountTie': ["person-tie","user-tie"],
    'mdiAccountTieHat': ["account-pilot"],
    'mdiAccountTieHatOutline': ["account-pilot-outline"],
    'mdiAccountTieWoman': ["business-woman"],
    'mdiAccountVoice': ["record-voice-over","speak","talk","speaking","talking"],
    'mdiAccountWrench': ["account-service"],
    'mdiAccountWrenchOutline': ["account-service-outline"],
    'mdiAdvertisements': ["ads"],
    'mdiAdvertisementsOff': ["ads-off"],
    'mdiAirConditioner': ["ac-unit"],
    'mdiAirFilter': ["water-filter","filter"],
    'mdiAirHumidifierOff': ["air-dehumidifier"],
    'mdiAirballoon': ["hot-air-balloon"],
    'mdiAirballoonOutline': ["hot-air-balloon-outline"],
    'mdiAirplane': ["aeroplane","airplanemode-active","flight","local-airport","flight-mode","plane"],
    'mdiAirplaneCheck': ["airplace-success","airplane-tick"],
    'mdiAirplaneClock': ["airplane-schedule","airplane-time","airplane-date"],
    'mdiAirplaneCog': ["airplane-settings"],
    'mdiAirplaneLanding': ["aeroplane-landing","flight-land","plane-landing"],
    'mdiAirplaneMarker': ["airplane-location","airplane-gps"],
    'mdiAirplaneOff': ["aeroplane-off","airplanemode-inactive","flight-mode-off","plane-off"],
    'mdiAirplaneSearch': ["airplane-find"],
    'mdiAirplaneTakeoff': ["aeroplane-takeoff","flight-takeoff","plane-takeoff","airplane-take-off"],
    'mdiAlarm': ["access-alarms","alarm-clock"],
    'mdiAlarmCheck': ["alarm-on","alarm-tick","alarm-clock-check","alarm-clock-tick","alarm-success"],
    'mdiAlarmMultiple': ["alarms","alarm-clock-multiple","alarm-clocks"],
    'mdiAlarmOff': ["alarm-clock-off"],
    'mdiAlarmPlus': ["add-alarm","alarm-clock-plus","alarm-clock-add","alarm-add"],
    'mdiAlarmSnooze': ["alarm-clock-snooze"],
    'mdiAlbum': ["vinyl","record"],
    'mdiAlert': ["warning","report-problem"],
    'mdiAlertBox': ["warning-box"],
    'mdiAlertBoxOutline': ["warning-box-outline"],
    'mdiAlertCircle': ["warning-circle","error"],
    'mdiAlertCircleCheck': ["alert-circle-success"],
    'mdiAlertCircleCheckOutline': ["alert-circle-success-outline"],
    'mdiAlertCircleOutline': ["warning-circle-outline","error-outline","git-issue"],
    'mdiAlertDecagram': ["new-releases","warning-decagram"],
    'mdiAlertDecagramOutline': ["warning-decagram-outline"],
    'mdiAlertOctagon': ["warning-octagon","report","stop-alert"],
    'mdiAlertOctagonOutline': ["warning-octagon-outline","stop-alert-outline"],
    'mdiAlertOctagram': ["warning-octagram"],
    'mdiAlertOctagramOutline': ["warning-octagram-outline"],
    'mdiAlertOutline': ["warning-outline"],
    'mdiAlignHorizontalCenter': ["align-horizontal-centre"],
    'mdiAlignVerticalCenter': ["align-vertical-centre"],
    'mdiAllInclusive': ["infinity","forever"],
    'mdiAllInclusiveBox': ["infinity-box","forever-box"],
    'mdiAllInclusiveBoxOutline': ["forever-box-outline","infinity-box-outline"],
    'mdiAllergy': ["hand","rash","germ"],
    'mdiAlphaA': ["alphabet-a","letter-a"],
    'mdiAlphaABox': ["alphabet-a-box","letter-a-box"],
    'mdiAlphaABoxOutline': ["alphabet-a-box-outline","letter-a-box-outline"],
    'mdiAlphaACircle': ["alphabet-a-circle","letter-a-circle"],
    'mdiAlphaACircleOutline': ["alphabet-a-circle-outline","letter-a-circle-outline"],
    'mdiAlphaB': ["alphabet-b","letter-b"],
    'mdiAlphaBBox': ["alphabet-b-box","letter-b-box"],
    'mdiAlphaBBoxOutline': ["alphabet-b-box-outline","letter-b-box-outline"],
    'mdiAlphaBCircle': ["alphabet-b-circle","letter-b-circle"],
    'mdiAlphaBCircleOutline': ["alphabet-b-circle-outline","letter-b-circle-outline"],
    'mdiAlphaC': ["alphabet-c","letter-c"],
    'mdiAlphaCBox': ["alphabet-c-box","letter-c-box"],
    'mdiAlphaCBoxOutline': ["alphabet-c-box-outline","letter-c-box-outline"],
    'mdiAlphaCCircle': ["alphabet-c-circle","letter-c-circle"],
    'mdiAlphaCCircleOutline': ["alphabet-c-circle-outline","letter-c-circle-outline"],
    'mdiAlphaD': ["alphabet-d","letter-d","drive"],
    'mdiAlphaDBox': ["alphabet-d-box","letter-d-box"],
    'mdiAlphaDBoxOutline': ["alphabet-d-box-outline","letter-d-box-outline"],
    'mdiAlphaDCircle': ["alphabet-d-circle","letter-d-circle"],
    'mdiAlphaDCircleOutline': ["alphabet-d-circle-outline","letter-d-circle-outline"],
    'mdiAlphaE': ["alphabet-e","letter-e"],
    'mdiAlphaEBox': ["alphabet-e-box","letter-e-box"],
    'mdiAlphaEBoxOutline': ["alphabet-e-box-outline","letter-e-box-outline"],
    'mdiAlphaECircle': ["alphabet-e-circle","letter-e-circle"],
    'mdiAlphaECircleOutline': ["alphabet-e-circle-outline","letter-e-circle-outline"],
    'mdiAlphaF': ["alphabet-f","letter-f"],
    'mdiAlphaFBox': ["alphabet-f-box","letter-f-box"],
    'mdiAlphaFBoxOutline': ["alphabet-f-box-outline","letter-f-box-outline"],
    'mdiAlphaFCircle': ["alphabet-f-circle","letter-f-circle"],
    'mdiAlphaFCircleOutline': ["alphabet-f-circle-outline","letter-f-circle-outline"],
    'mdiAlphaG': ["alphabet-g","letter-g"],
    'mdiAlphaGBox': ["alphabet-g-box","letter-g-box"],
    'mdiAlphaGBoxOutline': ["alphabet-g-box-outline","letter-g-box-outline"],
    'mdiAlphaGCircle': ["alphabet-g-circle","letter-g-circle"],
    'mdiAlphaGCircleOutline': ["alphabet-g-circle-outline","letter-g-circle-outline"],
    'mdiAlphaH': ["alphabet-h","letter-h"],
    'mdiAlphaHBox': ["alphabet-h-box","letter-h-box"],
    'mdiAlphaHBoxOutline': ["alphabet-h-box-outline","letter-h-box-outline"],
    'mdiAlphaHCircle': ["alphabet-h-circle","letter-h-circle"],
    'mdiAlphaHCircleOutline': ["alphabet-h-circle-outline","letter-h-circle-outline","helipad"],
    'mdiAlphaI': ["alphabet-i","letter-i","roman-numeral-1"],
    'mdiAlphaIBox': ["alphabet-i-box","letter-i-box"],
    'mdiAlphaIBoxOutline': ["alphabet-i-box-outline","letter-i-box-outline"],
    'mdiAlphaICircle': ["alphabet-i-circle","letter-i-circle"],
    'mdiAlphaICircleOutline': ["alphabet-i-circle-outline","letter-i-circle-outline"],
    'mdiAlphaJ': ["alphabet-j","letter-j"],
    'mdiAlphaJBox': ["alphabet-j-box","letter-j-box"],
    'mdiAlphaJBoxOutline': ["alphabet-j-box-outline","letter-j-box-outline"],
    'mdiAlphaJCircle': ["alphabet-j-circle","letter-j-circle"],
    'mdiAlphaJCircleOutline': ["alphabet-j-circle-outline","letter-j-circle-outline"],
    'mdiAlphaK': ["alphabet-k","letter-k"],
    'mdiAlphaKBox': ["alphabet-k-box","letter-k-box"],
    'mdiAlphaKBoxOutline': ["alphabet-k-box-outline","letter-k-box-outline"],
    'mdiAlphaKCircle': ["alphabet-k-circle","letter-k-circle"],
    'mdiAlphaKCircleOutline': ["alphabet-k-circle-outline","letter-k-circle-outline"],
    'mdiAlphaL': ["alphabet-l","letter-l"],
    'mdiAlphaLBox': ["alphabet-l-box","letter-l-box"],
    'mdiAlphaLBoxOutline': ["alphabet-l-box-outline","letter-l-box-outline"],
    'mdiAlphaLCircle': ["alphabet-l-circle","letter-l-circle"],
    'mdiAlphaLCircleOutline': ["alphabet-l-circle-outline","letter-l-circle-outline"],
    'mdiAlphaM': ["alphabet-m","letter-m"],
    'mdiAlphaMBox': ["alphabet-m-box","letter-m-box"],
    'mdiAlphaMBoxOutline': ["alphabet-m-box-outline","letter-m-box-outline"],
    'mdiAlphaMCircle': ["alphabet-m-circle","letter-m-circle"],
    'mdiAlphaMCircleOutline': ["alphabet-m-circle-outline","letter-m-circle-outline"],
    'mdiAlphaN': ["alphabet-n","letter-n","neutral"],
    'mdiAlphaNBox': ["alphabet-n-box","letter-n-box"],
    'mdiAlphaNBoxOutline': ["alphabet-n-box-outline","letter-n-box-outline"],
    'mdiAlphaNCircle': ["alphabet-n-circle","letter-n-circle"],
    'mdiAlphaNCircleOutline': ["alphabet-n-circle-outline","letter-n-circle-outline"],
    'mdiAlphaO': ["alphabet-o","letter-o"],
    'mdiAlphaOBox': ["alphabet-o-box","letter-o-box"],
    'mdiAlphaOBoxOutline': ["alphabet-o-box-outline","letter-o-box-outline"],
    'mdiAlphaOCircle': ["alphabet-o-circle","letter-o-circle"],
    'mdiAlphaOCircleOutline': ["alphabet-o-circle-outline","letter-o-circle-outline"],
    'mdiAlphaP': ["alphabet-p","letter-p","park"],
    'mdiAlphaPBox': ["alphabet-p-box","letter-p-box"],
    'mdiAlphaPBoxOutline': ["alphabet-p-box-outline","letter-p-box-outline"],
    'mdiAlphaPCircle': ["alphabet-p-circle","letter-p-circle"],
    'mdiAlphaPCircleOutline': ["alphabet-p-circle-outline","letter-p-circle-outline"],
    'mdiAlphaQ': ["alphabet-q","letter-q"],
    'mdiAlphaQBox': ["alphabet-q-box","letter-q-box"],
    'mdiAlphaQBoxOutline': ["alphabet-q-box-outline","letter-q-box-outline"],
    'mdiAlphaQCircle': ["alphabet-q-circle","letter-q-circle"],
    'mdiAlphaQCircleOutline': ["alphabet-q-circle-outline","letter-q-circle-outline"],
    'mdiAlphaR': ["alphabet-r","letter-r","reverse"],
    'mdiAlphaRBox': ["alphabet-r-box","letter-r-box"],
    'mdiAlphaRBoxOutline': ["alphabet-r-box-outline","letter-r-box-outline"],
    'mdiAlphaRCircle': ["alphabet-r-circle","letter-r-circle"],
    'mdiAlphaRCircleOutline': ["alphabet-r-circle-outline","letter-r-circle-outline"],
    'mdiAlphaS': ["alphabet-s","letter-s"],
    'mdiAlphaSBox': ["alphabet-s-box","letter-s-box"],
    'mdiAlphaSBoxOutline': ["alphabet-s-box-outline","letter-s-box-outline"],
    'mdiAlphaSCircle': ["alphabet-s-circle","letter-s-circle"],
    'mdiAlphaSCircleOutline': ["alphabet-s-circle-outline","letter-s-circle-outline"],
    'mdiAlphaT': ["alphabet-t","letter-t"],
    'mdiAlphaTBox': ["alphabet-t-box","letter-t-box"],
    'mdiAlphaTBoxOutline': ["alphabet-t-box-outline","letter-t-box-outline"],
    'mdiAlphaTCircle': ["alphabet-t-circle","letter-t-circle"],
    'mdiAlphaTCircleOutline': ["alphabet-t-circle-outline","letter-t-circle-outline"],
    'mdiAlphaU': ["alphabet-u","letter-u"],
    'mdiAlphaUBox': ["alphabet-u-box","letter-u-box"],
    'mdiAlphaUBoxOutline': ["alphabet-u-box-outline","letter-u-box-outline"],
    'mdiAlphaUCircle': ["alphabet-u-circle","letter-u-circle"],
    'mdiAlphaUCircleOutline': ["alphabet-u-circle-outline","letter-u-circle-outline"],
    'mdiAlphaV': ["alphabet-v","letter-v","roman-numeral-5"],
    'mdiAlphaVBox': ["alphabet-v-box","letter-v-box"],
    'mdiAlphaVBoxOutline': ["alphabet-v-box-outline","letter-v-box-outline"],
    'mdiAlphaVCircle': ["alphabet-v-circle","letter-v-circle"],
    'mdiAlphaVCircleOutline': ["alphabet-v-circle-outline","letter-v-circle-outline"],
    'mdiAlphaW': ["alphabet-w","letter-w"],
    'mdiAlphaWBox': ["alphabet-w-box","letter-w-box"],
    'mdiAlphaWBoxOutline': ["alphabet-w-box-outline","letter-w-box-outline"],
    'mdiAlphaWCircle': ["alphabet-w-circle","letter-w-circle"],
    'mdiAlphaWCircleOutline': ["alphabet-w-circle-outline","letter-w-circle-outline"],
    'mdiAlphaX': ["alphabet-x","letter-x","roman-numeral-10"],
    'mdiAlphaXBox': ["alphabet-x-box","letter-x-box"],
    'mdiAlphaXBoxOutline': ["alphabet-x-box-outline","letter-x-box-outline"],
    'mdiAlphaXCircle': ["alphabet-x-circle","letter-x-circle"],
    'mdiAlphaXCircleOutline': ["alphabet-x-circle-outline","letter-x-circle-outline"],
    'mdiAlphaY': ["alphabet-y","letter-y"],
    'mdiAlphaYBox': ["alphabet-y-box","letter-y-box"],
    'mdiAlphaYBoxOutline': ["alphabet-y-box-outline","letter-y-box-outline"],
    'mdiAlphaYCircle': ["alphabet-y-circle","letter-y-circle"],
    'mdiAlphaYCircleOutline': ["alphabet-y-circle-outline","letter-y-circle-outline"],
    'mdiAlphaZ': ["alphabet-z","letter-z"],
    'mdiAlphaZBox': ["alphabet-z-box","letter-z-box"],
    'mdiAlphaZBoxOutline': ["alphabet-z-box-outline","letter-z-box-outline"],
    'mdiAlphaZCircle': ["alphabet-z-circle","letter-z-circle"],
    'mdiAlphaZCircleOutline': ["alphabet-z-circle-outline","letter-z-circle-outline"],
    'mdiAlphabetAurebesh': ["writing-system-aurebesh"],
    'mdiAlphabetCyrillic': ["writing-system-cyrillic"],
    'mdiAlphabetGreek': ["writing-system-greek"],
    'mdiAlphabetLatin': ["writing-system-latin"],
    'mdiAlphabetPiqad': ["writing-system-piqad"],
    'mdiAlphabetTengwar': ["writing-system-tengwar"],
    'mdiAlphabetical': ["letters","a-b-c","abc"],
    'mdiAlphabeticalOff': ["letters-off","abc-off","a-b-c-off"],
    'mdiAlphabeticalVariant': ["letters","abc","a-b-c"],
    'mdiAlphabeticalVariantOff': ["letters-off","abc-off","a-b-c-off"],
    'mdiAmmunition': ["bullets"],
    'mdiAmpersand': ["and"],
    'mdiAnimation': ["auto-awesome-motion"],
    'mdiApplication': ["iframe"],
    'mdiApplicationArray': ["iframe-array"],
    'mdiApplicationArrayOutline': ["iframe-array-outline"],
    'mdiApplicationBraces': ["iframe-braces"],
    'mdiApplicationBracesOutline': ["iframe-braces-outline"],
    'mdiApplicationBrackets': ["iframe-brackets"],
    'mdiApplicationBracketsOutline': ["iframe-brackets-outline"],
    'mdiApplicationCog': ["iframe-cog"],
    'mdiApplicationCogOutline': ["application-settings","iframe-cog-outline"],
    'mdiApplicationEdit': ["iframe-edit"],
    'mdiApplicationEditOutline': ["iframe-edit-outline"],
    'mdiApplicationExport': ["iframe-export-outline"],
    'mdiApplicationImport': ["iframe-import-outline"],
    'mdiApplicationOutline': ["web-asset","iframe-outline"],
    'mdiApplicationParentheses': ["iframe-parentheses"],
    'mdiApplicationParenthesesOutline': ["iframe-parentheses-outline"],
    'mdiApplicationSettings': ["iframe-settings"],
    'mdiApplicationSettingsOutline': ["iframe-settings-outline"],
    'mdiApplicationVariable': ["iframe-variable"],
    'mdiApplicationVariableOutline': ["iframe-variable-outline"],
    'mdiArchive': ["box"],
    'mdiArchiveAlert': ["box-alert"],
    'mdiArchiveAlertOutline': ["box-alert-outline"],
    'mdiArchiveArrowDown': ["box-arrow-down","this-side-down"],
    'mdiArchiveArrowDownOutline': ["box-arrow-down","this-side-down-outline"],
    'mdiArchiveArrowUp': ["box-arrow-up","this-side-up"],
    'mdiArchiveArrowUpOutline': ["box-arrow-up-outline","this-side-up-outline"],
    'mdiArchiveCancel': ["box-cancel"],
    'mdiArchiveCancelOutline': ["box-cancel-outline"],
    'mdiArchiveCheck': ["box-check","archive-success","box-success"],
    'mdiArchiveCheckOutline': ["box-check-outline","archive-success-outline","box-success-outline"],
    'mdiArchiveClock': ["box-clock","box-time","archive-time"],
    'mdiArchiveClockOutline': ["box-clock-outline","box-time-outline","archive-time-outline"],
    'mdiArchiveCog': ["box-cog"],
    'mdiArchiveCogOutline': ["box-cog-outline"],
    'mdiArchiveEdit': ["box-edit"],
    'mdiArchiveEditOutline': ["box-edit-outline"],
    'mdiArchiveEye': ["archive-view","box-eye","box-view"],
    'mdiArchiveEyeOutline': ["archive-view-outline","box-eye-outline","box-view-outline"],
    'mdiArchiveLock': ["box-lock"],
    'mdiArchiveLockOpen': ["box-lock-open"],
    'mdiArchiveLockOpenOutline': ["box-lock-open-outline"],
    'mdiArchiveLockOutline': ["box-lock-outline"],
    'mdiArchiveMarker': ["archive-location","box-marker","box-location"],
    'mdiArchiveMarkerOutline': ["archive-location-outline","box-marker-outline","box-location-outline"],
    'mdiArchiveMinus': ["box-minus"],
    'mdiArchiveMinusOutline': ["box-minus-outline"],
    'mdiArchiveMusic': ["box-music"],
    'mdiArchiveMusicOutline': ["box-music-outline"],
    'mdiArchiveOff': ["box-off"],
    'mdiArchiveOffOutline': ["box-off-outline"],
    'mdiArchiveOutline': ["box-outline"],
    'mdiArchivePlus': ["archive-add","box-plus","box-add"],
    'mdiArchivePlusOutline': ["archive-add-outline","box-plus-outline","box-add-outline"],
    'mdiArchiveRefresh': ["box-refresh"],
    'mdiArchiveRefreshOutline': ["box-refresh-outline"],
    'mdiArchiveRemove': ["box-remove"],
    'mdiArchiveRemoveOutline': ["box-remove-outline"],
    'mdiArchiveSearch': ["box-search"],
    'mdiArchiveSearchOutline': ["box-search-outline"],
    'mdiArchiveSettings': ["box-settings"],
    'mdiArchiveSettingsOutline': ["box-settings-outline"],
    'mdiArchiveStar': ["archive-favorite","box-star","box-favorite"],
    'mdiArchiveStarOutline': ["archive-favorite-outline","box-star-outline","box-favorite-outline"],
    'mdiArchiveSync': ["box-sync"],
    'mdiArchiveSyncOutline': ["box-sync-outline"],
    'mdiArrowBottomLeft': ["arrow-down-left"],
    'mdiArrowBottomLeftBoldOutline': ["arrow-down-left-bold-outline"],
    'mdiArrowBottomLeftThick': ["arrow-down-left-thick","arrow-bottom-left-bold","arrow-down-left-bold"],
    'mdiArrowBottomRight': ["arrow-down-right"],
    'mdiArrowBottomRightBoldOutline': ["arrow-down-right-bold-outline"],
    'mdiArrowBottomRightThick': ["arrow-down-right-thick","arrow-bottom-right-bold","arrow-down-right-bold"],
    'mdiArrowCollapse': ["arrow-compress"],
    'mdiArrowCollapseAll': ["arrow-compress-all"],
    'mdiArrowCollapseDown': ["arrow-compress-down"],
    'mdiArrowCollapseLeft': ["arrow-compress-left"],
    'mdiArrowCollapseRight': ["arrow-compress-right"],
    'mdiArrowCollapseUp': ["arrow-compress-up"],
    'mdiArrowCollapseVertical': ["compress"],
    'mdiArrowDecision': ["proxy"],
    'mdiArrowDecisionAuto': ["proxy-auto"],
    'mdiArrowDecisionAutoOutline': ["proxy-auto-outline"],
    'mdiArrowDecisionOutline': ["proxy-outline"],
    'mdiArrowDown': ["arrow-downward","arrow-bottom"],
    'mdiArrowDownBold': ["arrow-bottom-bold"],
    'mdiArrowDownBoldBox': ["arrow-bottom-bold-box"],
    'mdiArrowDownBoldBoxOutline': ["arrow-bottom-bold-box-outline"],
    'mdiArrowDownBoldCircle': ["arrow-bottom-bold-circle"],
    'mdiArrowDownBoldCircleOutline': ["arrow-bottom-bold-circle-outline"],
    'mdiArrowDownBoldHexagonOutline': ["arrow-bottom-bold-hexagon-outline"],
    'mdiArrowDownBoldOutline': ["arrow-bottom-bold-outline"],
    'mdiArrowDownBox': ["arrow-bottom-box"],
    'mdiArrowDownCircle': ["arrow-bottom-circle"],
    'mdiArrowDownCircleOutline': ["arrow-bottom-circle-outline"],
    'mdiArrowDownDropCircle': ["arrow-drop-down-circle","arrow-bottom-drop-circle"],
    'mdiArrowDownDropCircleOutline': ["arrow-bottom-drop-circle-outline"],
    'mdiArrowDownThick': ["arrow-bottom-thick","arrow-down-bold","arrow-bottom-bold"],
    'mdiArrowHorizontalLock': ["scroll-horizontal-lock"],
    'mdiArrowLeft': ["arrow-back"],
    'mdiArrowLeftCircle': ["arrow-back-circle"],
    'mdiArrowLeftThick': ["arrow-left-bold"],
    'mdiArrowLeftTop': ["turn-left"],
    'mdiArrowLeftTopBold': ["turn-left-bold"],
    'mdiArrowRight': ["arrow-forward"],
    'mdiArrowRightCircle': ["arrow-forward-circle"],
    'mdiArrowRightThick': ["arrow-right-bold"],
    'mdiArrowRightTop': ["turn-right"],
    'mdiArrowRightTopBold': ["turn-right-bold"],
    'mdiArrowSplitHorizontal': ["resize-vertical","resize"],
    'mdiArrowSplitVertical': ["resize-horizontal","resize"],
    'mdiArrowTopLeft': ["arrow-up-left"],
    'mdiArrowTopLeftBoldOutline': ["arrow-up-left-bold-outline"],
    'mdiArrowTopLeftThick': ["arrow-up-left-thick","arrow-top-left-bold","arrow-up-left-bold"],
    'mdiArrowTopRight': ["arrow-up-right"],
    'mdiArrowTopRightBoldOutline': ["arrow-up-right-bold-outline"],
    'mdiArrowTopRightThick': ["arrow-up-right-thick","arrow-top-right-bold","arrow-up-right-bold"],
    'mdiArrowUDownLeft': ["u-turn-left"],
    'mdiArrowUDownLeftBold': ["u-turn-left-bold"],
    'mdiArrowUDownRight': ["u-turn-right"],
    'mdiArrowUDownRightBold': ["u-turn-right-bold"],
    'mdiArrowULeftBottom': ["undo"],
    'mdiArrowULeftBottomBold': ["undo"],
    'mdiArrowULeftTop': ["undo"],
    'mdiArrowULeftTopBold': ["undo"],
    'mdiArrowURightBottom': ["redo"],
    'mdiArrowURightBottomBold': ["redo"],
    'mdiArrowURightTop': ["redo"],
    'mdiArrowURightTopBold': ["redo"],
    'mdiArrowUp': ["arrow-upward","arrow-top"],
    'mdiArrowUpBold': ["arrow-top-bold"],
    'mdiArrowUpBoldBox': ["arrow-top-bold-box"],
    'mdiArrowUpBoldBoxOutline': ["arrow-top-bold-box-outline"],
    'mdiArrowUpBoldCircle': ["arrow-top-bold-circle"],
    'mdiArrowUpBoldCircleOutline': ["arrow-top-bold-circle-outline"],
    'mdiArrowUpBoldHexagonOutline': ["arrow-top-bold-hexagon-outline"],
    'mdiArrowUpBoldOutline': ["arrow-top-bold-outline"],
    'mdiArrowUpCircle': ["arrow-top-circle"],
    'mdiArrowUpCircleOutline': ["arrow-top-circle-outline"],
    'mdiArrowUpDropCircle': ["arrow-top-drop-circle"],
    'mdiArrowUpDropCircleOutline': ["arrow-top-drop-circle-outline"],
    'mdiArrowUpThick': ["arrow-top-thick","arrow-up-bold","arrow-top-bold"],
    'mdiArrowVerticalLock': ["scroll-vertical-lock"],
    'mdiArtboard': ["canvas","frame"],
    'mdiAsterisk': ["required"],
    'mdiAsteriskCircleOutline': ["required-circle"],
    'mdiAt': ["alternate-email"],
    'mdiAtomVariant': ["orbit"],
    'mdiAttachment': ["paperclip-horizontal"],
    'mdiAttachmentCheck': ["attachment-tick","paperclip-check","paperclip-tick"],
    'mdiAttachmentLock': ["paperclip-lock"],
    'mdiAttachmentMinus': ["paperclip-minus","paperclip-subtract","attachment-subtract"],
    'mdiAttachmentOff': ["paperclip-off"],
    'mdiAttachmentPlus': ["paperclip-plus","paperclip-add","attachment-add"],
    'mdiAttachmentRemove': ["paperclip-remove"],
    'mdiAtv': ["quad","trike","two-wheeler","all-terrain-vehicle"],
    'mdiAudioVideo': ["av-receiver"],
    'mdiAudioVideoOff': ["av-receiver-off"],
    'mdiAurora': ["aurora-borealis","aurora-australis","northern-lights","southern-lights","polar-lights"],
    'mdiAutoFix': ["magic","wand","auto-fix-high"],
    'mdiAutorenew': ["clockwise-arrows","circular-arrows","circle-arrows","sync"],
    'mdiAutorenewOff': ["clockwise-arrows-off","circular-arrows-off","circle-arrows-off","sync-off"],
    'mdiAwning': ["marquise","sun-shade"],
    'mdiAwningOutline': ["marquise-outline","sun-shade-outline"],
    'mdiAxisArrow': ["accelerometer","gyro"],
    'mdiAxisZRotateClockwise': ["vertical-rotate-clockwise"],
    'mdiAxisZRotateCounterclockwise': ["vertical-rotate-counterclockwise"],
    'mdiBabyBuggy': ["stroller","pram","carriage"],
    'mdiBabyCarriage': ["child-friendly","stroller","pram","buggy"],
    'mdiBabyCarriageOff': ["child-friendly-off","stroller-off","pram-off","buggy-off"],
    'mdiBabyFace': ["emoji-baby","emoticon-baby"],
    'mdiBabyFaceOutline': ["emoji-baby-outline","emoticon-baby-outline"],
    'mdiBackburger': ["hamburger-menu-back"],
    'mdiBackspace': ["erase","clear"],
    'mdiBackspaceOutline': ["erase-outline","clear-outline"],
    'mdiBackspaceReverse': ["clear-reverse","erase-reverse"],
    'mdiBackspaceReverseOutline': ["clear-reverse-outline","erase-reverse-outline"],
    'mdiBackupRestore': ["settings-backup-restore"],
    'mdiBadgeAccount': ["user-badge","person-badge"],
    'mdiBadgeAccountAlert': ["user-badge-alert","person-badge-alert","account-badge-warning","user-badge-warning","person-badge-warning"],
    'mdiBadgeAccountAlertOutline': ["user-badge-alert-outline","person-badge-alert-outline","account-badge-warning-outline","user-badge-warning-outline","person-badge-warning-outline"],
    'mdiBadgeAccountOutline': ["user-badge-outline","person-badge-outline"],
    'mdiBadminton': ["shuttlecock"],
    'mdiBagCarryOn': ["carry-on-luggage"],
    'mdiBagCarryOnCheck': ["carry-on-bag-tick","carry-on-bag-check"],
    'mdiBagCarryOnOff': ["carry-on-luggage-off"],
    'mdiBagChecked': ["luggage"],
    'mdiBagPersonal': ["backpack"],
    'mdiBagPersonalOff': ["backpack-off"],
    'mdiBagPersonalOffOutline': ["backpack-off-outline"],
    'mdiBagPersonalOutline': ["backpack-outline"],
    'mdiBagPersonalPlus': ["bag-personal-add","backpack-add","backpack-plus"],
    'mdiBagPersonalPlusOutline': ["backpack-plus-outline","backpack-add-outline","bag-personal-add-outline"],
    'mdiBagPersonalTag': ["property-tag"],
    'mdiBagPersonalTagOutline': ["property-tag-outline"],
    'mdiBaguette': ["bread","bakery","french-baguette","loaf"],
    'mdiBalcony': ["terrace","patio","veranda"],
    'mdiBalloon': ["party-balloon"],
    'mdiBallot': ["vote"],
    'mdiBallotOutline': ["vote-outline"],
    'mdiBallotRecount': ["vote-recount"],
    'mdiBallotRecountOutline': ["vote-recount-outline"],
    'mdiBandage': ["band-aid","plaster"],
    'mdiBank': ["account-balance","museum"],
    'mdiBankOutline': ["museum-outline"],
    'mdiBankPlus': ["bank-add"],
    'mdiBarcodeScan': ["barcode-scanner"],
    'mdiBarley': ["grain","wheat","gluten"],
    'mdiBarleyOff': ["gluten-free","grain-off","wheat-off"],
    'mdiBarn': ["farm"],
    'mdiBarrel': ["oil-barrel","energy","fossil-fuel"],
    'mdiBarrelOutline': ["oil-barrel-outline","fossil-fuel-outline","energy-outline"],
    'mdiBasket': ["shopping-basket","skip"],
    'mdiBasketFill': ["skip-fill"],
    'mdiBasketMinus': ["shopping-basket-minus","skip-minus"],
    'mdiBasketMinusOutline': ["shopping-basket-minus-outline","skip-minus-outline"],
    'mdiBasketOff': ["shopping-basket-off","skip-off"],
    'mdiBasketOffOutline': ["shopping-basket-off-outline","skip-off-outline"],
    'mdiBasketOutline': ["shopping-basket-outline","skip-outline"],
    'mdiBasketPlus': ["shopping-basket-plus","skip-plus"],
    'mdiBasketPlusOutline': ["shopping-basket-plus-outline","skip-plus-outline"],
    'mdiBasketRemove': ["shopping-basket-remove","skip-remove"],
    'mdiBasketRemoveOutline': ["shopping-basket-remove-outline","skip-remove-outline"],
    'mdiBasketball': ["youtube-sports"],
    'mdiBattery': ["battery-full","battery-std","battery-100"],
    'mdiBatteryAlert': ["battery-warning"],
    'mdiBatteryAlertBluetooth': ["battery-warning-bluetooth"],
    'mdiBatteryBluetooth': ["battery-bluetooth-100","battery-bluetooth-full"],
    'mdiBatteryCharging': ["battery-charging-full"],
    'mdiBatteryChargingWireless': ["battery-charging-wireless-full","battery-charging-wireless-100"],
    'mdiBatteryChargingWirelessAlert': ["battery-charging-wireless-warning"],
    'mdiBatteryChargingWirelessOutline': ["battery-charging-wireless-empty","battery-charging-wireless-0"],
    'mdiBatteryClock': ["battery-full-clock","battery-100-clock"],
    'mdiBatteryClockOutline': ["batter-0-clock","battery-empty-clock"],
    'mdiBatteryOutline': ["battery-0","battery-empty"],
    'mdiBatteryPlusVariant': ["battery-saver","battery-add"],
    'mdiBatterySync': ["battery-saver","battery-recycle","battery-eco"],
    'mdiBatterySyncOutline': ["battery-saver-outline","battery-eco-outline","battery-recycle-outline"],
    'mdiBeach': ["parasol"],
    'mdiBed': ["hotel","guest-room"],
    'mdiBedClock': ["bed-schedule","bed-time","sleep-schedule","sleep-time"],
    'mdiBedDouble': ["bedroom"],
    'mdiBedDoubleOutline': ["bedroom-outline"],
    'mdiBedKing': ["bedroom"],
    'mdiBedKingOutline': ["bedroom-outline"],
    'mdiBedOutline': ["hotel-outline","guest-room-outline"],
    'mdiBedQueen': ["bedroom"],
    'mdiBedQueenOutline': ["bedroom-outline"],
    'mdiBedSingle': ["bedroom"],
    'mdiBedSingleOutline': ["bedroom-outline"],
    'mdiBee': ["fly","insect"],
    'mdiBeeFlower': ["fly-flower","nature"],
    'mdiBeehiveOutline': ["honey-outline"],
    'mdiBeekeeper': ["apiarists","apiculturists","honey-farmer"],
    'mdiBeer': ["pint","pub","bar","drink","cup-full"],
    'mdiBeerOutline': ["drink-outline","cup-full-outline","pint-outline","pub-outline","bar-outline"],
    'mdiBell': ["notifications"],
    'mdiBellAlert': ["bell-warning"],
    'mdiBellBadge': ["bell-notification"],
    'mdiBellBadgeOutline': ["bell-notification-outline"],
    'mdiBellCog': ["bell-settings","notification-settings"],
    'mdiBellCogOutline': ["bell-settings-outline","notification-settings-outline"],
    'mdiBellOff': ["notifications-off"],
    'mdiBellOutline': ["notifications-none"],
    'mdiBellPlus': ["add-alert","bell-add"],
    'mdiBellPlusOutline': ["bell-add-outline","add-alert-outline"],
    'mdiBellRing': ["notifications-active"],
    'mdiBellSleep': ["notifications-paused"],
    'mdiBiathlon': ["human-biathlon"],
    'mdiBicycle': ["bike","cycling"],
    'mdiBicycleBasket': ["bike-basket"],
    'mdiBicycleCargo': ["bike-cargo"],
    'mdiBicycleElectric': ["bike-electric"],
    'mdiBicyclePennyFarthing': ["bicycle-high-wheel","bicycle-antique"],
    'mdiBike': ["bicycle","cycling","directions-bike"],
    'mdiBikeFast': ["velocity"],
    'mdiBikePedal': ["bike-pedal-flat"],
    'mdiBilliards': ["pool","eight-ball"],
    'mdiBilliardsRack': ["pool-table","pool-rack","snooker-rack","pool-triangle","billiards-triangle","snooker-triangle"],
    'mdiBlender': ["food-processor"],
    'mdiBlenderOutline': ["food-processor-outline"],
    'mdiBlinds': ["roller-shade-closed","window-closed"],
    'mdiBlindsHorizontal': ["blinds-open","mini-blinds","window-open"],
    'mdiBlindsHorizontalClosed': ["mini-blinds","window-closed"],
    'mdiBlindsOpen': ["roller-shade-open","window-open"],
    'mdiBlindsVertical': ["window"],
    'mdiBlindsVerticalClosed': ["window-closed"],
    'mdiBluetoothAudio': ["bluetooth-searching"],
    'mdiBluetoothConnect': ["bluetooth-connected"],
    'mdiBluetoothOff': ["bluetooth-disabled"],
    'mdiBluetoothSettings': ["settings-bluetooth"],
    'mdiBlur': ["blur-on"],
    'mdiBlurRadial': ["blur-circular"],
    'mdiBook': ["git-repository"],
    'mdiBookAlphabet': ["dictionary"],
    'mdiBookClock': ["book-schedule","book-time"],
    'mdiBookClockOutline': ["book-schedule","book-time"],
    'mdiBookCog': ["book-settings"],
    'mdiBookCogOutline': ["book-settings-outline"],
    'mdiBookCross': ["bible"],
    'mdiBookHeart': ["book-favorite","book-love"],
    'mdiBookHeartOutline': ["book-favorite-outline","book-love-outline"],
    'mdiBookInformationVariant': ["encyclopedia"],
    'mdiBookLock': ["book-secure"],
    'mdiBookLockOpen': ["book-unsecure"],
    'mdiBookLockOutline': ["book-secure-outline"],
    'mdiBookMarker': ["book-location"],
    'mdiBookMarkerOutline': ["book-location-outline"],
    'mdiBookMinusMultiple': ["books-minus"],
    'mdiBookMultiple': ["books"],
    'mdiBookMusic': ["audio-book"],
    'mdiBookOpen': ["chrome-reader-mode"],
    'mdiBookOpenBlankVariant': ["import-contacts"],
    'mdiBookOpenPageVariant': ["auto-stories"],
    'mdiBookPlus': ["book-add"],
    'mdiBookPlusMultiple': ["books-plus","book-multiple-add","books-add"],
    'mdiBookRemoveMultiple': ["books-remove"],
    'mdiBookVariant': ["class"],
    'mdiBookmark': ["turned-in"],
    'mdiBookmarkBoxMultiple': ["collections-bookmark","library-bookmark"],
    'mdiBookmarkBoxMultipleOutline': ["collections-bookmark-outline","library-bookmark-outline"],
    'mdiBookmarkCheck': ["bookmark-tick","bookmark-success"],
    'mdiBookmarkCheckOutline': ["bookmark-success-outline"],
    'mdiBookmarkOutline': ["bookmark-border","turned-in-not"],
    'mdiBookmarkPlus': ["bookmark-add"],
    'mdiBookmarkPlusOutline': ["bookmark-add-outline"],
    'mdiBoomGate': ["boom-arm","boom-barrier","arm-barrier","barrier","automatic-gate"],
    'mdiBoomGateAlert': ["boom-arm-alert","boom-barrier-alert","arm-barrier-alert","barrier-alert","automatic-gate-alert"],
    'mdiBoomGateAlertOutline': ["boom-arm-alert-outline","boom-barrier-alert-outline","arm-barrier-alert-outline","barrier-alert-outline","automatic-gate-alert-outline"],
    'mdiBoomGateArrowDown': ["boom-arm-down","boom-barrier-down","arm-barrier-down","barrier-down","automatic-gate-down"],
    'mdiBoomGateArrowDownOutline': ["boom-arm-down-outline","boom-barrier-down-outline","arm-barrier-down-outline","barrier-down-outline","automatic-gate-down-outline"],
    'mdiBoomGateArrowUp': ["boom-arm-up","boom-barrier-up","arm-barrier-up","barrier-up","automatic-gate-up"],
    'mdiBoomGateArrowUpOutline': ["boom-arm-up-outline","boom-barrier-up-outline","arm-barrier-up-outline","barrier-up-outline","automatic-gate-up-outline"],
    'mdiBoomGateOutline': ["boom-arm-outline","boom-barrier-outline","arm-barrier-outline","barrier-outline","automatic-gate-outline"],
    'mdiBoomGateUp': ["boom-arm-up","boom-barrier-up","arm-barrier-up","barrier-up","automatic-gate-up"],
    'mdiBoomGateUpOutline': ["boom-arm-up-outline","boom-barrier-up-outline","arm-barrier-up-outline","barrier-up-outline","automatic-gate-up-outline"],
    'mdiBorderColor': ["border-colour"],
    'mdiBorderNone': ["border-clear"],
    'mdiBorderOutside': ["border-outer"],
    'mdiBorderRadius': ["border-round-corners"],
    'mdiBottleSoda': ["bottle-coke","bottle-pop"],
    'mdiBottleSodaClassic': ["bottle-coke-classic","bottle-pop-classic"],
    'mdiBottleSodaOutline': ["bottle-coke-outline","bottle-pop-outline"],
    'mdiBottleTonic': ["flask"],
    'mdiBottleTonicOutline': ["flask-outline"],
    'mdiBottleTonicPlus': ["health-potion"],
    'mdiBottleTonicPlusOutline': ["health-potion-outline"],
    'mdiBottleTonicSkull': ["poison","moonshine"],
    'mdiBottleTonicSkullOutline': ["poison-outline","moonshine-outline"],
    'mdiBowlMix': ["mixing-bowl"],
    'mdiBowlMixOutline': ["mixing-bowl-outline"],
    'mdiBoxCutter': ["stanley-knife"],
    'mdiBraille': ["touch-reading","hand-reading"],
    'mdiBriefcase': ["work"],
    'mdiBriefcaseAccount': ["briefcase-person","briefcase-user"],
    'mdiBriefcaseAccountOutline': ["briefcase-person-outline","briefcase-user-outline"],
    'mdiBriefcaseArrowLeftRight': ["briefcase-transfer","briefcase-exchange","briefcase-swap"],
    'mdiBriefcaseArrowLeftRightOutline': ["briefcase-exchange-outline","briefcase-transfer-outline","briefcase-swap-outline"],
    'mdiBriefcaseArrowUpDown': ["briefcase-exchange","briefcase-transfer","briefcase-swap"],
    'mdiBriefcaseArrowUpDownOutline': ["briefcase-exchange-outline","briefcase-transfer-outline","briefcase-swap-outline"],
    'mdiBriefcaseCheck': ["briefcase-tick"],
    'mdiBriefcaseEye': ["briefcase-view"],
    'mdiBriefcaseEyeOutline': ["briefcase-view-outline"],
    'mdiBriefcaseOutline': ["work-outline"],
    'mdiBriefcasePlus': ["briefcase-add"],
    'mdiBriefcasePlusOutline': ["briefcase-add-outline"],
    'mdiBrightness4': ["theme-light-dark"],
    'mdiBrightness5': ["brightness-low"],
    'mdiBrightness6': ["brightness-medium","theme-light-dark"],
    'mdiBrightness7': ["brightness-high"],
    'mdiBrightnessPercent': ["discount","sale"],
    'mdiBroadcast': ["signal"],
    'mdiBroadcastOff': ["signal-off"],
    'mdiBrush': ["paintbrush"],
    'mdiBrushOutline': ["paintbrush-outline"],
    'mdiBrushVariant': ["paintbrush"],
    'mdiBuffet': ["sideboard"],
    'mdiBug': ["bug-report"],
    'mdiBugCheck': ["bug-tick"],
    'mdiBugCheckOutline': ["bug-tick-outline"],
    'mdiBugPlay': ["bug-start"],
    'mdiBugle': ["car-horn"],
    'mdiBulletinBoard': ["notice-board"],
    'mdiBullhorn': ["announcement","megaphone","loudspeaker"],
    'mdiBullhornOutline': ["announcement-outline","megaphone-outline","loudspeaker-outline"],
    'mdiBullhornVariant': ["announcement","megaphone","loudspeaker"],
    'mdiBullhornVariantOutline': ["announcement-outline","megaphone-outline","loudspeaker-outline"],
    'mdiBullseye': ["target"],
    'mdiBullseyeArrow': ["target-arrow"],
    'mdiBus': ["directions-bus"],
    'mdiBusAlert': ["bus-warning"],
    'mdiBusClock': ["departure-board"],
    'mdiBusMarker': ["bus-location","bus-stop"],
    'mdiBusMultiple': ["fleet"],
    'mdiBusSchool': ["education"],
    'mdiCached': ["counterclockwise-arrows","circular-arrows","circle-arrows","sync"],
    'mdiCake': ["birthday-cake"],
    'mdiCakeLayered': ["birthday-cake"],
    'mdiCakeVariant': ["birthday-cake"],
    'mdiCakeVariantOutline': ["birthday-cake-outline"],
    'mdiCalendar': ["event","insert-invitation"],
    'mdiCalendarAccount': ["calendar-user"],
    'mdiCalendarAccountOutline': ["calendar-user-outline"],
    'mdiCalendarAlert': ["event-alert","calendar-warning"],
    'mdiCalendarArrowLeft': ["reschedule"],
    'mdiCalendarArrowRight': ["reschedule"],
    'mdiCalendarBlank': ["calendar-today"],
    'mdiCalendarBlankOutline': ["event-blank-outline"],
    'mdiCalendarCheck': ["event-available","calendar-task","calendar-tick","event-tick","event-check"],
    'mdiCalendarCheckOutline': ["event-available-outline","event-check-outline","event-tick-outline","calendar-task-outline","calendar-tick-outline"],
    'mdiCalendarClock': ["event-clock","event-time","calendar-time"],
    'mdiCalendarEdit': ["event-edit"],
    'mdiCalendarFilterOutline': ["event-week-end-outline"],
    'mdiCalendarHeart': ["event-heart"],
    'mdiCalendarMinus': ["event-minus"],
    'mdiCalendarMultiple': ["event-multiple","calendars","events"],
    'mdiCalendarMultipleCheck': ["event-multiple-check","calendar-multiple-tick","calendars-check","calendars-tick","event-multiple-tick","events-check","events-tick"],
    'mdiCalendarOutline': ["event-outline"],
    'mdiCalendarPlus': ["event-plus","calendar-add","event-add"],
    'mdiCalendarQuestion': ["calendar-rsvp","event-question","calendar-help"],
    'mdiCalendarQuestionOutline': ["calendar-help-outline"],
    'mdiCalendarRange': ["date-range","calendar-week","event-range"],
    'mdiCalendarRangeOutline': ["event-range-outline"],
    'mdiCalendarRefresh': ["calendar-repeat"],
    'mdiCalendarRefreshOutline': ["calendar-repeat-outline"],
    'mdiCalendarRemove': ["event-busy","event-remove"],
    'mdiCalendarRemoveOutline': ["event-busy-outline","event-remove-outline"],
    'mdiCalendarSearch': ["event-search"],
    'mdiCalendarStar': ["event-star","calendar-favorite"],
    'mdiCalendarStarFourPoints': ["calendar-auto","event-star-four-points","event-auto"],
    'mdiCalendarSync': ["calendar-repeat"],
    'mdiCalendarSyncOutline': ["calendar-repeat-outline"],
    'mdiCalendarText': ["event-note","event-text"],
    'mdiCalendarTextOutline': ["event-text-outline","event-note-outline"],
    'mdiCalendarToday': ["calendar-day"],
    'mdiCalendarTodayOutline': ["calendar-day-outline"],
    'mdiCalendarWeek': ["event-week"],
    'mdiCalendarWeekBegin': ["event-week-begin"],
    'mdiCalendarWeekBeginOutline': ["event-week-begin-outline"],
    'mdiCalendarWeekOutline': ["event-week-outline"],
    'mdiCallMerge': ["merge-type"],
    'mdiCamera': ["photography","camera-alt","local-see","photo-camera"],
    'mdiCameraAccount': ["camera-user"],
    'mdiCameraBurst': ["burst-mode"],
    'mdiCameraDocument': ["overhead-projector"],
    'mdiCameraDocumentOff': ["overhead-projector-off"],
    'mdiCameraFlip': ["camera-sync","camera-refresh"],
    'mdiCameraFlipOutline': ["camera-sync-outline","camera-refresh-outline"],
    'mdiCameraMarker': ["camera-location"],
    'mdiCameraMarkerOutline': ["camera-location-outline"],
    'mdiCameraMeteringCenter': ["camera-metering-centre"],
    'mdiCameraSwitch': ["switch-camera"],
    'mdiCancel': ["prohibited","ban","do-not-disturb-alt","denied","block","forbid","no","clear"],
    'mdiCandelabra': ["candle","candelabrum"],
    'mdiCandelabraFire': ["candelabrum-fire","candelabrum-flame","candelabra-flame","candle-fire","candle-flame"],
    'mdiCandle': ["candle-flame","candle-fire"],
    'mdiCandy': ["treat","chocolate"],
    'mdiCandyOff': ["chocolate-off","treat-off"],
    'mdiCandyOffOutline': ["chocolate-off-outline","treat-off-outline","navi-off"],
    'mdiCandyOutline': ["chocolate-outline","treat-outline","navi","hey-listen","fairy"],
    'mdiCannabis': ["weed","pot","marijuana"],
    'mdiCar': ["directions-car","drive-eta","time-to-leave"],
    'mdiCar2Plus': ["hov-lane","high-occupancy-vehicle-lane","carpool-lane"],
    'mdiCar3Plus': ["hov-lane","high-occupancy-vehicle-lane","carpool-lane"],
    'mdiCarBrakeAbs': ["anti-lock-brake-system","anti-lock-braking-system"],
    'mdiCarBrakeAlert': ["car-parking-brake","car-handbrake","car-hand-brake","car-emergency-brake","car-brake-warning"],
    'mdiCarCog': ["car-settings"],
    'mdiCarEmergency': ["car-police"],
    'mdiCarEsp': ["electronic-stability-program"],
    'mdiCarEstate': ["car-suv","car-sports-utility-vehicle"],
    'mdiCarKey': ["car-rental","rent-a-car"],
    'mdiCarLightDimmed': ["head-light-dimmed","low-beam"],
    'mdiCarLightFog': ["head-light-fog"],
    'mdiCarLightHigh': ["head-light-high","high-beam"],
    'mdiCarPickup': ["truck-pickup"],
    'mdiCarSearch': ["car-find"],
    'mdiCarSearchOutline': ["car-find-outline"],
    'mdiCarSelect': ["car-location"],
    'mdiCarShiftPattern': ["car-transmission","car-manual-transmission"],
    'mdiCarSide': ["car-saloon"],
    'mdiCarTireAlert': ["car-tyre-alert","car-tyre-warning","car-tire-warning"],
    'mdiCarWash': ["local-car-wash"],
    'mdiCarWindshield': ["car-front-glass"],
    'mdiCarWindshieldOutline': ["car-front-glass-outline"],
    'mdiCarWireless': ["car-autonomous","car-self-driving","car-smart"],
    'mdiCarWrench': ["car-repair","mechanic"],
    'mdiCarabiner': ["karabiner","rock-climbing"],
    'mdiCaravan': ["holiday","camping"],
    'mdiCard': ["button"],
    'mdiCardAccountDetails': ["identification-card","user-card-details","id-card","person-card-details","drivers-license","business-card"],
    'mdiCardAccountDetailsOutline': ["identification-card-outline","user-card-details-outline","id-card-outline","person-card-details-outline","drivers-license-outline","business-card-outline"],
    'mdiCardAccountDetailsStar': ["card-account-details-favorite"],
    'mdiCardAccountDetailsStarOutline': ["card-account-details-favorite-outline"],
    'mdiCardAccountMail': ["contact-mail"],
    'mdiCardAccountMailOutline': ["contact-mail-outline"],
    'mdiCardAccountPhone': ["contact-phone"],
    'mdiCardAccountPhoneOutline': ["contact-phone-outline"],
    'mdiCardOutline': ["button-outline"],
    'mdiCardSearch': ["pageview"],
    'mdiCardSearchOutline': ["pageview-outline"],
    'mdiCardsClub': ["suit-clubs","poker-club"],
    'mdiCardsDiamond': ["suit-diamonds","hov-lane","high-occupancy-vehicle-lane","carpool-lane","poker-diamond"],
    'mdiCardsDiamondOutline': ["hov-lane-outline","high-occupancy-vehicle-lane-outline","carpool-lane-outline","poker-diamond-outline"],
    'mdiCardsHeart': ["suit-hearts","poker-heart"],
    'mdiCardsSpade': ["suit-spades","poker-spade"],
    'mdiCart': ["trolley","local-grocery-store","shopping-cart"],
    'mdiCartArrowDown': ["shopping-cart-arrow-down","trolley-arrow-down"],
    'mdiCartArrowRight': ["trolley-arrow-right","shopping-cart-arrow-right"],
    'mdiCartArrowUp': ["shopping-cart-arrow-up","trolley-arrow-up"],
    'mdiCartHeart': ["cart-favorite","shopping-favorite"],
    'mdiCartMinus': ["shopping-cart-minus","trolley-minus"],
    'mdiCartOff': ["trolley-off","remove-shopping-cart","shopping-cart-off"],
    'mdiCartOutline': ["trolley-outline","shopping-cart-outline"],
    'mdiCartPercent': ["cart-discount","cart-sale","trolley-percent"],
    'mdiCartPlus': ["trolley-plus","add-shopping-cart","shopping-cart-plus","cart-add","trolley-add","shopping-cart-add"],
    'mdiCartRemove': ["trolley-remove","shopping-cart-remove"],
    'mdiCash': ["money"],
    'mdiCash100': ["money-100"],
    'mdiCashClock': ["cash-schedule","payment-schedule","payment-clock","auto-pay"],
    'mdiCashFast': ["instant-deposit","instant-transfer","instant-cash"],
    'mdiCashMarker': ["cod","cash-on-delivery","cash-location"],
    'mdiCashMultiple': ["money"],
    'mdiCashRefund': ["cash-return","cash-chargeback"],
    'mdiCashRegister': ["till"],
    'mdiCashSync': ["auto-pay","recurring-payment","scheduled-payment","cash-cycle"],
    'mdiCassette': ["tape"],
    'mdiCastAudio': ["cast-speaker"],
    'mdiCastAudioVariant': ["apple-airplay"],
    'mdiCastEducation': ["cast-school","school-online","cast-tutorial"],
    'mdiCastVariant': ["apple","airplay"],
    'mdiCat': ["emoji-cat","emoticon-cat"],
    'mdiCctv': ["closed-circuit-television","security-camera"],
    'mdiCctvOff': ["closed-circuit-television-off","security-camera-off"],
    'mdiCeilingFanLight': ["ceiling-fan-on"],
    'mdiCeilingLight': ["ceiling-lamp"],
    'mdiCeilingLightMultiple': ["ceiling-lamp-multiple"],
    'mdiCeilingLightMultipleOutline': ["ceiling-lamp-multiple-outline"],
    'mdiCellphone': ["mobile-phone","smartphone","stay-current-portrait","stay-primary-portrait"],
    'mdiCellphoneArrowDown': ["cellphone-system-update","mobile-phone-arrow-down","smartphone-arrow-down"],
    'mdiCellphoneArrowDownVariant': ["cellphone-download"],
    'mdiCellphoneBasic': ["mobile-phone-basic"],
    'mdiCellphoneCog': ["phonelink-setup","mobile-phone-settings-variant","smartphone-settings-variant"],
    'mdiCellphoneDock': ["mobile-phone-dock","smartphone-dock"],
    'mdiCellphoneInformation': ["mobile-phone-information","smartphone-information"],
    'mdiCellphoneKey': ["mobile-phone-key","smartphone-key"],
    'mdiCellphoneLink': ["mobile-phone-link","smartphone-link","devices"],
    'mdiCellphoneLinkOff': ["mobile-phone-link-off","smartphone-link-off","phonelink-off"],
    'mdiCellphoneLock': ["phonelink-lock","mobile-phone-lock","smartphone-lock"],
    'mdiCellphoneMarker': ["cellphone-location","cellphone-map","find-my-phone","cellphone-gps"],
    'mdiCellphoneMessage': ["mobile-phone-message","smartphone-message"],
    'mdiCellphoneOff': ["mobile-phone-off","smartphone-off","mobile-off"],
    'mdiCellphoneRemove': ["phonelink-erase","mobile-phone-erase","smartphone-erase","cellphone-erase"],
    'mdiCellphoneSettings': ["mobile-phone-settings","smartphone-settings","settings-cell"],
    'mdiCellphoneSound': ["phonelink-ring","mobile-phone-sound","smartphone-sound"],
    'mdiCellphoneText': ["mobile-phone-text","smartphone-text"],
    'mdiCellphoneWireless': ["mobile-phone-wireless","smartphone-wireless"],
    'mdiCertificate': ["diploma","seal"],
    'mdiCertificateOutline': ["diploma-outline","seal-outline"],
    'mdiChairRolling': ["office-chair","study-chair"],
    'mdiChairSchool': ["desk","education","learn"],
    'mdiChandelier': ["ceiling-light","girandole","candelabra-lamp","suspended-light"],
    'mdiCharity': ["super-chat-for-good"],
    'mdiChartArc': ["report-arc","widget-arc"],
    'mdiChartAreaspline': ["report-areaspline","widget-areaspline","graph-areaspline"],
    'mdiChartAreasplineVariant': ["report-areaspline-variant","widget-areaspline-variant","graph-areaspline-variant"],
    'mdiChartBar': ["report-bar","widget-bar","graph-bar"],
    'mdiChartBarStacked': ["report-bar-stacked","widget-bar-stacked","graph-bar-stacked"],
    'mdiChartBellCurve': ["report-bell-curve","widget-bell-curve","graph-bell-curve"],
    'mdiChartBellCurveCumulative': ["report-bell-curve-cumulative","widget-bell-curve-cumulative","graph-bell-curve-cumulative"],
    'mdiChartBox': ["poll-box","report-box","widget-box","graph-box"],
    'mdiChartBoxMultiple': ["poll-box-multiple","graph-box-multiple","widget-box-multiple","report-box-multiple"],
    'mdiChartBoxMultipleOutline': ["graph-box-multiple-outline","widget-box-multiple-outline","report-box-multiple-outline","poll-box-multiple-outline"],
    'mdiChartBoxOutline': ["poll-box-outline","report-box-outline","widget-box-outline","graph-box-outline"],
    'mdiChartBoxPlusOutline': ["report-box-plus-outline","widget-box-plus-outline","graph-box-plus-outline"],
    'mdiChartBubble': ["bubble-chart","report-bubble","widget-bubble"],
    'mdiChartDonut': ["chart-doughnut","data-usage","report-donut","widget-donut"],
    'mdiChartDonutVariant': ["chart-doughnut-variant","report-donut-variant","widget-donut-variant"],
    'mdiChartGantt': ["report-gantt","timeline","widget-gantt","roadmap"],
    'mdiChartHistogram': ["report-histogram","widget-histogram","graph-histogram"],
    'mdiChartLine': ["report-line","widget-line","graph-line"],
    'mdiChartLineStacked': ["report-line-stacked","widget-line-stacked","graph-line-stacked"],
    'mdiChartLineVariant': ["show-chart","report-line-variant","widget-line-variant","graph-line-variant"],
    'mdiChartMultiline': ["report-multiline","widget-multiline","graph-multiline"],
    'mdiChartMultiple': ["report-multiple","widget-multiple","graph-multiple"],
    'mdiChartPie': ["report-pie","widget-pie","graph-pie"],
    'mdiChartPieOutline': ["report-pie-outline","widget-pie-outline","graph-pie-outline"],
    'mdiChartPpf': ["chart-production-possibility-frontier","report-ppf","widget-ppf","graph-ppf"],
    'mdiChartSankey': ["chart-snakey","report-sankey","widget-sankey","graph-sankey"],
    'mdiChartSankeyVariant': ["chart-snakey-variant","report-sankey-variant","widget-sankey-variant","graph-sankey-variant"],
    'mdiChartScatterPlot': ["report-scatter-plot","widget-scatter-plot","graph-scatter-plot"],
    'mdiChartScatterPlotHexbin': ["chart-scatterplot-hexbin","report-scatter-plot-hexbin","widget-scatter-plot-hexbin","graph-scatter-plot-hexbin"],
    'mdiChartTimeline': ["report-timeline","widget-timeline","graph-timeline","roadmap"],
    'mdiChartTimelineVariant': ["report-timeline-variant","widget-timeline-variant","graph-timeline-variant","report-line","widget-line","graph-line"],
    'mdiChartTimelineVariantShimmer': ["report-timeline-variant-shimmer","widget-timeline-variant-shimmer","graph-timeline-variant-shimmer","report-line-shimmer","widget-line-shimmer","graph-line-shimmer"],
    'mdiChartTree': ["report-tree","widget-tree"],
    'mdiChat': ["message","message-bubble","speak"],
    'mdiChatAlert': ["chat-warning"],
    'mdiChatOutline': ["message-outline","message-bubble-outline","speak-outline"],
    'mdiChatProcessing': ["chat-typing"],
    'mdiChatProcessingOutline': ["chat-typing-outline"],
    'mdiChatQuestion': ["chat-help"],
    'mdiChatQuestionOutline': ["chat-help-outline"],
    'mdiCheck': ["tick","done","success"],
    'mdiCheckAll': ["tick-all","done-all","check-multiple","checks","ticks"],
    'mdiCheckBold': ["check-thick","success-thick","success-bold"],
    'mdiCheckCircle': ["tick-circle","success-circle"],
    'mdiCheckCircleOutline': ["tick-circle-outline","success-circle-outline"],
    'mdiCheckDecagram': ["verified","decagram-check","approve","approval","tick-decagram"],
    'mdiCheckDecagramOutline': ["approve","approval","verified"],
    'mdiCheckNetwork': ["tick-network"],
    'mdiCheckNetworkOutline': ["tick-network-outline"],
    'mdiCheckOutline': ["done-outline","tick-outline","sucess-outline"],
    'mdiCheckbook': ["chequebook","cheque-book"],
    'mdiCheckbookArrowLeft': ["chequebook-arrow-left"],
    'mdiCheckbookArrowRight': ["chequebook-arrow-right"],
    'mdiCheckboxBlankBadge': ["checkbox-blank-notification","app-notification","app-badge"],
    'mdiCheckboxBlankBadgeOutline': ["checkbox-blank-notification-outline","app-notification-outline","app-badge-outline"],
    'mdiCheckboxBlankOutline': ["check-box-outline-blank","maximize"],
    'mdiCheckboxIntermediate': ["checkbox-indeterminate"],
    'mdiCheckboxIntermediateVariant': ["checkbox-indeterminate-variant"],
    'mdiCheckboxMarked': ["check-box"],
    'mdiCheckboxMarkedCircleAutoOutline': ["task-auto","todo-auto"],
    'mdiCheckboxMarkedCircleMinusOutline': ["todo-minus","task-minus"],
    'mdiCheckboxMarkedCirclePlusOutline': ["task-plus","task-add","todo-plus","todo-add"],
    'mdiCheckboxMultipleBlank': ["checkboxes-blank"],
    'mdiCheckboxMultipleBlankCircle': ["checkboxes-blank-circle"],
    'mdiCheckboxMultipleBlankCircleOutline': ["checkboxes-blank-circle-outline"],
    'mdiCheckboxMultipleBlankOutline': ["checkboxes-blank-outline"],
    'mdiCheckboxMultipleMarked': ["checkboxes-marked"],
    'mdiCheckboxMultipleMarkedCircle': ["checkboxes-marked-circle"],
    'mdiCheckboxMultipleMarkedCircleOutline': ["checkboxes-marked-circle-outline"],
    'mdiCheckboxMultipleMarkedOutline': ["checkboxes-marked-outline"],
    'mdiCheckboxMultipleOutline': ["check-boxes-outline","tick-box-multiple-outline"],
    'mdiCheckerboard': ["raster"],
    'mdiCheckerboardMinus': ["raster-minus"],
    'mdiCheckerboardPlus': ["raster-plus"],
    'mdiCheckerboardRemove': ["raster-remove"],
    'mdiCheese': ["swiss-cheese"],
    'mdiChefHat': ["toque","cook"],
    'mdiChessKing': ["crown","royalty"],
    'mdiChessKnight': ["chess-horse"],
    'mdiChessQueen': ["crown","royalty"],
    'mdiChessRook': ["chess-castle","chess-tower"],
    'mdiChevronDown': ["expand-more","keyboard-arrow-down"],
    'mdiChevronLeft': ["keyboard-arrow-left","navigate-before"],
    'mdiChevronRight': ["keyboard-arrow-right","navigate-next"],
    'mdiChevronTripleUp': ["rank"],
    'mdiChevronUp': ["expand-less","keyboard-arrow-up","caret"],
    'mdiChiliHot': ["chilli-hot","pepper","spicy"],
    'mdiChiliMedium': ["chilli-medium","pepper","spicy"],
    'mdiChiliMild': ["chilli-mild","pepper","spicy"],
    'mdiChiliOff': ["chilli-off","pepper-off","spicy-off"],
    'mdiChip': ["integrated-circuit"],
    'mdiCircle': ["lens"],
    'mdiCircleHalf': ["brightness-half"],
    'mdiCircleMultiple': ["coins"],
    'mdiCircleMultipleOutline': ["toll","coins-outline"],
    'mdiCircleOffOutline': ["null-off"],
    'mdiCircleOpacity': ["circle-transparent"],
    'mdiCircleOutline': ["null"],
    'mdiCircleSmall': ["bullet","multiplication","dot"],
    'mdiCity': ["location-city"],
    'mdiCitySwitch': ["city-swap"],
    'mdiClipboardAccount': ["clipboard-user","assignment-ind","clipboard-person"],
    'mdiClipboardAccountOutline': ["clipboard-user-outline","clipboard-person-outline","assignment-ind-outline"],
    'mdiClipboardAlert': ["clipboard-warning","assignment-late"],
    'mdiClipboardAlertOutline': ["clipboard-warning-outline"],
    'mdiClipboardArrowDown': ["assignment-returned","clipboard-arrow-bottom"],
    'mdiClipboardArrowDownOutline': ["assignment-returned-outline","clipboard-arrow-bottom-outline"],
    'mdiClipboardArrowLeft': ["assignment-return"],
    'mdiClipboardArrowUp': ["clipboard-arrow-top"],
    'mdiClipboardArrowUpOutline': ["clipboard-arrow-top-outline"],
    'mdiClipboardCheck': ["assignment-turned-in","clipboard-tick"],
    'mdiClipboardCheckOutline': ["clipboard-tick-outline"],
    'mdiClipboardPlus': ["clipboard-add"],
    'mdiClipboardPulse': ["clipboard-vitals"],
    'mdiClipboardPulseOutline': ["clipboard-vitals-outline"],
    'mdiClipboardText': ["assignment"],
    'mdiClipboardTextClock': ["clipboard-text-date","clipboard-text-time","clipboard-text-history"],
    'mdiClipboardTextClockOutline': ["clipboard-text-date-outline","clipboard-text-time-outline","clipboard-text-history-outline"],
    'mdiClock': ["watch-later"],
    'mdiClockAlert': ["clock-warning"],
    'mdiClockAlertOutline': ["clock-warning"],
    'mdiClockFast': ["velocity"],
    'mdiClockOutline': ["access-time","query-builder","schedule"],
    'mdiClockStarFourPoints': ["clock-auto"],
    'mdiClockStarFourPointsOutline': ["clock-auto-outline"],
    'mdiClose': ["clear","multiply","remove","cancel","times"],
    'mdiCloseBox': ["multiply-box","clear-box","cancel-box","remove-box"],
    'mdiCloseBoxMultiple': ["close-boxes","library-remove","library-close","multiply-boxes","multiply-box-multiple","cancel-box-multiple","remove-box-multiple"],
    'mdiCloseBoxMultipleOutline': ["close-boxes-outline","library-remove-outline","library-close-outline","multiply-boxes-outline","multiply-box-multiple-outline","remove-box-multiple","cancel-box-multiple"],
    'mdiCloseBoxOutline': ["multiply-box-outline","clear-box-outline","remove-box-outline","cancel-box-outline"],
    'mdiCloseCircle': ["remove-circle","cancel-circle","multiply-circle","clear-circle"],
    'mdiCloseCircleMultiple': ["remove-circle-multiple","coins-close","coins-remove","clear-circle-multiple","multiply-circle-multiple"],
    'mdiCloseCircleMultipleOutline': ["remove-circle-multiple-outline","coins-close-outline","coins-remove-outline","cancel-circle-multiple-outline","multiply-circle-multiple-outline","clear-circle-multiple-outline"],
    'mdiCloseCircleOutline': ["highlight-off","multiply-circle-outline","remove-circle-outline","clear-circle-outline","cancel-circle-outline"],
    'mdiCloseNetwork': ["remove-network","cancel-network","multiply-network","clear-network"],
    'mdiCloseNetworkOutline': ["remove-network-outline","cancel-network-outline","multiply-network-outline","clear-network-outline"],
    'mdiCloseOctagon': ["dangerous","multiply-octagon","remove-octagon","cancel-octagon","clear-octagon","stop-remove"],
    'mdiCloseOctagonOutline': ["remove-octagon-outline","multiply-octagon-outline","clear-octagon-outline","cancel-octagon-outline","stop-remove-outline"],
    'mdiCloseOutline': ["remove-outline","cancel-outline","multiply-outline","clear-outline"],
    'mdiCloseThick': ["close-bold","remove-thick","remove-bold","multiply-thick","multiply-bold","clear-thick","clear-bold","cancel-thick","cancel-bold"],
    'mdiClosedCaption': ["cc"],
    'mdiClosedCaptionOutline': ["cc-outline"],
    'mdiCloud': ["wb-cloudy"],
    'mdiCloudAlert': ["cloud-warning"],
    'mdiCloudBraces': ["cloud-json"],
    'mdiCloudCheckVariant': ["cloud-done","cloud-tick"],
    'mdiCloudKey': ["cloud-security","cloud-access"],
    'mdiCloudKeyOutline': ["cloud-security-outline","cloud-access-outline"],
    'mdiCloudOffOutline': ["offline","local"],
    'mdiCloudOutline': ["cloud-queue"],
    'mdiCloudPercent': ["humidity","rain-chance","cloud-discount"],
    'mdiCloudPercentOutline': ["cloud-discount-outline","humidity-outline","rain-chance-outline"],
    'mdiCloudTags': ["cloud-xml"],
    'mdiCloudUpload': ["backup"],
    'mdiCloudUploadOutline': ["backup-outline"],
    'mdiClover': ["luck"],
    'mdiCloverOutline': ["luck-outline"],
    'mdiCoachLamp': ["coach-light","carriage-lamp","carriage-light"],
    'mdiCoachLampVariant': ["coach-light","carriage-light","carriage-lamp"],
    'mdiCoatRack': ["foyer","hallway","entry-room"],
    'mdiCodeBlockBraces': ["code-block-tag","code-block-json"],
    'mdiCodeBlockBrackets': ["code-block-square"],
    'mdiCodeBlockTags': ["code-block-html","code-block-xml"],
    'mdiCodeBraces': ["set"],
    'mdiCodeBrackets': ["square-brackets"],
    'mdiCodeTagsCheck': ["code-tags-tick"],
    'mdiCoffee': ["tea","cup","free-breakfast","local-cafe","drink"],
    'mdiCoffeeMaker': ["espresso-maker","coffee-machine","espresso-machine"],
    'mdiCoffeeMakerCheck': ["coffee-maker-done","coffee-maker-complete"],
    'mdiCoffeeMakerCheckOutline': ["coffee-maker-complete-outline","coffee-maker-done-outline"],
    'mdiCoffeeOff': ["drink-off","tea-off","cup-off","free-breakfast-off","local-cafe-off"],
    'mdiCoffeeOffOutline': ["drink-off-outline","cup-off-outline","tea-off-outline","free-breakfast-off-outline","local-cafe-off-outline"],
    'mdiCoffeeOutline': ["tea-outline","cup-outline","drink-outline","free-breakfast-outline","local-cafe-outline"],
    'mdiCoffeeToGo': ["tea-to-go","drink-to-go","cup-to-go","free-breakfast-to-go","local-cafe-to-go"],
    'mdiCoffeeToGoOutline': ["tea-to-go-outline","cup-to-go-outline","drink-to-go-outline","free-breakfast-to-go-outline","local-cafe-to-go-outline"],
    'mdiCoffin': ["death","dead"],
    'mdiCog': ["settings","gear"],
    'mdiCogBox': ["gear-box","settings-applications","settings-box"],
    'mdiCogOff': ["settings-off"],
    'mdiCogOffOutline': ["settings-off-outline"],
    'mdiCogOutline': ["gear-outline","settings-outline"],
    'mdiCogPause': ["settings-pause","gear-pause"],
    'mdiCogPauseOutline': ["settings-pause-outline","gear-pause-outline"],
    'mdiCogPlay': ["settings-play","gear-play"],
    'mdiCogPlayOutline': ["settings-play-outline","gear-play-outline"],
    'mdiCogRefresh': ["settings-refresh"],
    'mdiCogRefreshOutline': ["settings-refresh-outline"],
    'mdiCogStop': ["settings-stop","gear-stop"],
    'mdiCogStopOutline': ["settings-stop-outline","gear-stop-outline"],
    'mdiCogSync': ["settings-sync"],
    'mdiCogSyncOutline': ["settings-sync-outline"],
    'mdiCogTransfer': ["settings-transfer"],
    'mdiCogTransferOutline': ["settings-transfer-outline"],
    'mdiCogs': ["settings","manufacturing"],
    'mdiCollage': ["auto-awesome-mosaic"],
    'mdiCollapseAll': ["animation-minus"],
    'mdiCollapseAllOutline': ["animation-minus-outline"],
    'mdiColorHelper': ["colour-helper"],
    'mdiCommentAccount': ["comment-user","comment-person"],
    'mdiCommentAccountOutline': ["comment-user-outline","comment-person-outline"],
    'mdiCommentAlert': ["comment-warning"],
    'mdiCommentAlertOutline': ["comment-warning-outline"],
    'mdiCommentArrowLeft': ["comment-previous"],
    'mdiCommentArrowLeftOutline': ["comment-previous-outline"],
    'mdiCommentArrowRight': ["comment-next"],
    'mdiCommentArrowRightOutline': ["comment-next-outline"],
    'mdiCommentCheck': ["comment-tick"],
    'mdiCommentCheckOutline': ["comment-tick-outline"],
    'mdiCommentFlash': ["comment-quick"],
    'mdiCommentFlashOutline': ["comment-quick-outline"],
    'mdiCommentMultiple': ["comments"],
    'mdiCommentMultipleOutline': ["comments-outline"],
    'mdiCommentPlus': ["comment-add"],
    'mdiCommentPlusOutline': ["comment-add-outline"],
    'mdiCommentQuestion': ["comment-help"],
    'mdiCommentQuestionOutline': ["comment-help-outline"],
    'mdiCommentQuote': ["feedback"],
    'mdiCommentQuoteOutline': ["feedback-outline"],
    'mdiCommentTextMultiple': ["comments-text"],
    'mdiCommentTextMultipleOutline': ["comments-text-outline"],
    'mdiCompare': ["theme-light-dark"],
    'mdiCompass': ["explore"],
    'mdiCompost': ["regeneration","regenerative-agriculture"],
    'mdiConnection': ["plug"],
    'mdiConsole': ["terminal"],
    'mdiConsoleLine': ["terminal-line"],
    'mdiConsoleNetwork': ["terminal-network"],
    'mdiConsoleNetworkOutline': ["terminal-network-outline"],
    'mdiContentCut': ["scissors","clip"],
    'mdiContentSave': ["floppy-disc","floppy-disk"],
    'mdiContentSaveAlert': ["floppy-disc-alert"],
    'mdiContentSaveAlertOutline': ["floppy-disc-alert-outline"],
    'mdiContentSaveAll': ["floppy-disc-multiple"],
    'mdiContentSaveAllOutline': ["floppy-disc-multiple-outline"],
    'mdiContentSaveCog': ["floppy-disc-cog"],
    'mdiContentSaveCogOutline': ["floppy-disc-cog-outline"],
    'mdiContentSaveEdit': ["floppy-disc-edit"],
    'mdiContentSaveEditOutline': ["floppy-disc-edit-outline"],
    'mdiContentSaveMove': ["floppy-disc-move"],
    'mdiContentSaveMoveOutline': ["floppy-disc-move-outline"],
    'mdiContentSavePlus': ["content-save-add"],
    'mdiContentSavePlusOutline': ["content-save-add-outline"],
    'mdiContentSaveSettings': ["floppy-disc-settings"],
    'mdiContentSaveSettingsOutline': ["floppy-disc-settings-outline"],
    'mdiController': ["gamepad"],
    'mdiControllerClassic': ["gamepad-classic"],
    'mdiControllerClassicOutline': ["gamepad-classic-outline"],
    'mdiControllerOff': ["gamepad-off"],
    'mdiCookie': ["biscuit"],
    'mdiCookieAlert': ["biscuit-alert"],
    'mdiCookieAlertOutline': ["biscuit-alert-outline"],
    'mdiCookieCheck': ["biscuit-check"],
    'mdiCookieCheckOutline': ["biscuit-check-outline"],
    'mdiCookieClock': ["biscuit-clock"],
    'mdiCookieClockOutline': ["biscuit-clock-outline"],
    'mdiCookieCog': ["biscuit-cog"],
    'mdiCookieCogOutline': ["biscuit-cog-outline"],
    'mdiCookieEdit': ["biscuit-edit"],
    'mdiCookieEditOutline': ["biscuit-edit-outline"],
    'mdiCookieLock': ["biscuit-lock"],
    'mdiCookieLockOutline': ["biscuit-lock-outline"],
    'mdiCookieMinus': ["biscuit-minus"],
    'mdiCookieMinusOutline': ["biscuit-minus-outline"],
    'mdiCookieOff': ["biscuit-off"],
    'mdiCookieOffOutline': ["biscuit-off-outline"],
    'mdiCookieOutline': ["biscuit-outline"],
    'mdiCookiePlus': ["biscuit-plus"],
    'mdiCookiePlusOutline': ["biscuit-plus-outline"],
    'mdiCookieRefresh': ["biscuit-refresh"],
    'mdiCookieRefreshOutline': ["biscuit-refresh-outline"],
    'mdiCookieRemove': ["biscuit-remove"],
    'mdiCookieRemoveOutline': ["biscuit-remove-outline"],
    'mdiCookieSettings': ["biscuit-settings","cookie-crumbs","biscuit-crumbs"],
    'mdiCookieSettingsOutline': ["biscuit-settings-outline","cookie-crumbs-outline","biscuit-crumbs-outline"],
    'mdiCosineWave': ["frequency","amplitude"],
    'mdiCounter': ["score","numbers","odometer"],
    'mdiCountertop': ["kitchen-counter","sink"],
    'mdiCountertopOutline': ["kitchen-counter-outline","sink-outline"],
    'mdiCow': ["emoji-cow","emoticon-cow"],
    'mdiCowOff': ["dairy-off","dairy-free"],
    'mdiCpu32Bit': ["chip-32-bit"],
    'mdiCpu64Bit': ["chip-64-bit"],
    'mdiCradle': ["crib","bassinet","baby","nursery","baby-room"],
    'mdiCradleOutline': ["bassinet","crib","baby","nursery-outline","baby-room-outline"],
    'mdiCreation': ["auto-awesome","sparkles","stars","shimmer"],
    'mdiCreationOutline': ["auto-awesome-outline","sparkles-outline","stars-outline","shimmer-outline"],
    'mdiCreditCardChip': ["credit-card-icc-chip"],
    'mdiCreditCardChipOutline': ["credit-card-icc-chip-outline"],
    'mdiCreditCardFast': ["credit-card-swipe"],
    'mdiCreditCardFastOutline': ["credit-card-swipe-outline"],
    'mdiCreditCardMarker': ["credit-card-location","payment-on-delivery"],
    'mdiCreditCardMarkerOutline': ["cod","payment-on-delivery-outline","credit-card-location-outline"],
    'mdiCreditCardMultipleOutline': ["credit-cards"],
    'mdiCreditCardOutline': ["payment"],
    'mdiCreditCardPlusOutline': ["credit-card-add"],
    'mdiCreditCardSettingsOutline': ["payment-settings"],
    'mdiCreditCardWirelessOutline': ["credit-card-contactless"],
    'mdiCricket': ["cricket-bat"],
    'mdiCropLandscape': ["crop-5-4"],
    'mdiCross': ["christianity","religion-christian"],
    'mdiCrossOutline': ["religion-christian-outline","christianity-outline"],
    'mdiCrosshairs': ["gps-not-fixed","location-searching"],
    'mdiCrosshairsGps': ["gps-fixed","my-location"],
    'mdiCrosshairsQuestion': ["crosshairs-unknown","gps-unknown"],
    'mdiCrowd': ["family","crowd-source","crowdsource"],
    'mdiCrownCircle': ["checkers"],
    'mdiCrownCircleOutline': ["checkers-outline"],
    'mdiCubeOffOutline': ["sugar-off","sugar-cube-off","sugar-free"],
    'mdiCubeOutline': ["sugar","sugar-cube"],
    'mdiCubeScan': ["view-in-ar","view-in-augmented-reality"],
    'mdiCup': ["glass","drink"],
    'mdiCupOff': ["glass-off","drink-off"],
    'mdiCupOffOutline': ["glass-off-outline","drink-off-outline"],
    'mdiCupOutline': ["glass-outline","drink-outline","cup-empty"],
    'mdiCupWater': ["local-drink","glass-water","drink-water","cup-liquid","glass-liquid"],
    'mdiCurrencyBdt': ["taka","bangladeshi-taka"],
    'mdiCurrencyBrl': ["brazilian-real"],
    'mdiCurrencyBtc': ["bitcoin"],
    'mdiCurrencyCny': ["yuan","renminbi"],
    'mdiCurrencyEth': ["ethereum","xi"],
    'mdiCurrencyEur': ["euro","euro-symbol"],
    'mdiCurrencyGbp': ["pound","sterling"],
    'mdiCurrencyInr': ["rupee"],
    'mdiCurrencyJpy': ["yen"],
    'mdiCurrencyKrw': ["won"],
    'mdiCurrencyKzt': ["kazakhstani-tenge"],
    'mdiCurrencyMnt': ["currency-mongolian-tugrug"],
    'mdiCurrencyNgn': ["naira"],
    'mdiCurrencyPhp': ["philippine-peso"],
    'mdiCurrencyRial': ["currency-riyal","currency-irr","currency-omr","currency-yer","currency-sar"],
    'mdiCurrencyRub': ["ruble"],
    'mdiCurrencyRupee': ["currency-npr","currency-pkr","currency-lkr","currency-inr"],
    'mdiCurrencySign': ["currency-scarab"],
    'mdiCurrencyThb': ["currency-thai-baht"],
    'mdiCurrencyTry': ["lira"],
    'mdiCurrencyTwd': ["new-taiwan-dollar"],
    'mdiCurrencyUah': ["currency-hryvnia","currency-ukraine"],
    'mdiCurrencyUsd': ["attach-money","dollar"],
    'mdiCurrencyUsdOff': ["money-off","dollar-off"],
    'mdiCurrentAc': ["alternating-current"],
    'mdiCurrentDc': ["direct-current"],
    'mdiCursorPointer': ["cursor-hand"],
    'mdiCurtains': ["drapes","window"],
    'mdiCurtainsClosed': ["drapes-closed","window-closed"],
    'mdiDanceBallroom': ["human-dance-ballroom"],
    'mdiDancePole': ["kho-kho","human-dance-pole"],
    'mdiDatabase': ["storage"],
    'mdiDatabaseCheck': ["database-tick"],
    'mdiDatabaseEye': ["database-view"],
    'mdiDatabaseEyeOff': ["database-view-off"],
    'mdiDatabaseEyeOffOutline': ["database-view-off-outline"],
    'mdiDatabaseEyeOutline': ["database-view-outline"],
    'mdiDatabaseMarker': ["database-location"],
    'mdiDatabaseMarkerOutline': ["database-location-outline"],
    'mdiDatabasePlus': ["database-add"],
    'mdiDatabaseSearch': ["sql-query"],
    'mdiDeathlyHallows': ["harry-potter"],
    'mdiDebugStepOver': ["skip","jump"],
    'mdiDecagram': ["starburst"],
    'mdiDecagramOutline': ["starburst-outline"],
    'mdiDelete': ["trash","bin","rubbish","garbage","rubbish-bin","trash-can","garbage-can"],
    'mdiDeleteCircle': ["trash-circle","bin-circle","garbage-can-circle","garbage-circle","rubbish-bin-circle","rubbish-circle","trash-can-circle"],
    'mdiDeleteCircleOutline': ["bin-circle-outline","garbage-can-circle-outline","garbage-circle-outline","rubbish-bin-circle-outline","rubbish-circle-outline","trash-can-circle-outline","trash-circle-outline"],
    'mdiDeleteEmpty': ["trash-empty","bin-empty","rubbish-empty","rubbish-bin-empty","trash-can-empty","garbage-empty","garbage-can-empty"],
    'mdiDeleteOutline': ["garbage-outline","bin-outline","rubbish-outline","garbage-can-outline","rubbish-bin-outline","trash-outline","trash-can-outline"],
    'mdiDeleteRestore': ["trash-restore","bin-restore","restore-from-trash"],
    'mdiDeleteVariant': ["trash-variant","bin-variant","cup-ice","drink-ice"],
    'mdiDelta': ["change-history"],
    'mdiDesktopClassic': ["computer-classic"],
    'mdiDevices': ["monitor","watch","smartwatch","smartphone","cellphone","television"],
    'mdiDharmachakra': ["dharma-wheel","religion-buddhist","buddhism"],
    'mdiDiabetes': ["hand-blood"],
    'mdiDialpad': ["keypad"],
    'mdiDiameter': ["circle-diameter","sphere-diameter"],
    'mdiDiameterOutline': ["circle-diameter-outline","sphere-diameter-outline"],
    'mdiDiameterVariant': ["circle-diameter-variant","sphere-diameter-variant"],
    'mdiDiamondStone': ["jewel"],
    'mdiDiaperOutline': ["nappy-outline"],
    'mdiDice1': ["die-1","dice-one"],
    'mdiDice2': ["die-2","dice-two"],
    'mdiDice3': ["die-3","dice-three"],
    'mdiDice4': ["die-4","dice-four"],
    'mdiDice5': ["die-5","dice-five"],
    'mdiDice6': ["die-6","dice-six"],
    'mdiDiceD10Outline': ["die-d10"],
    'mdiDiceD20Outline': ["die-d20"],
    'mdiDiceD4Outline': ["die-d4"],
    'mdiDiceD6Outline': ["die-d6"],
    'mdiDiceD8Outline': ["die-d8"],
    'mdiDiceMultiple': ["die-multiple"],
    'mdiDisc': ["cd-rom","dvd"],
    'mdiDiscAlert': ["disc-full","disc-warning"],
    'mdiDiving': ["swim-dive","human-diving"],
    'mdiDivision': ["obelus"],
    'mdiDna': ["helix"],
    'mdiDog': ["emoji-dog","emoticon-dog"],
    'mdiDogService': ["guide-dog","k9","canine"],
    'mdiDogSide': ["k9","canine"],
    'mdiDolly': ["hand-truck","trolley"],
    'mdiDolphin': ["porpoise"],
    'mdiDomain': ["building","company","business"],
    'mdiDominoMask': ["robber-mask","zorro-mask"],
    'mdiDoorClosedCancel': ["door-forbidden","door-do-not-enter","door-unavailable"],
    'mdiDoorSliding': ["patio-door","french-door"],
    'mdiDoorSlidingLock': ["patio-door-lock","french-door-lock"],
    'mdiDoorSlidingOpen': ["patio-door-open","french-door-open"],
    'mdiDotsCircle': ["perimeter"],
    'mdiDotsHorizontal': ["more","ellipsis-horizontal","more-horiz","menu"],
    'mdiDotsHorizontalCircle': ["ellipsis-horizontal-circle","more-circle","menu"],
    'mdiDotsHorizontalCircleOutline': ["ellipsis-horizontal-circle-outline","more-circle-outline","menu"],
    'mdiDotsSquare': ["perimeter"],
    'mdiDotsVertical': ["ellipsis-vertical","more-vert","menu"],
    'mdiDotsVerticalCircle': ["ellipsis-vertical-circle","menu"],
    'mdiDotsVerticalCircleOutline': ["ellipsis-vertical-circle-outline","menu"],
    'mdiDownload': ["file-download","get-app"],
    'mdiDownloadMultiple': ["downloads"],
    'mdiDramaMasks': ["comedy","tragedy","theatre"],
    'mdiDraw': ["sign","signature"],
    'mdiDrawPen': ["sign","signature"],
    'mdiDumbbell': ["weights","fitness-center","gym","barbell"],
    'mdiDumpTruck': ["tipper-lorry"],
    'mdiEarHearingLoop': ["audio-induction-loop","telecoil"],
    'mdiEarHearingOff': ["hearing-impaired"],
    'mdiEarbuds': ["headphones"],
    'mdiEarbudsOff': ["headphones-off"],
    'mdiEarbudsOffOutline': ["headphones-off-outline"],
    'mdiEarbudsOutline': ["headphones-outline"],
    'mdiEarth': ["globe","public","planet","world"],
    'mdiEarthArrowDown': ["globe-arrow-down","world-arrow-down","planet-arrow-down"],
    'mdiEarthArrowLeft': ["globe-arrow-left","world-arrow-left","planet-arrow-left"],
    'mdiEarthArrowRight': ["globe-arrow-right","world-arrow-right","planet-arrow-right"],
    'mdiEarthArrowUp': ["globe-arrow-up","planet-arrow-up","world-arrow-up"],
    'mdiEarthBox': ["globe-box","world-box","planet-box"],
    'mdiEarthBoxMinus': ["globe-box-minus","world-box-minus","planet-box-minus"],
    'mdiEarthBoxOff': ["globe-box-off","world-box-off","planet-box-off"],
    'mdiEarthBoxPlus': ["globe-box-plus","world-box-plus","planet-box-plus"],
    'mdiEarthBoxRemove': ["globe-box-remove","world-box-remove","planet-box-remove"],
    'mdiEarthMinus': ["globe-minus","world-minus","planet-minus"],
    'mdiEarthOff': ["globe-off","world-off","planet-off"],
    'mdiEarthPlus': ["globe-plus","world-plus","planet-plus"],
    'mdiEarthRemove': ["globe-remove","world-remove","planet-remove"],
    'mdiEiffelTower': ["paris","france"],
    'mdiEightTrack': ["8-track"],
    'mdiEmail': ["local-post-office","mail","markunread","envelope"],
    'mdiEmailAlert': ["email-warning","envelope-alert","envelope-warning"],
    'mdiEmailArrowLeft': ["email-receive"],
    'mdiEmailArrowLeftOutline': ["email-receive-outline"],
    'mdiEmailArrowRight': ["email-send"],
    'mdiEmailArrowRightOutline': ["email-arrow-right-outline"],
    'mdiEmailBox': ["envelope-box"],
    'mdiEmailCheck': ["email-tick"],
    'mdiEmailCheckOutline': ["email-tick-outline"],
    'mdiEmailFast': ["envelope-fast","email-quick","email-sent","email-send"],
    'mdiEmailFastOutline': ["email-send-outline","email-sent-outline","envelope-fast-outline","email-quick-outline"],
    'mdiEmailHeartOutline': ["love-letter","envelope-heart-outline","greeting-card"],
    'mdiEmailLock': ["envelope-secure","email-secure","envelope-lock"],
    'mdiEmailLockOutline': ["email-secure-outline"],
    'mdiEmailOpen': ["drafts","envelope-open"],
    'mdiEmailOpenHeartOutline': ["love-letter-open","greeting-card-open","envelope-open-heart-outline"],
    'mdiEmailOpenOutline': ["envelope-open-outline"],
    'mdiEmailOutline': ["mail-outline","envelope-outline"],
    'mdiEmailPlus': ["email-add","envelope-add","envelope-plus"],
    'mdiEmailPlusOutline': ["email-add-outline","envelope-add-outline","envelope-plus-outline"],
    'mdiEmailSeal': ["email-certified","mail-certified","mail-seal","email-verified","mail-verified"],
    'mdiEmailSealOutline': ["email-verified-outline","email-certified-outline","mail-verified-outline","mail-certified-outline","mail-seal-outline"],
    'mdiEmailSync': ["email-refresh","email-resend"],
    'mdiEmailSyncOutline': ["email-refresh-outline","email-resend-outline"],
    'mdiEmailVariant': ["envelope-variant"],
    'mdiEmoticon': ["smiley","face","emoji"],
    'mdiEmoticonAngry': ["smiley-angry","face-angry","emoji-angry"],
    'mdiEmoticonAngryOutline': ["smiley-angry-outline","face-angry-outline","emoji-angry-outline"],
    'mdiEmoticonConfused': ["face-confused","emoji-confused"],
    'mdiEmoticonConfusedOutline': ["face-confused-outline","emoji-confused-outline"],
    'mdiEmoticonCool': ["smiley-cool","face-cool","face-sunglasses","emoji-cool"],
    'mdiEmoticonCoolOutline': ["smiley-cool-outline","face-cool-outline","face-sunglasses-outline","emoji-cool-outline"],
    'mdiEmoticonCry': ["smiley-cry","face-cry","emoji-cry"],
    'mdiEmoticonCryOutline': ["smiley-cry-outline","face-cry-outline","emoji-cry-outline"],
    'mdiEmoticonDead': ["smiley-dead","face-dead","emoji-dead"],
    'mdiEmoticonDeadOutline': ["smiley-dead-outline","face-dead-outline","emoji-dead-outline"],
    'mdiEmoticonDevil': ["smiley-devil","face-devil","emoji-devil"],
    'mdiEmoticonDevilOutline': ["smiley-devil-outline","face-devil-outline","emoji-devil-outline"],
    'mdiEmoticonExcited': ["smiley-excited","face-excited","emoji-excited"],
    'mdiEmoticonExcitedOutline': ["smiley-excited-outline","face-excited-outline","emoji-excited-outline"],
    'mdiEmoticonFrown': ["face-frown","emoji-frown"],
    'mdiEmoticonFrownOutline': ["face-frown-outline","emoji-frown-outline"],
    'mdiEmoticonHappy': ["smiley-happy","face-happy","emoji-happy"],
    'mdiEmoticonHappyOutline': ["smiley-happy-outline","face-happy-outline","emoji-happy-outline"],
    'mdiEmoticonKiss': ["smiley-kiss","face-kiss","emoji-kiss"],
    'mdiEmoticonKissOutline': ["smiley-kiss-outline","face-kiss-outline","emoji-kiss-outline"],
    'mdiEmoticonLol': ["face-lol","emoji-lol"],
    'mdiEmoticonLolOutline': ["face-lol-outline","emoji-lol-outline"],
    'mdiEmoticonNeutral': ["smiley-neutral","face-neutral","emoji-neutral"],
    'mdiEmoticonNeutralOutline': ["smiley-neutral-outline","face-neutral-outline","emoji-neutral-outline"],
    'mdiEmoticonOutline': ["insert-emoticon","mood","sentiment-very-satisfied","tag-faces","smiley-outline","face-outline","emoji-outline"],
    'mdiEmoticonPoop': ["smiley-poop","face-poop","emoji-poop"],
    'mdiEmoticonPoopOutline': ["face-poop-outline","emoji-poop-outline"],
    'mdiEmoticonSad': ["smiley-sad","face-sad","emoji-sad"],
    'mdiEmoticonSadOutline': ["smiley-sad-outline","face-sad-outline","emoji-sad-outline"],
    'mdiEmoticonSick': ["face-sick","fever","emoji-sick"],
    'mdiEmoticonSickOutline': ["face-sick-outline","fever-outline","emoji-sick-outline"],
    'mdiEmoticonTongue': ["smiley-tongue","face-tongue","emoji-tongue"],
    'mdiEmoticonTongueOutline': ["smiley-tongue-outline","face-tongue-outline","emoji-tongue-outline"],
    'mdiEmoticonWink': ["smiley-wink","face-wink","emoji-wink"],
    'mdiEmoticonWinkOutline': ["smiley-wink-outline","face-wink-outline","emoji-wink-outline"],
    'mdiEngine': ["motor"],
    'mdiEngineOff': ["motor-off"],
    'mdiEngineOffOutline': ["motor-off-outline"],
    'mdiEngineOutline': ["motor-outline"],
    'mdiEvPlugCcs1': ["ev-plug-ccs-combo-1","ev-charger-ccs1"],
    'mdiEvPlugCcs2': ["ev-plug-ccs-combo-2","ev-charger-ccs2"],
    'mdiEvPlugChademo': ["ev-charger-chademo"],
    'mdiEvPlugTesla': ["ev-charger-tesla"],
    'mdiEvPlugType1': ["ev-plug-j1772","ev-charger-type1"],
    'mdiEvPlugType2': ["ev-plug-mennekes","ev-charger-type2"],
    'mdiEvStation': ["charging-station","ev-charger","wall-charger","wallbox","electric-vehicle-charger","evse","electric-charger"],
    'mdiExclamation': ["factorial"],
    'mdiExclamationThick': ["exclamation-bold"],
    'mdiExitRun': ["emergency-exit"],
    'mdiExpandAll': ["animation-plus"],
    'mdiExpandAllOutline': ["animation-plus-outline"],
    'mdiExpansionCard': ["gpu","graphics-processing-unit","nic","network-interface-card"],
    'mdiExpansionCardVariant': ["graphics-processing-unit","gpu","network-interface-card","nice"],
    'mdiExponent': ["power"],
    'mdiExponentBox': ["power-box"],
    'mdiExport': ["output"],
    'mdiExportVariant': ["ios-share"],
    'mdiEye': ["show","visibility","remove-red-eye"],
    'mdiEyeArrowLeft': ["view-arrow-left"],
    'mdiEyeArrowLeftOutline': ["view-arrow-left-outline"],
    'mdiEyeArrowRight': ["view-arrow-right"],
    'mdiEyeArrowRightOutline': ["view-arrow-right-outline"],
    'mdiEyeCheck': ["eye-tick"],
    'mdiEyeCheckOutline': ["eye-tick-outline"],
    'mdiEyeClosed': ["eye-shut","visibility-hidden"],
    'mdiEyeOff': ["hide","visibility-off"],
    'mdiEyeOffOutline': ["hide-outline","visibility-off-outline"],
    'mdiEyeOutline': ["show-outline","visibility-outline"],
    'mdiEyePlus': ["eye-add"],
    'mdiEyePlusOutline': ["eye-add-outline"],
    'mdiEyeRefresh': ["view-refresh"],
    'mdiEyeRefreshOutline': ["view-refresh-outline"],
    'mdiEyedropper': ["pipette"],
    'mdiEyedropperVariant': ["colorize","colourise","pipette-variant"],
    'mdiFaceAgent': ["customer-service","support","emoji-agent","emoticon-agent"],
    'mdiFaceMan': ["face-male","emoji-man","emoticon-man"],
    'mdiFaceManOutline': ["face-male-outline","emoji-man-outline","emoticon-man-outline"],
    'mdiFaceManProfile': ["face-male-profile","emoji-man-profile","emoticon-man-profile"],
    'mdiFaceManShimmer': ["face-retouching-natural","face-male-shimmer","emoji-man-shimmer","emoticon-man-shimmer"],
    'mdiFaceManShimmerOutline': ["face-retouching-natural-outline","face-male-shimmer-outline","emoji-man-shimmer-outline","emoticon-man-shimmer-outline"],
    'mdiFaceRecognition': ["facial-recognition","scan"],
    'mdiFaceWoman': ["face-female","emoji-woman","emoticon-woman"],
    'mdiFaceWomanOutline': ["face-female-outline","emoji-woman-outline","emoticon-woman-outline"],
    'mdiFaceWomanProfile': ["face-female-profile","emoji-woman-profile","emoticon-woman-profile"],
    'mdiFaceWomanShimmer': ["face-retouching-natural-woman","face-female-shimmer","emoji-woman-shimmer","emoticon-woman-shimmer"],
    'mdiFaceWomanShimmerOutline': ["face-retouching-natural-woman-outline","face-female-shimmer-outline","emoji-woman-shimmer-outline","emoticon-woman-shimmer-outline"],
    'mdiFactory': ["industrial"],
    'mdiFanChevronDown': ["fan-speed-down"],
    'mdiFanChevronUp': ["fan-speed-up"],
    'mdiFanClock': ["fan-clock","fan-schedule","fan-timer"],
    'mdiFanSpeed1': ["fan-speed-low"],
    'mdiFanSpeed2': ["fan-speed-medium"],
    'mdiFanSpeed3': ["fan-speed-high"],
    'mdiFaucet': ["kitchen-tap","bathroom-tap","sink"],
    'mdiFaucetVariant': ["bathroom-tap","kitchen-tap","sink"],
    'mdiFeather': ["quill"],
    'mdiFeatureSearch': ["box","box-search"],
    'mdiFeatureSearchOutline': ["box","box-outline","box-search-outline"],
    'mdiFence': ["railway","train-track"],
    'mdiFenceElectric': ["railway-electric","train-track-electric"],
    'mdiFencing': ["sword-fight"],
    'mdiFerry': ["cargo-ship","boat","ship","directions-boat","directions-ferry"],
    'mdiFile': ["insert-drive-file","draft","paper"],
    'mdiFileAccount': ["file-user","resume"],
    'mdiFileAlert': ["file-warning"],
    'mdiFileAlertOutline': ["file-warning-outline"],
    'mdiFileArrowLeftRight': ["file-exchange","file-transfer","file-swap"],
    'mdiFileArrowLeftRightOutline': ["file-exchange-outline","file-swap-outline","file-transfer-outline"],
    'mdiFileArrowUpDown': ["file-exchange","file-swap","file-transfer","file-upload-download"],
    'mdiFileArrowUpDownOutline': ["file-exchange-outline","file-swap-outline","file-transfer-outline","file-upload-download-outline"],
    'mdiFileCabinet': ["filing-cabinet"],
    'mdiFileCancel': ["ban","forbid"],
    'mdiFileCancelOutline': ["ban","forbid"],
    'mdiFileChart': ["file-report","file-graph"],
    'mdiFileChartOutline': ["file-graph-outline","file-report-outline"],
    'mdiFileCheck': ["file-tick"],
    'mdiFileCog': ["file-settings-cog"],
    'mdiFileCogOutline': ["file-settings-cog-outline"],
    'mdiFileDelimited': ["file-csv"],
    'mdiFileDelimitedOutline': ["file-csv-outline"],
    'mdiFileDocument': ["file-text"],
    'mdiFileDocumentAlert': ["file-document-error","file-text-alert","file-text-error"],
    'mdiFileDocumentAlertOutline': ["file-document-error-outline","file-text-error-outline","file-text-alert-outline"],
    'mdiFileDocumentArrowRight': ["file-document-move","file-text-move","file-text-arrow-right"],
    'mdiFileDocumentArrowRightOutline': ["file-document-move-outline","file-text-move-outline","file-text-arrow-right-outline"],
    'mdiFileDocumentCheck': ["file-document-tick","file-text-tick","file-text-check"],
    'mdiFileDocumentCheckOutline': ["file-document-tick-outline","file-text-tick-outline","file-text-check-outline"],
    'mdiFileDocumentEdit': ["contract","file-text-edit"],
    'mdiFileDocumentEditOutline': ["contract-outline","file-text-edit-outline"],
    'mdiFileDocumentMinus': ["file-text-minus"],
    'mdiFileDocumentMinusOutline': ["file-text-minus-outline"],
    'mdiFileDocumentMultiple': ["file-text-multiple"],
    'mdiFileDocumentMultipleOutline': ["file-text-multiple-outline"],
    'mdiFileDocumentOutline': ["file-text-outline"],
    'mdiFileDocumentPlus': ["file-document-add","file-text-add","file-text-plus"],
    'mdiFileDocumentPlusOutline': ["file-document-add-outline","file-text-plus-outline","file-text-add-outline"],
    'mdiFileDocumentRemove': ["file-document-delete","file-text-remove","file-text-delete"],
    'mdiFileDocumentRemoveOutline': ["file-document-delete-outline","file-text-remove-outline","file-text-delete-outline"],
    'mdiFileFind': ["print-preview","find-in-page"],
    'mdiFileImageMarker': ["file-image-location"],
    'mdiFileImageMarkerOutline': ["file-image-location-outline"],
    'mdiFileImagePlus': ["file-image-add"],
    'mdiFileImagePlusOutline': ["file-image-add-outline"],
    'mdiFileJpgBox': ["file-jpeg-box","image-jpg-box","image-jpeg-box"],
    'mdiFileMarker': ["file-location"],
    'mdiFileMarkerOutline': ["file-location-outline"],
    'mdiFileMultiple': ["files"],
    'mdiFileOutline': ["paper-outline"],
    'mdiFilePdfBox': ["file-acrobat-box","adobe-acrobat"],
    'mdiFilePlus': ["note-add"],
    'mdiFileRestore': ["restore-page"],
    'mdiFileRotateLeft': ["file-rotate-counter-clockwise","file-rotate-ccw"],
    'mdiFileRotateLeftOutline': ["file-rotate-counter-clockwise-outline","file-rotate-ccw-outline"],
    'mdiFileRotateRight': ["file-rotate-clockwise"],
    'mdiFileRotateRightOutline': ["file-rotate-clockwise"],
    'mdiFileSend': ["file-move"],
    'mdiFileSign': ["contract-sign","document-sign"],
    'mdiFileStar': ["file-favorite"],
    'mdiFileStarFourPoints': ["file-auto"],
    'mdiFileStarFourPointsOutline': ["file-auto-outline"],
    'mdiFileStarOutline': ["file-favorite-outline"],
    'mdiFileSwap': ["file-transfer"],
    'mdiFileSwapOutline': ["file-transfer-outline"],
    'mdiFileTree': ["subtasks"],
    'mdiFileUndo': ["file-revert","file-discard"],
    'mdiFilm': ["camera-roll"],
    'mdiFilmstrip': ["local-movies","theaters"],
    'mdiFilmstripBoxMultiple': ["library-movie"],
    'mdiFilter': ["funnel"],
    'mdiFilterCheck': ["funnel-check"],
    'mdiFilterCheckOutline': ["funnel-check-outline"],
    'mdiFilterCog': ["funnel-settings","filter-settings","funnel-cog","filter-gear","funnel-gear"],
    'mdiFilterCogOutline': ["filter-settings-outline","filter-gear-outline","funnel-cog-outline","funnel-settings-outline","funnel-gear-outline"],
    'mdiFilterMinus': ["funnel-minus"],
    'mdiFilterMinusOutline': ["funnel-minus-outline"],
    'mdiFilterMultiple': ["funnel-multiple"],
    'mdiFilterMultipleOutline': ["funnel-multiple-outline"],
    'mdiFilterOutline': ["funnel-outline"],
    'mdiFilterPlus': ["funnel-plus"],
    'mdiFilterPlusOutline': ["funnel-plus-outline"],
    'mdiFilterRemove': ["funnel-remove"],
    'mdiFilterRemoveOutline': ["funnel-remove-outline"],
    'mdiFilterSettings': ["funnel-settings"],
    'mdiFilterSettingsOutline': ["funnel-settings-outline"],
    'mdiFilterVariant': ["filter-list"],
    'mdiFinance': ["chart-finance","report-finance","graph-bar"],
    'mdiFire': ["whatshot","flame","gas","natural-gas","hot"],
    'mdiFireAlert': ["flame-alert"],
    'mdiFireCircle': ["flame-circle","hot-circle","gas-circle","natural-gas-circle"],
    'mdiFireOff': ["flame-off"],
    'mdiFireTruck': ["fire-engine"],
    'mdiFirework': ["bottle-rocket"],
    'mdiFishbowl': ["aquarium"],
    'mdiFishbowlOutline': ["aquarium-outline"],
    'mdiFlag': ["assistant-photo"],
    'mdiFlagCheckered': ["goal"],
    'mdiFlagPlus': ["flag-add"],
    'mdiFlagTriangle': ["milestone"],
    'mdiFlare': ["star"],
    'mdiFlash': ["lightning-bolt","flash-on","electricity"],
    'mdiFlashAlert': ["lightning-alert","storm-advisory"],
    'mdiFlashAlertOutline': ["lightning-alert-outline","storm-advisory-outline"],
    'mdiFlashOutline': ["lightning-bolt-outline"],
    'mdiFlashTriangle': ["high-voltage"],
    'mdiFlashTriangleOutline': ["high-voltage-outline"],
    'mdiFlashlight': ["torch"],
    'mdiFlashlightOff': ["torch-off"],
    'mdiFloorLamp': ["floor-light"],
    'mdiFloorLampDual': ["floor-light-dual"],
    'mdiFloorLampDualOutline': ["floor-light-dual-outline"],
    'mdiFloorLampOutline': ["floor-light-outline"],
    'mdiFloorLampTorchiere': ["floor-light-torchiere"],
    'mdiFloorLampTorchiereVariant': ["floor-light-torchiere-variant"],
    'mdiFloorLampTorchiereVariantOutline': ["floor-light-torchiere-variant-outline"],
    'mdiFlower': ["local-florist","plant"],
    'mdiFlowerOutline': ["local-florist-outline","plant"],
    'mdiFlowerPollen': ["allergy"],
    'mdiFlowerPollenOutline': ["allergy-outline"],
    'mdiFlowerPoppy': ["plant"],
    'mdiFlowerTulip': ["plant"],
    'mdiFlowerTulipOutline': ["plant"],
    'mdiFolderAccount': ["folder-user","folder-shared"],
    'mdiFolderAccountOutline': ["folder-user-outline","folder-shared-outline"],
    'mdiFolderAlert': ["folder-warning"],
    'mdiFolderAlertOutline': ["folder-warning-outline"],
    'mdiFolderArrowDown': ["folder-download"],
    'mdiFolderArrowDownOutline': ["folder-download-outline"],
    'mdiFolderArrowUp': ["folder-upload"],
    'mdiFolderArrowUpDown': ["folder-transfer"],
    'mdiFolderArrowUpDownOutline': ["folder-transfer-outline"],
    'mdiFolderArrowUpOutline': ["folder-upload-outline"],
    'mdiFolderCog': ["folder-cog"],
    'mdiFolderCogOutline': ["folder-cog-outline"],
    'mdiFolderHome': ["folder-house"],
    'mdiFolderHomeOutline': ["folder-house-outline"],
    'mdiFolderMarker': ["folder-location"],
    'mdiFolderMarkerOutline': ["folder-location-outline"],
    'mdiFolderMultiple': ["folders"],
    'mdiFolderMultipleImage': ["perm-media","folders-image"],
    'mdiFolderMultipleOutline': ["folders-outline"],
    'mdiFolderOutline': ["folder-open"],
    'mdiFolderPlay': ["folder-media","folder-music","folder-video"],
    'mdiFolderPlayOutline': ["folder-media-outline","folder-music-outline","folder-video-outline"],
    'mdiFolderPlus': ["create-new-folder","folder-add"],
    'mdiFolderPlusOutline': ["create-new-folder-outline","folder-add-outline"],
    'mdiFolderPound': ["folder-hash"],
    'mdiFolderPoundOutline': ["folder-hash-outline"],
    'mdiFolderQuestion': ["folder-help"],
    'mdiFolderQuestionOutline': ["folder-help-outline"],
    'mdiFolderStar': ["folder-special","folder-favorite"],
    'mdiFolderStarMultiple': ["folder-favorite-multiple"],
    'mdiFolderStarMultipleOutline': ["folder-favorite-multiple-outline"],
    'mdiFolderStarOutline': ["folder-special-outline","folder-favorite-outline"],
    'mdiFolderSwap': ["folder-transfer"],
    'mdiFolderSwapOutline': ["folder-transfer-outline"],
    'mdiFolderWrench': ["folder-settings"],
    'mdiFolderWrenchOutline': ["folder-settings-outline"],
    'mdiFolderZip': ["compressed-folder"],
    'mdiFolderZipOutline': ["compressed-folder-outline"],
    'mdiFood': ["fast-food","burger","cup","drink","hamburger"],
    'mdiFoodDrumstick': ["chicken-leg","turkey-leg","meat"],
    'mdiFoodDrumstickOff': ["chicken-leg-off","turkey-leg-off","meat-off"],
    'mdiFoodDrumstickOffOutline': ["chicken-leg-off-outline","turkey-leg-off-outline","meat-off-outline"],
    'mdiFoodDrumstickOutline': ["chicken-leg-outline","turkey-leg-outline","meat-outline"],
    'mdiFoodForkDrink': ["food-fork-cup"],
    'mdiFoodHalal': ["food-muslim","dietary-restriction"],
    'mdiFoodHotDog': ["food-weiner","food-frankfurter"],
    'mdiFoodKosher': ["food-jewish","dietary-restriction"],
    'mdiFoodOff': ["fast-food-off","burger-off","cup-off","drink-off","hamburger-off"],
    'mdiFoodSteak': ["meat","beef"],
    'mdiFoodSteakOff': ["meat-off","beef-off"],
    'mdiFoodTurkey': ["dinner","thanksgiving"],
    'mdiFootball': ["football-american"],
    'mdiForest': ["forestry","pine-tree-multiple"],
    'mdiForestOutline': ["forestry-outline","pine-tree-multiple-outline"],
    'mdiFormTextbox': ["rename"],
    'mdiFormatAlignCenter': ["format-align-centre"],
    'mdiFormatAnnotationPlus': ["format-annotation-add"],
    'mdiFormatColorFill': ["format-colour-fill","paint","paint-bucket","ink-color","ink-colour"],
    'mdiFormatColorHighlight': ["format-colour-highlight"],
    'mdiFormatColorMarkerCancel': ["format-color-redact"],
    'mdiFormatColorText': ["format-colour-text"],
    'mdiFormatFloatCenter': ["format-float-centre"],
    'mdiFormatHeader1': ["format-heading-1"],
    'mdiFormatHeader2': ["format-heading-2"],
    'mdiFormatHeader3': ["format-heading-3"],
    'mdiFormatHeader4': ["format-heading-4"],
    'mdiFormatHeader5': ["format-heading-5"],
    'mdiFormatHeader6': ["format-heading-6"],
    'mdiFormatHeaderDecrease': ["format-heading-decease"],
    'mdiFormatHeaderEqual': ["format-heading-equal"],
    'mdiFormatHeaderIncrease': ["format-heading-increase"],
    'mdiFormatHeaderPound': ["format-header-hash","format-heading-pound","format-heading-hash","format-heading-markdown"],
    'mdiFormatHorizontalAlignCenter': ["format-horizontal-align-centre","arrow-horizontal-collapse"],
    'mdiFormatLetterCaseLower': ["format-lowercase"],
    'mdiFormatLetterCaseUpper': ["format-uppercase"],
    'mdiFormatLetterSpacing': ["format-kerning"],
    'mdiFormatListChecks': ["to-do"],
    'mdiFormatListGroupPlus': ["format-list-group-add"],
    'mdiFormatListNumbered': ["format-list-numbers"],
    'mdiFormatListNumberedRtl': ["format-list-numbered-right-to-left"],
    'mdiFormatPilcrowArrowLeft': ["format-textdirection-r-to-l"],
    'mdiFormatPilcrowArrowRight': ["format-textdirection-l-to-r"],
    'mdiFormatRotate90': ["rotate-90-degrees-ccw","format-rotate-ninety"],
    'mdiFormatSize': ["font-size"],
    'mdiFormatStrikethroughVariant': ["strikethrough-s"],
    'mdiFormatSuperscript': ["exponent"],
    'mdiFormatUnderline': ["format-underlined"],
    'mdiFormatVerticalAlignCenter': ["format-vertical-align-centre","arrow-vertical-collapse"],
    'mdiForum': ["message-group","question-answer","chat","dialogue","conversation","discussion"],
    'mdiForumMinus': ["discussion-minus","conversation-minus","dialogue-minus","chat-minus","forum-subtract","chat-subtract"],
    'mdiForumMinusOutline': ["dialogue-minus-outline","chat-minus-outline","forum-subtract-outline","chat-subtract-outline","conversation-minus-outline","discussion-minus-outline"],
    'mdiForumOutline': ["chat-outline","dialogue-outline","discussion-outline","conversation-outline"],
    'mdiForumPlus': ["chat-plus","forum-add","chat-add","dialogue-plus","conversation-plus","discussion-plus"],
    'mdiForumPlusOutline': ["chat-plus-outline","chat-add-outline","forum-add-outline","dialogue-plus-outline","conversation-plus-outline","discussion-plus-outline"],
    'mdiForumRemove': ["forum-delete","chat-remove","chat-delete","dialogue-remove","conversation-remove","discussion-remove"],
    'mdiForumRemoveOutline': ["forum-delete-outline","chat-remove-outline","chat-delete-outline","dialogue-remove-outline","conversation-remove-outline","discussion-remove-outline"],
    'mdiFrenchFries': ["chips","finger-chips","french-fry","fried-potatoes","fries","frites"],
    'mdiFrequentlyAskedQuestions': ["faq"],
    'mdiFridge': ["fridge-filled","refrigerator","kitchen"],
    'mdiFridgeBottom': ["fridge-filled-top","refrigerator-bottom"],
    'mdiFridgeOutline': ["kitchen","refrigerator-outline"],
    'mdiFridgeTop': ["fridge-filled-bottom","refrigerator-top"],
    'mdiFruitCitrus': ["fruit-lemon","fruit-lime"],
    'mdiFruitPineapple': ["fruit-ananas"],
    'mdiFuel': ["petrol","gasoline"],
    'mdiFuelCell': ["battery"],
    'mdiFuriganaHorizontal': ["ruby-horizontal"],
    'mdiFuriganaVertical': ["zhuyin","ruby-vertical"],
    'mdiGamepad': ["games","controller"],
    'mdiGamepadCircle': ["controller-circle"],
    'mdiGamepadCircleDown': ["controller-circle-down"],
    'mdiGamepadCircleLeft': ["controller-circle-left"],
    'mdiGamepadCircleOutline': ["controller-circle-outline"],
    'mdiGamepadCircleRight': ["controller-circle-right"],
    'mdiGamepadCircleUp': ["controller-circle-up"],
    'mdiGamepadDown': ["controller-down"],
    'mdiGamepadLeft': ["controller-left"],
    'mdiGamepadOutline': ["controller-outline","games-outline"],
    'mdiGamepadRight': ["controller-right"],
    'mdiGamepadRound': ["controller-round"],
    'mdiGamepadRoundDown': ["controller-round-down"],
    'mdiGamepadRoundLeft': ["controller-round-left"],
    'mdiGamepadRoundOutline': ["controller-round-outline"],
    'mdiGamepadRoundRight': ["controller-round-right"],
    'mdiGamepadRoundUp': ["controller-round-up"],
    'mdiGamepadSquare': ["controller-square"],
    'mdiGamepadSquareOutline': ["controller-square-outline"],
    'mdiGamepadUp': ["controller-up"],
    'mdiGamepadVariant': ["controller-variant"],
    'mdiGamepadVariantOutline': ["controller-variant-outline"],
    'mdiGarageAlert': ["garage-warning"],
    'mdiGasBurner': ["stove-burner","cooktop-burner","grill","natural-gas","energy"],
    'mdiGasCylinder': ["tank","oxygen-tank"],
    'mdiGasStation': ["gas-pump","petrol-pump","petrol-station","local-gas-station","fuel-station","fuel-pump"],
    'mdiGasStationOutline': ["gas-pump-outline","petrol-pump-outline","petrol-station-outline","fuel-station-outline","fuel-pump-outline"],
    'mdiGateAnd': ["logic-gate-and"],
    'mdiGateNand': ["logic-gate-nand"],
    'mdiGateNor': ["logic-gate-nor"],
    'mdiGateNot': ["logic-gate-not"],
    'mdiGateOr': ["logic-gate-or"],
    'mdiGateXnor': ["logic-gate-xnor"],
    'mdiGateXor': ["logic-gate-xor"],
    'mdiGauge': ["swap-driving-apps-wheel","barometer"],
    'mdiGavel': ["court-hammer"],
    'mdiGenderFemale': ["venus"],
    'mdiGenderMale': ["mars"],
    'mdiGenderMaleFemaleVariant': ["mercury"],
    'mdiGenderNonBinary': ["gender-enby"],
    'mdiGeneratorMobile': ["power-generator","electricity-generator"],
    'mdiGeneratorPortable': ["power-generator","electricity-generator"],
    'mdiGeneratorStationary': ["power-generator","electricity-generator"],
    'mdiGesture': ["freehand-line"],
    'mdiGestureDoubleTap': ["interaction-double-tap","hand-double-tap"],
    'mdiGestureTap': ["interaction-tap","hand-tap","gesture-touch"],
    'mdiGestureTapBox': ["gesture-touch-box"],
    'mdiGestureTapButton': ["call-to-action","cta","button-pointer","gesture-touch-button"],
    'mdiGestureTapHold': ["gesture-touch-hold"],
    'mdiGhost': ["inky","blinky","pinky","clyde"],
    'mdiGift': ["present","package","donate"],
    'mdiGiftOff': ["present-off","package-off","donate-off"],
    'mdiGiftOffOutline': ["present-off-outline","package-off-outline","donate-off-outline"],
    'mdiGiftOpen': ["present-open","package-open"],
    'mdiGiftOpenOutline': ["present-open-outline","package-open-outline"],
    'mdiGiftOutline': ["donate-outline","present-outline","package-outline"],
    'mdiGlassCocktail': ["local-bar","cocktail","martini","alcohol","bar","cup","drink"],
    'mdiGlassFlute': ["alcohol","cocktail","cup","drink"],
    'mdiGlassFragile': ["glass-broken"],
    'mdiGlassMug': ["pub","bar","beer","alcohol","cup","drink","local-bar"],
    'mdiGlassMugVariant': ["pub","bar","beer","drink","alcohol","cup","local-bar"],
    'mdiGlassStange': ["alcohol","bar","cocktail","cup","drink"],
    'mdiGlassTulip': ["bar","alcohol","cocktail","cup","drink"],
    'mdiGlassWine': ["bar","alcohol","cocktail","cup","drink"],
    'mdiGoKart': ["cart"],
    'mdiGolf': ["golf-course"],
    'mdiGondola': ["cable-car"],
    'mdiGraph': ["dependency","dependencies"],
    'mdiGraphOutline': ["dependency","dependencies"],
    'mdiGrass': ["lawn"],
    'mdiGraveStone': ["headstone","tombstone","cemetery","graveyard"],
    'mdiGreenhouse': ["glasshouse","hothouse","shed"],
    'mdiGrid': ["grid-on"],
    'mdiGrill': ["bbq","barbecue","charcoal"],
    'mdiGrillOutline': ["barbecue-outline","bbq-outline","charcoal-outline"],
    'mdiHail': ["hail-taxi","hail-cab"],
    'mdiHalloween': ["pumpkin-face","pumpkin-carved","jack-o-lantern","emoji-halloween","emoticon-halloween"],
    'mdiHamburger': ["burger","fast-food","food"],
    'mdiHamburgerCheck': ["burger-check"],
    'mdiHamburgerMinus': ["burger-minus"],
    'mdiHamburgerOff': ["burger-off","fast-food-off","food-off"],
    'mdiHamburgerPlus': ["burger-plus","burger-add"],
    'mdiHamburgerRemove': ["burger-remove"],
    'mdiHammerScrewdriver': ["tools"],
    'mdiHammerSickle': ["communism"],
    'mdiHammerWrench': ["tools"],
    'mdiHandClap': ["applause"],
    'mdiHandClapOff': ["applause-off"],
    'mdiHandCoin': ["charity","donation"],
    'mdiHandCoinOutline': ["charity-outline","donation-outline"],
    'mdiHandCycle': ["hand-bike"],
    'mdiHandExtended': ["hand-open","hand-palm"],
    'mdiHandExtendedOutline': ["hand-open-outline","hand-palm-outline"],
    'mdiHandHeart': ["volunteer","love","hope"],
    'mdiHandWater': ["hand-wash"],
    'mdiHandWave': ["greeting","farewell"],
    'mdiHandWaveOutline': ["greeting-outline","farewell-outline"],
    'mdiHandball': ["volleyball","human-handball"],
    'mdiHandshake': ["business","deal","help","partnership"],
    'mdiHandshakeOutline': ["business-outline","deal-outline","help-outline","partnership-outline"],
    'mdiHanger': ["coat-hanger","clothes-hanger","closet"],
    'mdiHardHat': ["helmet"],
    'mdiHarddisk': ["hdd"],
    'mdiHarddiskPlus': ["hdd-plus"],
    'mdiHarddiskRemove': ["hdd-remove"],
    'mdiHazardLights': ["warning-lights"],
    'mdiHeadCog': ["psychology"],
    'mdiHeadCogOutline': ["psychology-outline"],
    'mdiHeadDotsHorizontal': ["head-thinking"],
    'mdiHeadDotsHorizontalOutline': ["head-thinking-outline"],
    'mdiHeadFlash': ["head-ache"],
    'mdiHeadFlashOutline': ["head-ache-outline"],
    'mdiHeadHeart': ["head-love"],
    'mdiHeadHeartOutline': ["head-love-outline"],
    'mdiHeadLightbulb': ["head-idea","head-bulb"],
    'mdiHeadLightbulbOutline': ["head-idea-outline","head-bulb-outline"],
    'mdiHeadSnowflake': ["head-freeze","brain-freeze"],
    'mdiHeadSnowflakeOutline': ["head-freeze-outline","brain-freeze-outline"],
    'mdiHeadSync': ["head-reload","head-refresh"],
    'mdiHeadSyncOutline': ["head-reload-outline","head-refresh-outline"],
    'mdiHeadphones': ["headset"],
    'mdiHeadset': ["headset-mic"],
    'mdiHeart': ["favorite","favourite"],
    'mdiHeartFlash': ["aed","defibrillator"],
    'mdiHeartMultiple': ["hearts"],
    'mdiHeartMultipleOutline': ["hearts-outline"],
    'mdiHeartOutline': ["favorite-border","favourite-border","favorite-outline","favourite-outline"],
    'mdiHeartPulse': ["heart-vitals"],
    'mdiHeartSearch': ["find-love"],
    'mdiHeatWave': ["keep-warm","warmth"],
    'mdiHeatingCoil': ["radiator-coil","heated-floor"],
    'mdiHelp': ["question-mark"],
    'mdiHelpBox': ["question-mark-box"],
    'mdiHelpBoxMultiple': ["quiz","question-box-multiple"],
    'mdiHelpBoxMultipleOutline': ["quiz-outline","question-box-multiple-outline"],
    'mdiHelpBoxOutline': ["question-box-outline"],
    'mdiHelpCircle': ["question-mark-circle"],
    'mdiHelpCircleOutline': ["help-outline","question-mark-circle-outline"],
    'mdiHelpNetwork': ["question-network"],
    'mdiHelpNetworkOutline': ["question-network-outline"],
    'mdiHelpRhombus': ["question-mark-rhombus"],
    'mdiHelpRhombusOutline': ["question-mark-rhombus-outline"],
    'mdiHexagonMultiple': ["hexagons"],
    'mdiHexagram': ["star","christmas-star"],
    'mdiHexagramOutline': ["star-outline","christmas-star-outline"],
    'mdiHighDefinition': ["hd"],
    'mdiHighDefinitionBox': ["hd-box","hd"],
    'mdiHighway': ["autobahn","motorway"],
    'mdiHiking': ["human-hiking"],
    'mdiHistory': ["recent","latest","clock-arrow","counterclockwise","restore-clock"],
    'mdiHome': ["house"],
    'mdiHomeAccount': ["home-user","house-account","house-user"],
    'mdiHomeAlert': ["home-warning","house-alert","house-warning"],
    'mdiHomeAlertOutline': ["house-alert-outline","home-warning-outline","house-warning-outline"],
    'mdiHomeAnalytics': ["chart-home","home-chart","home-report","house-analytics","house-chart"],
    'mdiHomeAutomation': ["house-automation","home-wireless","house-wireless","smart-home","smart-house"],
    'mdiHomeBattery': ["home-energy","home-power","home-electricity","house-energy","house-battery","house-power"],
    'mdiHomeBatteryOutline': ["home-energy-outline","home-power-outline","home-electricity-outline","house-battery-outline","house-power-outline","house-energy-outline"],
    'mdiHomeCircle': ["house-circle"],
    'mdiHomeCircleOutline': ["house-circle-outline"],
    'mdiHomeCity': ["house-city"],
    'mdiHomeCityOutline': ["house-city-outline"],
    'mdiHomeClock': ["home-time","home-schedule","house-time","house-clock","house-schedule"],
    'mdiHomeClockOutline': ["home-time-outline","home-schedule-outline","house-clock-outline","house-time-outline","house-schedule-outline"],
    'mdiHomeEdit': ["house-edit"],
    'mdiHomeEditOutline': ["house-edit-outline"],
    'mdiHomeExportOutline': ["house-export-outline"],
    'mdiHomeFlood': ["house-flood"],
    'mdiHomeFloor0': ["house-floor-0","home-floor-zero","house-floor-zero"],
    'mdiHomeFloor1': ["house-floor-1","home-floor-one","house-floor-one","home-floor-first","house-floor-first"],
    'mdiHomeFloor2': ["house-floor-2","home-floor-two","house-floor-two","home-floor-second","house-floor-second"],
    'mdiHomeFloor3': ["house-floor-3","home-floor-three","house-floor-three","home-floor-third","house-floor-third"],
    'mdiHomeFloorA': ["home-floor-attic","house-floor-a","house-floor-attic"],
    'mdiHomeFloorB': ["home-floor-basement","house-floor-b","house-floor-basement"],
    'mdiHomeFloorG': ["home-floor-ground","house-floor-g","house-floor-ground"],
    'mdiHomeFloorL': ["home-floor-loft","home-floor-lower","house-floor-l","house-floor-loft","house-floor-lower"],
    'mdiHomeFloorNegative1': ["house-floor-negative-1","home-floor-negative-one","home-floor-minus-1","home-floor-minus-one","house-floor-negative-one","house-floor-minus-1","house-floor-minus-one"],
    'mdiHomeGroup': ["house-group","neighbourhood","estate","housing-estate"],
    'mdiHomeGroupMinus': ["house-group-minus"],
    'mdiHomeGroupPlus': ["house-group-plus","home-group-add","house-group-add"],
    'mdiHomeGroupRemove': ["house-group-remove"],
    'mdiHomeHeart': ["family","house-heart"],
    'mdiHomeImportOutline': ["house-import-outline"],
    'mdiHomeLightbulb': ["home-bulb","house-lightbulb","house-bulb"],
    'mdiHomeLightbulbOutline': ["home-bulb-outline","house-lightbulb-outline","house-bulb-outline"],
    'mdiHomeLightningBolt': ["home-energy","home-power","home-electricity","home-flash","house-lightning-bolt","house-flash"],
    'mdiHomeLightningBoltOutline': ["home-energy","home-power","home-electricity","home-flash","house-lightning-bolt-outline","house-flash-outline"],
    'mdiHomeLock': ["house-lock","home-secure","house-secure"],
    'mdiHomeLockOpen': ["house-lock-open"],
    'mdiHomeMapMarker': ["house-map-marker","home-location"],
    'mdiHomeMinus': ["house-minus"],
    'mdiHomeMinusOutline': ["house-minus-outline"],
    'mdiHomeModern': ["house-modern"],
    'mdiHomeOff': ["house-off"],
    'mdiHomeOffOutline': ["house-off-outline"],
    'mdiHomeOutline': ["house-outline"],
    'mdiHomePlus': ["home-add","house-plus","house-add"],
    'mdiHomePlusOutline': ["house-plus-outline","house-add-outline"],
    'mdiHomeRemove': ["house-remove"],
    'mdiHomeRemoveOutline': ["house-remove-outline"],
    'mdiHomeRoof': ["home-chimney","home-attic","house-roof","house-attic","house-chimney"],
    'mdiHomeSearch': ["house-search","home-find","house-find"],
    'mdiHomeSearchOutline': ["house-search-outline","home-find-outline","house-find-outline"],
    'mdiHomeSilo': ["farm-house","farm-home"],
    'mdiHomeSiloOutline': ["farm-house-outline","farm-home-outline"],
    'mdiHomeSwitch': ["home-swap","house-switch","house-swap"],
    'mdiHomeSwitchOutline': ["home-swap-outline","house-swap-outline","house-switch-outline"],
    'mdiHomeThermometer': ["home-climate","home-temperature","house-thermometer","house-climate","house-temperature"],
    'mdiHomeThermometerOutline': ["home-climate-outline","home-temperature-outline","house-thermometer-outline","house-climate-outline","house-temperature-outline"],
    'mdiHomeVariant': ["house-variant"],
    'mdiHomeVariantOutline': ["house-variant-outline"],
    'mdiHoopHouse': ["green-house","high-tunnel"],
    'mdiHorse': ["equestrian"],
    'mdiHorseHuman': ["horseback-riding","horse-riding","equestrian"],
    'mdiHorseVariant': ["equestrian-variant"],
    'mdiHorseshoe': ["luck"],
    'mdiHospital': ["swiss-cross","dispensary"],
    'mdiHospitalBox': ["local-hospital","swiss-cross-box","dispensary-box"],
    'mdiHospitalBoxOutline': ["swiss-cross-box-outline","dispensary-box-outline"],
    'mdiHospitalMarker': ["hospital-location"],
    'mdiHuman': ["accessibility"],
    'mdiHumanCane': ["elderly"],
    'mdiHumanCapacityDecrease': ["human-capacity-reduce"],
    'mdiHumanDolly': ["human-hand-truck","human-trolley"],
    'mdiHumanFemale': ["woman"],
    'mdiHumanFemaleBoy': ["mother","mom","woman-child","mum"],
    'mdiHumanFemaleDance': ["ballet"],
    'mdiHumanFemaleFemale': ["woman-woman","women"],
    'mdiHumanFemaleFemaleChild': ["family"],
    'mdiHumanFemaleGirl': ["mother","mom","woman-child","mum"],
    'mdiHumanGreeting': ["human-hello","human-welcome"],
    'mdiHumanGreetingProximity': ["connect-without-contact"],
    'mdiHumanGreetingVariant': ["human-hello-variant"],
    'mdiHumanMale': ["man"],
    'mdiHumanMaleBoard': ["teacher","teaching","lecture","college","blackboard","whiteboard","human-man-board"],
    'mdiHumanMaleBoardPoll': ["teach-poll"],
    'mdiHumanMaleBoy': ["father","dad","man-child"],
    'mdiHumanMaleFemale': ["wc","man-woman"],
    'mdiHumanMaleFemaleChild': ["family","mom-dad-child"],
    'mdiHumanMaleGirl': ["father","dad","man-child"],
    'mdiHumanMaleMale': ["man-man","men"],
    'mdiHumanMaleMaleChild': ["family"],
    'mdiHumanNonBinary': ["human-genderless","human-transgender"],
    'mdiHumanPregnant': ["pregnant-woman"],
    'mdiHumanQueue': ["human-line"],
    'mdiHumanWheelchair': ["human-accessible"],
    'mdiHumanWhiteCane': ["human-blind"],
    'mdiHvac': ["heating","ventilation","air-conditioning"],
    'mdiHvacOff': ["heating-off","ventilation-off","air-conditioning-off"],
    'mdiHydroPower': ["hydraulic-turbine","water-turbine","watermill"],
    'mdiIcePop': ["popsicle"],
    'mdiIdentifier': ["key"],
    'mdiIdeogramCjk': ["ideogram-chinese-japanese-korean","writing-system-cjk"],
    'mdiIdeogramCjkVariant': ["ideogram-chinese-japanese-korean-variant","writing-system-cjk-variant"],
    'mdiImage': ["insert-photo"],
    'mdiImageAlbum': ["photo-album","book-image"],
    'mdiImageAutoAdjust': ["image-filter"],
    'mdiImageBrokenVariant': ["broken-image"],
    'mdiImageFilterBlackWhite': ["filter-b-and-w"],
    'mdiImageFilterCenterFocus': ["image-filter-centre-focus"],
    'mdiImageFilterCenterFocusWeak': ["image-filter-centre-focus-weak"],
    'mdiImageFilterHdr': ["mountain","landscape"],
    'mdiImageFilterHdrOutline': ["mountain-outline","landscape-outline"],
    'mdiImageFrame': ["hallway","foyer","entry-room"],
    'mdiImageLock': ["image-secure"],
    'mdiImageLockOutline': ["image-secure-outline"],
    'mdiImageMarker': ["image-location"],
    'mdiImageMarkerOutline': ["image-location-outline"],
    'mdiImageMultiple': ["collections","photo-library","images"],
    'mdiImageMultipleOutline': ["image-filter","images-outline"],
    'mdiImagePlus': ["image-add"],
    'mdiImagePlusOutline': ["image-add-outline"],
    'mdiImageText': ["image-description"],
    'mdiImport': ["input"],
    'mdiInboxArrowDown': ["move-to-inbox"],
    'mdiInboxArrowUp': ["move-from-inbox"],
    'mdiInboxMultiple': ["inboxes"],
    'mdiInboxMultipleOutline': ["inboxes-outline"],
    'mdiIncognito': ["anonymous","spy"],
    'mdiIncognitoCircle': ["anonymous-circle","spy-circle"],
    'mdiIncognitoCircleOff': ["anonymous-circle-off","spy-circle-off"],
    'mdiIncognitoOff': ["spy-off","anonymous-off"],
    'mdiInduction': ["ignition"],
    'mdiInformation': ["about","information-circle","info-circle","about-circle","info"],
    'mdiInformationBox': ["info-box"],
    'mdiInformationBoxOutline': ["info-box-outline"],
    'mdiInformationOff': ["info-off","info-circle-off","information-circle-off"],
    'mdiInformationOffOutline': ["info-circle-off-outline","information-circle-off-outline","information-off-outline","info-off-outline"],
    'mdiInformationOutline': ["info-outline","about-outline","information-circle-outline","info-circle-outline","about-circle-outline"],
    'mdiInformationSlabBox': ["info-slab-box"],
    'mdiInformationSlabBoxOutline': ["info-slab-box-outline"],
    'mdiInformationSlabCircle': ["info-slab-circle"],
    'mdiInformationSlabCircleOutline': ["info-slab-circle-outline"],
    'mdiInformationSlabSymbol': ["info-slab-symbol"],
    'mdiInformationSymbol': ["info-symbol"],
    'mdiInformationVariant': ["info-variant","about-variant","information-serif-symbol","info-variant-symbol"],
    'mdiInformationVariantBox': ["info-variant-box","information-serif-box","info-serif-box"],
    'mdiInformationVariantBoxOutline': ["info-variant-box-outline","information-serif-box-outline","info-serif-box-outline"],
    'mdiInformationVariantCircle': ["information-serif-circle","info-serif-circle","info-variant-circle"],
    'mdiInformationVariantCircleOutline': ["information-serif-circle-outline","info-variant-circle-outline","info-serif-circle-outline"],
    'mdiInstrumentTriangle': ["dinner-bell"],
    'mdiIntegratedCircuitChip': ["icc","chip"],
    'mdiInvertColors': ["invert-colours"],
    'mdiInvertColorsOff': ["invert-colours-off"],
    'mdiInvoiceClock': ["invoice-scheduled"],
    'mdiInvoiceClockOutline': ["invoice-scheduled-outline"],
    'mdiInvoiceExportOutline': ["invoice-outbound-outline"],
    'mdiInvoiceImport': ["invoice-inbound"],
    'mdiInvoiceImportOutline': ["invoice-inbound-outline"],
    'mdiInvoiceList': ["invoice-line-items"],
    'mdiInvoiceListOutline': ["invoice-line-items-outline"],
    'mdiInvoicePlus': ["invoice-new"],
    'mdiInvoicePlusOutline': ["invoice-new-outline"],
    'mdiInvoiceTextClock': ["invoice-text-scheduled"],
    'mdiInvoiceTextClockOutline': ["invoice-text-scheduled-outline"],
    'mdiInvoiceTextPlus': ["invoice-text-new"],
    'mdiInvoiceTextPlusOutline': ["invoice-text-new-outline"],
    'mdiIp': ["internet-protocol"],
    'mdiIpOutline': ["internet-protocol-outline"],
    'mdiIpod': ["apple-ipod"],
    'mdiIron': ["flatiron","smoothing-iron"],
    'mdiIronOutline': ["flatiron-outline","smoothing-iron-outline"],
    'mdiKabaddi': ["wrestling","human-kabaddi"],
    'mdiKangaroo': ["marsupial"],
    'mdiKarate': ["martial-arts","kickboxing","human-karate"],
    'mdiKayaking': ["human-kayaking"],
    'mdiKettle': ["tea-kettle","kettle-full","tea-kettle-full"],
    'mdiKettleAlert': ["tea-kettle-alert","kettle-full-alert","tea-kettle-full-alert"],
    'mdiKettleAlertOutline': ["tea-kettle-alert-outline","kettle-empty-alert","tea-kettle-empty-alert"],
    'mdiKettleOff': ["tea-kettle-off","tea-kettle-full-off","kettle-full-off"],
    'mdiKettleOffOutline': ["tea-kettle-off-outline","kettle-empty-off","tea-kettle-empty-off"],
    'mdiKettleOutline': ["tea-kettle-outline","kettle-empty","tea-kettle-empty"],
    'mdiKettleSteam': ["tea-kettle-steam","kettle-full-steam","tea-kettle-full-steam"],
    'mdiKettleSteamOutline': ["tea-kettle-steam-outline","kettle-empty-steam","tea-kettle-empty-steam"],
    'mdiKey': ["vpn-key"],
    'mdiKeyLink': ["foreign-key","sql-foreign-key"],
    'mdiKeyPlus': ["key-add"],
    'mdiKeyStar': ["primary-key","sql-primary-key","key-favorite"],
    'mdiKeyboardBackspace': ["keyboard-clear","keyboard-erase"],
    'mdiKeyboardCaps': ["keyboard-capslock"],
    'mdiKeyboardClose': ["keyboard-hide"],
    'mdiKeyboardCloseOutline': ["keyboard-hide-outline"],
    'mdiKhanda': ["sikh"],
    'mdiKnife': ["silverware-knife","cutlery-knife"],
    'mdiKnifeMilitary': ["dagger"],
    'mdiKnob': ["volume-knob","volume-control","dial","tuner","switch","adjuster"],
    'mdiKoala': ["marsupial","emoji-koala","emoticon-koala"],
    'mdiLadybug': ["bugfood","ladybird"],
    'mdiLamps': ["lights"],
    'mdiLampsOutline': ["lights-outline"],
    'mdiLan': ["local-area-network"],
    'mdiLanConnect': ["local-area-network-connect"],
    'mdiLanDisconnect': ["local-area-network-disconnect"],
    'mdiLanPending': ["local-area-network-pending"],
    'mdiLandslide': ["avalanche","mudslide"],
    'mdiLandslideOutline': ["avalanche-outline","mudslide-outline"],
    'mdiLaptop': ["computer"],
    'mdiLaptopAccount': ["teleconference","virtual-meeting","video-chat"],
    'mdiLayersOff': ["layers-clear"],
    'mdiLeafCircle': ["green-circle","organic"],
    'mdiLeafCircleOutline': ["green-circle-outline","organic-outline"],
    'mdiLeak': ["proximity-sensor"],
    'mdiLeakOff': ["proximity-sensor-off"],
    'mdiLectern': ["podium","dais","rostrum","lecturn"],
    'mdiLedStrip': ["light-strip"],
    'mdiLedStripVariant': ["light-strip-variant"],
    'mdiLedStripVariantOff': ["light-strip-variant-off"],
    'mdiLibrary': ["local-library"],
    'mdiLibraryOutline': ["local-library-outline"],
    'mdiLicense': ["ribbon","prize","award","seal"],
    'mdiLifebuoy': ["life-preserver","support","help","overboard"],
    'mdiLightFloodDown': ["floodlight-down"],
    'mdiLightFloodUp': ["floodlight-up"],
    'mdiLightRecessed': ["can-light","pot-light","high-hat-light","hi-hat-light","downlight"],
    'mdiLightSwitch': ["toggle-switch","rocker-switch"],
    'mdiLightSwitchOff': ["toggle-switch-off","rocker-switch-off"],
    'mdiLightbulb': ["idea","bulb"],
    'mdiLightbulbAlert': ["lightbulb-error"],
    'mdiLightbulbAlertOutline': ["lightbulb-error-outline"],
    'mdiLightbulbAuto': ["lightbulb-automatic","lightbulb-motion"],
    'mdiLightbulbAutoOutline': ["lightbulb-automatic-outline","lightbulb-motion-outline"],
    'mdiLightbulbCfl': ["bulb-cfl"],
    'mdiLightbulbCflOff': ["bulb-cfl-off"],
    'mdiLightbulbCflSpiral': ["bulb-cfl-spiral"],
    'mdiLightbulbCflSpiralOff': ["bulb-cfl-spiral-off"],
    'mdiLightbulbGroup': ["bulb-group"],
    'mdiLightbulbGroupOff': ["bulb-group-off"],
    'mdiLightbulbGroupOffOutline': ["bulb-group-off-outline"],
    'mdiLightbulbGroupOutline': ["bulb-group-outline"],
    'mdiLightbulbMultiple': ["lightbulbs","bulb-multiple","bulbs"],
    'mdiLightbulbMultipleOff': ["lightbulbs-off","bulb-multiple-off","bulbs-off"],
    'mdiLightbulbMultipleOffOutline': ["lightbulbs-off-outline","bulb-multiple-off-outline","bulbs-off-outline"],
    'mdiLightbulbMultipleOutline': ["lightbulbs-outline","bulb-multiple-outline","bulbs-outline"],
    'mdiLightbulbNight': ["night-light","nite-light","lightbulb-moon-star"],
    'mdiLightbulbNightOutline': ["night-light-outline","nite-light-outline","lightbulb-moon-star-outline"],
    'mdiLightbulbOff': ["bulb-off"],
    'mdiLightbulbOffOutline': ["bulb-off-outline"],
    'mdiLightbulbOn': ["idea","bulb-on","lightbulb-dimmer-100"],
    'mdiLightbulbOn10': ["lightbulb-dimmer-10"],
    'mdiLightbulbOn20': ["lightbulb-dimmer-20"],
    'mdiLightbulbOn30': ["lightbulb-dimmer-30"],
    'mdiLightbulbOn40': ["lightbulb-dimmer-40"],
    'mdiLightbulbOn50': ["lightbulb-dimmer-50"],
    'mdiLightbulbOn60': ["lightbulb-dimmer-60"],
    'mdiLightbulbOn70': ["lightbulb-dimmer-70"],
    'mdiLightbulbOn80': ["lightbulb-dimmer-80"],
    'mdiLightbulbOn90': ["lightbulb-dimmer-90"],
    'mdiLightbulbOnOutline': ["idea","bulb-on-outline"],
    'mdiLightbulbOutline': ["idea","bulb-outline"],
    'mdiLightbulbQuestion': ["lightbulb-help"],
    'mdiLightbulbQuestionOutline': ["lightbulb-help-outline"],
    'mdiLightbulbSpot': ["lightbulb-halogen","lightbulb-gu10"],
    'mdiLightbulbSpotOff': ["lightbulb-halogen-off","lightbulb-gu10-off"],
    'mdiLightbulbVariant': ["lightbulb-edison","lightbulb-filament"],
    'mdiLightbulbVariantOutline': ["lightbulb-edison-outline","lightbulb-filament-outline"],
    'mdiLighthouse': ["beacon"],
    'mdiLighthouseOn': ["beacon"],
    'mdiLightningBolt': ["thunder","storm","energy","electricity"],
    'mdiLightningBoltCircle': ["amp","offline-bolt","flash-circle","electricity-circle","energy-circle","thunder-circle","storm-circle"],
    'mdiLightningBoltOutline': ["thunder-outline","storm-outline","energy-outline","electricity-outline"],
    'mdiLingerie': ["underwear","bra","panties"],
    'mdiLink': ["insert-link"],
    'mdiLinkLock': ["block-chain"],
    'mdiLinkPlus': ["link-add"],
    'mdiLiquidSpot': ["ink-spot","puddle","water","blood","spill","oil","dirty"],
    'mdiLiquor': ["booze","alcohol","beverages","whiskey","rum","wine","tequila","beer","spirits"],
    'mdiListBox': ["form"],
    'mdiListBoxOutline': ["form-outline"],
    'mdiLocationEnter': ["presence-enter"],
    'mdiLocationExit': ["presence-exit"],
    'mdiLock': ["https","password","secure","protected","encryption"],
    'mdiLockAlert': ["lock-warning","password-alert","encryption-alert","password-warning","encryption-warning"],
    'mdiLockAlertOutline': ["lock-warning-outline","password-alert-outline","encryption-alert-outline","password-warning-outline","encryption-warning-outline"],
    'mdiLockCheck': ["password-check","password-secure","encryption-check","encryption-secure","password-verified","encryption-verified"],
    'mdiLockCheckOutline': ["password-check-outline","password-secure-outline","encryption-check-outline","encryption-secure-outline","password-verified-outline","encryption-verified-outline"],
    'mdiLockClock': ["confidential-mode","password-clock","password-expiration","encryption-expiration"],
    'mdiLockMinus': ["password-minus","encryption-minus"],
    'mdiLockMinusOutline': ["password-minus-outline","encryption-minus"],
    'mdiLockOff': ["password-off","not-protected","unsecure","encryption-off"],
    'mdiLockOffOutline': ["password-off-outline","unsecure-outline","not-protected-outline","encryption-off-outline"],
    'mdiLockOpen': ["unlocked","decrypted"],
    'mdiLockOpenAlert': ["unlocked-alert","decrypted-alert","lock-open-warning","unlocked-warning","decrypted-warning"],
    'mdiLockOpenAlertOutline': ["unlocked-alert-outline","lock-open-warning-outline","decrypted-alert-outline","unlocked-warning-outline","decrypted-warning-outline"],
    'mdiLockOpenCheck': ["unlocked-check","decrypted-check"],
    'mdiLockOpenCheckOutline': ["unlocked-check-outline","decrypted-check-outline"],
    'mdiLockOpenMinus': ["unlocked-minus","decrypted-minus"],
    'mdiLockOpenMinusOutline': ["unlocked-minus-outline","decrypted-minus-outline"],
    'mdiLockOpenOutline': ["unlocked-outline","decrypted-outline"],
    'mdiLockOpenPlus': ["unlocked-plus","decrypted-plus","lock-open-add","unlocked-add","decrypted-add"],
    'mdiLockOpenPlusOutline': ["unlocked-plus-outline","lock-open-add-outline","unlocked-add-outline","decrypted-plus-outline","decrypted-add-outline"],
    'mdiLockOpenRemove': ["unlocked-remove","decrypted-remove"],
    'mdiLockOpenRemoveOutline': ["unlocked-remove-outline","decrypted-remove-outline"],
    'mdiLockOpenVariant': ["unlocked-variant","decrypted-variant"],
    'mdiLockOpenVariantOutline': ["unlocked-variant-outline","decrypted-variant-outline"],
    'mdiLockOutline': ["password-outline","secure-outline","https-outline","protected-outline","encryption-outline"],
    'mdiLockPercent': ["lock-rate"],
    'mdiLockPercentOpen': ["lock-rate-open"],
    'mdiLockPercentOpenOutline': ["lock-rate-open-outline"],
    'mdiLockPercentOpenVariant': ["lock-rate-open-variant"],
    'mdiLockPercentOpenVariantOutline': ["lock-rate-open-variant-outline"],
    'mdiLockPercentOutline': ["lock-rate-outline"],
    'mdiLockPlus': ["enhanced-encryption","lock-add","encryption-add","password-add","password-plus","encryption-plus"],
    'mdiLockPlusOutline': ["lock-add-outline","password-plus-outline","password-add-outline","encryption-plus-outline","encryption-add-outline"],
    'mdiLockQuestion': ["forgot-password","password-question","encryption-question"],
    'mdiLockRemove': ["password-remove","encryption-remove"],
    'mdiLockRemoveOutline': ["password-remove-outline","encryption-remove-outline"],
    'mdiLockReset': ["password-reset","encryption-reset"],
    'mdiLockerMultiple': ["lockers"],
    'mdiLogin': ["log-in","sign-in"],
    'mdiLoginVariant': ["log-in-variant","sign-in-variant"],
    'mdiLogout': ["log-out","sign-out"],
    'mdiLogoutVariant': ["log-out-variant","sign-out-variant"],
    'mdiLooks': ["rainbow"],
    'mdiLotionPlus': ["hand-sanitizer"],
    'mdiLotionPlusOutline': ["hand-sanitizer-outline"],
    'mdiLoupe': ["zoom-plus","circle-plus-outline","magnify"],
    'mdiMagazinePistol': ["ammunition-pistol"],
    'mdiMagazineRifle': ["ammunition-rifle"],
    'mdiMagicStaff': ["staff-shimmer","magic-wand"],
    'mdiMagnify': ["search"],
    'mdiMagnifyExpand': ["search-expand"],
    'mdiMagnifyMinus': ["zoom-out","search-minus"],
    'mdiMagnifyMinusCursor': ["zoom-out-cursor"],
    'mdiMagnifyMinusOutline': ["zoom-out-outline","search-minus-outline"],
    'mdiMagnifyPlus': ["zoom-in","magnify-add","search-plus","search-add"],
    'mdiMagnifyPlusCursor': ["zoom-in-cursor","magnify-add-cursor"],
    'mdiMagnifyPlusOutline': ["zoom-in-outline","magnify-add-outline","search-plus-outline","search-add-outline"],
    'mdiMapCheck': ["map-tick"],
    'mdiMapCheckOutline': ["map-tick-outline"],
    'mdiMapClock': ["timezone"],
    'mdiMapClockOutline': ["timezone-outline"],
    'mdiMapMarker': ["location","address-marker","location-on","place","room"],
    'mdiMapMarkerAlert': ["location-alert","location-warning"],
    'mdiMapMarkerAlertOutline': ["location-alert-outline","location-warning-outline"],
    'mdiMapMarkerCheck': ["map-marker-tick","where-to-vote","location-check"],
    'mdiMapMarkerCheckOutline': ["location-check-outline","where-to-vote-outline"],
    'mdiMapMarkerCircle': ["explore-nearby","location-circle"],
    'mdiMapMarkerDistance': ["location-distance"],
    'mdiMapMarkerDown': ["location-down"],
    'mdiMapMarkerLeft': ["location-left"],
    'mdiMapMarkerLeftOutline': ["location-left-outline"],
    'mdiMapMarkerMinus': ["location-minus"],
    'mdiMapMarkerMinusOutline': ["location-minus-outline"],
    'mdiMapMarkerMultiple': ["map-markers","location-multiple","locations"],
    'mdiMapMarkerMultipleOutline': ["locations-outline","location-multiple-outline","map-markers-outline"],
    'mdiMapMarkerOff': ["location-off"],
    'mdiMapMarkerOffOutline': ["location-off-outline"],
    'mdiMapMarkerOutline': ["location-outline","address-marker-outline","location-on-outline","place-outline"],
    'mdiMapMarkerPath': ["location-path"],
    'mdiMapMarkerPlus': ["location-plus","map-marker-add","location-add"],
    'mdiMapMarkerPlusOutline': ["map-marker-add-outline","location-plus-outline","location-add-outline"],
    'mdiMapMarkerQuestion': ["location-question"],
    'mdiMapMarkerQuestionOutline': ["location-question-outline"],
    'mdiMapMarkerRadius': ["location-radius"],
    'mdiMapMarkerRadiusOutline': ["location-radius-outline"],
    'mdiMapMarkerRemove': ["location-remove"],
    'mdiMapMarkerRemoveOutline': ["location-remove-outline"],
    'mdiMapMarkerRemoveVariant': ["location-remove-variant-outline"],
    'mdiMapMarkerRight': ["location-right"],
    'mdiMapMarkerRightOutline': ["location-right-outline"],
    'mdiMapMarkerStar': ["map-marker-favorite","location-star","location-favorite"],
    'mdiMapMarkerStarOutline': ["map-marker-favorite-outline","location-star-outline","location-favorite-outline"],
    'mdiMapMarkerUp': ["location-up"],
    'mdiMapPlus': ["map-add"],
    'mdiMarker': ["highlighter"],
    'mdiMarkerCheck': ["beenhere","marker-tick"],
    'mdiMathCompass': ["maths-compass"],
    'mdiMathCos': ["math-cosine","maths-cos"],
    'mdiMathNorm': ["code-or","parallel"],
    'mdiMathNormBox': ["code-or-box","parallel-box"],
    'mdiMathSin': ["math-sine","maths-sin"],
    'mdiMathTan': ["math-tangent","maths-tan"],
    'mdiMedal': ["award"],
    'mdiMedicalBag': ["first-aid-kit","medicine"],
    'mdiMedicalCottonSwab': ["covid-test","medicine"],
    'mdiMedication': ["pill-bottle","medicine-bottle","bottle-plus"],
    'mdiMedicationOutline': ["pill-bottle-outline","medicine-bottle-outline","bottle-plus-outline"],
    'mdiMeditation': ["human-meditation"],
    'mdiMemory': ["chip"],
    'mdiMemoryArrowDown': ["chip-arrow-down"],
    'mdiMenorah': ["candelabrum","candelabra","candle"],
    'mdiMenorahFire': ["menorah-flame","candle-flame","candelabra-flame","candelabra-fire","candle-fire","candelabrum-fire","candelabrum-flame"],
    'mdiMenu': ["hamburger-menu"],
    'mdiMenuClose': ["hamburger-close"],
    'mdiMenuDown': ["arrow-drop-down","caret-down"],
    'mdiMenuDownOutline': ["caret-down-outline"],
    'mdiMenuLeft': ["arrow-left"],
    'mdiMenuOpen': ["hamburger-open"],
    'mdiMenuRight': ["arrow-right"],
    'mdiMenuUp': ["arrow-drop-up","caret-up"],
    'mdiMenuUpOutline': ["caret-up-outline"],
    'mdiMessage': ["chat-bubble"],
    'mdiMessageAlert': ["feedback","message-warning","announcement","sms-failed"],
    'mdiMessageAlertOutline': ["announcement-outline","feedback-outline","message-warning-outline","sms-failed-outline"],
    'mdiMessageBadge': ["message-unread","message-notification"],
    'mdiMessageBadgeOutline': ["message-unread-outline","message-notification-outline"],
    'mdiMessageBulleted': ["speaker-notes"],
    'mdiMessageBulletedOff': ["speaker-notes-off"],
    'mdiMessageDraw': ["rate-review"],
    'mdiMessageFlash': ["message-quick"],
    'mdiMessageFlashOutline': ["message-quick-outline"],
    'mdiMessageImage': ["mms"],
    'mdiMessageLock': ["message-secure"],
    'mdiMessageOutline': ["chat-bubble-outline"],
    'mdiMessagePlus': ["message-add"],
    'mdiMessageProcessing': ["sms","textsms"],
    'mdiMessageReply': ["mode-comment"],
    'mdiMessageReplyText': ["comment","insert-comment"],
    'mdiMessageText': ["chat"],
    'mdiMessageTextLock': ["message-text-secure"],
    'mdiMessageVideo': ["voice-chat"],
    'mdiMeterElectric': ["power-meter","electricity"],
    'mdiMeterElectricOutline': ["power-meter-outline","electricity-outline"],
    'mdiMeterGas': ["natural-gas"],
    'mdiMeterGasOutline': ["natural-gas-outline"],
    'mdiMetronome': ["tempo","bpm","beats-per-minute"],
    'mdiMetronomeTick': ["tempo-tick","bpm-tick","beats-per-minute-tick"],
    'mdiMicrophone': ["keyboard-voice"],
    'mdiMicrophoneMessage': ["tts","text-to-speech"],
    'mdiMicrophoneMessageOff': ["tts-off","text-to-speech-off"],
    'mdiMicrophoneMinus': ["microphone-remove"],
    'mdiMicrophoneOff': ["mic-off"],
    'mdiMicrophoneOutline': ["mic-none"],
    'mdiMicrophonePlus': ["microphone-add"],
    'mdiMicrophoneQuestion': ["microphone-help"],
    'mdiMicrophoneQuestionOutline': ["microphone-help-outline"],
    'mdiMicrophoneSettings': ["settings-voice"],
    'mdiMicrosoftXboxControllerBatteryUnknown': ["microsoft-xbox-gamepad-battery-unknown"],
    'mdiMicrowave': ["microwave-oven"],
    'mdiMinus': ["remove","horizontal-line","minimize"],
    'mdiMinusBox': ["indeterminate-check-box"],
    'mdiMinusBoxMultiple': ["library-minus"],
    'mdiMinusBoxMultipleOutline': ["library-minus-outline"],
    'mdiMinusBoxOutline': ["checkbox-indeterminate-outline"],
    'mdiMinusCircle': ["do-not-disturb-on","remove-circle","do-not-enter","pill-tablet","medicine","pharmaceutical"],
    'mdiMinusCircleMultiple': ["coins-minus"],
    'mdiMinusCircleMultipleOutline': ["coins-minus-outline"],
    'mdiMinusCircleOff': ["do-not-disturb-off","remove-circle-off","do-not-enter-off"],
    'mdiMinusCircleOffOutline': ["do-not-disturb-off-outline","remove-circle-off-outline","do-not-enter-off-outline"],
    'mdiMinusCircleOutline': ["remove-circle-outline","do-not-enter-outline","do-not-disturb-outline","pill-tablet-outline","medicine-outline","pharmaceutical"],
    'mdiMixedMartialArts': ["mma","glove"],
    'mdiMoleculeCo': ["carbon-monoxide","gas-co"],
    'mdiMoleculeCo2': ["periodic-table-carbon-dioxide","gas-co2"],
    'mdiMonitor': ["desktop-windows"],
    'mdiMonitorAccount': ["teleconference","virtual-meeting","video-chat"],
    'mdiMonitorArrowDown': ["monitor-download"],
    'mdiMonitorArrowDownVariant': ["monitor-download"],
    'mdiMonitorCellphone': ["monitor-mobile-phone","monitor-smartphone"],
    'mdiMonitorCellphoneStar': ["important-devices","monitor-mobile-phone-star","monitor-smartphone-star","monitor-cellphone-favorite"],
    'mdiMonitorMultiple': ["monitors"],
    'mdiMonitorShimmer': ["monitor-clean"],
    'mdiMonitorSmall': ["monitor-crt"],
    'mdiMonitorStar': ["monitor-favorite"],
    'mdiMoped': ["scooter","vespa","delivery-dining"],
    'mdiMopedElectric': ["scooter-electric","vespa-electric","delivery-dining-electric"],
    'mdiMopedElectricOutline': ["scooter-electric-outline","vespa-electric-outline","delivery-dining-electric-outline"],
    'mdiMopedOutline': ["scooter-outline","vespa-outline","delivery-dining-outline"],
    'mdiMortarPestlePlus': ["chemist","local-pharmacy","mortar-pestle","pharmaceutical"],
    'mdiMosque': ["islam","muslim"],
    'mdiMosqueOutline': ["islam","muslim"],
    'mdiMotherNurse': ["breast-feed"],
    'mdiMotionSensor': ["motion-detector"],
    'mdiMotorbike': ["motorcycle"],
    'mdiMotorbikeElectric': ["motorcycle-electric"],
    'mdiMotorbikeOff': ["motorcycle-off"],
    'mdiMovie': ["slate","clapperboard","film","movie-creation"],
    'mdiMovieCheck': ["slate-check","clapperboard-check","film-check"],
    'mdiMovieCheckOutline': ["slate-check-outline","clapperboard-check-outline","film-check-outline"],
    'mdiMovieCog': ["slate-cog","clapperboard-cog","film-cog"],
    'mdiMovieCogOutline': ["slate-cog-outline","clapperboard-cog-outline","film-cog-outline"],
    'mdiMovieEdit': ["slate-edit","clapperboard-edit","film-edit"],
    'mdiMovieEditOutline': ["slate-edit-outline","clapperboard-edit-outline","film-edit-outline"],
    'mdiMovieMinus': ["slate-minus","clapperboard-minus","film-minus"],
    'mdiMovieMinusOutline': ["slate-minus-outline","clapperboard-minus-outline","film-minus-outline"],
    'mdiMovieOff': ["slate-off","clapperboard-off","film-off"],
    'mdiMovieOffOutline': ["slate-off-outline","clapperboard-off-outline","film-off-outline"],
    'mdiMovieOpen': ["slate-open","clapperboard-open","film-open","movie-creation"],
    'mdiMovieOpenCheck': ["slate-open-check","clapperboard-open-check","film-open-check"],
    'mdiMovieOpenCheckOutline': ["slate-open-check-outline","clapperboard-open-check-outline","film-open-check-outline"],
    'mdiMovieOpenCog': ["slate-open-cog","clapperboard-open-cog","film-open-cog"],
    'mdiMovieOpenCogOutline': ["slate-open-cog-outline","clapperboard-open-cog-outline","film-open-cog-outline"],
    'mdiMovieOpenEdit': ["slate-open-edit","clapperboard-open-edit","film-open-edit"],
    'mdiMovieOpenEditOutline': ["slate-open-edit-outline","clapperboard-open-edit-outline","film-open-edit-outline"],
    'mdiMovieOpenMinus': ["slate-open-minus","clapperboard-open-minus","film-open-minus"],
    'mdiMovieOpenMinusOutline': ["slate-open-minus-outline","clapperboard-open-minus-outline","film-open-minus-outline"],
    'mdiMovieOpenOff': ["slate-open-off","clapperboard-open-off","film-open-off"],
    'mdiMovieOpenOffOutline': ["slate-open-off-outline","clapperboard-open-off-outline","film-open-off-outline"],
    'mdiMovieOpenOutline': ["slate-open-outline","clapperboard-open-outline","film-open-outline","movie-creation"],
    'mdiMovieOpenPlay': ["slate-open-play","clapperboard-open-play","film-open-play"],
    'mdiMovieOpenPlayOutline': ["slate-open-play-outline","clapperboard-open-play-outline","film-open-play-outline"],
    'mdiMovieOpenPlus': ["clapperboard-open-plus","slate-open-plus","flim-open-plus"],
    'mdiMovieOpenPlusOutline': ["slate-open-plus-outline","clapperboard-open-plus-outline","film-open-plus-outline"],
    'mdiMovieOpenRemove': ["slate-open-remove","clapperboard-open-remove","film-open-remove"],
    'mdiMovieOpenRemoveOutline': ["slate-open-remove-outline","clapperboard-open-remove-outline","film-open-remove-outline"],
    'mdiMovieOpenSettings': ["slate-open-settings","clapperboard-open-settings","film-open-settings"],
    'mdiMovieOpenSettingsOutline': ["slate-open-settings-outline","clapperboard-open-settings-outline","film-open-settings-outline"],
    'mdiMovieOpenStar': ["slate-open-star","clapperboard-open-star","film-open-star","movie-open-favorite"],
    'mdiMovieOpenStarOutline': ["slate-open-star-outline","clapperboard-open-star-outline","film-open-star-outline","movie-open-favorite-outline"],
    'mdiMovieOutline': ["slate-outline","clapperboard-outline","film-outline"],
    'mdiMoviePlay': ["slate-play","clapperboard-play","film-play"],
    'mdiMoviePlayOutline': ["slate-play-outline","clapperboard-play-outline","film-play-outline"],
    'mdiMoviePlus': ["slate-plus","clapperboard-plus","film-plus"],
    'mdiMoviePlusOutline': ["slate-plus-outline","clapperboard-plus-outline","film-plus-outline"],
    'mdiMovieRemove': ["slate-remove","clapperboard-remove","film-remove"],
    'mdiMovieRemoveOutline': ["slate-remove-outline","clapperboard-remove-outline","film-remove-outline"],
    'mdiMovieRoll': ["film-reel"],
    'mdiMovieSettings': ["slate-settings","clapperboard-settings","film-settings"],
    'mdiMovieSettingsOutline': ["slate-settings-outline","clapperboard-settings-outline","film-settings-outline"],
    'mdiMovieStar': ["slate-star","clapperboard-star","film-star","movie-favorite"],
    'mdiMovieStarOutline': ["slate-star-outline","clapperboard-star-outline","film-star-outline","movie-favorite-outline"],
    'mdiMulticast': ["multiplex","broadcast"],
    'mdiMultimedia': ["audio","video","image","music","movie","picture"],
    'mdiMushroom': ["fungus"],
    'mdiMushroomOutline': ["fungus-outline"],
    'mdiMusicBoxMultiple': ["library-music"],
    'mdiMusicBoxMultipleOutline': ["library-music-outline"],
    'mdiMusicCircle': ["note-circle"],
    'mdiMusicCircleOutline': ["note-circle-outline"],
    'mdiMusicClefAlto': ["music-c-clef","music-clef-tenor","music-clef-soprano","music-clef-baritone"],
    'mdiMusicClefBass': ["music-f-clef"],
    'mdiMusicClefTreble': ["music-g-clef"],
    'mdiMusicNotePlus': ["music-note-add"],
    'mdiNas': ["network-attached-storage"],
    'mdiNature': ["plant"],
    'mdiNaturePeople': ["plant"],
    'mdiNavigation': ["arrow-compass"],
    'mdiNeedle': ["syringe","injection","medicine","shot","drug","immunization","pharmaceutical"],
    'mdiNeedleOff': ["syringe-off","injection-off","medicine-off","shot-off","drug-off","immunization-off","pharmaceutical-off"],
    'mdiNetworkPos': ["network-point-of-sale","network-cash-box"],
    'mdiNetworkStrength1Alert': ["network-strength-1-warning"],
    'mdiNetworkStrength2Alert': ["network-strength-2-warning"],
    'mdiNetworkStrength3Alert': ["network-strength-3-warning"],
    'mdiNetworkStrength4Alert': ["network-strength-4-warning"],
    'mdiNetworkStrength4Cog': ["network-strength-4-settings","data-settings"],
    'mdiNetworkStrengthOutline': ["network-strength-0"],
    'mdiNewBox': ["fiber-new"],
    'mdiNfcTap': ["near-field-communication-tap"],
    'mdiNfcVariant': ["near-field-communication-variant"],
    'mdiNfcVariantOff': ["near-field-communication-off"],
    'mdiNoodles': ["food-ramen","asian-noodles"],
    'mdiNote': ["paper","sticky-note","post-it-note"],
    'mdiNoteAlert': ["paper-alert","sticky-note-alert","post-it-note-alert"],
    'mdiNoteAlertOutline': ["paper-alert-outline","post-it-note-alert-outline","sticky-note-alert-outline"],
    'mdiNoteCheck': ["paper-check","sticky-note-check","post-it-note-check"],
    'mdiNoteCheckOutline': ["paper-check-outline","sticky-note-check-outline","post-it-note-check-outline"],
    'mdiNoteEdit': ["paper-edit","sticky-note-edit","post-it-note-edit"],
    'mdiNoteEditOutline': ["paper-edit-outline","sticky-note-edit-outline","post-it-note-edit-outline"],
    'mdiNoteMinus': ["paper-minus","sticky-note-minus","post-it-note-minus"],
    'mdiNoteMinusOutline': ["paper-minus-outline","sticky-note-minus-outline","post-it-note-minus-outline"],
    'mdiNoteMultiple': ["notes","papers","sticky-notes","post-it-notes"],
    'mdiNoteMultipleOutline': ["notes-outline","papers-outline","sticky-notes-outline","post-it-notes-outline"],
    'mdiNoteOff': ["paper-off","sticky-note-off","post-it-note-off"],
    'mdiNoteOffOutline': ["paper-off-outline","sticky-note-off-outline","post-it-note-off-outline"],
    'mdiNoteOutline': ["paper-outline","sticky-note-outline","post-it-note-outline"],
    'mdiNotePlus': ["note-add","paper-plus","paper-add","sticky-note-plus","sticky-note-add","post-it-note-plus","post-it-note-add"],
    'mdiNotePlusOutline': ["note-add-outline","paper-plus-outline","paper-add-outline","sticky-note-plus-outline","sticky-note-add-outline","post-it-note-plus-outline","post-it-note-add-outline"],
    'mdiNoteRemove': ["paper-remove","sticky-note-remove","post-it-note-remove"],
    'mdiNoteSearch': ["paper-search","sticky-note-search","post-it-note-search"],
    'mdiNoteSearchOutline': ["paper-search-outline","sticky-note-search-outline","post-it-note-search-outline"],
    'mdiNoteText': ["paper-text","sticky-note-text","post-it-note-text"],
    'mdiNoteTextOutline': ["paper-text-outline","sticky-note-text-outline","post-it-note-text-outline"],
    'mdiNotebook': ["journal","planner","diary"],
    'mdiNotebookHeart': ["notebook-favorite","notebook-love"],
    'mdiNotebookHeartOutline': ["notebook-favorite-outline","notebook-love-outline"],
    'mdiNotebookMultiple': ["journal-multiple","planner-multiple"],
    'mdiNotebookOutline': ["journal-outline","planner-outline"],
    'mdiNuke': ["nuclear","atomic-bomb"],
    'mdiNumeric': ["numbers","1-2-3","one-two-three","123"],
    'mdiNumeric0': ["number-0","numeric-zero"],
    'mdiNumeric0Box': ["numeric-zero-box","number-0-box"],
    'mdiNumeric0BoxMultipleOutline': ["numeric-zero-box-multiple-outline","numeric-0-boxes-outline","number-0-box-multiple-outline"],
    'mdiNumeric0BoxOutline': ["numeric-zero-box-outline","number-0-box-outline"],
    'mdiNumeric0Circle': ["numeric-zero-circle","number-0-circle","number-zero-circle"],
    'mdiNumeric0CircleOutline': ["numeric-zero-circle-outline","number-0-circle-outline","number-zero-circle-outline"],
    'mdiNumeric1': ["number-1","numeric-one"],
    'mdiNumeric1Box': ["looks-one","numeric-one-box","number-1-box"],
    'mdiNumeric1BoxMultipleOutline': ["filter-1","numeric-one-box-multiple-outline","numeric-1-boxes-outline","number-1-box-multiple-outline"],
    'mdiNumeric1BoxOutline': ["numeric-one-box-outline","number-1-box-outline"],
    'mdiNumeric1Circle': ["numeric-one-circle","number-1-circle","number-one-circle"],
    'mdiNumeric1CircleOutline': ["numeric-one-circle-outline","number-1-circle-outline","number-one-circle-outline"],
    'mdiNumeric2': ["number-2","numeric-two"],
    'mdiNumeric2Box': ["looks-two","numeric-two-box","number-2-box"],
    'mdiNumeric2BoxMultipleOutline': ["filter-2","numeric-two-box-multiple-outline","numeric-2-boxes-outline","number-2-box-multiple-outline"],
    'mdiNumeric2BoxOutline': ["numeric-two-box-outline","number-2-box-outline"],
    'mdiNumeric2Circle': ["numeric-two-circle","number-2-circle","number-two-circle"],
    'mdiNumeric2CircleOutline': ["numeric-two-circle-outline","number-2-circle-outline","number-two-circle-outline"],
    'mdiNumeric3': ["number-3","numeric-three"],
    'mdiNumeric3Box': ["looks-3","numeric-three-box","number-3-box"],
    'mdiNumeric3BoxMultipleOutline': ["filter-3","numeric-three-box-multiple-outline","numeric-3-boxes-outline","number-3-box-multiple-outline"],
    'mdiNumeric3BoxOutline': ["numeric-three-box-outline","number-3-box-outline"],
    'mdiNumeric3Circle': ["numeric-three-circle","number-3-circle","number-three-circle"],
    'mdiNumeric3CircleOutline': ["numeric-three-circle-outline","number-3-circle-outline","number-three-circle-outline"],
    'mdiNumeric4': ["number-4","numeric-four"],
    'mdiNumeric4Box': ["looks-4","numeric-four-box","number-4-box"],
    'mdiNumeric4BoxMultipleOutline': ["filter-4","numeric-four-box-multiple-outline","numeric-4-boxes-outline","number-4-box-multiple-outline"],
    'mdiNumeric4BoxOutline': ["numeric-four-box-outline","number-4-box-outline"],
    'mdiNumeric4Circle': ["numeric-four-circle","number-4-circle","number-four-circle"],
    'mdiNumeric4CircleOutline': ["numeric-four-circle-outline","number-4-circle-outline","number-four-circle-outline"],
    'mdiNumeric5': ["number-5","numeric-five"],
    'mdiNumeric5Box': ["looks-5","numeric-five-box","number-5-box"],
    'mdiNumeric5BoxMultipleOutline': ["filter-5","numeric-five-box-multiple-outline","numeric-5-boxes-outline","number-5-box-multiple-outline"],
    'mdiNumeric5BoxOutline': ["numeric-five-box-outline","number-5-box-outline"],
    'mdiNumeric5Circle': ["numeric-five-circle","number-5-circle","number-five-circle"],
    'mdiNumeric5CircleOutline': ["numeric-five-circle-outline","number-5-circle-outline","number-five-circle-outline"],
    'mdiNumeric6': ["number-6","numeric-six"],
    'mdiNumeric6Box': ["looks-6","numeric-six-box","number-6-box"],
    'mdiNumeric6BoxMultipleOutline': ["filter-6","numeric-six-box-multiple-outline","numeric-6-boxes-outline","number-6-box-multiple-outline"],
    'mdiNumeric6BoxOutline': ["numeric-six-box-outline","number-6-box-outline"],
    'mdiNumeric6Circle': ["numeric-six-circle","number-6-circle","number-six-circle"],
    'mdiNumeric6CircleOutline': ["numeric-six-circle-outline","number-6-circle-outline","number-six-circle-outline"],
    'mdiNumeric7': ["number-7","numeric-seven"],
    'mdiNumeric7Box': ["numeric-seven-box","number-7-box"],
    'mdiNumeric7BoxMultipleOutline': ["filter-7","numeric-seven-box-multiple-outline","numeric-7-boxes-outline","number-7-box-multiple-outline"],
    'mdiNumeric7BoxOutline': ["numeric-seven-box-outline","number-7-box-outline"],
    'mdiNumeric7Circle': ["numeric-seven-circle","number-7-circle","number-seven-circle"],
    'mdiNumeric7CircleOutline': ["numeric-seven-circle-outline","number-7-circle-outline","number-seven-circle-outline"],
    'mdiNumeric8': ["number-8","numeric-eight"],
    'mdiNumeric8Box': ["numeric-eight-box","number-8-box"],
    'mdiNumeric8BoxMultipleOutline': ["filter-8","numeric-eight-box-multiple-outline","numeric-8-boxes-outline","number-8-box-multiple-outline"],
    'mdiNumeric8BoxOutline': ["numeric-eight-box-outline","number-8-box-outline"],
    'mdiNumeric8Circle': ["numeric-eight-circle","number-8-circle","number-eight-circle"],
    'mdiNumeric8CircleOutline': ["numeric-eight-circle-outline","number-8-circle-outline","number-eight-circle-outline"],
    'mdiNumeric9': ["number-9","numeric-nine"],
    'mdiNumeric9Box': ["numeric-nine-box","number-9-box"],
    'mdiNumeric9BoxMultipleOutline': ["filter-9","numeric-nine-box-multiple-outline","numeric-9-boxes-outline","number-9-box-multiple-outline"],
    'mdiNumeric9BoxOutline': ["numeric-nine-box-outline","number-9-box-outline"],
    'mdiNumeric9Circle': ["numeric-nine-circle","number-9-circle","number-nine-circle"],
    'mdiNumeric9CircleOutline': ["numeric-nine-circle-outline","number-9-circle-outline","number-nine-circle-outline"],
    'mdiNumeric9PlusBox': ["numeric-nine-plus-box","number-9-plus-box"],
    'mdiNumeric9PlusBoxMultipleOutline': ["filter-9-plus","numeric-nine-plus-box-multiple-outline","numeric-9-plus-boxes-outline","number-9-plus-box-multiple-outline"],
    'mdiNumeric9PlusBoxOutline': ["numeric-nine-plus-box-outline","number-9-plus-box-outline"],
    'mdiNumeric9PlusCircle': ["numeric-nine-plus-circle","number-9-plus-circle","number-nine-plus-circle"],
    'mdiNumeric9PlusCircleOutline': ["numeric-nine-plus-circle-outline","number-9-plus-circle-outline","number-nine-plus-circle-outline"],
    'mdiNumericNegative1': ["decrement","minus-one"],
    'mdiNumericOff': ["numbers-off","123-off","one-two-three-off"],
    'mdiNumericPositive1': ["increment","plus-one"],
    'mdiOcr': ["optical-character-recognition"],
    'mdiOctagon': ["stop"],
    'mdiOctagonOutline': ["stop-outline"],
    'mdiOctagram': ["starburst"],
    'mdiOctagramEdit': ["starburst-edit"],
    'mdiOctagramEditOutline': ["starburst-edit-outline"],
    'mdiOctagramMinus': ["starburst-plus"],
    'mdiOctagramMinusOutline': ["starburst-minus-outline"],
    'mdiOctagramOutline': ["starburst-outline"],
    'mdiOctagramPlus': ["starburst-plus"],
    'mdiOfficeBuildingCog': ["office-building-settings"],
    'mdiOfficeBuildingCogOutline': ["office-building-settings-outline"],
    'mdiOfficeBuildingMarker': ["office-building-location"],
    'mdiOfficeBuildingMarkerOutline': ["office-building-location-outline"],
    'mdiOilLamp': ["wish","genie-lamp"],
    'mdiOm': ["religion-hindu","hinduism"],
    'mdiOmega': ["ohm","electrical-resistance"],
    'mdiOneUp': ["1up","extra-life"],
    'mdiOpenInApp': ["open-in-browser"],
    'mdiOpenInNew': ["external-link"],
    'mdiOrbitVariant': ["camera-flip"],
    'mdiOrderBoolAscendingVariant': ["order-checkbox-ascending"],
    'mdiOrderBoolDescending': ["order-checkbox-descending"],
    'mdiOutdoorLamp': ["outdoor-light"],
    'mdiOverscan': ["fullscreen"],
    'mdiPackage': ["box"],
    'mdiPackageCheck': ["package-delivered"],
    'mdiPackageDown': ["archive","box-down","this-side-down"],
    'mdiPackageUp': ["unarchive","box-up","this-side-up"],
    'mdiPackageVariant': ["box-variant"],
    'mdiPackageVariantClosed': ["box-variant-closed"],
    'mdiPackageVariantClosedCheck': ["package-variant-closed-delivered"],
    'mdiPackageVariantClosedMinus': ["package-variant-closed-subtract","box-variant-closed-minus","box-variant-closed-subtract"],
    'mdiPackageVariantClosedPlus': ["box-variant-closed-plus","package-variant-closed-add","box-variant-closed-add"],
    'mdiPackageVariantClosedRemove': ["box-variant-closed-remove"],
    'mdiPackageVariantMinus': ["box-variant-minus","package-variant-subtract","box-variant-subtract"],
    'mdiPackageVariantPlus': ["box-variant-plus","package-variant-add","box-variant-add"],
    'mdiPackageVariantRemove': ["box-variant-remove"],
    'mdiPageFirst': ["first-page","chevron-left-first"],
    'mdiPageLast': ["last-page","chevron-right-last"],
    'mdiPageLayoutHeaderFooter': ["page-layout-marginals"],
    'mdiPageNext': ["read-more"],
    'mdiPageNextOutline': ["read-more-outline"],
    'mdiPail': ["bucket"],
    'mdiPailMinus': ["bucket-minus"],
    'mdiPailMinusOutline': ["bucket-minus-outline"],
    'mdiPailOff': ["bucket-off"],
    'mdiPailOffOutline': ["bucket-off-outline"],
    'mdiPailOutline': ["bucket-outline"],
    'mdiPailPlus': ["bucket-plus"],
    'mdiPailPlusOutline': ["bucket-plus-outline"],
    'mdiPailRemove': ["bucket-remove"],
    'mdiPailRemoveOutline': ["bucket-remove-outline"],
    'mdiPalette': ["color-lens","colour-lens","paint","art","color"],
    'mdiPaletteAdvanced': ["paint"],
    'mdiPaletteOutline': ["paint-outline"],
    'mdiPaletteSwatch': ["style","paint","material"],
    'mdiPaletteSwatchOutline': ["style-outline","paint-outline"],
    'mdiPaletteSwatchVariant': ["style","paint","material"],
    'mdiPanBottomLeft': ["pan-down-left"],
    'mdiPanBottomRight': ["pan-down-right"],
    'mdiPanTopLeft': ["pan-up-left"],
    'mdiPanTopRight': ["pan-up-right"],
    'mdiPanda': ["emoji-panda","emoticon-panda"],
    'mdiPanoramaFisheye': ["panorama-fish-eye"],
    'mdiPanoramaSphere': ["panorama-360"],
    'mdiPanoramaSphereOutline': ["panorama-360-outline"],
    'mdiPanoramaVariant': ["panorama-vr","image-vr","picture-vr","picture-360","image-360"],
    'mdiPanoramaVariantOutline': ["panorama-vr-outline","image-vr-outline","picture-vr-outline","picture-360-outline","image-360-outline"],
    'mdiPaperRoll': ["lavatory-roll","bathroom-tissue","toilet-paper","kitchen-roll","paper-towels","receipt-roll"],
    'mdiPaperRollOutline': ["lavatory-roll-outline","bathroom-tissue-outline","kitchen-roll-outline","paper-towels-outline","toilet-paper-outline","receipt-roll-outline"],
    'mdiPaperclip': ["attachment-vertical","attach-file"],
    'mdiPaperclipCheck': ["paperclip-tick","attachment-check","attachment-tick"],
    'mdiPaperclipLock': ["attachment-lock"],
    'mdiPaperclipMinus': ["paperclip-subtract","attachment-minus","attachment-subtract"],
    'mdiPaperclipOff': ["attachment-off"],
    'mdiPaperclipPlus': ["paperclip-add","attachment-plus","attachment-add"],
    'mdiPaperclipRemove': ["attachment-remove"],
    'mdiParagliding': ["parasail","paraglide"],
    'mdiParking': ["car-park","local-parking"],
    'mdiPartyPopper': ["celebration"],
    'mdiPassportBiometric': ["passport-electronic"],
    'mdiPasta': ["food-italian","spaghetti"],
    'mdiPauseCircle': ["pause-circle-filled"],
    'mdiPauseOctagon': ["stop-pause"],
    'mdiPauseOctagonOutline': ["stop-pause-outline"],
    'mdiPaw': ["pets"],
    'mdiPeanut': ["allergen","food-allergy"],
    'mdiPeanutOff': ["allergen-off","food-allergy-off"],
    'mdiPeanutOffOutline': ["allergen-off-outline","food-allergy-off-outline"],
    'mdiPeanutOutline': ["allergen-outline","food-allergy-outline"],
    'mdiPenPlus': ["pen-add"],
    'mdiPencil': ["edit","create","mode-edit"],
    'mdiPencilBox': ["edit-box"],
    'mdiPencilBoxMultiple': ["library-edit"],
    'mdiPencilBoxMultipleOutline': ["library-edit-outline"],
    'mdiPencilBoxOutline': ["edit-box-outline"],
    'mdiPencilCircle': ["edit-circle"],
    'mdiPencilCircleOutline': ["edit-circle-outline"],
    'mdiPencilOff': ["edit-off"],
    'mdiPencilOffOutline': ["edit-off-outline"],
    'mdiPencilOutline': ["edit-outline","create-outline","mode-edit-outline"],
    'mdiPencilPlus': ["pencil-add"],
    'mdiPencilPlusOutline': ["pencil-add-outline"],
    'mdiPencilRuler': ["design"],
    'mdiPenguin': ["emoji-penguin","emoticon-penguin","linux"],
    'mdiPercent': ["discount","sale"],
    'mdiPercentBox': ["discount-box","sale-box"],
    'mdiPercentBoxOutline': ["discount-box-outline","sale-box-outline"],
    'mdiPercentCircle': ["discount-circle","sale-circle"],
    'mdiPercentCircleOutline': ["discount-circle-outline","sale-circle-outline"],
    'mdiPercentOutline': ["discount-outline","sale-outline"],
    'mdiPerspectiveLess': ["perspective-decrease"],
    'mdiPerspectiveMore': ["perspective-increase"],
    'mdiPh': ["acid","base","potential-of-hydrogen","power-of-hydrogen"],
    'mdiPhone': ["call","local-phone","telephone"],
    'mdiPhoneBluetooth': ["phone-bluetooth-speaker","telephone-bluetooth"],
    'mdiPhoneCancel': ["phone-block"],
    'mdiPhoneClock': ["phone-schedule","phone-time"],
    'mdiPhoneDial': ["phone-keypad"],
    'mdiPhoneDialOutline': ["phone-keypad-outline"],
    'mdiPhoneForward': ["phone-forwarded","telephone-forward"],
    'mdiPhoneHangup': ["call-end","telephone-hangup"],
    'mdiPhoneInTalk': ["telephone-in-talk"],
    'mdiPhoneInTalkOutline': ["telephone-in-talk-outline"],
    'mdiPhoneIncoming': ["telephone-incoming"],
    'mdiPhoneLock': ["telephone-locked","phone-locked","telephone-lock"],
    'mdiPhoneOutline': ["telephone-outline","call-outline"],
    'mdiPhonePlus': ["add-call"],
    'mdiPhoneRefresh': ["phone-redial"],
    'mdiPhoneRefreshOutline': ["phone-redial-outline"],
    'mdiPhoneSettings': ["settings-phone"],
    'mdiPhoneSync': ["phone-redial"],
    'mdiPhoneSyncOutline': ["phone-redial-outline"],
    'mdiPig': ["emoji-pig","emoticon-pig"],
    'mdiPill': ["medicine","capsule","drug","pharmaceutical"],
    'mdiPillMultiple': ["medicine","medication","drugs"],
    'mdiPillOff': ["medicine-off","capsule-off","drug-off","pharmaceutical-off"],
    'mdiPillar': ["historic","column"],
    'mdiPin': ["keep"],
    'mdiPinOff': ["keep-off"],
    'mdiPinOffOutline': ["keep-off-outline"],
    'mdiPinOutline': ["keep-outline"],
    'mdiPineTree': ["forest","plant"],
    'mdiPineTreeBox': ["plant"],
    'mdiPineTreeFire': ["wildfire","controlled-burn"],
    'mdiPinwheel': ["toys"],
    'mdiPinwheelOutline': ["toys-outline"],
    'mdiPipeWrench': ["monkey-wrench"],
    'mdiPistol': ["gun"],
    'mdiPizza': ["pizzeria","local-pizza"],
    'mdiPlaneCar': ["airport-shuttle","airport-taxi","airplane-car"],
    'mdiPlaneTrain': ["airport-shuttle","airplane-train"],
    'mdiPlay': ["play-arrow"],
    'mdiPlayBoxOutline': ["slideshow"],
    'mdiPlayCircle': ["play-circle-filled"],
    'mdiPlayNetwork': ["media-network"],
    'mdiPlayNetworkOutline': ["media-network-outline"],
    'mdiPlaylistCheck': ["subscriptions","playlist-add-check","playlist-tick"],
    'mdiPlaylistMusic': ["playlist-note","queue-music"],
    'mdiPlaylistMusicOutline': ["playlist-note-outline","queue-music-outline"],
    'mdiPlaylistPlus': ["playlist-add"],
    'mdiPlaylistStar': ["playlist-favorite"],
    'mdiPlus': ["add"],
    'mdiPlusBox': ["add-box"],
    'mdiPlusBoxMultiple': ["add-to-photos","library-add","queue","library-plus"],
    'mdiPlusCircle': ["add-circle"],
    'mdiPlusCircleMultiple': ["coins-plus"],
    'mdiPlusCircleMultipleOutline': ["control-point-duplicate","plus-circles-outline","coins-plus-outline"],
    'mdiPlusCircleOutline': ["add-circle-outline","control-point","circles-add"],
    'mdiPlusLock': ["plus-secure"],
    'mdiPlusNetwork': ["add-network"],
    'mdiPlusNetworkOutline': ["add-network-outline"],
    'mdiPlusThick': ["add-thick","add-bold","plus-bold"],
    'mdiPodiumBronze': ["podium-third"],
    'mdiPodiumGold': ["podium-first"],
    'mdiPodiumSilver': ["podium-second"],
    'mdiPokerChip': ["casino-chip","gambling-chip"],
    'mdiPoll': ["bar-chart","report","performance","analytics"],
    'mdiPool': ["swimming-pool"],
    'mdiPoolThermometer': ["pool-temperature"],
    'mdiPost': ["blog"],
    'mdiPostLamp': ["post-light"],
    'mdiPostOutline': ["blog-outline"],
    'mdiPound': ["hashtag"],
    'mdiPoundBox': ["hashtag-box"],
    'mdiPoundBoxOutline': ["hashtag-box-outline"],
    'mdiPower': ["power-settings-new","shutdown"],
    'mdiPowerPlugBattery': ["battery-backup"],
    'mdiPowerPlugBatteryOutline': ["battery-backup-outline"],
    'mdiPowerPlugOff': ["power-off"],
    'mdiPowerSettings': ["settings-power"],
    'mdiPowerSocket': ["plug-socket"],
    'mdiPowerSocketAu': ["plug-socket-au","power-socket-type-i","power-socket-cn","power-socket-ar","power-socket-nz","power-socket-pg","power-socket-australia","power-socket-china","power-socket-argentina","power-socket-new-zealand","power-socket-papua-new-guinea"],
    'mdiPowerSocketCh': ["plug-socket-ch","power-socket-type-j","plug-socket-type-j","power-socket-switzerland","plug-socket-switzerland"],
    'mdiPowerSocketEu': ["plug-socket-eu","power-socket-europe"],
    'mdiPowerSocketUk': ["plug-socket-uk","power-socket-type-g","power-socket-ie","power-socket-hk","power-socket-my","power-socket-cy","power-socket-mt","power-socket-sg","power-socket-united-kingdom","power-socket-ireland","power-socket-hong-kong","power-socket-malaysia","power-socket-cyprus","power-socket-malta","power-socket-singapore"],
    'mdiPowerSocketUs': ["plug-socket-us","power-socket-ca","power-socket-mx","power-socket-type-b","power-socket-united-states","power-socket-japan","power-socket-canada","power-socket-mexico"],
    'mdiPrinter': ["local-printshop","local-print-shop"],
    'mdiPrinterAlert': ["printer-warning","paper-jam"],
    'mdiPrinterEye': ["printer-preview","printer-view"],
    'mdiPrinterPos': ["printer-point-of-sale","printer-receipt"],
    'mdiPrinterPosAlert': ["printer-point-of-sale-alert","printer-receipt-alert"],
    'mdiPrinterPosAlertOutline': ["printer-point-of-sale-alert-outline","printer-receipt-alert-outline"],
    'mdiPrinterPosCancel': ["printer-point-of-sale-cancel","printer-receipt-cancel"],
    'mdiPrinterPosCancelOutline': ["printer-point-of-sale-cancel-outline","printer-receipt-cancel-outline"],
    'mdiPrinterPosCheck': ["printer-point-of-sale-check","printer-receipt-check"],
    'mdiPrinterPosCheckOutline': ["printer-point-of-sale-check-outline","printer-receipt-check-outline"],
    'mdiPrinterPosCog': ["printer-point-of-sale-cog","printer-receipt-cog"],
    'mdiPrinterPosCogOutline': ["printer-point-of-sale-cog-outline","printer-receipt-cog-outline"],
    'mdiPrinterPosEdit': ["printer-point-of-sale-edit","printer-receipt-edit"],
    'mdiPrinterPosEditOutline': ["printer-point-of-sale-edit-outline","printer-receipt-edit-outline"],
    'mdiPrinterPosMinus': ["printer-point-of-sale-minus","printer-receipt-minus"],
    'mdiPrinterPosMinusOutline': ["printer-point-of-sale-minus-outline","printer-receipt-minus-outline"],
    'mdiPrinterPosNetwork': ["printer-point-of-sale-network","printer-receipt-network"],
    'mdiPrinterPosNetworkOutline': ["printer-point-of-sale-network-outline","printer-receipt-network-outline"],
    'mdiPrinterPosOff': ["printer-point-of-sale-off","printer-receipt-off"],
    'mdiPrinterPosOffOutline': ["printer-point-of-sale-off-outline","printer-receipt-off-outline"],
    'mdiPrinterPosOutline': ["printer-point-of-sale-outline","printer-receipt-outline"],
    'mdiPrinterPosPause': ["printer-point-of-sale-pause","printer-receipt-pause"],
    'mdiPrinterPosPauseOutline': ["printer-point-of-sale-pause-outline","printer-receipt-pause-outline"],
    'mdiPrinterPosPlay': ["printer-point-of-sale-play","printer-receipt-play"],
    'mdiPrinterPosPlayOutline': ["printer-point-of-sale-play-outline","printer-receipt-play-outline"],
    'mdiPrinterPosPlus': ["printer-point-of-sale-plus","printer-receipt-plus"],
    'mdiPrinterPosPlusOutline': ["printer-point-of-sale-plus-outline","printer-receipt-plus-outline"],
    'mdiPrinterPosRefresh': ["printer-point-of-sale-refresh","printer-receipt-refresh"],
    'mdiPrinterPosRefreshOutline': ["printer-point-of-sale-refresh-outline","printer-receipt-refresh-outline"],
    'mdiPrinterPosRemove': ["printer-point-of-sale-remove","printer-receipt-remove"],
    'mdiPrinterPosRemoveOutline': ["printer-point-of-sale-remove-outline","printer-receipt-remove-outline"],
    'mdiPrinterPosStar': ["printer-point-of-sale-star","printer-receipt-star","printer-favorite","printer-primary"],
    'mdiPrinterPosStarOutline': ["printer-point-of-sale-star-outline","printer-receipt-star-outline"],
    'mdiPrinterPosStop': ["printer-point-of-sale-stop","printer-receipt-stop"],
    'mdiPrinterPosStopOutline': ["printer-point-of-sale-stop-outline","printer-receipt-stop-outline"],
    'mdiPrinterPosSync': ["printer-point-of-sale-sync","printer-receipt-sync"],
    'mdiPrinterPosSyncOutline': ["printer-point-of-sale-sync-outline","printer-receipt-sync-outline"],
    'mdiPrinterPosWrench': ["printer-point-of-sale-wrench","printer-receipt-wrench"],
    'mdiPrinterPosWrenchOutline': ["printer-point-of-sale-wrench-outline","printer-receipt-wrench-outline"],
    'mdiPrinterSearch': ["printer-preview","printer-magnify"],
    'mdiPriorityLow': ["low-priority"],
    'mdiProgressAlert': ["progress-warning"],
    'mdiProgressCheck': ["progress-tick"],
    'mdiProgressStarFourPoints': ["progress-auto"],
    'mdiProgressWrench': ["progress-spanner"],
    'mdiPublishOff': ["publish-disabled"],
    'mdiPulse': ["vitals"],
    'mdiPuzzle': ["extension","jigsaw"],
    'mdiPuzzleOutline': ["jigsaw-outline","extension-outline"],
    'mdiPuzzleStar': ["puzzle-favorite"],
    'mdiPuzzleStarOutline': ["puzzle-favorite-outline"],
    'mdiQuadcopter': ["drone"],
    'mdiQualityHigh': ["high-quality","hq"],
    'mdiQualityLow': ["low-quality","lq"],
    'mdiQualityMedium': ["medium-quality","mq"],
    'mdiRabbit': ["bunny","hare"],
    'mdiRabbitVariant': ["bunny","easter","hare","cruelty-free"],
    'mdiRabbitVariantOutline': ["easter-outline","bunny-outline","hare-outline","cruelty-free-outline"],
    'mdiRacquetball': ["lacrosse","squash"],
    'mdiRadar': ["track-changes"],
    'mdiRadiator': ["heater"],
    'mdiRadiatorDisabled': ["heater-disabled"],
    'mdiRadiatorOff': ["heater-off"],
    'mdiRadioactive': ["radiation"],
    'mdiRadioactiveCircle': ["radiation-circle"],
    'mdiRadioactiveCircleOutline': ["radiation-circle-outline"],
    'mdiRadioactiveOff': ["radiation-off"],
    'mdiRadioboxBlank': ["radio-button-unchecked"],
    'mdiRadioboxIndeterminateVariant': ["radio-button-indeterminate","radiobox-intermediate-variant"],
    'mdiRadioboxMarked': ["radio-button-checked","record"],
    'mdiRadiologyBox': ["x-ray-box"],
    'mdiRadiologyBoxOutline': ["x-ray-box-outline"],
    'mdiRadius': ["circle-radius","sphere-radius"],
    'mdiRadiusOutline': ["circle-radius-outline","sphere-radius-outline"],
    'mdiRailroadLight': ["railroad-crossing-light","train-crossing-light","level-crossing-signals"],
    'mdiRaspberryPi': ["raspberrypi"],
    'mdiReceipt': ["cloth","fabric","swatch"],
    'mdiReceiptClock': ["receipt-pending"],
    'mdiReceiptClockOutline': ["receipt-pending"],
    'mdiReceiptOutline': ["cloth-outline","fabric-outline","swatch-outline"],
    'mdiReceiptTextOutline': ["invoice-outline"],
    'mdiReceiptTextPlus': ["receipt-text-add"],
    'mdiReceiptTextPlusOutline': ["receipt-text-add"],
    'mdiRecord': ["fiber-manual-record"],
    'mdiRedo': ["arrow"],
    'mdiRedoVariant': ["arrow"],
    'mdiRefresh': ["loop"],
    'mdiRefreshAuto': ["auto-start","automatic-start","auto-stop","automatic-stop","automatic","refresh-automatic"],
    'mdiRegex': ["regular-expression"],
    'mdiRelativeScale': ["image-aspect-ratio"],
    'mdiReload': ["car-engine-start","loop","rotate-clockwise"],
    'mdiRemote': ["settings-remote"],
    'mdiRepeat': ["repost"],
    'mdiRepeatOnce': ["repeat-one"],
    'mdiRepeatVariant': ["twitter-retweet","repost"],
    'mdiResizeBottomRight': ["drag"],
    'mdiRestore': ["loop","rotate-counter-clockwise"],
    'mdiRewind': ["fast-rewind"],
    'mdiRhombus': ["diamond"],
    'mdiRhombusOutline': ["diamond-outline"],
    'mdiRhombusSplit': ["collection"],
    'mdiRobot': ["emoji-robot","emoticon-robot"],
    'mdiRobotAngry': ["emoji-robot-angry","emoticon-robot-angry"],
    'mdiRobotAngryOutline': ["emoji-robot-angry-outline","emoticon-robot-angry-outline"],
    'mdiRobotConfused': ["emoji-robot-confused","emoticon-robot-confused"],
    'mdiRobotConfusedOutline': ["emoji-robot-confused-outline","emoticon-robot-confused-outline"],
    'mdiRobotDead': ["emoji-robot-dead","emoticon-robot-dead"],
    'mdiRobotDeadOutline': ["emoji-robot-dead-outline","emoticon-robot-dead-outline"],
    'mdiRobotExcited': ["emoticon-robot-excited","emoji-robot-excited"],
    'mdiRobotExcitedOutline': ["emoji-robot-excited-outline","emoticon-robot-excited-outline"],
    'mdiRobotHappy': ["emoji-robot-happy","emoticon-robot-happy"],
    'mdiRobotHappyOutline': ["emoji-robot-happy-outline","emoticon-robot-happy-outline"],
    'mdiRobotIndustrial': ["autonomous","assembly"],
    'mdiRobotLove': ["emoji-robot-love","emoticon-robot-love"],
    'mdiRobotMower': ["lawn-mower"],
    'mdiRobotMowerOutline': ["lawn-mower-outline"],
    'mdiRobotOff': ["emoji-robot-off","emoticon-robot-off"],
    'mdiRobotOutline': ["emoji-robot-outline","emoticon-robot-outline"],
    'mdiRobotVacuum': ["roomba"],
    'mdiRobotVacuumAlert': ["robot-vacuum-error"],
    'mdiRobotVacuumVariant': ["neato"],
    'mdiRobotVacuumVariantAlert': ["robot-vacuum-variant-error"],
    'mdiRodent': ["mouse","rat"],
    'mdiRollerShade': ["blinds-open","window-open"],
    'mdiRollerShadeClosed': ["blinds-closed","window-closed"],
    'mdiRoomService': ["call-bell"],
    'mdiRoomServiceOutline': ["call-bell-outline"],
    'mdiRotate3DVariant': ["3d-rotation"],
    'mdiRotateLeft': ["arrow-rotate-left"],
    'mdiRotateOrbit': ["gyro","accelerometer"],
    'mdiRotateRight': ["arrow-rotate-right"],
    'mdiRouterNetworkWireless': ["wireless-router"],
    'mdiRoutes': ["sign-routes"],
    'mdiRowing': ["human-rowing"],
    'mdiRss': ["rss-feed"],
    'mdiRssBox': ["rss-feed-box"],
    'mdiRug': ["carpet"],
    'mdiRugby': ["rugby-ball"],
    'mdiRulerSquare': ["square","carpentry","architecture"],
    'mdiRulerSquareCompass': ["mason","masonic","freemasonry"],
    'mdiRun': ["directions-run","human-run"],
    'mdiRunFast': ["velocity","human-run-fast"],
    'mdiRvTruck': ["recreational-vehicle","campervan"],
    'mdiSafetyGoggles': ["safety-glasses"],
    'mdiSailBoat': ["sailing","boat"],
    'mdiSailBoatSink': ["sail-boat-crash","sail-boat-wreck"],
    'mdiSale': ["discount"],
    'mdiSaleOutline': ["discount-outline"],
    'mdiScaleBalance': ["justice","legal"],
    'mdiScent': ["aroma","fragrance","smell","odor"],
    'mdiScentOff': ["aroma-off","smell-off","fragrance-off","odor-off"],
    'mdiSchool': ["graduation-cap","university","college","academic-cap","education","learn"],
    'mdiSchoolOutline': ["academic-cap-outline","college-outline","graduation-cap-outline","university-outline","education-outline","learn-outline"],
    'mdiScreenRotationLock': ["screen-lock-rotation"],
    'mdiScript': ["scroll"],
    'mdiScriptOutline': ["scroll-outline"],
    'mdiScriptText': ["scroll-text"],
    'mdiScriptTextOutline': ["scroll-text-outline"],
    'mdiSd': ["sd-card","sd-storage"],
    'mdiSeal': ["ribbon","prize","award"],
    'mdiSealVariant': ["ribbon","prize","award"],
    'mdiSearchWeb': ["search-globe","global-search","internet-search"],
    'mdiSeat': ["event-seat","chair","chair-accent","home-theater","home-theatre"],
    'mdiSeatFlat': ["airline-seat-flat"],
    'mdiSeatFlatAngled': ["airline-seat-flat-angled"],
    'mdiSeatIndividualSuite': ["airline-seat-individual-suite"],
    'mdiSeatLegroomExtra': ["airline-seat-legroom-extra"],
    'mdiSeatLegroomNormal': ["airline-seat-legroom-normal"],
    'mdiSeatLegroomReduced': ["airline-seat-legroom-reduced"],
    'mdiSeatOutline': ["event-seat-outline","chair-outline","chair-accent-outline","home-theater","home-theatre"],
    'mdiSeatReclineExtra': ["airline-seat-recline-extra"],
    'mdiSeatReclineNormal': ["airline-seat-recline-normal"],
    'mdiSeatbelt': ["seat-belt","safety-belt"],
    'mdiSecurity': ["shield","uac","user-access-control","administrator"],
    'mdiSecurityNetwork': ["shield-network","uac-network","administrator-network"],
    'mdiSeedPlus': ["seed-add"],
    'mdiSeedPlusOutline': ["seed-add-outline"],
    'mdiSeesaw': ["playground-seesaw"],
    'mdiSelectColor': ["select-colour"],
    'mdiSelectInverse': ["selection-invert"],
    'mdiSelectMarker': ["select-location"],
    'mdiSelectMultipleMarker': ["select-multiple-location"],
    'mdiSelectionMarker': ["selection-location"],
    'mdiSelectionMultipleMarker': ["selection-multiple-location"],
    'mdiSend': ["paper-airplane","paper-plane"],
    'mdiSendLock': ["send-secure"],
    'mdiSendOutline': ["paper-airplane-outline","paper-plane-outline"],
    'mdiSendVariant': ["paper-plane-variant","paper-airplane-variant"],
    'mdiSendVariantOutline': ["paper-airplane-variant-outline","paper-plane-variant-outline"],
    'mdiSerialPort': ["vga"],
    'mdiServer': ["storage"],
    'mdiServerMinus': ["server-remove"],
    'mdiServerMinusOutline': ["server-remove-outline"],
    'mdiServerPlus': ["server-add"],
    'mdiServerPlusOutline': ["server-add-outline"],
    'mdiServerSecurity': ["server-shield"],
    'mdiSetAll': ["set-union","set-or","full-outer-join","sql-full-outer-join"],
    'mdiSetCenter': ["set-centre","set-intersection","set-and","inner-join","sql-inner-join"],
    'mdiSetCenterRight': ["set-centre-right","outer-join-right","sql-right-outer-join"],
    'mdiSetLeft': ["difference-left"],
    'mdiSetLeftCenter': ["set-left-centre","outer-join-left","sql-left-outer-join"],
    'mdiSetLeftRight': ["exclusion","set-xor"],
    'mdiSetNone': ["set-null","set-not","venn-diagram"],
    'mdiSetRight': ["difference-right"],
    'mdiShaker': ["pepper","fish-food"],
    'mdiShakerOutline': ["salt","fish-food-outline"],
    'mdiShape': ["category","theme"],
    'mdiShapeCirclePlus': ["shape-circle-add"],
    'mdiShapeOutline': ["theme-outline","category-outline"],
    'mdiShapePlus': ["shape-add","category-plus"],
    'mdiShapePlusOutline': ["shape-add-outline","category-plus-outline"],
    'mdiShapePolygonPlus': ["shape-polygon-add"],
    'mdiShapeRectanglePlus': ["shape-rectangle-add"],
    'mdiShapeSquarePlus': ["shape-square-add"],
    'mdiShare': ["forward"],
    'mdiShareOff': ["forward-off"],
    'mdiShareOffOutline': ["forward-off-outline"],
    'mdiShareOutline': ["forward-outline"],
    'mdiShark': ["jaws"],
    'mdiSharkOff': ["jaws-off"],
    'mdiSheep': ["emoji-sheep","emoticon-sheep"],
    'mdiShieldAccount': ["security-account","shield-user","shield-person","alarm-arm-home"],
    'mdiShieldAccountOutline': ["security-account-outline","shield-user-outline","shield-person-outline","alarm-arm-home-outline"],
    'mdiShieldAirplane': ["shield-aeroplane","shield-plane","plane-shield"],
    'mdiShieldAirplaneOutline': ["shield-aeroplane-outline","shield-plane-outline"],
    'mdiShieldAlert': ["shield-warning"],
    'mdiShieldAlertOutline': ["shield-warning-outline"],
    'mdiShieldBug': ["antivirus"],
    'mdiShieldBugOutline': ["antivirus-outline"],
    'mdiShieldCar': ["car-security","car-insurance"],
    'mdiShieldCheck': ["verified-user","shield-tick","verified"],
    'mdiShieldCheckOutline': ["shield-tick-outline"],
    'mdiShieldCross': ["shield-templar","shield-christianity"],
    'mdiShieldCrossOutline': ["shield-templar-outline","shield-christianity-outline"],
    'mdiShieldCrown': ["administrator"],
    'mdiShieldCrownOutline': ["administrator-outline"],
    'mdiShieldHome': ["security-home","shield-house","alarm-arm-home"],
    'mdiShieldHomeOutline': ["shield-house-outline","alarm-arm-home"],
    'mdiShieldLock': ["security-lock","alarm-arm-away"],
    'mdiShieldLockOpen': ["shield-unlocked"],
    'mdiShieldLockOpenOutline': ["shield-unlocked-outline"],
    'mdiShieldLockOutline': ["alarm-arm-away-outline","security-lock-outline"],
    'mdiShieldMoon': ["alarm-arm-night"],
    'mdiShieldMoonOutline': ["alarm-arm-night-outline"],
    'mdiShieldOff': ["security-off"],
    'mdiShieldPlus': ["shield-add"],
    'mdiShieldPlusOutline': ["shield-add-outline"],
    'mdiShieldStar': ["badge","shield-favorite"],
    'mdiShieldStarOutline': ["badge-outline","shield-favorite-outline"],
    'mdiShieldSun': ["sun-protection"],
    'mdiShieldSunOutline': ["sun-protection-outline"],
    'mdiShieldSword': ["moderator"],
    'mdiShieldSwordOutline': ["moderator-outline"],
    'mdiShimmer': ["sparkles"],
    'mdiShipWheel': ["voyager","helm"],
    'mdiShoeBallet': ["slippers-ballet"],
    'mdiShoePrint': ["footprints"],
    'mdiShoeSneaker': ["shoe-running"],
    'mdiShopping': ["local-mall","marketplace"],
    'mdiShoppingOutline': ["local-mall-outline","marketplace-outline"],
    'mdiShovel': ["gardening"],
    'mdiShower': ["bathtub","bathroom"],
    'mdiShowerHead': ["bathroom"],
    'mdiShuriken': ["ninja-star"],
    'mdiSigma': ["summation"],
    'mdiSignCaution': ["barrier"],
    'mdiSignDirection': ["milestone"],
    'mdiSignDirectionMinus': ["milestone-minus"],
    'mdiSignDirectionPlus': ["milestone-plus","sign-direction-add","milestone-add"],
    'mdiSignDirectionRemove': ["milestone-remove"],
    'mdiSignYield': ["give-way"],
    'mdiSignalCellularOutline': ["signal-cellular-0"],
    'mdiSilo': ["farm"],
    'mdiSiloOutline': ["farm-outline"],
    'mdiSilverware': ["local-dining","restaurant-menu","local-restaurant","cutlery"],
    'mdiSilverwareClean': ["silverware-shimmer","cutlery-clean"],
    'mdiSilverwareFork': ["cutlery-fork"],
    'mdiSilverwareForkKnife': ["restaurant","fortnite","cutlery-fork-knife","place-setting"],
    'mdiSilverwareSpoon': ["cutlery-spoon"],
    'mdiSilverwareVariant': ["cutlery-variant"],
    'mdiSim': ["sim-card","subscriber-identity-module","subscriber-identification-module"],
    'mdiSimAlert': ["sim-warning","sim-card-alert"],
    'mdiSimOff': ["signal-cellular-no-sim"],
    'mdiSimOutline': ["sim-card-outline","subscriber-identity-module-outline","subscriber-identification-module-outline"],
    'mdiSineWave': ["alternating-current","current-ac","wave","analog","frequency","amplitude"],
    'mdiSitemap': ["workflow","flowchart"],
    'mdiSitemapOutline': ["workflow-outline","flowchart-outline"],
    'mdiSizeL': ["size-large"],
    'mdiSizeM': ["size-medium"],
    'mdiSizeS': ["size-small"],
    'mdiSizeXl': ["size-extra-large"],
    'mdiSizeXs': ["size-extra-small"],
    'mdiSizeXxl': ["size-extra-extra-large"],
    'mdiSizeXxs': ["size-extra-extra-small"],
    'mdiSkate': ["ice-skate"],
    'mdiSkateboarding': ["human-skateboarding"],
    'mdiSkewLess': ["skew-decrease"],
    'mdiSkewMore': ["skew-increase"],
    'mdiSki': ["human-ski"],
    'mdiSkiCrossCountry': ["nordic-walking","human-ski-cross-country"],
    'mdiSkiWater': ["human-ski-water"],
    'mdiSkipBackward': ["title-backward","previous-title"],
    'mdiSkipForward': ["title-forward","next-title"],
    'mdiSkullCrossbones': ["jolly-roger"],
    'mdiSkullCrossbonesOutline': ["jolly-roger-outline"],
    'mdiSkullScan': ["x-ray","radiology"],
    'mdiSkullScanOutline': ["x-ray-outline","radiology-outline"],
    'mdiSlashForward': ["divide","division"],
    'mdiSlashForwardBox': ["divide-box","division-box"],
    'mdiSledding': ["human-sledding"],
    'mdiSlide': ["playground-slide"],
    'mdiSlotMachine': ["casino","gambling"],
    'mdiSlotMachineOutline': ["casino-outline","gambling-outline"],
    'mdiSmoke': ["smog","fire"],
    'mdiSmokeDetector': ["nest-protect","subwoofer"],
    'mdiSmoking': ["cigarette","smoking-area","smoking-rooms"],
    'mdiSmokingOff': ["no-smoking","cigarette-off","smoke-free"],
    'mdiSnail': ["gastropod"],
    'mdiSnake': ["reptile"],
    'mdiSnowboard': ["human-snowboard"],
    'mdiSnowflake': ["power-hibernate"],
    'mdiSnowflakeAlert': ["cold-alert","snow-advisory","freeze-advisory"],
    'mdiSnowflakeCheck': ["snowflake-approve"],
    'mdiSnowflakeMelt': ["defrost"],
    'mdiSnowflakeThermometer': ["frost-point","freezing-point","snowflake-temperature"],
    'mdiSoccer': ["football"],
    'mdiSoccerField': ["football-pitch"],
    'mdiSofa': ["couch","living-room","family-room"],
    'mdiSofaOutline': ["couch-outline","living-room-outline","family-room-outline"],
    'mdiSofaSingle': ["loveseat","love-seat","couch","chair-accent","living-room","family-room"],
    'mdiSofaSingleOutline': ["loveseat-outline","love-seat-outline","couch-outline","chair-accent-outline","living-room-outline","family-room-outline"],
    'mdiSolarPanel': ["solar-energy","solar-electricity"],
    'mdiSolarPanelLarge': ["solar-panel-energy","solar-panel-electricity"],
    'mdiSolarPower': ["solar-energy","solar-electricity"],
    'mdiSolarPowerVariant': ["solar-energy","solar-electricity"],
    'mdiSolarPowerVariantOutline': ["solar-energy-outline","solar-electricity-outline"],
    'mdiSortAlphabeticalVariant': ["sort-by-alpha","sort-alphabetically"],
    'mdiSortBoolAscendingVariant': ["sort-checkbox-ascending"],
    'mdiSortBoolDescendingVariant': ["sort-checkbox-descending"],
    'mdiSortCalendarAscending': ["sort-date-ascending"],
    'mdiSortCalendarDescending': ["sort-date-descending"],
    'mdiSortClockAscending': ["sort-time-ascending"],
    'mdiSortClockAscendingOutline': ["sort-time-ascending-outline"],
    'mdiSortClockDescending': ["sort-time-descending"],
    'mdiSortClockDescendingOutline': ["sort-time-descending-outline"],
    'mdiSortNumericVariant': ["sort-numerically"],
    'mdiSoundbar': ["speaker-bar"],
    'mdiSourceRepositoryMultiple': ["source-repositories"],
    'mdiSoySauce': ["soya-sauce"],
    'mdiSpa': ["flower-lotus","plant"],
    'mdiSpaOutline': ["flower-lotus-outline","plant"],
    'mdiSpeakerMessage': ["text-to-speech"],
    'mdiSpeakerMultiple': ["speakers"],
    'mdiSpear': ["staff","fishing"],
    'mdiSpider': ["arachnid","bug"],
    'mdiSpiderOutline': ["arachnid-outline"],
    'mdiSpiderThread': ["arachnid-thread","bug"],
    'mdiSpiderWeb': ["cobweb","arachnid-web"],
    'mdiSpray': ["paint","aerosol"],
    'mdiSprayBottle': ["cleaning"],
    'mdiSprinkler': ["irrigation"],
    'mdiSprinklerFire': ["sprinkler-mist","mister","sprinkler-head"],
    'mdiSprinklerVariant': ["irrigation"],
    'mdiSprout': ["seedling","plant","ecology","environment"],
    'mdiSproutOutline': ["seedling-outline","plant-outline","ecology-outline","environment-outline"],
    'mdiSquareCircle': ["vegetarian","lacto-vegetarian"],
    'mdiSquareOpacity': ["square-transparent"],
    'mdiSquareRoundedBadge': ["app-badge","push-notification"],
    'mdiSquareRoundedBadgeOutline': ["app-badge-outline","push-notification-outline"],
    'mdiSquareSmall': ["bullet"],
    'mdiStadium': ["arena"],
    'mdiStadiumOutline': ["arena-outline"],
    'mdiStadiumVariant': ["arena"],
    'mdiStar': ["grade","star-rate","favorite"],
    'mdiStarBox': ["favorite-box"],
    'mdiStarBoxMultiple': ["favorite-box-multiple"],
    'mdiStarBoxMultipleOutline': ["favorite-box-multiple-outline"],
    'mdiStarBoxOutline': ["favorite-box-outline"],
    'mdiStarCheck': ["favorite-check"],
    'mdiStarCheckOutline': ["favorite-check-outline"],
    'mdiStarCircle': ["stars","favorite-circle"],
    'mdiStarCircleOutline': ["feature-highlight","favorite-circle-outline"],
    'mdiStarCog': ["favorite-cog"],
    'mdiStarCogOutline': ["favorite-cog-outline"],
    'mdiStarCrescent': ["islam","religion-islamic","religion-muslim"],
    'mdiStarDavid': ["jewish","religion-judaic","judaism","magen-david"],
    'mdiStarFace': ["favorite-face","emoji-star","emoticon-star"],
    'mdiStarFourPointsBox': ["auto-box"],
    'mdiStarFourPointsBoxOutline': ["auto-box-outline"],
    'mdiStarFourPointsCircle': ["auto-circle"],
    'mdiStarFourPointsCircleOutline': ["auto-circle-outline"],
    'mdiStarHalf': ["favorite-half"],
    'mdiStarHalfFull': ["favorite-half-full"],
    'mdiStarMinus': ["favorite-minus"],
    'mdiStarMinusOutline': ["favorite-minus-outline"],
    'mdiStarOff': ["favorite-off"],
    'mdiStarOffOutline': ["favorite-off-outline"],
    'mdiStarOutline': ["star-border","favorite-outline"],
    'mdiStarPlus': ["favorite-plus","star-add","favorite-add"],
    'mdiStarPlusOutline': ["star-add-outline","favorite-plus-outline","favorite-add-outline"],
    'mdiStarRemove': ["favorite-remove"],
    'mdiStarRemoveOutline': ["favorite-remove-outline"],
    'mdiStarSettings': ["favorite-settings"],
    'mdiStarSettingsOutline': ["favorite-settings-outline"],
    'mdiStarShooting': ["favorite-shooting"],
    'mdiStarShootingOutline': ["favorite-shooting-outline"],
    'mdiSteering': ["search-hands-free"],
    'mdiSteeringOff': ["search-hands-free-off"],
    'mdiStepBackward2': ["frame-backward"],
    'mdiStepForward2': ["frame-forward"],
    'mdiStorageTank': ["propane-tank","gas-tank"],
    'mdiStorageTankOutline': ["propane-tank-outline","gas-tank-outline"],
    'mdiStore': ["shop","store-mall-directory"],
    'mdiStore24Hour': ["local-convenience-store","shop-24-hour"],
    'mdiStoreAlert': ["shop-alert"],
    'mdiStoreAlertOutline': ["shop-alert-outline"],
    'mdiStoreCheck': ["shop-check","shop-complete","store-complete"],
    'mdiStoreCheckOutline': ["shop-complete","store-complete-outline","shop-check-outline"],
    'mdiStoreClock': ["store-schedule","store-hours","shop-clock","shop-hours","shop-schedule","store-time","shop-time"],
    'mdiStoreClockOutline': ["shop-clock-outline","store-hours-outline","shop-hours-outline","store-time-outline","shop-time-outline","store-schedule-outline","shop-schedule-outline"],
    'mdiStoreCog': ["store-settings","shop-settings"],
    'mdiStoreCogOutline': ["store-settings-outline","shop-settings-outline","shop-cog-outline"],
    'mdiStoreEdit': ["shop-edit"],
    'mdiStoreEditOutline': ["shop-edit-outline"],
    'mdiStoreMarker': ["store-location","shop-marker","shop-location"],
    'mdiStoreMarkerOutline': ["store-location-outline","shop-marker-outline","shop-location-outline"],
    'mdiStoreMinus': ["shop-minus"],
    'mdiStoreMinusOutline': ["shop-minus-outline"],
    'mdiStoreOff': ["shop-off"],
    'mdiStoreOffOutline': ["shop-off-outline"],
    'mdiStoreOutline': ["shop-outline","store-mall-directory-outline"],
    'mdiStorePlus': ["shop-plus"],
    'mdiStorePlusOutline': ["shop-plus-outline"],
    'mdiStoreRemove': ["shop-remove","store-delete","shop-delete"],
    'mdiStoreRemoveOutline': ["shop-remove-outline","store-delete-outline","shop-delete-outline"],
    'mdiStoreSearch': ["shop-search","store-find","shop-find","store-locator","shop-locator","store-look-up","shop-look-up"],
    'mdiStoreSearchOutline': ["store-find-outline","shop-search-outline","shop-find-outline","store-locator-outline","shop-locator-outline","store-look-up-outline","shop-look-up-outline"],
    'mdiStoreSettings': ["shop-settings"],
    'mdiStoreSettingsOutline': ["shop-settings-outline"],
    'mdiStorefront': ["awning"],
    'mdiStorefrontOutline': ["awning"],
    'mdiStove': ["cooker","oven"],
    'mdiStrategy': ["football-play"],
    'mdiStringLights': ["italian-lights","christmas-lights","fairy-lights"],
    'mdiStringLightsOff': ["italian-lights-off","christmas-lights-off","fairy-lights-off"],
    'mdiSubway': ["metro","tube","underground"],
    'mdiSubwayAlertVariant': ["subway-warning-variant"],
    'mdiSubwayVariant': ["metro-variant","tube-variant","underground-variant","directions-subway","directions-transit"],
    'mdiSummit': ["peak"],
    'mdiSunAngle': ["solar-angle"],
    'mdiSunAngleOutline': ["solar-angle-outline"],
    'mdiSunClock': ["sun-schedule","sun-time","time-of-day"],
    'mdiSunClockOutline': ["sun-schedule-outline","sun-time-outline","time-of-day-outline"],
    'mdiSunCompass': ["sun-azimuth","solar-compass","solar-asimuth"],
    'mdiSunSnowflake': ["hot-cold","heat-cool"],
    'mdiSunSnowflakeVariant': ["hot-cold","heat-cool"],
    'mdiSunThermometer': ["heat-index","sun-temperature","day-temperature","external-temperature","outdoor-temperature"],
    'mdiSunThermometerOutline': ["external-temperature","outside-temperature","heat-index","day-temperature"],
    'mdiSunWireless': ["weather-sun-wireless","illuminance","uv-ray","ultraviolet"],
    'mdiSunWirelessOutline': ["weather-sun-wireless-outline","illuminance-outline","uv-ray-outline","ultraviolet-outline"],
    'mdiSurroundSound20': ["stereo"],
    'mdiSwapHorizontal': ["arrow-left-right","transfer","exchange","switch"],
    'mdiSwapHorizontalBold': ["arrow-left-right-bold"],
    'mdiSwapVertical': ["import-export","arrow-up-down"],
    'mdiSwapVerticalBold': ["arrow-up-down-bold","import-export-bold"],
    'mdiSwapVerticalVariant': ["swap-calls"],
    'mdiSyllabaryHangul': ["writing-system-hangul"],
    'mdiSyllabaryHiragana': ["writing-system-hiragana"],
    'mdiSyllabaryKatakana': ["writing-system-katakana"],
    'mdiSyllabaryKatakanaHalfwidth': ["writing-system-katakana-half-width"],
    'mdiSynagogue': ["shul","temple","jewish"],
    'mdiSynagogueOutline': ["temple-outline","shul-outline","jewish-outline"],
    'mdiSync': ["loop","counterclockwise-arrows","circular-arrows","circle-arrows"],
    'mdiSyncAlert': ["sync-warning","sync-problem"],
    'mdiSyncOff': ["sync-disabled"],
    'mdiTabPlus': ["tab-add"],
    'mdiTabSearch': ["tab-find"],
    'mdiTableAccount': ["table-user"],
    'mdiTableArrowDown': ["table-download"],
    'mdiTableArrowLeft': ["table-import"],
    'mdiTableArrowRight': ["table-share","table-export"],
    'mdiTableArrowUp': ["table-upload"],
    'mdiTableChair': ["restaurant","kitchen","dining","dining-room"],
    'mdiTableCog': ["table-settings"],
    'mdiTableColumnPlusAfter': ["table-column-add-after"],
    'mdiTableColumnPlusBefore': ["table-column-add-before"],
    'mdiTableFurniture': ["kitchen","dining-room"],
    'mdiTableHeart': ["table-favorite"],
    'mdiTableLargePlus': ["table-large-add"],
    'mdiTableOfContents': ["toc"],
    'mdiTablePlus': ["table-add"],
    'mdiTableQuestion': ["table-help"],
    'mdiTableRowPlusAfter': ["table-row-add-after"],
    'mdiTableRowPlusBefore': ["table-row-add-before"],
    'mdiTableStar': ["table-favorite"],
    'mdiTableTennis': ["ping-pong","whiff-whaff"],
    'mdiTabletCellphone': ["mobile-devices","tablet-mobile-phone","tablet-smartphone"],
    'mdiTag': ["local-offer"],
    'mdiTagCheck': ["tag-approve"],
    'mdiTagCheckOutline': ["tag-approve-outline"],
    'mdiTagFaces': ["tag-emoji","tag-emoticon"],
    'mdiTagHeart': ["loyalty"],
    'mdiTagMultiple': ["tags"],
    'mdiTagPlus': ["tag-add"],
    'mdiTagSearch': ["tag-find"],
    'mdiTagSearchOutline': ["tag-find-outline"],
    'mdiTallyMark1': ["counting-1","one"],
    'mdiTallyMark2': ["counting-2","two"],
    'mdiTallyMark3': ["counting-3","three"],
    'mdiTallyMark4': ["counting-4","four"],
    'mdiTallyMark5': ["counting-5","five"],
    'mdiTangram': ["puzzle"],
    'mdiTankerTruck': ["fuel-truck","oil-truck","water-truck","tanker"],
    'mdiTapeMeasure': ["measuring-tape"],
    'mdiTarget': ["registration-mark"],
    'mdiTargetAccount': ["crosshairs-account","target-user"],
    'mdiTargetVariant': ["registration-mark"],
    'mdiTaxi': ["local-taxi","cab"],
    'mdiTeddyBear': ["child-toy","children-toy","kids-room","childrens-room","play-room"],
    'mdiTelevision': ["tv"],
    'mdiTelevisionBox': ["tv-box","tv-guide"],
    'mdiTelevisionClassic': ["tv-classic"],
    'mdiTelevisionClassicOff': ["tv-classic-off"],
    'mdiTelevisionOff': ["tv-off"],
    'mdiTelevisionShimmer': ["television-clean"],
    'mdiTemperatureCelsius': ["temperature-centigrade"],
    'mdiTennis': ["tennis-racquet","tennis-racket"],
    'mdiTent': ["camping","holiday"],
    'mdiText': ["notes"],
    'mdiTextAccount': ["biography","text-user"],
    'mdiTextBox': ["drive-document","file-document-box"],
    'mdiTextBoxCheck': ["file-document-box-tick","file-document-box-check"],
    'mdiTextBoxCheckOutline': ["file-document-box-tick-outline","file-document-box-check-outline"],
    'mdiTextBoxMinus': ["file-document-box-minus"],
    'mdiTextBoxMinusOutline': ["file-document-box-minus-outline"],
    'mdiTextBoxMultiple': ["file-document-boxes","file-document-box-multiple"],
    'mdiTextBoxMultipleOutline': ["file-document-boxes-outline","file-document-box-multiple-outline"],
    'mdiTextBoxOutline': ["file-document-box-outline"],
    'mdiTextBoxPlus': ["file-document-box-plus"],
    'mdiTextBoxPlusOutline': ["file-document-box-plus-outline"],
    'mdiTextBoxRemove': ["file-document-box-remove"],
    'mdiTextBoxRemoveOutline': ["file-document-box-remove-outline"],
    'mdiTextBoxSearch': ["file-document-box-search"],
    'mdiTextBoxSearchOutline': ["file-document-box-search-outline"],
    'mdiTextLong': ["text-subject"],
    'mdiTextSearch': ["notes-search"],
    'mdiTextSearchVariant': ["notes-search-variant"],
    'mdiTextureBox': ["surface-area"],
    'mdiTheater': ["cinema","theatre"],
    'mdiThemeLightDark': ["sun-moon-stars"],
    'mdiThermometer': ["temperature"],
    'mdiThermometerAlert': ["thermometer-warning","temperature-alert","temperature-warning"],
    'mdiThermometerAuto': ["temperature-auto"],
    'mdiThermometerBluetooth': ["temperature-bluetooth"],
    'mdiThermometerCheck': ["thermometer-approve","temperature-check","temperature-approve"],
    'mdiThermometerChevronDown': ["temperature-chevron-down","temperature-decrease","thermometer-decrease"],
    'mdiThermometerChevronUp': ["temperature-chevron-up","temperature-increase","thermometer-increase"],
    'mdiThermometerHigh': ["temperature-high"],
    'mdiThermometerLines': ["temperature-lines"],
    'mdiThermometerLow': ["temperature-low"],
    'mdiThermometerMinus': ["temperature-minus","thermometer-decrease","temperature-decrease"],
    'mdiThermometerOff': ["temperature-off"],
    'mdiThermometerPlus': ["thermometer-add","thermometer-increase","temperature-plus","temperature-add","temperature-increase"],
    'mdiThermometerWater': ["dew-point","water-temperature","boiling-point"],
    'mdiThermostat': ["nest"],
    'mdiThoughtBubble': ["comic-bubble","thinking"],
    'mdiThoughtBubbleOutline': ["comic-thought-bubble-outline","thinking-outline","think-outline"],
    'mdiThumbDown': ["dislike","thumbs-down"],
    'mdiThumbDownOutline': ["dislike-outline","thumbs-down-outline"],
    'mdiThumbUp': ["like","thumbs-up"],
    'mdiThumbUpOutline': ["like-outline","thumbs-up-outline"],
    'mdiThumbsUpDown': ["like-dislike"],
    'mdiThumbsUpDownOutline': ["like-dislike-outline"],
    'mdiTicket': ["local-activity","local-play","local-attraction"],
    'mdiTicketAccount': ["ticket-user"],
    'mdiTicketConfirmation': ["confirmation-number"],
    'mdiTicketConfirmationOutline': ["confirmation-number-outline"],
    'mdiTicketPercent': ["coupon","voucher"],
    'mdiTicketPercentOutline': ["coupon-outline","voucher-outline"],
    'mdiTimelineQuestion': ["timeline-help"],
    'mdiTimelineQuestionOutline': ["timeline-help-outline"],
    'mdiTimer': ["stopwatch"],
    'mdiTimer10': ["timer-ten"],
    'mdiTimer3': ["timer-three"],
    'mdiTimerAlert': ["stopwatch-alert"],
    'mdiTimerAlertOutline': ["stopwatch-alert-outline"],
    'mdiTimerCancel': ["stopwatch-cancel"],
    'mdiTimerCancelOutline': ["stopwatch-cancel-outline"],
    'mdiTimerCheck': ["stopwatch-check","timer-tick","stopwatch-tick"],
    'mdiTimerCheckOutline': ["timer-tick-outline","stopwatch-check-outline","stopwatch-tick-outline"],
    'mdiTimerCog': ["timer-settings"],
    'mdiTimerCogOutline': ["timer-settings-outline"],
    'mdiTimerEdit': ["stopwatch-edit"],
    'mdiTimerEditOutline': ["stopwatch-edit-outline"],
    'mdiTimerLock': ["stopwatch-lock","timer-secure","stopwatch-secure"],
    'mdiTimerLockOpen': ["stopwatch-lock-open"],
    'mdiTimerLockOpenOutline': ["stopwatch-lock-open-outline"],
    'mdiTimerLockOutline': ["stopwatch-lock-outline","stopwatch-secure-outline","timer-secure-outline"],
    'mdiTimerMarker': ["stopwatch-marker","timer-location","stopwatch-location"],
    'mdiTimerMarkerOutline': ["stopwatch-marker-outline","timer-location-outline","stopwatch-location-outline"],
    'mdiTimerMinus': ["timer-subtract","stopwatch-minus","stopwatch-subtract"],
    'mdiTimerMinusOutline': ["timer-subtract-outline","stopwatch-minus-outline","stopwatch-subtract-outline"],
    'mdiTimerMusic': ["stopwatch-music"],
    'mdiTimerMusicOutline': ["stopwatch-music-outline"],
    'mdiTimerOff': ["stopwatch-off"],
    'mdiTimerOffOutline': ["stopwatch-off-outline"],
    'mdiTimerOutline': ["stopwatch-outline"],
    'mdiTimerPause': ["stopwatch-pause"],
    'mdiTimerPauseOutline': ["stopwatch-pause-outline"],
    'mdiTimerPlay': ["timer-start","stopwatch-play","stopwatch-start"],
    'mdiTimerPlayOutline': ["timer-start-outline","stopwatch-play-outline","stopwatch-start-outline"],
    'mdiTimerPlus': ["timer-add","stopwatch-plus","stopwatch-add"],
    'mdiTimerPlusOutline': ["timer-add-outline","stopwatch-plus-outline","stopwatch-add-outline"],
    'mdiTimerRefresh': ["stopwatch-refresh"],
    'mdiTimerRefreshOutline': ["stopwatch-refresh-outline"],
    'mdiTimerRemove': ["stopwatch-remove"],
    'mdiTimerRemoveOutline': ["stopwatch-remove-outline"],
    'mdiTimerSand': ["hourglass"],
    'mdiTimerSandComplete': ["hourglass-complete"],
    'mdiTimerSandEmpty': ["hourglass-empty"],
    'mdiTimerSandFull': ["hourglass-full"],
    'mdiTimerSandPaused': ["hourglass-paused"],
    'mdiTimerStar': ["timer-favorite","stopwatch-star","stopwatch-favorite"],
    'mdiTimerStarOutline': ["timer-favorite-outline","stopwatch-star-outline","stopwatch-favorite-outline"],
    'mdiTimerStop': ["stopwatch-stop"],
    'mdiTimerStopOutline': ["stopwatch-stop-outline"],
    'mdiTimerSync': ["stopwatch-sync"],
    'mdiTimerSyncOutline': ["stopwatch-sync-outline"],
    'mdiTire': ["tyre","wheel"],
    'mdiToggleSwitchVariant': ["light-switch-on"],
    'mdiToggleSwitchVariantOff': ["light-switch-off","rocker-switch-off"],
    'mdiToilet': ["bathroom","lavatory","bidet"],
    'mdiToolboxOutline': ["service-toolbox"],
    'mdiTools': ["wrench","screwdriver"],
    'mdiTooltipAccount': ["tooltip-user","tooltip-person","account-location"],
    'mdiTooltipCellphone': ["cellphone-location","cellphone-gps","find-my-phone"],
    'mdiTooltipPlus': ["tooltip-add"],
    'mdiTooltipPlusOutline': ["tooltip-outline-plus","tooltip-add-outline"],
    'mdiTooltipQuestion': ["tooltip-help"],
    'mdiTooltipQuestionOutline': ["tooltip-help-outline"],
    'mdiTooth': ["dentist"],
    'mdiToothbrush': ["dentist","oral-hygiene"],
    'mdiToothbrushElectric': ["dentist","oral-hygiene"],
    'mdiToothbrushPaste': ["dentist","oral-hygiene"],
    'mdiTorch': ["olympics"],
    'mdiTortoise': ["turtle","reptile"],
    'mdiToslink': ["optical-audio"],
    'mdiTournament': ["bracket"],
    'mdiTowTruck': ["auto-towing","truck"],
    'mdiTownHall': ["school"],
    'mdiToyBrick': ["lego","plugin","extension"],
    'mdiToyBrickMarker': ["lego","plugin","extension","lego-location","toy-brick-location"],
    'mdiToyBrickMarkerOutline': ["extension-outline","lego-location-outline","toy-brick-location-outline","plugin-outline","lego-outline"],
    'mdiToyBrickMinus': ["lego","plugin","extension"],
    'mdiToyBrickMinusOutline': ["lego","plugin","extension"],
    'mdiToyBrickOutline': ["lego","plugin","extension"],
    'mdiToyBrickPlus': ["lego","plugin","extension"],
    'mdiToyBrickPlusOutline': ["lego","plugin","extension"],
    'mdiToyBrickRemove': ["lego","plugin","extension"],
    'mdiToyBrickRemoveOutline': ["lego","plugin","extension"],
    'mdiToyBrickSearch': ["lego","plugin","extension"],
    'mdiToyBrickSearchOutline': ["lego","plugin","extension"],
    'mdiTractor': ["farm"],
    'mdiTractorVariant': ["agriculture"],
    'mdiTrademark': ["tm"],
    'mdiTrafficLight': ["traffic-signal","stop-light"],
    'mdiTrafficLightOutline': ["traffic-signal-outline","stop-light-outline"],
    'mdiTrain': ["directions-railway","locomotive","railroad"],
    'mdiTrainCar': ["commute","transportation","travel"],
    'mdiTrainVariant': ["locomotive-variant","railroad-variant"],
    'mdiTransitTransfer': ["transfer-within-a-station"],
    'mdiTransition': ["animation","motion","translate"],
    'mdiTransitionMasked': ["masked-transitions"],
    'mdiTranslate': ["language"],
    'mdiTranslateVariant': ["spoken-language"],
    'mdiTransmissionTower': ["pylon","powerline","electricity","energy","power","grid"],
    'mdiTransmissionTowerExport': ["power-from-grid","energy-from-grid","electricity-from-grid"],
    'mdiTransmissionTowerImport': ["power-to-grid","energy-to-grid","electricity-to-grid","return-to-grid"],
    'mdiTransmissionTowerOff': ["powerline-off","pylon-off","grid-off"],
    'mdiTrashCan': ["delete","rubbish-bin","trashcan","garbage-can"],
    'mdiTrashCanOutline': ["delete-outline","rubbish-bin-outline","trashcan-outline","garbage-can-outline"],
    'mdiTray': ["queue","printer","inbox"],
    'mdiTrayAlert': ["queue","printer","inbox"],
    'mdiTrayArrowDown': ["tray-download"],
    'mdiTrayArrowUp': ["tray-upload"],
    'mdiTrayFull': ["queue","printer","inbox"],
    'mdiTrayMinus': ["queue","printer","inbox"],
    'mdiTrayPlus': ["queue","printer","inbox"],
    'mdiTrayRemove': ["queue","printer","inbox"],
    'mdiTreasureChest': ["jewelry-box","jewel-case"],
    'mdiTreasureChestOutline': ["jewel-case-outline","jewelry-box-outline"],
    'mdiTree': ["plant"],
    'mdiTreeOutline': ["plant"],
    'mdiTrendingNeutral': ["trending-flat"],
    'mdiTriangleSmallDown': ["trending-down-variant"],
    'mdiTriangleSmallUp': ["trending-up-variant"],
    'mdiTriforce': ["zelda"],
    'mdiTrophy': ["achievement"],
    'mdiTrophyAward': ["achievement-award"],
    'mdiTrophyOutline': ["achievement-outline"],
    'mdiTrophyVariant': ["achievement-variant"],
    'mdiTrophyVariantOutline': ["achievement-variant-outline"],
    'mdiTruck': ["lorry","local-shipping","courier"],
    'mdiTruckAlert': ["truck-error"],
    'mdiTruckAlertOutline': ["truck-error-outline"],
    'mdiTruckCargoContainer': ["truck-shipping"],
    'mdiTruckCheck': ["truck-tick","lorry-check","courier-check"],
    'mdiTruckDelivery': ["lorry-delivery"],
    'mdiTruckFast': ["lorry-fast","courier-fast"],
    'mdiTruckFlatbed': ["truck-flatbed-tow"],
    'mdiTruckMinus': ["truck-subtract"],
    'mdiTruckMinusOutline': ["truck-subtract-outline"],
    'mdiTruckPlus': ["truck-add"],
    'mdiTruckPlusOutline': ["truck-add-outline"],
    'mdiTruckSnowflake': ["truck-refrigerator","truck-freezer"],
    'mdiTshirtCrew': ["t-shirt-crew"],
    'mdiTshirtCrewOutline': ["t-shirt-crew-outline"],
    'mdiTshirtV': ["t-shirt-v"],
    'mdiTshirtVOutline': ["t-shirt-v-outline"],
    'mdiTumbleDryer': ["laundry-room"],
    'mdiTumbleDryerAlert': ["laundry-room-alert"],
    'mdiTumbleDryerOff': ["laundry-room-off"],
    'mdiTune': ["mixer-settings","equaliser","settings"],
    'mdiTuneVariant': ["settings","equalizer","slider"],
    'mdiTuneVertical': ["equaliser-vertical","instant-mix","settings-vertical","mixer-settings-vertical"],
    'mdiTuneVerticalVariant': ["settings-vertical","equalizer-vertical","slider-vertical"],
    'mdiTurbine': ["jet-engine","wind-turbine"],
    'mdiTurkey': ["thanksgiving"],
    'mdiTurtle': ["reptile"],
    'mdiUfo': ["unidentified-flying-object","alien"],
    'mdiUfoOutline': ["unidentified-flying-object-outline","alien"],
    'mdiUltraHighDefinition': ["uhd"],
    'mdiUnderwearOutline': ["briefs-outline"],
    'mdiUndo': ["arrow"],
    'mdiUndoVariant': ["arrow"],
    'mdiUnfoldLessHorizontal': ["chevron-down-up","collapse-horizontal"],
    'mdiUnfoldLessVertical': ["chevron-right-left","collapse-vertical"],
    'mdiUnfoldMoreHorizontal': ["chevron-up-down","expand-horizontal"],
    'mdiUnfoldMoreVertical': ["chevron-left-right","expand-vertical"],
    'mdiUnicorn': ["fantasy"],
    'mdiUnicornVariant': ["fantasy-variant"],
    'mdiUpdate': ["clockwise","clock-arrow"],
    'mdiUpload': ["file-upload"],
    'mdiUploadMultiple': ["uploads"],
    'mdiUploadOutline': ["file-upload-outline"],
    'mdiVacuum': ["vacuum-cleaner"],
    'mdiVacuumOutline': ["vacuum-cleaner-outline"],
    'mdiVanUtility': ["van-candy"],
    'mdiVectorCurve': ["bezier"],
    'mdiVectorPointPlus': ["vector-point-add"],
    'mdiVectorSquare': ["mdi"],
    'mdiVectorSquareMinus': ["vector-square-subtract"],
    'mdiVectorSquarePlus': ["vector-square-add"],
    'mdiVectorSquareRemove': ["vector-square-delete"],
    'mdiVhs': ["video-home-system","vhs-cassette","vhs-tape"],
    'mdiVibrate': ["vibration"],
    'mdiVideo': ["videocam"],
    'mdiVideo4KBox': ["4k"],
    'mdiVideoAccount': ["video-user"],
    'mdiVideoInputAntenna': ["settings-input-antenna"],
    'mdiVideoInputComponent': ["video-input-composite","settings-input-component","settings-input-composite","video-input-ypbpr","rca"],
    'mdiVideoInputHdmi': ["settings-input-hdmi"],
    'mdiVideoInputSvideo': ["settings-input-svideo"],
    'mdiVideoMarker': ["video-location"],
    'mdiVideoMarkerOutline': ["video-location-outline"],
    'mdiVideoMinus': ["video-remove"],
    'mdiVideoOff': ["videocam-off"],
    'mdiVideoOffOutline': ["videocam-off-outline"],
    'mdiVideoOutline': ["videocam-outline"],
    'mdiVideoPlus': ["video-call","video-add"],
    'mdiVideoStabilization': ["video-stabilisation"],
    'mdiVideoStandardDefinition': ["video-sd","video-quality-sd"],
    'mdiVideoSwitch': ["switch-video"],
    'mdiVideoVintage': ["video-film","video-classic"],
    'mdiViewGridPlus': ["view-grid-add"],
    'mdiVirtualReality': ["vr"],
    'mdiVolcano': ["eruption"],
    'mdiVolcanoOutline': ["eruption-outline"],
    'mdiVolumeHigh': ["audio","speaker","speakerphone"],
    'mdiVolumeLow': ["audio","speaker"],
    'mdiVolumeMedium': ["audio","speaker"],
    'mdiVolumeMinus': ["volume-decrease"],
    'mdiVolumeOff': ["mute","audio-off","speaker-off","speakerphone-off"],
    'mdiVolumePlus': ["volume-increase"],
    'mdiVote': ["how-to-vote"],
    'mdiVoteOutline': ["how-to-vote-outline"],
    'mdiVpn': ["virtual-private-network"],
    'mdiWalk': ["directions-walk","walker","walking","human-walk"],
    'mdiWall': ["bricks"],
    'mdiWallFire': ["firewall"],
    'mdiWallSconceFlat': ["ceiling-light-flat","pot-light-flat"],
    'mdiWallSconceFlatVariant': ["pot-light-flat-variant"],
    'mdiWallSconceRound': ["pot-light-round"],
    'mdiWallSconceRoundVariant': ["pot-light-round-variant"],
    'mdiWallet': ["account-balance-wallet"],
    'mdiWalletGiftcard': ["card-giftcard","redeem"],
    'mdiWalletMembership': ["card-membership"],
    'mdiWalletOutline': ["account-balance-wallet-outline"],
    'mdiWalletPlus': ["wallet-add"],
    'mdiWalletPlusOutline': ["wallet-add-outline"],
    'mdiWalletTravel': ["card-travel"],
    'mdiWan': ["wide-area-network"],
    'mdiWardrobe': ["closet"],
    'mdiWardrobeOutline': ["closet-outline"],
    'mdiWashingMachine': ["laundrette","local-laundry-service","laundry-room","washer"],
    'mdiWashingMachineAlert': ["laundry-room-alert","washer-alert"],
    'mdiWashingMachineOff': ["laundry-room-off","washer-off"],
    'mdiWater': ["drop","blood","water-drop","trans-fat","ink"],
    'mdiWaterAlert': ["drop-alert","blood-alert","ink-alert"],
    'mdiWaterAlertOutline': ["drop-alert-outline","blood-alert-outline","ink-alert-outline"],
    'mdiWaterBoiler': ["water-heater","gas-water-boiler","electric-water-boiler","gas-water-heater","electric-water-heater"],
    'mdiWaterBoilerAlert': ["water-heater-alert","water-boiler-error","water-heater-error"],
    'mdiWaterBoilerAuto': ["water-heater-auto"],
    'mdiWaterBoilerOff': ["water-heater-off"],
    'mdiWaterCheck': ["drop-check","blood-check","ink-check"],
    'mdiWaterCheckOutline': ["drop-check-outline","blood-check-outline","ink-check-outline"],
    'mdiWaterCircle': ["drop-circle","blood-circle","ink-circle"],
    'mdiWaterMinus': ["drop-minus","blood-minus","ink-minus"],
    'mdiWaterMinusOutline': ["drop-minus-outline","blood-minus-outline","ink-minus-outline"],
    'mdiWaterOff': ["format-color-reset","trans-fat-off","blood-off","ink-off"],
    'mdiWaterOffOutline': ["drop-off-outline","blood-off-outline","trans-fat-off-outline","ink-off-outline"],
    'mdiWaterOpacity': ["water-transparent","water-saver","blood-saver","blood-transparent","oil-saver","oil-transparent","drop-transparent","drop-saver"],
    'mdiWaterOutline': ["drop-outline","blood-outline","water-drop-outline","ink-outline"],
    'mdiWaterPercent': ["humidity","ink-percent"],
    'mdiWaterPercentAlert': ["humidity-alert","ink-percent-alert"],
    'mdiWaterPlus': ["drop-plus","blood-plus","ink-plus"],
    'mdiWaterPlusOutline': ["drop-plus-outline","blood-plus-outline","ink-plus-outline"],
    'mdiWaterPump': ["tap","kitchen-tap","faucet"],
    'mdiWaterPumpOff': ["tap-off","kitchen-tap-off","faucet-off"],
    'mdiWaterRemove': ["drop-remove","blood-remove","ink-remove"],
    'mdiWaterRemoveOutline': ["drop-remove-outline","blood-remove-outline","ink-remove-outline"],
    'mdiWaterSync': ["water-recycle","water-reuse"],
    'mdiWaterThermometer': ["boil-point","water-temperature","dew-point"],
    'mdiWaterThermometerOutline': ["dew-point-outline","water-temperature-outline","boil-point-outline"],
    'mdiWateringCan': ["watering-pot"],
    'mdiWateringCanOutline': ["watering-pot-outline"],
    'mdiWatermark': ["branding-watermark"],
    'mdiWave': ["water"],
    'mdiWaves': ["ocean","lake","flood","water"],
    'mdiWavesArrowLeft': ["tide-in","water-flow"],
    'mdiWavesArrowRight': ["tide-out","water-flow"],
    'mdiWavesArrowUp': ["water-evaporation","humidity","sea-level-rise","ocean-level-rise","climate-change"],
    'mdiWeatherCloudyClock': ["weather-history","weather-time","weather-date"],
    'mdiWeatherDust': ["dust-storm","windy"],
    'mdiWeatherFog': ["weather-mist"],
    'mdiWeatherHurricane': ["cyclone"],
    'mdiWeatherHurricaneOutline': ["cyclone-outline"],
    'mdiWeatherLightning': ["weather-storm","weather-thunder","weather-flash"],
    'mdiWeatherLightningRainy': ["weather-thunder-rainy","weather-storm"],
    'mdiWeatherMoonsetUp': ["moonrise"],
    'mdiWeatherNight': ["moon-and-stars","night-sky","weather-night-outline"],
    'mdiWeatherPartlyCloudy': ["weather-partlycloudy"],
    'mdiWeatherPouring': ["weather-heavy-rain"],
    'mdiWeatherRainy': ["weather-drizzle","weather-spitting"],
    'mdiWeatherSnowyHeavy': ["flurries"],
    'mdiWeatherSnowyRainy': ["weather-sleet"],
    'mdiWeatherSunnyAlert': ["heat-alert","heat-advisory","sun-advisory"],
    'mdiWeatherSunsetUp': ["sunrise"],
    'mdiWeb': ["language","globe","internet","world-wide-web"],
    'mdiWebBox': ["language-box","globe-box","internet-box"],
    'mdiWebcam': ["web-camera"],
    'mdiWeightKilogram': ["weight-kg"],
    'mdiWeightLifter': ["crossfit","gym","fitness-center","human-barbell"],
    'mdiWeightPound': ["weight-lb"],
    'mdiWheelchair': ["accessible","isa","international-symbol-of-access"],
    'mdiWheelchairAccessibility': ["accessible"],
    'mdiWhiteBalanceAuto': ["wb-auto"],
    'mdiWhiteBalanceIncandescent': ["wb-incandescent"],
    'mdiWhiteBalanceIridescent': ["wb-iridescent"],
    'mdiWhiteBalanceSunny': ["wb-sunny"],
    'mdiWifiMarker': ["wifi-location"],
    'mdiWifiStar': ["wifi-favourite","network-favourite","wifi-favorite","network-favorite"],
    'mdiWifiStrength1Alert': ["wifi-strength-1-warning"],
    'mdiWifiStrength2Alert': ["wifi-strength-2-warning"],
    'mdiWifiStrength3Alert': ["wifi-strength-3-warning"],
    'mdiWifiStrength4Alert': ["wifi-strength-4-warning"],
    'mdiWifiStrengthAlertOutline': ["wifi-strength-warning-outline","wifi-strength-0-alert","wifi-strength-0-warning"],
    'mdiWifiStrengthLockOutline': ["wifi-strength-0-lock"],
    'mdiWifiStrengthOutline': ["wifi-strength-0"],
    'mdiWindPower': ["wind-energy","wind-electricity"],
    'mdiWindPowerOutline': ["wind-energy-outline","wind-electricity-outline"],
    'mdiWindTurbine': ["wind-power","wind-electricity"],
    'mdiWindTurbineAlert': ["wind-power-alert","wind-turbine-warning"],
    'mdiWindTurbineCheck': ["wind-power-check","wind-turbine-success","wind-power-success"],
    'mdiWindowClose': ["cancel","close"],
    'mdiWindowShutterCog': ["window-shutter-settings"],
    'mdiWiperWash': ["wiper-fluid","washer-fluid"],
    'mdiWiperWashAlert': ["wiper-fluid-alert","washer-fluid-alert","wiper-fluid-low","washer-fluid-low"],
    'mdiWrapDisabled': ["unwrap"],
    'mdiWrench': ["build","spanner"],
    'mdiWrenchClock': ["scheduled-maintenance","wrench-time","tool-time","tool-clock"],
    'mdiWrenchCog': ["wrench-settings"],
    'mdiWrenchCogOutline': ["wrench-settings-outline"],
    'mdiWrenchOutline': ["build-outline","spanner-outline"],
    'mdiXml': ["code"],
    'mdiYinYang': ["taoism"],
    'mdiZipBox': ["compressed-file"],
    'mdiZipBoxOutline': ["compressed-file-outline"],
    'mdiZodiacAquarius': ["horoscope-aquarius"],
    'mdiZodiacAries': ["horoscope-aries"],
    'mdiZodiacCancer': ["horoscope-cancer"],
    'mdiZodiacCapricorn': ["horoscope-capricorn"],
    'mdiZodiacGemini': ["horoscope-gemini"],
    'mdiZodiacLeo': ["horoscope-leo"],
    'mdiZodiacLibra': ["horoscope-libra"],
    'mdiZodiacPisces': ["horoscope-pisces"],
    'mdiZodiacSagittarius': ["horoscope-sagittarius"],
    'mdiZodiacScorpio': ["horoscope-scorpio"],
    'mdiZodiacTaurus': ["horoscope-taurus"],
    'mdiZodiacVirgo': ["horoscope-virgo"],

}
