// imported and cleaned up from
// https://slay-the-spire.fandom.com/wiki/Module:Cards/data

export type STSCard = {
    Name: string
    Image: string
    Color: 'Colorless' | 'Green' | 'Red' | 'Blue' | 'Curse' | 'Purple'
    Rarity: 'Special' | 'Uncommon' | 'Rare' | 'Basic' | 'Common' | 'Curse'
    Type: 'Skill' | 'Attack' | 'Power' | 'Curse' | 'Status'
    Cost: number | string
    CostPlus?: number
    Text: string
    Traits: string[]
    //
    ID?: string /** to dedupe cards with similar names */
    NoUpgrade?: boolean
    Link?: string
}

// prettier-ignore
export const allCards: STSCard[] = [
    { Name: 'Apparition', Image: 'Apparition.png', Color: 'Colorless', Rarity: 'Special', Type: 'Skill', Cost: 1, Text: '[#Ethereal.|\nGain 1 #Intangible. \n#Exhaust.', Traits: [], },
    { Name: 'Beta', Image: 'Beta.png', Color: 'Colorless', Rarity: 'Special', Type: 'Skill', Cost: 2, CostPlus: 1, Text: 'Shuffle an [[Omega]] into draw pile. \n#Exhaust.', Traits: [], },
    { Name: 'Bite', Image: 'Bite.png', Color: 'Colorless', Rarity: 'Special', Type: 'Attack', Cost: 1, Text: 'Deal [7|8] damage.\nHeal [2|3] HP.', Traits: [], },
    { Name: 'Expunger', Image: 'Expunger.png', Color: 'Colorless', Rarity: 'Special', Type: 'Attack', Cost: 1, Text: 'Deal [9|15] damage X times.', Traits: [], },
    { Name: 'Insight', Image: 'Insight.png', Color: 'Colorless', Rarity: 'Special', Type: 'Skill', Cost: 0, Text: '#Retain. Draw [2|3] cards. #Exhaust.', Traits: [], },
    { Name: 'J.A.X.', Image: 'J.A.X..png', Color: 'Colorless', Rarity: 'Special', Type: 'Skill', Cost: 0, Text: 'Lose 3 HP.\nGain [2|3] #Strength.', Traits: [], },
    { Name: 'Miracle', Image: 'Miracle.png', Color: 'Colorless', Rarity: 'Special', Type: 'Skill', Cost: 0, Text: '#Retain. Gain <P>| <P>]. #Exhaust.', Traits: [], },
    { Name: 'Omega', Image: 'Omega.png', Color: 'Colorless', Rarity: 'Special', Type: 'Power', Cost: 3, Text: 'At the end of your turn, deal [50|60] damage to ALL enemies.', Traits: [], },
    { Name: 'Ritual Dagger', Image: 'RitualDagger.png', Color: 'Colorless', Rarity: 'Special', Type: 'Attack', Cost: 1, Text: "Deal 15 damage. If #Fatal, permanently increase this card's damage by [3|5].\n#Exhaust.", Traits: [], },
    { Name: 'Safety', Image: 'Safety.png', Color: 'Colorless', Rarity: 'Special', Type: 'Skill', Cost: 1, Text: '#Retain. Gain [12|16] #Block. #Exhaust.', Traits: [], },
    { Name: 'Shiv', Image: 'Shiv.png', Color: 'Colorless', Rarity: 'Special', Type: 'Attack', Cost: 0, Text: 'Deal [4|6] damage.\n#Exhaust.', Traits: [], },
    { Name: 'Smite', Image: 'Smite.png', Color: 'Colorless', Rarity: 'Special', Type: 'Attack', Cost: 1, Text: '#Retain. Deal [12|16] damage. #Exhaust.', Traits: [], },
    { Name: 'Through Violence', Image: 'ThroughViolence.png', Color: 'Colorless', Rarity: 'Special', Type: 'Attack', Cost: 0, Text: '#Retain. Deal [20|30] damage. #Exhaust.', Traits: [], },
    { Name: 'Bandage Up', Image: 'BandageUp.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Heal [4|6] HP.\n#Exhaust.', Traits: [], },
    { Name: 'Blind', Image: 'Blind.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Apply 2 #Weak| to ALL enemies].', Traits: [], },
    { Name: 'Dark Shackles', Image: 'DarkShackles.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Enemy loses [9|15] #Strength this turn.\n#Exhaust.', Traits: [], },
    { Name: 'Deep Breath', Image: 'DeepBreath.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Shuffle your discard pile into your draw pile.\nDraw [1|2] [card|cards].', Traits: [], },
    { Name: 'Discovery', Image: 'Discovery.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'Choose 1 of 3 random cards to add into your hand. It costs 0 this turn. [\n#Exhaust.|', Traits: [], },
    { Name: 'Dramatic Entrance', Image: 'DramaticEntrance.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Attack', Cost: 0, Text: '#Innate.\nDeal [8|12] damage to ALL enemies.\n#Exhaust.', Traits: [], },
    { Name: 'Enlightenment', Image: 'Enlightenment.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Reduce the cost of all cards in your hand to 1 this [turn|combat].', Traits: [], },
    { Name: 'Finesse', Image: 'Finesse.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Gain [2|4] #Block.\nDraw 1 card.', Traits: [], },
    { Name: 'Flash of Steel', Image: 'FlashofSteel.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Attack', Cost: 0, Text: 'Deal [3|6] damage.\nDraw 1 card.', Traits: [], },
    { Name: 'Forethought', Image: 'Forethought.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Put [a card|any number of cards] from your hand to the bottom of your draw pile. [It costs|They cost] 0 until played.', Traits: [], },
    { Name: 'Good Instincts', Image: 'GoodInstincts.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Gain [6|9] #Block.', Traits: [], },
    { Name: 'Impatience', Image: 'Impatience.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'If you have no Attacks in your hand, draw [2|3] cards.', Traits: [], },
    { Name: 'Jack of All Trades', Image: 'JackOfAllTrades.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Add [1|2] random Colorless [card|cards] into your hand.\n#Exhaust.', Traits: [], },
    { Name: 'Madness', Image: 'Madness.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, CostPlus: 0, Text: 'Reduce the cost of a random card in your hand to 0 this combat.\n#Exhaust.', Traits: [], },
    { Name: 'Mind Blast', Image: 'MindBlast.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Attack', Cost: 2, CostPlus: 1, Text: '#Innate.\nDeal damage equal to the number of cards in your draw pile.', Traits: [], },
    { Name: 'Panacea', Image: 'Panacea.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Gain [1|2] #Artifact.\n#Exhaust.', Traits: [], },
    { Name: 'Panic Button', Image: 'PanicButton.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Gain [30|40] #Block. You cannot gain #Block from cards for 2 turns.\n#Exhaust.', Traits: [], },
    { Name: 'Purity', Image: 'Purity.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: '#Exhaust up to [3|5] cards in your hand.\n#Exhaust.', Traits: [], },
    { Name: 'Swift Strike', Image: 'SwiftStrike.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Attack', Cost: 0, Text: 'Deal [7|10] damage.', Traits: [], },
    { Name: 'Trip', Image: 'Trip.png', Color: 'Colorless', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Apply 2 #Vulnerable| to ALL enemies].', Traits: [], },
    { Name: 'Apotheosis', Image: 'Apotheosis.png', Color: 'Colorless', Rarity: 'Rare', Type: 'Skill', Cost: 2, CostPlus: 1, Text: '#Upgrade ALL your cards for the rest of combat.\n#Exhaust.', Traits: [], },
    { Name: 'Chrysalis', Image: 'Chrysalis.png', Color: 'Colorless', Rarity: 'Rare', Type: 'Skill', Cost: 2, Text: 'Shuffle [3|5] random Skills into your draw pile. They cost 0 this combat.\n#Exhaust.', Traits: [], },
    { Name: 'Hand of Greed', Image: 'HandOfGreed.png', Color: 'Colorless', Rarity: 'Rare', Type: 'Attack', Cost: 2, Text: 'Deal [20|25] damage.\nIf #Fatal, gain [20|25] Gold.', Traits: [], },
    { Name: 'Magnetism', Image: 'Magnetism.png', Color: 'Colorless', Rarity: 'Rare', Type: 'Power', Cost: 2, CostPlus: 1, Text: 'At the start of your turn, add a random Colorless card into your hand.', Traits: [], },
    { Name: 'Master of Strategy', Image: 'MasterofStrategy.png', Color: 'Colorless', Rarity: 'Rare', Type: 'Skill', Cost: 0, Text: 'Draw [3|4] cards.\n#Exhaust.', Traits: [], },
    { Name: 'Mayhem', Image: 'Mayhem.png', Color: 'Colorless', Rarity: 'Rare', Type: 'Power', Cost: 2, CostPlus: 1, Text: 'At the start of your turn, play the top card of your draw pile.', Traits: [], },
    { Name: 'Metamorphosis', Image: 'Metamorphosis.png', Color: 'Colorless', Rarity: 'Rare', Type: 'Skill', Cost: 2, Text: 'Shuffle [3|5] random Attacks into your draw pile. They cost 0 this combat.\n#Exhaust.', Traits: [], },
    { Name: 'Panache', Image: 'Panache.png', Color: 'Colorless', Rarity: 'Rare', Type: 'Power', Cost: 0, Text: 'Every time you play 5 cards in a single turn, deal [10|14] damage to ALL enemies.', Traits: [], },
    { Name: 'Sadistic Nature', Image: 'SadisticNature.png', Color: 'Colorless', Rarity: 'Rare', Type: 'Power', Cost: 0, Text: 'Whenever you apply a debuff to an enemy, they take [5|7] damage.', Traits: [], },
    { Name: 'Secret Technique', Image: 'SecretTechnique.png', Color: 'Colorless', Rarity: 'Rare', Type: 'Skill', Cost: 0, Text: 'Put a Skill from your draw pile into your hand. [\n#Exhaust.|', Traits: [], },
    { Name: 'Secret Weapon', Image: 'SecretWeapon.png', Color: 'Colorless', Rarity: 'Rare', Type: 'Skill', Cost: 0, Text: 'Put an Attack from your draw pile into your hand. [\n#Exhaust.|', Traits: [], },
    { Name: 'The Bomb', Image: 'TheBomb.png', Color: 'Colorless', Rarity: 'Rare', Type: 'Skill', Cost: 2, Text: 'At the end of 3 turns, deal [40|50] damage to ALL enemies.', Traits: [], },
    { Name: 'Thinking Ahead', Image: 'ThinkingAhead.png', Color: 'Colorless', Rarity: 'Rare', Type: 'Skill', Cost: 0, Text: 'Draw 2 cards.\nPut a card from your hand on top of your draw pile. [\n#Exhaust.|', Traits: [], },
    { Name: 'Transmutation', Image: 'Transmutation.png', Color: 'Colorless', Rarity: 'Rare', Type: 'Skill', Cost: 'X', Text: 'Add X random| #upgraded] Colorless cards into your hand. They cost 0 this turn.\n#Exhaust.', Traits: [], },
    { Name: 'Violence', Image: 'Violence.png', Color: 'Colorless', Rarity: 'Rare', Type: 'Skill', Cost: 0, Text: 'Put [3|4] random Attacks from your draw pile into your hand.\n#Exhaust.', Traits: [], },
    { Name: 'Defend', Image: 'Defend_G.png', ID: 'Defend_G', Link: 'Defend (Silent)', Color: 'Green', Rarity: 'Basic', Type: 'Skill', Cost: 1, Text: 'Gain [5|8] #Block.', Traits: [], },
    { Name: 'Neutralize', Image: 'Neutralize.png', Color: 'Green', Rarity: 'Basic', Type: 'Attack', Cost: 0, Text: 'Deal [3|4] damage.\nApply [1|2] #Weak.', Traits: [], },
    { Name: 'Strike', Image: 'Strike_G.png', ID: 'Strike_G', Link: 'Strike (Silent)', Color: 'Green', Rarity: 'Basic', Type: 'Attack', Cost: 1, Text: 'Deal [6|9] damage.', Traits: [], },
    { Name: 'Survivor', Image: 'Survivor.png', Color: 'Green', Rarity: 'Basic', Type: 'Skill', Cost: 1, Text: 'Gain [8|11] #Block.\nDiscard 1 card.', Traits: [], },
    { Name: 'Acrobatics', Image: 'Acrobatics.png', Color: 'Green', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Draw [3|4] cards.\nDiscard 1 card.', Traits: [], },
    { Name: 'Backflip', Image: 'Backflip.png', Color: 'Green', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Gain [5|8] #Block.\nDraw 2 cards.', Traits: [], },
    { Name: 'Bane', Image: 'Bane.png', Color: 'Green', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [7|10] damage.\nIf the enemy has #Poison, deal [7|10] damage again.', Traits: [], },
    { Name: 'Blade Dance', Image: 'BladeDance.png', Color: 'Green', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Add [3|4] #Shivs into your hand.', Traits: [], },
    { Name: 'Cloak and Dagger', Image: 'CloakAndDagger.png', Color: 'Green', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Gain 6 #Block.\nAdd [1|2] [#Shiv|#Shivs] into your hand.', Traits: [], },
    { Name: 'Dagger Spray', Image: 'DaggerSpray.png', Color: 'Green', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [4|6] damage to ALL enemies twice.', Traits: [], },
    { Name: 'Dagger Throw', Image: 'DaggerThrow.png', Color: 'Green', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [9|12] damage.\nDraw 1 card. \nDiscard 1 card.', Traits: [], },
    { Name: 'Deadly Poison', Image: 'DeadlyPoison.png', Color: 'Green', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Apply [5|7] #Poison.', Traits: [], },
    { Name: 'Deflect', Image: 'Deflect.png', Color: 'Green', Rarity: 'Common', Type: 'Skill', Cost: 0, Text: 'Gain [4|7] #Block.', Traits: [], },
    { Name: 'Dodge and Roll', Image: 'DodgeandRoll.png', Color: 'Green', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Gain [4|6] #Block.\nNext turn, gain [4|6] #Block.', Traits: [], },
    { Name: 'Flying Knee', Image: 'FlyingKnee.png', Color: 'Green', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [8|11] damage.\nNext turn, gain <G>.', Traits: [], },
    { Name: 'Outmaneuver', Image: 'Outmaneuver.png', Color: 'Green', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Next turn,\ngain <G> <G>| <G>].', Traits: [], },
    { Name: 'Piercing Wail', Image: 'PiercingWail.png', Color: 'Green', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'ALL enemies lose [6|8] #Strength this turn.\n#Exhaust.', Traits: [], },
    { Name: 'Poisoned Stab', Image: 'PoisonedStab.png', Color: 'Green', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [6|8] damage.\nApply [3|4] #Poison.', Traits: [], },
    { Name: 'Prepared', Image: 'Prepared.png', Color: 'Green', Rarity: 'Common', Type: 'Skill', Cost: 0, Text: 'Draw [1|2] [card|cards].\nDiscard [1|2] [card|cards].', Traits: [], },
    { Name: 'Quick Slash', Image: 'QuickSlash.png', Color: 'Green', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [8|12] damage.\nDraw 1 card.', Traits: [], },
    { Name: 'Slice', Image: 'Slice.png', Color: 'Green', Rarity: 'Common', Type: 'Attack', Cost: 0, Text: 'Deal [6|9] damage.', Traits: [], },
    { Name: 'Sneaky Strike', Image: 'SneakyStrike.png', Color: 'Green', Rarity: 'Common', Type: 'Attack', Cost: 2, Text: 'Deal [12|16] damage.\nIf you have discarded a card this turn,\ngain <G> <G>.', Traits: [], },
    { Name: 'Sucker Punch', Image: 'SuckerPunch.png', Color: 'Green', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [7|9] damage.\nApply [1|2] #Weak.', Traits: [], },
    { Name: 'Accuracy', Image: 'Accuracy.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: '#Shivs deal [4|6] additional damage.', Traits: [], },
    { Name: 'All-Out Attack', Image: 'All-OutAttack.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: 'Deal [10|14] damage to ALL enemies.\nDiscard 1 card at random.', Traits: [], },
    { Name: 'Backstab', Image: 'Backstab.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Attack', Cost: 0, Text: '#Innate.\nDeal [11|15] damage.\n#Exhaust.', Traits: [], },
    { Name: 'Blur', Image: 'Blur.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'Gain [5|8] #Block.\n#Block is not removed at the start of your next turn.', Traits: [], },
    { Name: 'Bouncing Flask', Image: 'BouncingFlask.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Skill', Cost: 2, Text: 'Apply 3 #Poison to a random enemy [3|4] times.', Traits: [], },
    { Name: 'Calculated Gamble', Image: 'CalculatedGamble.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Discard your hand,\nthen draw that many cards. [\n#Exhaust.|', Traits: [], },
    { Name: 'Caltrops', Image: 'Caltrops.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'Whenever you are attacked, deal [3|5] damage back.', Traits: [], },
    { Name: 'Catalyst', Image: 'Catalyst.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: "[Double|Triple] the enemy's #Poison.\n#Exhaust.", Traits: [], },
    { Name: 'Choke', Image: 'Choke.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Attack', Cost: 2, Text: 'Deal 12 damage.\nWhenever you play a card this turn, the enemy loses [3|5] HP.', Traits: [], },
    { Name: 'Concentrate', Image: 'Concentrate.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Discard [3|2] cards.\nGain <G> <G>.', Traits: [], },
    { Name: 'Crippling Cloud', Image: 'CripplingCloud.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Skill', Cost: 2, Text: 'Apply [4|7] #Poison and 2 #Weak to ALL enemies.\n#Exhaust.', Traits: [], },
    { Name: 'Dash', Image: 'Dash.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Attack', Cost: 2, Text: 'Gain [10|13] #Block.\nDeal [10|13] damage.', Traits: [], },
    { Name: 'Distraction', Image: 'Distraction.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, CostPlus: 0, Text: 'Add a random Skill into your hand.\nIt costs 0 this turn.\n#Exhaust.', Traits: [], },
    { Name: 'Endless Agony', Image: 'EndlessAgony.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Attack', Cost: 0, Text: 'Whenever you draw this card, add a copy of it into your hand.\nDeal [4|6] damage.\n#Exhaust.', Traits: [], },
    { Name: 'Escape Plan', Image: 'EscapePlan.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Draw 1 card.\nIf you draw a Skill, gain [3|5] #Block.', Traits: [], },
    { Name: 'Eviscerate', Image: 'Eviscerate.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Attack', Cost: 3, Text: 'Costs 1 less <G>\nfor each card discarded this turn.\nDeal [7|9] damage 3 times.', Traits: [], },
    { Name: 'Expertise', Image: 'Expertise.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'Draw cards until you have [6|7] in your hand.', Traits: [], },
    { Name: 'Finisher', Image: 'Finisher.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: 'Deal [6|8] damage for each Attack played this turn.', Traits: [], },
    { Name: 'Flechettes', Image: 'Flechettes.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: 'Deal [4|6] damage for each Skill in your hand.', Traits: [], },
    { Name: 'Footwork', Image: 'Footwork.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'Gain [2|3] #Dexterity.', Traits: [], },
    { Name: 'Heel Hook', Image: 'HeelHook.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: 'Deal [5|8] damage. \nIf the enemy has #Weak, \ngain <G> and \ndraw 1 card.', Traits: [], },
    { Name: 'Infinite Blades', Image: 'InfiniteBlades.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: '|#Innate. ]At the start of your turn, add a #Shiv into your hand.', Traits: ['Innate'], },
    { Name: 'Leg Sweep', Image: 'LegSweep.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Skill', Cost: 2, Text: 'Apply [2|3] #Weak.\nGain [11|14] #Block.', Traits: [], },
    { Name: 'Masterful Stab', Image: 'MasterfulStab.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Attack', Cost: 0, Text: 'Costs 1 additional <G>\nfor each time you lose HP this combat.\nDeal [12|16] damage.', Traits: [], },
    { Name: 'Noxious Fumes', Image: 'NoxiousFumes.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'At the start of your turn, apply [2|3] #Poison to ALL enemies.', Traits: [], },
    { Name: 'Predator', Image: 'Predator.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Attack', Cost: 2, Text: 'Deal [15|20] damage.\nNext turn, draw 2 additional cards.', Traits: [], },
    { Name: 'Reflex', Image: 'Reflex.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Skill', Cost: -2, Text: '#Unplayable.\nIf this card is discarded from your hand, draw [2|3] [card|cards].', Traits: [], },
    { Name: 'Riddle with Holes', Image: 'RiddleWithHoles.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Attack', Cost: 2, Text: 'Deal [3|4] damage 5 times.', Traits: [], },
    { Name: 'Setup', Image: 'Setup.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, CostPlus: 0, Text: 'Put a card from your hand on top of your draw pile.\nIt costs 0 until played.', Traits: [], },
    { Name: 'Skewer', Image: 'Skewer.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Attack', Cost: 'X', Text: 'Deal [7|10] damage X times.', Traits: [], },
    { Name: 'Tactician', Image: 'Tactician.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Skill', Cost: -2, Text: '#Unplayable.\nIf this card is discarded from your hand, gain <G>| <G>].', Traits: [], },
    { Name: 'Terror', Image: 'Terror.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, CostPlus: 0, Text: 'Apply 99 #Vulnerable.\n#Exhaust.', Traits: [], },
    { Name: 'Well-Laid Plans', Image: 'Well-LaidPlans.png', Color: 'Green', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'At the end of your turn, #Retain up to [1|2] [card|cards].', Traits: [], },
    { Name: 'A Thousand Cuts', Image: 'AThousandCuts.png', Color: 'Green', Rarity: 'Rare', Type: 'Power', Cost: 2, Text: 'Whenever you play a card, deal [1|2] damage to ALL enemies.', Traits: [], },
    { Name: 'Adrenaline', Image: 'Adrenaline.png', Color: 'Green', Rarity: 'Rare', Type: 'Skill', Cost: 0, Text: 'Gain <G>| <G>].\nDraw 2 cards.\n#Exhaust.', Traits: [], },
    { Name: 'After Image', Image: 'AfterImage.png', Color: 'Green', Rarity: 'Rare', Type: 'Power', Cost: 1, Text: '|#Innate.] \nWhenever you play a card, gain 1 #Block.', Traits: [], },
    { Name: 'Alchemize', Image: 'Alchemize.png', Color: 'Green', Rarity: 'Rare', Type: 'Skill', Cost: 1, CostPlus: 0, Text: 'Obtain a random potion.\n#Exhaust.', Traits: [], },
    { Name: 'Bullet Time', Image: 'BulletTime.png', Color: 'Green', Rarity: 'Rare', Type: 'Skill', Cost: 3, CostPlus: 2, Text: 'You cannot draw additional cards this turn. Reduce the cost of all cards in your hand to 0 this turn.', Traits: [], },
    { Name: 'Burst', Image: 'Burst.png', Color: 'Green', Rarity: 'Rare', Type: 'Skill', Cost: 1, Text: 'This turn, your next [Skill is|2 Skills are] played twice.', Traits: [], },
    { Name: 'Corpse Explosion', Image: 'CorpseExplosion.png', Color: 'Green', Rarity: 'Rare', Type: 'Skill', Cost: 2, Text: 'Apply [6|9] #Poison.\nWhen the enemy dies, deal damage equal to its max HP to ALL enemies.', Traits: [], },
    { Name: 'Die Die Die', Image: 'DieDieDie.png', Color: 'Green', Rarity: 'Rare', Type: 'Attack', Cost: 1, Text: 'Deal [13|17] damage to ALL enemies.\n#Exhaust.', Traits: [], },
    { Name: 'Doppelganger', Image: 'Doppelganger.png', Color: 'Green', Rarity: 'Rare', Type: 'Skill', Cost: 'X', Text: 'Next turn, draw [X|X+1] cards and gain [X|X+1] <G>.\n#Exhaust.', Traits: [], },
    { Name: 'Envenom', Image: 'Envenom.png', Color: 'Green', Rarity: 'Rare', Type: 'Power', Cost: 2, CostPlus: 1, Text: 'Whenever an Attack deals unblocked damage, apply 1 #Poison.', Traits: [], },
    { Name: 'Glass Knife', Image: 'GlassKnife.png', Color: 'Green', Rarity: 'Rare', Type: 'Attack', Cost: 1, Text: 'Deal [8|12] damage twice. Decrease the damage of this card by 2 this combat.', Traits: [], },
    { Name: 'Grand Finale', Image: 'GrandFinale.png', Color: 'Green', Rarity: 'Rare', Type: 'Attack', Cost: 0, Text: 'Can only be played if there are no cards in your draw pile.\nDeal [50|60] damage to ALL enemies.', Traits: [], },
    { Name: 'Malaise', Image: 'Malaise.png', Color: 'Green', Rarity: 'Rare', Type: 'Skill', Cost: 'X', Text: 'Enemy loses [X|X+1] #Strength. Apply [X|X+1] #Weak.\n#Exhaust.', Traits: [], },
    { Name: 'Nightmare', Image: 'Nightmare.png', Color: 'Green', Rarity: 'Rare', Type: 'Skill', Cost: 3, CostPlus: 2, Text: 'Choose a card.\nNext turn, add 3 copies of that card into your hand. #Exhaust.', Traits: [], },
    { Name: 'Phantasmal Killer', Image: 'PhantasmalKiller.png', Color: 'Green', Rarity: 'Rare', Type: 'Skill', Cost: 1, CostPlus: 0, Text: 'Next turn, your Attacks deal double damage.', Traits: [], },
    { Name: 'Storm of Steel', Image: 'StormofSteel.png', Color: 'Green', Rarity: 'Rare', Type: 'Skill', Cost: 1, Text: 'Discard your hand.\nAdd 1 #Shiv|+] into your hand for each card discarded.', Traits: [], },
    { Name: 'Tools of the Trade', Image: 'ToolsoftheTrade.png', Color: 'Green', Rarity: 'Rare', Type: 'Power', Cost: 1, CostPlus: 0, Text: 'At the start of your turn, draw 1 card and discard 1 card.', Traits: [], },
    { Name: 'Unload', Image: 'Unload.png', Color: 'Green', Rarity: 'Rare', Type: 'Attack', Cost: 1, Text: 'Deal [14|18] damage.\nDiscard all non-Attack cards in your hand.', Traits: [], },
    { Name: 'Wraith Form', Image: 'WraithForm.png', Color: 'Green', Rarity: 'Rare', Type: 'Power', Cost: 3, Text: 'Gain [2|3] #Intangible.\nAt the end of your turn, lose 1 #Dexterity.', Traits: [], },
    { Name: 'Bash', Image: 'Bash.png', Color: 'Red', Rarity: 'Basic', Type: 'Attack', Cost: 2, Text: 'Deal [8|10] damage.\nApply [2|3] #Vulnerable.', Traits: [], },
    { Name: 'Defend', Image: 'Defend_R.png', ID: 'Defend_R', Link: 'Defend (Ironclad)', Color: 'Red', Rarity: 'Basic', Type: 'Skill', Cost: 1, Text: 'Gain [5|8] #Block.', Traits: [], },
    { Name: 'Strike', Image: 'Strike_R.png', ID: 'Strike_R', Link: 'Strike (Ironclad)', Color: 'Red', Rarity: 'Basic', Type: 'Attack', Cost: 1, Text: 'Deal [6|9] damage.', Traits: [], },
    { Name: 'Anger', Image: 'Anger.png', Color: 'Red', Rarity: 'Common', Type: 'Attack', Cost: 0, Text: 'Deal [6|8] damage.\nAdd a copy of this card into your discard pile.', Traits: [], },
    { Name: 'Armaments', Image: 'Armaments.png', Color: 'Red', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Gain 5 #Block.\n#Upgrade [a card|all cards] in your hand for the rest of combat.', Traits: [], },
    { Name: 'Body Slam', Image: 'BodySlam.png', Color: 'Red', Rarity: 'Common', Type: 'Attack', Cost: 1, CostPlus: 0, Text: 'Deal damage equal to your #Block.', Traits: [], },
    { Name: 'Clash', Image: 'Clash.png', Color: 'Red', Rarity: 'Common', Type: 'Attack', Cost: 0, Text: 'Can only be played if every card in your hand is an Attack.\nDeal [14|18] damage.', Traits: [], },
    { Name: 'Cleave', Image: 'Cleave.png', Color: 'Red', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [8|11] damage to ALL enemies.', Traits: [], },
    { Name: 'Clothesline', Image: 'Clothesline.png', Color: 'Red', Rarity: 'Common', Type: 'Attack', Cost: 2, Text: 'Deal [12|14] damage.\nApply [2|3] #Weak.', Traits: [], },
    { Name: 'Flex', Image: 'Flex.png', Color: 'Red', Rarity: 'Common', Type: 'Skill', Cost: 0, Text: 'Gain [2|4] #Strength.\nAt the end of this turn, lose [2|4] #Strength.', Traits: [], },
    { Name: 'Havoc', Image: 'Havoc.png', Color: 'Red', Rarity: 'Common', Type: 'Skill', Cost: 1, CostPlus: 0, Text: 'Play the top card of your draw pile and #Exhaust it.', Traits: [], },
    { Name: 'Headbutt', Image: 'Headbutt.png', Color: 'Red', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [9|12] damage.\nPut a card from your discard pile on top of your draw pile.', Traits: [], },
    { Name: 'Heavy Blade', Image: 'HeavyBlade.png', Color: 'Red', Rarity: 'Common', Type: 'Attack', Cost: 2, Text: 'Deal 14 damage.\n#Strength affects this card [3|5] times.', Traits: [], },
    { Name: 'Iron Wave', Image: 'IronWave.png', Color: 'Red', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Gain [5|7] #Block.\nDeal [5|7] damage.', Traits: [], },
    { Name: 'Perfected Strike', Image: 'PerfectedStrike.png', Color: 'Red', Rarity: 'Common', Type: 'Attack', Cost: 2, Text: 'Deal 6 damage.\nDeals [2|3] additional damage for ALL your cards containing "Strike".', Traits: [], },
    { Name: 'Pommel Strike', Image: 'PommelStrike.png', Color: 'Red', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [9|10] damage.\nDraw [1|2] [card|cards].', Traits: [], },
    { Name: 'Shrug It Off', Image: 'ShrugItOff.png', Color: 'Red', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Gain [8|11] #Block.\nDraw 1 card.', Traits: [], },
    { Name: 'Sword Boomerang', Image: 'SwordBoomerang.png', Color: 'Red', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal 3 damage to a random enemy [3|4] times.', Traits: [], },
    { Name: 'Thunderclap', Image: 'Thunderclap.png', Color: 'Red', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [4|7] damage and apply 1 #Vulnerable to ALL enemies.', Traits: [], },
    { Name: 'True Grit', Image: 'TrueGrit.png', Color: 'Red', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Gain [7|9] #Block.\n#Exhaust a [random|] card in your hand.', Traits: [], },
    { Name: 'Twin Strike', Image: 'TwinStrike.png', Color: 'Red', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [5|7] damage twice.', Traits: [], },
    { Name: 'Warcry', Image: 'Warcry.png', Color: 'Red', Rarity: 'Common', Type: 'Skill', Cost: 0, Text: 'Draw [1|2] [card|cards].\nPut a card from your hand onto the top of your draw pile.\n#Exhaust.', Traits: [], },
    { Name: 'Wild Strike', Image: 'WildStrike.png', Color: 'Red', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [12|17] damage.\nShuffle a #Wound into your draw pile.', Traits: [], },
    { Name: 'Battle Trance', Image: 'BattleTrance.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Draw [3|4] cards.\nYou cannot draw additional cards this turn.', Traits: [], },
    { Name: 'Blood for Blood', Image: 'BloodforBlood.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Attack', Cost: 4, CostPlus: 3, Text: 'Costs 1 less <R>\nfor each time you lose HP this combat.\nDeal [18|22] damage.', Traits: [], },
    { Name: 'Bloodletting', Image: 'Bloodletting.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Lose 3 HP.\nGain <R> <R>| <R>].', Traits: [], },
    { Name: 'Burning Pact', Image: 'BurningPact.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: '#Exhaust 1 card.\nDraw [2|3] cards.', Traits: [], },
    { Name: 'Carnage', Image: 'Carnage.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Attack', Cost: 2, Text: '#Ethereal.\nDeal [20|28] damage.', Traits: [], },
    { Name: 'Combust', Image: 'Combust.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'At the end of your turn, lose 1 HP and deal [5|7] damage to ALL enemies.', Traits: [], },
    { Name: 'Dark Embrace', Image: 'DarkEmbrace.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Power', Cost: 2, CostPlus: 1, Text: 'Whenever a card is #Exhausted,\ndraw 1 card.', Traits: [], },
    { Name: 'Disarm', Image: 'Disarm.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'Enemy loses [2|3] #Strength.\n#Exhaust.', Traits: [], },
    { Name: 'Dropkick', Image: 'Dropkick.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: 'Deal [5|8] damage.\nIf the enemy has #Vulnerable, gain <R> and draw 1 card.', Traits: [], },
    { Name: 'Dual Wield', Image: 'DualWield.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'Choose an Attack or Power card. Add [a copy|2 copies] of that card into your hand.', Traits: [], },
    { Name: 'Entrench', Image: 'Entrench.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Skill', Cost: 2, CostPlus: 1, Text: 'Double your #Block.', Traits: [], },
    { Name: 'Evolve', Image: 'Evolve.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'Whenever you draw a #Status card, draw [1|2] [card|cards].', Traits: [], },
    { Name: 'Feel No Pain', Image: 'FeelNoPain.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'Whenever a card is #Exhausted,\ngain [3|4] #Block.', Traits: [], },
    { Name: 'Fire Breathing', Image: 'FireBreathing.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'Whenever you draw a #Status or #Curse card, deal [6|10] damage to ALL enemies.', Traits: [], },
    { Name: 'Flame Barrier', Image: 'FlameBarrier.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Skill', Cost: 2, Text: 'Gain [12|16] #Block.\nWhenever you are attacked this turn, deal [4|6] damage back.', Traits: [], },
    { Name: 'Ghostly Armor', Image: 'GhostlyArmor.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: '#Ethereal.\nGain [10|13] #Block.', Traits: [], },
    { Name: 'Hemokinesis', Image: 'Hemokinesis.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: 'Lose 2 HP.\nDeal [15|20] damage.', Traits: [], },
    { Name: 'Infernal Blade', Image: 'InfernalBlade.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, CostPlus: 0, Text: 'Add a random Attack into your hand.\nIt costs 0 this turn.\n#Exhaust.', Traits: [], },
    { Name: 'Inflame', Image: 'Inflame.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'Gain [2|3] #Strength.', Traits: [], },
    { Name: 'Intimidate', Image: 'Intimidate.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Apply [1|2] #Weak to ALL enemies.\n#Exhaust.', Traits: [], },
    { Name: 'Metallicize', Image: 'Metallicize.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'At the end of your turn, gain [3|4] #Block.', Traits: [], },
    { Name: 'Power Through', Image: 'PowerThrough.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'Add 2 #Wounds into your hand.\nGain [15|20] #Block.', Traits: [], },
    { Name: 'Pummel', Image: 'Pummel.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: 'Deal 2 damage [4|5] times.\n#Exhaust.', Traits: [], },
    { Name: 'Rage', Image: 'Rage.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Whenever you play an Attack this turn, gain [3|5] #Block.', Traits: [], },
    { Name: 'Rampage', Image: 'Rampage.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: "Deal 8 damage.\nIncrease this card's damage by [5|8] this combat.", Traits: [], },
    { Name: 'Reckless Charge', Image: 'RecklessCharge.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Attack', Cost: 0, Text: 'Deal [7|10] damage.\nShuffle a [[Dazed]] into your draw pile.', Traits: [], },
    { Name: 'Rupture', Image: 'Rupture.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'Whenever you lose HP from a card,\ngain [1|2] #Strength.', Traits: [], },
    { Name: 'Searing Blow', Image: 'SearingBlow.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Attack', Cost: 2, Text: 'Deal [12|16] damage.\nCan be #Upgraded any number of times.', Traits: [], },
    { Name: 'Second Wind', Image: 'SecondWind.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: '#Exhaust all non-Attack cards in your hand. Gain [5|7] #Block for each card #Exhausted.', Traits: [], },
    { Name: 'Seeing Red', Image: 'SeeingRed.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, CostPlus: 0, Text: 'Gain <R> <R>.\n#Exhaust.', Traits: [], },
    { Name: 'Sentinel', Image: 'Sentinel.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'Gain [5|8] #Block.\nIf this card is #Exhausted,\ngain <R> <R>| <R>].', Traits: [], },
    { Name: 'Sever Soul', Image: 'SeverSoul.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Attack', Cost: 2, Text: '#Exhaust all non-Attack cards in your hand.\nDeal [16|22] damage.', Traits: [], },
    { Name: 'Shockwave', Image: 'Shockwave.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Skill', Cost: 2, Text: 'Apply [3|5] #Weak and #Vulnerable to ALL enemies.\n#Exhaust.', Traits: [], },
    { Name: 'Spot Weakness', Image: 'SpotWeakness.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'If the enemy intends to attack, gain [3|4] #Strength.', Traits: [], },
    { Name: 'Uppercut', Image: 'Uppercut.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Attack', Cost: 2, Text: 'Deal 13 damage.\nApply [1|2] #Weak.\nApply [1|2] #Vulnerable.', Traits: [], },
    { Name: 'Whirlwind', Image: 'Whirlwind.png', Color: 'Red', Rarity: 'Uncommon', Type: 'Attack', Cost: 'X', Text: 'Deal [5|8] damage to ALL enemies X times.', Traits: [], },
    { Name: 'Barricade', Image: 'Barricade.png', Color: 'Red', Rarity: 'Rare', Type: 'Power', Cost: 3, CostPlus: 2, Text: '#Block is not removed at the start of your turn.', Traits: [], },
    { Name: 'Berserk', Image: 'Berserk.png', Color: 'Red', Rarity: 'Rare', Type: 'Power', Cost: 0, Text: 'Gain [2|1] #Vulnerable.\nAt the start of your turn, gain <R>.', Traits: [], },
    { Name: 'Bludgeon', Image: 'Bludgeon.png', Color: 'Red', Rarity: 'Rare', Type: 'Attack', Cost: 3, Text: 'Deal [32|42] damage.', Traits: [], },
    { Name: 'Brutality', Image: 'Brutality.png', Color: 'Red', Rarity: 'Rare', Type: 'Power', Cost: 0, Text: '|#Innate.] \nAt the start of your turn, lose 1 HP and draw 1 card.', Traits: [], },
    { Name: 'Corruption', Image: 'Corruption.png', Color: 'Red', Rarity: 'Rare', Type: 'Power', Cost: 3, CostPlus: 2, Text: 'Skills cost 0.\nWhenever you play a Skill, #Exhaust it.', Traits: [], },
    { Name: 'Demon Form', Image: 'DemonForm.png', Color: 'Red', Rarity: 'Rare', Type: 'Power', Cost: 3, Text: 'At the start of your turn, gain [2|3] #Strength.', Traits: [], },
    { Name: 'Double Tap', Image: 'DoubleTap.png', Color: 'Red', Rarity: 'Rare', Type: 'Skill', Cost: 1, Text: 'This turn, your next [Attack is|[1|2] Attacks are] played twice.', Traits: [], },
    { Name: 'Exhume', Image: 'Exhume.png', Color: 'Red', Rarity: 'Rare', Type: 'Skill', Cost: 1, CostPlus: 0, Text: 'Put a card from your #Exhaust pile into your hand.\n#Exhaust.', Traits: [], },
    { Name: 'Feed', Image: 'Feed.png', Color: 'Red', Rarity: 'Rare', Type: 'Attack', Cost: 1, Text: 'Deal [10|12] damage.\nIf #Fatal, raise your Max HP by [3|4]. #Exhaust.', Traits: [], },
    { Name: 'Fiend Fire', Image: 'FiendFire.png', Color: 'Red', Rarity: 'Rare', Type: 'Attack', Cost: 2, Text: '#Exhaust all cards in your hand.\nDeal [7|10] damage for each #Exhausted card.\n#Exhaust.', Traits: [], },
    { Name: 'Immolate', Image: 'Immolate.png', Color: 'Red', Rarity: 'Rare', Type: 'Attack', Cost: 2, Text: 'Deal [21|28] damage to ALL enemies.\nAdd a [[Burn]] into your discard pile.', Traits: [], },
    { Name: 'Impervious', Image: 'Impervious.png', Color: 'Red', Rarity: 'Rare', Type: 'Skill', Cost: 2, Text: 'Gain [30|40] #Block.\n#Exhaust.', Traits: [], },
    { Name: 'Juggernaut', Image: 'Juggernaut.png', Color: 'Red', Rarity: 'Rare', Type: 'Power', Cost: 2, Text: 'Whenever you gain #Block, deal [5|7] damage to a random enemy.', Traits: [], },
    { Name: 'Limit Break', Image: 'LimitBreak.png', Color: 'Red', Rarity: 'Rare', Type: 'Skill', Cost: 1, Text: 'Double your #Strength. [\n#Exhaust.|', Traits: [], },
    { Name: 'Offering', Image: 'Offering.png', Color: 'Red', Rarity: 'Rare', Type: 'Skill', Cost: 0, Text: 'Lose 6 HP.\nGain <R> <R>.\nDraw [3|5] cards.\n#Exhaust.', Traits: [], },
    { Name: 'Reaper', Image: 'Reaper.png', Color: 'Red', Rarity: 'Rare', Type: 'Attack', Cost: 2, Text: 'Deal [4|5] damage to ALL enemies. Heal HP equal to unblocked damage.\n#Exhaust.', Traits: [], },
    { Name: 'Clumsy', Image: 'Clumsy.png', Color: 'Curse', Rarity: 'Curse', Type: 'Curse', Cost: -2, Text: '#Unplayable.\n#Ethereal.', NoUpgrade: true, Traits: ['Unplayable', 'Ethereal'], },
    { Name: 'Curse of the Bell', Image: 'CurseoftheBell.png', Color: 'Curse', Rarity: 'Curse', Type: 'Curse', Cost: -2, Text: '#Unplayable. Cannot be removed from your deck.', NoUpgrade: true, Traits: ['Unplayable', 'Ethereal'], },
    { Name: 'Decay', Image: 'Decay.png', Color: 'Curse', Rarity: 'Curse', Type: 'Curse', Cost: -2, Text: '#Unplayable.\nAt the end of your turn, take 2 damage.', NoUpgrade: true, Traits: [], },
    { Name: 'Doubt', Image: 'Doubt.png', Color: 'Curse', Rarity: 'Curse', Type: 'Curse', Cost: -2, Text: '#Unplayable.\nAt the end of your turn, gain 1 #Weak.', NoUpgrade: true, Traits: ['Unplayable', 'SelfDebuff'], },
    { Name: 'Injury', Image: 'Injury.png', Color: 'Curse', Rarity: 'Curse', Type: 'Curse', Cost: -2, Text: '#Unplayable.', NoUpgrade: true, Traits: ['Unplayable'], },
    { Name: 'Necronomicurse', Image: 'Necronomicurse.png', Color: 'Curse', Rarity: 'Curse', Type: 'Curse', Cost: -2, Text: '#Unplayable.\nThere is no escape from this curse.', NoUpgrade: true, Traits: ['Unplayable'], },
    { Name: 'Normality', Image: 'Normality.png', Color: 'Curse', Rarity: 'Curse', Type: 'Curse', Cost: -2, Text: '#Unplayable.\nYou cannot play more than 3 cards this turn.', NoUpgrade: true, Traits: ['Unplayable'], },
    { Name: 'Pain', Image: 'Pain.png', Color: 'Curse', Rarity: 'Curse', Type: 'Curse', Cost: -2, Text: '#Unplayable.\nWhile in hand, lose 1 HP when other cards are played.', NoUpgrade: true, Traits: ['Unplayable', 'Life Payment'], },
    { Name: 'Parasite', Image: 'Parasite.png', Color: 'Curse', Rarity: 'Curse', Type: 'Curse', Cost: -2, Text: '#Unplayable.\nIf transformed or removed from your deck, lose 3 Max HP.', NoUpgrade: true, Traits: ['Unplayable'], },
    { Name: 'Pride', Image: 'Pride.png', Color: 'Curse', Rarity: 'Curse', Type: 'Curse', Cost: 1, Text: '#Innate.\nAt the end of your turn, put a copy of this card on top of your draw pile.\n#Exhaust.', NoUpgrade: true, Traits: [], },
    { Name: 'Regret', Image: 'Regret.png', Color: 'Curse', Rarity: 'Curse', Type: 'Curse', Cost: -2, Text: '#Unplayable.\nAt the end of your turn, lose 1 HP for each card in your hand.', NoUpgrade: true, Traits: ['Unplayable', 'Life Payment'], },
    { Name: 'Shame', Image: 'Shame.png', Color: 'Curse', Rarity: 'Curse', Type: 'Curse', Cost: -2, Text: '#Unplayable.\n#At the end of your turn, gain 1 Frail.', NoUpgrade: true, Traits: ['Unplayable', 'At the end of your turn, gain 1 Frail.'], },
    { Name: 'Writhe', Image: 'Writhe.png', Color: 'Curse', Rarity: 'Curse', Type: 'Curse', Cost: -2, Text: '#Unplayable.\n#Innate.', NoUpgrade: true, Traits: ['Unplayable', 'Innate'], },
    { Name: "Ascender's Bane", Image: 'Ascender%27s Bane.png', Color: 'Curse', Rarity: 'Curse', Type: 'Curse', Cost: -2, Text: '#Unplayable.', NoUpgrade: true, Traits: ['Unplayable'], },
    { Name: 'Burn', Image: 'Burn.png', Color: 'Colorless', Rarity: 'Common', Type: 'Status', Cost: -2, Text: '#Unplayable.\nAt the end of your turn, take [2|4] damage.', Traits: ['Unplayable', 'Self-Damage'], },
    { Name: 'Dazed', Image: 'Dazed.png', Color: 'Colorless', Rarity: 'Common', Type: 'Status', Cost: -2, Text: '#Unplayable.\n#Ethereal.', NoUpgrade: true, Traits: ['Unplayable', 'Ethereal'], },
    { Name: 'Slimed', Image: 'Slimed.png', Color: 'Colorless', Rarity: 'Common', Type: 'Status', Cost: 1, Text: '#Exhaust.', NoUpgrade: true, Traits: ['Exhaust'], },
    { Name: 'Void', Image: 'Void.png', Color: 'Colorless', Rarity: 'Common', Type: 'Status', Cost: -2, Text: '#Unplayable.\nWhenever this card is drawn, lose 1 Energy.\n#Ethereal.', NoUpgrade: true, Traits: ['Unplayable', 'Whenever this card is drawn, lose 1 Energy.', 'Ethereal.'], },
    { Name: 'Wound', Image: 'Wound.png', Color: 'Colorless', Rarity: 'Common', Type: 'Status', Cost: -2, Text: '#Unplayable.', NoUpgrade: true, Traits: ['Unplayable'], },
    { Name: 'Defend', Image: 'Defend_B.png', ID: 'Defend_B', Link: 'Defend (Defect)', Color: 'Blue', Rarity: 'Basic', Type: 'Skill', Cost: 1, Text: 'Gain [5|8] #Block.', Traits: [], },
    { Name: 'Dualcast', Image: 'Dualcast.png', Color: 'Blue', Rarity: 'Basic', Type: 'Skill', Cost: 1, CostPlus: 0, Text: '#Evoke your next Orb twice.', Traits: [], },
    { Name: 'Strike', Image: 'Strike_B.png', ID: 'Strike_B', Link: 'Strike (Defect)', Color: 'Blue', Rarity: 'Basic', Type: 'Attack', Cost: 1, Text: 'Deal [6|9] damage.', Traits: [], },
    { Name: 'Zap', Image: 'Zap.png', Color: 'Blue', Rarity: 'Basic', Type: 'Skill', Cost: 1, CostPlus: 0, Text: '#Channel 1 #Lightning.', Traits: [], },
    { Name: 'Ball Lightning', Image: 'BallLightning.png', Color: 'Blue', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [7|10] damage. #Channel 1 #Lightning.', Traits: [], },
    { Name: 'Barrage', Image: 'Barrage.png', Color: 'Blue', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [4|6] damage for each #Channeled Orb.', Traits: [], },
    { Name: 'Beam Cell', Image: 'BeamCell.png', Color: 'Blue', Rarity: 'Common', Type: 'Attack', Cost: 0, Text: 'Deal [3|4] damage.\nApply [1|2] #Vulnerable.', Traits: [], },
    { Name: 'Charge Battery', Image: 'ChargeBattery.png', Color: 'Blue', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Gain [7|10] #Block.\nNext turn, gain <B>.', Traits: [], },
    { Name: 'Claw', Image: 'Claw.png', Color: 'Blue', Rarity: 'Common', Type: 'Attack', Cost: 0, Text: 'Deal [3|5] damage.\nIncrease the damage of ALL Claw cards by 2 this combat.', Traits: [], },
    { Name: 'Cold Snap', Image: 'ColdSnap.png', Color: 'Blue', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [6|9] damage. #Channel 1 #Frost.', Traits: [], },
    { Name: 'Compile Driver', Image: 'CompileDriver.png', Color: 'Blue', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [7|10] damage.\nDraw 1 card for each unique Orb you have.', Traits: [], },
    { Name: 'Coolheaded', Image: 'Coolheaded.png', Color: 'Blue', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: '#Channel 1 #Frost.\nDraw [1|2] [card|cards].', Traits: [], },
    { Name: 'Go for the Eyes', Image: 'GofortheEyes.png', Color: 'Blue', Rarity: 'Common', Type: 'Attack', Cost: 0, Text: 'Deal [3|4] damage.\nIf the enemy intends to attack, apply [1|2] #Weak.', Traits: [], },
    { Name: 'Hologram', Image: 'Hologram.png', Color: 'Blue', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Gain [3|5] #Block.\nPut a card from your discard pile into your hand. [\n#Exhaust.|', Traits: [], },
    { Name: 'Leap', Image: 'Leap.png', Color: 'Blue', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Gain [9|12] #Block.', Traits: [], },
    { Name: 'Rebound', Image: 'Rebound.png', Color: 'Blue', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [9|12] damage.\nPut the next card you play this turn on top of your draw pile.', Traits: [], },
    { Name: 'Recursion', Image: 'Recursion.png', Color: 'Blue', Rarity: 'Common', Type: 'Skill', Cost: 1, CostPlus: 0, Text: '#Evoke your next Orb.\n#Channel the Orb that was just #Evoked.', Traits: [], },
    { Name: 'Stack', Image: 'Stack.png', Color: 'Blue', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Gain #Block equal to the number of cards in your discard pile| +3].', Traits: [], },
    { Name: 'Steam Barrier', Image: 'SteamBarrier.png', Color: 'Blue', Rarity: 'Common', Type: 'Skill', Cost: 0, Text: "Gain [6|8] #Block. Decrease this card's #Block by 1 this combat.", Traits: [], },
    { Name: 'Streamline', Image: 'Streamline.png', Color: 'Blue', Rarity: 'Common', Type: 'Attack', Cost: 2, Text: "Deal [15|20] damage.\nReduce this card's cost by 1 this combat.", Traits: [], },
    { Name: 'Sweeping Beam', Image: 'SweepingBeam.png', Color: 'Blue', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [6|9] damage to ALL enemies.\nDraw 1 card.', Traits: [], },
    { Name: 'TURBO', Image: 'TURBO.png', Color: 'Blue', Rarity: 'Common', Type: 'Skill', Cost: 0, Text: 'Gain <B> <B>| <B>].\nAdd a #Void into your discard pile.', Traits: [], },
    { Name: 'Aggregate', Image: 'Aggregate.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'Gain <B> for every [4|3] cards in your draw pile.', Traits: [], },
    { Name: 'Auto-Shields', Image: 'Auto-Shields.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'If you have no #Block, gain [11|15] #Block.', Traits: [], },
    { Name: 'Blizzard', Image: 'Blizzard.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: 'Deal damage equal to [2|3] times the number of #Frost #Channeled this combat to ALL enemies.', Traits: [], },
    { Name: 'Boot Sequence', Image: 'BootSequence.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: '#Innate.\nGain [10|13] #Block.\n#Exhaust.', Traits: [], },
    { Name: 'Bullseye', Image: 'Bullseye.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: 'Deal [8|11] damage.\nApply [2|3] #Lock-On.', Traits: [], },
    { Name: 'Capacitor', Image: 'Capacitor.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'Gain [2|3] Orb slots.', Traits: [], },
    { Name: 'Chaos', Image: 'Chaos.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: '#Channel [1|2] random [Orb|Orbs].', Traits: [], },
    { Name: 'Chill', Image: 'Chill.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: '|#Innate.] \n#Channel 1 #Frost for each enemy in combat.\n#Exhaust.', Traits: [], },
    { Name: 'Consume', Image: 'Consume.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 2, Text: 'Gain [2|3] #Focus.\nLose 1 Orb Slot.', Traits: [], },
    { Name: 'Darkness', Image: 'Darkness.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: '#Channel 1 #Dark.|\nTrigger the passive ability of all #Dark orbs.]', Traits: [], },
    { Name: 'Defragment', Image: 'Defragment.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'Gain [1|2] #Focus.', Traits: [], },
    { Name: 'Doom and Gloom', Image: 'DoomandGloom.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Attack', Cost: 2, Text: 'Deal [10|14] damage to ALL enemies.\n#Channel 1 #Dark.', Traits: [], },
    { Name: 'Double Energy', Image: 'DoubleEnergy.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, CostPlus: 0, Text: 'Double your #Energy.\n#Exhaust.', Traits: [], },
    { Name: 'Equilibrium', Image: 'Equilibrium.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 2, Text: 'Gain [13|16] #Block.\n#Retain your hand this turn.', Traits: [], },
    { Name: 'FTL', Image: 'FTL.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Attack', Cost: 0, Text: 'Deal [5|6] damage. If you have played less than [3|4] cards this turn, draw 1 card.', Traits: [], },
    { Name: 'Force Field', Image: 'ForceField.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 4, Text: 'Costs 1 less <B> for each Power card played this combat.\nGain [12|16] #Block.', Traits: [], },
    { Name: 'Fusion', Image: 'Fusion.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 2, CostPlus: 1, Text: '#Channel 1 #Plasma.', Traits: [], },
    { Name: 'Genetic Algorithm', Image: 'GeneticAlgorithm.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: "Gain 1 #Block. Permanently increase this card's #Block by [2|3].\n#Exhaust.", Traits: [], },
    { Name: 'Glacier', Image: 'Glacier.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 2, Text: 'Gain [7|10] #Block.\n#Channel 2 #Frost.', Traits: [], },
    { Name: 'Heatsinks', Image: 'Heatsinks.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'Whenever you play a Power card, draw [1|2] [card|cards].', Traits: [], },
    { Name: 'Hello World', Image: 'HelloWorld.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: '|#Innate.] \nAt the start of your turn, add a random Common card into your hand.', Traits: [], },
    { Name: 'Loop', Image: 'Loop.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'At the start of your turn, trigger the passive ability of your next Orb| [1|2] times].', Traits: [], },
    { Name: 'Melter', Image: 'Melter.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: 'Remove all #Block from the enemy.\nDeal [10|14] damage.', Traits: [], },
    { Name: 'Overclock', Image: 'Overclock.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Draw [2|3] cards.\nAdd a #Burn into your discard pile.', Traits: [], },
    { Name: 'Recycle', Image: 'Recycle.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, CostPlus: 0, Text: '#Exhaust a card.\nGain <B> equal to its cost.', Traits: [], },
    { Name: 'Reinforced Body', Image: 'ReinforcedBody.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 'X', Text: 'Gain [7|9] #Block X times.', Traits: [], },
    { Name: 'Reprogram', Image: 'Reprogram.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'Lose [1|2] focus. Gain [1|2] Strength. Gain [1|2] Dexterity.', Traits: [], },
    { Name: 'Rip and Tear', Image: 'RipandTear.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: 'Deal [7|9] damage to a random enemy twice.', Traits: [], },
    { Name: 'Scrape', Image: 'Scrape.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: 'Deal [7|10] damage.\nDraw [4|5] cards.\nDiscard all cards drawn this way that do not cost 0.', Traits: [], },
    { Name: 'Self Repair', Image: 'SelfRepair.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'At the end of combat, heal [7|10] HP.', Traits: [], },
    { Name: 'Skim', Image: 'Skim.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'Draw [3|4] cards.', Traits: [], },
    { Name: 'Static Discharge', Image: 'StaticDischarge.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'Whenever you receive unblocked attack damage, #Channel [1|2] #Lightning.', Traits: [], },
    { Name: 'Storm', Image: 'Storm.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: '|#Innate.] \nWhenever you play a Power card, #Channel 1 #Lightning.', Traits: [], },
    { Name: 'Sunder', Image: 'Sunder.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Attack', Cost: 3, Text: 'Deal [24|32] damage.\nIf this kills an enemy, gain <B> <B> <B>.', Traits: [], },
    { Name: 'Tempest', Image: 'Tempest.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 'X', Text: '#Channel [X|X+1] #Lightning.\n#Exhaust.', Traits: [], },
    { Name: 'White Noise', Image: 'WhiteNoise.png', Color: 'Blue', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, CostPlus: 0, Text: 'Add a random Power card into your hand.\nIt costs 0 this turn.\n#Exhaust.', Traits: [], },
    { Name: 'All for One', Image: 'AllforOne.png', Color: 'Blue', Rarity: 'Rare', Type: 'Attack', Cost: 2, Text: 'Deal [10|14] damage.\nPut all cost 0 cards from your discard pile into your hand.', Traits: [], },
    { Name: 'Amplify', Image: 'Amplify.png', Color: 'Blue', Rarity: 'Rare', Type: 'Skill', Cost: 1, Text: 'This turn, your next| [1|2]] Power [card is|cards are] played twice.', Traits: [], },
    { Name: 'Biased Cognition', Image: 'BiasedCognition.png', Color: 'Blue', Rarity: 'Rare', Type: 'Power', Cost: 1, Text: 'Gain [4|5] #Focus.\nAt the start of your turn, lose 1 #Focus.', Traits: [], },
    { Name: 'Buffer', Image: 'Buffer.png', Color: 'Blue', Rarity: 'Rare', Type: 'Power', Cost: 2, Text: 'Prevent the next [time|2 times] you would lose HP.', Traits: [], },
    { Name: 'Core Surge', Image: 'CoreSurge.png', Color: 'Blue', Rarity: 'Rare', Type: 'Attack', Cost: 1, Text: 'Deal [11|15] damage.\nGain 1 #Artifact.\n#Exhaust.', Traits: [], },
    { Name: 'Creative AI', Image: 'CreativeAI.png', Color: 'Blue', Rarity: 'Rare', Type: 'Power', Cost: 3, CostPlus: 2, Text: 'At the start of your turn, add a random Power card into your hand.', Traits: [], },
    { Name: 'Echo Form', Image: 'EchoForm.png', Color: 'Blue', Rarity: 'Rare', Type: 'Power', Cost: 3, Text: '[#Ethereal.| \nThe first card you play each turn is played twice.', Traits: [], },
    { Name: 'Electrodynamics', Image: 'Electrodynamics.png', Color: 'Blue', Rarity: 'Rare', Type: 'Power', Cost: 2, Text: '#Lightning now hits ALL enemies.\n#Channel [2|3] #Lightning.', Traits: [], },
    { Name: 'Fission', Image: 'Fission.png', Color: 'Blue', Rarity: 'Rare', Type: 'Skill', Cost: 0, Text: '[Remove|#Evoke] all your Orbs. Gain <B> and draw 1 card for each Orb [removed|#Evoked].\n#Exhaust.', Traits: [], },
    { Name: 'Hyperbeam', Image: 'Hyperbeam.png', Color: 'Blue', Rarity: 'Rare', Type: 'Attack', Cost: 2, Text: 'Deal [26|34] damage to ALL enemies.\nLose 3 #Focus.', Traits: [], },
    { Name: 'Machine Learning', Image: 'MachineLearning.png', Color: 'Blue', Rarity: 'Rare', Type: 'Power', Cost: 1, Text: '|#Innate.] \nAt the start of your turn, draw 1 additional card.', Traits: [], },
    { Name: 'Meteor Strike', Image: 'MeteorStrike.png', Color: 'Blue', Rarity: 'Rare', Type: 'Attack', Cost: 5, Text: 'Deal [24|30] damage.\n#Channel 3 #Plasma.', Traits: [], },
    { Name: 'Multi-Cast', Image: 'Multi-Cast.png', Color: 'Blue', Rarity: 'Rare', Type: 'Skill', Cost: 'X', Text: '#Evoke your next Orb [X|X+1] times.', Traits: [], },
    { Name: 'Rainbow', Image: 'Rainbow.png', Color: 'Blue', Rarity: 'Rare', Type: 'Skill', Cost: 2, Text: '#Channel 1 #Lightning.\n#Channel 1 #Frost.\n#Channel 1 #Dark. [\n#Exhaust.|', Traits: [], },
    { Name: 'Reboot', Image: 'Reboot.png', Color: 'Blue', Rarity: 'Rare', Type: 'Skill', Cost: 0, Text: 'Shuffle ALL your cards into your draw pile.\nDraw [4|6] cards.\n#Exhaust.', Traits: [], },
    { Name: 'Seek', Image: 'Seek.png', Color: 'Blue', Rarity: 'Rare', Type: 'Skill', Cost: 0, Text: 'Put [1|2] [card|cards] from your draw pile into your hand.\n#Exhaust.', Traits: [], },
    { Name: 'Thunder Strike', Image: 'ThunderStrike.png', Color: 'Blue', Rarity: 'Rare', Type: 'Attack', Cost: 3, Text: 'Deal [7|9] damage to a random enemy for each #Lightning #Channeled this combat.', Traits: [], },

    { Name: 'Defend', Image: 'Defend P.png', ID: 'Defend_P', Link: 'Defend (Watcher)', Color: 'Purple', Rarity: 'Basic', Type: 'Skill', Cost: 1, Text: 'Gain [5|8] #Block.',
        Traits: [], },
    { Name: 'Eruption', Image: 'Eruption.png', Color: 'Purple', Rarity: 'Basic', Type: 'Attack', Cost: 2, CostPlus: 1, Text: 'Deal 9 damage. Enter #Wrath.', Traits: [], },
    { Name: 'Strike', Image: 'Strike P.png', ID: 'Strike_P', Link: 'Strike (Watcher)', Color: 'Purple', Rarity: 'Basic', Type: 'Attack', Cost: 1, Text: 'Deal [6|9] damage.',
        Traits: [], },
    { Name: 'Vigilance', Image: 'Vigilance.png', Color: 'Purple', Rarity: 'Basic', Type: 'Skill', Cost: 2, Text: 'Enter #Calm. Gain [8|12] #Block.', Traits: [], },
    { Name: 'Bowling Bash', Image: 'BowlingBash.png', Color: 'Purple', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [7|10] damage for each enemy in combat.', Traits: [], },
    { Name: 'Consecrate', Image: 'Consecrate.png', Color: 'Purple', Rarity: 'Common', Type: 'Attack', Cost: 0, Text: 'Deal [5|8] damage to ALL enemies.', Traits: [], },
    { Name: 'Crescendo', Image: 'Crescendo.png', Color: 'Purple', Rarity: 'Common', Type: 'Skill', Cost: 1, CostPlus: 0, Text: '#Retain. Enter #Wrath. #Exhaust.', Traits: [], },
    { Name: 'Crush Joints', Image: 'CrushJoints.png', Color: 'Purple', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [8|10] damage. If the previous card played was a Skill, apply [1|2] #Vulnerable.', Traits: [], },
    { Name: 'Cut Through Fate', Image: 'CutThroughFate.png', Color: 'Purple', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [7|9] damage. #Scry [2|3]. Draw 1 card.', Traits: [], },
    { Name: 'Empty Body', Image: 'EmptyBody.png', Color: 'Purple', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Gain [7|10] #Block. Exit your #Stance.', Traits: [], },
    { Name: 'Empty Fist', Image: 'EmptyFist.png', Color: 'Purple', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [9|14] damage. Exit your #Stance.', Traits: [], },
    { Name: 'Evaluate', Image: 'Evaluate.png', Color: 'Purple', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Gain [6|10] #Block. Shuffle an #Insight into your draw pile.', Traits: [], },
    { Name: 'Flurry of Blows', Image: 'FlurryOfBlows.png', Color: 'Purple', Rarity: 'Common', Type: 'Attack', Cost: 0, Text: 'Deal [4|6] damage. On #Stance change, returns from the Discard Pile into your hand.', Traits: [], },
    { Name: 'Flying Sleeves', Image: 'FlyingSleeves.png', Color: 'Purple', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: '#Retain. Deal [4|6] damage twice.', Traits: [], },
    { Name: 'Follow-Up', Image: 'Follow-Up.png', Color: 'Purple', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [7|11] damage. If the previous card played was an Attack, gain <P>.', Traits: [], },
    { Name: 'Halt', Image: 'Halt.png', Color: 'Purple', Rarity: 'Common', Type: 'Skill', Cost: 0, Text: 'Gain [3|4] #Block. #Wrath: Gain [9|14] additional #Block.', Traits: [], },
    { Name: 'Just Lucky', Image: 'JustLucky.png', Color: 'Purple', Rarity: 'Common', Type: 'Attack', Cost: 0, Text: '#Scry [1|2]. Gain [2|3] #Block. Deal [3|4] damage.', Traits: [], },
    { Name: 'Pressure Points', Image: 'PressurePoints.png', Color: 'Purple', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Apply [8|11] Mark. ALL enemies lose HP equal to their Mark.', Traits: [], },
    { Name: 'Prostrate', Image: 'Prostrate.png', Color: 'Purple', Rarity: 'Common', Type: 'Skill', Cost: 0, Text: 'Gain [2|3] #Mantra. Gain 4 #Block.', Traits: [], },
    { Name: 'Protect', Image: 'Protect.png', Color: 'Purple', Rarity: 'Common', Type: 'Skill', Cost: 2, Text: '#Retain. Gain [12|16] #Block.', Traits: [], },
    { Name: 'Sash Whip', Image: 'SashWhip.png', Color: 'Purple', Rarity: 'Common', Type: 'Attack', Cost: 1, Text: 'Deal [8|10] damage. If the last card played this combat was an Attack, apply [1|2] #Weak.', Traits: [], },
    { Name: 'Third Eye', Image: 'ThirdEye.png', Color: 'Purple', Rarity: 'Common', Type: 'Skill', Cost: 1, Text: 'Gain [7|9] #Block. #Scry [3|5].', Traits: [], },
    { Name: 'Tranquility', Image: 'Tranquility.png', Color: 'Purple', Rarity: 'Common', Type: 'Skill', Cost: 1, CostPlus: 0, Text: '#Retain. Enter #Calm. #Exhaust.', Traits: [], },
    { Name: 'Battle Hymn', Image: 'BattleHymn.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: '|#Innate. ]At the start of each turn add a #Smite into your hand.', Traits: ['Innate'], },
    { Name: 'Carve Reality', Image: 'CarveReality.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: 'Deal [6|10] damage. Add a #Smite into your hand.', Traits: [], },
    { Name: 'Collect', Image: 'Collect.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Skill', Cost: 'X', Text: 'Put an Upgraded #Miracle into your hand at the start of your next [X|X+1] turns. #Exhaust', Traits: [], },
    { Name: 'Conclude', Image: 'Conclude.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: 'Deal [12|16] damage to ALL enemies. End your turn.', Traits: [], },
    { Name: 'Deceive Reality', Image: 'DeceiveReality.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'Gain [4|7] #Block. Add a #Safety into your hand.', Traits: [], },
    { Name: 'Empty Mind', Image: 'EmptyMind.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'Exit your #Stance. Draw [2|3] cards.', Traits: [], },
    { Name: 'Fasting', Image: 'Fasting.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Power', Cost: 2, Text: 'Gain [3|4] #Strength. \nGain [3|4] #Dexterity. \nGain 1 less <P> at the start of each turn.', Traits: [], },
    { Name: 'Fear No Evil', Image: 'FearNoEvil.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: 'Deal [8|11] damage. If the enemy intends to Attack, enter #Calm.', Traits: [], },
    { Name: 'Foreign Influence', Image: 'ForeignInfluence.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Skill', Cost: 0, Text: 'Choose 1 of 3 Attacks of any color to add to your hand. |It costs 0 this turn.] #Exhaust.', Traits: [], },
    { Name: 'Foresight', Image: 'Foresight.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'At the start of your turn, #Scry [3|4].', Traits: [], },
    { Name: 'Indignation', Image: 'Indignation.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'If you are in #Wrath, apply [3|5] #Vulnerable to ALL enemies, otherwise enter #Wrath.', Traits: [], },
    { Name: 'Inner Peace', Image: 'InnerPeace.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'If you are in #Calm, draw [3|4] cards, otherwise Enter #Calm.', Traits: [], },
    { Name: 'Like Water', Image: 'LikeWater.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'At the end of your turn, if you are in #Calm, gain [5|7] #Block.', Traits: [], },
    { Name: 'Meditate', Image: 'Meditate.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'Put [1 card|2 cards] from your dsicard pile into your hand and #Retain [it|them]. Enter #Calm. End your turn.', Traits: [], },
    { Name: 'Mental Fortress', Image: 'MentalFortress.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'Whenever you switch #Stances, gain [4|6] #Block.', Traits: [], },
    { Name: 'Nirvana', Image: 'Nirvana.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Power', Cost: 1, Text: 'Whenever you #Scry, gain [3|4] #Block.', Traits: [], },
    { Name: 'Perseverance', Image: 'Perseverance.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: '#Retain. Gain [5|7] #Block. Whenever this card is #Retained, increase its #Block by [2|3].', Traits: [], },
    { Name: 'Pray', Image: 'Pray.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'Gain [3|4] #Mantra. Shuffle an #Insight into your draw pile.', Traits: [], },
    { Name: 'Reach Heaven', Image: 'ReachHeaven.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Attack', Cost: 2, Text: 'Deal [10|15] damage. Shuffle a [[Through Violence]] into your draw pile.', Traits: [], },
    { Name: 'Rushdown', Image: 'Rushdown.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Power', Cost: 1, CostPlus: 0, Text: 'Whenever you enter #Wrath, draw 2 cards.', Traits: [], },
    { Name: 'Sanctity', Image: 'Sanctity.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'Gain [6|9] #Block. If the previous card played was a Skill, draw 2 cards.', Traits: [], },
    { Name: 'Sands of Time', Image: 'SandsofTime.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Attack', Cost: 4, Text: '#Retain. Deal [20|26] damage. Whenever this card is #Retained, lower its cost by 1.', Traits: [], },
    { Name: 'Signature Move', Image: 'SignatureMove.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Attack', Cost: 2, Text: 'Can only be played if this is the only attack in your hand. Deal [30|40] damage.', Traits: [], },
    { Name: 'Simmering Fury', Image: 'SimmeringFury.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'At the start of your next turn, enter #Wrath and draw [2|3] cards.', Traits: [], },
    { Name: 'Study', Image: 'Study.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Power', Cost: 2, CostPlus: 1, Text: 'At the end of your turn, shuffle an #Insight into your draw pile.', Traits: [], },
    { Name: 'Swivel', Image: 'Swivel.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Skill', Cost: 2, Text: 'Gain [8|11] #Block. The next Attack you play costs 0.', Traits: [], },
    { Name: 'Talk to the Hand', Image: 'TalktotheHand.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: 'Deal [5|7] damage. Whenever you attack this enemy, gain [2|3] #Block. #Exhaust.', Traits: [], },
    { Name: 'Tantrum', Image: 'Tantrum.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Attack', Cost: 1, Text: 'Deal 3 damage [3|4] times. Enter #Wrath. Shuffle this card into your draw pile.', Traits: [], },
    { Name: 'Wallop', Image: 'Wallop.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Attack', Cost: 2, Text: 'Deal [9|12] damage. Gain #Block equal to unblocked damage dealt.', Traits: [], },
    { Name: 'Wave of the Hand', Image: 'WaveoftheHand.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'Whenever you gain #Block this turn, apply [1|2] #Weak to ALL enemies.', Traits: [], },
    { Name: 'Weave', Image: 'Weave.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Attack', Cost: 0, Text: 'Deal [4|6] damage. Whenever you #Scry, return this from the discard pile to your hand.', Traits: [], },
    { Name: 'Wheel Kick', Image: 'WheelKick.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Attack', Cost: 2, Text: 'Deal [15|20] damage. Draw 2 cards.', Traits: [], },
    { Name: 'Windmill Strike', Image: 'WindmillStrike.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Attack', Cost: 2, Text: '#Retain. Deal [7|10] damage. Whenever this card is #Retained, increase its damage by [4|5].', Traits: [], },
    { Name: 'Worship', Image: 'Worship.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Skill', Cost: 2, Text: '|#Retain. ]Gain 5 #Mantra.', Traits: [], },
    { Name: 'Wreath of Flame', Image: 'WreathofFlame.png', Color: 'Purple', Rarity: 'Uncommon', Type: 'Skill', Cost: 1, Text: 'Your next Attack deals [5|8] additional damage.', Traits: [], },
    { Name: 'Alpha', Image: 'Alpha.png', Color: 'Purple', Rarity: 'Rare', Type: 'Skill', Cost: 1, Text: '|#Innate. ]Shuffle a [[Beta]] into your draw pile. #Exhaust.', Traits: ['Innate'], },
    { Name: 'Blasphemy', Image: 'Blasphemy.png', Color: 'Purple', Rarity: 'Rare', Type: 'Skill', Cost: 1, Text: '|#Retain. ]Enter #Divinity. Die next turn. #Exhaust', Traits: [], },
    { Name: 'Brilliance', Image: 'Brilliance.png', Color: 'Purple', Rarity: 'Rare', Type: 'Attack', Cost: 1, Text: 'Deal [12|16] damage. Deals additional damage equal to #Mantra gained this combat.', Traits: [], },
    { Name: 'Conjure Blade', Image: 'ConjureBlade.png', Color: 'Purple', Rarity: 'Rare', Type: 'Skill', Cost: 'X', Text: 'Shuffle an #Expunger| with X+1] into your draw pile. #Exhaust.', Traits: [], },
    { Name: 'Deus Ex Machina', Image: 'DeusExMachina.png', Color: 'Purple', Rarity: 'Rare', Type: 'Skill', Cost: 'Unplayable', Text: '#Unplayable. When you draw this card, add [2|3] #Miracles into your hand. #Exhaust.', Traits: ['Unplayable', 'Exhaust'], },
    { Name: 'Deva Form', Image: 'DevaForm.png', Color: 'Purple', Rarity: 'Rare', Type: 'Power', Cost: 3, Text: '[#Ethereal. |At the start of your turn, gain <P> and increase this gain by 1.', Traits: ['Ethereal'], },
    { Name: 'Devotion', Image: 'Devotion.png', Color: 'Purple', Rarity: 'Rare', Type: 'Power', Cost: 1, Text: 'At the start of your turn, gain [2|3] #Mantra.', Traits: [], },
    { Name: 'Establishment', Image: 'Establishment.png', Color: 'Purple', Rarity: 'Rare', Type: 'Power', Cost: 1, Text: '|#Innate. ]Whenever a card is #Retained, lower its cost by 1.', Traits: ['Innate'], },
    { Name: 'Judgment', Image: 'Judgment.png', Color: 'Purple', Rarity: 'Rare', Type: 'Skill', Cost: 1, Text: 'If the enemy had [30|40] or less HP, set their HP to 0.', Traits: [], },
    { Name: 'Lesson Learned', Image: 'LessonLearned.png', Color: 'Purple', Rarity: 'Rare', Type: 'Attack', Cost: 2, Text: 'Deal [10|13] damage. If #Fatal, #Upgrade a random card in your deck. #Exhaust.', Traits: [], },
    { Name: 'Master Reality', Image: 'MasterReality.png', Color: 'Purple', Rarity: 'Rare', Type: 'Power', Cost: 1, CostPlus: 0, Text: 'Whenever a card is created during combat, #Upgrade it.', Traits: [], },
    { Name: 'Omniscience', Image: 'Omniscience.png', Color: 'Purple', Rarity: 'Rare', Type: 'Skill', Cost: 4, CostPlus: 3, Text: 'Choose a card in your draw pile. Play the chosen card twice and #Exhaust it. #Exhaust.', Traits: [], },
    { Name: 'Ragnarok', Image: 'Ragnarok.png', Color: 'Purple', Rarity: 'Rare', Type: 'Attack', Cost: 3, Text: 'Deal [5|6] damage to a random enemy [5|6] times.', Traits: [], },
    { Name: 'Scrawl', Image: 'Scrawl.png', Color: 'Purple', Rarity: 'Rare', Type: 'Skill', Cost: 1, CostPlus: 0, Text: 'Draw cards until your hand is full. #Exhaust.', Traits: [], },
    { Name: 'Spirit Shield', Image: 'SpiritShield.png', Color: 'Purple', Rarity: 'Rare', Type: 'Skill', Cost: 2, Text: 'Gain [3|4] #Block for each card in your hand.', Traits: [], },
    { Name: 'Vault', Image: 'Vault.png', Color: 'Purple', Rarity: 'Rare', Type: 'Skill', Cost: 3, CostPlus: 2, Text: 'Take an extra turn after this one. \nEnd your turn. \n#Exhaust.', Traits: [], },
    { Name: 'Wish', Image: 'Wish.png', Color: 'Purple', Rarity: 'Rare', Type: 'Skill', Cost: 3, Text: 'Choose one: Gain [6|8] #Plated Armor, [3|4] #Strength, or [25|30] Gold. #Exhaust.', Traits: [], },
]
