---
description: CushyStudio is packed with features, this page list the major ones
---

# ✨ CushyStudio Features

## First-class ComfyUI support

{% hint style="danger" %}
Insert Image of ComfyUI nodes being displayed within Cushy Here
{% endhint %}

ComfyUI support includes working with Local, Managed, Remote, and Cloud ComfyUI instances. This allows for quick switching between various ComfyUI setups and parallelizing work across multiple instances.

Parallelizing load across multiple ComfyUI instances is made easy with features such as automatically downloading images into your local outputs folder, automatic uploading of missing files, and a powerful image hashing system to avoid duplicate uploads.

CushyStudio also offers native support for ComfyUI workflows in JSON format and images. Simply add them to the action folder to use them seamlessly within CushyStudio, with the option to convert them into actions in a single click.

## Full Large Language Model (LLM) support

{% hint style="danger" %}
Insert Image of LLM being used, along with a list of available models able to be pulled from.
{% endhint %}

Full LLM support includes a built-in prompt-master system prompt for quick experimentation with LLMs. You have the ability to define custom agents and customize all system prompts. The system is open-router based, giving you access to all models, including chatgpt4, claude 2, various unfiltered llama flavors, and more.

## Live painting support&#x20;

{% hint style="danger" %}
Insert a video demonstration of Live painting here
{% endhint %}

Experience the power of real-time creativity with CushyStudio's "Real-time Painting" feature. Harness the artistry of generative AI as you paint and watch your imagination come to life instantly. With our intuitive tools, you can effortlessly craft stunning images that evolve with every brushstroke. Whether you're a seasoned artist or new to generative art, our real-time painting feature empowers you to explore, experiment, and create captivating visuals in the blink of an eye.

## CivitAI integration

{% hint style="danger" %}
Insert image of the CivitAI browser within Cushy here.
{% endhint %}

Explore the convenience of our embedded CivitAI browser, which simplifies the discovery and usage of model references and allows for easy download and integration. Additionally, CushyStudio offers custom ComfyUI nodes for CivitAI, ensuring optimal support for a seamless interactive experience. We also provide dedicated Civitai widgets, allowing your applications to effortlessly select CivitAI models, and integrate them into your creative projects and allowing users to use your exact workflow without having to manually fetch the required assets.

## Built-in fully featured image editor (MiniPaint)

{% hint style="danger" %}
Insert a screenshot of Minipaint's UI within Cushy.
{% endhint %}

CushyStudio has Minipaint built right in. This offers a comprehensive suite of essential tools to modify and touch up your images while never leaving Cushy. With features like layers, effects, masks, blending modes, and more, you have everything you need to fine-tune and transform your images effortlessly. This allows for quick edits and touchups in any workflow. Allowing you the freedom to focus more on your work and spend less time jumping between applications.

## Create your own Apps

{% hint style="danger" %}
Insert a screenshot of sample app code here.
{% endhint %}

CushyStudio simplifies the image and video production process by providing a user-friendly environment. You have the flexibility to create custom prompts in TypeScript, allowing you to take control of your creative workflow. With a strong emphasis on type safety for all values and enums, you can work with confidence. Our integrated standard library expedites the development of your ideal workflow, while the implementation of lambdas offers precise guidance ensuring your nodes generate the necessary values. The production process is incredibly efficient and straightforward, empowering your creative work with ease.
