# Table of contents

* [🛋️ CushyStudio](README.md)

## Getting Started

* [🛠️ Installation](getting-started/installation/README.md)
  * [Installing Cushy](getting-started/installation/windows.md)
  * [Updating Cushy](getting-started/installation/updating-cushy.md)
  * [Scripts](getting-started/installation/scripts.md)
  * [Installing Modules](getting-started/installation/installing-modules/README.md)
    * [Install ComfyUI](getting-started/installation/installing-modules/cloud.md)
    * [Install FFMpeg (optional)](getting-started/installation/installing-modules/install-ffmpeg-optional.md)
    * [Installing Models](getting-started/installation/installing-modules/installing-models.md)
    * [Install ImageMagick (optional)](getting-started/installation/installing-modules/install-imagemagick-optional.md)
* [👋 First Steps](getting-started/getting-started/README.md)
  * [Intro to Generative AI](getting-started/getting-started/intro-to-generative-ai.md)
  * [Making an image](getting-started/getting-started/making-an-image.md)
  * [Coming From...](getting-started/getting-started/coming-from....md)
* [🎁 Built-in apps](getting-started/built-in-apps/README.md)
  * [CushyDiffusion](getting-started/built-in-apps/cushydiffusion.md)
  * [Rotate anything](getting-started/built-in-apps/rotate-anything.md)
  * [Cushy Cascade](getting-started/built-in-apps/cushy-cascade.md)
  * [Remove Background](getting-started/built-in-apps/remove-background.md)
  * [Slay the Spire - Art Pack](getting-started/built-in-apps/slay-the-spire-art-pack.md)
  * [Manga Coloring](getting-started/built-in-apps/manga-coloring.md)
* [🚶 Cushy Interface](getting-started/cushy-interface/README.md)
  * [Draft Panel](getting-started/cushy-interface/draft-panel.md)
  * [Welcome Panel](getting-started/cushy-interface/welcome-panel.md)
  * [Minipaint](getting-started/cushy-interface/minipaint.md)
  * [File Explorer](getting-started/cushy-interface/file-explorer.md)
  * [Quick-Civitai](getting-started/cushy-interface/quick-civitai.md)
  * [Iframes](getting-started/cushy-interface/iframes/README.md)
    * [Minipaint](getting-started/cushy-interface/iframes/minipaint.md)
    * [Civitai](getting-started/cushy-interface/iframes/civitai.md)
  * [Image Comtext menu](getting-started/cushy-interface/image-comtext-menu.md)
* [🍏 Images, Videos, 3d scenes](getting-started/features/README.md)
  * [Quick Actions](getting-started/features/quick-actions.md)
  * [LLM (Large Language Model)](getting-started/features/llm.md)
* [😁 Unified canvas](getting-started/unified-canvas/README.md)
  * [Starin](getting-started/unified-canvas/starin.md)
  * [Inpainting](getting-started/unified-canvas/inpainting.md)
  * [Outpainting](getting-started/unified-canvas/outpainting.md)
* [🧪 Prompting](getting-started/prompting/README.md)
  * [adding Loras](getting-started/prompting/adding-loras.md)

## Going further

* [💡 Creating apps](going-further/creating-apps/README.md)
  * [Creating a new App file](going-further/creating-apps/creating-a-new-app-file.md)
  * [Prefabs](going-further/creating-apps/prefabs.md)
  * [App Structure](going-further/creating-apps/app-structure.md)
  * [Contextual Apps](going-further/creating-apps/contextual-apps.md)
  * [For loops](going-further/creating-apps/for-loops.md)
  * [App UI](going-further/creating-apps/app-ui.md)
  * [Using ImageMagick in your app](going-further/creating-apps/using-imagemagick-in-your-app.md)
* [⚙️ CushyKit](going-further/cushy-sdk.md)
* [🏈 Importing from ComfyUI](going-further/importing-workflows.md)
* [🤝 Woking on Cushy](going-further/contribution/README.md)
  * [Setting up VSCode](going-further/contribution/setting-up-vscode.md)
  * [Contributing on the UI](going-further/contribution/contributing-on-the-ui.md)
  * [Contributing on top-level scripts](going-further/contribution/contributing-on-top-level-scripts.md)
  * [Database](going-further/contribution/database.md)
  * [Migrations](going-further/contribution/migrations.md)
* [🔥 Troubleshooting](going-further/wip-pad/README.md)
  * [Page 1](going-further/wip-pad/page-1.md)

## Community

* [🤝 Community](community/community.md)
* [💬 FAQs](community/faqs/README.md)
  * [⁉️ Can Cushy...](community/faqs/can-cushy....md)
* [📰 News](community/news.md)
* [😁 Changelog](community/changelog.md)
* [🚀 Roadmap](community/roadmap.md)
* [💬 Blog](community/blog/README.md)
  * [2024-02-18 - creating the website](community/blog/2024-02-18-creating-the-website.md)
* [🚂 Other Softwares](community/fast-track/README.md)
  * [Coming from Krita](community/fast-track/coming-from-krita.md)
  * [Coming from A1111](community/fast-track/coming-from-a1111.md)
  * [Coming from ComfyUI](community/fast-track/coming-from-comfyui.md)
  * [Coming from InvokeAI](community/fast-track/coming-from-invokeai.md)
  * [Coming from Fooocus](community/fast-track/coming-from-fooocus.md)
* [Contributing](community/contributing/README.md)
  * [Supporting the team](community/contributing/supporting-the-team.md)
  * [Writing Docs](community/contributing/guidelines.md)

## TEMP

* [✨ CushyStudio Features](temp/cushystudio-features.md)
* [🛋️ TEMPORARY](temp/a-b-testing/README.md)
  * [Manual](temp/a-b-testing/manual.md)
  * [GPT alt A](temp/a-b-testing/gpt-alt-a.md)
  * [GPT alt B](temp/a-b-testing/gpt-alt-b.md)
  * [GPT alt C](temp/a-b-testing/gpt-alt-c.md)
