import classNames from 'classnames'

type Props = {
    activeStep: number,
    completedStep: number,
}

const Steps = (props: Props) => (
    <div>
        <div
            className="after:mt-4 after:block after:h-1 after:w-full after:rounded-lg after:bg-gray-200"
        >
            <ol className="grid grid-cols-4 text-sm font-medium text-gray-500">
                <li className={classNames('relative text-left', { 'text-blue-600': props?.completedStep >= 0 })}>
                    <span
                    className={classNames('absolute left-0 -bottom-[1.75rem] rounded-full text-white', { 'bg-blue-600': props?.completedStep >= 0 }, { 'bg-gray-500': props?.completedStep < 0 })}
                    >
                    <svg
                        className="h-5 w-5"
                        xmlns="http://www.w3.org/2000/svg"
                        viewBox="0 0 20 20"
                        fill="currentColor"
                    >
                        <path
                        fill-rule="evenodd"
                        d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                        clip-rule="evenodd"
                        />
                    </svg>
                    </span>

                    <span className="hidden sm:block"> Welcome </span>

                    <svg
                    className="ml-0 h-6 w-6 sm:hidden"
                    xmlns="http://www.w3.org/2000/svg"
                    fill="none"
                    viewBox="0 0 24 24"
                    stroke="currentColor"
                    stroke-width="2"
                    >
                    <path
                        stroke-linecap="round"
                        stroke-linejoin="round"
                        d="M10 6H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V8a2 2 0 00-2-2h-5m-4 0V5a2 2 0 114 0v1m-4 0a2 2 0 104 0m-5 8a2 2 0 100-4 2 2 0 000 4zm0 0c1.306 0 2.417.835 2.83 2M9 14a3.001 3.001 0 00-2.83 2M15 11h3m-3 4h2"
                    />
                    </svg>
                </li>

                 <li className={classNames('relative text-center', { 'text-blue-600': props?.completedStep >= 1 })}>
                    <span
                        className={classNames('absolute left-1/2 -bottom-[1.75rem] -translate-x-1/2 rounded-full text-white', { 'bg-blue-600': props?.completedStep >= 1 }, { 'bg-gray-500': (props?.completedStep < 1) })}
                    >
                    <svg
                        className="h-5 w-5"
                        xmlns="http://www.w3.org/2000/svg"
                        viewBox="0 0 20 20"
                        fill="currentColor"
                    >
                        <path
                        fill-rule="evenodd"
                        d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                        clip-rule="evenodd"
                        />
                    </svg>
                    </span>

                    <span className="hidden sm:block"> Attendance </span>

                    <svg
                        className="mx-auto h-6 w-6 sm:hidden"
                        xmlns="http://www.w3.org/2000/svg"
                        fill="none"
                        viewBox="0 0 24 24"
                        stroke="currentColor"
                        stroke-width="2"
                    >
                    <path
                        stroke-linecap="round"
                        stroke-linejoin="round"
                        d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"
                    />
                    <path
                        stroke-linecap="round"
                        stroke-linejoin="round"
                        d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"
                    />
                    </svg>
                </li>

                <li className={classNames('relative text-center', { 'text-blue-600': props?.completedStep >= 2 })}>
                    <span
                        className={classNames('absolute left-1/2 -bottom-[1.75rem] -translate-x-1/2 rounded-full text-white', { 'bg-blue-600': props?.completedStep >= 2 }, { 'bg-gray-500': (props?.completedStep < 2) })}
                    >
                    <svg
                        className="h-5 w-5"
                        xmlns="http://www.w3.org/2000/svg"
                        viewBox="0 0 20 20"
                        fill="currentColor"
                    >
                        <path
                        fill-rule="evenodd"
                        d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                        clip-rule="evenodd"
                        />
                    </svg>
                    </span>

                    <span className="hidden sm:block"> Calendar Sync </span>

                    <svg
                        className="mx-auto h-6 w-6 sm:hidden"
                        xmlns="http://www.w3.org/2000/svg"
                        fill="none"
                        viewBox="0 0 24 24"
                        stroke="currentColor"
                        stroke-width="2"
                    >
                    <path
                        stroke-linecap="round"
                        stroke-linejoin="round"
                        d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"
                    />
                    <path
                        stroke-linecap="round"
                        stroke-linejoin="round"
                        d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"
                    />
                    </svg>
                </li>

                <li className={classNames("relative text-right")}>
                    <span className="hidden sm:block"> Time Preference </span>

                    <svg
                    className="ml-auto h-6 w-6 sm:hidden"
                    xmlns="http://www.w3.org/2000/svg"
                    fill="none"
                    viewBox="0 0 24 24"
                    stroke="currentColor"
                    stroke-width="2"
                    >
                    <path
                        stroke-linecap="round"
                        stroke-linejoin="round"
                        d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"
                    />
                    </svg>
                </li>
            </ol>
        </div>
    </div>
)

export default Steps
