import { gql } from "@apollo/client";


export default gql`
query ListCategoriesForUser($userId: uuid!) {
  Category(where: {userId: {_eq: $userId}}) {
    id
    name
    deleted
    createdDate
    updatedAt
    userId
    copyAvailability
    copyTimeBlocking
    copyTimePreference
    copyReminders
    copyPriorityLevel
    copyModifiable
    defaultAvailability
    defaultTimeBlocking
    defaultTimePreference
    defaultReminders
    defaultPriorityLevel
    defaultModifiable
    copyIsBreak
    defaultIsBreak
    color
    copyIsMeeting
    copyIsExternalMeeting
    defaultIsMeeting
    defaultIsExternalMeeting
    defaultMeetingModifiable
    defaultExternalMeetingModifiable
  }
}
`