import { gql } from "@apollo/client";


export default gql`
query listCategoriesForEventId($eventId: String!) {
  Category(where: {Category_Events: {eventId: {_eq: $eventId }}}) {
    id
    name
    deleted
    createdDate
    updatedAt
    userId
    copyAvailability
    copyTimeBlocking
    copyTimePreference
    copyReminders
    copyPriorityLevel
    copyModifiable
    defaultAvailability
    defaultTimeBlocking
    defaultTimePreference
    defaultReminders
    defaultPriorityLevel
    defaultModifiable
    copyIsBreak
    defaultIsBreak
    color
    copyIsMeeting
    copyIsExternalMeeting
    defaultIsMeeting
    defaultIsExternalMeeting
    defaultMeetingModifiable
    defaultExternalMeetingModifiable
  }
}
`;