-- ----------------------------------------
-- RRZCMS MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.7.26
-- Database       : rrzcms
-- 
-- Part : #1
-- Version : #v1.3.4
-- Date : 2021-11-18 17:14:48
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- ----------------------------
-- Table structure for `rrz_admin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin`;
CREATE TABLE `rrz_admin` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(50) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(50) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) unsigned DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) unsigned DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) unsigned DEFAULT '0' COMMENT '同步注册到会员表',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员表';

-- -----------------------------
-- Records of `rrz_admin`
-- -----------------------------
INSERT INTO `rrz_admin` VALUES ('1', 'admin', '', 'admin', '', '', '21232f297a57a5a743894a0e4a801fc3', '/static/images/dfboy.png', '1637219133', '127.0.0.1', '30', '', '0', '1', 'cn', '1', '1', '1586479354', '1588751715');

-- ----------------------------
-- Table structure for `rrz_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_log`;
CREATE TABLE `rrz_admin_log` (
  `id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员日志表';


-- ----------------------------
-- Table structure for `rrz_admin_role`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_role`;
CREATE TABLE `rrz_admin_role` (
  `role_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名称',
  `act_list` text COMMENT '权限列表',
  `role_desc` varchar(255) DEFAULT NULL COMMENT '角色描述',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='用户角色表';

-- -----------------------------
-- Records of `rrz_admin_role`
-- -----------------------------
INSERT INTO `rrz_admin_role` VALUES ('1', '超级管理员', 'all', '管理全站');

-- ----------------------------
-- Table structure for `rrz_article_nodes`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_article_nodes`;
CREATE TABLE `rrz_article_nodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '栏目图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '栏目深度',
  `sort` smallint(6) unsigned DEFAULT '50' COMMENT '排序',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章类目';

-- -----------------------------
-- Records of `rrz_article_nodes`
-- -----------------------------
INSERT INTO `rrz_article_nodes` VALUES ('1', '0', '关于我们', 'about us', 'guanyuwomen', '0', '', '1', '1', '1', '1001', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '关于我们', '', '', '广州某某酒店于2001年成立于广东省广州市，当年的广州市小型初创企业现已发展成为全球规模最大的酒店管理商务公司之一。广州某某酒店隶属于广州酒店集团.（纳斯达克上市公司：GUANGZHOU），我们的使命是：五星服务，探索世界，我们在你身边。<br />\r\n<br />\r\n旗下产品线：<br />\r\n<br />\r\n员工服务自助管理平台系统<br />\r\n广州某某酒店支持43种语言，已有超过2800万房源，其中民宿、公寓和其他特色住宿房源超过620万家。无论你想去哪里，你想做什么，广州某某酒店提供7天24小时全天候客服支持，让一切变得容易。<br />\r\n&nbsp;\r\n<p>\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-191113152Z03E.jpg\" /></p>\r\n<p>\r\n	&nbsp;</p>\r\n员工服务管理系统<br />\r\n&nbsp;\r\n<p>\r\n	广州某某酒店通过投资科技，为数百万用户提供顺畅无阻的难忘旅行体验、一系列交通选择以及各种精彩住宿。从民宿到酒店，应有尽有。无论是成熟品牌还是各种规模的初创企业都能受益于广州某某酒店。作为全球知名酒店平台，广州某某酒店帮助世界各地的住宿吸引全球游客，实现业务增长。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-191113152ZLC.jpg\" /></p>\r\n', '', 'true', '1637205671');
INSERT INTO `rrz_article_nodes` VALUES ('2', '0', '优选房源', 'products', 'youxuanfangyuan', '0', '', '2', '1', '2', '1002', 'image', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '优选房源', '', '', '&nbsp;', '', 'true', '1637205671');
INSERT INTO `rrz_article_nodes` VALUES ('3', '0', '康养酒店', '', 'kangyang', '2', '', '2,3', '2', '1', '10021001', 'image', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '康养酒店', '', '', '&nbsp;', '', 'true', '1637205671');
INSERT INTO `rrz_article_nodes` VALUES ('4', '0', '度假酒店', '', 'dujia', '2', '', '2,4', '2', '2', '10021002', 'image', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '度假酒店', '', '', '&nbsp;', '', 'true', '1637205671');
INSERT INTO `rrz_article_nodes` VALUES ('5', '0', '海景酒店', '', 'haijing', '2', '', '2,5', '2', '3', '10021003', 'image', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '海景酒店', '', '', '&nbsp;', '', 'true', '1637205671');
INSERT INTO `rrz_article_nodes` VALUES ('6', '0', '商务酒店', '', 'shangwu', '2', '', '2,6', '2', '4', '10021004', 'image', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '商务酒店', '', '', '&nbsp;', '', 'true', '1637205671');
INSERT INTO `rrz_article_nodes` VALUES ('7', '0', '新闻动态', 'news', 'xinwendongtai', '0', '', '7', '1', '3', '1003', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '新闻动态', '', '', '&nbsp;', '', 'true', '1637205671');
INSERT INTO `rrz_article_nodes` VALUES ('8', '0', '公司动态', '', 'xinwendongtai/gongsidongtai', '7', '', '7,8', '2', '1', '10031001', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '公司动态', '', '', '', '', 'true', '1637205671');
INSERT INTO `rrz_article_nodes` VALUES ('9', '0', '行业动态', '', 'xinwendongtai/xingyedongtai', '7', '', '7,9', '2', '2', '10031002', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '行业动态', '', '', '', '', 'true', '1637205671');
INSERT INTO `rrz_article_nodes` VALUES ('10', '0', '客房展示', 'case', 'kefangzhanshi', '0', '', '10', '1', '4', '1004', 'image', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '客房展示', '', '', '&nbsp;', '', 'true', '1637205671');
INSERT INTO `rrz_article_nodes` VALUES ('11', '0', '商务双标', '', 'shangwushuangbiao', '10', '', '10,11', '2', '1', '10041001', 'image', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '商务双标', '', '', '&nbsp;', '', 'true', '1637205671');
INSERT INTO `rrz_article_nodes` VALUES ('12', '0', '海景度假', '', 'haijingdujia', '10', '', '10,12', '2', '2', '10041002', 'image', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '海景度假', '', '', '&nbsp;', '', 'true', '1637205671');
INSERT INTO `rrz_article_nodes` VALUES ('13', '0', '五星团队', '', 'wuxingtuandui', '0', '', '13', '1', '5', '1005', 'team', 'team', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '五星团队', '', '', '&nbsp;', '', 'true', '1637205671');
INSERT INTO `rrz_article_nodes` VALUES ('14', '0', '品牌介绍', '', 'pinpaijieshao', '0', '', '14', '1', '6', '1006', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '品牌介绍', '', '', '<p>\r\n	快捷酒店是相对于传统的全面服务酒店而存在的一种酒店业态。其最大的特点是房价便宜，服务模式为“b&amp;b”（住宿+早餐）。最早出现在上个世纪50年代的美国，如今在欧美国家已是相当成熟的酒店形式。快捷酒店的目标市场是一般商务人士、工薪阶层、普通自费旅游者和学生群体等。快捷酒店一般以连锁化的加盟或特许经营模式为主，通过连锁经营达到规模经济，提高品牌价值，这也是快捷酒店区别于其他星级酒店和社会旅馆的一个明显特征。</p>\r\n<div>\r\n	经济型酒店</div>\r\n<div>\r\n	快捷酒店是经济型酒店的一种，经济型酒店的特点是功能简化，把服务功能集中在住宿上，力求在该核心服务上精益求精，而把餐饮、购物、娱乐功能取消，床+早餐是快捷酒店的真实写照，因而快捷酒店投入的运营成本大幅降低。</div>\r\n<div>\r\n	廉价酒店</div>\r\n<div>\r\n	快捷酒店不等于廉价酒店，连锁的品牌的快捷酒店在市场竞争力，知名度，统一化管理，客源等多方面有着明显的优势。因为具有统一的连锁管理体系和标准化的运作方式，快捷酒店的管理水平较高、管理成本低，有效的降低了管理的投入。但是在酒店房价上，快捷酒店的房价高于一般单体酒店，具有更高的盈利水平。</div>\r\n<div>\r\n	<div>\r\n		快捷酒店又称有限服务酒店，最大特点是房价便宜，其服务模式为“住宿和早餐”，以价格低廉、设施简洁、安全、干净和性价比高的酒店模式。在快捷酒店还未兴起时，多数酒店都是以独立经营模式，酒店服务项目多比如餐饮、娱乐、桑拿等，人员配置较多，浪费和占有很多资源，无形中增加了酒店支出成本，使得大部分酒店处在一个长期亏损或收益比较低的情况。而快捷酒店兴起，整合了资源，使得连锁酒店经营具有规模化、组织化、现代化，在总部统一管理下，按照统一的经营方式进行共同的经营活动。</div>\r\n	<div>\r\n		快捷酒店经营模式以控制成本实现竞争优势，采取统一的采购系统、订房系统、批量采购，降低酒店的固定成本投入，具有一定的规模和资金优势，能够更好地控制成本，提高企业知名度，实现竞争优势，达到利润最大化目标。快捷酒店经营模式因设立网点众多而贴近目标市场。统一标识、统一品牌和形象，可以更贴近目标市场，有利于了解宾客需求，制定针对性强的经营战略，最大限度地聚集顾客群。快捷酒店经营模式借助信息资源共享降低运营风险，重要优势是可以通过快捷酒店建设信息、资源共享系统，建立中央预定系统和免费的预定电话，还有网上强大的订房网，各分营店之间可以共享客房数据库和客户信息档案，通过分析客户信息资源了解客户需求，可以有效稳定客源，降低了运营风险。</div>\r\n	<div>\r\n		&nbsp;</div>\r\n</div>\r\n<br />\r\n', '', 'true', '1637205671');
INSERT INTO `rrz_article_nodes` VALUES ('15', '0', '联系我们', '', 'lianxiwomen', '0', '', '15', '1', '7', '1007', 'single', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '联系我们', '', '', '<p>\r\n	广州某某酒店有限公司</p>\r\n<p>\r\n	集酒店、餐饮、旅游于一身的高服务企业。服务范围涵盖了餐饮、酒店住宿、旅游等全方位业务。</p>\r\n<p>\r\n	地址：广州市番禺经济开发区88号</p>\r\n<p>\r\n	业务部：020-88888888</p>\r\n<p>\r\n	技术部：020- 99999999</p>\r\n<p>\r\n	邮箱：baidu@baidu.com</p>\r\n<p>\r\n	网址：www.baidu.com</p>\r\n<p>\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-210616144233951.jpg\" /></p>\r\n', '', 'true', '1637205671');

-- ----------------------------
-- Table structure for `rrz_articles`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_articles`;
CREATE TABLE `rrz_articles` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `node_id` mediumint(8) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '文章标题',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `img` varchar(255) NOT NULL DEFAULT '' COMMENT '文章配图',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `author` varchar(100) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `uptime` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  `pubtime` int(10) unsigned DEFAULT '0' COMMENT '文章发布时间',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '发布',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '文章创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `source` varchar(100) NOT NULL DEFAULT '' COMMENT '来源',
  `source_url` varchar(255) NOT NULL DEFAULT '' COMMENT '来源URL',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_node_id` (`node_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章';

-- -----------------------------
-- Records of `rrz_articles`
-- -----------------------------
INSERT INTO `rrz_articles` VALUES ('1', '3', '优选酒店九', '', '/storage/images/20211118/1-1911131R2080-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131R2080-L.jpg\" style=\"width: 290px; height: 218px;\" /></div>\r\n<p>\r\n	<span style=\"text-align: center;\">一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客提供住宿服务、亦生活的服务及设施（寝前服务）、餐饮、游戏、娱乐、购物、商务中心、宴会及会议等设施。</span></p>\r\n', '', 'admin', '', '1573640541', '1573640541', 'true', '', '一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客', '优选,酒店,九,一般地说,来就,是给,宾客,提供,', '178', '1623832729', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('2', '3', '优选酒店八', '', '/storage/images/20211118/1-1911131R2320-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131R2320-L.jpg\" style=\"width: 500px; height: 333px;\" /></div>\r\n<span style=\"text-align: center;\">一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客提供住宿服务、亦生活的服务及设施（寝前服务）、餐饮、游戏、娱乐、购物、商务中心、宴会及会议等设施。</span>', '', 'admin', '', '1573640561', '1573640561', 'true', '', '一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客', '优选,酒店,八,一般地说,来就,是给,宾客,提供,', '59', '1623832699', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('3', '3', '优选酒店九', '', '/storage/images/20211118/1-1911131R2080-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131R2080-L.jpg\" style=\"width: 290px; height: 218px;\" /></div>\r\n<p>\r\n	<span style=\"text-align: center;\">一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客提供住宿服务、亦生活的服务及设施（寝前服务）、餐饮、游戏、娱乐、购物、商务中心、宴会及会议等设施。</span></p>\r\n', '', 'admin', '', '1573640541', '1573640541', 'true', '', '一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客', '优选,酒店,九,一般地说,来就,是给,宾客,提供,', '179', '1623832729', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('4', '3', '优选酒店八', '', '/storage/images/20211118/1-1911131R2320-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131R2320-L.jpg\" style=\"width: 500px; height: 333px;\" /></div>\r\n<span style=\"text-align: center;\">一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客提供住宿服务、亦生活的服务及设施（寝前服务）、餐饮、游戏、娱乐、购物、商务中心、宴会及会议等设施。</span>', '', 'admin', '', '1573640561', '1573640561', 'true', '', '一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客', '优选,酒店,八,一般地说,来就,是给,宾客,提供,', '53', '1623832699', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('5', '3', '优选酒店九', '', '/storage/images/20211118/1-1911131R2080-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131R2080-L.jpg\" style=\"width: 290px; height: 218px;\" /></div>\r\n<p>\r\n	<span style=\"text-align: center;\">一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客提供住宿服务、亦生活的服务及设施（寝前服务）、餐饮、游戏、娱乐、购物、商务中心、宴会及会议等设施。</span></p>\r\n', '', 'admin', '', '1573640541', '1573640541', 'true', '', '一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客', '优选,酒店,九,一般地说,来就,是给,宾客,提供,', '179', '1623832729', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('6', '3', '优选酒店八', '', '/storage/images/20211118/1-1911131R2320-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131R2320-L.jpg\" style=\"width: 500px; height: 333px;\" /></div>\r\n<span style=\"text-align: center;\">一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客提供住宿服务、亦生活的服务及设施（寝前服务）、餐饮、游戏、娱乐、购物、商务中心、宴会及会议等设施。</span>', '', 'admin', '', '1573640561', '1573640561', 'true', '', '一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客', '优选,酒店,八,一般地说,来就,是给,宾客,提供,', '53', '1623832699', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('7', '3', '优选酒店九', '', '/storage/images/20211118/1-1911131R2080-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131R2080-L.jpg\" style=\"width: 290px; height: 218px;\" /></div>\r\n<p>\r\n	<span style=\"text-align: center;\">一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客提供住宿服务、亦生活的服务及设施（寝前服务）、餐饮、游戏、娱乐、购物、商务中心、宴会及会议等设施。</span></p>\r\n', '', 'admin', '', '1573640541', '1573640541', 'true', '', '一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客', '优选,酒店,九,一般地说,来就,是给,宾客,提供,', '179', '1623832729', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('8', '3', '优选酒店八', '', '/storage/images/20211118/1-1911131R2320-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131R2320-L.jpg\" style=\"width: 500px; height: 333px;\" /></div>\r\n<span style=\"text-align: center;\">一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客提供住宿服务、亦生活的服务及设施（寝前服务）、餐饮、游戏、娱乐、购物、商务中心、宴会及会议等设施。</span>', '', 'admin', '', '1573640561', '1573640561', 'true', '', '一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客', '优选,酒店,八,一般地说,来就,是给,宾客,提供,', '53', '1623832699', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('9', '3', '优选酒店九', '', '/storage/images/20211118/1-1911131R2080-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131R2080-L.jpg\" style=\"width: 290px; height: 218px;\" /></div>\r\n<p>\r\n	<span style=\"text-align: center;\">一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客提供住宿服务、亦生活的服务及设施（寝前服务）、餐饮、游戏、娱乐、购物、商务中心、宴会及会议等设施。</span></p>\r\n', '', 'admin', '', '1573640541', '1573640541', 'true', '', '一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客', '优选,酒店,九,一般地说,来就,是给,宾客,提供,', '179', '1623832729', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('10', '3', '优选酒店八', '', '/storage/images/20211118/1-1911131R2320-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131R2320-L.jpg\" style=\"width: 500px; height: 333px;\" /></div>\r\n<span style=\"text-align: center;\">一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客提供住宿服务、亦生活的服务及设施（寝前服务）、餐饮、游戏、娱乐、购物、商务中心、宴会及会议等设施。</span>', '', 'admin', '', '1573640561', '1573640561', 'true', '', '一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客', '优选,酒店,八,一般地说,来就,是给,宾客,提供,', '53', '1623832699', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('11', '4', '优选酒店三', '', '/storage/images/20211118/1-1911131R5290-L.jpg', '', '<p style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131R5290-L.jpg\" style=\"width: 500px; height: 333px;\" /><br />\r\n	一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客提供住宿服务、亦生活的服务及设施（寝前服务）、餐饮、游戏、娱乐、购物、商务中心、宴会及会议等设施。</p>\r\n', '', 'admin', '', '1573640738', '1573640738', 'true', '', '一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客', '优选,酒店,三,一般地说,来就,是给,宾客,提供,', '120', '1623832550', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('12', '4', '优选酒店二', '', '/storage/images/20211118/1-1911131R6060-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131R6060-L.jpg\" style=\"width: 500px; height: 333px;\" /><br />\r\n	一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客提供住宿服务、亦生活的服务及设施（寝前服务）、餐饮、游戏、娱乐、购物、商务中心、宴会及会议等设施。</div>\r\n', '', 'admin', '', '1573640774', '1573640774', 'true', '', '一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客', '优选,酒店,二,一般地说,来就,是给,宾客,提供,', '142', '1623832518', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('13', '4', '优选酒店一', '', '/storage/images/20211118/1-1911131RJ60-L.jpg', '', '<div style=\"text-align: center;\">\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131RJ60-L.jpg\" /><br />\r\n	一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客提供住宿服务、亦生活的服务及设施（寝前服务）、餐饮、游戏、娱乐、购物、商务中心、宴会及会议等设施。</div>\r\n', '', 'admin', '', '1573640875', '1573640875', 'true', '', '一般地说来就是给宾客提供歇宿和饮食的场所。具体地说饭店是以它的建筑物为凭证，通过出售客房、餐饮及综合服务设施向客人提供服务，从而获得经济收益的组织。酒店主要为游客', '优选,酒店,一,', '106', '1623832414', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('14', '8', '雅高CEO：疫情中的酒店投资低价潮尚未来临', '', '/storage/images/20211118/1-1911131I00X11.png', '', '<p>\r\n	全球大型酒店企业并没有成功应对疫情危机。但他们仍然想宣传一种观念，即在全球网络中比作为独立运营商更有价值。小型运营商需要接受这一观念，才能抓住夏季旅游旺季的机会。</p>\r\n<p>\r\n	　　很多投资者认为经济危机不是一次好的机会，但在2008年，很多企业都会在这期间逢低买入。</p>\r\n<p>\r\n	　　疫情期间也会这样，但目前并没有出现酒店投资者热切期待的廉价定价浪潮。以酒店为目标的投资基金几乎每周都会宣布交易，黑石和喜达屋资本等主要投资公司也都在酒店业进行交易。</p>\r\n<p>\r\n	　　一些大型酒店企业的CEO称还需等待时机。</p>\r\n<p>\r\n	　　雅高CEO Sebastien Bazin与大多数酒店高管和行业分析师一样，他指出，在疫情期间，各国政府采取了多种形式的救济措施，并提高贷款的灵活度，这使得大多数酒店在疫情最严重时得以生存。</p>\r\n<p>\r\n	　　预计全球旅行市场将在今年夏季旺季得到明显改善，届时各国政府也将逐渐结束救济措施，未来几个月，酒店的入住率可能会超过2019年的水平。在中国市场，万豪和华住等公司在今年某些月份的商务旅行入住率已经高于2019年。</p>\r\n<p>\r\n	　　但并非每家酒店都如此。全球主要城市的酒店市场恢复水平继续落后于休闲目的地。Bazin估计，这些潜在的增长机会可能需要六到九个月的时间才能出现。</p>\r\n<p>\r\n	　　酒店业预计，大部分增长将趋向于更大的全球公司，如雅高、凯悦或IHG等。</p>\r\n<p>\r\n	　　IHG CEO Keith Barr称随着时间的推移，会有较小规模的酒店企业进行某种程度的整合。</p>\r\n<p>\r\n	　　Lodging Econometrics在5月报告称，万豪、希尔顿和IHG这三大全球品牌占美国在建酒店数量近70%。这种趋势很可能会延续到其他国家或地区，因为一些品牌都希望继续进入不重视品牌建设的市场。</p>\r\n<p>\r\n	　　很多酒店业务的增长源于转换，即现有酒店业主转换品牌隶属关系或首次签订品牌协议的交易。疫情期间，所有主要酒店公司的CEO都将转换视为业务增长的主要来源，而新建酒店的建设融资明显比正常情况紧张。</p>\r\n<p>\r\n	　　考虑到有多少酒店公司计划专注于转换，人们可能认为转换的成功是有限的。有些人可能认为转换不可避免地成为一场零和游戏，但凯悦认为未来还有很多跑道。</p>\r\n<p>\r\n	　　凯悦CEO Mark Hoplamazian表示很多转换来自规模较小的品牌和在过去一年中度过了艰难时期的独立酒店，而非大公司，他称这也是转换活动如此频繁的部分原因。</p>\r\n<p>\r\n	　　Hoplamazian补充说，凯悦去年四分之一的净客房增长来自转换，而且这种速度一直持续到今年。去年IHG的360酒店四分之一的签约也是转换，而雅高去年开业酒店的40%来自转换。</p>\r\n<p>\r\n	　　雅高去年亏损24亿美元，因为其投资组合中对欧洲的敞口很大。凯悦损失了7.03亿美元，洲际酒店集团损失了1.53亿美元。</p>\r\n<p>\r\n	　　但是，随着陷入困境的运营商希望利用更大品牌的一些好处，如全球分销平台、客户意识和忠诚度计划，这些公司和许多其他公司都预计今年的转化率可能会上升。</p>\r\n', '', 'admin', '', '1573637418', '1573637418', 'true', '', '全球大型酒店企业并没有成功应对疫情危机。但他们仍然想宣传一种观念，即在全球网络中比作为独立运营商更有价值。小型运营商需要接受这一观念，才能抓住夏季旅游旺季的机会。', '雅高,CEO,疫情,中的,酒店,投资,低价,潮,尚未,', '90', '1623828575', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('15', '8', 'G7峰会接待酒店暴发新冠疫情已关闭', '', '/storage/images/20211118/1-1911131I15T95.jpg', '', '<p>\r\n	据英媒10日报道，英国康沃尔郡圣艾夫斯一家酒店暴发新冠疫情，目前酒店处于完全关闭状态。报道称，该酒店内入住了G7峰会的安保和媒体工作人员。</p>\r\n<p>\r\n	　　据报道，13名酒店工作人员确诊感染。一位即将自行隔离的工作人员告诉英国天空电视台，该酒店“已经关闭”。报道称，该酒店距离G7峰会的举办地点卡比斯湾仅1英里(约合1.6公里)。</p>\r\n<p>\r\n	　　另外，住在该酒店的德国代表团安保人员称，他们此前“没有被告知任何事”，之后可能会买一顶帐篷睡在沙滩上。</p>\r\n<p>\r\n	　　报道称，该酒店所有者发布声明称，“我们可以确认，我们在圣艾夫斯Pedn Olva酒店的团队，有人新冠检测为阳性。”该公司表示，已经通知了英格兰公共卫生署，一旦彻底完成清洁工作，酒店将重新开放。</p>\r\n', '', 'admin', '', '1573637527', '1573637527', 'true', '', '据英媒10日报道，英国康沃尔郡圣艾夫斯一家酒店暴发新冠疫情，目前酒店处于完全关闭状态。报道称，该酒店内入住了G7峰会的安保和媒体工作人员。 据报道，13名酒店工作人员确诊感', '峰会,接待,酒店,暴发,新冠,疫情,已,关闭,据,', '103', '1623828546', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('16', '8', '雅高CEO：疫情中的酒店投资低价潮尚未来临', '', '/storage/images/20211118/1-1911131I00X11.png', '', '<p>\r\n	全球大型酒店企业并没有成功应对疫情危机。但他们仍然想宣传一种观念，即在全球网络中比作为独立运营商更有价值。小型运营商需要接受这一观念，才能抓住夏季旅游旺季的机会。</p>\r\n<p>\r\n	　　很多投资者认为经济危机不是一次好的机会，但在2008年，很多企业都会在这期间逢低买入。</p>\r\n<p>\r\n	　　疫情期间也会这样，但目前并没有出现酒店投资者热切期待的廉价定价浪潮。以酒店为目标的投资基金几乎每周都会宣布交易，黑石和喜达屋资本等主要投资公司也都在酒店业进行交易。</p>\r\n<p>\r\n	　　一些大型酒店企业的CEO称还需等待时机。</p>\r\n<p>\r\n	　　雅高CEO Sebastien Bazin与大多数酒店高管和行业分析师一样，他指出，在疫情期间，各国政府采取了多种形式的救济措施，并提高贷款的灵活度，这使得大多数酒店在疫情最严重时得以生存。</p>\r\n<p>\r\n	　　预计全球旅行市场将在今年夏季旺季得到明显改善，届时各国政府也将逐渐结束救济措施，未来几个月，酒店的入住率可能会超过2019年的水平。在中国市场，万豪和华住等公司在今年某些月份的商务旅行入住率已经高于2019年。</p>\r\n<p>\r\n	　　但并非每家酒店都如此。全球主要城市的酒店市场恢复水平继续落后于休闲目的地。Bazin估计，这些潜在的增长机会可能需要六到九个月的时间才能出现。</p>\r\n<p>\r\n	　　酒店业预计，大部分增长将趋向于更大的全球公司，如雅高、凯悦或IHG等。</p>\r\n<p>\r\n	　　IHG CEO Keith Barr称随着时间的推移，会有较小规模的酒店企业进行某种程度的整合。</p>\r\n<p>\r\n	　　Lodging Econometrics在5月报告称，万豪、希尔顿和IHG这三大全球品牌占美国在建酒店数量近70%。这种趋势很可能会延续到其他国家或地区，因为一些品牌都希望继续进入不重视品牌建设的市场。</p>\r\n<p>\r\n	　　很多酒店业务的增长源于转换，即现有酒店业主转换品牌隶属关系或首次签订品牌协议的交易。疫情期间，所有主要酒店公司的CEO都将转换视为业务增长的主要来源，而新建酒店的建设融资明显比正常情况紧张。</p>\r\n<p>\r\n	　　考虑到有多少酒店公司计划专注于转换，人们可能认为转换的成功是有限的。有些人可能认为转换不可避免地成为一场零和游戏，但凯悦认为未来还有很多跑道。</p>\r\n<p>\r\n	　　凯悦CEO Mark Hoplamazian表示很多转换来自规模较小的品牌和在过去一年中度过了艰难时期的独立酒店，而非大公司，他称这也是转换活动如此频繁的部分原因。</p>\r\n<p>\r\n	　　Hoplamazian补充说，凯悦去年四分之一的净客房增长来自转换，而且这种速度一直持续到今年。去年IHG的360酒店四分之一的签约也是转换，而雅高去年开业酒店的40%来自转换。</p>\r\n<p>\r\n	　　雅高去年亏损24亿美元，因为其投资组合中对欧洲的敞口很大。凯悦损失了7.03亿美元，洲际酒店集团损失了1.53亿美元。</p>\r\n<p>\r\n	　　但是，随着陷入困境的运营商希望利用更大品牌的一些好处，如全球分销平台、客户意识和忠诚度计划，这些公司和许多其他公司都预计今年的转化率可能会上升。</p>\r\n', '', 'admin', '', '1573637418', '1573637418', 'true', '', '全球大型酒店企业并没有成功应对疫情危机。但他们仍然想宣传一种观念，即在全球网络中比作为独立运营商更有价值。小型运营商需要接受这一观念，才能抓住夏季旅游旺季的机会。', '雅高,CEO,疫情,中的,酒店,投资,低价,潮,尚未,', '90', '1623828575', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('17', '8', 'G7峰会接待酒店暴发新冠疫情已关闭', '', '/storage/images/20211118/1-1911131I15T95.jpg', '', '<p>\r\n	据英媒10日报道，英国康沃尔郡圣艾夫斯一家酒店暴发新冠疫情，目前酒店处于完全关闭状态。报道称，该酒店内入住了G7峰会的安保和媒体工作人员。</p>\r\n<p>\r\n	　　据报道，13名酒店工作人员确诊感染。一位即将自行隔离的工作人员告诉英国天空电视台，该酒店“已经关闭”。报道称，该酒店距离G7峰会的举办地点卡比斯湾仅1英里(约合1.6公里)。</p>\r\n<p>\r\n	　　另外，住在该酒店的德国代表团安保人员称，他们此前“没有被告知任何事”，之后可能会买一顶帐篷睡在沙滩上。</p>\r\n<p>\r\n	　　报道称，该酒店所有者发布声明称，“我们可以确认，我们在圣艾夫斯Pedn Olva酒店的团队，有人新冠检测为阳性。”该公司表示，已经通知了英格兰公共卫生署，一旦彻底完成清洁工作，酒店将重新开放。</p>\r\n', '', 'admin', '', '1573637527', '1573637527', 'true', '', '据英媒10日报道，英国康沃尔郡圣艾夫斯一家酒店暴发新冠疫情，目前酒店处于完全关闭状态。报道称，该酒店内入住了G7峰会的安保和媒体工作人员。 据报道，13名酒店工作人员确诊感', '峰会,接待,酒店,暴发,新冠,疫情,已,关闭,据,', '103', '1623828546', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('18', '8', '雅高CEO：疫情中的酒店投资低价潮尚未来临', '', '/storage/images/20211118/1-1911131I00X11.png', '', '<p>\r\n	全球大型酒店企业并没有成功应对疫情危机。但他们仍然想宣传一种观念，即在全球网络中比作为独立运营商更有价值。小型运营商需要接受这一观念，才能抓住夏季旅游旺季的机会。</p>\r\n<p>\r\n	　　很多投资者认为经济危机不是一次好的机会，但在2008年，很多企业都会在这期间逢低买入。</p>\r\n<p>\r\n	　　疫情期间也会这样，但目前并没有出现酒店投资者热切期待的廉价定价浪潮。以酒店为目标的投资基金几乎每周都会宣布交易，黑石和喜达屋资本等主要投资公司也都在酒店业进行交易。</p>\r\n<p>\r\n	　　一些大型酒店企业的CEO称还需等待时机。</p>\r\n<p>\r\n	　　雅高CEO Sebastien Bazin与大多数酒店高管和行业分析师一样，他指出，在疫情期间，各国政府采取了多种形式的救济措施，并提高贷款的灵活度，这使得大多数酒店在疫情最严重时得以生存。</p>\r\n<p>\r\n	　　预计全球旅行市场将在今年夏季旺季得到明显改善，届时各国政府也将逐渐结束救济措施，未来几个月，酒店的入住率可能会超过2019年的水平。在中国市场，万豪和华住等公司在今年某些月份的商务旅行入住率已经高于2019年。</p>\r\n<p>\r\n	　　但并非每家酒店都如此。全球主要城市的酒店市场恢复水平继续落后于休闲目的地。Bazin估计，这些潜在的增长机会可能需要六到九个月的时间才能出现。</p>\r\n<p>\r\n	　　酒店业预计，大部分增长将趋向于更大的全球公司，如雅高、凯悦或IHG等。</p>\r\n<p>\r\n	　　IHG CEO Keith Barr称随着时间的推移，会有较小规模的酒店企业进行某种程度的整合。</p>\r\n<p>\r\n	　　Lodging Econometrics在5月报告称，万豪、希尔顿和IHG这三大全球品牌占美国在建酒店数量近70%。这种趋势很可能会延续到其他国家或地区，因为一些品牌都希望继续进入不重视品牌建设的市场。</p>\r\n<p>\r\n	　　很多酒店业务的增长源于转换，即现有酒店业主转换品牌隶属关系或首次签订品牌协议的交易。疫情期间，所有主要酒店公司的CEO都将转换视为业务增长的主要来源，而新建酒店的建设融资明显比正常情况紧张。</p>\r\n<p>\r\n	　　考虑到有多少酒店公司计划专注于转换，人们可能认为转换的成功是有限的。有些人可能认为转换不可避免地成为一场零和游戏，但凯悦认为未来还有很多跑道。</p>\r\n<p>\r\n	　　凯悦CEO Mark Hoplamazian表示很多转换来自规模较小的品牌和在过去一年中度过了艰难时期的独立酒店，而非大公司，他称这也是转换活动如此频繁的部分原因。</p>\r\n<p>\r\n	　　Hoplamazian补充说，凯悦去年四分之一的净客房增长来自转换，而且这种速度一直持续到今年。去年IHG的360酒店四分之一的签约也是转换，而雅高去年开业酒店的40%来自转换。</p>\r\n<p>\r\n	　　雅高去年亏损24亿美元，因为其投资组合中对欧洲的敞口很大。凯悦损失了7.03亿美元，洲际酒店集团损失了1.53亿美元。</p>\r\n<p>\r\n	　　但是，随着陷入困境的运营商希望利用更大品牌的一些好处，如全球分销平台、客户意识和忠诚度计划，这些公司和许多其他公司都预计今年的转化率可能会上升。</p>\r\n', '', 'admin', '', '1573637418', '1573637418', 'true', '', '全球大型酒店企业并没有成功应对疫情危机。但他们仍然想宣传一种观念，即在全球网络中比作为独立运营商更有价值。小型运营商需要接受这一观念，才能抓住夏季旅游旺季的机会。', '雅高,CEO,疫情,中的,酒店,投资,低价,潮,尚未,', '90', '1623828575', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('19', '8', 'G7峰会接待酒店暴发新冠疫情已关闭', '', '/storage/images/20211118/1-1911131I15T95.jpg', '', '<p>\r\n	据英媒10日报道，英国康沃尔郡圣艾夫斯一家酒店暴发新冠疫情，目前酒店处于完全关闭状态。报道称，该酒店内入住了G7峰会的安保和媒体工作人员。</p>\r\n<p>\r\n	　　据报道，13名酒店工作人员确诊感染。一位即将自行隔离的工作人员告诉英国天空电视台，该酒店“已经关闭”。报道称，该酒店距离G7峰会的举办地点卡比斯湾仅1英里(约合1.6公里)。</p>\r\n<p>\r\n	　　另外，住在该酒店的德国代表团安保人员称，他们此前“没有被告知任何事”，之后可能会买一顶帐篷睡在沙滩上。</p>\r\n<p>\r\n	　　报道称，该酒店所有者发布声明称，“我们可以确认，我们在圣艾夫斯Pedn Olva酒店的团队，有人新冠检测为阳性。”该公司表示，已经通知了英格兰公共卫生署，一旦彻底完成清洁工作，酒店将重新开放。</p>\r\n', '', 'admin', '', '1573637527', '1573637527', 'true', '', '据英媒10日报道，英国康沃尔郡圣艾夫斯一家酒店暴发新冠疫情，目前酒店处于完全关闭状态。报道称，该酒店内入住了G7峰会的安保和媒体工作人员。 据报道，13名酒店工作人员确诊感', '峰会,接待,酒店,暴发,新冠,疫情,已,关闭,据,', '103', '1623828546', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('20', '8', '雅高CEO：疫情中的酒店投资低价潮尚未来临', '', '/storage/images/20211118/1-1911131I00X11.png', '', '<p>\r\n	全球大型酒店企业并没有成功应对疫情危机。但他们仍然想宣传一种观念，即在全球网络中比作为独立运营商更有价值。小型运营商需要接受这一观念，才能抓住夏季旅游旺季的机会。</p>\r\n<p>\r\n	　　很多投资者认为经济危机不是一次好的机会，但在2008年，很多企业都会在这期间逢低买入。</p>\r\n<p>\r\n	　　疫情期间也会这样，但目前并没有出现酒店投资者热切期待的廉价定价浪潮。以酒店为目标的投资基金几乎每周都会宣布交易，黑石和喜达屋资本等主要投资公司也都在酒店业进行交易。</p>\r\n<p>\r\n	　　一些大型酒店企业的CEO称还需等待时机。</p>\r\n<p>\r\n	　　雅高CEO Sebastien Bazin与大多数酒店高管和行业分析师一样，他指出，在疫情期间，各国政府采取了多种形式的救济措施，并提高贷款的灵活度，这使得大多数酒店在疫情最严重时得以生存。</p>\r\n<p>\r\n	　　预计全球旅行市场将在今年夏季旺季得到明显改善，届时各国政府也将逐渐结束救济措施，未来几个月，酒店的入住率可能会超过2019年的水平。在中国市场，万豪和华住等公司在今年某些月份的商务旅行入住率已经高于2019年。</p>\r\n<p>\r\n	　　但并非每家酒店都如此。全球主要城市的酒店市场恢复水平继续落后于休闲目的地。Bazin估计，这些潜在的增长机会可能需要六到九个月的时间才能出现。</p>\r\n<p>\r\n	　　酒店业预计，大部分增长将趋向于更大的全球公司，如雅高、凯悦或IHG等。</p>\r\n<p>\r\n	　　IHG CEO Keith Barr称随着时间的推移，会有较小规模的酒店企业进行某种程度的整合。</p>\r\n<p>\r\n	　　Lodging Econometrics在5月报告称，万豪、希尔顿和IHG这三大全球品牌占美国在建酒店数量近70%。这种趋势很可能会延续到其他国家或地区，因为一些品牌都希望继续进入不重视品牌建设的市场。</p>\r\n<p>\r\n	　　很多酒店业务的增长源于转换，即现有酒店业主转换品牌隶属关系或首次签订品牌协议的交易。疫情期间，所有主要酒店公司的CEO都将转换视为业务增长的主要来源，而新建酒店的建设融资明显比正常情况紧张。</p>\r\n<p>\r\n	　　考虑到有多少酒店公司计划专注于转换，人们可能认为转换的成功是有限的。有些人可能认为转换不可避免地成为一场零和游戏，但凯悦认为未来还有很多跑道。</p>\r\n<p>\r\n	　　凯悦CEO Mark Hoplamazian表示很多转换来自规模较小的品牌和在过去一年中度过了艰难时期的独立酒店，而非大公司，他称这也是转换活动如此频繁的部分原因。</p>\r\n<p>\r\n	　　Hoplamazian补充说，凯悦去年四分之一的净客房增长来自转换，而且这种速度一直持续到今年。去年IHG的360酒店四分之一的签约也是转换，而雅高去年开业酒店的40%来自转换。</p>\r\n<p>\r\n	　　雅高去年亏损24亿美元，因为其投资组合中对欧洲的敞口很大。凯悦损失了7.03亿美元，洲际酒店集团损失了1.53亿美元。</p>\r\n<p>\r\n	　　但是，随着陷入困境的运营商希望利用更大品牌的一些好处，如全球分销平台、客户意识和忠诚度计划，这些公司和许多其他公司都预计今年的转化率可能会上升。</p>\r\n', '', 'admin', '', '1573637418', '1573637418', 'true', '', '全球大型酒店企业并没有成功应对疫情危机。但他们仍然想宣传一种观念，即在全球网络中比作为独立运营商更有价值。小型运营商需要接受这一观念，才能抓住夏季旅游旺季的机会。', '雅高,CEO,疫情,中的,酒店,投资,低价,潮,尚未,', '90', '1623828575', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('21', '8', 'G7峰会接待酒店暴发新冠疫情已关闭', '', '/storage/images/20211118/1-1911131I15T95.jpg', '', '<p>\r\n	据英媒10日报道，英国康沃尔郡圣艾夫斯一家酒店暴发新冠疫情，目前酒店处于完全关闭状态。报道称，该酒店内入住了G7峰会的安保和媒体工作人员。</p>\r\n<p>\r\n	　　据报道，13名酒店工作人员确诊感染。一位即将自行隔离的工作人员告诉英国天空电视台，该酒店“已经关闭”。报道称，该酒店距离G7峰会的举办地点卡比斯湾仅1英里(约合1.6公里)。</p>\r\n<p>\r\n	　　另外，住在该酒店的德国代表团安保人员称，他们此前“没有被告知任何事”，之后可能会买一顶帐篷睡在沙滩上。</p>\r\n<p>\r\n	　　报道称，该酒店所有者发布声明称，“我们可以确认，我们在圣艾夫斯Pedn Olva酒店的团队，有人新冠检测为阳性。”该公司表示，已经通知了英格兰公共卫生署，一旦彻底完成清洁工作，酒店将重新开放。</p>\r\n', '', 'admin', '', '1573637527', '1573637527', 'true', '', '据英媒10日报道，英国康沃尔郡圣艾夫斯一家酒店暴发新冠疫情，目前酒店处于完全关闭状态。报道称，该酒店内入住了G7峰会的安保和媒体工作人员。 据报道，13名酒店工作人员确诊感', '峰会,接待,酒店,暴发,新冠,疫情,已,关闭,据,', '103', '1623828546', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('22', '8', '雅高CEO：疫情中的酒店投资低价潮尚未来临', '', '/storage/images/20211118/1-1911131I00X11.png', '', '<p>\r\n	全球大型酒店企业并没有成功应对疫情危机。但他们仍然想宣传一种观念，即在全球网络中比作为独立运营商更有价值。小型运营商需要接受这一观念，才能抓住夏季旅游旺季的机会。</p>\r\n<p>\r\n	　　很多投资者认为经济危机不是一次好的机会，但在2008年，很多企业都会在这期间逢低买入。</p>\r\n<p>\r\n	　　疫情期间也会这样，但目前并没有出现酒店投资者热切期待的廉价定价浪潮。以酒店为目标的投资基金几乎每周都会宣布交易，黑石和喜达屋资本等主要投资公司也都在酒店业进行交易。</p>\r\n<p>\r\n	　　一些大型酒店企业的CEO称还需等待时机。</p>\r\n<p>\r\n	　　雅高CEO Sebastien Bazin与大多数酒店高管和行业分析师一样，他指出，在疫情期间，各国政府采取了多种形式的救济措施，并提高贷款的灵活度，这使得大多数酒店在疫情最严重时得以生存。</p>\r\n<p>\r\n	　　预计全球旅行市场将在今年夏季旺季得到明显改善，届时各国政府也将逐渐结束救济措施，未来几个月，酒店的入住率可能会超过2019年的水平。在中国市场，万豪和华住等公司在今年某些月份的商务旅行入住率已经高于2019年。</p>\r\n<p>\r\n	　　但并非每家酒店都如此。全球主要城市的酒店市场恢复水平继续落后于休闲目的地。Bazin估计，这些潜在的增长机会可能需要六到九个月的时间才能出现。</p>\r\n<p>\r\n	　　酒店业预计，大部分增长将趋向于更大的全球公司，如雅高、凯悦或IHG等。</p>\r\n<p>\r\n	　　IHG CEO Keith Barr称随着时间的推移，会有较小规模的酒店企业进行某种程度的整合。</p>\r\n<p>\r\n	　　Lodging Econometrics在5月报告称，万豪、希尔顿和IHG这三大全球品牌占美国在建酒店数量近70%。这种趋势很可能会延续到其他国家或地区，因为一些品牌都希望继续进入不重视品牌建设的市场。</p>\r\n<p>\r\n	　　很多酒店业务的增长源于转换，即现有酒店业主转换品牌隶属关系或首次签订品牌协议的交易。疫情期间，所有主要酒店公司的CEO都将转换视为业务增长的主要来源，而新建酒店的建设融资明显比正常情况紧张。</p>\r\n<p>\r\n	　　考虑到有多少酒店公司计划专注于转换，人们可能认为转换的成功是有限的。有些人可能认为转换不可避免地成为一场零和游戏，但凯悦认为未来还有很多跑道。</p>\r\n<p>\r\n	　　凯悦CEO Mark Hoplamazian表示很多转换来自规模较小的品牌和在过去一年中度过了艰难时期的独立酒店，而非大公司，他称这也是转换活动如此频繁的部分原因。</p>\r\n<p>\r\n	　　Hoplamazian补充说，凯悦去年四分之一的净客房增长来自转换，而且这种速度一直持续到今年。去年IHG的360酒店四分之一的签约也是转换，而雅高去年开业酒店的40%来自转换。</p>\r\n<p>\r\n	　　雅高去年亏损24亿美元，因为其投资组合中对欧洲的敞口很大。凯悦损失了7.03亿美元，洲际酒店集团损失了1.53亿美元。</p>\r\n<p>\r\n	　　但是，随着陷入困境的运营商希望利用更大品牌的一些好处，如全球分销平台、客户意识和忠诚度计划，这些公司和许多其他公司都预计今年的转化率可能会上升。</p>\r\n', '', 'admin', '', '1573637418', '1573637418', 'true', '', '全球大型酒店企业并没有成功应对疫情危机。但他们仍然想宣传一种观念，即在全球网络中比作为独立运营商更有价值。小型运营商需要接受这一观念，才能抓住夏季旅游旺季的机会。', '雅高,CEO,疫情,中的,酒店,投资,低价,潮,尚未,', '90', '1623828575', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('23', '8', 'G7峰会接待酒店暴发新冠疫情已关闭', '', '/storage/images/20211118/1-1911131I15T95.jpg', '', '<p>\r\n	据英媒10日报道，英国康沃尔郡圣艾夫斯一家酒店暴发新冠疫情，目前酒店处于完全关闭状态。报道称，该酒店内入住了G7峰会的安保和媒体工作人员。</p>\r\n<p>\r\n	　　据报道，13名酒店工作人员确诊感染。一位即将自行隔离的工作人员告诉英国天空电视台，该酒店“已经关闭”。报道称，该酒店距离G7峰会的举办地点卡比斯湾仅1英里(约合1.6公里)。</p>\r\n<p>\r\n	　　另外，住在该酒店的德国代表团安保人员称，他们此前“没有被告知任何事”，之后可能会买一顶帐篷睡在沙滩上。</p>\r\n<p>\r\n	　　报道称，该酒店所有者发布声明称，“我们可以确认，我们在圣艾夫斯Pedn Olva酒店的团队，有人新冠检测为阳性。”该公司表示，已经通知了英格兰公共卫生署，一旦彻底完成清洁工作，酒店将重新开放。</p>\r\n', '', 'admin', '', '1573637527', '1573637527', 'true', '', '据英媒10日报道，英国康沃尔郡圣艾夫斯一家酒店暴发新冠疫情，目前酒店处于完全关闭状态。报道称，该酒店内入住了G7峰会的安保和媒体工作人员。 据报道，13名酒店工作人员确诊感', '峰会,接待,酒店,暴发,新冠,疫情,已,关闭,据,', '104', '1623828546', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('24', '11', '酒店客房一', '', '/storage/images/20211118/1-1911131K5490-L.jpg', '', '<div style=\"text-align: center;\">\r\n	Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。<br />\r\n	<br />\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131K5490-L.jpg\" /></div>\r\n', '', 'admin', '', '1573638990', '1573638990', 'true', '', 'Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。', '酒店,客房,一,Mr.,Soof,TLV2GO,提供,带,阳', '98', '1623830507', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('25', '11', '酒店客房二', '', '/storage/images/20211118/1-1911131K6370-L.jpg', '', '<div style=\"text-align: center;\">\r\n	Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。<br />\r\n	<br />\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131K6370-L.jpg\" /></div>\r\n', '', 'admin', '', '1573639010', '1573639010', 'true', '', 'Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。', '酒店,客房,二,Mr.,Soof,TLV2GO,提供,带,阳', '176', '1623830401', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('26', '11', '酒店客房一', '', '/storage/images/20211118/1-1911131K5490-L.jpg', '', '<div style=\"text-align: center;\">\r\n	Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。<br />\r\n	<br />\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131K5490-L.jpg\" /></div>\r\n', '', 'admin', '', '1573638990', '1573638990', 'true', '', 'Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。', '酒店,客房,一,Mr.,Soof,TLV2GO,提供,带,阳', '98', '1623830507', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('27', '11', '酒店客房二', '', '/storage/images/20211118/1-1911131K6370-L.jpg', '', '<div style=\"text-align: center;\">\r\n	Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。<br />\r\n	<br />\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131K6370-L.jpg\" /></div>\r\n', '', 'admin', '', '1573639010', '1573639010', 'true', '', 'Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。', '酒店,客房,二,Mr.,Soof,TLV2GO,提供,带,阳', '176', '1623830401', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('28', '11', '酒店客房一', '', '/storage/images/20211118/1-1911131K5490-L.jpg', '', '<div style=\"text-align: center;\">\r\n	Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。<br />\r\n	<br />\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131K5490-L.jpg\" /></div>\r\n', '', 'admin', '', '1573638990', '1573638990', 'true', '', 'Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。', '酒店,客房,一,Mr.,Soof,TLV2GO,提供,带,阳', '98', '1623830507', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('29', '11', '酒店客房二', '', '/storage/images/20211118/1-1911131K6370-L.jpg', '', '<div style=\"text-align: center;\">\r\n	Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。<br />\r\n	<br />\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131K6370-L.jpg\" /></div>\r\n', '', 'admin', '', '1573639010', '1573639010', 'true', '', 'Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。', '酒店,客房,二,Mr.,Soof,TLV2GO,提供,带,阳', '176', '1623830401', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('30', '11', '酒店客房一', '', '/storage/images/20211118/1-1911131K5490-L.jpg', '', '<div style=\"text-align: center;\">\r\n	Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。<br />\r\n	<br />\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131K5490-L.jpg\" /></div>\r\n', '', 'admin', '', '1573638990', '1573638990', 'true', '', 'Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。', '酒店,客房,一,Mr.,Soof,TLV2GO,提供,带,阳', '98', '1623830507', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('31', '11', '酒店客房二', '', '/storage/images/20211118/1-1911131K6370-L.jpg', '', '<div style=\"text-align: center;\">\r\n	Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。<br />\r\n	<br />\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131K6370-L.jpg\" /></div>\r\n', '', 'admin', '', '1573639010', '1573639010', 'true', '', 'Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。', '酒店,客房,二,Mr.,Soof,TLV2GO,提供,带,阳', '176', '1623830401', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('32', '11', '酒店客房一', '', '/storage/images/20211118/1-1911131K5490-L.jpg', '', '<div style=\"text-align: center;\">\r\n	Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。<br />\r\n	<br />\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131K5490-L.jpg\" /></div>\r\n', '', 'admin', '', '1573638990', '1573638990', 'true', '', 'Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。', '酒店,客房,一,Mr.,Soof,TLV2GO,提供,带,阳', '98', '1623830507', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('33', '11', '酒店客房二', '', '/storage/images/20211118/1-1911131K6370-L.jpg', '', '<div style=\"text-align: center;\">\r\n	Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。<br />\r\n	<br />\r\n	<img alt=\"\" src=\"/storage/images/20211118/1-1911131K6370-L.jpg\" /></div>\r\n', '', 'admin', '', '1573639010', '1573639010', 'true', '', 'Mr. Soof - By TLV2GO提供带阳台和免费WiFi的空调住宿，距离Neviot Beach有18分钟步行路程。', '酒店,客房,二,Mr.,Soof,TLV2GO,提供,带,阳', '176', '1623830401', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('34', '13', 'Lafei拉菲', '客房经理', '/storage/images/20211118/1-1911131646070-L.jpg', '', '1941年9月13日出生，出生于日本大阪。<br />\r\n1957年左右，开始练习职业拳击。<br />\r\n1959～1961年，考察日本传统建筑。<br />\r\n1962～1969年，游学于美国、欧洲和非洲。<br />\r\n1969年，创办“安藤忠雄建筑研究所”（Tadao Ando Architecture&amp;Associates）。<br />\r\n1969年在大阪成立安藤忠雄建筑研究所，设计了许多个人住宅。其中位在大阪的“住吉的长屋（住吉の长屋）”获得很高的评价。<br />\r\n1980年代在关西周边（特别是神户?北野町、大阪心斋桥一带）设计了许多商业设施、寺庙、教会等。<br />\r\n1987年 - 担任耶鲁大学的客座教授。<br />\r\n1988年 - 担任哥伦比亚大学的客座教授。<br />\r\n1990年代之后公共建筑、美术馆，及海外的建筑设计案开始增加。<br />\r\n1989年 - 担任哈佛大学的客座教授。<br />\r\n1995年 - 获得普利兹克建筑奖。<br />\r\n1997年 - 执教于日本东京大学建筑系，并担任东京大学工学部教授。<br />\r\n1997年 - 2003年 - 从东京大学退休，转任名誉教授。<br />\r\n2005年 - 获得东京大学的终身特别荣誉教授。<br />\r\n2011年 - 担任东南大学的客座教授。', '', 'admin', '', '1573634781', '1573634781', 'true', '', '1941年9月13日出生，出生于日本大阪。 1957年左右，开始练习职业拳击。 1959～1961年，考察日本传统建筑。 1962～1969年，游学于美国、欧洲和非洲。 1969年，创办安藤忠雄建筑研究所（Ta', 'Lafei,拉菲,1941年,9月,13日,出生,出生于,日', '62', '1623827410', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('35', '13', '迈克-鲁斯', '客房服务员', '/storage/images/20211118/1-191113164F10-L.jpg', '', '1941年9月13日出生，出生于日本大阪。<br />\r\n1957年左右，开始练习职业拳击。<br />\r\n1959～1961年，考察日本传统建筑。<br />\r\n1962～1969年，游学于美国、欧洲和非洲。<br />\r\n1969年，创办“安藤忠雄建筑研究所”（Tadao Ando Architecture&amp;Associates）。<br />\r\n1969年在大阪成立安藤忠雄建筑研究所，设计了许多个人住宅。其中位在大阪的“住吉的长屋（住吉の长屋）”获得很高的评价。<br />\r\n1980年代在关西周边（特别是神户?北野町、大阪心斋桥一带）设计了许多商业设施、寺庙、教会等。<br />\r\n1987年 - 担任耶鲁大学的客座教授。<br />\r\n1988年 - 担任哥伦比亚大学的客座教授。<br />\r\n1990年代之后公共建筑、美术馆，及海外的建筑设计案开始增加。<br />\r\n1989年 - 担任哈佛大学的客座教授。<br />\r\n1995年 - 获得普利兹克建筑奖。<br />\r\n1997年 - 执教于日本东京大学建筑系，并担任东京大学工学部教授。<br />\r\n1997年 - 2003年 - 从东京大学退休，转任名誉教授。<br />\r\n2005年 - 获得东京大学的终身特别荣誉教授。<br />\r\n2011年 - 担任东南大学的客座教授。', '', 'admin', '', '1573634830', '1573634830', 'true', '', '1941年9月13日出生，出生于日本大阪。 1957年左右，开始练习职业拳击。 1959～1961年，考察日本传统建筑。 1962～1969年，游学于美国、欧洲和非洲。 1969年，创办安藤忠雄建筑研究所（Ta', '迈克,鲁斯,1941年,9月,13日,出生,出生于,日本,', '66', '1623827395', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('36', '13', 'David Elas Mjuni', '前台经理', '/storage/images/20211118/1-191113164H50-L.jpg', '', '1941年9月13日出生，出生于日本大阪。<br />\r\n1957年左右，开始练习职业拳击。<br />\r\n1959～1961年，考察日本传统建筑。<br />\r\n1962～1969年，游学于美国、欧洲和非洲。<br />\r\n1969年，创办“安藤忠雄建筑研究所”（Tadao Ando Architecture&amp;Associates）。<br />\r\n1969年在大阪成立安藤忠雄建筑研究所，设计了许多个人住宅。其中位在大阪的“住吉的长屋（住吉の长屋）”获得很高的评价。<br />\r\n1980年代在关西周边（特别是神户?北野町、大阪心斋桥一带）设计了许多商业设施、寺庙、教会等。<br />\r\n1987年 - 担任耶鲁大学的客座教授。<br />\r\n1988年 - 担任哥伦比亚大学的客座教授。<br />\r\n1990年代之后公共建筑、美术馆，及海外的建筑设计案开始增加。<br />\r\n1989年 - 担任哈佛大学的客座教授。<br />\r\n1995年 - 获得普利兹克建筑奖。<br />\r\n1997年 - 执教于日本东京大学建筑系，并担任东京大学工学部教授。<br />\r\n1997年 - 2003年 - 从东京大学退休，转任名誉教授。<br />\r\n2005年 - 获得东京大学的终身特别荣誉教授。<br />\r\n2011年 - 担任东南大学的客座教授。', '', 'admin', '', '1573634854', '1573634854', 'true', '', '1941年9月13日出生，出生于日本大阪。 1957年左右，开始练习职业拳击。 1959～1961年，考察日本传统建筑。 1962～1969年，游学于美国、欧洲和非洲。 1969年，创办安藤忠雄建筑研究所（Ta', 'David,Elas,Mjuni,1941年,9月,13日,', '92', '1623827382', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('37', '13', 'Dame Yucca', '前台领班', '/storage/images/20211118/1-191113164J80-L.jpg', '', '1941年9月13日出生，出生于日本大阪。<br />\r\n1957年左右，开始练习职业拳击。<br />\r\n1959～1961年，考察日本传统建筑。<br />\r\n1962～1969年，游学于美国、欧洲和非洲。<br />\r\n1969年，创办“安藤忠雄建筑研究所”（Tadao Ando Architecture&amp;Associates）。<br />\r\n1969年在大阪成立安藤忠雄建筑研究所，设计了许多个人住宅。其中位在大阪的“住吉的长屋（住吉の长屋）”获得很高的评价。<br />\r\n1980年代在关西周边（特别是神户?北野町、大阪心斋桥一带）设计了许多商业设施、寺庙、教会等。<br />\r\n1987年 - 担任耶鲁大学的客座教授。<br />\r\n1988年 - 担任哥伦比亚大学的客座教授。<br />\r\n1990年代之后公共建筑、美术馆，及海外的建筑设计案开始增加。<br />\r\n1989年 - 担任哈佛大学的客座教授。<br />\r\n1995年 - 获得普利兹克建筑奖。<br />\r\n1997年 - 执教于日本东京大学建筑系，并担任东京大学工学部教授。<br />\r\n1997年 - 2003年 - 从东京大学退休，转任名誉教授。<br />\r\n2005年 - 获得东京大学的终身特别荣誉教授。<br />\r\n2011年 - 担任东南大学的客座教授。', '', 'admin', '', '1573634880', '1573634880', 'true', '', '1941年9月13日出生，出生于日本大阪。 1957年左右，开始练习职业拳击。 1959～1961年，考察日本传统建筑。 1962～1969年，游学于美国、欧洲和非洲。 1969年，创办安藤忠雄建筑研究所（Ta', 'Dame,Yucca,1941年,9月,13日,出生,出生于', '121', '1623827364', '0', '0', '0', '100', '未知', '');

-- ----------------------------
-- Table structure for `rrz_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channelfield`;
CREATE TABLE `rrz_channelfield` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `channel_type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` longtext COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `ifrequire` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否必填',
  `sort` int(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='自定义字段表';


-- ----------------------------
-- Table structure for `rrz_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channeltype`;
CREATE TABLE `rrz_channeltype` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文章（产品）类型';


-- ----------------------------
-- Table structure for `rrz_config`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_config`;
CREATE TABLE `rrz_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置内容',
  `type` varchar(64) DEFAULT '' COMMENT '类型',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除（0：否，1：是）',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_name` (`name`) USING BTREE,
  KEY `idx_type` (`type`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统配置表';

-- -----------------------------
-- Records of `rrz_config`
-- -----------------------------
INSERT INTO `rrz_config` VALUES ('1', 'status', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('2', 'name', '某某网络科技有限公司', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('3', 'logo', '/storage/images/20211118/c31eedde56325304db2925543135d7b3.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('4', 'wap_logo', '/storage/images/20211118/c31eedde56325304db2925543135d7b3.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('5', 'favicon', '/storage/images/20200509/9e9ffe4e859c185d063363237637f296.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('6', 'copyright', 'Copyright © 2012-2018 某某公司 版权所有', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('7', 'recordnum', '琼ICP备xxxxxxxx号', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('8', 'title', '响应式酒店民宿住宿类网站人人站模板(自适应手机端)', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('9', 'keywords', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('10', 'description', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('11', 'is_authorization', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('12', 'authortoken_code', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('13', 'popup_upgrade', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('14', 'wap_domain', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('15', 'is_https', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('16', 'logo', '/static/images/logo.png', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('17', 'sqldatapath', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('18', 'expiretime', '3600', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('19', 'name', '广州某某公司', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('20', 'telephone', '400-123-4567', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('21', 'fax', '020-99999999', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('22', 'qq', '88888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('23', 'email', 'admin@youweb.com', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('24', 'addr', '广东省广州市天河区88号', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('25', 'coord', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('26', 'thirdcode_pc', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('27', 'thirdcode_wap', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('28', 'inlet', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('29', 'auto', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('30', 'filter_isurl', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('31', 'type', 'xml', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('32', 'index_changefreq', 'always', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('33', 'list_changefreq', 'hourly', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('34', 'view_changefreq', 'daily', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('35', 'index_priority', '1.0', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('36', 'list_priority', '0.8', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('37', 'view_priority', '0.5', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('38', 'articles_num', '100', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('39', 'zzbaidutoken', '', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('40', 'app_map', 'admin', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('41', 'status', '1', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('42', 'replace', '国家级|国际级|世界级|宇宙级|千万级|百万级|星级|甲级|超甲级|完美|唯一|一流|精确|顶级|顶尖|尖端|最|国际级产品|填补国内空白|带头|首个|首次|首发|首款|首家|首选|品牌|正品|金牌|名牌|优秀|顶级|独家|唯独|独有|独创|独据|开发者|缔造者|创始|发明者|领先|领头|领导|领跑|领袖|领先|引领|创领|领航|权威|先进|耀领|缔造者|极品|极佳|顶级|尖端|顶尖|终极|绝佳|绝对|绝版|终极|极致|极具|王牌|冠军|第一|极致|永久|王牌|掌门人|领袖|独一无二|绝无仅有|前无古人|史无前例|万能|绝对|绝顶|大牌|精确|超赚|巨星|至尊|巅峰|之王|巨星|王者|冠军|资深|至尊|著名|奢侈|百分之百|国家级产品|国家免检|国家领导人|填补国内空白|史无前例|前无古人|永久|永远|万能|祖传|特效|无敌|纯天然|超赚|国际品质|专家推荐|超强|全面|全网|全球|随时结束|仅此一次|空前绝后|随时涨价|马上降价|最后一波|包治百病|药到病除|特供|专供|专家推荐|热销|畅销|全效|标杆|精确|优秀|仅此|遥遥|高档|真皮|超赚|精准|指定|精品|特供|专供|军方|军事|国旗|国徽|党旗|驰名|秒杀|一步到位|', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('43', 'connector_title', '_', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('44', 'list_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('45', 'view_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('46', 'mobile', '138-0000-0000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('47', 'wx', 'WX8888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('48', 'qrcode', '/storage/images/20211118/3d3c79997f9d46cb571688c78e82bfb8.png', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('49', 'nav_hide_suffix', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('50', 'url_level_dir', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('51', 'app_debug', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('52', 'hide_plugin', '0', 'admin', '', 'cn', '0');

-- ----------------------------
-- Table structure for `rrz_form_data`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_form_data`;
CREATE TABLE `rrz_form_data` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `form_id` int(10) unsigned DEFAULT '0' COMMENT '表单ID',
  `form_name` varchar(255) DEFAULT '' COMMENT '表单名称',
  `content` longtext COMMENT '提交内容',
  `ip` varchar(255) DEFAULT '' COMMENT '提交人IP',
  `add_time` int(10) unsigned DEFAULT NULL COMMENT '提交时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_forms`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_forms`;
CREATE TABLE `rrz_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `config` longtext COMMENT '表单配置',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '创建时间',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '删除(0=否，1=是)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_is_del` (`is_del`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_goods`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods`;
CREATE TABLE `rrz_goods` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '产品名称',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `brief` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '商品简介',
  `cat_id` mediumint(8) unsigned DEFAULT NULL COMMENT '产品分类id',
  `brand_id` int(10) unsigned DEFAULT '0' COMMENT '产品品牌id',
  `def_img` varchar(500) DEFAULT '' COMMENT '产品默认图片路径',
  `imgs` longtext COMMENT '产品图片集合',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `del_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品划线价格',
  `store` int(8) unsigned DEFAULT '0' COMMENT '产品库存',
  `is_presell` enum('true','false') DEFAULT 'false' COMMENT '是否预售（是否定金付款）',
  `presell_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '预售价格（定金）',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '产品规格',
  `content` longtext COMMENT '产品详情',
  `wap_content` longtext COMMENT '手机端详情',
  `sales` int(11) unsigned DEFAULT '0' COMMENT '产品销量',
  `addtime` int(11) unsigned DEFAULT '0' COMMENT '创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_news` tinyint(1) unsigned DEFAULT '0' COMMENT '新品（0=否，1=是）',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '上架',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_cat_id` (`cat_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_is_news` (`is_news`) USING BTREE,
  KEY `idx_brand_id` (`brand_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品管理';


-- ----------------------------
-- Table structure for `rrz_goods_attr`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attr`;
CREATE TABLE `rrz_goods_attr` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品属性id自增',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `attr_value` text COMMENT '属性值',
  `attr_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `goods_id` (`goods_id`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性关联表';


-- ----------------------------
-- Table structure for `rrz_goods_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attribute`;
CREATE TABLE `rrz_goods_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '类型（0 单行文本框 1下拉式列表 2多行文本框）',
  `values` text COMMENT '属性值集合',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性';


-- ----------------------------
-- Table structure for `rrz_goods_brand`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_brand`;
CREATE TABLE `rrz_goods_brand` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '品牌表',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌名称',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌logo',
  `desc` text COMMENT '备注介绍',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌地址',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品品牌';


-- ----------------------------
-- Table structure for `rrz_goods_cat`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_cat`;
CREATE TABLE `rrz_goods_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) DEFAULT '' COMMENT '分类名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '分类英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '分类图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '节点深度',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分类排序',
  `path` varchar(255) DEFAULT '' COMMENT '节点路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `attrs` longtext COMMENT '参数列表',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品分类';


-- ----------------------------
-- Table structure for `rrz_goods_skus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_skus`;
CREATE TABLE `rrz_goods_skus` (
  `sku_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品规格id',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '规格明细',
  PRIMARY KEY (`sku_id`) USING BTREE,
  KEY `idx_goods_id` (`goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品规格详情';


-- ----------------------------
-- Table structure for `rrz_goods_spec_values`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_spec_values`;
CREATE TABLE `rrz_goods_spec_values` (
  `spec_value_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规格值ID',
  `spec_id` bigint(15) unsigned NOT NULL DEFAULT '0' COMMENT '规格ID',
  `spec_value` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值',
  PRIMARY KEY (`spec_value_id`) USING BTREE,
  KEY `idx_spec_id` (`spec_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格值';


-- ----------------------------
-- Table structure for `rrz_goods_specification`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_specification`;
CREATE TABLE `rrz_goods_specification` (
  `spec_id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `spec_name` varchar(50) DEFAULT NULL COMMENT '规格名',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序顺序',
  PRIMARY KEY (`spec_id`) USING BTREE,
  KEY `idx_sort` (`sort`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格表';


-- ----------------------------
-- Table structure for `rrz_plugin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_plugin`;
CREATE TABLE `rrz_plugin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL DEFAULT '' COMMENT '编码',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `desc` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `version` varchar(20) NOT NULL DEFAULT '' COMMENT '版本号',
  `author` varchar(30) NOT NULL DEFAULT '' COMMENT '作者',
  `isadmin` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否存在后台（0否1是）',
  `ishome` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否存在前台（0否1是）',
  `isload` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否自动加载（0手动加载、1自动加载）',
  `loadtemp` text COMMENT '自动加载在指定模板，空白默认全部',
  `config` text COMMENT '额外参数',
  `data` text COMMENT '配置存储数据，简单插件可以不创建表',
  `saflag` varchar(500) DEFAULT NULL COMMENT '标示内容',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态（0未安装、1启用、2禁用）',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='插件表';


-- ----------------------------
-- Table structure for `rrz_search_keywords`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_search_keywords`;
CREATE TABLE `rrz_search_keywords` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `keywords` text COMMENT '关键词',
  `type` varchar(50) DEFAULT 'article' COMMENT '搜索类型',
  `ip` varchar(100) DEFAULT NULL COMMENT '搜索客户端的ip地址',
  `hot` int(10) unsigned DEFAULT '0' COMMENT '关键词搜索量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '搜索时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_hot` (`hot`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_site_links`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_links`;
CREATE TABLE `rrz_site_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `url` varchar(255) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) unsigned DEFAULT '0' COMMENT '是否新窗口打开',
  `email` varchar(50) DEFAULT '',
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='友情链接表';

-- -----------------------------
-- Records of `rrz_site_links`
-- -----------------------------
INSERT INTO `rrz_site_links` VALUES ('1', '企业建站系统', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481203', '1627543172');
INSERT INTO `rrz_site_links` VALUES ('2', '淘进微信', 'http://taobao.kbstore.cn/', 'http://taobao.kbstore.cn/Public/images/logo-1.png', '100', '1', '', '', '1', 'cn', '1590481246', '1627543144');
INSERT INTO `rrz_site_links` VALUES ('3', '人人站CMS', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481266', '1627543178');
INSERT INTO `rrz_site_links` VALUES ('4', '抖进微信', 'http://dou.kbstore.cn/', 'http://dou.kbstore.cn/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1621244482', '1627543197');

-- ----------------------------
-- Table structure for `rrz_site_menus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_menus`;
CREATE TABLE `rrz_site_menus` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `en_title` varchar(100) NOT NULL DEFAULT '' COMMENT '英文标题',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级菜单',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '菜单深度',
  `url` varchar(200) DEFAULT '' COMMENT '自定义链接',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `path` varchar(100) NOT NULL DEFAULT '' COMMENT '上下级路径',
  `target_blank` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '是否新开窗口',
  `config` longtext COMMENT '配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='导航菜单表';

-- -----------------------------
-- Records of `rrz_site_menus`
-- -----------------------------
INSERT INTO `rrz_site_menus` VALUES ('1', '首页', 'Home', 'index', '0', '1', '1', '/', '1', '1001', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('2', '关于我们', 'about us', 'guanyuwomen', '0', '2', '1', '/node/1.html', '2', '1002', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('3', '优选房源', 'products', 'youxuanfangyuan', '0', '3', '1', '/node/2.html', '3', '1003', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('4', '新闻动态', 'news', 'xinwendongtai', '0', '4', '1', '/node/7.html', '4', '1004', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('5', '客房展示', 'case', 'kefangzhanshi', '0', '5', '1', '/node/10.html', '5', '1005', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('6', '五星团队', '', 'wuxingtuandui', '0', '6', '1', '/node/13.html', '6', '1006', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('7', '品牌介绍', '', 'pinpaijieshao', '0', '7', '1', '/node/14.html', '7', '1007', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('8', '联系我们', '', 'lianxiwomen', '0', '8', '1', '/node/15.html', '8', '1008', 'false', '');
