<?php
/**
 * 人人站CMS
 * ============================================================================
 * 版权所有 2015-2030 山东康程信息科技有限公司，并保留所有权利。
 * 网站地址: http://www.rrzcms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 */

namespace think\repair\cache\driver;

use think\cache\driver\File as base;

class File extends base
{
    /**
     * 取得变量的存储文件名
     * @access public
     * @param string $name 缓存变量名
     * @return string
     */
    public function getCacheKey(string $name): string {

        //chuan 当hash===false 时不做名称处理 直接用 $name 作为文件名称
        if ($this->options['hash_type'] !== false) {

            $name = hash($this->options['hash_type'], $name);

            if ($this->options['cache_subdir']) {
                // 使用子目录
                $name = substr($name, 0, 2) . DIRECTORY_SEPARATOR . substr($name, 2);
            }

        }

        if ($this->options['prefix']) {
            $name = $this->options['prefix'] . DIRECTORY_SEPARATOR . $name;
        }

        return $this->options['path'] . $name . '.php';
    }
}