(function($) {
    $.fn.camera = function(Z, ba) {
        var bJ = {
            alignment: "center",
            autoAdvance: true,
            mobileAutoAdvance: true,
            barDirection: "leftToRight",
            barPosition: "bottom",
            cols: 6,
            easing: "easeInOutExpo",
            mobileEasing: "",
            fx: "random",
                mobileFx: "",
            gridDifference: 250,
            height: "36%",
            imagePath: "img/",
            hover: false,
            loader: "none",
            loaderColor: "#eeeeee",
            loaderBgColor: "#222222",
            loaderOpacity: 0.8,
            loaderPadding: 2,
            loaderStroke: 7,
            minHeight: "200px",
            navigation: true,
            navigationHover: false,
            mobileNavHover: true,
            opacityOnGrid: false,
            overlayer: true,
            pagination: false,
            playPause: true,
            pauseOnClick: true,
            pieDiameter: 38,
            piePosition: "rightTop",
            portrait: false,
            rows: 4,
            slicedCols: 12,
            slicedRows: 8,
            slideOn: "random",
            thumbnails: false,
            time: 4000,
            transPeriod: 1500,
            onEndTransition: function() {},
            onLoaded: function() {},
            onStartLoading: function() {},
            onStartTransition: function() {}
        };

        function isMobile() {
            if (navigator.userAgent.match(/Android/i) || navigator.userAgent.match(/webOS/i) || navigator.userAgent.match(/iPad/i) || navigator.userAgent.match(/iPhone/i) || navigator.userAgent.match(/iPod/i)) {
                return true
            }
        }
        var Z = $.extend({}, bJ, Z);
        var bK = $(this).addClass("camera_wrap");
        bK.wrapInner('<div class="camera_src" />').wrapInner('<div class="camera_fakehover" />');
        var bL = $(".camera_fakehover", bK);
        bL.append('<div class="camera_target"></div>');
        if (Z.overlayer == true) {
            bL.append('<div class="camera_overlayer"></div>')
        }
        bL.append('<div class="camera_target_content"></div>');
        var bM;
        if (Z.loader == "pie" && $.browser.msie && $.browser.version < 9) {
            bM = "bar"
        } else {
            bM = Z.loader
        }
        if (bM == "pie") {
            bL.append('<div class="camera_pie"></div>')
        } else {
            if (bM == "bar") {
                bL.append('<div class="camera_bar"></div>')
            } else {
                bL.append('<div class="camera_bar" style="display:none"></div>')
            }
        }
        if (Z.playPause == true) {
            bL.append('<div class="camera_commands"></div>')
        }
        if (Z.navigation == true) {
            bL.append('<div class="camera_prev"><span></span></div>').append('<div class="camera_next"><span></span></div>')
        }
        if (Z.thumbnails == true) {
            bK.append('<div class="camera_thumbs_cont" />')
        }
        if (Z.thumbnails == true && Z.pagination != true) {
            $(".camera_thumbs_cont", bK).wrap("<div />").wrap('<div class="camera_thumbs" />').wrap("<div />").wrap('<div class="camera_command_wrap" />')
        }
        if (Z.pagination == true) {
            bK.append('<div class="camera_pag"></div>')
        }
        bK.append('<div class="camera_loader"></div>');
        $(".camera_caption", bK).each(function() {
            $(this).wrapInner("<div />")
        });
        var bN = "pie_" + bK.index(),
            elem = $(".camera_src", bK),
            target = $(".camera_target", bK),
            content = $(".camera_target_content", bK),
            pieContainer = $(".camera_pie", bK),
            barContainer = $(".camera_bar", bK),
            prevNav = $(".camera_prev", bK),
            nextNav = $(".camera_next", bK),
            commands = $(".camera_commands", bK),
            pagination = $(".camera_pag", bK),
            thumbs = $(".camera_thumbs_cont", bK);
        var w, h;
        var bO = new Array();
        $("> div", elem).each(function() {
            bO.push($(this).attr("data-src"))
        });
        var bP = new Array();
        $("> div", elem).each(function() {
            if ($(this).attr("data-link")) {
                bP.push($(this).attr("data-link"))
            } else {
                bP.push("")
            }
        });
        var bQ = new Array();
        $("> div", elem).each(function() {
            if ($(this).attr("data-target")) {
                bQ.push($(this).attr("data-target"))
            } else {
                bQ.push("")
            }
        });
        var bsT = new Array();
        $("> div", elem).each(function() {
            if ($(this).attr("data-title")) {
                bsT.push($(this).attr("data-title"))
            } else {
                bsT.push("")
            }
        });
        var bR = new Array();
        $("> div", elem).each(function() {
            if ($(this).attr("data-portrait")) {
                bR.push($(this).attr("data-portrait"))
            } else {
                bR.push("")
            }
        });
        var bS = new Array();
        $("> div", elem).each(function() {
            if ($(this).attr("data-alignment")) {
                bS.push($(this).attr("data-alignment"))
            } else {
                bS.push("")
            }
        });
        var bT = new Array();
        $("> div", elem).each(function() {
            if ($(this).attr("data-thumb")) {
                bT.push($(this).attr("data-thumb"))
            } else {
                bT.push("")
            }
        });
        var bU = bO.length;
        $(content).append('<div class="cameraContents" />');
        var bV;
        for (bV = 0; bV < bU; bV++) {
            $(".cameraContents", content).append('<div class="cameraContent" />');
            if (bP[bV] != "") {
                var bW = $("> div ", elem).eq(bV).attr("data-box");
                if (typeof bW !== "undefined" && bW !== false && bW != "") {
                    bW = 'data-box="' + $("> div ", elem).eq(bV).attr("data-box") + '"'
                } else {
                    bW = ""
                }
                $(".camera_target_content .cameraContent:eq(" + bV + ")", bK).append('<a class="camera_link" href="' + bP[bV] + '" ' + bW + ' target="' + bQ[bV] + '" title="'+ bsT[bV] +'"></a>')
            }
        }
        $(".camera_caption", bK).each(function() {
            var a = $(this).parent().index(),
                cont = bK.find(".cameraContent").eq(a);
            $(this).appendTo(cont)
        });
        target.append('<div class="cameraCont" />');
        var bX = $(".cameraCont", bK);
        var bY;
        for (bY = 0; bY < bU; bY++) {
            bX.append('<div class="cameraSlide cameraSlide_' + bY + '" />');
            var bZ = $("> div:eq(" + bY + ")", elem);
            target.find(".cameraSlide_" + bY).clone(bZ)
        }
        function thumbnailVisible() {
            var c = $(thumbs).width();
            $("li", thumbs).removeClass("camera_visThumb");
            $("li", thumbs).each(function() {
                var a = $(this).position(),
                    ulW = $("ul", thumbs).outerWidth(),
                    offUl = $("ul", thumbs).offset().left,
                    offDiv = $("> div", thumbs).offset().left,
                    ulLeft = offDiv - offUl;
                if (ulLeft > 0) {
                    $(".camera_prevThumbs", ch).removeClass("hideNav")
                } else {
                    $(".camera_prevThumbs", ch).addClass("hideNav")
                }
                if ((ulW - ulLeft) > c) {
                    $(".camera_nextThumbs", ch).removeClass("hideNav")
                } else {
                    $(".camera_nextThumbs", ch).addClass("hideNav")
                }
                var b = a.left,
                    right = a.left + ($(this).width());
                if (right - ulLeft <= c && b - ulLeft >= 0) {
                    $(this).addClass("camera_visThumb")
                }
            })
        }
        $(window).bind("load resize pageshow", function() {
            thumbnailPos();
            thumbnailVisible()
        });
        bX.append('<div class="cameraSlide cameraSlide_' + bY + '" />');
        var ca;
        bK.show();
        var w = target.width();
        var h = target.height();
        var cb;
        $(window).bind("resize pageshow", function() {
            if (ca == true) {
                resizeImage()
            }
            $("ul", thumbs).animate({
                "margin-top": 0
            }, 0, thumbnailPos);
            if (!elem.hasClass("paused")) {
                elem.addClass("paused");
                if ($(".camera_stop", ch).length) {
                    $(".camera_stop", ch).hide();
                    $(".camera_play", ch).show();
                    if (bM != "none") {
                        $("#" + bN).hide()
                    }
                } else {
                    if (bM != "none") {
                        $("#" + bN).hide()
                    }
                }
                clearTimeout(cb);
                cb = setTimeout(function() {
                    elem.removeClass("paused");
                    if ($(".camera_play", ch).length) {
                        $(".camera_play", ch).hide();
                        $(".camera_stop", ch).show();
                        if (bM != "none") {
                            $("#" + bN).fadeIn()
                        }
                    } else {
                        if (bM != "none") {
                            $("#" + bN).fadeIn()
                        }
                    }
                }, 1500)
            }
        });

        function resizeImage() {
            var b;

            function resizeImageWork() {
                w = bK.width();
                if (Z.height.indexOf("%") != -1) {
                    var a = Math.round(w / (100 / parseFloat(Z.height)));
                    if (Z.minHeight != "" && a < parseFloat(Z.minHeight)) {
                        h = parseFloat(Z.minHeight)
                    } else {
                        h = a
                    }
                    bK.css({
                        height: h
                    })
                } else {
                    if (Z.height == "auto") {
                        h = bK.height()
                    } else {
                        h = parseFloat(Z.height);
                        bK.css({
                            height: h
                        })
                    }
                }
                $(".camerarelative", target).css({
                    "width": w,
                    "height": h
                });
                $(".imgLoaded", target).each(function() {
                    var t = $(this),
                        wT = t.attr("width"),
                        hT = t.attr("height"),
                        imgLoadIn = t.index(),
                        mTop, mLeft, alignment = t.attr("data-alignment"),
                        portrait = t.attr("data-portrait");
                    if (typeof alignment === "undefined" || alignment === false || alignment === "") {
                        alignment = Z.alignment
                    }
                    if (typeof portrait === "undefined" || portrait === false || portrait === "") {
                        portrait = Z.portrait
                    }
                    if (portrait == false || portrait == "false") {
                        if ((wT / hT) < (w / h)) {
                            var r = w / wT;
                            var d = (Math.abs(h - (hT * r))) * 0.5;
                            switch (alignment) {
                                case "topLeft":
                                    mTop = 0;
                                    break;
                                case "topCenter":
                                    mTop = 0;
                                    break;
                                case "topRight":
                                    mTop = 0;
                                    break;
                                case "centerLeft":
                                    mTop = "-" + d + "px";
                                    break;
                                case "center":
                                    mTop = "-" + d + "px";
                                    break;
                                case "centerRight":
                                    mTop = "-" + d + "px";
                                    break;
                                case "bottomLeft":
                                    mTop = "-" + d * 2 + "px";
                                    break;
                                case "bottomCenter":
                                    mTop = "-" + d * 2 + "px";
                                    break;
                                case "bottomRight":
                                    mTop = "-" + d * 2 + "px";
                                    break
                            }
                            t.css({
                                "height": hT * r,
                                "margin-left": 0,
                                "margin-top": mTop,
                                "position": "absolute",
                                "visibility": "visible",
                                "width": w
                            })
                        } else {
                            var r = h / hT;
                            var d = (Math.abs(w - (wT * r))) * 0.5;
                            switch (alignment) {
                                case "topLeft":
                                    mLeft = 0;
                                    break;
                                case "topCenter":
                                    mLeft = "-" + d + "px";
                                    break;
                                case "topRight":
                                    mLeft = "-" + d * 2 + "px";
                                    break;
                                case "centerLeft":
                                    mLeft = 0;
                                    break;
                                case "center":
                                    mLeft = "-" + d + "px";
                                    break;
                                case "centerRight":
                                    mLeft = "-" + d * 2 + "px";
                                    break;
                                case "bottomLeft":
                                    mLeft = 0;
                                    break;
                                case "bottomCenter":
                                    mLeft = "-" + d + "px";
                                    break;
                                case "bottomRight":
                                    mLeft = "-" + d * 2 + "px";
                                    break
                            }
                            t.css({
                                "height": h,
                                "margin-left": mLeft,
                                "margin-top": 0,
                                "position": "absolute",
                                "visibility": "visible",
                                "width": wT * r
                            })
                        }
                    } else {
                        if ((wT / hT) < (w / h)) {
                            var r = h / hT;
                            var d = (Math.abs(w - (wT * r))) * 0.5;
                            switch (alignment) {
                                case "topLeft":
                                    mLeft = 0;
                                    break;
                                case "topCenter":
                                    mLeft = d + "px";
                                    break;
                                case "topRight":
                                    mLeft = d * 2 + "px";
                                    break;
                                case "centerLeft":
                                    mLeft = 0;
                                    break;
                                case "center":
                                    mLeft = d + "px";
                                    break;
                                case "centerRight":
                                    mLeft = d * 2 + "px";
                                    break;
                                case "bottomLeft":
                                    mLeft = 0;
                                    break;
                                case "bottomCenter":
                                    mLeft = d + "px";
                                    break;
                                case "bottomRight":
                                    mLeft = d * 2 + "px";
                                    break
                            }
                            t.css({
                                "height": h,
                                "margin-left": mLeft,
                                "margin-top": 0,
                                "position": "absolute",
                                "visibility": "visible",
                                "width": wT * r
                            })
                        } else {
                            var r = w / wT;
                            var d = (Math.abs(h - (hT * r))) * 0.5;
                            switch (alignment) {
                                case "topLeft":
                                    mTop = 0;
                                    break;
                                case "topCenter":
                                    mTop = 0;
                                    break;
                                case "topRight":
                                    mTop = 0;
                                    break;
                                case "centerLeft":
                                    mTop = d + "px";
                                    break;
                                case "center":
                                    mTop = d + "px";
                                    break;
                                case "centerRight":
                                    mTop = d + "px";
                                    break;
                                case "bottomLeft":
                                    mTop = d * 2 + "px";
                                    break;
                                case "bottomCenter":
                                    mTop = d * 2 + "px";
                                    break;
                                case "bottomRight":
                                    mTop = d * 2 + "px";
                                    break
                            }
                            t.css({
                                "height": hT * r,
                                "margin-left": 0,
                                "margin-top": mTop,
                                "position": "absolute",
                                "visibility": "visible",
                                "width": w
                            })
                        }
                    }
                })
            }
            if (ca == true) {
                clearTimeout(b);
                b = setTimeout(resizeImageWork, 200)
            } else {
                resizeImageWork()
            }
            ca = true
        }
        var u, setT;
        var cc, autoAdv, navHover, commands, pagination;
        var cd, videoPresent;
        if (isMobile() && Z.mobileAutoAdvance != "") {
            autoAdv = Z.mobileAutoAdvance
        } else {
            autoAdv = Z.autoAdvance
        }
        if (autoAdv == false) {
            elem.addClass("paused")
        }
        if (isMobile() && Z.mobileNavHover != "") {
            navHover = Z.mobileNavHover
        } else {
            navHover = Z.navigationHover
        }
        if (elem.length != 0) {
            var ce = $(".cameraSlide", target);
            ce.wrapInner('<div class="camerarelative" />');
            var cf;
            var cg = Z.barDirection;
            var ch = bK;
            $("iframe", bL).each(function() {
                var t = $(this);
                var a = t.attr("src");
                t.attr("data-src", a);
                var b = t.parent().index(".camera_src > div");
                $(".camera_target_content .cameraContent:eq(" + b + ")", bK).append(t)
            });

            function imgFake() {
                $("iframe", bL).each(function() {
                    $(".camera_caption", bL).show();
                    var t = $(this);
                    var a = t.attr("data-src");
                    t.attr("src", a);
                    var b = Z.imagePath + "blank.gif";
                    var c = new Image();
                    c.src = b;
                    if (Z.height.indexOf("%") != -1) {
                        var d = Math.round(w / (100 / parseFloat(Z.height)));
                        if (Z.minHeight != "" && d < parseFloat(Z.minHeight)) {
                            h = parseFloat(Z.minHeight)
                        } else {
                            h = d
                        }
                    } else {
                        if (Z.height == "auto") {
                            h = bK.height()
                        } else {
                            h = parseFloat(Z.height)
                        }
                    }
                    t.after($(c).attr({
                        "class": "imgFake",
                        "width": w,
                        "height": h
                    }));
                    var e = t.clone();
                    t.remove();
                    $(c).bind("click", function() {
                        if ($(this).css("position") == "absolute") {
                            $(this).remove();
                            if (a.indexOf("vimeo") != -1 || a.indexOf("youtube") != -1) {
                                if (a.indexOf("?") != -1) {
                                    autoplay = "&autoplay=1"
                                } else {
                                    autoplay = "?autoplay=1"
                                }
                            } else {
                                if (a.indexOf("dailymotion") != -1) {
                                    if (a.indexOf("?") != -1) {
                                        autoplay = "&autoPlay=1"
                                    } else {
                                        autoplay = "?autoPlay=1"
                                    }
                                }
                            }
                            e.attr("src", a + autoplay);
                            videoPresent = true
                        } else {
                            $(this).css({
                                position: "absolute",
                                top: 0,
                                left: 0,
                                zIndex: 10
                            }).after(e);
                            e.css({
                                position: "absolute",
                                top: 0,
                                left: 0,
                                zIndex: 9
                            })
                        }
                    })
                })
            }
            imgFake();
            if (Z.hover == true) {
                if (!isMobile()) {
                    bL.hover(function() {
                        elem.addClass("hovered")
                    }, function() {
                        elem.removeClass("hovered")
                    })
                }
            }
            if (navHover == true) {
                $(prevNav, bK).animate({
                    opacity: 0
                }, 0);
                $(nextNav, bK).animate({
                    opacity: 0
                }, 0);
                $(commands, bK).animate({
                    opacity: 0
                }, 0);
                if (isMobile()) {
                    bL.live("vmouseover", function() {
                        $(prevNav, bK).animate({
                            opacity: 1
                        }, 200);
                        $(nextNav, bK).animate({
                            opacity: 1
                        }, 200);
                        $(commands, bK).animate({
                            opacity: 1
                        }, 200)
                    });
                    bL.live("vmouseout", function() {
                        $(prevNav, bK).delay(500).animate({
                            opacity: 0
                        }, 200);
                        $(nextNav, bK).delay(500).animate({
                            opacity: 0
                        }, 200);
                        $(commands, bK).delay(500).animate({
                            opacity: 0
                        }, 200)
                    })
                } else {
                    bL.hover(function() {
                        $(prevNav, bK).animate({
                            opacity: 1
                        }, 200);
                        $(nextNav, bK).animate({
                            opacity: 1
                        }, 200);
                        $(commands, bK).animate({
                            opacity: 1
                        }, 200)
                    }, function() {
                        $(prevNav, bK).animate({
                            opacity: 0
                        }, 200);
                        $(nextNav, bK).animate({
                            opacity: 0
                        }, 200);
                        $(commands, bK).animate({
                            opacity: 0
                        }, 200)
                    })
                }
            }
            $(".camera_stop", ch).live("click", function() {
                autoAdv = false;
                elem.addClass("paused");
                if ($(".camera_stop", ch).length) {
                    $(".camera_stop", ch).hide();
                    $(".camera_play", ch).show();
                    if (bM != "none") {
                        $("#" + bN).hide()
                    }
                } else {
                    if (bM != "none") {
                        $("#" + bN).hide()
                    }
                }
            });
            $(".camera_play", ch).live("click", function() {
                autoAdv = true;
                elem.removeClass("paused");
                if ($(".camera_play", ch).length) {
                    $(".camera_play", ch).hide();
                    $(".camera_stop", ch).show();
                    if (bM != "none") {
                        $("#" + bN).show()
                    }
                } else {
                    if (bM != "none") {
                        $("#" + bN).show()
                    }
                }
            });
            if (Z.pauseOnClick == true) {
                $(".camera_target_content", bL).mouseup(function() {
                    autoAdv = false;
                    elem.addClass("paused");
                    $(".camera_stop", ch).hide();
                    $(".camera_play", ch).show();
                    $("#" + bN).hide()
                })
            }
            $(".cameraContent, .imgFake", bL).hover(function() {
                cd = true
            }, function() {
                cd = false
            });
            $(".cameraContent, .imgFake", bL).bind("click", function() {
                if (videoPresent == true && cd == true) {
                    autoAdv = false;
                    $(".camera_caption", bL).hide();
                    elem.addClass("paused");
                    $(".camera_stop", ch).hide();
                    $(".camera_play", ch).show();
                    $("#" + bN).hide()
                }
            })
        }
        function shuffle(a) {
            for (var j, x, i = a.length; i; j = parseInt(Math.random() * i), x = a[--i], a[i] = a[j], a[j] = x) {}
            return a
        }
        function isInteger(s) {
            return Math.ceil(s) == Math.floor(s)
        }
        if (bM != "pie") {
            barContainer.append('<span class="camera_bar_cont" />');
            $(".camera_bar_cont", barContainer).animate({
                opacity: Z.loaderOpacity
            }, 0).css({
                "position": "absolute",
                "left": 0,
                "right": 0,
                "top": 0,
                "bottom": 0,
                "background-color": Z.loaderBgColor
            }).append('<span id="' + bN + '" />');
            $("#" + bN).animate({
                opacity: 0
            }, 0);
            var ci = $("#" + bN);
            ci.css({
                "position": "absolute",
                "background-color": Z.loaderColor
            });
            switch (Z.barPosition) {
                case "left":
                    barContainer.css({
                        right: "auto",
                        width: Z.loaderStroke
                    });
                    break;
                case "right":
                    barContainer.css({
                        left: "auto",
                        width: Z.loaderStroke
                    });
                    break;
                case "top":
                    barContainer.css({
                        bottom: "auto",
                        height: Z.loaderStroke
                    });
                    break;
                case "bottom":
                    barContainer.css({
                        top: "auto",
                        height: Z.loaderStroke
                    });
                    break
            }
            switch (cg) {
                case "leftToRight":
                    ci.css({
                        "left": 0,
                        "right": 0,
                        "top": Z.loaderPadding,
                        "bottom": Z.loaderPadding
                    });
                    break;
                case "rightToLeft":
                    ci.css({
                        "left": 0,
                        "right": 0,
                        "top": Z.loaderPadding,
                        "bottom": Z.loaderPadding
                    });
                    break;
                case "topToBottom":
                    ci.css({
                        "left": Z.loaderPadding,
                        "right": Z.loaderPadding,
                        "top": 0,
                        "bottom": 0
                    });
                    break;
                case "bottomToTop":
                    ci.css({
                        "left": Z.loaderPadding,
                        "right": Z.loaderPadding,
                        "top": 0,
                        "bottom": 0
                    });
                    break
            }
        } else {
            pieContainer.append('<canvas id="' + bN + '"></canvas>');
            var cj;
            var ci = document.getElementById(bN);
            ci.setAttribute("width", Z.pieDiameter);
            ci.setAttribute("height", Z.pieDiameter);
            var ck;
            switch (Z.piePosition) {
                case "leftTop":
                    ck = "left:0; top:0;";
                    break;
                case "rightTop":
                    ck = "right:0; top:0;";
                    break;
                case "leftBottom":
                    ck = "left:0; bottom:0;";
                    break;
                case "rightBottom":
                    ck = "right:0; bottom:0;";
                    break
            }
            ci.setAttribute("style", "position:absolute; z-index:1002; " + ck);
            var cl;
            var cm;
            if (ci && ci.getContext) {
                var cn = ci.getContext("2d");
                cn.rotate(Math.PI * (3 / 2));
                cn.translate(-Z.pieDiameter, 0)
            }
        }
        if (bM == "none" || autoAdv == false) {
            $("#" + bN).hide();
            $(".camera_canvas_wrap", ch).hide()
        }
        if ($(pagination).length) {
            $(pagination).append('<ul class="camera_pag_ul" />');
            var co;
            for (co = 0; co < bU; co++) {
                $(".camera_pag_ul", bK).append('<li class="pag_nav_' + co + '" style="position:relative; z-index:1002"><span><span>' + co + "</span></span></li>")
            }
            $(".camera_pag_ul li", bK).hover(function() {
                $(this).addClass("camera_hover");
                if ($(".camera_thumb", this).length) {
                    var a = $(".camera_thumb", this).outerWidth(),
                        hTh = $(".camera_thumb", this).outerHeight(),
                        wTt = $(this).outerWidth();
                    $(".camera_thumb", this).show().css({
                        "top": "-" + hTh + "px",
                        "left": "-" + (a - wTt) / 2 + "px"
                    }).animate({
                        "opacity": 1,
                        "margin-top": "-3px"
                    }, 200);
                    $(".thumb_arrow", this).show().animate({
                        "opacity": 1,
                        "margin-top": "-3px"
                    }, 200)
                }
            }, function() {
                $(this).removeClass("camera_hover");
                $(".camera_thumb", this).animate({
                    "margin-top": "-20px",
                    "opacity": 0
                }, 200, function() {
                    $(this).css({
                        marginTop: "5px"
                    }).hide()
                });
                $(".thumb_arrow", this).animate({
                    "margin-top": "-20px",
                    "opacity": 0
                }, 200, function() {
                    $(this).css({
                        marginTop: "5px"
                    }).hide()
                })
            })
        }
        if ($(thumbs).length) {
            var cp;
            if (!$(pagination).length) {
                $(thumbs).append("<div />");
                $(thumbs).before('<div class="camera_prevThumbs hideNav"><div></div></div>').before('<div class="camera_nextThumbs hideNav"><div></div></div>');
                $("> div", thumbs).append("<ul />");
                $.each(bT, function(i, a) {
                    if ($("> div", elem).eq(i).attr("data-thumb") != "") {
                        var b = $("> div", elem).eq(i).attr("data-thumb"),
                            newImg = new Image();
                        newImg.src = b;
                        $("ul", thumbs).append('<li class="pix_thumb pix_thumb_' + i + '" />');
                        $("li.pix_thumb_" + i, thumbs).append($(newImg).attr("class", "camera_thumb"))
                    }
                })
            } else {
                $.each(bT, function(i, a) {
                    if ($("> div", elem).eq(i).attr("data-thumb") != "") {
                        var b = $("> div", elem).eq(i).attr("data-thumb"),
                            newImg = new Image();
                        newImg.src = b;
                        $("li.pag_nav_" + i, pagination).append($(newImg).attr("class", "camera_thumb").css({
                            "position": "absolute"
                        }).animate({
                            opacity: 0
                        }, 0));
                        $("li.pag_nav_" + i + " > img", pagination).after('<div class="thumb_arrow" />');
                        $("li.pag_nav_" + i + " > .thumb_arrow", pagination).animate({
                            opacity: 0
                        }, 0)
                    }
                });
                bK.css({
                    marginBottom: $(pagination).outerHeight()
                })
            }
        } else {
            if (!$(thumbs).length && $(pagination).length) {
                bK.css({
                    marginBottom: $(pagination).outerHeight()
                })
            }
        }
        var cq = true;

        function thumbnailPos() {
            if ($(thumbs).length && !$(pagination).length) {
                var a = $(thumbs).outerWidth(),
                    owTh = $("ul > li", thumbs).outerWidth(),
                    pos = $("li.cameracurrent", thumbs).length ? $("li.cameracurrent", thumbs).position() : "",
                    ulW = ($("ul > li", thumbs).length * $("ul > li", thumbs).outerWidth()),
                    offUl = $("ul", thumbs).offset().left,
                    offDiv = $("> div", thumbs).offset().left,
                    ulLeft;
                if (offUl < 0) {
                    ulLeft = "-" + (offDiv - offUl)
                } else {
                    ulLeft = offDiv - offUl
                }
                if (cq == true) {
                    $("ul", thumbs).width($("ul > li", thumbs).length * $("ul > li", thumbs).outerWidth());
                    if ($(thumbs).length && !$(pagination).lenght) {
                        bK.css({
                            marginBottom: $(thumbs).outerHeight()
                        })
                    }
                    thumbnailVisible();
                    $("ul", thumbs).width($("ul > li", thumbs).length * $("ul > li", thumbs).outerWidth());
                    if ($(thumbs).length && !$(pagination).lenght) {
                        bK.css({
                            marginBottom: $(thumbs).outerHeight()
                        })
                    }
                }
                cq = false;
                var b = $("li.cameracurrent", thumbs).length ? pos.left : "",
                    right = $("li.cameracurrent", thumbs).length ? pos.left + ($("li.cameracurrent", thumbs).outerWidth()) : "";
                if (b < $("li.cameracurrent", thumbs).outerWidth()) {
                    b = 0
                }
                if (right - ulLeft > a) {
                    if ((b + a) < ulW) {
                        $("ul", thumbs).animate({
                            "margin-left": "-" + (b) + "px"
                        }, 500, thumbnailVisible)
                    } else {
                        $("ul", thumbs).animate({
                            "margin-left": "-" + ($("ul", thumbs).outerWidth() - a) + "px"
                        }, 500, thumbnailVisible)
                    }
                } else {
                    if (b - ulLeft < 0) {
                        $("ul", thumbs).animate({
                            "margin-left": "-" + (b) + "px"
                        }, 500, thumbnailVisible)
                    } else {
                        $("ul", thumbs).css({
                            "margin-left": "auto",
                            "margin-right": "auto"
                        });
                        setTimeout(thumbnailVisible, 100)
                    }
                }
            }
        }
        if ($(commands).length) {
            $(commands).append('<div class="camera_play"></div>').append('<div class="camera_stop"></div>');
            if (autoAdv == true) {
                $(".camera_play", ch).hide();
                $(".camera_stop", ch).show()
            } else {
                $(".camera_stop", ch).hide();
                $(".camera_play", ch).show()
            }
        }
        function canvasLoader() {
            cl = 0;
            var a = $(".camera_bar_cont", ch).width(),
                barHeight = $(".camera_bar_cont", ch).height();
            if (bM != "pie") {
                switch (cg) {
                    case "leftToRight":
                        $("#" + bN).css({
                            "right": a
                        });
                        break;
                    case "rightToLeft":
                        $("#" + bN).css({
                            "left": a
                        });
                        break;
                    case "topToBottom":
                        $("#" + bN).css({
                            "bottom": barHeight
                        });
                        break;
                    case "bottomToTop":
                        $("#" + bN).css({
                            "top": barHeight
                        });
                        break
                }
            } else {
                cn.clearRect(0, 0, Z.pieDiameter, Z.pieDiameter)
            }
        }
        canvasLoader();
        $(".moveFromLeft, .moveFromRight, .moveFromTop, .moveFromBottom, .fadeIn, .fadeFromLeft, .fadeFromRight, .fadeFromTop, .fadeFromBottom", bL).each(function() {
            $(this).css("visibility", "hidden")
        });
        Z.onStartLoading.call(this);
        nextSlide();

        function nextSlide(r) {
            elem.addClass("camerasliding");
            videoPresent = false;
            var s = parseFloat($("div.cameraSlide.cameracurrent", target).index());
            if (r > 0) {
                var v = r - 1
            } else {
                if (s == bU - 1) {
                    var v = 0
                } else {
                    var v = s + 1
                }
            }
            var A = $(".cameraSlide:eq(" + v + ")", target);
            var B = $(".cameraSlide:eq(" + (v + 1) + ")", target).addClass("cameranext");
            if (s != v + 1) {
                B.hide()
            }
            $(".cameraContent", bL).fadeOut(600);
            $(".camera_caption", bL).show();
            $(".camerarelative", A).append($("> div ", elem).eq(v).find("> div.camera_effected"));
            $(".camera_target_content .cameraContent:eq(" + v + ")", bK).append($("> div ", elem).eq(v).find("> div"));
            if (!$(".imgLoaded", A).length) {
                var C = bO[v];
                var D = new Image();
                D.src = C + "?" + new Date().getTime();
                A.css("visibility", "hidden");
                A.prepend($(D).attr("class", "imgLoaded").css("visibility", "hidden"));
                var E, hT;
                if (!$(D).get(0).complete || E == "0" || hT == "0" || typeof E === "undefined" || E === false || typeof hT === "undefined" || hT === false) {
                    $(".camera_loader", bK).delay(500).fadeIn(400);
                    D.onload = function() {
                        E = D.naturalWidth;
                        hT = D.naturalHeight;
                        $(D).attr("data-alignment", bS[v]).attr("data-portrait", bR[v]);
                        $(D).attr("width", E);
                        $(D).attr("height", hT);
                        target.find(".cameraSlide_" + v).hide().css("visibility", "visible");
                        resizeImage();
                        nextSlide(v + 1)
                    }
                }
            } else {
                if (bO.length > (v + 1) && !$(".imgLoaded", B).length) {
                    var F = bO[(v + 1)];
                    var G = new Image();
                    G.src = F + "?" + new Date().getTime();
                    B.prepend($(G).attr("class", "imgLoaded").css("visibility", "hidden"));
                    G.onload = function() {
                        E = G.naturalWidth;
                        hT = G.naturalHeight;
                        $(G).attr("data-alignment", bS[v + 1]).attr("data-portrait", bR[v + 1]);
                        $(G).attr("width", E);
                        $(G).attr("height", hT);
                        resizeImage()
                    }
                }
                Z.onLoaded.call(this);
                if ($(".camera_loader", bK).is(":visible")) {
                    $(".camera_loader", bK).fadeOut(400)
                } else {
                    $(".camera_loader", bK).css({
                        "visibility": "hidden"
                    });
                    $(".camera_loader", bK).fadeOut(400, function() {
                        $(".camera_loader", bK).css({
                            "visibility": "visible"
                        })
                    })
                }
                var H = Z.rows,
                    cols = Z.cols,
                    couples = 1,
                    difference = 0,
                    dataSlideOn, time, transPeriod, fx, easing, randomFx = new Array("simpleFade", "curtainTopLeft", "curtainTopRight", "curtainBottomLeft", "curtainBottomRight", "curtainSliceLeft", "curtainSliceRight", "blindCurtainTopLeft", "blindCurtainTopRight", "blindCurtainBottomLeft", "blindCurtainBottomRight", "blindCurtainSliceBottom", "blindCurtainSliceTop", "stampede", "mosaic", "mosaicReverse", "mosaicRandom", "mosaicSpiral", "mosaicSpiralReverse", "topLeftBottomRight", "bottomRightTopLeft", "bottomLeftTopRight", "topRightBottomLeft", "scrollLeft", "scrollRight", "scrollTop", "scrollBottom", "scrollHorz");
                marginLeft = 0, marginTop = 0, opacityOnGrid = 0;
                if (Z.opacityOnGrid == true) {
                    opacityOnGrid = 0
                } else {
                    opacityOnGrid = 1
                }
                var I = $(" > div", elem).eq(v).attr("data-fx");
                if (isMobile() && Z.mobileFx != "" && Z.mobileFx != "default") {
                    fx = Z.mobileFx
                } else {
                    if (typeof I !== "undefined" && I !== false && I !== "default") {
                        fx = I
                    } else {
                        fx = Z.fx
                    }
                }
                if (fx == "random") {
                    fx = shuffle(randomFx);
                    fx = fx[0]
                } else {
                    fx = fx;
                    if (fx.indexOf(",") > 0) {
                        fx = fx.replace(/ /g, "");
                        fx = fx.split(",");
                        fx = shuffle(fx);
                        fx = fx[0]
                    }
                }
                dataEasing = $(" > div", elem).eq(v).attr("data-easing");
                mobileEasing = $(" > div", elem).eq(v).attr("data-mobileEasing");
                if (isMobile() && Z.mobileEasing != "" && Z.mobileEasing != "default") {
                    if (typeof mobileEasing !== "undefined" && mobileEasing !== false && mobileEasing !== "default") {
                        easing = mobileEasing
                    } else {
                        easing = Z.mobileEasing
                    }
                } else {
                    if (typeof dataEasing !== "undefined" && dataEasing !== false && dataEasing !== "default") {
                        easing = dataEasing
                    } else {
                        easing = Z.easing
                    }
                }
                dataSlideOn = $(" > div", elem).eq(v).attr("data-slideOn");
                if (typeof dataSlideOn !== "undefined" && dataSlideOn !== false) {
                    J = dataSlideOn
                } else {
                    if (Z.slideOn == "random") {
                        var J = new Array("next", "prev");
                        J = shuffle(J);
                        J = J[0]
                    } else {
                        J = Z.slideOn
                    }
                }
                var K = $(" > div", elem).eq(v).attr("data-time");
                if (typeof K !== "undefined" && K !== false && K !== "") {
                    time = parseFloat(K)
                } else {
                    time = Z.time
                }
                var L = $(" > div", elem).eq(v).attr("data-transPeriod");
                if (typeof L !== "undefined" && L !== false && L !== "") {
                    transPeriod = parseFloat(L)
                } else {
                    transPeriod = Z.transPeriod
                }
                if (!$(elem).hasClass("camerastarted")) {
                    fx = "simpleFade";
                    J = "next";
                    easing = "";
                    transPeriod = 400;
                    $(elem).addClass("camerastarted")
                }
                switch (fx) {
                    case "simpleFade":
                        cols = 1;
                        H = 1;
                        break;
                    case "curtainTopLeft":
                        if (Z.slicedCols == 0) {
                            cols = Z.cols
                        } else {
                            cols = Z.slicedCols
                        }
                        H = 1;
                        break;
                    case "curtainTopRight":
                        if (Z.slicedCols == 0) {
                            cols = Z.cols
                        } else {
                            cols = Z.slicedCols
                        }
                        H = 1;
                        break;
                    case "curtainBottomLeft":
                        if (Z.slicedCols == 0) {
                            cols = Z.cols
                        } else {
                            cols = Z.slicedCols
                        }
                        H = 1;
                        break;
                    case "curtainBottomRight":
                        if (Z.slicedCols == 0) {
                            cols = Z.cols
                        } else {
                            cols = Z.slicedCols
                        }
                        H = 1;
                        break;
                    case "curtainSliceLeft":
                        if (Z.slicedCols == 0) {
                            cols = Z.cols
                        } else {
                            cols = Z.slicedCols
                        }
                        H = 1;
                        break;
                    case "curtainSliceRight":
                        if (Z.slicedCols == 0) {
                            cols = Z.cols
                        } else {
                            cols = Z.slicedCols
                        }
                        H = 1;
                        break;
                    case "blindCurtainTopLeft":
                        if (Z.slicedRows == 0) {
                            H = Z.rows
                        } else {
                            H = Z.slicedRows
                        }
                        cols = 1;
                        break;
                    case "blindCurtainTopRight":
                        if (Z.slicedRows == 0) {
                            H = Z.rows
                        } else {
                            H = Z.slicedRows
                        }
                        cols = 1;
                        break;
                    case "blindCurtainBottomLeft":
                        if (Z.slicedRows == 0) {
                            H = Z.rows
                        } else {
                            H = Z.slicedRows
                        }
                        cols = 1;
                        break;
                    case "blindCurtainBottomRight":
                        if (Z.slicedRows == 0) {
                            H = Z.rows
                        } else {
                            H = Z.slicedRows
                        }
                        cols = 1;
                        break;
                    case "blindCurtainSliceTop":
                        if (Z.slicedRows == 0) {
                            H = Z.rows
                        } else {
                            H = Z.slicedRows
                        }
                        cols = 1;
                        break;
                    case "blindCurtainSliceBottom":
                        if (Z.slicedRows == 0) {
                            H = Z.rows
                        } else {
                            H = Z.slicedRows
                        }
                        cols = 1;
                        break;
                    case "stampede":
                        difference = "-" + transPeriod;
                        break;
                    case "mosaic":
                        difference = Z.gridDifference;
                        break;
                    case "mosaicReverse":
                        difference = Z.gridDifference;
                        break;
                    case "mosaicRandom":
                        break;
                    case "mosaicSpiral":
                        difference = Z.gridDifference;
                        couples = 1.7;
                        break;
                    case "mosaicSpiralReverse":
                        difference = Z.gridDifference;
                        couples = 1.7;
                        break;
                    case "topLeftBottomRight":
                        difference = Z.gridDifference;
                        couples = 6;
                        break;
                    case "bottomRightTopLeft":
                        difference = Z.gridDifference;
                        couples = 6;
                        break;
                    case "bottomLeftTopRight":
                        difference = Z.gridDifference;
                        couples = 6;
                        break;
                    case "topRightBottomLeft":
                        difference = Z.gridDifference;
                        couples = 6;
                        break;
                    case "scrollLeft":
                        cols = 1;
                        H = 1;
                        break;
                    case "scrollRight":
                        cols = 1;
                        H = 1;
                        break;
                    case "scrollTop":
                        cols = 1;
                        H = 1;
                        break;
                    case "scrollBottom":
                        cols = 1;
                        H = 1;
                        break;
                    case "scrollHorz":
                        cols = 1;
                        H = 1;
                        break
                }
                var M = 0;
                var N = H * cols;
                var O = w - (Math.floor(w / cols) * cols);
                var P = h - (Math.floor(h / H) * H);
                var Q;
                var R;
                var S = 0;
                var T = 0;
                var U = new Array();
                var V = new Array();
                var W = new Array();
                while (M < N) {
                    U.push(M);
                    V.push(M);
                    bX.append('<div class="cameraappended" style="display:none; overflow:hidden; position:absolute; z-index:1000" />');
                    var X = $(".cameraappended:eq(" + M + ")", target);
                    if (fx == "scrollLeft" || fx == "scrollRight" || fx == "scrollTop" || fx == "scrollBottom" || fx == "scrollHorz") {
                        ce.eq(v).clone().show().appendTo(X)
                    } else {
                        if (J == "next") {
                            ce.eq(v).clone().show().appendTo(X)
                        } else {
                            ce.eq(s).clone().show().appendTo(X)
                        }
                    }
                    if (M % cols < O) {
                        Q = 1
                    } else {
                        Q = 0
                    }
                    if (M % cols == 0) {
                        S = 0
                    }
                    if (Math.floor(M / cols) < P) {
                        R = 1
                    } else {
                        R = 0
                    }
                    X.css({
                        "height": Math.floor((h / H) + R + 1),
                        "left": S,
                        "top": T,
                        "width": Math.floor((w / cols) + Q + 1)
                    });
                    $("> .cameraSlide", X).css({
                        "height": h,
                        "margin-left": "-" + S + "px",
                        "margin-top": "-" + T + "px",
                        "width": w
                    });
                    S = S + X.width() - 1;
                    if (M % cols == cols - 1) {
                        T = T + X.height() - 1
                    }
                    M++
                }
                switch (fx) {
                    case "curtainTopLeft":
                        break;
                    case "curtainBottomLeft":
                        break;
                    case "curtainSliceLeft":
                        break;
                    case "curtainTopRight":
                        U = U.reverse();
                        break;
                    case "curtainBottomRight":
                        U = U.reverse();
                        break;
                    case "curtainSliceRight":
                        U = U.reverse();
                        break;
                    case "blindCurtainTopLeft":
                        break;
                    case "blindCurtainBottomLeft":
                        U = U.reverse();
                        break;
                    case "blindCurtainSliceTop":
                        break;
                    case "blindCurtainTopRight":
                        break;
                    case "blindCurtainBottomRight":
                        U = U.reverse();
                        break;
                    case "blindCurtainSliceBottom":
                        U = U.reverse();
                        break;
                    case "stampede":
                        U = shuffle(U);
                        break;
                    case "mosaic":
                        break;
                    case "mosaicReverse":
                        U = U.reverse();
                        break;
                    case "mosaicRandom":
                        U = shuffle(U);
                        break;
                    case "mosaicSpiral":
                        var Y = H / 2,
                            x, y, z, n = 0;
                        for (z = 0; z < Y; z++) {
                            y = z;
                            for (x = z; x < cols - z - 1; x++) {
                                W[n++] = y * cols + x
                            }
                            x = cols - z - 1;
                            for (y = z; y < H - z - 1; y++) {
                                W[n++] = y * cols + x
                            }
                            y = H - z - 1;
                            for (x = cols - z - 1; x > z; x--) {
                                W[n++] = y * cols + x
                            }
                            x = z;
                            for (y = H - z - 1; y > z; y--) {
                                W[n++] = y * cols + x
                            }
                        }
                        U = W;
                        break;
                    case "mosaicSpiralReverse":
                        var Y = H / 2,
                            x, y, z, n = N - 1;
                        for (z = 0; z < Y; z++) {
                            y = z;
                            for (x = z; x < cols - z - 1; x++) {
                                W[n--] = y * cols + x
                            }
                            x = cols - z - 1;
                            for (y = z; y < H - z - 1; y++) {
                                W[n--] = y * cols + x
                            }
                            y = H - z - 1;
                            for (x = cols - z - 1; x > z; x--) {
                                W[n--] = y * cols + x
                            }
                            x = z;
                            for (y = H - z - 1; y > z; y--) {
                                W[n--] = y * cols + x
                            }
                        }
                        U = W;
                        break;
                    case "topLeftBottomRight":
                        for (var y = 0; y < H; y++) {
                            for (var x = 0; x < cols; x++) {
                                W.push(x + y)
                            }
                        }
                        V = W;
                        break;
                    case "bottomRightTopLeft":
                        for (var y = 0; y < H; y++) {
                            for (var x = 0; x < cols; x++) {
                                W.push(x + y)
                            }
                        }
                        V = W.reverse();
                        break;
                    case "bottomLeftTopRight":
                        for (var y = H; y > 0; y--) {
                            for (var x = 0; x < cols; x++) {
                                W.push(x + y)
                            }
                        }
                        V = W;
                        break;
                    case "topRightBottomLeft":
                        for (var y = 0; y < H; y++) {
                            for (var x = cols; x > 0; x--) {
                                W.push(x + y)
                            }
                        }
                        V = W;
                        break
                }
                $.each(U, function(n, o) {
                    if (o % cols < O) {
                        Q = 1
                    } else {
                        Q = 0
                    }
                    if (o % cols == 0) {
                        S = 0
                    }
                    if (Math.floor(o / cols) < P) {
                        R = 1
                    } else {
                        R = 0
                    }
                    switch (fx) {
                        case "simpleFade":
                            height = h;
                            width = w;
                            opacityOnGrid = 0;
                            break;
                        case "curtainTopLeft":
                            height = 0, width = Math.floor((w / cols) + Q + 1), marginTop = "-" + Math.floor((h / H) + R + 1) + "px";
                            break;
                        case "curtainTopRight":
                            height = 0, width = Math.floor((w / cols) + Q + 1), marginTop = "-" + Math.floor((h / H) + R + 1) + "px";
                            break;
                        case "curtainBottomLeft":
                            height = 0, width = Math.floor((w / cols) + Q + 1), marginTop = Math.floor((h / H) + R + 1) + "px";
                            break;
                        case "curtainBottomRight":
                            height = 0, width = Math.floor((w / cols) + Q + 1), marginTop = Math.floor((h / H) + R + 1) + "px";
                            break;
                        case "curtainSliceLeft":
                            height = 0, width = Math.floor((w / cols) + Q + 1);
                            if (o % 2 == 0) {
                                marginTop = Math.floor((h / H) + R + 1) + "px"
                            } else {
                                marginTop = "-" + Math.floor((h / H) + R + 1) + "px"
                            }
                            break;
                        case "curtainSliceRight":
                            height = 0, width = Math.floor((w / cols) + Q + 1);
                            if (o % 2 == 0) {
                                marginTop = Math.floor((h / H) + R + 1) + "px"
                            } else {
                                marginTop = "-" + Math.floor((h / H) + R + 1) + "px"
                            }
                            break;
                        case "blindCurtainTopLeft":
                            height = Math.floor((h / H) + R + 1), width = 0, marginLeft = "-" + Math.floor((w / cols) + Q + 1) + "px";
                            break;
                        case "blindCurtainTopRight":
                            height = Math.floor((h / H) + R + 1), width = 0, marginLeft = Math.floor((w / cols) + Q + 1) + "px";
                            break;
                        case "blindCurtainBottomLeft":
                            height = Math.floor((h / H) + R + 1), width = 0, marginLeft = "-" + Math.floor((w / cols) + Q + 1) + "px";
                            break;
                        case "blindCurtainBottomRight":
                            height = Math.floor((h / H) + R + 1), width = 0, marginLeft = Math.floor((w / cols) + Q + 1) + "px";
                            break;
                        case "blindCurtainSliceBottom":
                            height = Math.floor((h / H) + R + 1), width = 0;
                            if (o % 2 == 0) {
                                marginLeft = "-" + Math.floor((w / cols) + Q + 1) + "px"
                            } else {
                                marginLeft = Math.floor((w / cols) + Q + 1) + "px"
                            }
                            break;
                        case "blindCurtainSliceTop":
                            height = Math.floor((h / H) + R + 1), width = 0;
                            if (o % 2 == 0) {
                                marginLeft = "-" + Math.floor((w / cols) + Q + 1) + "px"
                            } else {
                                marginLeft = Math.floor((w / cols) + Q + 1) + "px"
                            }
                            break;
                        case "stampede":
                            height = 0;
                            width = 0;
                            marginLeft = (w * 0.2) * (((n) % cols) - (cols - (Math.floor(cols / 2)))) + "px";
                            marginTop = (h * 0.2) * ((Math.floor(n / cols) + 1) - (H - (Math.floor(H / 2)))) + "px";
                            break;
                        case "mosaic":
                            height = 0;
                            width = 0;
                            break;
                        case "mosaicReverse":
                            height = 0;
                            width = 0;
                            marginLeft = Math.floor((w / cols) + Q + 1) + "px";
                            marginTop = Math.floor((h / H) + R + 1) + "px";
                            break;
                        case "mosaicRandom":
                            height = 0;
                            width = 0;
                            marginLeft = Math.floor((w / cols) + Q + 1) * 0.5 + "px";
                            marginTop = Math.floor((h / H) + R + 1) * 0.5 + "px";
                            break;
                        case "mosaicSpiral":
                            height = 0;
                            width = 0;
                            marginLeft = Math.floor((w / cols) + Q + 1) * 0.5 + "px";
                            marginTop = Math.floor((h / H) + R + 1) * 0.5 + "px";
                            break;
                        case "mosaicSpiralReverse":
                            height = 0;
                            width = 0;
                            marginLeft = Math.floor((w / cols) + Q + 1) * 0.5 + "px";
                            marginTop = Math.floor((h / H) + R + 1) * 0.5 + "px";
                            break;
                        case "topLeftBottomRight":
                            height = 0;
                            width = 0;
                            break;
                        case "bottomRightTopLeft":
                            height = 0;
                            width = 0;
                            marginLeft = Math.floor((w / cols) + Q + 1) + "px";
                            marginTop = Math.floor((h / H) + R + 1) + "px";
                            break;
                        case "bottomLeftTopRight":
                            height = 0;
                            width = 0;
                            marginLeft = 0;
                            marginTop = Math.floor((h / H) + R + 1) + "px";
                            break;
                        case "topRightBottomLeft":
                            height = 0;
                            width = 0;
                            marginLeft = Math.floor((w / cols) + Q + 1) + "px";
                            marginTop = 0;
                            break;
                        case "scrollRight":
                            height = h;
                            width = w;
                            marginLeft = -w;
                            break;
                        case "scrollLeft":
                            height = h;
                            width = w;
                            marginLeft = w;
                            break;
                        case "scrollTop":
                            height = h;
                            width = w;
                            marginTop = h;
                            break;
                        case "scrollBottom":
                            height = h;
                            width = w;
                            marginTop = -h;
                            break;
                        case "scrollHorz":
                            height = h;
                            width = w;
                            if (s == 0 && v == bU - 1) {
                                marginLeft = -w
                            } else {
                                if (s < v || (s == bU - 1 && v == 0)) {
                                    marginLeft = w
                                } else {
                                    marginLeft = -w
                                }
                            }
                            break
                    }
                    var p = $(".cameraappended:eq(" + o + ")", target);
                    if (typeof u !== "undefined") {
                        clearInterval(u);
                        clearTimeout(setT);
                        setT = setTimeout(canvasLoader, transPeriod + difference)
                    }
                    if ($(pagination).length) {
                        $(".camera_pag li", bK).removeClass("cameracurrent");
                        $(".camera_pag li", bK).eq(v).addClass("cameracurrent")
                    }
                    if ($(thumbs).length) {
                        $("li", thumbs).removeClass("cameracurrent");
                        $("li", thumbs).eq(v).addClass("cameracurrent");
                        $("li", thumbs).not(".cameracurrent").find("img").animate({
                            opacity: 0.5
                        }, 0);
                        $("li.cameracurrent img", thumbs).animate({
                            opacity: 1
                        }, 0);
                        $("li", thumbs).hover(function() {
                            $("img", this).stop(true, false).animate({
                                opacity: 1
                            }, 150)
                        }, function() {
                            if (!$(this).hasClass("cameracurrent")) {
                                $("img", this).stop(true, false).animate({
                                    opacity: 0.5
                                }, 150)
                            }
                        })
                    }
                    var q = parseFloat(transPeriod) + parseFloat(difference);

                    function cameraeased() {
                        $(this).addClass("cameraeased");
                        if ($(".cameraeased", target).length >= 0) {
                            $(thumbs).css({
                                visibility: "visible"
                            })
                        }
                        if ($(".cameraeased", target).length == N) {
                            thumbnailPos();
                            $(".moveFromLeft, .moveFromRight, .moveFromTop, .moveFromBottom, .fadeIn, .fadeFromLeft, .fadeFromRight, .fadeFromTop, .fadeFromBottom", bL).each(function() {
                                $(this).css("visibility", "hidden")
                            });
                            ce.eq(v).show().css("z-index", "999").removeClass("cameranext").addClass("cameracurrent");
                            ce.eq(s).css("z-index", "1").removeClass("cameracurrent");
                            $(".cameraContent", bL).eq(v).addClass("cameracurrent");
                            if (s >= 0) {
                                $(".cameraContent", bL).eq(s).removeClass("cameracurrent")
                            }
                            Z.onEndTransition.call(this);
                            if ($("> div", elem).eq(v).attr("data-video") != "hide" && $(".cameraContent.cameracurrent .imgFake", bL).length) {
                                $(".cameraContent.cameracurrent .imgFake", bL).click()
                            }
                            var k = ce.eq(v).find(".fadeIn").length;
                            var l = $(".cameraContent", bL).eq(v).find(".moveFromLeft, .moveFromRight, .moveFromTop, .moveFromBottom, .fadeIn, .fadeFromLeft, .fadeFromRight, .fadeFromTop, .fadeFromBottom").length;
                            if (k != 0) {
                                $(".cameraSlide.cameracurrent .fadeIn", bL).each(function() {
                                    if ($(this).attr("data-easing") != "") {
                                        var a = $(this).attr("data-easing")
                                    } else {
                                        var a = easing
                                    }
                                    var t = $(this);
                                    if (typeof t.attr("data-outerWidth") === "undefined" || t.attr("data-outerWidth") === false || t.attr("data-outerWidth") === "") {
                                        var b = t.outerWidth();
                                        t.attr("data-outerWidth", b)
                                    } else {
                                        var b = t.attr("data-outerWidth")
                                    }
                                    if (typeof t.attr("data-outerHeight") === "undefined" || t.attr("data-outerHeight") === false || t.attr("data-outerHeight") === "") {
                                        var c = t.outerHeight();
                                        t.attr("data-outerHeight", c)
                                    } else {
                                        var c = t.attr("data-outerHeight")
                                    }
                                    var d = t.position();
                                    var e = d.left;
                                    var f = d.top;
                                    var g = t.attr("class");
                                    var h = t.index();
                                    var i = t.parents(".camerarelative").outerHeight();
                                    var j = t.parents(".camerarelative").outerWidth();
                                    if (g.indexOf("fadeIn") != -1) {
                                        t.animate({
                                            opacity: 0
                                        }, 0).css("visibility", "visible").delay((time / k) * (0.1 * (h - 1))).animate({
                                            opacity: 1
                                        }, (time / k) * 0.15, a)
                                    } else {
                                        t.css("visibility", "visible")
                                    }
                                })
                            }
                            $(".cameraContent.cameracurrent", bL).show();
                            if (l != 0) {
                                $(".cameraContent.cameracurrent .moveFromLeft, .cameraContent.cameracurrent .moveFromRight, .cameraContent.cameracurrent .moveFromTop, .cameraContent.cameracurrent .moveFromBottom, .cameraContent.cameracurrent .fadeIn, .cameraContent.cameracurrent .fadeFromLeft, .cameraContent.cameracurrent .fadeFromRight, .cameraContent.cameracurrent .fadeFromTop, .cameraContent.cameracurrent .fadeFromBottom", bL).each(function() {
                                    if ($(this).attr("data-easing") != "") {
                                        var a = $(this).attr("data-easing")
                                    } else {
                                        var a = easing
                                    }
                                    var t = $(this);
                                    var b = t.position();
                                    var c = b.left;
                                    var d = b.top;
                                    var e = t.attr("class");
                                    var f = t.index();
                                    var g = t.outerHeight();
                                    if (e.indexOf("moveFromLeft") != -1) {
                                        t.css({
                                            "left": "-" + (w) + "px",
                                            "right": "auto"
                                        });
                                        t.css("visibility", "visible").delay((time / l) * (0.1 * (f - 1))).animate({
                                            "left": b.left
                                        }, (time / l) * 0.15, a)
                                    } else {
                                        if (e.indexOf("moveFromRight") != -1) {
                                            t.css({
                                                "left": w + "px",
                                                "right": "auto"
                                            });
                                            t.css("visibility", "visible").delay((time / l) * (0.1 * (f - 1))).animate({
                                                "left": b.left
                                            }, (time / l) * 0.15, a)
                                        } else {
                                            if (e.indexOf("moveFromTop") != -1) {
                                                t.css({
                                                    "top": "-" + h + "px",
                                                    "bottom": "auto"
                                                });
                                                t.css("visibility", "visible").delay((time / l) * (0.1 * (f - 1))).animate({
                                                    "top": b.top
                                                }, (time / l) * 0.15, a, function() {
                                                    t.css({
                                                        top: "auto",
                                                        bottom: 0
                                                    })
                                                })
                                            } else {
                                                if (e.indexOf("moveFromBottom") != -1) {
                                                    t.css({
                                                        "top": h + "px",
                                                        "bottom": "auto"
                                                    });
                                                    t.css("visibility", "visible").delay((time / l) * (0.1 * (f - 1))).animate({
                                                        "top": b.top
                                                    }, (time / l) * 0.15, a)
                                                } else {
                                                    if (e.indexOf("fadeFromLeft") != -1) {
                                                        t.animate({
                                                            opacity: 0
                                                        }, 0).css({
                                                            "left": "-" + (w) + "px",
                                                            "right": "auto"
                                                        });
                                                        t.css("visibility", "visible").delay((time / l) * (0.1 * (f - 1))).animate({
                                                            "left": b.left,
                                                            opacity: 1
                                                        }, (time / l) * 0.15, a)
                                                    } else {
                                                        if (e.indexOf("fadeFromRight") != -1) {
                                                            t.animate({
                                                                opacity: 0
                                                            }, 0).css({
                                                                "left": (w) + "px",
                                                                "right": "auto"
                                                            });
                                                            t.css("visibility", "visible").delay((time / l) * (0.1 * (f - 1))).animate({
                                                                "left": b.left,
                                                                opacity: 1
                                                            }, (time / l) * 0.15, a)
                                                        } else {
                                                            if (e.indexOf("fadeFromTop") != -1) {
                                                                t.animate({
                                                                    opacity: 0
                                                                }, 0).css({
                                                                    "top": "-" + (h) + "px",
                                                                    "bottom": "auto"
                                                                });
                                                                t.css("visibility", "visible").delay((time / l) * (0.1 * (f - 1))).animate({
                                                                    "top": b.top,
                                                                    opacity: 1
                                                                }, (time / l) * 0.15, a, function() {
                                                                    t.css({
                                                                        top: "auto",
                                                                        bottom: 0
                                                                    })
                                                                })
                                                            } else {
                                                                if (e.indexOf("fadeFromBottom") != -1) {
                                                                    t.animate({
                                                                        opacity: 0
                                                                    }, 0).css({
                                                                        "bottom": "-" + g + "px"
                                                                    });
                                                                    t.css("visibility", "visible").delay((time / l) * (0.1 * (f - 1))).animate({
                                                                        "bottom": "0",
                                                                        opacity: 1
                                                                    }, (time / l) * 0.15, a)
                                                                } else {
                                                                    if (e.indexOf("fadeIn") != -1) {
                                                                        t.animate({
                                                                            opacity: 0
                                                                        }, 0).css("visibility", "visible").delay((time / l) * (0.1 * (f - 1))).animate({
                                                                            opacity: 1
                                                                        }, (time / l) * 0.15, a)
                                                                    } else {
                                                                        t.css("visibility", "visible")
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                })
                            }
                            $(".cameraappended", target).remove();
                            elem.removeClass("camerasliding");
                            ce.eq(s).hide();
                            var m = $(".camera_bar_cont", ch).width(),
                                barHeight = $(".camera_bar_cont", ch).height(),
                                radSum;
                            if (bM != "pie") {
                                radSum = 0.05
                            } else {
                                radSum = 0.005
                            }
                            $("#" + bN).animate({
                                opacity: Z.loaderOpacity
                            }, 200);
                            u = setInterval(function() {
                                if (elem.hasClass("stopped")) {
                                    clearInterval(u)
                                }
                                if (bM != "pie") {
                                    if (cl <= 1.002 && !elem.hasClass("stopped") && !elem.hasClass("paused") && !elem.hasClass("hovered")) {
                                        cl = (cl + radSum)
                                    } else {
                                        if (cl <= 1 && (elem.hasClass("stopped") || elem.hasClass("paused") || elem.hasClass("stopped") || elem.hasClass("hovered"))) {
                                            cl = cl
                                        } else {
                                            if (!elem.hasClass("stopped") && !elem.hasClass("paused") && !elem.hasClass("hovered")) {
                                                clearInterval(u);
                                                imgFake();
                                                $("#" + bN).animate({
                                                    opacity: 0
                                                }, 200, function() {
                                                    clearTimeout(setT);
                                                    setT = setTimeout(canvasLoader, q);
                                                    nextSlide();
                                                    Z.onStartLoading.call(this)
                                                })
                                            }
                                        }
                                    }
                                    switch (cg) {
                                        case "leftToRight":
                                            $("#" + bN).animate({
                                                "right": m - (m * cl)
                                            }, (time * radSum), "linear");
                                            break;
                                        case "rightToLeft":
                                            $("#" + bN).animate({
                                                "left": m - (m * cl)
                                            }, (time * radSum), "linear");
                                            break;
                                        case "topToBottom":
                                            $("#" + bN).animate({
                                                "bottom": barHeight - (barHeight * cl)
                                            }, (time * radSum), "linear");
                                            break;
                                        case "bottomToTop":
                                            $("#" + bN).animate({
                                                "bottom": barHeight - (barHeight * cl)
                                            }, (time * radSum), "linear");
                                            break
                                    }
                                } else {
                                    cm = cl;
                                    cn.clearRect(0, 0, Z.pieDiameter, Z.pieDiameter);
                                    cn.globalCompositeOperation = "destination-over";
                                    cn.beginPath();
                                    cn.arc((Z.pieDiameter) / 2, (Z.pieDiameter) / 2, (Z.pieDiameter) / 2 - Z.loaderStroke, 0, Math.PI * 2, false);
                                    cn.lineWidth = Z.loaderStroke;
                                    cn.strokeStyle = Z.loaderBgColor;
                                    cn.stroke();
                                    cn.closePath();
                                    cn.globalCompositeOperation = "source-over";
                                    cn.beginPath();
                                    cn.arc((Z.pieDiameter) / 2, (Z.pieDiameter) / 2, (Z.pieDiameter) / 2 - Z.loaderStroke, 0, Math.PI * 2 * cm, false);
                                    cn.lineWidth = Z.loaderStroke - (Z.loaderPadding * 2);
                                    cn.strokeStyle = Z.loaderColor;
                                    cn.stroke();
                                    cn.closePath();
                                    if (cl <= 1.002 && !elem.hasClass("stopped") && !elem.hasClass("paused") && !elem.hasClass("hovered")) {
                                        cl = (cl + radSum)
                                    } else {
                                        if (cl <= 1 && (elem.hasClass("stopped") || elem.hasClass("paused") || elem.hasClass("hovered"))) {
                                            cl = cl
                                        } else {
                                            if (!elem.hasClass("stopped") && !elem.hasClass("paused") && !elem.hasClass("hovered")) {
                                                clearInterval(u);
                                                imgFake();
                                                $("#" + bN + ", .camera_canvas_wrap", ch).animate({
                                                    opacity: 0
                                                }, 200, function() {
                                                    clearTimeout(setT);
                                                    setT = setTimeout(canvasLoader, q);
                                                    nextSlide();
                                                    Z.onStartLoading.call(this)
                                                })
                                            }
                                        }
                                    }
                                }
                            }, time * radSum)
                        }
                    }
                    if (fx == "scrollLeft" || fx == "scrollRight" || fx == "scrollTop" || fx == "scrollBottom" || fx == "scrollHorz") {
                        Z.onStartTransition.call(this);
                        q = 0;
                        p.delay((((transPeriod + difference) / N) * V[n] * couples) * 0.5).css({
                            "display": "block",
                            "height": height,
                            "margin-left": marginLeft,
                            "margin-top": marginTop,
                            "width": width
                        }).animate({
                            "height": Math.floor((h / H) + R + 1),
                            "margin-top": 0,
                            "margin-left": 0,
                            "width": Math.floor((w / cols) + Q + 1)
                        }, (transPeriod - difference), easing, cameraeased);
                        ce.eq(s).delay((((transPeriod + difference) / N) * V[n] * couples) * 0.5).animate({
                            "margin-left": marginLeft * (-1),
                            "margin-top": marginTop * (-1)
                        }, (transPeriod - difference), easing, function() {
                            $(this).css({
                                "margin-top": 0,
                                "margin-left": 0
                            })
                        })
                    } else {
                        Z.onStartTransition.call(this);
                        q = parseFloat(transPeriod) + parseFloat(difference);
                        if (J == "next") {
                            p.delay((((transPeriod + difference) / N) * V[n] * couples) * 0.5).css({
                                "display": "block",
                                "height": height,
                                "margin-left": marginLeft,
                                "margin-top": marginTop,
                                "width": width,
                                "opacity": opacityOnGrid
                            }).animate({
                                "height": Math.floor((h / H) + R + 1),
                                "margin-top": 0,
                                "margin-left": 0,
                                "opacity": 1,
                                "width": Math.floor((w / cols) + Q + 1)
                            }, (transPeriod - difference), easing, cameraeased)
                        } else {
                            ce.eq(v).show().css("z-index", "999").addClass("cameracurrent");
                            ce.eq(s).css("z-index", "1").removeClass("cameracurrent");
                            $(".cameraContent", bL).eq(v).addClass("cameracurrent");
                            $(".cameraContent", bL).eq(s).removeClass("cameracurrent");
                            p.delay((((transPeriod + difference) / N) * V[n] * couples) * 0.5).css({
                                "display": "block",
                                "height": Math.floor((h / H) + R + 1),
                                "margin-top": 0,
                                "margin-left": 0,
                                "opacity": 1,
                                "width": Math.floor((w / cols) + Q + 1)
                            }).animate({
                                "height": height,
                                "margin-left": marginLeft,
                                "margin-top": marginTop,
                                "width": width,
                                "opacity": opacityOnGrid
                            }, (transPeriod - difference), easing, cameraeased)
                        }
                    }
                })
            }
        }
        if ($(prevNav).length) {
            $(prevNav).click(function() {
                if (!elem.hasClass("camerasliding")) {
                    var a = parseFloat($(".cameraSlide.cameracurrent", target).index());
                    clearInterval(u);
                    imgFake();
                    $("#" + bN + ", .camera_canvas_wrap", bK).animate({
                        opacity: 0
                    }, 0);
                    canvasLoader();
                    if (a != 0) {
                        nextSlide(a)
                    } else {
                        nextSlide(bU)
                    }
                    Z.onStartLoading.call(this)
                }
            })
        }
        if ($(nextNav).length) {
            $(nextNav).click(function() {
                if (!elem.hasClass("camerasliding")) {
                    var a = parseFloat($(".cameraSlide.cameracurrent", target).index());
                    clearInterval(u);
                    imgFake();
                    $("#" + bN + ", .camera_canvas_wrap", ch).animate({
                        opacity: 0
                    }, 0);
                    canvasLoader();
                    if (a == bU - 1) {
                        nextSlide(1)
                    } else {
                        nextSlide(a + 2)
                    }
                    Z.onStartLoading.call(this)
                }
            })
        }
        if (isMobile()) {
            bL.bind("swipeleft", function(a) {
                if (!elem.hasClass("camerasliding")) {
                    var b = parseFloat($(".cameraSlide.cameracurrent", target).index());
                    clearInterval(u);
                    imgFake();
                    $("#" + bN + ", .camera_canvas_wrap", ch).animate({
                        opacity: 0
                    }, 0);
                    canvasLoader();
                    if (b == bU - 1) {
                        nextSlide(1)
                    } else {
                        nextSlide(b + 2)
                    }
                    Z.onStartLoading.call(this)
                }
            });
            bL.bind("swiperight", function(a) {
                if (!elem.hasClass("camerasliding")) {
                    var b = parseFloat($(".cameraSlide.cameracurrent", target).index());
                    clearInterval(u);
                    imgFake();
                    $("#" + bN + ", .camera_canvas_wrap", ch).animate({
                        opacity: 0
                    }, 0);
                    canvasLoader();
                    if (b != 0) {
                        nextSlide(b)
                    } else {
                        nextSlide(bU)
                    }
                    Z.onStartLoading.call(this)
                }
            })
        }
        if ($(pagination).length) {
            $(".camera_pag li", bK).click(function() {
                if (!elem.hasClass("camerasliding")) {
                    var a = parseFloat($(this).index());
                    var b = parseFloat($(".cameraSlide.cameracurrent", target).index());
                    if (a != b) {
                        clearInterval(u);
                        imgFake();
                        $("#" + bN + ", .camera_canvas_wrap", ch).animate({
                            opacity: 0
                        }, 0);
                        canvasLoader();
                        nextSlide(a + 1);
                        Z.onStartLoading.call(this)
                    }
                }
            })
        }
        if ($(thumbs).length) {
            $(".pix_thumb img", thumbs).click(function() {
                if (!elem.hasClass("camerasliding")) {
                    var a = parseFloat($(this).parents("li").index());
                    var b = parseFloat($(".cameracurrent", target).index());
                    if (a != b) {
                        clearInterval(u);
                        imgFake();
                        $("#" + bN + ", .camera_canvas_wrap", ch).animate({
                            opacity: 0
                        }, 0);
                        $(".pix_thumb", thumbs).removeClass("cameracurrent");
                        $(this).parents("li").addClass("cameracurrent");
                        canvasLoader();
                        nextSlide(a + 1);
                        thumbnailPos();
                        Z.onStartLoading.call(this)
                    }
                }
            });
            $(".camera_thumbs_cont .camera_prevThumbs", ch).hover(function() {
                $(this).stop(true, false).animate({
                    opacity: 1
                }, 250)
            }, function() {
                $(this).stop(true, false).animate({
                    opacity: 0.7
                }, 250)
            });
            $(".camera_prevThumbs", ch).click(function() {
                var b = 0,
                    wTh = $(thumbs).outerWidth(),
                    offUl = $("ul", thumbs).offset().left,
                    offDiv = $("> div", thumbs).offset().left,
                    ulLeft = offDiv - offUl;
                $(".camera_visThumb", thumbs).each(function() {
                    var a = $(this).outerWidth();
                    b = b + a
                });
                if (ulLeft - b > 0) {
                    $("ul", thumbs).animate({
                        "margin-left": "-" + (ulLeft - b) + "px"
                    }, 500, thumbnailVisible)
                } else {
                    $("ul", thumbs).animate({
                        "margin-left": 0
                    }, 500, thumbnailVisible)
                }
            });
            $(".camera_thumbs_cont .camera_nextThumbs", ch).hover(function() {
                $(this).stop(true, false).animate({
                    opacity: 1
                }, 250)
            }, function() {
                $(this).stop(true, false).animate({
                    opacity: 0.7
                }, 250)
            });
            $(".camera_nextThumbs", ch).click(function() {
                var b = 0,
                    wTh = $(thumbs).outerWidth(),
                    ulW = $("ul", thumbs).outerWidth(),
                    offUl = $("ul", thumbs).offset().left,
                    offDiv = $("> div", thumbs).offset().left,
                    ulLeft = offDiv - offUl;
                $(".camera_visThumb", thumbs).each(function() {
                    var a = $(this).outerWidth();
                    b = b + a
                });
                if (ulLeft + b + b < ulW) {
                    $("ul", thumbs).animate({
                        "margin-left": "-" + (ulLeft + b) + "px"
                    }, 500, thumbnailVisible)
                } else {
                    $("ul", thumbs).animate({
                        "margin-left": "-" + (ulW - wTh) + "px"
                    }, 500, thumbnailVisible)
                }
            })
        }
    }
})(jQuery);
(function($) {
    $.fn.cameraStop = function() {
        var a = $(this),
            elem = $(".camera_src", a),
            pieID = "pie_" + a.index();
        elem.addClass("stopped");
        if ($(".camera_showcommands").length) {
            var b = $(".camera_thumbs_wrap", a)
        } else {
            var b = a
        }
    }
})(jQuery);
(function($) {
    $.fn.cameraPause = function() {
        var a = $(this);
        var b = $(".camera_src", a);
        b.addClass("paused")
    }
})(jQuery);
(function($) {
    $.fn.cameraResume = function() {
        var a = $(this);
        var b = $(".camera_src", a);
        if (typeof autoAdv === "undefined" || autoAdv !== true) {
            b.removeClass("paused")
        }
    }
})(jQuery);
jQuery.easing['jswing'] = jQuery.easing['swing'];
jQuery.extend(jQuery.easing, {
    def: 'easeOutQuad',
    swing: function(x, t, b, c, d) {
        return jQuery.easing[jQuery.easing.def](x, t, b, c, d)
    },
    easeInQuad: function(x, t, b, c, d) {
        return c * (t /= d) * t + b
    },
    easeOutQuad: function(x, t, b, c, d) {
        return -c * (t /= d) * (t - 2) + b
    },
    easeInOutQuad: function(x, t, b, c, d) {
        if ((t /= d / 2) < 1) return c / 2 * t * t + b;
        return -c / 2 * ((--t) * (t - 2) - 1) + b
    },
    easeInCubic: function(x, t, b, c, d) {
        return c * (t /= d) * t * t + b
    },
    easeOutCubic: function(x, t, b, c, d) {
        return c * ((t = t / d - 1) * t * t + 1) + b
    },
    easeInOutCubic: function(x, t, b, c, d) {
        if ((t /= d / 2) < 1) return c / 2 * t * t * t + b;
        return c / 2 * ((t -= 2) * t * t + 2) + b
    },
    easeInQuart: function(x, t, b, c, d) {
        return c * (t /= d) * t * t * t + b
    },
    easeOutQuart: function(x, t, b, c, d) {
        return -c * ((t = t / d - 1) * t * t * t - 1) + b
    },
    easeInOutQuart: function(x, t, b, c, d) {
        if ((t /= d / 2) < 1) return c / 2 * t * t * t * t + b;
        return -c / 2 * ((t -= 2) * t * t * t - 2) + b
    },
    easeInQuint: function(x, t, b, c, d) {
        return c * (t /= d) * t * t * t * t + b
    },
    easeOutQuint: function(x, t, b, c, d) {
        return c * ((t = t / d - 1) * t * t * t * t + 1) + b
    },
    easeInOutQuint: function(x, t, b, c, d) {
        if ((t /= d / 2) < 1) return c / 2 * t * t * t * t * t + b;
        return c / 2 * ((t -= 2) * t * t * t * t + 2) + b
    },
    easeInSine: function(x, t, b, c, d) {
        return -c * Math.cos(t / d * (Math.PI / 2)) + c + b
    },
    easeOutSine: function(x, t, b, c, d) {
        return c * Math.sin(t / d * (Math.PI / 2)) + b
    },
    easeInOutSine: function(x, t, b, c, d) {
        return -c / 2 * (Math.cos(Math.PI * t / d) - 1) + b
    },
    easeInExpo: function(x, t, b, c, d) {
        return (t == 0) ? b : c * Math.pow(2, 10 * (t / d - 1)) + b
    },
    easeOutExpo: function(x, t, b, c, d) {
        return (t == d) ? b + c : c * (-Math.pow(2, -10 * t / d) + 1) + b
    },
    easeInOutExpo: function(x, t, b, c, d) {
        if (t == 0) return b;
        if (t == d) return b + c;
        if ((t /= d / 2) < 1) return c / 2 * Math.pow(2, 10 * (t - 1)) + b;
        return c / 2 * (-Math.pow(2, -10 * --t) + 2) + b
    },
    easeInCirc: function(x, t, b, c, d) {
        return -c * (Math.sqrt(1 - (t /= d) * t) - 1) + b
    },
    easeOutCirc: function(x, t, b, c, d) {
        return c * Math.sqrt(1 - (t = t / d - 1) * t) + b
    },
    easeInOutCirc: function(x, t, b, c, d) {
        if ((t /= d / 2) < 1) return -c / 2 * (Math.sqrt(1 - t * t) - 1) + b;
        return c / 2 * (Math.sqrt(1 - (t -= 2) * t) + 1) + b
    },
    easeInElastic: function(x, t, b, c, d) {
        var s = 1.70158;
        var p = 0;
        var a = c;
        if (t == 0) return b;
        if ((t /= d) == 1) return b + c;
        if (!p) p = d * .3;
        if (a < Math.abs(c)) {
            a = c;
            var s = p / 4
        } else var s = p / (2 * Math.PI) * Math.asin(c / a);
        return -(a * Math.pow(2, 10 * (t -= 1)) * Math.sin((t * d - s) * (2 * Math.PI) / p)) + b
    },
    easeOutElastic: function(x, t, b, c, d) {
        var s = 1.70158;
        var p = 0;
        var a = c;
        if (t == 0) return b;
        if ((t /= d) == 1) return b + c;
        if (!p) p = d * .3;
        if (a < Math.abs(c)) {
            a = c;
            var s = p / 4
        } else var s = p / (2 * Math.PI) * Math.asin(c / a);
        return a * Math.pow(2, -10 * t) * Math.sin((t * d - s) * (2 * Math.PI) / p) + c + b
    },
    easeInOutElastic: function(x, t, b, c, d) {
        var s = 1.70158;
        var p = 0;
        var a = c;
        if (t == 0) return b;
        if ((t /= d / 2) == 2) return b + c;
        if (!p) p = d * (.3 * 1.5);
        if (a < Math.abs(c)) {
            a = c;
            var s = p / 4
        } else var s = p / (2 * Math.PI) * Math.asin(c / a);
        if (t < 1) return -.5 * (a * Math.pow(2, 10 * (t -= 1)) * Math.sin((t * d - s) * (2 * Math.PI) / p)) + b;
        return a * Math.pow(2, -10 * (t -= 1)) * Math.sin((t * d - s) * (2 * Math.PI) / p) * .5 + c + b
    },
    easeInBack: function(x, t, b, c, d, s) {
        if (s == undefined) s = 1.70158;
        return c * (t /= d) * t * ((s + 1) * t - s) + b
    },
    easeOutBack: function(x, t, b, c, d, s) {
        if (s == undefined) s = 1.70158;
        return c * ((t = t / d - 1) * t * ((s + 1) * t + s) + 1) + b
    },
    easeInOutBack: function(x, t, b, c, d, s) {
        if (s == undefined) s = 1.70158;
        if ((t /= d / 2) < 1) return c / 2 * (t * t * (((s *= (1.525)) + 1) * t - s)) + b;
        return c / 2 * ((t -= 2) * t * (((s *= (1.525)) + 1) * t + s) + 2) + b
    },
    easeInBounce: function(x, t, b, c, d) {
        return c - jQuery.easing.easeOutBounce(x, d - t, 0, c, d) + b
    },
    easeOutBounce: function(x, t, b, c, d) {
        if ((t /= d) < (1 / 2.75)) {
            return c * (7.5625 * t * t) + b
        } else if (t < (2 / 2.75)) {
            return c * (7.5625 * (t -= (1.5 / 2.75)) * t + .75) + b
        } else if (t < (2.5 / 2.75)) {
            return c * (7.5625 * (t -= (2.25 / 2.75)) * t + .9375) + b
        } else {
            return c * (7.5625 * (t -= (2.625 / 2.75)) * t + .984375) + b
        }
    },
    easeInOutBounce: function(x, t, b, c, d) {
        if (t < d / 2) return jQuery.easing.easeInBounce(x, t * 2, 0, c, d) * .5 + b;
        return jQuery.easing.easeOutBounce(x, t * 2 - d, 0, c, d) * .5 + c * .5 + b
    }
});